<a id="mypy-boto3-es"></a>

# mypy-boto3-es

[![PyPI - mypy-boto3-es](https://img.shields.io/pypi/v/mypy-boto3-es.svg?color=blue)](https://pypi.org/project/mypy-boto3-es)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-es.svg?color=blue)](https://pypi.org/project/mypy-boto3-es)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)
[![PyPI - Downloads](https://img.shields.io/pypi/dw/mypy-boto3-es?color=blue)](https://pypistats.org/packages/mypy-boto3-es)

![boto3.typed](https://github.com/vemel/mypy_boto3_builder/raw/master/logo.png)

Type annotations for
[boto3.ElasticsearchService 1.18.24](https://boto3.amazonaws.com/v1/documentation/api/1.18.24/reference/services/es.html#ElasticsearchService)
service compatible with [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[Emacs](https://www.gnu.org/software/emacs/),
[Sublime Text](https://www.sublimetext.com/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright) and other tools.

Generated by
[mypy-boto3-builder 5.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on
[boto3-stubs](https://pypi.org/project/boto3-stubs/) page and in
[mypy-boto3-es docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_es/)

See how it helps to find and fix potential bugs:

![boto3-stubs demo](https://github.com/vemel/mypy_boto3_builder/raw/master/demo.gif)

- [mypy-boto3-es](#mypy-boto3-es)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Literals](#literals)
    - [Typed dictionaries](#typed-dictionaries)
  - [Versioning](#versioning)
  - [Documentation](#documentation)
  - [Support and contributing](#support-and-contributing)

<a id="how-to-install"></a>

## How to install

Install `boto3-stubs` for `ElasticsearchService` service.

```bash
python -m pip install boto3-stubs[es]
```

<a id="usage"></a>

## Usage

<a id="vscode"></a>

### VSCode

- Install
  [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install
  [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`

Both type checking and auto-complete should work for `ElasticsearchService`
service. No explicit type annotations required, write your `boto3` code as
usual.

<a id="pycharm"></a>

### PyCharm

- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`

Both type checking and auto-complete should work for `ElasticsearchService`
service. No explicit type annotations required, write your `boto3` code as
usual. Auto-complete can be slow on big projects or if you have a lot of
installed `boto3-stubs` submodules.

<a id="other-ides"></a>

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything
should work.

<a id="mypy"></a>

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`
- Run `mypy` as usual

Type checking should work for `ElasticsearchService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="pyright"></a>

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[es]` in your environment:
  `python -m pip install 'boto3-stubs[es]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `ElasticsearchService` service. No explicit type
annotations required, write your `boto3` code as usual.

<a id="explicit-type-annotations"></a>

## Explicit type annotations

<a id="client-annotations"></a>

### Client annotations

`ElasticsearchServiceClient` provides annotations for `boto3.client("es")`.

```python
import boto3

from mypy_boto3_es import ElasticsearchServiceClient

client: ElasticsearchServiceClient = boto3.client("es")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ElasticsearchServiceClient = session.client("es")
```

<a id="paginators-annotations"></a>

### Paginators annotations

`mypy_boto3_es.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_es import ElasticsearchServiceClient
from mypy_boto3_es.paginator import (
    DescribeReservedElasticsearchInstanceOfferingsPaginator,
    DescribeReservedElasticsearchInstancesPaginator,
    GetUpgradeHistoryPaginator,
    ListElasticsearchInstanceTypesPaginator,
    ListElasticsearchVersionsPaginator,
)

client: ElasticsearchServiceClient = boto3.client("es")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
describe_reserved_elasticsearch_instance_offerings_paginator: DescribeReservedElasticsearchInstanceOfferingsPaginator = client.get_paginator("describe_reserved_elasticsearch_instance_offerings")
describe_reserved_elasticsearch_instances_paginator: DescribeReservedElasticsearchInstancesPaginator = client.get_paginator("describe_reserved_elasticsearch_instances")
get_upgrade_history_paginator: GetUpgradeHistoryPaginator = client.get_paginator("get_upgrade_history")
list_elasticsearch_instance_types_paginator: ListElasticsearchInstanceTypesPaginator = client.get_paginator("list_elasticsearch_instance_types")
list_elasticsearch_versions_paginator: ListElasticsearchVersionsPaginator = client.get_paginator("list_elasticsearch_versions")
```

<a id="literals"></a>

### Literals

`mypy_boto3_es.literals` module contains literals extracted from shapes that
can be used in user code for type checking.

```python
from mypy_boto3_es.literals import (
    AutoTuneDesiredStateType,
    AutoTuneStateType,
    AutoTuneTypeType,
    DeploymentStatusType,
    DescribePackagesFilterNameType,
    DescribeReservedElasticsearchInstanceOfferingsPaginatorName,
    DescribeReservedElasticsearchInstancesPaginatorName,
    DomainPackageStatusType,
    ESPartitionInstanceTypeType,
    ESWarmPartitionInstanceTypeType,
    GetUpgradeHistoryPaginatorName,
    InboundCrossClusterSearchConnectionStatusCodeType,
    ListElasticsearchInstanceTypesPaginatorName,
    ListElasticsearchVersionsPaginatorName,
    LogTypeType,
    OptionStateType,
    OutboundCrossClusterSearchConnectionStatusCodeType,
    PackageStatusType,
    PackageTypeType,
    ReservedElasticsearchInstancePaymentOptionType,
    RollbackOnDisableType,
    ScheduledAutoTuneActionTypeType,
    ScheduledAutoTuneSeverityTypeType,
    TLSSecurityPolicyType,
    TimeUnitType,
    UpgradeStatusType,
    UpgradeStepType,
    VolumeTypeType,
)

def check_value(value: AutoTuneDesiredStateType) -> bool:
    ...
```

<a id="typed-dictionaries"></a>

### Typed dictionaries

`mypy_boto3_es.type_defs` module contains structures and shapes assembled to
typed dictionaries for additional type checking.

```python
from mypy_boto3_es.type_defs import (
    AcceptInboundCrossClusterSearchConnectionRequestRequestTypeDef,
    AcceptInboundCrossClusterSearchConnectionResponseTypeDef,
    AccessPoliciesStatusTypeDef,
    AddTagsRequestRequestTypeDef,
    AdditionalLimitTypeDef,
    AdvancedOptionsStatusTypeDef,
    AdvancedSecurityOptionsInputTypeDef,
    AdvancedSecurityOptionsStatusTypeDef,
    AdvancedSecurityOptionsTypeDef,
    AssociatePackageRequestRequestTypeDef,
    AssociatePackageResponseTypeDef,
    AutoTuneDetailsTypeDef,
    AutoTuneMaintenanceScheduleTypeDef,
    AutoTuneOptionsInputTypeDef,
    AutoTuneOptionsOutputTypeDef,
    AutoTuneOptionsStatusTypeDef,
    AutoTuneOptionsTypeDef,
    AutoTuneStatusTypeDef,
    AutoTuneTypeDef,
    CancelElasticsearchServiceSoftwareUpdateRequestRequestTypeDef,
    CancelElasticsearchServiceSoftwareUpdateResponseTypeDef,
    CognitoOptionsStatusTypeDef,
    CognitoOptionsTypeDef,
    ColdStorageOptionsTypeDef,
    CompatibleVersionsMapTypeDef,
    CreateElasticsearchDomainRequestRequestTypeDef,
    CreateElasticsearchDomainResponseTypeDef,
    CreateOutboundCrossClusterSearchConnectionRequestRequestTypeDef,
    CreateOutboundCrossClusterSearchConnectionResponseTypeDef,
    CreatePackageRequestRequestTypeDef,
    CreatePackageResponseTypeDef,
    DeleteElasticsearchDomainRequestRequestTypeDef,
    DeleteElasticsearchDomainResponseTypeDef,
    DeleteInboundCrossClusterSearchConnectionRequestRequestTypeDef,
    DeleteInboundCrossClusterSearchConnectionResponseTypeDef,
    DeleteOutboundCrossClusterSearchConnectionRequestRequestTypeDef,
    DeleteOutboundCrossClusterSearchConnectionResponseTypeDef,
    DeletePackageRequestRequestTypeDef,
    DeletePackageResponseTypeDef,
    DescribeDomainAutoTunesRequestRequestTypeDef,
    DescribeDomainAutoTunesResponseTypeDef,
    DescribeElasticsearchDomainConfigRequestRequestTypeDef,
    DescribeElasticsearchDomainConfigResponseTypeDef,
    DescribeElasticsearchDomainRequestRequestTypeDef,
    DescribeElasticsearchDomainResponseTypeDef,
    DescribeElasticsearchDomainsRequestRequestTypeDef,
    DescribeElasticsearchDomainsResponseTypeDef,
    DescribeElasticsearchInstanceTypeLimitsRequestRequestTypeDef,
    DescribeElasticsearchInstanceTypeLimitsResponseTypeDef,
    DescribeInboundCrossClusterSearchConnectionsRequestRequestTypeDef,
    DescribeInboundCrossClusterSearchConnectionsResponseTypeDef,
    DescribeOutboundCrossClusterSearchConnectionsRequestRequestTypeDef,
    DescribeOutboundCrossClusterSearchConnectionsResponseTypeDef,
    DescribePackagesFilterTypeDef,
    DescribePackagesRequestRequestTypeDef,
    DescribePackagesResponseTypeDef,
    DescribeReservedElasticsearchInstanceOfferingsRequestRequestTypeDef,
    DescribeReservedElasticsearchInstanceOfferingsResponseTypeDef,
    DescribeReservedElasticsearchInstancesRequestRequestTypeDef,
    DescribeReservedElasticsearchInstancesResponseTypeDef,
    DissociatePackageRequestRequestTypeDef,
    DissociatePackageResponseTypeDef,
    DomainEndpointOptionsStatusTypeDef,
    DomainEndpointOptionsTypeDef,
    DomainInfoTypeDef,
    DomainInformationTypeDef,
    DomainPackageDetailsTypeDef,
    DurationTypeDef,
    EBSOptionsStatusTypeDef,
    EBSOptionsTypeDef,
    ElasticsearchClusterConfigStatusTypeDef,
    ElasticsearchClusterConfigTypeDef,
    ElasticsearchDomainConfigTypeDef,
    ElasticsearchDomainStatusTypeDef,
    ElasticsearchVersionStatusTypeDef,
    EncryptionAtRestOptionsStatusTypeDef,
    EncryptionAtRestOptionsTypeDef,
    ErrorDetailsTypeDef,
    FilterTypeDef,
    GetCompatibleElasticsearchVersionsRequestRequestTypeDef,
    GetCompatibleElasticsearchVersionsResponseTypeDef,
    GetPackageVersionHistoryRequestRequestTypeDef,
    GetPackageVersionHistoryResponseTypeDef,
    GetUpgradeHistoryRequestRequestTypeDef,
    GetUpgradeHistoryResponseTypeDef,
    GetUpgradeStatusRequestRequestTypeDef,
    GetUpgradeStatusResponseTypeDef,
    InboundCrossClusterSearchConnectionStatusTypeDef,
    InboundCrossClusterSearchConnectionTypeDef,
    InstanceCountLimitsTypeDef,
    InstanceLimitsTypeDef,
    LimitsTypeDef,
    ListDomainNamesResponseTypeDef,
    ListDomainsForPackageRequestRequestTypeDef,
    ListDomainsForPackageResponseTypeDef,
    ListElasticsearchInstanceTypesRequestRequestTypeDef,
    ListElasticsearchInstanceTypesResponseTypeDef,
    ListElasticsearchVersionsRequestRequestTypeDef,
    ListElasticsearchVersionsResponseTypeDef,
    ListPackagesForDomainRequestRequestTypeDef,
    ListPackagesForDomainResponseTypeDef,
    ListTagsRequestRequestTypeDef,
    ListTagsResponseTypeDef,
    LogPublishingOptionTypeDef,
    LogPublishingOptionsStatusTypeDef,
    MasterUserOptionsTypeDef,
    NodeToNodeEncryptionOptionsStatusTypeDef,
    NodeToNodeEncryptionOptionsTypeDef,
    OptionStatusTypeDef,
    OutboundCrossClusterSearchConnectionStatusTypeDef,
    OutboundCrossClusterSearchConnectionTypeDef,
    PackageDetailsTypeDef,
    PackageSourceTypeDef,
    PackageVersionHistoryTypeDef,
    PaginatorConfigTypeDef,
    PurchaseReservedElasticsearchInstanceOfferingRequestRequestTypeDef,
    PurchaseReservedElasticsearchInstanceOfferingResponseTypeDef,
    RecurringChargeTypeDef,
    RejectInboundCrossClusterSearchConnectionRequestRequestTypeDef,
    RejectInboundCrossClusterSearchConnectionResponseTypeDef,
    RemoveTagsRequestRequestTypeDef,
    ReservedElasticsearchInstanceOfferingTypeDef,
    ReservedElasticsearchInstanceTypeDef,
    ResponseMetadataTypeDef,
    SAMLIdpTypeDef,
    SAMLOptionsInputTypeDef,
    SAMLOptionsOutputTypeDef,
    ScheduledAutoTuneDetailsTypeDef,
    ServiceSoftwareOptionsTypeDef,
    SnapshotOptionsStatusTypeDef,
    SnapshotOptionsTypeDef,
    StartElasticsearchServiceSoftwareUpdateRequestRequestTypeDef,
    StartElasticsearchServiceSoftwareUpdateResponseTypeDef,
    StorageTypeLimitTypeDef,
    StorageTypeTypeDef,
    TagTypeDef,
    UpdateElasticsearchDomainConfigRequestRequestTypeDef,
    UpdateElasticsearchDomainConfigResponseTypeDef,
    UpdatePackageRequestRequestTypeDef,
    UpdatePackageResponseTypeDef,
    UpgradeElasticsearchDomainRequestRequestTypeDef,
    UpgradeElasticsearchDomainResponseTypeDef,
    UpgradeHistoryTypeDef,
    UpgradeStepItemTypeDef,
    VPCDerivedInfoStatusTypeDef,
    VPCDerivedInfoTypeDef,
    VPCOptionsTypeDef,
    ZoneAwarenessConfigTypeDef,
)

def get_structure() -> AcceptInboundCrossClusterSearchConnectionRequestRequestTypeDef:
    return {
      ...
    }
```

<a id="versioning"></a>

## Versioning

`mypy-boto3-es` version is the same as related `boto3` version and follows
[PEP 440](https://www.python.org/dev/peps/pep-0440/) format.

<a id="documentation"></a>

## Documentation

All type annotations can be found in
[mypy-boto3-es docs](https://vemel.github.io/boto3_stubs_docs/mypy_boto3_es/)

<a id="support-and-contributing"></a>

## Support and contributing

This package is auto-generated. Please reports any bugs or request new features
in [mypy-boto3-builder](https://github.com/vemel/mypy_boto3_builder/issues/)
repository.
