# pylint:disable=line-too-long
import logging

from ...sim_type import SimTypeFunction,     SimTypeShort, SimTypeInt, SimTypeLong, SimTypeLongLong, SimTypeDouble, SimTypeFloat,     SimTypePointer,     SimTypeChar,     SimStruct,     SimTypeFixedSizeArray,     SimTypeBottom,     SimUnion,     SimTypeBool
from ...calling_conventions import SimCCStdcall, SimCCMicrosoftAMD64
from .. import SIM_PROCEDURES as P
from . import SimLibrary


_l = logging.getLogger(name=__name__)


lib = SimLibrary()
lib.set_default_cc('X86', SimCCStdcall)
lib.set_default_cc('AMD64', SimCCMicrosoftAMD64)
lib.set_library_names("tdh.dll")
prototypes = \
    {
        # 
        'TdhCreatePayloadFilter': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0), SimTypeChar(label="Byte"), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"FieldName": SimTypePointer(SimTypeChar(label="Char"), offset=0), "CompareOp": SimTypeShort(signed=False, label="UInt16"), "Value": SimTypePointer(SimTypeChar(label="Char"), offset=0)}, name="PAYLOAD_FILTER_PREDICATE", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderGuid", "EventDescriptor", "EventMatchANY", "PayloadPredicateCount", "PayloadPredicates", "PayloadFilter"]),
        # 
        'TdhDeletePayloadFilter': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PayloadFilter"]),
        # 
        'TdhAggregatePayloadFilters': SimTypeFunction([SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypePointer(SimTypeBottom(label="Void"), offset=0), label="LPArray", offset=0), SimTypePointer(SimTypeChar(label="Byte"), label="LPArray", offset=0), SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_FILTER_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["PayloadFilterCount", "PayloadFilterPtrs", "EventMatchALLFlags", "EventFilterDescriptor"]),
        # 
        'TdhCleanupPayloadEventFilterDescriptor': SimTypeFunction([SimTypePointer(SimStruct({"Ptr": SimTypeLongLong(signed=False, label="UInt64"), "Size": SimTypeInt(signed=False, label="UInt32"), "Type": SimTypeInt(signed=False, label="UInt32")}, name="EVENT_FILTER_DESCRIPTOR", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["EventFilterDescriptor"]),
        # 
        'TdhGetEventInformation': SimTypeFunction([SimTypePointer(SimStruct({"EventHeader": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "HeaderType": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EventProperty": SimTypeShort(signed=False, label="UInt16"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "ProviderId": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "Anonymous": SimUnion({"Anonymous": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ActivityId": SimTypeBottom(label="Guid")}, name="EVENT_HEADER", pack=False, align=None), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None), "ExtendedDataCount": SimTypeShort(signed=False, label="UInt16"), "UserDataLength": SimTypeShort(signed=False, label="UInt16"), "ExtendedData": SimTypePointer(SimStruct({"Reserved1": SimTypeShort(signed=False, label="UInt16"), "ExtType": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"_bitfield": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None), "DataSize": SimTypeShort(signed=False, label="UInt16"), "DataPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_HEADER_EXTENDED_DATA_ITEM", pack=False, align=None), offset=0), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ParameterValue": SimTypeLongLong(signed=False, label="UInt64"), "ParameterType": SimTypeInt(signed=False, label="TDH_CONTEXT_TYPE"), "ParameterSize": SimTypeInt(signed=False, label="UInt32")}, name="TDH_CONTEXT", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimStruct({"ProviderGuid": SimTypeBottom(label="Guid"), "EventGuid": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "DecodingSource": SimTypeInt(signed=False, label="DECODING_SOURCE"), "ProviderNameOffset": SimTypeInt(signed=False, label="UInt32"), "LevelNameOffset": SimTypeInt(signed=False, label="UInt32"), "ChannelNameOffset": SimTypeInt(signed=False, label="UInt32"), "KeywordsNameOffset": SimTypeInt(signed=False, label="UInt32"), "TaskNameOffset": SimTypeInt(signed=False, label="UInt32"), "OpcodeNameOffset": SimTypeInt(signed=False, label="UInt32"), "EventMessageOffset": SimTypeInt(signed=False, label="UInt32"), "ProviderMessageOffset": SimTypeInt(signed=False, label="UInt32"), "BinaryXMLOffset": SimTypeInt(signed=False, label="UInt32"), "BinaryXMLSize": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"EventNameOffset": SimTypeInt(signed=False, label="UInt32"), "ActivityIDNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"EventAttributesOffset": SimTypeInt(signed=False, label="UInt32"), "RelatedActivityIDNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "PropertyCount": SimTypeInt(signed=False, label="UInt32"), "TopLevelPropertyCount": SimTypeInt(signed=False, label="UInt32"), "Anonymous3": SimUnion({"Flags": SimTypeInt(signed=False, label="TEMPLATE_FLAGS"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "EventPropertyInfoArray": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="PROPERTY_FLAGS"), "NameOffset": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"nonStructType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "MapNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="_nonStructType", pack=False, align=None), "structType": SimStruct({"StructStartIndex": SimTypeShort(signed=False, label="UInt16"), "NumOfStructMembers": SimTypeShort(signed=False, label="UInt16"), "padding": SimTypeInt(signed=False, label="UInt32")}, name="_structType", pack=False, align=None), "customSchemaType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "CustomSchemaOffset": SimTypeInt(signed=False, label="UInt32")}, name="_customSchemaType", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"count": SimTypeShort(signed=False, label="UInt16"), "countPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous3": SimUnion({"length": SimTypeShort(signed=False, label="UInt16"), "lengthPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_PROPERTY_INFO", pack=False, align=None), offset=0)}, name="TRACE_EVENT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Event", "TdhContextCount", "TdhContext", "Buffer", "BufferSize"]),
        # 
        'TdhGetEventMapInformation': SimTypeFunction([SimTypePointer(SimStruct({"EventHeader": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "HeaderType": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EventProperty": SimTypeShort(signed=False, label="UInt16"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "ProviderId": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "Anonymous": SimUnion({"Anonymous": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ActivityId": SimTypeBottom(label="Guid")}, name="EVENT_HEADER", pack=False, align=None), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None), "ExtendedDataCount": SimTypeShort(signed=False, label="UInt16"), "UserDataLength": SimTypeShort(signed=False, label="UInt16"), "ExtendedData": SimTypePointer(SimStruct({"Reserved1": SimTypeShort(signed=False, label="UInt16"), "ExtType": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"_bitfield": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None), "DataSize": SimTypeShort(signed=False, label="UInt16"), "DataPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_HEADER_EXTENDED_DATA_ITEM", pack=False, align=None), offset=0), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_RECORD", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimStruct({"NameOffset": SimTypeInt(signed=False, label="UInt32"), "Flag": SimTypeInt(signed=False, label="MAP_FLAGS"), "EntryCount": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"MapEntryValueType": SimTypeInt(signed=False, label="MAP_VALUETYPE"), "FormatStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "MapEntryArray": SimTypePointer(SimStruct({"OutputOffset": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Value": SimTypeInt(signed=False, label="UInt32"), "InputOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="EVENT_MAP_ENTRY", pack=False, align=None), offset=0)}, name="EVENT_MAP_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pEvent", "pMapName", "pBuffer", "pBufferSize"]),
        # 
        'TdhGetPropertySize': SimTypeFunction([SimTypePointer(SimStruct({"EventHeader": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "HeaderType": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EventProperty": SimTypeShort(signed=False, label="UInt16"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "ProviderId": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "Anonymous": SimUnion({"Anonymous": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ActivityId": SimTypeBottom(label="Guid")}, name="EVENT_HEADER", pack=False, align=None), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None), "ExtendedDataCount": SimTypeShort(signed=False, label="UInt16"), "UserDataLength": SimTypeShort(signed=False, label="UInt16"), "ExtendedData": SimTypePointer(SimStruct({"Reserved1": SimTypeShort(signed=False, label="UInt16"), "ExtType": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"_bitfield": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None), "DataSize": SimTypeShort(signed=False, label="UInt16"), "DataPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_HEADER_EXTENDED_DATA_ITEM", pack=False, align=None), offset=0), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ParameterValue": SimTypeLongLong(signed=False, label="UInt64"), "ParameterType": SimTypeInt(signed=False, label="TDH_CONTEXT_TYPE"), "ParameterSize": SimTypeInt(signed=False, label="UInt32")}, name="TDH_CONTEXT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PropertyName": SimTypeLongLong(signed=False, label="UInt64"), "ArrayIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="PROPERTY_DATA_DESCRIPTOR", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pEvent", "TdhContextCount", "pTdhContext", "PropertyDataCount", "pPropertyData", "pPropertySize"]),
        # 
        'TdhGetProperty': SimTypeFunction([SimTypePointer(SimStruct({"EventHeader": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "HeaderType": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EventProperty": SimTypeShort(signed=False, label="UInt16"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "ProviderId": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "Anonymous": SimUnion({"Anonymous": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ActivityId": SimTypeBottom(label="Guid")}, name="EVENT_HEADER", pack=False, align=None), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None), "ExtendedDataCount": SimTypeShort(signed=False, label="UInt16"), "UserDataLength": SimTypeShort(signed=False, label="UInt16"), "ExtendedData": SimTypePointer(SimStruct({"Reserved1": SimTypeShort(signed=False, label="UInt16"), "ExtType": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"_bitfield": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None), "DataSize": SimTypeShort(signed=False, label="UInt16"), "DataPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_HEADER_EXTENDED_DATA_ITEM", pack=False, align=None), offset=0), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_RECORD", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ParameterValue": SimTypeLongLong(signed=False, label="UInt64"), "ParameterType": SimTypeInt(signed=False, label="TDH_CONTEXT_TYPE"), "ParameterSize": SimTypeInt(signed=False, label="UInt32")}, name="TDH_CONTEXT", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"PropertyName": SimTypeLongLong(signed=False, label="UInt64"), "ArrayIndex": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32")}, name="PROPERTY_DATA_DESCRIPTOR", pack=False, align=None), label="LPArray", offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pEvent", "TdhContextCount", "pTdhContext", "PropertyDataCount", "pPropertyData", "BufferSize", "pBuffer"]),
        # 
        'TdhEnumerateProviders': SimTypeFunction([SimTypePointer(SimStruct({"NumberOfProviders": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "TraceProviderInfoArray": SimTypePointer(SimStruct({"ProviderGuid": SimTypeBottom(label="Guid"), "SchemaSource": SimTypeInt(signed=False, label="UInt32"), "ProviderNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="TRACE_PROVIDER_INFO", pack=False, align=None), offset=0)}, name="PROVIDER_ENUMERATION_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pBuffer", "pBufferSize"]),
        # 
        'TdhQueryProviderFieldInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeLongLong(signed=False, label="UInt64"), SimTypeInt(signed=False, label="EVENT_FIELD_TYPE"), SimTypePointer(SimStruct({"NumberOfElements": SimTypeInt(signed=False, label="UInt32"), "FieldType": SimTypeInt(signed=False, label="EVENT_FIELD_TYPE"), "FieldInfoArray": SimTypePointer(SimStruct({"NameOffset": SimTypeInt(signed=False, label="UInt32"), "DescriptionOffset": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypeLongLong(signed=False, label="UInt64")}, name="PROVIDER_FIELD_INFO", pack=False, align=None), offset=0)}, name="PROVIDER_FIELD_INFOARRAY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pGuid", "EventFieldValue", "EventFieldType", "pBuffer", "pBufferSize"]),
        # 
        'TdhEnumerateProviderFieldInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="EVENT_FIELD_TYPE"), SimTypePointer(SimStruct({"NumberOfElements": SimTypeInt(signed=False, label="UInt32"), "FieldType": SimTypeInt(signed=False, label="EVENT_FIELD_TYPE"), "FieldInfoArray": SimTypePointer(SimStruct({"NameOffset": SimTypeInt(signed=False, label="UInt32"), "DescriptionOffset": SimTypeInt(signed=False, label="UInt32"), "Value": SimTypeLongLong(signed=False, label="UInt64")}, name="PROVIDER_FIELD_INFO", pack=False, align=None), offset=0)}, name="PROVIDER_FIELD_INFOARRAY", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["pGuid", "EventFieldType", "pBuffer", "pBufferSize"]),
        # 
        'TdhEnumerateProviderFilters': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypePointer(SimStruct({"ParameterValue": SimTypeLongLong(signed=False, label="UInt64"), "ParameterType": SimTypeInt(signed=False, label="TDH_CONTEXT_TYPE"), "ParameterSize": SimTypeInt(signed=False, label="UInt32")}, name="TDH_CONTEXT", pack=False, align=None), label="LPArray", offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypePointer(SimStruct({"Id": SimTypeChar(label="Byte"), "Version": SimTypeChar(label="Byte"), "MessageOffset": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "PropertyCount": SimTypeInt(signed=False, label="UInt32"), "EventPropertyInfoArray": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="PROPERTY_FLAGS"), "NameOffset": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"nonStructType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "MapNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="_nonStructType", pack=False, align=None), "structType": SimStruct({"StructStartIndex": SimTypeShort(signed=False, label="UInt16"), "NumOfStructMembers": SimTypeShort(signed=False, label="UInt16"), "padding": SimTypeInt(signed=False, label="UInt32")}, name="_structType", pack=False, align=None), "customSchemaType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "CustomSchemaOffset": SimTypeInt(signed=False, label="UInt32")}, name="_customSchemaType", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"count": SimTypeShort(signed=False, label="UInt16"), "countPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous3": SimUnion({"length": SimTypeShort(signed=False, label="UInt16"), "lengthPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_PROPERTY_INFO", pack=False, align=None), offset=0)}, name="PROVIDER_FILTER_INFO", pack=False, align=None), offset=0), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Guid", "TdhContextCount", "TdhContext", "FilterCount", "Buffer", "BufferSize"]),
        # 
        'TdhLoadManifest': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Manifest"]),
        # 
        'TdhLoadManifestFromMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pData", "cbData"]),
        # 
        'TdhUnloadManifest': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Manifest"]),
        # 
        'TdhUnloadManifestFromMemory': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Void"), offset=0), SimTypeInt(signed=False, label="UInt32")], SimTypeInt(signed=False, label="UInt32"), arg_names=["pData", "cbData"]),
        # 
        'TdhFormatProperty': SimTypeFunction([SimTypePointer(SimStruct({"ProviderGuid": SimTypeBottom(label="Guid"), "EventGuid": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "DecodingSource": SimTypeInt(signed=False, label="DECODING_SOURCE"), "ProviderNameOffset": SimTypeInt(signed=False, label="UInt32"), "LevelNameOffset": SimTypeInt(signed=False, label="UInt32"), "ChannelNameOffset": SimTypeInt(signed=False, label="UInt32"), "KeywordsNameOffset": SimTypeInt(signed=False, label="UInt32"), "TaskNameOffset": SimTypeInt(signed=False, label="UInt32"), "OpcodeNameOffset": SimTypeInt(signed=False, label="UInt32"), "EventMessageOffset": SimTypeInt(signed=False, label="UInt32"), "ProviderMessageOffset": SimTypeInt(signed=False, label="UInt32"), "BinaryXMLOffset": SimTypeInt(signed=False, label="UInt32"), "BinaryXMLSize": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"EventNameOffset": SimTypeInt(signed=False, label="UInt32"), "ActivityIDNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"EventAttributesOffset": SimTypeInt(signed=False, label="UInt32"), "RelatedActivityIDNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "PropertyCount": SimTypeInt(signed=False, label="UInt32"), "TopLevelPropertyCount": SimTypeInt(signed=False, label="UInt32"), "Anonymous3": SimUnion({"Flags": SimTypeInt(signed=False, label="TEMPLATE_FLAGS"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "EventPropertyInfoArray": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="PROPERTY_FLAGS"), "NameOffset": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"nonStructType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "MapNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="_nonStructType", pack=False, align=None), "structType": SimStruct({"StructStartIndex": SimTypeShort(signed=False, label="UInt16"), "NumOfStructMembers": SimTypeShort(signed=False, label="UInt16"), "padding": SimTypeInt(signed=False, label="UInt32")}, name="_structType", pack=False, align=None), "customSchemaType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "CustomSchemaOffset": SimTypeInt(signed=False, label="UInt32")}, name="_customSchemaType", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"count": SimTypeShort(signed=False, label="UInt16"), "countPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous3": SimUnion({"length": SimTypeShort(signed=False, label="UInt16"), "lengthPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_PROPERTY_INFO", pack=False, align=None), offset=0)}, name="TRACE_EVENT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"NameOffset": SimTypeInt(signed=False, label="UInt32"), "Flag": SimTypeInt(signed=False, label="MAP_FLAGS"), "EntryCount": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"MapEntryValueType": SimTypeInt(signed=False, label="MAP_VALUETYPE"), "FormatStringOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "MapEntryArray": SimTypePointer(SimStruct({"OutputOffset": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimUnion({"Value": SimTypeInt(signed=False, label="UInt32"), "InputOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None")}, name="EVENT_MAP_ENTRY", pack=False, align=None), offset=0)}, name="EVENT_MAP_INFO", pack=False, align=None), offset=0), SimTypeInt(signed=False, label="UInt32"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypeShort(signed=False, label="UInt16"), SimTypePointer(SimTypeChar(label="Byte"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeShort(signed=False, label="UInt16"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["EventInfo", "MapInfo", "PointerSize", "PropertyInType", "PropertyOutType", "PropertyLength", "UserDataLength", "UserData", "BufferSize", "Buffer", "UserDataConsumed"]),
        # 
        'TdhOpenDecodingHandle': SimTypeFunction([SimTypePointer(SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle"]),
        # 
        'TdhSetDecodingParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ParameterValue": SimTypeLongLong(signed=False, label="UInt64"), "ParameterType": SimTypeInt(signed=False, label="TDH_CONTEXT_TYPE"), "ParameterSize": SimTypeInt(signed=False, label="UInt32")}, name="TDH_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "TdhContext"]),
        # 
        'TdhGetDecodingParameter': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"ParameterValue": SimTypeLongLong(signed=False, label="UInt64"), "ParameterType": SimTypeInt(signed=False, label="TDH_CONTEXT_TYPE"), "ParameterSize": SimTypeInt(signed=False, label="UInt32")}, name="TDH_CONTEXT", pack=False, align=None), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "TdhContext"]),
        # 
        'TdhGetWppProperty': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"EventHeader": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "HeaderType": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EventProperty": SimTypeShort(signed=False, label="UInt16"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "ProviderId": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "Anonymous": SimUnion({"Anonymous": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ActivityId": SimTypeBottom(label="Guid")}, name="EVENT_HEADER", pack=False, align=None), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None), "ExtendedDataCount": SimTypeShort(signed=False, label="UInt16"), "UserDataLength": SimTypeShort(signed=False, label="UInt16"), "ExtendedData": SimTypePointer(SimStruct({"Reserved1": SimTypeShort(signed=False, label="UInt16"), "ExtType": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"_bitfield": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None), "DataSize": SimTypeShort(signed=False, label="UInt16"), "DataPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_HEADER_EXTENDED_DATA_ITEM", pack=False, align=None), offset=0), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_RECORD", pack=False, align=None), offset=0), SimTypePointer(SimTypeChar(label="Char"), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "EventRecord", "PropertyName", "BufferSize", "Buffer"]),
        # 
        'TdhGetWppMessage': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0), SimTypePointer(SimStruct({"EventHeader": SimStruct({"Size": SimTypeShort(signed=False, label="UInt16"), "HeaderType": SimTypeShort(signed=False, label="UInt16"), "Flags": SimTypeShort(signed=False, label="UInt16"), "EventProperty": SimTypeShort(signed=False, label="UInt16"), "ThreadId": SimTypeInt(signed=False, label="UInt32"), "ProcessId": SimTypeInt(signed=False, label="UInt32"), "TimeStamp": SimTypeBottom(label="LARGE_INTEGER"), "ProviderId": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "Anonymous": SimUnion({"Anonymous": SimStruct({"KernelTime": SimTypeInt(signed=False, label="UInt32"), "UserTime": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorTime": SimTypeLongLong(signed=False, label="UInt64")}, name="<anon>", label="None"), "ActivityId": SimTypeBottom(label="Guid")}, name="EVENT_HEADER", pack=False, align=None), "BufferContext": SimStruct({"Anonymous": SimUnion({"Anonymous": SimStruct({"ProcessorNumber": SimTypeChar(label="Byte"), "Alignment": SimTypeChar(label="Byte")}, name="_Anonymous_e__Struct", pack=False, align=None), "ProcessorIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "LoggerId": SimTypeShort(signed=False, label="UInt16")}, name="ETW_BUFFER_CONTEXT", pack=False, align=None), "ExtendedDataCount": SimTypeShort(signed=False, label="UInt16"), "UserDataLength": SimTypeShort(signed=False, label="UInt16"), "ExtendedData": SimTypePointer(SimStruct({"Reserved1": SimTypeShort(signed=False, label="UInt16"), "ExtType": SimTypeShort(signed=False, label="UInt16"), "Anonymous": SimStruct({"_bitfield": SimTypeShort(signed=False, label="UInt16")}, name="_Anonymous_e__Struct", pack=False, align=None), "DataSize": SimTypeShort(signed=False, label="UInt16"), "DataPtr": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_HEADER_EXTENDED_DATA_ITEM", pack=False, align=None), offset=0), "UserData": SimTypePointer(SimTypeBottom(label="Void"), offset=0), "UserContext": SimTypePointer(SimTypeBottom(label="Void"), offset=0)}, name="EVENT_RECORD", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0), SimTypePointer(SimTypeChar(label="Byte"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle", "EventRecord", "BufferSize", "Buffer"]),
        # 
        'TdhCloseDecodingHandle': SimTypeFunction([SimTypePointer(SimTypeInt(signed=True, label="Int"), label="IntPtr", offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["Handle"]),
        # 
        'TdhLoadManifestFromBinary': SimTypeFunction([SimTypePointer(SimTypeChar(label="Char"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["BinaryPath"]),
        # 
        'TdhEnumerateManifestProviderEvents': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"NumberOfEvents": SimTypeInt(signed=False, label="UInt32"), "Reserved": SimTypeInt(signed=False, label="UInt32"), "EventDescriptorsArray": SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0)}, name="PROVIDER_EVENT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderGuid", "Buffer", "BufferSize"]),
        # 
        'TdhGetManifestEventInformation': SimTypeFunction([SimTypePointer(SimTypeBottom(label="Guid"), offset=0), SimTypePointer(SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), offset=0), SimTypePointer(SimStruct({"ProviderGuid": SimTypeBottom(label="Guid"), "EventGuid": SimTypeBottom(label="Guid"), "EventDescriptor": SimStruct({"Id": SimTypeShort(signed=False, label="UInt16"), "Version": SimTypeChar(label="Byte"), "Channel": SimTypeChar(label="Byte"), "Level": SimTypeChar(label="Byte"), "Opcode": SimTypeChar(label="Byte"), "Task": SimTypeShort(signed=False, label="UInt16"), "Keyword": SimTypeLongLong(signed=False, label="UInt64")}, name="EVENT_DESCRIPTOR", pack=False, align=None), "DecodingSource": SimTypeInt(signed=False, label="DECODING_SOURCE"), "ProviderNameOffset": SimTypeInt(signed=False, label="UInt32"), "LevelNameOffset": SimTypeInt(signed=False, label="UInt32"), "ChannelNameOffset": SimTypeInt(signed=False, label="UInt32"), "KeywordsNameOffset": SimTypeInt(signed=False, label="UInt32"), "TaskNameOffset": SimTypeInt(signed=False, label="UInt32"), "OpcodeNameOffset": SimTypeInt(signed=False, label="UInt32"), "EventMessageOffset": SimTypeInt(signed=False, label="UInt32"), "ProviderMessageOffset": SimTypeInt(signed=False, label="UInt32"), "BinaryXMLOffset": SimTypeInt(signed=False, label="UInt32"), "BinaryXMLSize": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"EventNameOffset": SimTypeInt(signed=False, label="UInt32"), "ActivityIDNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "Anonymous2": SimUnion({"EventAttributesOffset": SimTypeInt(signed=False, label="UInt32"), "RelatedActivityIDNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="<anon>", label="None"), "PropertyCount": SimTypeInt(signed=False, label="UInt32"), "TopLevelPropertyCount": SimTypeInt(signed=False, label="UInt32"), "Anonymous3": SimUnion({"Flags": SimTypeInt(signed=False, label="TEMPLATE_FLAGS"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None"), "EventPropertyInfoArray": SimTypePointer(SimStruct({"Flags": SimTypeInt(signed=False, label="PROPERTY_FLAGS"), "NameOffset": SimTypeInt(signed=False, label="UInt32"), "Anonymous1": SimUnion({"nonStructType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "MapNameOffset": SimTypeInt(signed=False, label="UInt32")}, name="_nonStructType", pack=False, align=None), "structType": SimStruct({"StructStartIndex": SimTypeShort(signed=False, label="UInt16"), "NumOfStructMembers": SimTypeShort(signed=False, label="UInt16"), "padding": SimTypeInt(signed=False, label="UInt32")}, name="_structType", pack=False, align=None), "customSchemaType": SimStruct({"InType": SimTypeShort(signed=False, label="UInt16"), "OutType": SimTypeShort(signed=False, label="UInt16"), "CustomSchemaOffset": SimTypeInt(signed=False, label="UInt32")}, name="_customSchemaType", pack=False, align=None)}, name="<anon>", label="None"), "Anonymous2": SimUnion({"count": SimTypeShort(signed=False, label="UInt16"), "countPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous3": SimUnion({"length": SimTypeShort(signed=False, label="UInt16"), "lengthPropertyIndex": SimTypeShort(signed=False, label="UInt16")}, name="<anon>", label="None"), "Anonymous4": SimUnion({"Reserved": SimTypeInt(signed=False, label="UInt32"), "Anonymous": SimStruct({"_bitfield": SimTypeInt(signed=False, label="UInt32")}, name="_Anonymous_e__Struct", pack=False, align=None)}, name="<anon>", label="None")}, name="EVENT_PROPERTY_INFO", pack=False, align=None), offset=0)}, name="TRACE_EVENT_INFO", pack=False, align=None), offset=0), SimTypePointer(SimTypeInt(signed=False, label="UInt32"), offset=0)], SimTypeInt(signed=False, label="UInt32"), arg_names=["ProviderGuid", "EventDescriptor", "Buffer", "BufferSize"]),
    }

lib.set_prototypes(prototypes)
