# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.descriptor import EnumDescriptor
from google.protobuf.internal.containers import RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "Unit",
    "PackageRef",
    "DottedName",
    "ModuleRef",
    "TypeConName",
    "TypeSynName",
    "ValName",
    "FieldWithType",
    "VarWithType",
    "TypeVarWithKind",
    "FieldWithExpr",
    "Binding",
    "Kind",
    "Type",
    "PrimLit",
    "Location",
    "Expr",
    "CaseAlt",
    "Case",
    "Block",
    "Pure",
    "Update",
    "Scenario",
    "TemplateChoice",
    "KeyExpr",
    "DefTemplate",
    "DefException",
    "DefDataType",
    "DefTypeSyn",
    "DefValue",
    "FeatureFlags",
    "Module",
    "InternedDottedName",
    "PackageMetadata",
    "Package",
]

class PrimType:
    DESCRIPTOR: _typing.ClassVar[EnumDescriptor] = ...
    UNIT: _typing.ClassVar[_L[0]] = ...
    BOOL: _typing.ClassVar[_L[1]] = ...
    INT64: _typing.ClassVar[_L[2]] = ...
    DECIMAL: _typing.ClassVar[_L[3]] = ...
    TEXT: _typing.ClassVar[_L[5]] = ...
    TIMESTAMP: _typing.ClassVar[_L[6]] = ...
    PARTY: _typing.ClassVar[_L[8]] = ...
    LIST: _typing.ClassVar[_L[9]] = ...
    UPDATE: _typing.ClassVar[_L[10]] = ...
    SCENARIO: _typing.ClassVar[_L[11]] = ...
    DATE: _typing.ClassVar[_L[12]] = ...
    CONTRACT_ID: _typing.ClassVar[_L[13]] = ...
    OPTIONAL: _typing.ClassVar[_L[14]] = ...
    ARROW: _typing.ClassVar[_L[15]] = ...
    TEXTMAP: _typing.ClassVar[_L[16]] = ...
    NUMERIC: _typing.ClassVar[_L[17]] = ...
    ANY: _typing.ClassVar[_L[18]] = ...
    TYPE_REP: _typing.ClassVar[_L[19]] = ...
    GENMAP: _typing.ClassVar[_L[20]] = ...
    BIGNUMERIC: _typing.ClassVar[_L[21]] = ...
    ROUNDING_MODE: _typing.ClassVar[_L[22]] = ...
    ANY_EXCEPTION: _typing.ClassVar[_L[23]] = ...
UNIT = _L[0]
BOOL = _L[1]
INT64 = _L[2]
DECIMAL = _L[3]
TEXT = _L[5]
TIMESTAMP = _L[6]
PARTY = _L[8]
LIST = _L[9]
UPDATE = _L[10]
SCENARIO = _L[11]
DATE = _L[12]
CONTRACT_ID = _L[13]
OPTIONAL = _L[14]
ARROW = _L[15]
TEXTMAP = _L[16]
NUMERIC = _L[17]
ANY = _L[18]
TYPE_REP = _L[19]
GENMAP = _L[20]
BIGNUMERIC = _L[21]
ROUNDING_MODE = _L[22]
ANY_EXCEPTION = _L[23]

class PrimCon:
    DESCRIPTOR: _typing.ClassVar[EnumDescriptor] = ...
    CON_UNIT: _typing.ClassVar[_L[0]] = ...
    CON_FALSE: _typing.ClassVar[_L[1]] = ...
    CON_TRUE: _typing.ClassVar[_L[2]] = ...
CON_UNIT = _L[0]
CON_FALSE = _L[1]
CON_TRUE = _L[2]

class BuiltinFunction:
    DESCRIPTOR: _typing.ClassVar[EnumDescriptor] = ...
    ADD_DECIMAL: _typing.ClassVar[_L[0]] = ...
    SUB_DECIMAL: _typing.ClassVar[_L[1]] = ...
    MUL_DECIMAL: _typing.ClassVar[_L[2]] = ...
    DIV_DECIMAL: _typing.ClassVar[_L[3]] = ...
    ROUND_DECIMAL: _typing.ClassVar[_L[6]] = ...
    ADD_NUMERIC: _typing.ClassVar[_L[107]] = ...
    SUB_NUMERIC: _typing.ClassVar[_L[108]] = ...
    MUL_NUMERIC: _typing.ClassVar[_L[109]] = ...
    DIV_NUMERIC: _typing.ClassVar[_L[110]] = ...
    ROUND_NUMERIC: _typing.ClassVar[_L[111]] = ...
    CAST_NUMERIC: _typing.ClassVar[_L[121]] = ...
    SHIFT_NUMERIC: _typing.ClassVar[_L[122]] = ...
    ADD_INT64: _typing.ClassVar[_L[7]] = ...
    SUB_INT64: _typing.ClassVar[_L[8]] = ...
    MUL_INT64: _typing.ClassVar[_L[9]] = ...
    DIV_INT64: _typing.ClassVar[_L[10]] = ...
    MOD_INT64: _typing.ClassVar[_L[11]] = ...
    EXP_INT64: _typing.ClassVar[_L[12]] = ...
    FOLDL: _typing.ClassVar[_L[20]] = ...
    FOLDR: _typing.ClassVar[_L[21]] = ...
    TEXTMAP_EMPTY: _typing.ClassVar[_L[96]] = ...
    TEXTMAP_INSERT: _typing.ClassVar[_L[97]] = ...
    TEXTMAP_LOOKUP: _typing.ClassVar[_L[98]] = ...
    TEXTMAP_DELETE: _typing.ClassVar[_L[99]] = ...
    TEXTMAP_TO_LIST: _typing.ClassVar[_L[100]] = ...
    TEXTMAP_SIZE: _typing.ClassVar[_L[101]] = ...
    GENMAP_EMPTY: _typing.ClassVar[_L[124]] = ...
    GENMAP_INSERT: _typing.ClassVar[_L[125]] = ...
    GENMAP_LOOKUP: _typing.ClassVar[_L[126]] = ...
    GENMAP_DELETE: _typing.ClassVar[_L[127]] = ...
    GENMAP_KEYS: _typing.ClassVar[_L[128]] = ...
    GENMAP_VALUES: _typing.ClassVar[_L[129]] = ...
    GENMAP_SIZE: _typing.ClassVar[_L[130]] = ...
    EXPLODE_TEXT: _typing.ClassVar[_L[23]] = ...
    APPEND_TEXT: _typing.ClassVar[_L[24]] = ...
    ERROR: _typing.ClassVar[_L[25]] = ...
    ANY_EXCEPTION_MESSAGE: _typing.ClassVar[_L[147]] = ...
    LEQ_INT64: _typing.ClassVar[_L[33]] = ...
    LEQ_DECIMAL: _typing.ClassVar[_L[34]] = ...
    LEQ_NUMERIC: _typing.ClassVar[_L[112]] = ...
    LEQ_TEXT: _typing.ClassVar[_L[36]] = ...
    LEQ_TIMESTAMP: _typing.ClassVar[_L[37]] = ...
    LEQ_DATE: _typing.ClassVar[_L[67]] = ...
    LEQ_PARTY: _typing.ClassVar[_L[89]] = ...
    LESS_INT64: _typing.ClassVar[_L[39]] = ...
    LESS_DECIMAL: _typing.ClassVar[_L[40]] = ...
    LESS_NUMERIC: _typing.ClassVar[_L[113]] = ...
    LESS_TEXT: _typing.ClassVar[_L[42]] = ...
    LESS_TIMESTAMP: _typing.ClassVar[_L[43]] = ...
    LESS_DATE: _typing.ClassVar[_L[68]] = ...
    LESS_PARTY: _typing.ClassVar[_L[90]] = ...
    GEQ_INT64: _typing.ClassVar[_L[45]] = ...
    GEQ_DECIMAL: _typing.ClassVar[_L[46]] = ...
    GEQ_NUMERIC: _typing.ClassVar[_L[114]] = ...
    GEQ_TEXT: _typing.ClassVar[_L[48]] = ...
    GEQ_TIMESTAMP: _typing.ClassVar[_L[49]] = ...
    GEQ_DATE: _typing.ClassVar[_L[69]] = ...
    GEQ_PARTY: _typing.ClassVar[_L[91]] = ...
    GREATER_INT64: _typing.ClassVar[_L[51]] = ...
    GREATER_DECIMAL: _typing.ClassVar[_L[52]] = ...
    GREATER_NUMERIC: _typing.ClassVar[_L[115]] = ...
    GREATER_TEXT: _typing.ClassVar[_L[54]] = ...
    GREATER_TIMESTAMP: _typing.ClassVar[_L[55]] = ...
    GREATER_DATE: _typing.ClassVar[_L[70]] = ...
    GREATER_PARTY: _typing.ClassVar[_L[92]] = ...
    INT64_TO_TEXT: _typing.ClassVar[_L[57]] = ...
    DECIMAL_TO_TEXT: _typing.ClassVar[_L[58]] = ...
    NUMERIC_TO_TEXT: _typing.ClassVar[_L[116]] = ...
    TEXT_TO_TEXT: _typing.ClassVar[_L[60]] = ...
    TIMESTAMP_TO_TEXT: _typing.ClassVar[_L[61]] = ...
    DATE_TO_TEXT: _typing.ClassVar[_L[71]] = ...
    PARTY_TO_QUOTED_TEXT: _typing.ClassVar[_L[63]] = ...
    PARTY_TO_TEXT: _typing.ClassVar[_L[94]] = ...
    TEXT_TO_PARTY: _typing.ClassVar[_L[95]] = ...
    TEXT_TO_INT64: _typing.ClassVar[_L[103]] = ...
    TEXT_TO_DECIMAL: _typing.ClassVar[_L[104]] = ...
    TEXT_TO_NUMERIC: _typing.ClassVar[_L[117]] = ...
    CONTRACT_ID_TO_TEXT: _typing.ClassVar[_L[136]] = ...
    SHA256_TEXT: _typing.ClassVar[_L[93]] = ...
    DATE_TO_UNIX_DAYS: _typing.ClassVar[_L[72]] = ...
    UNIX_DAYS_TO_DATE: _typing.ClassVar[_L[73]] = ...
    TIMESTAMP_TO_UNIX_MICROSECONDS: _typing.ClassVar[_L[74]] = ...
    UNIX_MICROSECONDS_TO_TIMESTAMP: _typing.ClassVar[_L[75]] = ...
    INT64_TO_DECIMAL: _typing.ClassVar[_L[76]] = ...
    DECIMAL_TO_INT64: _typing.ClassVar[_L[77]] = ...
    INT64_TO_NUMERIC: _typing.ClassVar[_L[118]] = ...
    NUMERIC_TO_INT64: _typing.ClassVar[_L[119]] = ...
    IMPLODE_TEXT: _typing.ClassVar[_L[78]] = ...
    EQUAL_INT64: _typing.ClassVar[_L[79]] = ...
    EQUAL_DECIMAL: _typing.ClassVar[_L[80]] = ...
    EQUAL_NUMERIC: _typing.ClassVar[_L[120]] = ...
    EQUAL_TEXT: _typing.ClassVar[_L[81]] = ...
    EQUAL_TIMESTAMP: _typing.ClassVar[_L[82]] = ...
    EQUAL_DATE: _typing.ClassVar[_L[83]] = ...
    EQUAL_PARTY: _typing.ClassVar[_L[84]] = ...
    EQUAL_BOOL: _typing.ClassVar[_L[85]] = ...
    EQUAL_CONTRACT_ID: _typing.ClassVar[_L[86]] = ...
    EQUAL_LIST: _typing.ClassVar[_L[87]] = ...
    EQUAL_TYPE_REP: _typing.ClassVar[_L[123]] = ...
    EQUAL: _typing.ClassVar[_L[131]] = ...
    LESS_EQ: _typing.ClassVar[_L[132]] = ...
    LESS: _typing.ClassVar[_L[133]] = ...
    GREATER_EQ: _typing.ClassVar[_L[134]] = ...
    GREATER: _typing.ClassVar[_L[135]] = ...
    TRACE: _typing.ClassVar[_L[88]] = ...
    COERCE_CONTRACT_ID: _typing.ClassVar[_L[102]] = ...
    CODE_POINTS_TO_TEXT: _typing.ClassVar[_L[105]] = ...
    TEXT_POINTS_TO_CODE: _typing.ClassVar[_L[106]] = ...
    SCALE_BIGNUMERIC: _typing.ClassVar[_L[137]] = ...
    PRECISION_BIGNUMERIC: _typing.ClassVar[_L[138]] = ...
    ADD_BIGNUMERIC: _typing.ClassVar[_L[139]] = ...
    SUB_BIGNUMERIC: _typing.ClassVar[_L[140]] = ...
    MUL_BIGNUMERIC: _typing.ClassVar[_L[141]] = ...
    DIV_BIGNUMERIC: _typing.ClassVar[_L[142]] = ...
    SHIFT_RIGHT_BIGNUMERIC: _typing.ClassVar[_L[143]] = ...
    BIGNUMERIC_TO_NUMERIC: _typing.ClassVar[_L[144]] = ...
    NUMERIC_TO_BIGNUMERIC: _typing.ClassVar[_L[145]] = ...
    BIGNUMERIC_TO_TEXT: _typing.ClassVar[_L[146]] = ...
ADD_DECIMAL = _L[0]
SUB_DECIMAL = _L[1]
MUL_DECIMAL = _L[2]
DIV_DECIMAL = _L[3]
ROUND_DECIMAL = _L[6]
ADD_NUMERIC = _L[107]
SUB_NUMERIC = _L[108]
MUL_NUMERIC = _L[109]
DIV_NUMERIC = _L[110]
ROUND_NUMERIC = _L[111]
CAST_NUMERIC = _L[121]
SHIFT_NUMERIC = _L[122]
ADD_INT64 = _L[7]
SUB_INT64 = _L[8]
MUL_INT64 = _L[9]
DIV_INT64 = _L[10]
MOD_INT64 = _L[11]
EXP_INT64 = _L[12]
FOLDL = _L[20]
FOLDR = _L[21]
TEXTMAP_EMPTY = _L[96]
TEXTMAP_INSERT = _L[97]
TEXTMAP_LOOKUP = _L[98]
TEXTMAP_DELETE = _L[99]
TEXTMAP_TO_LIST = _L[100]
TEXTMAP_SIZE = _L[101]
GENMAP_EMPTY = _L[124]
GENMAP_INSERT = _L[125]
GENMAP_LOOKUP = _L[126]
GENMAP_DELETE = _L[127]
GENMAP_KEYS = _L[128]
GENMAP_VALUES = _L[129]
GENMAP_SIZE = _L[130]
EXPLODE_TEXT = _L[23]
APPEND_TEXT = _L[24]
ERROR = _L[25]
ANY_EXCEPTION_MESSAGE = _L[147]
LEQ_INT64 = _L[33]
LEQ_DECIMAL = _L[34]
LEQ_NUMERIC = _L[112]
LEQ_TEXT = _L[36]
LEQ_TIMESTAMP = _L[37]
LEQ_DATE = _L[67]
LEQ_PARTY = _L[89]
LESS_INT64 = _L[39]
LESS_DECIMAL = _L[40]
LESS_NUMERIC = _L[113]
LESS_TEXT = _L[42]
LESS_TIMESTAMP = _L[43]
LESS_DATE = _L[68]
LESS_PARTY = _L[90]
GEQ_INT64 = _L[45]
GEQ_DECIMAL = _L[46]
GEQ_NUMERIC = _L[114]
GEQ_TEXT = _L[48]
GEQ_TIMESTAMP = _L[49]
GEQ_DATE = _L[69]
GEQ_PARTY = _L[91]
GREATER_INT64 = _L[51]
GREATER_DECIMAL = _L[52]
GREATER_NUMERIC = _L[115]
GREATER_TEXT = _L[54]
GREATER_TIMESTAMP = _L[55]
GREATER_DATE = _L[70]
GREATER_PARTY = _L[92]
INT64_TO_TEXT = _L[57]
DECIMAL_TO_TEXT = _L[58]
NUMERIC_TO_TEXT = _L[116]
TEXT_TO_TEXT = _L[60]
TIMESTAMP_TO_TEXT = _L[61]
DATE_TO_TEXT = _L[71]
PARTY_TO_QUOTED_TEXT = _L[63]
PARTY_TO_TEXT = _L[94]
TEXT_TO_PARTY = _L[95]
TEXT_TO_INT64 = _L[103]
TEXT_TO_DECIMAL = _L[104]
TEXT_TO_NUMERIC = _L[117]
CONTRACT_ID_TO_TEXT = _L[136]
SHA256_TEXT = _L[93]
DATE_TO_UNIX_DAYS = _L[72]
UNIX_DAYS_TO_DATE = _L[73]
TIMESTAMP_TO_UNIX_MICROSECONDS = _L[74]
UNIX_MICROSECONDS_TO_TIMESTAMP = _L[75]
INT64_TO_DECIMAL = _L[76]
DECIMAL_TO_INT64 = _L[77]
INT64_TO_NUMERIC = _L[118]
NUMERIC_TO_INT64 = _L[119]
IMPLODE_TEXT = _L[78]
EQUAL_INT64 = _L[79]
EQUAL_DECIMAL = _L[80]
EQUAL_NUMERIC = _L[120]
EQUAL_TEXT = _L[81]
EQUAL_TIMESTAMP = _L[82]
EQUAL_DATE = _L[83]
EQUAL_PARTY = _L[84]
EQUAL_BOOL = _L[85]
EQUAL_CONTRACT_ID = _L[86]
EQUAL_LIST = _L[87]
EQUAL_TYPE_REP = _L[123]
EQUAL = _L[131]
LESS_EQ = _L[132]
LESS = _L[133]
GREATER_EQ = _L[134]
GREATER = _L[135]
TRACE = _L[88]
COERCE_CONTRACT_ID = _L[102]
CODE_POINTS_TO_TEXT = _L[105]
TEXT_POINTS_TO_CODE = _L[106]
SCALE_BIGNUMERIC = _L[137]
PRECISION_BIGNUMERIC = _L[138]
ADD_BIGNUMERIC = _L[139]
SUB_BIGNUMERIC = _L[140]
MUL_BIGNUMERIC = _L[141]
DIV_BIGNUMERIC = _L[142]
SHIFT_RIGHT_BIGNUMERIC = _L[143]
BIGNUMERIC_TO_NUMERIC = _L[144]
NUMERIC_TO_BIGNUMERIC = _L[145]
BIGNUMERIC_TO_TEXT = _L[146]


class Unit(_Message):
    def __init__(self): ...
    def HasField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def ClearField(self, field_name: _typing.NoReturn) -> _typing.NoReturn: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class PackageRef(_Message):
    @property
    def self(self) -> Unit: ...
    package_id_str: _builtins.str
    package_id_interned_str: _builtins.int
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self_, *, self: Unit = ...): ...
    @_typing.overload
    def __init__(self, *, package_id_str: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, package_id_interned_str: _builtins.int = ...): ...
    def HasField(self, field_name: _L["Sum", "self", "package_id_str", "package_id_interned_str"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "self", "package_id_str", "package_id_interned_str"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "self", "package_id_str", "package_id_interned_str"]: ...

class DottedName(_Message):
    @property
    def segments(self) -> RepeatedScalarFieldContainer[_builtins.str]: ...
    def __init__(self, *, segments: _typing.Optional[_typing.Iterable[_builtins.str]] = ...): ...
    def HasField(self, field_name: _L["segments"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["segments"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class ModuleRef(_Message):
    @property
    def package_ref(self) -> PackageRef: ...
    @property
    def module_name_dname(self) -> DottedName: ...
    module_name_interned_dname: _builtins.int
    @_typing.overload
    def __init__(self, *, package_ref: _typing.Optional[PackageRef] = ...): ...
    @_typing.overload
    def __init__(self, *, package_ref: _typing.Optional[PackageRef] = ..., module_name_dname: DottedName = ...): ...
    @_typing.overload
    def __init__(self, *, package_ref: _typing.Optional[PackageRef] = ..., module_name_interned_dname: _builtins.int = ...): ...
    def HasField(self, field_name: _L["package_ref", "module_name", "module_name_dname", "module_name_interned_dname"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["package_ref", "module_name", "module_name_dname", "module_name_interned_dname"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["module_name"]) -> _L[None, "module_name_dname", "module_name_interned_dname"]: ...

class TypeConName(_Message):
    @property
    def module(self) -> ModuleRef: ...
    @property
    def name_dname(self) -> DottedName: ...
    name_interned_dname: _builtins.int
    @_typing.overload
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ...): ...
    @_typing.overload
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ..., name_dname: DottedName = ...): ...
    @_typing.overload
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ..., name_interned_dname: _builtins.int = ...): ...
    def HasField(self, field_name: _L["module", "name", "name_dname", "name_interned_dname"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["module", "name", "name_dname", "name_interned_dname"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["name"]) -> _L[None, "name_dname", "name_interned_dname"]: ...

class TypeSynName(_Message):
    @property
    def module(self) -> ModuleRef: ...
    @property
    def name_dname(self) -> DottedName: ...
    name_interned_dname: _builtins.int
    @_typing.overload
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ...): ...
    @_typing.overload
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ..., name_dname: DottedName = ...): ...
    @_typing.overload
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ..., name_interned_dname: _builtins.int = ...): ...
    def HasField(self, field_name: _L["module", "name", "name_dname", "name_interned_dname"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["module", "name", "name_dname", "name_interned_dname"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["name"]) -> _L[None, "name_dname", "name_interned_dname"]: ...

class ValName(_Message):
    @property
    def module(self) -> ModuleRef: ...
    @property
    def name_dname(self) -> RepeatedScalarFieldContainer[_builtins.str]: ...
    name_interned_dname: _builtins.int
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ..., name_dname: _typing.Optional[_typing.Iterable[_builtins.str]] = ..., name_interned_dname: _typing.Optional[_builtins.int] = ...): ...
    def HasField(self, field_name: _L["module", "name_dname", "name_interned_dname"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["module", "name_dname", "name_interned_dname"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class FieldWithType(_Message):
    field_str: _builtins.str
    field_interned_str: _builtins.int
    @property
    def type(self) -> Type: ...
    @_typing.overload
    def __init__(self, *, type: _typing.Optional[Type] = ...): ...
    @_typing.overload
    def __init__(self, *, field_str: _builtins.str = ..., type: _typing.Optional[Type] = ...): ...
    @_typing.overload
    def __init__(self, *, field_interned_str: _builtins.int = ..., type: _typing.Optional[Type] = ...): ...
    def HasField(self, field_name: _L["field", "field_str", "field_interned_str", "type"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["field", "field_str", "field_interned_str", "type"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...

class VarWithType(_Message):
    var_str: _builtins.str
    var_interned_str: _builtins.int
    @property
    def type(self) -> Type: ...
    @_typing.overload
    def __init__(self, *, type: _typing.Optional[Type] = ...): ...
    @_typing.overload
    def __init__(self, *, var_str: _builtins.str = ..., type: _typing.Optional[Type] = ...): ...
    @_typing.overload
    def __init__(self, *, var_interned_str: _builtins.int = ..., type: _typing.Optional[Type] = ...): ...
    def HasField(self, field_name: _L["var", "var_str", "var_interned_str", "type"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["var", "var_str", "var_interned_str", "type"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["var"]) -> _L[None, "var_str", "var_interned_str"]: ...

class TypeVarWithKind(_Message):
    var_str: _builtins.str
    var_interned_str: _builtins.int
    @property
    def kind(self) -> Kind: ...
    @_typing.overload
    def __init__(self, *, kind: _typing.Optional[Kind] = ...): ...
    @_typing.overload
    def __init__(self, *, var_str: _builtins.str = ..., kind: _typing.Optional[Kind] = ...): ...
    @_typing.overload
    def __init__(self, *, var_interned_str: _builtins.int = ..., kind: _typing.Optional[Kind] = ...): ...
    def HasField(self, field_name: _L["var", "var_str", "var_interned_str", "kind"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["var", "var_str", "var_interned_str", "kind"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["var"]) -> _L[None, "var_str", "var_interned_str"]: ...

class FieldWithExpr(_Message):
    field_str: _builtins.str
    field_interned_str: _builtins.int
    @property
    def expr(self) -> Expr: ...
    @_typing.overload
    def __init__(self, *, expr: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, field_str: _builtins.str = ..., expr: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, field_interned_str: _builtins.int = ..., expr: _typing.Optional[Expr] = ...): ...
    def HasField(self, field_name: _L["field", "field_str", "field_interned_str", "expr"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["field", "field_str", "field_interned_str", "expr"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...

class Binding(_Message):
    @property
    def binder(self) -> VarWithType: ...
    @property
    def bound(self) -> Expr: ...
    def __init__(self, *, binder: _typing.Optional[VarWithType] = ..., bound: _typing.Optional[Expr] = ...): ...
    def HasField(self, field_name: _L["binder", "bound"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["binder", "bound"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Kind(_Message):
    
    class Arrow(_Message):
        @property
        def params(self) -> RepeatedCompositeFieldContainer[Kind]: ...
        @property
        def result(self) -> Kind: ...
        def __init__(self, *, params: _typing.Optional[_typing.Iterable[Kind]] = ..., result: _typing.Optional[Kind] = ...): ...
        def HasField(self, field_name: _L["params", "result"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["params", "result"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def star(self) -> Unit: ...
    @property
    def arrow(self) -> Kind.Arrow: ...
    @property
    def nat(self) -> Unit: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, star: Unit = ...): ...
    @_typing.overload
    def __init__(self, *, arrow: Kind.Arrow = ...): ...
    @_typing.overload
    def __init__(self, *, nat: Unit = ...): ...
    def HasField(self, field_name: _L["Sum", "star", "arrow", "nat"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "star", "arrow", "nat"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "star", "arrow", "nat"]: ...

class Type(_Message):
    
    class Var(_Message):
        var_str: _builtins.str
        var_interned_str: _builtins.int
        @property
        def args(self) -> RepeatedCompositeFieldContainer[Type]: ...
        @_typing.overload
        def __init__(self, *, args: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        @_typing.overload
        def __init__(self, *, var_str: _builtins.str = ..., args: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        @_typing.overload
        def __init__(self, *, var_interned_str: _builtins.int = ..., args: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        def HasField(self, field_name: _L["var", "var_str", "var_interned_str", "args"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["var", "var_str", "var_interned_str", "args"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["var"]) -> _L[None, "var_str", "var_interned_str"]: ...
    
    class Con(_Message):
        @property
        def tycon(self) -> TypeConName: ...
        @property
        def args(self) -> RepeatedCompositeFieldContainer[Type]: ...
        def __init__(self, *, tycon: _typing.Optional[TypeConName] = ..., args: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        def HasField(self, field_name: _L["tycon", "args"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "args"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Syn(_Message):
        @property
        def tysyn(self) -> TypeSynName: ...
        @property
        def args(self) -> RepeatedCompositeFieldContainer[Type]: ...
        def __init__(self, *, tysyn: _typing.Optional[TypeSynName] = ..., args: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        def HasField(self, field_name: _L["tysyn", "args"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tysyn", "args"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Prim(_Message):
        @property
        def prim(self) -> _L[0, 1, 2, 3, 5, 6, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23]: ...
        @property
        def args(self) -> RepeatedCompositeFieldContainer[Type]: ...
        def __init__(self, *, prim: _typing.Optional[_L['UNIT', 0, 'BOOL', 1, 'INT64', 2, 'DECIMAL', 3, 'TEXT', 5, 'TIMESTAMP', 6, 'PARTY', 8, 'LIST', 9, 'UPDATE', 10, 'SCENARIO', 11, 'DATE', 12, 'CONTRACT_ID', 13, 'OPTIONAL', 14, 'ARROW', 15, 'TEXTMAP', 16, 'NUMERIC', 17, 'ANY', 18, 'TYPE_REP', 19, 'GENMAP', 20, 'BIGNUMERIC', 21, 'ROUNDING_MODE', 22, 'ANY_EXCEPTION', 23]] = ..., args: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        def HasField(self, field_name: _L["prim", "args"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["prim", "args"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Fun(_Message):
        @property
        def params(self) -> RepeatedCompositeFieldContainer[Type]: ...
        @property
        def result(self) -> Type: ...
        def __init__(self, *, params: _typing.Optional[_typing.Iterable[Type]] = ..., result: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["params", "result"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["params", "result"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Forall(_Message):
        @property
        def vars(self) -> RepeatedCompositeFieldContainer[TypeVarWithKind]: ...
        @property
        def body(self) -> Type: ...
        def __init__(self, *, vars: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., body: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["vars", "body"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["vars", "body"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Struct(_Message):
        @property
        def fields(self) -> RepeatedCompositeFieldContainer[FieldWithType]: ...
        def __init__(self, *, fields: _typing.Optional[_typing.Iterable[FieldWithType]] = ...): ...
        def HasField(self, field_name: _L["fields"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["fields"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def var(self) -> Type.Var: ...
    @property
    def con(self) -> Type.Con: ...
    @property
    def prim(self) -> Type.Prim: ...
    @property
    def forall(self) -> Type.Forall: ...
    @property
    def struct(self) -> Type.Struct: ...
    nat: _builtins.int
    @property
    def syn(self) -> Type.Syn: ...
    interned: _builtins.int
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, var: Type.Var = ...): ...
    @_typing.overload
    def __init__(self, *, con: Type.Con = ...): ...
    @_typing.overload
    def __init__(self, *, prim: Type.Prim = ...): ...
    @_typing.overload
    def __init__(self, *, forall: Type.Forall = ...): ...
    @_typing.overload
    def __init__(self, *, struct: Type.Struct = ...): ...
    @_typing.overload
    def __init__(self, *, nat: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, syn: Type.Syn = ...): ...
    @_typing.overload
    def __init__(self, *, interned: _builtins.int = ...): ...
    def HasField(self, field_name: _L["Sum", "var", "con", "prim", "forall", "struct", "nat", "syn", "interned"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "var", "con", "prim", "forall", "struct", "nat", "syn", "interned"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "var", "con", "prim", "forall", "struct", "nat", "syn", "interned"]: ...

class PrimLit(_Message):
    int64: _builtins.int
    decimal_str: _builtins.str
    numeric_interned_str: _builtins.int
    text_str: _builtins.str
    text_interned_str: _builtins.int
    timestamp: _builtins.float
    party_str: _builtins.str
    party_interned_str: _builtins.int
    date: _builtins.int
    @property
    def rounding_mode(self) -> _L[0, 1, 2, 3, 4, 5, 6, 7]: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, int64: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, decimal_str: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, numeric_interned_str: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, text_str: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, text_interned_str: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, timestamp: _builtins.float = ...): ...
    @_typing.overload
    def __init__(self, *, party_str: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, party_interned_str: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, date: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, rounding_mode: _L['UP', 0, 'DOWN', 1, 'CEILING', 2, 'FLOOR', 3, 'HALF_UP', 4, 'HALF_DOWN', 5, 'HALF_EVEN', 6, 'UNNECESSARY', 7] = ...): ...
    def HasField(self, field_name: _L["Sum", "int64", "decimal_str", "numeric_interned_str", "text_str", "text_interned_str", "timestamp", "party_str", "party_interned_str", "date", "rounding_mode"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "int64", "decimal_str", "numeric_interned_str", "text_str", "text_interned_str", "timestamp", "party_str", "party_interned_str", "date", "rounding_mode"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "int64", "decimal_str", "numeric_interned_str", "text_str", "text_interned_str", "timestamp", "party_str", "party_interned_str", "date", "rounding_mode"]: ...

class Location(_Message):
    
    class Range(_Message):
        start_line: _builtins.int
        start_col: _builtins.int
        end_line: _builtins.int
        end_col: _builtins.int
        def __init__(self, *, start_line: _typing.Optional[_builtins.int] = ..., start_col: _typing.Optional[_builtins.int] = ..., end_line: _typing.Optional[_builtins.int] = ..., end_col: _typing.Optional[_builtins.int] = ...): ...
        def HasField(self, field_name: _L["start_line", "start_col", "end_line", "end_col"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["start_line", "start_col", "end_line", "end_col"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def module(self) -> ModuleRef: ...
    @property
    def range(self) -> Location.Range: ...
    def __init__(self, *, module: _typing.Optional[ModuleRef] = ..., range: _typing.Optional[Location.Range] = ...): ...
    def HasField(self, field_name: _L["module", "range"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["module", "range"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Expr(_Message):
    
    class RecCon(_Message):
        @property
        def tycon(self) -> Type.Con: ...
        @property
        def fields(self) -> RepeatedCompositeFieldContainer[FieldWithExpr]: ...
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., fields: _typing.Optional[_typing.Iterable[FieldWithExpr]] = ...): ...
        def HasField(self, field_name: _L["tycon", "fields"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "fields"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class RecProj(_Message):
        @property
        def tycon(self) -> Type.Con: ...
        field_str: _builtins.str
        field_interned_str: _builtins.int
        @property
        def record(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., record: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., field_str: _builtins.str = ..., record: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., field_interned_str: _builtins.int = ..., record: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["tycon", "field", "field_str", "field_interned_str", "record"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "field", "field_str", "field_interned_str", "record"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...
    
    class RecUpd(_Message):
        @property
        def tycon(self) -> Type.Con: ...
        field_str: _builtins.str
        field_interned_str: _builtins.int
        @property
        def record(self) -> Expr: ...
        @property
        def update(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., record: _typing.Optional[Expr] = ..., update: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., field_str: _builtins.str = ..., record: _typing.Optional[Expr] = ..., update: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., field_interned_str: _builtins.int = ..., record: _typing.Optional[Expr] = ..., update: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["tycon", "field", "field_str", "field_interned_str", "record", "update"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "field", "field_str", "field_interned_str", "record", "update"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...
    
    class VariantCon(_Message):
        @property
        def tycon(self) -> Type.Con: ...
        variant_con_str: _builtins.str
        variant_con_interned_str: _builtins.int
        @property
        def variant_arg(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., variant_arg: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., variant_con_str: _builtins.str = ..., variant_arg: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., variant_con_interned_str: _builtins.int = ..., variant_arg: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["tycon", "variant_con", "variant_con_str", "variant_con_interned_str", "variant_arg"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "variant_con", "variant_con_str", "variant_con_interned_str", "variant_arg"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["variant_con"]) -> _L[None, "variant_con_str", "variant_con_interned_str"]: ...
    
    class EnumCon(_Message):
        @property
        def tycon(self) -> TypeConName: ...
        enum_con_str: _builtins.str
        enum_con_interned_str: _builtins.int
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[TypeConName] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[TypeConName] = ..., enum_con_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[TypeConName] = ..., enum_con_interned_str: _builtins.int = ...): ...
        def HasField(self, field_name: _L["tycon", "enum_con", "enum_con_str", "enum_con_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "enum_con", "enum_con_str", "enum_con_interned_str"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["enum_con"]) -> _L[None, "enum_con_str", "enum_con_interned_str"]: ...
    
    class StructCon(_Message):
        @property
        def fields(self) -> RepeatedCompositeFieldContainer[FieldWithExpr]: ...
        def __init__(self, *, fields: _typing.Optional[_typing.Iterable[FieldWithExpr]] = ...): ...
        def HasField(self, field_name: _L["fields"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["fields"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class StructProj(_Message):
        field_str: _builtins.str
        field_interned_str: _builtins.int
        @property
        def struct(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, struct: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, field_str: _builtins.str = ..., struct: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, field_interned_str: _builtins.int = ..., struct: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["field", "field_str", "field_interned_str", "struct"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["field", "field_str", "field_interned_str", "struct"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...
    
    class StructUpd(_Message):
        field_str: _builtins.str
        field_interned_str: _builtins.int
        @property
        def struct(self) -> Expr: ...
        @property
        def update(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, struct: _typing.Optional[Expr] = ..., update: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, field_str: _builtins.str = ..., struct: _typing.Optional[Expr] = ..., update: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, field_interned_str: _builtins.int = ..., struct: _typing.Optional[Expr] = ..., update: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["field", "field_str", "field_interned_str", "struct", "update"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["field", "field_str", "field_interned_str", "struct", "update"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...
    
    class App(_Message):
        @property
        def fun(self) -> Expr: ...
        @property
        def args(self) -> RepeatedCompositeFieldContainer[Expr]: ...
        def __init__(self, *, fun: _typing.Optional[Expr] = ..., args: _typing.Optional[_typing.Iterable[Expr]] = ...): ...
        def HasField(self, field_name: _L["fun", "args"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["fun", "args"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class TyApp(_Message):
        @property
        def expr(self) -> Expr: ...
        @property
        def types(self) -> RepeatedCompositeFieldContainer[Type]: ...
        def __init__(self, *, expr: _typing.Optional[Expr] = ..., types: _typing.Optional[_typing.Iterable[Type]] = ...): ...
        def HasField(self, field_name: _L["expr", "types"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["expr", "types"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Abs(_Message):
        @property
        def param(self) -> RepeatedCompositeFieldContainer[VarWithType]: ...
        @property
        def body(self) -> Expr: ...
        def __init__(self, *, param: _typing.Optional[_typing.Iterable[VarWithType]] = ..., body: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["param", "body"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["param", "body"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class TyAbs(_Message):
        @property
        def param(self) -> RepeatedCompositeFieldContainer[TypeVarWithKind]: ...
        @property
        def body(self) -> Expr: ...
        def __init__(self, *, param: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., body: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["param", "body"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["param", "body"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Nil(_Message):
        @property
        def type(self) -> Type: ...
        def __init__(self, *, type: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["type"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Cons(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def front(self) -> RepeatedCompositeFieldContainer[Expr]: ...
        @property
        def tail(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., front: _typing.Optional[_typing.Iterable[Expr]] = ..., tail: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "front", "tail"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "front", "tail"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class OptionalNone(_Message):
        @property
        def type(self) -> Type: ...
        def __init__(self, *, type: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["type"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class OptionalSome(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def body(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., body: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "body"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "body"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class ToAny(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def expr(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class FromAny(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def expr(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class ToAnyException(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def expr(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class FromAnyException(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def expr(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Throw(_Message):
        @property
        def return_type(self) -> Type: ...
        @property
        def exception_type(self) -> Type: ...
        @property
        def exception_expr(self) -> Expr: ...
        def __init__(self, *, return_type: _typing.Optional[Type] = ..., exception_type: _typing.Optional[Type] = ..., exception_expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["return_type", "exception_type", "exception_expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["return_type", "exception_type", "exception_expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Experimental(_Message):
        name: _builtins.str
        @property
        def type(self) -> Type: ...
        def __init__(self, *, name: _typing.Optional[_builtins.str] = ..., type: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["name", "type"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["name", "type"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def location(self) -> Location: ...
    var_str: _builtins.str
    var_interned_str: _builtins.int
    @property
    def val(self) -> ValName: ...
    @property
    def builtin(self) -> _L[0, 1, 2, 3, 6, 107, 108, 109, 110, 111, 121, 122, 7, 8, 9, 10, 11, 12, 20, 21, 96, 97, 98, 99, 100, 101, 124, 125, 126, 127, 128, 129, 130, 23, 24, 25, 147, 33, 34, 112, 36, 37, 67, 89, 39, 40, 113, 42, 43, 68, 90, 45, 46, 114, 48, 49, 69, 91, 51, 52, 115, 54, 55, 70, 92, 57, 58, 116, 60, 61, 71, 63, 94, 95, 103, 104, 117, 136, 93, 72, 73, 74, 75, 76, 77, 118, 119, 78, 79, 80, 120, 81, 82, 83, 84, 85, 86, 87, 123, 131, 132, 133, 134, 135, 88, 102, 105, 106, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146]: ...
    @property
    def prim_con(self) -> _L[0, 1, 2]: ...
    @property
    def prim_lit(self) -> PrimLit: ...
    @property
    def rec_con(self) -> Expr.RecCon: ...
    @property
    def rec_proj(self) -> Expr.RecProj: ...
    @property
    def rec_upd(self) -> Expr.RecUpd: ...
    @property
    def variant_con(self) -> Expr.VariantCon: ...
    @property
    def enum_con(self) -> Expr.EnumCon: ...
    @property
    def struct_con(self) -> Expr.StructCon: ...
    @property
    def struct_proj(self) -> Expr.StructProj: ...
    @property
    def struct_upd(self) -> Expr.StructUpd: ...
    @property
    def app(self) -> Expr.App: ...
    @property
    def ty_app(self) -> Expr.TyApp: ...
    @property
    def abs(self) -> Expr.Abs: ...
    @property
    def ty_abs(self) -> Expr.TyAbs: ...
    @property
    def case(self) -> Case: ...
    @property
    def let(self) -> Block: ...
    @property
    def nil(self) -> Expr.Nil: ...
    @property
    def cons(self) -> Expr.Cons: ...
    @property
    def update(self) -> Update: ...
    @property
    def scenario(self) -> Scenario: ...
    @property
    def optional_none(self) -> Expr.OptionalNone: ...
    @property
    def optional_some(self) -> Expr.OptionalSome: ...
    @property
    def to_any(self) -> Expr.ToAny: ...
    @property
    def from_any(self) -> Expr.FromAny: ...
    @property
    def type_rep(self) -> Type: ...
    @property
    def to_any_exception(self) -> Expr.ToAnyException: ...
    @property
    def from_any_exception(self) -> Expr.FromAnyException: ...
    @property
    def throw(self) -> Expr.Throw: ...
    @property
    def experimental(self) -> Expr.Experimental: ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., var_str: _builtins.str = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., var_interned_str: _builtins.int = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., val: ValName = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., builtin: _L['ADD_DECIMAL', 0, 'SUB_DECIMAL', 1, 'MUL_DECIMAL', 2, 'DIV_DECIMAL', 3, 'ROUND_DECIMAL', 6, 'ADD_NUMERIC', 107, 'SUB_NUMERIC', 108, 'MUL_NUMERIC', 109, 'DIV_NUMERIC', 110, 'ROUND_NUMERIC', 111, 'CAST_NUMERIC', 121, 'SHIFT_NUMERIC', 122, 'ADD_INT64', 7, 'SUB_INT64', 8, 'MUL_INT64', 9, 'DIV_INT64', 10, 'MOD_INT64', 11, 'EXP_INT64', 12, 'FOLDL', 20, 'FOLDR', 21, 'TEXTMAP_EMPTY', 96, 'TEXTMAP_INSERT', 97, 'TEXTMAP_LOOKUP', 98, 'TEXTMAP_DELETE', 99, 'TEXTMAP_TO_LIST', 100, 'TEXTMAP_SIZE', 101, 'GENMAP_EMPTY', 124, 'GENMAP_INSERT', 125, 'GENMAP_LOOKUP', 126, 'GENMAP_DELETE', 127, 'GENMAP_KEYS', 128, 'GENMAP_VALUES', 129, 'GENMAP_SIZE', 130, 'EXPLODE_TEXT', 23, 'APPEND_TEXT', 24, 'ERROR', 25, 'ANY_EXCEPTION_MESSAGE', 147, 'LEQ_INT64', 33, 'LEQ_DECIMAL', 34, 'LEQ_NUMERIC', 112, 'LEQ_TEXT', 36, 'LEQ_TIMESTAMP', 37, 'LEQ_DATE', 67, 'LEQ_PARTY', 89, 'LESS_INT64', 39, 'LESS_DECIMAL', 40, 'LESS_NUMERIC', 113, 'LESS_TEXT', 42, 'LESS_TIMESTAMP', 43, 'LESS_DATE', 68, 'LESS_PARTY', 90, 'GEQ_INT64', 45, 'GEQ_DECIMAL', 46, 'GEQ_NUMERIC', 114, 'GEQ_TEXT', 48, 'GEQ_TIMESTAMP', 49, 'GEQ_DATE', 69, 'GEQ_PARTY', 91, 'GREATER_INT64', 51, 'GREATER_DECIMAL', 52, 'GREATER_NUMERIC', 115, 'GREATER_TEXT', 54, 'GREATER_TIMESTAMP', 55, 'GREATER_DATE', 70, 'GREATER_PARTY', 92, 'INT64_TO_TEXT', 57, 'DECIMAL_TO_TEXT', 58, 'NUMERIC_TO_TEXT', 116, 'TEXT_TO_TEXT', 60, 'TIMESTAMP_TO_TEXT', 61, 'DATE_TO_TEXT', 71, 'PARTY_TO_QUOTED_TEXT', 63, 'PARTY_TO_TEXT', 94, 'TEXT_TO_PARTY', 95, 'TEXT_TO_INT64', 103, 'TEXT_TO_DECIMAL', 104, 'TEXT_TO_NUMERIC', 117, 'CONTRACT_ID_TO_TEXT', 136, 'SHA256_TEXT', 93, 'DATE_TO_UNIX_DAYS', 72, 'UNIX_DAYS_TO_DATE', 73, 'TIMESTAMP_TO_UNIX_MICROSECONDS', 74, 'UNIX_MICROSECONDS_TO_TIMESTAMP', 75, 'INT64_TO_DECIMAL', 76, 'DECIMAL_TO_INT64', 77, 'INT64_TO_NUMERIC', 118, 'NUMERIC_TO_INT64', 119, 'IMPLODE_TEXT', 78, 'EQUAL_INT64', 79, 'EQUAL_DECIMAL', 80, 'EQUAL_NUMERIC', 120, 'EQUAL_TEXT', 81, 'EQUAL_TIMESTAMP', 82, 'EQUAL_DATE', 83, 'EQUAL_PARTY', 84, 'EQUAL_BOOL', 85, 'EQUAL_CONTRACT_ID', 86, 'EQUAL_LIST', 87, 'EQUAL_TYPE_REP', 123, 'EQUAL', 131, 'LESS_EQ', 132, 'LESS', 133, 'GREATER_EQ', 134, 'GREATER', 135, 'TRACE', 88, 'COERCE_CONTRACT_ID', 102, 'CODE_POINTS_TO_TEXT', 105, 'TEXT_POINTS_TO_CODE', 106, 'SCALE_BIGNUMERIC', 137, 'PRECISION_BIGNUMERIC', 138, 'ADD_BIGNUMERIC', 139, 'SUB_BIGNUMERIC', 140, 'MUL_BIGNUMERIC', 141, 'DIV_BIGNUMERIC', 142, 'SHIFT_RIGHT_BIGNUMERIC', 143, 'BIGNUMERIC_TO_NUMERIC', 144, 'NUMERIC_TO_BIGNUMERIC', 145, 'BIGNUMERIC_TO_TEXT', 146] = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., prim_con: _L['CON_UNIT', 0, 'CON_FALSE', 1, 'CON_TRUE', 2] = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., prim_lit: PrimLit = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., rec_con: Expr.RecCon = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., rec_proj: Expr.RecProj = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., rec_upd: Expr.RecUpd = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., variant_con: Expr.VariantCon = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., enum_con: Expr.EnumCon = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., struct_con: Expr.StructCon = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., struct_proj: Expr.StructProj = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., struct_upd: Expr.StructUpd = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., app: Expr.App = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., ty_app: Expr.TyApp = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., abs: Expr.Abs = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., ty_abs: Expr.TyAbs = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., case: Case = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., let: Block = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., nil: Expr.Nil = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., cons: Expr.Cons = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., update: Update = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., scenario: Scenario = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., optional_none: Expr.OptionalNone = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., optional_some: Expr.OptionalSome = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., to_any: Expr.ToAny = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., from_any: Expr.FromAny = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., type_rep: Type = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., to_any_exception: Expr.ToAnyException = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., from_any_exception: Expr.FromAnyException = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., throw: Expr.Throw = ...): ...
    @_typing.overload
    def __init__(self, *, location: _typing.Optional[Location] = ..., experimental: Expr.Experimental = ...): ...
    def HasField(self, field_name: _L["location", "Sum", "var_str", "var_interned_str", "val", "builtin", "prim_con", "prim_lit", "rec_con", "rec_proj", "rec_upd", "variant_con", "enum_con", "struct_con", "struct_proj", "struct_upd", "app", "ty_app", "abs", "ty_abs", "case", "let", "nil", "cons", "update", "scenario", "optional_none", "optional_some", "to_any", "from_any", "type_rep", "to_any_exception", "from_any_exception", "throw", "experimental"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["location", "Sum", "var_str", "var_interned_str", "val", "builtin", "prim_con", "prim_lit", "rec_con", "rec_proj", "rec_upd", "variant_con", "enum_con", "struct_con", "struct_proj", "struct_upd", "app", "ty_app", "abs", "ty_abs", "case", "let", "nil", "cons", "update", "scenario", "optional_none", "optional_some", "to_any", "from_any", "type_rep", "to_any_exception", "from_any_exception", "throw", "experimental"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "var_str", "var_interned_str", "val", "builtin", "prim_con", "prim_lit", "rec_con", "rec_proj", "rec_upd", "variant_con", "enum_con", "struct_con", "struct_proj", "struct_upd", "app", "ty_app", "abs", "ty_abs", "case", "let", "nil", "cons", "update", "scenario", "optional_none", "optional_some", "to_any", "from_any", "type_rep", "to_any_exception", "from_any_exception", "throw", "experimental"]: ...

class CaseAlt(_Message):
    
    class Variant(_Message):
        @property
        def con(self) -> TypeConName: ...
        variant_str: _builtins.str
        variant_interned_str: _builtins.int
        binder_str: _builtins.str
        binder_interned_str: _builtins.int
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., binder_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., binder_interned_str: _builtins.int = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., variant_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., variant_str: _builtins.str = ..., binder_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., variant_str: _builtins.str = ..., binder_interned_str: _builtins.int = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., variant_interned_str: _builtins.int = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., variant_interned_str: _builtins.int = ..., binder_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., variant_interned_str: _builtins.int = ..., binder_interned_str: _builtins.int = ...): ...
        def HasField(self, field_name: _L["con", "variant", "variant_str", "variant_interned_str", "binder", "binder_str", "binder_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["con", "variant", "variant_str", "variant_interned_str", "binder", "binder_str", "binder_interned_str"]) -> None: ...
        @_typing.overload
        def WhichOneof(self, oneof_group: _L["variant"]) -> _L[None, "variant_str", "variant_interned_str"]: ...
        @_typing.overload
        def WhichOneof(self, oneof_group: _L["binder"]) -> _L[None, "binder_str", "binder_interned_str"]: ...
    
    class Enum(_Message):
        @property
        def con(self) -> TypeConName: ...
        constructor_str: _builtins.str
        constructor_interned_str: _builtins.int
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., constructor_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, con: _typing.Optional[TypeConName] = ..., constructor_interned_str: _builtins.int = ...): ...
        def HasField(self, field_name: _L["con", "constructor", "constructor_str", "constructor_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["con", "constructor", "constructor_str", "constructor_interned_str"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["constructor"]) -> _L[None, "constructor_str", "constructor_interned_str"]: ...
    
    class Cons(_Message):
        var_head_str: _builtins.str
        var_head_interned_str: _builtins.int
        var_tail_str: _builtins.str
        var_tail_interned_str: _builtins.int
        @_typing.overload
        def __init__(self): ...
        @_typing.overload
        def __init__(self, *, var_tail_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, var_tail_interned_str: _builtins.int = ...): ...
        @_typing.overload
        def __init__(self, *, var_head_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, var_head_str: _builtins.str = ..., var_tail_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, var_head_str: _builtins.str = ..., var_tail_interned_str: _builtins.int = ...): ...
        @_typing.overload
        def __init__(self, *, var_head_interned_str: _builtins.int = ...): ...
        @_typing.overload
        def __init__(self, *, var_head_interned_str: _builtins.int = ..., var_tail_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, var_head_interned_str: _builtins.int = ..., var_tail_interned_str: _builtins.int = ...): ...
        def HasField(self, field_name: _L["var_head", "var_head_str", "var_head_interned_str", "var_tail", "var_tail_str", "var_tail_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["var_head", "var_head_str", "var_head_interned_str", "var_tail", "var_tail_str", "var_tail_interned_str"]) -> None: ...
        @_typing.overload
        def WhichOneof(self, oneof_group: _L["var_head"]) -> _L[None, "var_head_str", "var_head_interned_str"]: ...
        @_typing.overload
        def WhichOneof(self, oneof_group: _L["var_tail"]) -> _L[None, "var_tail_str", "var_tail_interned_str"]: ...
    
    class OptionalSome(_Message):
        var_body_str: _builtins.str
        var_body_interned_str: _builtins.int
        @_typing.overload
        def __init__(self): ...
        @_typing.overload
        def __init__(self, *, var_body_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, var_body_interned_str: _builtins.int = ...): ...
        def HasField(self, field_name: _L["var_body", "var_body_str", "var_body_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["var_body", "var_body_str", "var_body_interned_str"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["var_body"]) -> _L[None, "var_body_str", "var_body_interned_str"]: ...
    @property
    def default(self) -> Unit: ...
    @property
    def variant(self) -> CaseAlt.Variant: ...
    @property
    def prim_con(self) -> _L[0, 1, 2]: ...
    @property
    def nil(self) -> Unit: ...
    @property
    def cons(self) -> CaseAlt.Cons: ...
    @property
    def optional_none(self) -> Unit: ...
    @property
    def optional_some(self) -> CaseAlt.OptionalSome: ...
    @property
    def enum(self) -> CaseAlt.Enum: ...
    @property
    def body(self) -> Expr: ...
    @_typing.overload
    def __init__(self, *, body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, default: Unit = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, variant: CaseAlt.Variant = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, prim_con: _L['CON_UNIT', 0, 'CON_FALSE', 1, 'CON_TRUE', 2] = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, nil: Unit = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, cons: CaseAlt.Cons = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, optional_none: Unit = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, optional_some: CaseAlt.OptionalSome = ..., body: _typing.Optional[Expr] = ...): ...
    @_typing.overload
    def __init__(self, *, enum: CaseAlt.Enum = ..., body: _typing.Optional[Expr] = ...): ...
    def HasField(self, field_name: _L["Sum", "default", "variant", "prim_con", "nil", "cons", "optional_none", "optional_some", "enum", "body"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "default", "variant", "prim_con", "nil", "cons", "optional_none", "optional_some", "enum", "body"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "default", "variant", "prim_con", "nil", "cons", "optional_none", "optional_some", "enum"]: ...

class Case(_Message):
    @property
    def scrut(self) -> Expr: ...
    @property
    def alts(self) -> RepeatedCompositeFieldContainer[CaseAlt]: ...
    def __init__(self, *, scrut: _typing.Optional[Expr] = ..., alts: _typing.Optional[_typing.Iterable[CaseAlt]] = ...): ...
    def HasField(self, field_name: _L["scrut", "alts"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["scrut", "alts"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Block(_Message):
    @property
    def bindings(self) -> RepeatedCompositeFieldContainer[Binding]: ...
    @property
    def body(self) -> Expr: ...
    def __init__(self, *, bindings: _typing.Optional[_typing.Iterable[Binding]] = ..., body: _typing.Optional[Expr] = ...): ...
    def HasField(self, field_name: _L["bindings", "body"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["bindings", "body"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Pure(_Message):
    @property
    def type(self) -> Type: ...
    @property
    def expr(self) -> Expr: ...
    def __init__(self, *, type: _typing.Optional[Type] = ..., expr: _typing.Optional[Expr] = ...): ...
    def HasField(self, field_name: _L["type", "expr"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["type", "expr"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Update(_Message):
    
    class Create(_Message):
        @property
        def template(self) -> TypeConName: ...
        @property
        def expr(self) -> Expr: ...
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["template", "expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["template", "expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Exercise(_Message):
        @property
        def template(self) -> TypeConName: ...
        choice_str: _builtins.str
        choice_interned_str: _builtins.int
        @property
        def cid(self) -> Expr: ...
        @property
        def arg(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., cid: _typing.Optional[Expr] = ..., arg: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., choice_str: _builtins.str = ..., cid: _typing.Optional[Expr] = ..., arg: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., choice_interned_str: _builtins.int = ..., cid: _typing.Optional[Expr] = ..., arg: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["template", "choice", "choice_str", "choice_interned_str", "cid", "arg"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["template", "choice", "choice_str", "choice_interned_str", "cid", "arg"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["choice"]) -> _L[None, "choice_str", "choice_interned_str"]: ...
    
    class ExerciseByKey(_Message):
        @property
        def template(self) -> TypeConName: ...
        choice_interned_str: _builtins.int
        @property
        def key(self) -> Expr: ...
        @property
        def arg(self) -> Expr: ...
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., choice_interned_str: _typing.Optional[_builtins.int] = ..., key: _typing.Optional[Expr] = ..., arg: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["template", "choice_interned_str", "key", "arg"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["template", "choice_interned_str", "key", "arg"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class Fetch(_Message):
        @property
        def template(self) -> TypeConName: ...
        @property
        def cid(self) -> Expr: ...
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., cid: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["template", "cid"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["template", "cid"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class EmbedExpr(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def body(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., body: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "body"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "body"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class RetrieveByKey(_Message):
        @property
        def template(self) -> TypeConName: ...
        @property
        def key(self) -> Expr: ...
        def __init__(self, *, template: _typing.Optional[TypeConName] = ..., key: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["template", "key"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["template", "key"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class TryCatch(_Message):
        @property
        def return_type(self) -> Type: ...
        @property
        def try_expr(self) -> Expr: ...
        var_interned_str: _builtins.int
        @property
        def catch_expr(self) -> Expr: ...
        def __init__(self, *, return_type: _typing.Optional[Type] = ..., try_expr: _typing.Optional[Expr] = ..., var_interned_str: _typing.Optional[_builtins.int] = ..., catch_expr: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["return_type", "try_expr", "var_interned_str", "catch_expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["return_type", "try_expr", "var_interned_str", "catch_expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def pure(self) -> Pure: ...
    @property
    def block(self) -> Block: ...
    @property
    def create(self) -> Update.Create: ...
    @property
    def exercise(self) -> Update.Exercise: ...
    @property
    def exercise_by_key(self) -> Update.ExerciseByKey: ...
    @property
    def fetch(self) -> Update.Fetch: ...
    @property
    def get_time(self) -> Unit: ...
    @property
    def lookup_by_key(self) -> Update.RetrieveByKey: ...
    @property
    def fetch_by_key(self) -> Update.RetrieveByKey: ...
    @property
    def embed_expr(self) -> Update.EmbedExpr: ...
    @property
    def try_catch(self) -> Update.TryCatch: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, pure: Pure = ...): ...
    @_typing.overload
    def __init__(self, *, block: Block = ...): ...
    @_typing.overload
    def __init__(self, *, create: Update.Create = ...): ...
    @_typing.overload
    def __init__(self, *, exercise: Update.Exercise = ...): ...
    @_typing.overload
    def __init__(self, *, exercise_by_key: Update.ExerciseByKey = ...): ...
    @_typing.overload
    def __init__(self, *, fetch: Update.Fetch = ...): ...
    @_typing.overload
    def __init__(self, *, get_time: Unit = ...): ...
    @_typing.overload
    def __init__(self, *, lookup_by_key: Update.RetrieveByKey = ...): ...
    @_typing.overload
    def __init__(self, *, fetch_by_key: Update.RetrieveByKey = ...): ...
    @_typing.overload
    def __init__(self, *, embed_expr: Update.EmbedExpr = ...): ...
    @_typing.overload
    def __init__(self, *, try_catch: Update.TryCatch = ...): ...
    def HasField(self, field_name: _L["Sum", "pure", "block", "create", "exercise", "exercise_by_key", "fetch", "get_time", "lookup_by_key", "fetch_by_key", "embed_expr", "try_catch"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "pure", "block", "create", "exercise", "exercise_by_key", "fetch", "get_time", "lookup_by_key", "fetch_by_key", "embed_expr", "try_catch"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "pure", "block", "create", "exercise", "exercise_by_key", "fetch", "get_time", "lookup_by_key", "fetch_by_key", "embed_expr", "try_catch"]: ...

class Scenario(_Message):
    
    class Commit(_Message):
        @property
        def party(self) -> Expr: ...
        @property
        def expr(self) -> Expr: ...
        @property
        def ret_type(self) -> Type: ...
        def __init__(self, *, party: _typing.Optional[Expr] = ..., expr: _typing.Optional[Expr] = ..., ret_type: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["party", "expr", "ret_type"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["party", "expr", "ret_type"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class EmbedExpr(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def body(self) -> Expr: ...
        def __init__(self, *, type: _typing.Optional[Type] = ..., body: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "body"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "body"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def pure(self) -> Pure: ...
    @property
    def block(self) -> Block: ...
    @property
    def commit(self) -> Scenario.Commit: ...
    @property
    def mustFailAt(self) -> Scenario.Commit: ...
    @property
    def get_time(self) -> Unit: ...
    @property
    def get_party(self) -> Expr: ...
    @property
    def embed_expr(self) -> Scenario.EmbedExpr: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, pure: Pure = ...): ...
    @_typing.overload
    def __init__(self, *, block: Block = ...): ...
    @_typing.overload
    def __init__(self, *, commit: Scenario.Commit = ...): ...
    @_typing.overload
    def __init__(self, *, mustFailAt: Scenario.Commit = ...): ...
    @_typing.overload
    def __init__(self, *, get_time: Unit = ...): ...
    @_typing.overload
    def __init__(self, *, get_party: Expr = ...): ...
    @_typing.overload
    def __init__(self, *, embed_expr: Scenario.EmbedExpr = ...): ...
    def HasField(self, field_name: _L["Sum", "pure", "block", "commit", "mustFailAt", "pass", "get_time", "get_party", "embed_expr"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "pure", "block", "commit", "mustFailAt", "pass", "get_time", "get_party", "embed_expr"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "pure", "block", "commit", "mustFailAt", "pass", "get_time", "get_party", "embed_expr"]: ...

class TemplateChoice(_Message):
    name_str: _builtins.str
    name_interned_str: _builtins.int
    consuming: _builtins.bool
    @property
    def controllers(self) -> Expr: ...
    @property
    def observers(self) -> Expr: ...
    @property
    def arg_binder(self) -> VarWithType: ...
    @property
    def ret_type(self) -> Type: ...
    @property
    def update(self) -> Expr: ...
    self_binder_str: _builtins.str
    self_binder_interned_str: _builtins.int
    @property
    def location(self) -> Location: ...
    @_typing.overload
    def __init__(self, *, consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., self_binder_str: _builtins.str = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., self_binder_interned_str: _builtins.int = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_str: _builtins.str = ..., consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_str: _builtins.str = ..., consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., self_binder_str: _builtins.str = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_str: _builtins.str = ..., consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., self_binder_interned_str: _builtins.int = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_str: _builtins.int = ..., consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_str: _builtins.int = ..., consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., self_binder_str: _builtins.str = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_str: _builtins.int = ..., consuming: _typing.Optional[_builtins.bool] = ..., controllers: _typing.Optional[Expr] = ..., observers: _typing.Optional[Expr] = ..., arg_binder: _typing.Optional[VarWithType] = ..., ret_type: _typing.Optional[Type] = ..., update: _typing.Optional[Expr] = ..., self_binder_interned_str: _builtins.int = ..., location: _typing.Optional[Location] = ...): ...
    def HasField(self, field_name: _L["name", "name_str", "name_interned_str", "consuming", "controllers", "observers", "arg_binder", "ret_type", "update", "self_binder", "self_binder_str", "self_binder_interned_str", "location"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name", "name_str", "name_interned_str", "consuming", "controllers", "observers", "arg_binder", "ret_type", "update", "self_binder", "self_binder_str", "self_binder_interned_str", "location"]) -> None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _L["name"]) -> _L[None, "name_str", "name_interned_str"]: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _L["self_binder"]) -> _L[None, "self_binder_str", "self_binder_interned_str"]: ...

class KeyExpr(_Message):
    
    class Projection(_Message):
        @property
        def tycon(self) -> Type.Con: ...
        field_str: _builtins.str
        field_interned_str: _builtins.int
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., field_str: _builtins.str = ...): ...
        @_typing.overload
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., field_interned_str: _builtins.int = ...): ...
        def HasField(self, field_name: _L["tycon", "field", "field_str", "field_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "field", "field_str", "field_interned_str"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...
    
    class Projections(_Message):
        @property
        def projections(self) -> RepeatedCompositeFieldContainer[KeyExpr.Projection]: ...
        def __init__(self, *, projections: _typing.Optional[_typing.Iterable[KeyExpr.Projection]] = ...): ...
        def HasField(self, field_name: _L["projections"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["projections"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class RecordField(_Message):
        field_str: _builtins.str
        field_interned_str: _builtins.int
        @property
        def expr(self) -> KeyExpr: ...
        @_typing.overload
        def __init__(self, *, expr: _typing.Optional[KeyExpr] = ...): ...
        @_typing.overload
        def __init__(self, *, field_str: _builtins.str = ..., expr: _typing.Optional[KeyExpr] = ...): ...
        @_typing.overload
        def __init__(self, *, field_interned_str: _builtins.int = ..., expr: _typing.Optional[KeyExpr] = ...): ...
        def HasField(self, field_name: _L["field", "field_str", "field_interned_str", "expr"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["field", "field_str", "field_interned_str", "expr"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["field"]) -> _L[None, "field_str", "field_interned_str"]: ...
    
    class Record(_Message):
        @property
        def tycon(self) -> Type.Con: ...
        @property
        def fields(self) -> RepeatedCompositeFieldContainer[KeyExpr.RecordField]: ...
        def __init__(self, *, tycon: _typing.Optional[Type.Con] = ..., fields: _typing.Optional[_typing.Iterable[KeyExpr.RecordField]] = ...): ...
        def HasField(self, field_name: _L["tycon", "fields"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["tycon", "fields"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def projections(self) -> KeyExpr.Projections: ...
    @property
    def record(self) -> KeyExpr.Record: ...
    @_typing.overload
    def __init__(self): ...
    @_typing.overload
    def __init__(self, *, projections: KeyExpr.Projections = ...): ...
    @_typing.overload
    def __init__(self, *, record: KeyExpr.Record = ...): ...
    def HasField(self, field_name: _L["Sum", "projections", "record"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["Sum", "projections", "record"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["Sum"]) -> _L[None, "projections", "record"]: ...

class DefTemplate(_Message):
    
    class DefKey(_Message):
        @property
        def type(self) -> Type: ...
        @property
        def key(self) -> KeyExpr: ...
        @property
        def complex_key(self) -> Expr: ...
        @property
        def maintainers(self) -> Expr: ...
        @_typing.overload
        def __init__(self, *, type: _typing.Optional[Type] = ..., maintainers: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, type: _typing.Optional[Type] = ..., key: KeyExpr = ..., maintainers: _typing.Optional[Expr] = ...): ...
        @_typing.overload
        def __init__(self, *, type: _typing.Optional[Type] = ..., complex_key: Expr = ..., maintainers: _typing.Optional[Expr] = ...): ...
        def HasField(self, field_name: _L["type", "key_expr", "key", "complex_key", "maintainers"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["type", "key_expr", "key", "complex_key", "maintainers"]) -> None: ...
        def WhichOneof(self, oneof_group: _L["key_expr"]) -> _L[None, "key", "complex_key"]: ...
    @property
    def tycon_dname(self) -> DottedName: ...
    tycon_interned_dname: _builtins.int
    param_str: _builtins.str
    param_interned_str: _builtins.int
    @property
    def precond(self) -> Expr: ...
    @property
    def signatories(self) -> Expr: ...
    @property
    def agreement(self) -> Expr: ...
    @property
    def choices(self) -> RepeatedCompositeFieldContainer[TemplateChoice]: ...
    @property
    def observers(self) -> Expr: ...
    @property
    def location(self) -> Location: ...
    @property
    def key(self) -> DefTemplate.DefKey: ...
    @_typing.overload
    def __init__(self, *, precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, param_str: _builtins.str = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, param_interned_str: _builtins.int = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, tycon_dname: DottedName = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, tycon_dname: DottedName = ..., param_str: _builtins.str = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, tycon_dname: DottedName = ..., param_interned_str: _builtins.int = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, tycon_interned_dname: _builtins.int = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, tycon_interned_dname: _builtins.int = ..., param_str: _builtins.str = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    @_typing.overload
    def __init__(self, *, tycon_interned_dname: _builtins.int = ..., param_interned_str: _builtins.int = ..., precond: _typing.Optional[Expr] = ..., signatories: _typing.Optional[Expr] = ..., agreement: _typing.Optional[Expr] = ..., choices: _typing.Optional[_typing.Iterable[TemplateChoice]] = ..., observers: _typing.Optional[Expr] = ..., location: _typing.Optional[Location] = ..., key: _typing.Optional[DefTemplate.DefKey] = ...): ...
    def HasField(self, field_name: _L["tycon", "tycon_dname", "tycon_interned_dname", "param", "param_str", "param_interned_str", "precond", "signatories", "agreement", "choices", "observers", "location", "key"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["tycon", "tycon_dname", "tycon_interned_dname", "param", "param_str", "param_interned_str", "precond", "signatories", "agreement", "choices", "observers", "location", "key"]) -> None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _L["tycon"]) -> _L[None, "tycon_dname", "tycon_interned_dname"]: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _L["param"]) -> _L[None, "param_str", "param_interned_str"]: ...

class DefException(_Message):
    name_interned_dname: _builtins.int
    @property
    def location(self) -> Location: ...
    @property
    def message(self) -> Expr: ...
    def __init__(self, *, name_interned_dname: _typing.Optional[_builtins.int] = ..., location: _typing.Optional[Location] = ..., message: _typing.Optional[Expr] = ...): ...
    def HasField(self, field_name: _L["name_interned_dname", "location", "message"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name_interned_dname", "location", "message"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class DefDataType(_Message):
    
    class Fields(_Message):
        @property
        def fields(self) -> RepeatedCompositeFieldContainer[FieldWithType]: ...
        def __init__(self, *, fields: _typing.Optional[_typing.Iterable[FieldWithType]] = ...): ...
        def HasField(self, field_name: _L["fields"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["fields"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    
    class EnumConstructors(_Message):
        @property
        def constructors_str(self) -> RepeatedScalarFieldContainer[_builtins.str]: ...
        @property
        def constructors_interned_str(self) -> RepeatedScalarFieldContainer[_builtins.int]: ...
        def __init__(self, *, constructors_str: _typing.Optional[_typing.Iterable[_builtins.str]] = ..., constructors_interned_str: _typing.Optional[_typing.Iterable[_builtins.int]] = ...): ...
        def HasField(self, field_name: _L["constructors_str", "constructors_interned_str"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["constructors_str", "constructors_interned_str"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def name_dname(self) -> DottedName: ...
    name_interned_dname: _builtins.int
    @property
    def params(self) -> RepeatedCompositeFieldContainer[TypeVarWithKind]: ...
    @property
    def record(self) -> DefDataType.Fields: ...
    @property
    def variant(self) -> DefDataType.Fields: ...
    @property
    def enum(self) -> DefDataType.EnumConstructors: ...
    serializable: _builtins.bool
    @property
    def location(self) -> Location: ...
    @_typing.overload
    def __init__(self, *, params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., record: DefDataType.Fields = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., variant: DefDataType.Fields = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., enum: DefDataType.EnumConstructors = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_dname: DottedName = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_dname: DottedName = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., record: DefDataType.Fields = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_dname: DottedName = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., variant: DefDataType.Fields = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_dname: DottedName = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., enum: DefDataType.EnumConstructors = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_dname: _builtins.int = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_dname: _builtins.int = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., record: DefDataType.Fields = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_dname: _builtins.int = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., variant: DefDataType.Fields = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_dname: _builtins.int = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., enum: DefDataType.EnumConstructors = ..., serializable: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    def HasField(self, field_name: _L["name", "name_dname", "name_interned_dname", "params", "DataCons", "record", "variant", "enum", "serializable", "location"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name", "name_dname", "name_interned_dname", "params", "DataCons", "record", "variant", "enum", "serializable", "location"]) -> None: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _L["name"]) -> _L[None, "name_dname", "name_interned_dname"]: ...
    @_typing.overload
    def WhichOneof(self, oneof_group: _L["DataCons"]) -> _L[None, "record", "variant", "enum"]: ...

class DefTypeSyn(_Message):
    @property
    def name_dname(self) -> DottedName: ...
    name_interned_dname: _builtins.int
    @property
    def params(self) -> RepeatedCompositeFieldContainer[TypeVarWithKind]: ...
    @property
    def type(self) -> Type: ...
    @property
    def location(self) -> Location: ...
    @_typing.overload
    def __init__(self, *, params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., type: _typing.Optional[Type] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_dname: DottedName = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., type: _typing.Optional[Type] = ..., location: _typing.Optional[Location] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_dname: _builtins.int = ..., params: _typing.Optional[_typing.Iterable[TypeVarWithKind]] = ..., type: _typing.Optional[Type] = ..., location: _typing.Optional[Location] = ...): ...
    def HasField(self, field_name: _L["name", "name_dname", "name_interned_dname", "params", "type", "location"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name", "name_dname", "name_interned_dname", "params", "type", "location"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["name"]) -> _L[None, "name_dname", "name_interned_dname"]: ...

class DefValue(_Message):
    
    class NameWithType(_Message):
        @property
        def name_dname(self) -> RepeatedScalarFieldContainer[_builtins.str]: ...
        name_interned_dname: _builtins.int
        @property
        def type(self) -> Type: ...
        def __init__(self, *, name_dname: _typing.Optional[_typing.Iterable[_builtins.str]] = ..., name_interned_dname: _typing.Optional[_builtins.int] = ..., type: _typing.Optional[Type] = ...): ...
        def HasField(self, field_name: _L["name_dname", "name_interned_dname", "type"]) -> _builtins.bool: ...
        def ClearField(self, field_name: _L["name_dname", "name_interned_dname", "type"]) -> None: ...
        def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
    @property
    def name_with_type(self) -> DefValue.NameWithType: ...
    @property
    def expr(self) -> Expr: ...
    no_party_literals: _builtins.bool
    is_test: _builtins.bool
    @property
    def location(self) -> Location: ...
    def __init__(self, *, name_with_type: _typing.Optional[DefValue.NameWithType] = ..., expr: _typing.Optional[Expr] = ..., no_party_literals: _typing.Optional[_builtins.bool] = ..., is_test: _typing.Optional[_builtins.bool] = ..., location: _typing.Optional[Location] = ...): ...
    def HasField(self, field_name: _L["name_with_type", "expr", "no_party_literals", "is_test", "location"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name_with_type", "expr", "no_party_literals", "is_test", "location"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class FeatureFlags(_Message):
    forbidPartyLiterals: _builtins.bool
    dontDivulgeContractIdsInCreateArguments: _builtins.bool
    dontDiscloseNonConsumingChoicesToObservers: _builtins.bool
    def __init__(self, *, forbidPartyLiterals: _typing.Optional[_builtins.bool] = ..., dontDivulgeContractIdsInCreateArguments: _typing.Optional[_builtins.bool] = ..., dontDiscloseNonConsumingChoicesToObservers: _typing.Optional[_builtins.bool] = ...): ...
    def HasField(self, field_name: _L["forbidPartyLiterals", "dontDivulgeContractIdsInCreateArguments", "dontDiscloseNonConsumingChoicesToObservers"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["forbidPartyLiterals", "dontDivulgeContractIdsInCreateArguments", "dontDiscloseNonConsumingChoicesToObservers"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Module(_Message):
    @property
    def name_dname(self) -> DottedName: ...
    name_interned_dname: _builtins.int
    @property
    def flags(self) -> FeatureFlags: ...
    @property
    def synonyms(self) -> RepeatedCompositeFieldContainer[DefTypeSyn]: ...
    @property
    def data_types(self) -> RepeatedCompositeFieldContainer[DefDataType]: ...
    @property
    def values(self) -> RepeatedCompositeFieldContainer[DefValue]: ...
    @property
    def templates(self) -> RepeatedCompositeFieldContainer[DefTemplate]: ...
    @property
    def exceptions(self) -> RepeatedCompositeFieldContainer[DefException]: ...
    @_typing.overload
    def __init__(self, *, flags: _typing.Optional[FeatureFlags] = ..., synonyms: _typing.Optional[_typing.Iterable[DefTypeSyn]] = ..., data_types: _typing.Optional[_typing.Iterable[DefDataType]] = ..., values: _typing.Optional[_typing.Iterable[DefValue]] = ..., templates: _typing.Optional[_typing.Iterable[DefTemplate]] = ..., exceptions: _typing.Optional[_typing.Iterable[DefException]] = ...): ...
    @_typing.overload
    def __init__(self, *, name_dname: DottedName = ..., flags: _typing.Optional[FeatureFlags] = ..., synonyms: _typing.Optional[_typing.Iterable[DefTypeSyn]] = ..., data_types: _typing.Optional[_typing.Iterable[DefDataType]] = ..., values: _typing.Optional[_typing.Iterable[DefValue]] = ..., templates: _typing.Optional[_typing.Iterable[DefTemplate]] = ..., exceptions: _typing.Optional[_typing.Iterable[DefException]] = ...): ...
    @_typing.overload
    def __init__(self, *, name_interned_dname: _builtins.int = ..., flags: _typing.Optional[FeatureFlags] = ..., synonyms: _typing.Optional[_typing.Iterable[DefTypeSyn]] = ..., data_types: _typing.Optional[_typing.Iterable[DefDataType]] = ..., values: _typing.Optional[_typing.Iterable[DefValue]] = ..., templates: _typing.Optional[_typing.Iterable[DefTemplate]] = ..., exceptions: _typing.Optional[_typing.Iterable[DefException]] = ...): ...
    def HasField(self, field_name: _L["name", "name_dname", "name_interned_dname", "flags", "synonyms", "data_types", "values", "templates", "exceptions"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name", "name_dname", "name_interned_dname", "flags", "synonyms", "data_types", "values", "templates", "exceptions"]) -> None: ...
    def WhichOneof(self, oneof_group: _L["name"]) -> _L[None, "name_dname", "name_interned_dname"]: ...

class InternedDottedName(_Message):
    @property
    def segments_interned_str(self) -> RepeatedScalarFieldContainer[_builtins.int]: ...
    def __init__(self, *, segments_interned_str: _typing.Optional[_typing.Iterable[_builtins.int]] = ...): ...
    def HasField(self, field_name: _L["segments_interned_str"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["segments_interned_str"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class PackageMetadata(_Message):
    name_interned_str: _builtins.int
    version_interned_str: _builtins.int
    def __init__(self, *, name_interned_str: _typing.Optional[_builtins.int] = ..., version_interned_str: _typing.Optional[_builtins.int] = ...): ...
    def HasField(self, field_name: _L["name_interned_str", "version_interned_str"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["name_interned_str", "version_interned_str"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Package(_Message):
    @property
    def modules(self) -> RepeatedCompositeFieldContainer[Module]: ...
    @property
    def interned_strings(self) -> RepeatedScalarFieldContainer[_builtins.str]: ...
    @property
    def interned_dotted_names(self) -> RepeatedCompositeFieldContainer[InternedDottedName]: ...
    @property
    def metadata(self) -> PackageMetadata: ...
    @property
    def interned_types(self) -> RepeatedCompositeFieldContainer[Type]: ...
    def __init__(self, *, modules: _typing.Optional[_typing.Iterable[Module]] = ..., interned_strings: _typing.Optional[_typing.Iterable[_builtins.str]] = ..., interned_dotted_names: _typing.Optional[_typing.Iterable[InternedDottedName]] = ..., metadata: _typing.Optional[PackageMetadata] = ..., interned_types: _typing.Optional[_typing.Iterable[Type]] = ...): ...
    def HasField(self, field_name: _L["modules", "interned_strings", "interned_dotted_names", "metadata", "interned_types"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["modules", "interned_strings", "interned_dotted_names", "metadata", "interned_types"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
