# Copyright (c) 2017-2022 Digital Asset (Switzerland) GmbH and/or its affiliates. All rights reserved.
# SPDX-License-Identifier: Apache-2.0
# fmt: off
# isort: skip_file

import builtins as _builtins, sys, typing as _typing

from google.protobuf.internal.containers import RepeatedCompositeFieldContainer, RepeatedScalarFieldContainer
from google.protobuf.message import Message as _Message
from google.protobuf.timestamp_pb2 import Timestamp

from .completion_pb2 import Completion
from .ledger_offset_pb2 import LedgerOffset

if sys.version_info >= (3, 8):
    from typing import Literal as _L
else:
    from typing_extensions import Literal as _L

__all__ = [
    "CompletionStreamRequest",
    "CompletionStreamResponse",
    "Checkpoint",
    "CompletionEndRequest",
    "CompletionEndResponse",
]


class CompletionStreamRequest(_Message):
    ledger_id: _builtins.str
    application_id: _builtins.str
    @property
    def parties(self) -> RepeatedScalarFieldContainer[_builtins.str]: ...
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, ledger_id: _typing.Optional[_builtins.str] = ..., application_id: _typing.Optional[_builtins.str] = ..., parties: _typing.Optional[_typing.Iterable[_builtins.str]] = ..., offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _L["ledger_id", "application_id", "parties", "offset"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["ledger_id", "application_id", "parties", "offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CompletionStreamResponse(_Message):
    @property
    def checkpoint(self) -> Checkpoint: ...
    @property
    def completions(self) -> RepeatedCompositeFieldContainer[Completion]: ...
    def __init__(self, *, checkpoint: _typing.Optional[Checkpoint] = ..., completions: _typing.Optional[_typing.Iterable[Completion]] = ...): ...
    def HasField(self, field_name: _L["checkpoint", "completions"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["checkpoint", "completions"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class Checkpoint(_Message):
    @property
    def record_time(self) -> Timestamp: ...
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, record_time: _typing.Optional[Timestamp] = ..., offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _L["record_time", "offset"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["record_time", "offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CompletionEndRequest(_Message):
    ledger_id: _builtins.str
    def __init__(self, *, ledger_id: _typing.Optional[_builtins.str] = ...): ...
    def HasField(self, field_name: _L["ledger_id"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["ledger_id"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...

class CompletionEndResponse(_Message):
    @property
    def offset(self) -> LedgerOffset: ...
    def __init__(self, *, offset: _typing.Optional[LedgerOffset] = ...): ...
    def HasField(self, field_name: _L["offset"]) -> _builtins.bool: ...
    def ClearField(self, field_name: _L["offset"]) -> None: ...
    def WhichOneof(self, oneof_group: _typing.NoReturn) -> _typing.NoReturn: ...
