# AoE2ScenarioParser

This is a project for editing parts of an `aoe2scenario` file from **Age of Empires 2 Definitive Edition** outside of
the in-game editor.

Documentation can be found on the [readthedocs] page.

**For now**, some of the documentation can also be found here on github:

- [Triggers Cheatsheet]
- [Units Cheatsheet]
- [Datasets Cheatsheet]

[readthedocs]: https://aoe2scenarioparser.readthedocs.io/en/master/

[triggers cheatsheet]: ./cheatsheets/TRIGGERS.md

[units cheatsheet]: ./cheatsheets/UNITS.md

[datasets cheatsheet]: ./cheatsheets/DATASETS.md

# Progress

Current up-to-date progress can be found on the [changelog.md] page. (Check the `dev` branch for non-released progress).

[changelog.md]: ./changelog.md

## Features:

|            | View               | Add                | Edit               | Remove             |
| ---------- | ------------------ | ------------------ | ------------------ | ------------------ |
| Triggers   | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| Conditions | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| Effects    | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| Units      | n/a                | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |
| Map        | n/a                | :heavy_check_mark: | :heavy_check_mark: | :heavy_check_mark: |

&nbsp;

## Support:

| Scenario file version | Read               | Write              | Reference                                                                                                                                                                                                                                                                                                                                                                                             |
| ------------- | ------------------ | ------------------ | -----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------                                                                                                                                                   |
| 1.36          | :heavy_check_mark: | :heavy_check_mark: | Version since the **release of the Definitive Edition**
| 1.37          | :heavy_check_mark: | :heavy_check_mark: | Version since game update: [35584] (February 27th, 2020) <br> **Unchanged in**: <br> - Update [36202] (March 30th, 2020) <br> - Update [36906] (April 29th, 2020) <br> - Update [37650] (May 27th, 2020) <br> - Hotfix [37906] (June 2nd, 2020) <br> - Update [39284] (July 20th, 2020) <br> - Hotfix [39515] (July 27th, 2020) <br> - Update [40220] (August 24th, 2020) <br> - Update [40874] (September 22nd, 2020) <br> - Update [41855] (October 20th, 2020) |
| 1.40          | :heavy_check_mark: | :heavy_check_mark: | Version since game update: [42848] (November 17th, 2020) <br> **Unchanged in**: <br> - Hotfix [43210] (November 24th, 2020)                                                                                                                                                                                                                                                                                       |
| 1.41          | :heavy_check_mark: | :heavy_check_mark: | Version since game update: [44725] (January 25th, 2021) <br> **Unchanged in**: <br> - Hotfix [44834] (January 28th, 2021)<br> - Hotfix [45185] (February 11th, 2021)<br> - Update [46265] (March 24th, 2021)<br> - Update [47820] (May 3rd, 2021)                                                                                                                                                                                                                                                                                             |
| 1.42          | :heavy_check_mark: | :heavy_check_mark: | Version since game update: [50292] (July 6th, 2021)

[35584]: https://www.ageofempires.com/news/aoe2de-update-35584/
[36202]: https://www.ageofempires.com/news/aoe2de-update-36202/
[36906]: https://www.ageofempires.com/news/aoe2de-update-36906/
[37650]: https://www.ageofempires.com/news/aoe2de-update-37650/
[37906]: https://www.ageofempires.com/news/aoe2de-hotfix-37906/
[39284]: https://www.ageofempires.com/news/aoe2de-update-39284/
[39515]: https://www.ageofempires.com/news/aoe2de-hotfix-39515/
[40220]: https://www.ageofempires.com/news/aoe2de-update-40220/
[40874]: https://www.ageofempires.com/news/aoe2de-update-40874/
[41855]: https://www.ageofempires.com/news/aoe2de-update-41855/
[42848]: https://www.ageofempires.com/news/aoe2de-update-42848/
[43210]: https://www.ageofempires.com/news/aoe2de-hotfix-43210/
[44725]: https://www.ageofempires.com/news/aoeiide-update-44725/
[44834]: https://www.ageofempires.com/news/aoeiide-update-44725#hotfix-44834
[45185]: https://www.ageofempires.com/news/aoe2de-hotfix-45185/
[46265]: https://www.ageofempires.com/news/aoe2de-update-46295/
[47820]: https://www.ageofempires.com/news/aoe2de-update-47820/
[50292]: https://www.ageofempires.com/news/aoe2de-update-50292/

# Authors

- Kerwin Sneijders (Main Author)

# License

GNU General Public License v3.0: Please see the [LICENSE file].

[license file]: https://github.com/KSneijders/AoE2ScenarioParser/blob/dev/LICENSE
