"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ApiDestination = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const connection_1 = require("./connection");
const events_generated_1 = require("./events.generated");
/**
 * Define an EventBridge Api Destination
 *
 * @resource AWS::Events::ApiDestination
 */
class ApiDestination extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, {
            physicalName: props.apiDestinationName,
        });
        jsiiDeprecationWarnings._aws_cdk_aws_events_ApiDestinationProps(props);
        this.connection = props.connection;
        let apiDestination = new events_generated_1.CfnApiDestination(this, 'ApiDestination', {
            connectionArn: this.connection.connectionArn,
            description: props.description,
            httpMethod: (_b = props.httpMethod) !== null && _b !== void 0 ? _b : connection_1.HttpMethod.POST,
            invocationEndpoint: props.endpoint,
            invocationRateLimitPerSecond: props.rateLimitPerSecond,
            name: this.physicalName,
        });
        this.apiDestinationName = this.getResourceNameAttribute(apiDestination.ref);
        this.apiDestinationArn = apiDestination.attrArn;
    }
}
exports.ApiDestination = ApiDestination;
_a = JSII_RTTI_SYMBOL_1;
ApiDestination[_a] = { fqn: "@aws-cdk/aws-events.ApiDestination", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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