"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Archive = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const events_generated_1 = require("./events.generated");
const util_1 = require("./util");
/**
 * Define an EventBridge Archive
 *
 * @resource AWS::Events::Archive
 */
class Archive extends core_1.Resource {
    constructor(scope, id, props) {
        var _b;
        super(scope, id, { physicalName: props.archiveName });
        jsiiDeprecationWarnings._aws_cdk_aws_events_ArchiveProps(props);
        let archive = new events_generated_1.CfnArchive(this, 'Archive', {
            sourceArn: props.sourceEventBus.eventBusArn,
            description: props.description,
            eventPattern: util_1.renderEventPattern(props.eventPattern),
            retentionDays: ((_b = props.retention) === null || _b === void 0 ? void 0 : _b.toDays({ integral: true })) || 0,
            archiveName: this.physicalName,
        });
        this.archiveArn = archive.attrArn;
        this.archiveName = archive.attrArchiveName;
    }
}
exports.Archive = Archive;
_a = JSII_RTTI_SYMBOL_1;
Archive[_a] = { fqn: "@aws-cdk/aws-events.Archive", version: "1.148.0" };
//# sourceMappingURL=data:application/json;base64,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