"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Jenkins = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdk8s = require("cdk8s");
const constructs_1 = require("constructs");
const jenkins = require("./imports/jenkins.io");
/**
 * A jenkins instance.
 */
class Jenkins extends constructs_1.Construct {
    constructor(scope, id, props = {}) {
        super(scope, id);
        this._plugins = props.plugins ?? [];
        this._seedJobs = props.seedJobs ?? [];
        this._basePlugins = new Map([
            ['kubernetes', '1.31.3'],
            ['workflow-job', '1145.v7f2433caa07f'],
            ['workflow-aggregator', '2.6'],
            ['git', '4.10.3'],
            ['job-dsl', '1.78.1'],
            ['configuration-as-code', '1414.v878271fc496f'],
            ['kubernetes-credentials-provider', '0.20'],
        ]);
        this.addBasePlugins(...(props.basePlugins ?? []));
        const metadata = {
            ...props.metadata,
            namespace: props.metadata?.namespace ?? 'default',
            labels: props.metadata?.labels ?? { app: 'jenkins' },
        };
        const authorizationStrategy = 'createUser';
        const disableCSRFProtection = props.disableCsrfProtection ?? false;
        // Keeping container resources defaults similar to Jenkins defaults here: https://jenkinsci.github.io/kubernetes-operator/docs/getting-started/latest/installing-the-operator/
        const containers = [
            {
                name: 'jenkins-master',
                image: 'jenkins/jenkins:lts',
                imagePullPolicy: 'Always',
                resources: {
                    limits: {
                        cpu: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('1500m'),
                        memory: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('3Gi'),
                    },
                    requests: {
                        cpu: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('1'),
                        memory: jenkins.JenkinsSpecMasterContainersResourcesLimits.fromString('500M'),
                    },
                },
            },
        ];
        ;
        const jenkinsCustomResource = new jenkins.Jenkins(this, 'Default', {
            metadata: metadata,
            spec: {
                groovyScripts: {
                    configurations: [],
                    secret: {
                        name: '',
                    },
                },
                configurationAsCode: {
                    configurations: [],
                    secret: {
                        name: '',
                    },
                },
                jenkinsApiSettings: {
                    authorizationStrategy: authorizationStrategy,
                },
                master: {
                    disableCsrfProtection: disableCSRFProtection,
                    containers: containers,
                    basePlugins: cdk8s.Lazy.any({
                        produce: () => {
                            return Array.from(this._basePlugins, ([key, value]) => {
                                return {
                                    name: key,
                                    version: value,
                                };
                            });
                        },
                    }),
                    plugins: cdk8s.Lazy.any({
                        produce: () => {
                            return this._plugins;
                        },
                    }),
                },
                seedJobs: cdk8s.Lazy.any({
                    produce: () => {
                        return this._seedJobs;
                    },
                }),
            },
        });
        this.node.defaultChild = jenkinsCustomResource;
    }
    /**
     * Add base plugins to jenkins instance.
     * @param basePlugins List of base plugins.
     */
    addBasePlugins(...basePlugins) {
        for (const basePlugin of basePlugins) {
            this._basePlugins.set(basePlugin.name, basePlugin.version);
        }
    }
    /**
     * Add custom plugins to jenkins instance.
     * @param plugins List of custom plugins.
     */
    addPlugins(...plugins) {
        this._plugins.push(...plugins);
    }
    /**
     * Add seed jobs to jenkins instance.
     * @param seedJobs List of seed jobs.
     */
    addSeedJobs(...seedJobs) {
        this._seedJobs.push(...seedJobs);
    }
}
exports.Jenkins = Jenkins;
_a = JSII_RTTI_SYMBOL_1;
Jenkins[_a] = { fqn: "cdk8s-jenkins.Jenkins", version: "0.0.53" };
//# sourceMappingURL=data:application/json;base64,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