<div align="center">

<img src="https://docs.getpropheto.com/logo-light.svg">

<p align="center">
  <a href="https://getpropheto.com/">Website</a> •
  <a href="https://docs.getpropheto.com/">Docs</a>
</p>

[![PyPI - Propheto Version](https://img.shields.io/pypi/v/zenml.svg?label=pip&logo=PyPI&logoColor=white)](https://pypi.org/project/propheto/)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/propheto)](https://pypi.org/project/propheto/)
[![PyPI Status](https://pepy.tech/badge/propheto)](https://pepy.tech/project/propheto)
![GitHub](https://img.shields.io/github/license/propheto-io/propheto)

</div>


# Propheto - Open ML Platform 

Propheto is a flexible, high-performance framework for deploying, managing, and monitoring models. Using Propheto, data scientists can quickly and easily deploy their models as complete, fully functioning microservices. Propheto allows:

- Integration first to support all major data systems, ML frameworks, amd MLOps tools
- No vendor lock in so you can use all the tools and systems your team needs
- Real-time or batch prediction endpoints with minimal overhead and maximum parallelism
- Easy debugging, testing, and versioning for model pipelines
- Security first architecture with portability across cloud and on-prem environments
- Open-core but designed for enterprise (automated logging, monitoring, and documentation)

With only a few simple commands in their IDE (jupyter notebooks, VS Code, Pycharm, etc.) data scientists can deploy models in their cloud architecture with all of the logging, tracking, scaling, and reporting required.

The Propheto package works with all major system architectures so that it can easily integrate into the production data and software applications and can easily be managed by other DevOps or software engineering resources. However, Propheto also makes it such that data scientists can self-manage these resources without any burden and without working through these other teams.

It is quick and easy to get up and running with Propheto. Data scientists can install Propheto using tools like pip, conda, and R’s CRAN package library. With a simple authentication import statement, data scientists can then use Propheto’s packages to seamlessly interact with their AWS, GCP, Azure, or other cloud or on-premise system architecture as needed.

Ready to get started? checkout our [Quickstart guide](https://docs.getpropheto.com/quickstart/) or [sample notebook](https://github.com/Propheto-io/propheto/blob/main/docs/Propheto%20Iris%20Classification.ipynb) or [download the notebook directly](https://raw.githubusercontent.com/Propheto-io/propheto/main/docs/Propheto%20Iris%20Classification.ipynb) to see Propheto in action.
