DEFAULT_TEAM_NAME_1 = 'Defaulticons'
DEFAULT_TEAM_NAME_2 = 'Standardators'
STALEMATE_CHECK_PERIOD = 1
COLLECTABLE_COIN_LIFETIME = 20
TICK_PERIOD = 0.05
MAX_PLAYER_NAME_LENGTH = 30

# The time after a zone tag after which there is 50% of a new
# collectable coin appearing every STALEMATE_CHECK_PERIOD.
ZONE_TAG_COIN_HALF_LIFE = 60

GAME_STATE_CHECK_PERIOD = 5
RABBIT_CHASING_PERIOD = 60

ZONE_CAP_DISTANCE = 35

MULTICAST_PROTOCOL_NAME = b'TrosnothMulticastProtocol1'

MAP_TO_SCREEN_SCALE = 1.25

BODY_BLOCK_MAP_SIZE = (1024, 384)
BODY_BLOCK_SCREEN_SIZE = (
    int(BODY_BLOCK_MAP_SIZE[0] * MAP_TO_SCREEN_SCALE + 0.5),
    int(BODY_BLOCK_MAP_SIZE[1] * MAP_TO_SCREEN_SCALE + 0.5),
)
INTERFACE_BLOCK_MAP_SIZE = (512, 384)
INTERFACE_BLOCK_SCREEN_SIZE = (
    int(INTERFACE_BLOCK_MAP_SIZE[0] * MAP_TO_SCREEN_SCALE + 0.5),
    int(INTERFACE_BLOCK_MAP_SIZE[1] * MAP_TO_SCREEN_SCALE + 0.5),
)
ZONE_SIZE = (2048, 768)


# When a client is found to be lagging, this is the number of extra frames of
# delay that's added (on top of the measured lag), to prevent lots of resyncs
# in quick succession.
LAG_BUFFER = 1
LAG_THRESHOLD = 5
INITIAL_ASSUMED_LATENCY = int(0.3 / TICK_PERIOD)
DEFAULT_RESYNC_MESSAGE = 'Resynced your computer with server'

PATH_FINDING_DISCRETISATION_UNIT = 4


# Player lifeStates
ALIVE_STATE = b'O'
PHANTOM_STATE = b'-'
ALL_DEAD_STATE = b'X'


# hitKinds
SHOT_HIT = b'S'
GRENADE_HIT = b'G'
SHOXWAVE_HIT = b'W'
MINE_HIT = b'M'
OFF_MAP_DEATH_HIT = b'O'
TROSBALL_DEATH_HIT = b'B'
BOMBER_DEATH_HIT = b'X'
CUSTOM_HIT = b'L'

SHOXWAVE_RADIUS = 128


# ChatMsg kinds
OPEN_CHAT = b'o'
PRIVATE_CHAT = b'p'
TEAM_CHAT = b't'


# CannotBuyUpgradeMsg reasons
NOT_ENOUGH_COINS_REASON = b'N'
CANNOT_REACTIVATE_REASON = b'A'
PLAYER_DEAD_REASON = b'D'
GAME_NOT_STARTED_REASON = b'P'
PLAYER_HAS_TROSBALL_REASON = b'T'
TOO_CLOSE_TO_EDGE_REASON = b'E'
TOO_CLOSE_TO_ORB_REASON = b'O'
NOT_IN_DARK_ZONE_REASON = b'F'
INVALID_UPGRADE_REASON = b'I'
DISABLED_UPGRADE_REASON = b'X'
INVALID_REQUEST_REASON = b'Z'


# CannotJoinMsg reasons
GAME_FULL_REASON = b'F'
UNAUTHORISED_REASON = b'A'
NICK_USED_REASON = b'N'
BAD_NICK_REASON = b'B'
USER_IN_GAME_REASON = b'U'
ALREADY_JOINED_REASON = b'J'


# CannotRespawnMsg reasons
RESYNC_IN_PROGRESS_REASON = b'r'
# GAME_NOT_STARTED_REASON = b'P' (defined above)
ALREADY_ALIVE_REASON = b'A'
BE_PATIENT_REASON = b'T'
ENEMY_ZONE_REASON = b'E'
FROZEN_ZONE_REASON = b'F'

# GrapplingHook states
HOOK_FIRING = b'F'
HOOK_ATTACHED = b'A'
HOOK_RETURNING = b'R'
HOOK_NOT_ACTIVE = b'N'

HOOK_EXTEND_SPEED = 3000
HOOK_RETRACT_SPEED = 3000
HOOK_PULL_PLAYER_SPEED = 600
HOOK_BREAK_SPEED = 1000
HOOK_LENGTH = 500


DEFAULT_COIN_VALUE = 50
COINS_PER_KILL = 50
COINS_PER_NEUTRAL_CAP = 50
COINS_PER_ENEMY_CAP = 100
COINS_PER_ZONE_NEUTRALISED = 50
COIN_FACTOR_FOR_ASSIST = 0.8
BONUS_COINS_PER_5_SECONDS = 10
BONUS_COINS_FOR_TROSBALL_SCORE = 300
BONUS_COINS_FOR_RABBIT_SURVIVAL = 500


DEATH_TAX_RATE = 0.35
DEATH_TAX_FREE_THRESHOLD = 250
DEATH_MAX_COIN_COUNT = 5


FRONT_LINE_NORMAL = 'normal'
FRONT_LINE_TROSBALL = 'trosball'


# Keyboard / menu actions
ACTION_LEFT = 'left'
ACTION_DOWN = 'down'
ACTION_RIGHT = 'right'
ACTION_JUMP = 'jump'
ACTION_SHOW_TRAJECTORY = 'trajectory'
ACTION_DEBUGKEY = 'debugkey'

ACTION_NEXT_WEAPON = 'next weapon'
ACTION_PREVIOUS_WEAPON = 'previous weapon'
ACTION_BUY_AMMO = 'buy ammo'
ACTION_FOLLOW = 'follow'    # Used in observer/replay mode
ACTION_MAIN_MENU = 'main menu'
ACTION_SETTINGS_MENU = 'settings'
ACTION_JOIN_GAME = 'join'
ACTION_QUIT_MENU = 'maybeLeave'
ACTION_REALLY_QUIT = 'leave'

ACTION_HOOK = 'hook'
ACTION_RESPAWN = 'respawn'
ACTION_USE_UPGRADE = 'activate upgrade'
ACTION_ABANDON_UPGRADE = 'abandon'
ACTION_RADIAL_UPGRADE_MENU = 'radial upgrade'
ACTION_CLEAR_UPGRADE = 'no upgrade'
ACTION_READY = 'ready'
ACTION_CHAT = 'chat'
ACTION_TERMINAL_TOGGLE = 'toggle terminal'
ACTION_PAUSE_GAME = 'pause'
ACTION_EMOTE = 'emote'
ACTION_CONTRIBUTE_TO_TEAM_BOOST = 'contribute'
ACTION_NEXT_TEAM_BOOST = 'next boost'

KEY_UP = '-up'


EMOTE_BOOGIE = 0
EMOTE_CHARLESTON = 1
EMOTE_WAVE = 2

MAX_EMOTE = EMOTE_WAVE


BOT_GOAL_NONE = 'none'
BOT_GOAL_CAPTURE_MAP = 'cap'
BOT_GOAL_HUNT_RABBITS = 'hunt'
BOT_GOAL_SCORE_TROSBALL_POINT = 'ball'
BOT_GOAL_KILL_THINGS = 'kill'
BOT_GOAL_COWARDLY_CAPTURE = 'sneak'


ACHIEVEMENT_TACTICAL = 'tactical'
ACHIEVEMENT_TERRITORY = 'territory'
ACHIEVEMENT_AFTER_GAME = 'after'

DEFAULT_SERVER_PORT = 6780
DEFAULT_GAME_PORT = 6789

# Game statistics
POINT_VALUES = {
    'kills': 10,
    'deaths': 1,
    'zoneTags': 10,
    'accuracy': 20,
    'coinsUsed': 0.03,
    'zoneScore': 10,
}

LEFT_STATE = b'left'
RIGHT_STATE = b'right'
JUMP_STATE = b'jump'
DOWN_STATE = b'down'


# Team colours
TEAM_1_COLOUR = (0, 96, 255)
TEAM_2_COLOUR = (255, 0, 0)

HEAD_CUEBALL = 0
HEAD_BLACKHAT = 1
HEAD_WHITEHAT = 2
HEAD_BERET = 3
HEAD_AFRO = 4
HEAD_BLONDIE = 5
HEAD_BOT = 6
HEAD_MEGAN = 7
HEAD_HAIRBUN = 8

HEADS_ORDER = [
    HEAD_CUEBALL, HEAD_BLONDIE, HEAD_BERET, HEAD_HAIRBUN,
    HEAD_AFRO, HEAD_MEGAN, HEAD_WHITEHAT, HEAD_BLACKHAT]
HEAD_LOCATIONS = {
    HEAD_CUEBALL: (0, 0),
    HEAD_BOT: (3, 0),
    HEAD_BLACKHAT: (0, 1),
    HEAD_WHITEHAT: (3, 1),
    HEAD_BERET: (0, 2),
    HEAD_AFRO: (3, 2),
    HEAD_BLONDIE: (0, 3),
    HEAD_MEGAN: (3, 3),
    HEAD_HAIRBUN: (0, 4),
}


DEFAULT_ELEPHANT_NAME = 'Jerakeen'


BOT_DIFFICULTY_EASY = 20
BOT_DIFFICULTY_MEDIUM = 50
BOT_DIFFICULTY_HARD = 80
DEFAULT_BOT_DIFFICULTY = BOT_DIFFICULTY_MEDIUM

# Bot settings are (pause, perfectionism, dodging) where pause is the
# number of ticks to pause between each action, perfectionism is a
# fraction indicating how perfect the path-finding should be, and
# dodging is a boolean indicating whether or not the bot should try to
# dodge bullets.
BOT_DIFFICULTIES = {
    BOT_DIFFICULTY_EASY: (4, 0.4, False),
    BOT_DIFFICULTY_MEDIUM: (2, 0.7, False),
    BOT_DIFFICULTY_HARD: (0, 0.9, True),
}

DISCONNECT_IDLE_GHOST_AFTER = 30


MINIMAP_NORMAL = 0
MINIMAP_PARTLY_DISRUPTED = 1
MINIMAP_FULLY_DISRUPTED = 2


# Declarative interface event kinds
MOUSE_DOWN = 0
MOUSE_UP = 1