# Generated by Django 2.2.12 on 2021-09-26 10:14

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('trosnoth', '0033_trosnotharena_extra_bot_count'),
    ]

    operations = [
        migrations.CreateModel(
            name='SignUp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField()),
                ('description', models.TextField()),
                ('enabled', models.BooleanField(default=True)),
            ],
        ),
        migrations.CreateModel(
            name='SignUpTeam',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField()),
                ('signup', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='trosnoth.SignUp')),
            ],
        ),
        migrations.CreateModel(
            name='SignUpPlayer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('nick', models.TextField(verbose_name='Nick')),
                ('team_admin', models.BooleanField()),
                ('signup', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='trosnoth.SignUp')),
                ('team', models.ForeignKey(null=True, on_delete=django.db.models.deletion.SET_NULL, to='trosnoth.SignUpTeam')),
                ('user', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='trosnoth.TrosnothUser')),
            ],
        ),
        migrations.AddConstraint(
            model_name='signupteam',
            constraint=models.UniqueConstraint(fields=('signup', 'name'), name='unique name within signup'),
        ),
        migrations.AddConstraint(
            model_name='signupplayer',
            constraint=models.UniqueConstraint(fields=('signup', 'user'), name='unique player in signup'),
        ),
        migrations.AddConstraint(
            model_name='signupplayer',
            constraint=models.UniqueConstraint(fields=('signup', 'nick'), name='unique nick in signup'),
        ),
    ]
