import { Construct } from 'constructs';
import { ICommandComponent } from '../construct/document-component';
import { CommandStep } from '../parent-steps/command-step';
import { CommandDocumentBuilder } from './document-builder';
import { SsmDocumentProps, SsmDocument } from './ssm-document';
export interface CommandDocumentProps extends SsmDocumentProps {
}
/**
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html
 * The CommandDocument will delegate execution responsibility to the CammandSteps that it receives.
 * The SsmDocument parent class contains methods to runSimulation() as well as print().
 */
export declare class CommandDocument extends SsmDocument {
    readonly builder: CommandDocumentBuilder;
    constructor(scope: Construct, id: string, props: CommandDocumentProps);
    addStep(component: ICommandComponent): void;
    protected buildSsmDocument(): {
        [p: string]: any;
    };
    collectedSteps(): CommandStep[];
    documentType(): string;
}
