/**
 * Represents an AWS service.
 * The namespace which is meant to be used for the service declaration in SSM may be difficult to guess.
 * The name provided for simulation may at times be different.
 * This class provides many ready-to-use implementations of AWS services.
 * If a service is not on the list, you can fall back to constructing this object on your own.
 * In other words, you can reference S3 using `AwsService.S3`
 * For a NewService, you can reference it using `new AwsService('new-service', 'NewService')`.
 * It is risky to auto convert between namespace and javaScriptName because they are not consistent in all cases.
 */
export declare class AwsService {
    static readonly ACCESS_ANALYZER: AwsService;
    static readonly ACCOUNT: AwsService;
    static readonly ACM: AwsService;
    static readonly ACMPCA: AwsService;
    static readonly ALEXA_FOR_BUSINESS: AwsService;
    static readonly AMP: AwsService;
    static readonly AMPLIFY: AwsService;
    static readonly AMPLIFY_BACKEND: AwsService;
    static readonly AMPLIFY_UI_BUILDER: AwsService;
    static readonly APIGATEWAY: AwsService;
    static readonly API_GATEWAY_MANAGEMENT_API: AwsService;
    static readonly API_GATEWAY_V2: AwsService;
    static readonly APP_CONFIG: AwsService;
    static readonly APP_CONFIG_DATA: AwsService;
    static readonly APPFLOW: AwsService;
    static readonly APP_INTEGRATIONS: AwsService;
    static readonly APPLICATION_AUTO_SCALING: AwsService;
    static readonly APPLICATION_COST_PROFILER: AwsService;
    static readonly APPLICATION_INSIGHTS: AwsService;
    static readonly APP_MESH: AwsService;
    static readonly APP_RUNNER: AwsService;
    static readonly APP_STREAM: AwsService;
    static readonly APP_SYNC: AwsService;
    static readonly ATHENA: AwsService;
    static readonly AUDIT_MANAGER: AwsService;
    static readonly AUTO_SCALING: AwsService;
    static readonly AUTO_SCALING_PLANS: AwsService;
    static readonly BACKUP: AwsService;
    static readonly BACKUP_GATEWAY: AwsService;
    static readonly BACKUP_STORAGE: AwsService;
    static readonly BATCH: AwsService;
    static readonly BILLINGCONDUCTOR: AwsService;
    static readonly BRAKET: AwsService;
    static readonly BUDGETS: AwsService;
    static readonly CHIME: AwsService;
    static readonly CHIME_SDK_IDENTITY: AwsService;
    static readonly CHIME_SDK_MEDIA_PIPELINES: AwsService;
    static readonly CHIME_SDK_MEETINGS: AwsService;
    static readonly CHIME_SDK_MESSAGING: AwsService;
    static readonly CLOUD9: AwsService;
    static readonly CLOUD_CONTROL: AwsService;
    static readonly CLOUD_DIRECTORY: AwsService;
    static readonly CLOUD_FORMATION: AwsService;
    static readonly CLOUD_FRONT: AwsService;
    static readonly CLOUD_HS_M: AwsService;
    static readonly CLOUD_HSM_V2: AwsService;
    static readonly CLOUD_SEARCH: AwsService;
    static readonly CLOUD_SEARCH_DOMAIN: AwsService;
    static readonly CLOUD_TRAIL: AwsService;
    static readonly CLOUD_WATCH: AwsService;
    static readonly CODE_ARTIFACT: AwsService;
    static readonly CODE_BUILD: AwsService;
    static readonly CODE_COMMIT: AwsService;
    static readonly CODE_DEPLOY: AwsService;
    static readonly CODE_GURU_PROFILER: AwsService;
    static readonly CODE_GURU_REVIEWER: AwsService;
    static readonly CODE_PIPELINE: AwsService;
    static readonly CODE_STAR: AwsService;
    static readonly CODE_STARCONNECTIONS: AwsService;
    static readonly CODE_STAR_NOTIFICATIONS: AwsService;
    static readonly COGNITO_IDENTITY: AwsService;
    static readonly COGNITO_SYNC: AwsService;
    static readonly COMPREHEND: AwsService;
    static readonly COMPREHEND_MEDICAL: AwsService;
    static readonly COMPUTE_OPTIMIZER: AwsService;
    static readonly CONNECT: AwsService;
    static readonly CONNECT_CAMPAIGNS: AwsService;
    static readonly CONNECT_CASES: AwsService;
    static readonly CONNECT_CONTACT_LENS: AwsService;
    static readonly CONNECT_PARTICIPANT: AwsService;
    static readonly CONTROL_TOWER: AwsService;
    static readonly CUR: AwsService;
    static readonly CUSTOMER_PROFILES: AwsService;
    static readonly DATA_BREW: AwsService;
    static readonly DATA_EXCHANGE: AwsService;
    static readonly DATA_PIPELINE: AwsService;
    static readonly DATA_SYNC: AwsService;
    static readonly DAX: AwsService;
    static readonly DETECTIVE: AwsService;
    static readonly DEVICE_FARM: AwsService;
    static readonly DEV_OPS_GURU: AwsService;
    static readonly DIRECT_CONNECT: AwsService;
    static readonly DISCOVERY: AwsService;
    static readonly DLM: AwsService;
    static readonly DMS: AwsService;
    static readonly DOC_DB: AwsService;
    static readonly DRS: AwsService;
    static readonly DYNAMO_DB: AwsService;
    static readonly DYNAMO_DB_STREAMS: AwsService;
    static readonly EBS: AwsService;
    static readonly EC2: AwsService;
    static readonly EC2_INSTANCE_CONNECT: AwsService;
    static readonly ECR: AwsService;
    static readonly ECRPUBLIC: AwsService;
    static readonly ECS: AwsService;
    static readonly EFS: AwsService;
    static readonly EKS: AwsService;
    static readonly ELASTI_CACHE: AwsService;
    static readonly ELASTIC_BEANSTALK: AwsService;
    static readonly ELASTIC_INFERENCE: AwsService;
    static readonly ELASTIC_TRANSCODER: AwsService;
    static readonly ELB: AwsService;
    static readonly ELBV2: AwsService;
    static readonly EMR: AwsService;
    static readonly EMRCONTAINERS: AwsService;
    static readonly EMRSERVERLESS: AwsService;
    static readonly ES: AwsService;
    static readonly EVIDENTLY: AwsService;
    static readonly FINSPACE: AwsService;
    static readonly FINSPACEDATA: AwsService;
    static readonly FIREHOSE: AwsService;
    static readonly FIS: AwsService;
    static readonly FMS: AwsService;
    static readonly FRAUD_DETECTOR: AwsService;
    static readonly FSX: AwsService;
    static readonly GAME_LIFT: AwsService;
    static readonly GAME_SPARKS: AwsService;
    static readonly GLACIER: AwsService;
    static readonly GLOBAL_ACCELERATOR: AwsService;
    static readonly GLUE: AwsService;
    static readonly GRAFANA: AwsService;
    static readonly GREENGRASS: AwsService;
    static readonly GREENGRASS_V2: AwsService;
    static readonly GROUND_STATION: AwsService;
    static readonly GUARD_DUTY: AwsService;
    static readonly HEALTH: AwsService;
    static readonly HEALTH_LAKE: AwsService;
    static readonly HONEYCODE: AwsService;
    static readonly IAM: AwsService;
    static readonly IDENTITY_STORE: AwsService;
    static readonly IMAGEBUILDER: AwsService;
    static readonly IMPORT_EXPORT: AwsService;
    static readonly INSPECTOR: AwsService;
    static readonly INSPECTOR2: AwsService;
    static readonly IOT: AwsService;
    static readonly IO_T1_CLICK_PROJECTS: AwsService;
    static readonly IO_T_ANALYTICS: AwsService;
    static readonly IOT_DATA: AwsService;
    static readonly IOT_DEVICE_ADVISOR: AwsService;
    static readonly IOT_EVENTS: AwsService;
    static readonly IOT_EVENTS_DATA: AwsService;
    static readonly IOT_FLEET_HUB: AwsService;
    static readonly IOT_FLEET_WISE: AwsService;
    static readonly IOT_SECURE_TUNNELING: AwsService;
    static readonly IOT_SITE_WISE: AwsService;
    static readonly IOT_THINGS_GRAPH: AwsService;
    static readonly IOT_TWIN_MAKER: AwsService;
    static readonly IOT_WIRELESS: AwsService;
    static readonly IVS: AwsService;
    static readonly IVSCHAT: AwsService;
    static readonly KAFKA: AwsService;
    static readonly KAFKA_CONNECT: AwsService;
    static readonly KENDRA: AwsService;
    static readonly KEYSPACES: AwsService;
    static readonly KINESIS: AwsService;
    static readonly KINESIS_ANALYTICS: AwsService;
    static readonly KINESIS_ANALYTICS_V2: AwsService;
    static readonly KINESIS_VIDEO: AwsService;
    static readonly KINESIS_VIDEO_ARCHIVED_MEDIA: AwsService;
    static readonly KINESIS_VIDEO_MEDIA: AwsService;
    static readonly KMS: AwsService;
    static readonly LAKE_FORMATION: AwsService;
    static readonly LAMBDA: AwsService;
    static readonly LEX_RUNTIME: AwsService;
    static readonly LICENSE_MANAGER: AwsService;
    static readonly LICENSE_MANAGER_USER_SUBSCRIPTIONS: AwsService;
    static readonly LIGHTSAIL: AwsService;
    static readonly LOCATION: AwsService;
    static readonly LOOKOUT_EQUIPMENT: AwsService;
    static readonly LOOKOUT_METRICS: AwsService;
    static readonly LOOKOUT_VISION: AwsService;
    static readonly M2: AwsService;
    static readonly MACHINE_LEARNING: AwsService;
    static readonly MACIE: AwsService;
    static readonly MACIE2: AwsService;
    static readonly MANAGED_BLOCKCHAIN: AwsService;
    static readonly MARKETPLACE_CATALOG: AwsService;
    static readonly MARKETPLACE_COMMERCE_ANALYTICS: AwsService;
    static readonly MEDIA_CONNECT: AwsService;
    static readonly MEDIA_CONVERT: AwsService;
    static readonly MEDIA_LIVE: AwsService;
    static readonly MEDIA_PACKAGE: AwsService;
    static readonly MEDIA_PACKAGE_VOD: AwsService;
    static readonly MEDIA_STORE: AwsService;
    static readonly MEDIA_STORE_DATA: AwsService;
    static readonly MEDIA_TAILOR: AwsService;
    static readonly MEMORY_DB: AwsService;
    static readonly MGN: AwsService;
    static readonly MIGRATION_HUB_CONFIG: AwsService;
    static readonly MIGRATION_HUB_ORCHESTRATOR: AwsService;
    static readonly MIGRATION_HUB_REFACTOR_SPACES: AwsService;
    static readonly MIGRATION_HUB_STRATEGY: AwsService;
    static readonly MOBILE: AwsService;
    static readonly MQ: AwsService;
    static readonly MTURK: AwsService;
    static readonly MWAA: AwsService;
    static readonly NEPTUNE: AwsService;
    static readonly NETWORK_FIREWALL: AwsService;
    static readonly NETWORK_MANAGER: AwsService;
    static readonly NIMBLE: AwsService;
    static readonly OPEN_SEARCH: AwsService;
    static readonly OPS_WORKS: AwsService;
    static readonly OPS_WORKS_C_M: AwsService;
    static readonly ORGANIZATIONS: AwsService;
    static readonly OUTPOSTS: AwsService;
    static readonly PANORAMA: AwsService;
    static readonly PERSONALIZE: AwsService;
    static readonly PERSONALIZE_EVENTS: AwsService;
    static readonly PERSONALIZE_RUNTIME: AwsService;
    static readonly PI: AwsService;
    static readonly PINPOINT: AwsService;
    static readonly PINPOINT_EMAIL: AwsService;
    static readonly PINPOINT_SMS_VOICE: AwsService;
    static readonly PINPOINT_SMS_VOICE_V2: AwsService;
    static readonly POLLY: AwsService;
    static readonly PRICING: AwsService;
    static readonly PRIVATE_NETWORKS: AwsService;
    static readonly PROTON: AwsService;
    static readonly QLDB: AwsService;
    static readonly QLDB_SESSION: AwsService;
    static readonly QUICK_SIGHT: AwsService;
    static readonly RAM: AwsService;
    static readonly RBIN: AwsService;
    static readonly RDS: AwsService;
    static readonly REDSHIFT: AwsService;
    static readonly REDSHIFT_DATA: AwsService;
    static readonly REDSHIFT_SERVERLESS: AwsService;
    static readonly REKOGNITION: AwsService;
    static readonly RESILIENCEHUB: AwsService;
    static readonly RESOURCE_EXPLORER2: AwsService;
    static readonly RESOURCE_GROUPS: AwsService;
    static readonly RESOURCE_GROUPS_TAGGING_AP_I: AwsService;
    static readonly ROBO_MAKER: AwsService;
    static readonly ROLES_ANYWHERE: AwsService;
    static readonly ROUTE53: AwsService;
    static readonly ROUTE53_DOMAINS: AwsService;
    static readonly ROUTE53_RECOVERY_CLUSTER: AwsService;
    static readonly ROUTE53_RECOVERY_CONTROL_CONFIG: AwsService;
    static readonly ROUTE53_RECOVERY_READINESS: AwsService;
    static readonly ROUTE53_RESOLVER: AwsService;
    static readonly RUM: AwsService;
    static readonly S3: AwsService;
    static readonly S3_CONTROL: AwsService;
    static readonly S3_OUTPOSTS: AwsService;
    static readonly SAGE_MAKER: AwsService;
    static readonly SAGEMAKER_EDGE: AwsService;
    static readonly SAGE_MAKER_FEATURE_STORE_RUNTIME: AwsService;
    static readonly SAGE_MAKER_RUNTIME: AwsService;
    static readonly SAVINGS_PLANS: AwsService;
    static readonly SCHEDULER: AwsService;
    static readonly SCHEMAS: AwsService;
    static readonly SECRETS_MANAGER: AwsService;
    static readonly SECURITY_HUB: AwsService;
    static readonly SERVICE_CATALOG: AwsService;
    static readonly SERVICE_CATALOG_APP_REGISTRY: AwsService;
    static readonly SERVICE_DISCOVERY: AwsService;
    static readonly SERVICE_QUOTAS: AwsService;
    static readonly SES: AwsService;
    static readonly SES_V2: AwsService;
    static readonly SHIELD: AwsService;
    static readonly SIGNER: AwsService;
    static readonly SMS: AwsService;
    static readonly SNOWBALL: AwsService;
    static readonly SNOW_DEVICE_MANAGEMENT: AwsService;
    static readonly SNS: AwsService;
    static readonly SQS: AwsService;
    static readonly SSM: AwsService;
    static readonly SSM_CONTACTS: AwsService;
    static readonly SSM_INCIDENTS: AwsService;
    static readonly SSO: AwsService;
    static readonly SSO_ADMIN: AwsService;
    static readonly SSO_OIDC: AwsService;
    static readonly STEP_FUNCTIONS: AwsService;
    static readonly STORAGE_GATEWAY: AwsService;
    static readonly STS: AwsService;
    static readonly SUPPORT: AwsService;
    static readonly SUPPORT_APP: AwsService;
    static readonly SWF: AwsService;
    static readonly SYNTHETICS: AwsService;
    static readonly TEXTRACT: AwsService;
    static readonly TIMESTREAM_QUERY: AwsService;
    static readonly TIMESTREAM_WRITE: AwsService;
    static readonly TRANSFER: AwsService;
    static readonly TRANSLATE: AwsService;
    static readonly VOICE_I_D: AwsService;
    static readonly WAF: AwsService;
    static readonly WAF_REGIONAL: AwsService;
    static readonly WAF_V2: AwsService;
    static readonly WELL_ARCHITECTED: AwsService;
    static readonly WISDOM: AwsService;
    static readonly WORK_DOCS: AwsService;
    static readonly WORK_LINK: AwsService;
    static readonly WORK_MAIL: AwsService;
    static readonly WORK_MAIL_MESSAGE_FLOW: AwsService;
    static readonly WORK_SPACES: AwsService;
    static readonly WORK_SPACES_WEB: AwsService;
    static readonly XRAY: AwsService;
    /**
     * Used for declaration in SSM Automation document.
     */
    readonly namespace: string;
    /**
     * Used for simulation of service requests using the simulated execution.
     */
    readonly javaScriptName: string;
    constructor(namespace: string, javaScriptName: string);
    toJSON(): string;
}
