"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.MockAwsInvoker = exports.ReflectiveAwsInvoker = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const immutable_1 = require("immutable");
const synchronous_promise_1 = require("../sync/synchronous-promise");
/**
 * Implementation of IAwsInvoker that executes the AWS api for real.
 * If using this implementation, be sure that AWS credentials are available to the execution.
 */
class ReflectiveAwsInvoker {
    invoke(invocation) {
        const wrappedAwsResponse = new synchronous_promise_1.SynchronousPromise().wait('../../lib/sync/aws-async-invoker', 'AwsAsyncInvoker', [invocation.service.javaScriptName, invocation.awsApi, invocation.awsParams]);
        if (wrappedAwsResponse == undefined) {
            throw new Error(`Exception occurred calling AWS API with ${JSON.stringify(invocation)}. Please ensure that your service name is correct.`);
        }
        if (wrappedAwsResponse.status == 'FAILURE') {
            console.error(`Exception occurred calling AWS API with ${JSON.stringify(invocation)}: ${wrappedAwsResponse.Payload}`);
            throw new Error(wrappedAwsResponse.Payload);
        }
        else {
            return wrappedAwsResponse.Payload;
        }
    }
}
exports.ReflectiveAwsInvoker = ReflectiveAwsInvoker;
_a = JSII_RTTI_SYMBOL_1;
ReflectiveAwsInvoker[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ReflectiveAwsInvoker", version: "0.0.32" };
/**
 * Mock implementation of IAwsInvoker.
 * This class can be reused for testing in exported JSII languages.
 */
class MockAwsInvoker {
    constructor() {
        /**
         * All of the invocations that have been submitted to this invoker until present.
         */
        this.previousInvocations = [];
        this.mockReturn = [];
        // @ts-ignore
        this.mockResponses = new immutable_1.Map({});
    }
    /**
     * Saves the invocation to be retrieved using getInvocations().
     * @returns the next result as set by the setReturn function
     */
    invoke(invocation) {
        const immutableInvocation = {
            service: invocation.service.namespace,
            api: invocation.awsApi,
            params: invocation.awsParams,
        };
        this.previousInvocations.push(invocation);
        if (this.mockResponses.has(immutable_1.fromJS(immutableInvocation))) {
            return this.mockResponses.get(immutable_1.fromJS(immutableInvocation));
        }
        return this.mockReturn.shift() || this.lastReturn;
    }
    /**
     * Set the next return value. This function can be chained to return subsequent return values.
     * Values are read in order they were inserted.
     * The last value is used as a default if there are no other values retrieved.
     * In that way this function behaves the same way as Mockito .thenReturn(val).
     */
    nextReturn(awsResult) {
        this.mockReturn.push(awsResult);
        this.lastReturn = awsResult;
        return this;
    }
    /**
     * Allows developers to mock out responses from the AwsInvoker depending on the input that it receives.
     * @param when defines the invocation to match and return the then
     * @param then is the value that should be returned if the above when Invocation is matched
     */
    whenThen(when, then) {
        const immutableWhen = {
            service: when.service.namespace,
            api: when.awsApi,
            params: when.awsParams,
        };
        this.mockResponses = this.mockResponses.set(immutable_1.fromJS(immutableWhen), then);
        console.log(this.mockResponses);
    }
}
exports.MockAwsInvoker = MockAwsInvoker;
_b = JSII_RTTI_SYMBOL_1;
MockAwsInvoker[_b] = { fqn: "@cdklabs/cdk-ssm-documents.MockAwsInvoker", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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