"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.RefreshAssociationStep = void 0;
const platform_1 = require("../../domain/platform");
const command_step_1 = require("../command-step");
/**
 * CommandStep implemenation for aws:refreshAssociation
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-refreshassociation
 */
class RefreshAssociationStep extends command_step_1.CommandStep {
    constructor(scope, id, props) {
        super(scope, id, props);
        this.platforms = [platform_1.Platform.WINDOWS, platform_1.Platform.LINUX, platform_1.Platform.MAC_OS];
        this.action = 'aws:refreshAssociation';
        this.associationIds = props.associationIds;
    }
    /**
     * Input required for this command is associationIds
     */
    listInputs() {
        const inputs = [
            this.associationIds,
        ];
        return inputs.flatMap(i => i?.requiredInputs() ?? []);
    }
    toSsmEntry() {
        const inputs = {};
        if (this.associationIds != undefined) {
            inputs.associationIds = this.associationIds;
        }
        return super.prepareSsmEntry(inputs);
    }
}
exports.RefreshAssociationStep = RefreshAssociationStep;
//# sourceMappingURL=data:application/json;base64,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