"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RebootInstanceAndWait = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_resource_step_1 = require("../../parent-steps/automation/wait-for-resource-step");
const composite_step_1 = require("./composite-step");
const aws_service_1 = require("../../domain/aws-service");
class RebootInstanceAndWait extends composite_step_1.CompositeAutomationStep {
    constructor(scope, id, instanceId) {
        super(scope, id);
        this.reboot = new aws_api_step_1.AwsApiStep(this, 'RebootInstances', {
            service: aws_service_1.AwsService.EC2,
            pascalCaseApi: 'RebootInstances',
            apiParams: { InstanceIds: [instanceId] },
            outputs: [],
        });
        this.describe = new wait_for_resource_step_1.WaitForResourceStep(this, 'DescribeInstances', {
            service: aws_service_1.AwsService.EC2,
            pascalCaseApi: 'DescribeInstances',
            apiParams: { InstanceIds: [instanceId] },
            selector: '$.Reservations[0].Instances[0].State.Name',
            desiredValues: ['running'],
        });
    }
    addToDocument(doc) {
        doc.addStep(this.reboot);
        doc.addStep(this.describe);
    }
}
exports.RebootInstanceAndWait = RebootInstanceAndWait;
_a = JSII_RTTI_SYMBOL_1;
RebootInstanceAndWait[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RebootInstanceAndWait", version: "0.0.32" };
//# sourceMappingURL=data:application/json;base64,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