"""
Django settings for user project.

Generated by 'django-admin startproject' using Django 3.1.4.

For more information on this file, see
https://docs.djangoproject.com/en/3.1/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/3.1/ref/settings/
"""
from .base import *  # noqa: F401, F403
import os  # noqa: F401
from pathlib import Path    # noqa: F401

# SECURITY WARNING: keep the secret key used in production secret!
SECRET_KEY = config('SECRET_KEY')  # noqa


# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = True

ALLOWED_HOSTS = ['*']


# Application definition

INSTALLED_APPS.extend([  # noqa: F405
    'drf_yasg',
])

INTERNAL_IPS = [
    '127.0.0.1',
]

ROOT_URLCONF = 'user.urls'


# Database
# https://docs.djangoproject.com/en/3.1/ref/settings/#databases

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.sqlite3',
        'NAME': BASE_DIR / 'db.sqlite3',        # noqa: F405
    }
}

EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'
EMAIL_USE_LOCALTIME = True

SERVER_EMAIL = 'crouber_test@crouber.com'
DEFAULT_FROM_EMAIL = SERVER_EMAIL
