import { S as SvelteComponent, i as init, s as safe_not_equal, e as element, c as create_component, a as space, b as attr, f as insert, g as append, m as mount_component, a3 as set_input_value, l as listen, ah as to_number, j as transition_in, k as transition_out, n as detach, o as destroy_component, z as run_all, E as createEventDispatcher, t as text, h as set_data, P as assign, Q as StatusTracker, H as binding_callbacks, N as bind, R as get_spread_update, T as get_spread_object, K as add_flush_callback, J as bubble } from './index.4e854d0e.js';
import { B as Block } from './Block.29b25e3f.js';
import { B as BlockTitle } from './BlockTitle.85f1213e.js';
import './styles.ed3b21b5.js';

/* home/runner/work/gradio/gradio/ui/packages/form/src/Range.svelte generated by Svelte v3.49.0 */

function create_default_slot$1(ctx) {
	let t;

	return {
		c() {
			t = text(/*label*/ ctx[5]);
		},
		m(target, anchor) {
			insert(target, t, anchor);
		},
		p(ctx, dirty) {
			if (dirty & /*label*/ 32) set_data(t, /*label*/ ctx[5]);
		},
		d(detaching) {
			if (detaching) detach(t);
		}
	};
}

function create_fragment$1(ctx) {
	let div1;
	let div0;
	let label_1;
	let blocktitle;
	let t0;
	let input0;
	let t1;
	let input1;
	let current;
	let mounted;
	let dispose;

	blocktitle = new BlockTitle({
			props: {
				show_label: /*show_label*/ ctx[6],
				$$slots: { default: [create_default_slot$1] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			div1 = element("div");
			div0 = element("div");
			label_1 = element("label");
			create_component(blocktitle.$$.fragment);
			t0 = space();
			input0 = element("input");
			t1 = space();
			input1 = element("input");
			attr(label_1, "for", /*id*/ ctx[7]);
			attr(input0, "type", "number");
			attr(input0, "class", "gr-box gr-input gr-text-input text-center h-6");
			attr(input0, "min", /*minimum*/ ctx[1]);
			attr(input0, "max", /*maximum*/ ctx[2]);
			attr(input0, "step", /*step*/ ctx[3]);
			input0.disabled = /*disabled*/ ctx[4];
			attr(div0, "class", "flex justify-between");
			attr(div1, "class", "w-full flex flex-col ");
			attr(input1, "type", "range");
			attr(input1, "id", /*id*/ ctx[7]);
			attr(input1, "name", "cowbell");
			attr(input1, "class", "w-full disabled:cursor-not-allowed");
			attr(input1, "min", /*minimum*/ ctx[1]);
			attr(input1, "max", /*maximum*/ ctx[2]);
			attr(input1, "step", /*step*/ ctx[3]);
			input1.disabled = /*disabled*/ ctx[4];
		},
		m(target, anchor) {
			insert(target, div1, anchor);
			append(div1, div0);
			append(div0, label_1);
			mount_component(blocktitle, label_1, null);
			append(div0, t0);
			append(div0, input0);
			set_input_value(input0, /*value*/ ctx[0]);
			insert(target, t1, anchor);
			insert(target, input1, anchor);
			set_input_value(input1, /*value*/ ctx[0]);
			current = true;

			if (!mounted) {
				dispose = [
					listen(input0, "input", /*input0_input_handler*/ ctx[9]),
					listen(input1, "change", /*input1_change_input_handler*/ ctx[10]),
					listen(input1, "input", /*input1_change_input_handler*/ ctx[10])
				];

				mounted = true;
			}
		},
		p(ctx, [dirty]) {
			const blocktitle_changes = {};
			if (dirty & /*show_label*/ 64) blocktitle_changes.show_label = /*show_label*/ ctx[6];

			if (dirty & /*$$scope, label*/ 4128) {
				blocktitle_changes.$$scope = { dirty, ctx };
			}

			blocktitle.$set(blocktitle_changes);

			if (!current || dirty & /*minimum*/ 2) {
				attr(input0, "min", /*minimum*/ ctx[1]);
			}

			if (!current || dirty & /*maximum*/ 4) {
				attr(input0, "max", /*maximum*/ ctx[2]);
			}

			if (!current || dirty & /*step*/ 8) {
				attr(input0, "step", /*step*/ ctx[3]);
			}

			if (!current || dirty & /*disabled*/ 16) {
				input0.disabled = /*disabled*/ ctx[4];
			}

			if (dirty & /*value*/ 1 && to_number(input0.value) !== /*value*/ ctx[0]) {
				set_input_value(input0, /*value*/ ctx[0]);
			}

			if (!current || dirty & /*minimum*/ 2) {
				attr(input1, "min", /*minimum*/ ctx[1]);
			}

			if (!current || dirty & /*maximum*/ 4) {
				attr(input1, "max", /*maximum*/ ctx[2]);
			}

			if (!current || dirty & /*step*/ 8) {
				attr(input1, "step", /*step*/ ctx[3]);
			}

			if (!current || dirty & /*disabled*/ 16) {
				input1.disabled = /*disabled*/ ctx[4];
			}

			if (dirty & /*value*/ 1) {
				set_input_value(input1, /*value*/ ctx[0]);
			}
		},
		i(local) {
			if (current) return;
			transition_in(blocktitle.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(blocktitle.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			if (detaching) detach(div1);
			destroy_component(blocktitle);
			if (detaching) detach(t1);
			if (detaching) detach(input1);
			mounted = false;
			run_all(dispose);
		}
	};
}

let _id = 0;

function instance$1($$self, $$props, $$invalidate) {
	let { value = 0 } = $$props;
	let { style = {} } = $$props;
	let { minimum = 0 } = $$props;
	let { maximum = 100 } = $$props;
	let { step = 1 } = $$props;
	let { disabled = false } = $$props;
	let { label } = $$props;
	let { show_label } = $$props;
	const id = `range_id_${_id++}`;
	const dispatch = createEventDispatcher();

	function input0_input_handler() {
		value = to_number(this.value);
		$$invalidate(0, value);
	}

	function input1_change_input_handler() {
		value = to_number(this.value);
		$$invalidate(0, value);
	}

	$$self.$$set = $$props => {
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('style' in $$props) $$invalidate(8, style = $$props.style);
		if ('minimum' in $$props) $$invalidate(1, minimum = $$props.minimum);
		if ('maximum' in $$props) $$invalidate(2, maximum = $$props.maximum);
		if ('step' in $$props) $$invalidate(3, step = $$props.step);
		if ('disabled' in $$props) $$invalidate(4, disabled = $$props.disabled);
		if ('label' in $$props) $$invalidate(5, label = $$props.label);
		if ('show_label' in $$props) $$invalidate(6, show_label = $$props.show_label);
	};

	$$self.$$.update = () => {
		if ($$self.$$.dirty & /*value*/ 1) {
			dispatch("change", value);
		}
	};

	return [
		value,
		minimum,
		maximum,
		step,
		disabled,
		label,
		show_label,
		id,
		style,
		input0_input_handler,
		input1_change_input_handler
	];
}

class Range extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance$1, create_fragment$1, safe_not_equal, {
			value: 0,
			style: 8,
			minimum: 1,
			maximum: 2,
			step: 3,
			disabled: 4,
			label: 5,
			show_label: 6
		});
	}
}

/* src/components/Slider/Slider.svelte generated by Svelte v3.49.0 */

function create_default_slot(ctx) {
	let statustracker;
	let t;
	let range;
	let updating_value;
	let current;
	const statustracker_spread_levels = [/*loading_status*/ ctx[10]];
	let statustracker_props = {};

	for (let i = 0; i < statustracker_spread_levels.length; i += 1) {
		statustracker_props = assign(statustracker_props, statustracker_spread_levels[i]);
	}

	statustracker = new StatusTracker({ props: statustracker_props });

	function range_value_binding(value) {
		/*range_value_binding*/ ctx[11](value);
	}

	let range_props = {
		label: /*label*/ ctx[3],
		show_label: /*show_label*/ ctx[9],
		minimum: /*minimum*/ ctx[5],
		maximum: /*maximum*/ ctx[6],
		step: /*step*/ ctx[7],
		style: /*style*/ ctx[4],
		disabled: /*mode*/ ctx[8] === "static"
	};

	if (/*value*/ ctx[0] !== void 0) {
		range_props.value = /*value*/ ctx[0];
	}

	range = new Range({ props: range_props });
	binding_callbacks.push(() => bind(range, 'value', range_value_binding));
	range.$on("change", /*change_handler*/ ctx[12]);

	return {
		c() {
			create_component(statustracker.$$.fragment);
			t = space();
			create_component(range.$$.fragment);
		},
		m(target, anchor) {
			mount_component(statustracker, target, anchor);
			insert(target, t, anchor);
			mount_component(range, target, anchor);
			current = true;
		},
		p(ctx, dirty) {
			const statustracker_changes = (dirty & /*loading_status*/ 1024)
			? get_spread_update(statustracker_spread_levels, [get_spread_object(/*loading_status*/ ctx[10])])
			: {};

			statustracker.$set(statustracker_changes);
			const range_changes = {};
			if (dirty & /*label*/ 8) range_changes.label = /*label*/ ctx[3];
			if (dirty & /*show_label*/ 512) range_changes.show_label = /*show_label*/ ctx[9];
			if (dirty & /*minimum*/ 32) range_changes.minimum = /*minimum*/ ctx[5];
			if (dirty & /*maximum*/ 64) range_changes.maximum = /*maximum*/ ctx[6];
			if (dirty & /*step*/ 128) range_changes.step = /*step*/ ctx[7];
			if (dirty & /*style*/ 16) range_changes.style = /*style*/ ctx[4];
			if (dirty & /*mode*/ 256) range_changes.disabled = /*mode*/ ctx[8] === "static";

			if (!updating_value && dirty & /*value*/ 1) {
				updating_value = true;
				range_changes.value = /*value*/ ctx[0];
				add_flush_callback(() => updating_value = false);
			}

			range.$set(range_changes);
		},
		i(local) {
			if (current) return;
			transition_in(statustracker.$$.fragment, local);
			transition_in(range.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(statustracker.$$.fragment, local);
			transition_out(range.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(statustracker, detaching);
			if (detaching) detach(t);
			destroy_component(range, detaching);
		}
	};
}

function create_fragment(ctx) {
	let block;
	let current;

	block = new Block({
			props: {
				visible: /*visible*/ ctx[2],
				elem_id: /*elem_id*/ ctx[1],
				disable: typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container,
				$$slots: { default: [create_default_slot] },
				$$scope: { ctx }
			}
		});

	return {
		c() {
			create_component(block.$$.fragment);
		},
		m(target, anchor) {
			mount_component(block, target, anchor);
			current = true;
		},
		p(ctx, [dirty]) {
			const block_changes = {};
			if (dirty & /*visible*/ 4) block_changes.visible = /*visible*/ ctx[2];
			if (dirty & /*elem_id*/ 2) block_changes.elem_id = /*elem_id*/ ctx[1];
			if (dirty & /*style*/ 16) block_changes.disable = typeof /*style*/ ctx[4].container === "boolean" && !/*style*/ ctx[4].container;

			if (dirty & /*$$scope, label, show_label, minimum, maximum, step, style, mode, value, loading_status*/ 10233) {
				block_changes.$$scope = { dirty, ctx };
			}

			block.$set(block_changes);
		},
		i(local) {
			if (current) return;
			transition_in(block.$$.fragment, local);
			current = true;
		},
		o(local) {
			transition_out(block.$$.fragment, local);
			current = false;
		},
		d(detaching) {
			destroy_component(block, detaching);
		}
	};
}

function instance($$self, $$props, $$invalidate) {
	let { elem_id = "" } = $$props;
	let { visible = true } = $$props;
	let { value = 0 } = $$props;
	let { label = "Slider" } = $$props;
	let { style = {} } = $$props;
	let { minimum } = $$props;
	let { maximum } = $$props;
	let { step } = $$props;
	let { mode } = $$props;
	let { show_label } = $$props;
	let { loading_status } = $$props;

	function range_value_binding(value$1) {
		value = value$1;
		$$invalidate(0, value);
	}

	function change_handler(event) {
		bubble.call(this, $$self, event);
	}

	$$self.$$set = $$props => {
		if ('elem_id' in $$props) $$invalidate(1, elem_id = $$props.elem_id);
		if ('visible' in $$props) $$invalidate(2, visible = $$props.visible);
		if ('value' in $$props) $$invalidate(0, value = $$props.value);
		if ('label' in $$props) $$invalidate(3, label = $$props.label);
		if ('style' in $$props) $$invalidate(4, style = $$props.style);
		if ('minimum' in $$props) $$invalidate(5, minimum = $$props.minimum);
		if ('maximum' in $$props) $$invalidate(6, maximum = $$props.maximum);
		if ('step' in $$props) $$invalidate(7, step = $$props.step);
		if ('mode' in $$props) $$invalidate(8, mode = $$props.mode);
		if ('show_label' in $$props) $$invalidate(9, show_label = $$props.show_label);
		if ('loading_status' in $$props) $$invalidate(10, loading_status = $$props.loading_status);
	};

	return [
		value,
		elem_id,
		visible,
		label,
		style,
		minimum,
		maximum,
		step,
		mode,
		show_label,
		loading_status,
		range_value_binding,
		change_handler
	];
}

class Slider extends SvelteComponent {
	constructor(options) {
		super();

		init(this, options, instance, create_fragment, safe_not_equal, {
			elem_id: 1,
			visible: 2,
			value: 0,
			label: 3,
			style: 4,
			minimum: 5,
			maximum: 6,
			step: 7,
			mode: 8,
			show_label: 9,
			loading_status: 10
		});
	}
}

var Slider$1 = Slider;

const modes = ["static", "dynamic"];

export { Slider$1 as Component, modes };
