# coding: utf-8

"""
    MailSlurp API

    MailSlurp is an API for sending and receiving emails from dynamically allocated email addresses. It's designed for developers and QA teams to test applications, process inbound emails, send templated notifications, attachments, and more.  ## Resources  - [Homepage](https://www.mailslurp.com) - Get an [API KEY](https://app.mailslurp.com/sign-up/) - Generated [SDK Clients](https://www.mailslurp.com/docs/) - [Examples](https://github.com/mailslurp/examples) repository   # noqa: E501

    The version of the OpenAPI document: 6.5.2
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from mailslurp_client.configuration import Configuration


class CreateWebhookOptions(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'basic_auth': 'BasicAuthOptions',
        'event_name': 'str',
        'name': 'str',
        'url': 'str'
    }

    attribute_map = {
        'basic_auth': 'basicAuth',
        'event_name': 'eventName',
        'name': 'name',
        'url': 'url'
    }

    def __init__(self, basic_auth=None, event_name=None, name=None, url=None, local_vars_configuration=None):  # noqa: E501
        """CreateWebhookOptions - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._basic_auth = None
        self._event_name = None
        self._name = None
        self._url = None
        self.discriminator = None

        if basic_auth is not None:
            self.basic_auth = basic_auth
        if event_name is not None:
            self.event_name = event_name
        if name is not None:
            self.name = name
        if url is not None:
            self.url = url

    @property
    def basic_auth(self):
        """Gets the basic_auth of this CreateWebhookOptions.  # noqa: E501


        :return: The basic_auth of this CreateWebhookOptions.  # noqa: E501
        :rtype: BasicAuthOptions
        """
        return self._basic_auth

    @basic_auth.setter
    def basic_auth(self, basic_auth):
        """Sets the basic_auth of this CreateWebhookOptions.


        :param basic_auth: The basic_auth of this CreateWebhookOptions.  # noqa: E501
        :type: BasicAuthOptions
        """

        self._basic_auth = basic_auth

    @property
    def event_name(self):
        """Gets the event_name of this CreateWebhookOptions.  # noqa: E501

        Optional webhook event name. Default is `EMAIL_RECEIVED`. Payload differ according to the webhook event name.  # noqa: E501

        :return: The event_name of this CreateWebhookOptions.  # noqa: E501
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name):
        """Sets the event_name of this CreateWebhookOptions.

        Optional webhook event name. Default is `EMAIL_RECEIVED`. Payload differ according to the webhook event name.  # noqa: E501

        :param event_name: The event_name of this CreateWebhookOptions.  # noqa: E501
        :type: str
        """
        allowed_values = ["EMAIL_RECEIVED", "NEW_EMAIL", "NEW_CONTACT", "NEW_ATTACHMENT"]  # noqa: E501
        if self.local_vars_configuration.client_side_validation and event_name not in allowed_values:  # noqa: E501
            raise ValueError(
                "Invalid value for `event_name` ({0}), must be one of {1}"  # noqa: E501
                .format(event_name, allowed_values)
            )

        self._event_name = event_name

    @property
    def name(self):
        """Gets the name of this CreateWebhookOptions.  # noqa: E501

        Optional name for the webhook  # noqa: E501

        :return: The name of this CreateWebhookOptions.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this CreateWebhookOptions.

        Optional name for the webhook  # noqa: E501

        :param name: The name of this CreateWebhookOptions.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def url(self):
        """Gets the url of this CreateWebhookOptions.  # noqa: E501

        Public URL on your server that MailSlurp can post WebhookNotification payload to when an email is received. The payload of the submitted JSON is described by https://api.mailslurp.com/schemas/webhook-payload  # noqa: E501

        :return: The url of this CreateWebhookOptions.  # noqa: E501
        :rtype: str
        """
        return self._url

    @url.setter
    def url(self, url):
        """Sets the url of this CreateWebhookOptions.

        Public URL on your server that MailSlurp can post WebhookNotification payload to when an email is received. The payload of the submitted JSON is described by https://api.mailslurp.com/schemas/webhook-payload  # noqa: E501

        :param url: The url of this CreateWebhookOptions.  # noqa: E501
        :type: str
        """

        self._url = url

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CreateWebhookOptions):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, CreateWebhookOptions):
            return True

        return self.to_dict() != other.to_dict()
