# wikipediarevs

If you have a file of Wikipedia article URLs wikipediarevs will get the page revisions for all of them (one JSON file per revision).

## Install

First you will need to install it:

    pip3 install wikipediarevs

## Collect

If you have a file `urls.txt` that looks like:

```
https://en.wikipedia.org/wiki/Jerry_Carl
https://en.wikipedia.org/wiki/Barry_Moore_(Alabama_politician)
https://en.wikipedia.org/wiki/Mike_Rogers_(Alabama_politician)
```

you can collect all the revisions:

```
wikipediarevs urls.txt
```

And you will get a directory structure something like this:

```

revisions
└── en.wikipedia.org
    ├── Barry_Moore_(Alabama_politician)
    │   ├── 892845554.json
    │   ├── 1084971549.json
    │   ├── 1084973620.json
    │   ├── 1087341166.json
    │   ├── 1088959683.json
    │   ├── 1089941112.json
    │   ├── 1095013401.json
    │   ├── 1095424530.json
    │   ├── 1096851491.json
    │   ├── 1096851727.json
    │   ├── 1096851780.json
    │   ├── 1100621349.json
    │   ├── 1102369880.json
    │   ├── 1104083178.json
    │   ├── 1107953086.json
    │   └── 1113571598.json
    ├── Jerry_Carl
    │   ├── 925987048.json
    │   ├── 1095423558.json
    │   ├── 1096851560.json
    │   ├── 1096851726.json
    │   ├── 1096851781.json
    │   ├── 1102368118.json
    │   ├── 1104083039.json
    │   ├── 1107373062.json
    │   ├── 1107951565.json
    │   └── 1113570755.json
    └── Mike_Rogers_(Alabama_politician)
        ├── 1031350801.json
        ├── 1031481925.json
        ├── 1033842549.json
        ├── 1035777659.json
        ├── 1036331683.json
        ├── 1038178596.json
        ├── 1038553883.json
        ├── 1043357304.json
        ├── 1043357479.json
        ├── 1046065138.json
        ├── 1052177616.json
        ├── 1059647767.json
        ├── 1063156704.json
        ├── 1063157857.json
        ├── 1072339104.json
        ├── 1072854739.json
        ├── 1075086554.json
        ├── 1078049733.json
        ├── 1079797305.json
        ├── 1095020232.json
        ├── 1096851592.json
        ├── 1096851737.json
        ├── 1096851793.json
        ├── 1105148833.json
        └── 1114637456.json
```

Each revision looks something like:

```json
{
  "revid": 1005821213,
  "parentid": 1005623810,
  "user": "2600:1700:B190:9700:286F:D8B0:9F50:6AA4",
  "anon": "",
  "userid": 0,
  "timestamp": "2021-02-09T15:54:05Z",
  "size": 17239,
  "sha1": "a96f10c0aefe01a5d55069b6704b1d5525147594",
  "roles": [
    "main"
  ],
  "contentmodel": "wikitext",
  "parsetree": "<root><template><title>Use mdy dates</title><part><name>date</name><equals>=</equals><value>November 2020</value></part></template>\n<template lineStart=\"1\"><title>short description</title><part><name index=\"1\"/><value>American politician</value></part></template>\n<template lineStart=\"1\"><title>Infobox officeholder\n</title><part><name>name         </name><equals>=</equals><value> Barry Moore\n</value></part><part><name>image        </name><equals>=</equals><value> Barry Moore 117th U.S Congress.jpg\n</value></part><part><name>state        </name><equals>=</equals><value> [[Alabama]]\n</value></part><part><name>district     </name><equals>=</equals><value> <template><title>ushr</title><part><name index=\"1\"/><value>AL</value></part><part><name index=\"2\"/><value>2</value></part><part><name index=\"3\"/><value>2nd</value></part></template>\n</value></part><part><name>term_start   </name><equals>=</equals><value> January 3, 2021\n</value></part><part><name>term_end     </name><equals>=</equals><value> \n</value></part><part><name>predecessor  </name><equals>=</equals><value> [[Martha Roby]]\n</value></part><part><name>successor    </name><equals>=</equals><value> \n</value></part><part><name>state_house1 </name><equals>=</equals><value> Alabama\n</value></part><part><name>district1    </name><equals>=</equals><value> 91st\n</value></part><part><name>term_start1  </name><equals>=</equals><value> November 3, 2010\n</value></part><part><name>term_end1    </name><equals>=</equals><value> November 7, 2018\n</value></part><part><name>predecessor1 </name><equals>=</equals><value> [[Terry Spicer]]\n</value></part><part><name>successor1   </name><equals>=</equals><value> Rhett Marques\n</value></part><part><name>birth_name</name><equals>=</equals><value>Felix Barry Moore\n</value></part><part><name>birth_date   </name><equals>=</equals><value> <template><title>birth date and age</title><part><name index=\"1\"/><value>1966</value></part><part><name index=\"2\"/><value>9</value></part><part><name index=\"3\"/><value>26</value></part></template>\n</value></part><part><name>birth_place  </name><equals>=</equals><value> [[Enterprise, Alabama]], U.S.\n</value></part><part><name>death_date   </name><equals>=</equals><value> \n</value></part><part><name>death_place  </name><equals>=</equals><value> \n</value></part><part><name>party        </name><equals>=</equals><value> [[Republican Party (United States)|Republican]]\n</value></part><part><name>spouse       </name><equals>=</equals><value> <template><title>marriage</title><part><name index=\"1\"/><value>Heather Hopper</value></part><part><name index=\"2\"/><value>1992</value></part></template>\n</value></part><part><name>education    </name><equals>=</equals><value> [[Enterprise State Community College]] ([[Associate of Science|AS]])&lt;br&gt;[[Auburn University]] ([[Bachelor of Science|BS]])\n</value></part><part><name>website      </name><equals>=</equals><value> <template><title>url</title><part><name index=\"1\"/><value>barrymoore.house.gov</value></part><part><name index=\"2\"/><value>House website</value></part></template>\n</value></part><part><name> signature   </name><equals>=</equals><value> Barrymooresig.png\n</value></part></template>\n'''Felix Barry Moore''' (born September 26, 1966) is an American politician serving as the [[United States House of Representatives|U.S. Representative]] for [[Alabama's 2nd congressional district]] since 2021. Before his election to the United States House of Representatives, he served as a member of the [[Alabama House of Representatives]] from the 91st district from 2010 to 2018.<ext><name>ref</name><attr/><inner>{{cite web|url=http://www.legislature.state.al.us/aliswww/ISD/ALRepresentative.aspx?OID_SPONSOR=86005&amp;OID_PERSON=6676 |archive-url=https://web.archive.org/web/20170204071509/http://www.legislature.state.al.us/aliswww/ISD/ALRepresentative.aspx?OID_SPONSOR=86005&amp;OID_PERSON=6676 |url-status=dead |archive-date=February 4, 2017 |title=Barry Moore |publisher=Legislature.state.al.us |access-date=April 17, 2019}}</inner><close>&lt;/ref&gt;</close></ext>\n\nIn May 2017, Moore announced his intention to run for the U.S. House of Representatives for [[Alabama's 2nd congressional district]] against [[incumbent]] [[Republican Party (United States)|Republican]] representative [[Martha Roby]].<ext><name>ref</name><attr/><inner>{{Cite web|url=https://www.al.com/news/2017/05/rep_barry_moore_to_challenge_m.html|title=Barry Moore challenging Martha Roby for House seat|date=May 12, 2017|website=al}}</inner><close>&lt;/ref&gt;</close></ext> He finished third in the [[2018 United States House of Representatives elections in Alabama#District 2|2018 Republican primary]]. After Roby announced in July 2019 that she would not run for reelection in [[2020 United States House of Representatives elections in Alabama#District 2|2020]], Moore announced his candidacy for the open seat<ext><name>ref</name><attr/><inner>{{cite web|url=https://www.al.com/news/2019/08/former-state-rep-barry-moore-of-enterprise-running-for-congress.html |title=Enterprise's Barry Moore to run for U.S. House of Representatives |publisher=AL.com |date=May 5, 2019 |access-date=May 5, 2019}}</inner><close>&lt;/ref&gt;</close></ext> and advanced to a runoff election against Jeff Coleman. Moore defeated Coleman to win the Republican nomination<ext><name>ref</name><attr/><inner>{{Cite web|url=https://www.al.com/election/2020/07/barry-moore-wins-in-district-2-gop-runoff.html|title=Barry Moore wins in District 2 GOP runoff|date=July 15, 2020|website=al}}</inner><close>&lt;/ref&gt;</close></ext> and faced [[Democratic Party (United States)|Democrat]] Phyllis Harvey-Hall in the general election.\n\n<h level=\"2\" i=\"1\">==Early life and education==</h>\nBarry Moore grew up on a farm in [[Coffee County, Alabama|Coffee County]], and attended [[Enterprise State Community College]].<ext><name>ref</name><attr> name=Advertiser</attr><inner>{{cite web|url=https://www.montgomeryadvertiser.com/story/news/2020/02/14/barry-moore-hitting-veteran-status-congressional-run/4750259002/|work=[[Montgomery Advertiser]]|title=Barry Moore hitting veteran status in congressional run|author=Bryan Lyman|date=February 14, 2020|access-date=August 15, 2020}}</inner><close>&lt;/ref&gt;</close></ext><ext><name>ref</name><attr/><inner>{{Cite web|url=https://barrymooreforcongress.com/|title=Barry Moore for US Congress &amp;#124;}}</inner><close>&lt;/ref&gt;</close></ext> He later attended [[Auburn University]], where he received a degree in [[agricultural science]] in 1992. While attending Auburn, Moore was enlisted in the [[Alabama National Guard]].\n\nIn 1998, Moore founded Barry Moore Industries, a waste hauling company.\n\n<h level=\"2\" i=\"2\">==Alabama House of Representatives==</h>\nMoore was first elected to the Alabama House of Representatives in 2010, defeating Democratic incumbent [[Terry Spicer]].<ext><name>ref</name><attr> name=APRprofile</attr><inner>{{cite web|url=https://www.alreporter.com/2020/06/15/a-brief-look-at-candidate-barry-moore/|title=A brief look at candidate Barry Moore|work=Alabama Political Reporter|date=June 15, 2020|access-date=August 15, 2020|author=Bill Britt}}</inner><close>&lt;/ref&gt;</close></ext> PACs controlled by [[Mike Hubbard (politician)|Mike Hubbard]], a prominent Republican politician in Alabama and convicted felon,<ext><name>ref</name><attr/><inner>{{Cite web|last=Britt|first=Bill|date=2020-06-15|title=A brief look at candidate Barry Moore|url=https://www.alreporter.com/2020/06/15/a-brief-look-at-candidate-barry-moore/|access-date=2020-11-25|website=Alabama Political Reporter|language=en-US}}</inner><close>&lt;/ref&gt;</close></ext> contributed more than $150,000 towards his candidacy.\n\n<h level=\"2\" i=\"3\">==U.S. House of Representatives ==</h>\n\n<h level=\"3\" i=\"4\">=== Elections ===</h>\n<h level=\"4\" i=\"5\">==== 2018 ====</h>\n<template lineStart=\"1\"><title>Main</title><part><name index=\"1\"/><value>2018 United States House of Representatives elections in Alabama#District 2</value></part></template>\nIn 2018, Moore challenged incumbent U.S. Representative Martha Roby in the Republican primary for [[Alabama's 2nd congressional district|AL-02]], placing third behind Roby and former U.S. Representative [[Bobby Bright]].<ext><name>ref</name><attr> name=Advertiser</attr></ext>\n\n<h level=\"4\" i=\"6\">==== 2020 ====</h>\n<template lineStart=\"1\"><title>Main</title><part><name index=\"1\"/><value>2020 United States House of Representatives elections in Alabama#District 2</value></part></template>\nMoore again sought the nomination in 2020, placing second in the Republican primary and later defeating [[Dothan, Alabama|Dothan]] businessman Jeff Coleman in the runoff.<ext><name>ref</name><attr/><inner>{{cite web|url=https://www.montgomeryadvertiser.com/story/news/2020/07/14/barry-moore-defeats-jeff-coleman-gop-nomination-2nd-congressional-district/5429384002/|title=Barry Moore defeats Jeff Coleman for GOP nomination in 2nd Congressional District|work=Montgomery Advertiser|author=Bryan Lyman|date=July 14, 2020|access-date=August 15, 2020}}</inner><close>&lt;/ref&gt;</close></ext> Moore faced Democratic nominee Phyllis Harvey-Hall in the general election.\n\nOn November 3, 2020, Moore won the general election with 65.2 percent of the vote.\n\n<h level=\"3\" i=\"7\">=== Tenure ===</h>\n\n<h level=\"3\" i=\"8\">=== Committee assignments<ext><name>ref</name><attr/><inner>{{Cite web|title=Rep. Barry Moore to Serve on House Agriculture Committee, House Committee on Veterans\u2019 Affairs in 117th Congress {{!}} Representative Barry Moore|url=https://barrymoore.house.gov/media/press-releases/rep-barry-moore-serve-house-agriculture-committee-house-committee-veterans|access-date=2021-02-02|website=barrymoore.house.gov}}</inner><close>&lt;/ref&gt;</close></ext> ===</h>\n\n* '''[[House Agriculture Committee|Committee on Agriculture]]'''\n* '''[[House Veterans Affairs Committee|Committee on Veterans\u2019 Affairs]]'''\n\n<h level=\"3\" i=\"9\">=== Caucus memberships ===</h>\n* '''[[Freedom Caucus]]<ext><name>ref</name><attr/><inner>{{Cite web|title=House Freedom Fund|url=https://www.housefreedomfund.com/|access-date=2020-11-12|website=www.housefreedomfund.com}}</inner><close>&lt;/ref&gt;</close></ext>'''\n\n<h level=\"2\" i=\"10\">==Controversies==</h>\nTwo months after Moore was elected to the Alabama State House of Representatives in 2010, he and his wife were awarded a contract with the Alabama Department of Environmental Management (ADEM), which is notable because neither Moore nor his wife had ever held state contracts prior to his election to public office. Total payments from ADEM from Fiscal Year 2011 through 2013 totaled $64,612.<ext><name>ref</name><attr> name=&quot;Britt&quot;</attr></ext><ext><name>ref</name><attr/><inner>{{cite web|last=Britt|first=Bill|title=Rep. Barry Moore Receives Thousands in Taxpayer Dollars|url=https://www.alreporter.com/2014/03/10/rep-barry-moore-receives-thousands-in-taxpayer-dollars/|access-date=January 11, 2021|website=Alabama Political Reporter|language=en-US}}</inner><close>&lt;/ref&gt;</close></ext>\n\nIn April 2014, Moore was arrested for felony perjury and lying to authorities during a grand jury investigation into Moore's friend and mentor, [[Mike Hubbard (politician)|Mike Hubbard]].<ext><name>ref</name><attr/><inner>{{Cite web|date=April 24, 2014|title=AL Rep. Barry Moore of Enterprise arrested on felony charges|url=https://www.wsfa.com/story/25330913/al-rep-barry-moore-of-enterprise-arrested-on-felony-charges|access-date=2020-11-25|website=WSFA 12 News|language=en-US}}</inner><close>&lt;/ref&gt;</close></ext> In late 2014, Moore was acquitted of all charges.<ext><name>ref</name><attr> name=&quot;Britt&quot;</attr></ext><ext><name>ref</name><attr/><inner>{{cite web|author=Cliff Sims|title=Alabama Rep. Barry Moore not guilty on all counts|url=https://yellowhammernews.com/breaking-alabama-rep-barry-moore-guilty-counts/|access-date=August 15, 2020|work=Yellowhammer News}}</inner><close>&lt;/ref&gt;</close></ext>\n\nOn October 30, 2020, Moore's Twitter account sent a tweet advocating for higher taxes and voting restrictions for those who move from one state to another state. The tweet was deleted shortly after, and Moore's media director, Jonathan Barbee, claimed responsibility, saying that the opinion was a personal view that Moore did not share and that Barbee had intended to send the tweet from his personal account.<ext><name>ref</name><attr/><inner>{{Cite web|last=Lyman|first=Brian|date=October 30, 2020|title=Barry Moore campaign worker: I sent tweet on voting restrictions for new state residents|url=https://www.montgomeryadvertiser.com/story/news/2020/10/30/barry-moore-campaign-worker-takes-responsibility-tweet-voting-restrictions-alabama-congress/6087008002/|website=The Montgomery Advertiser}}</inner><close>&lt;/ref&gt;</close></ext>\n\nOn January 6, 2021, Moore objected to the [[2021 United States Electoral College vote count|certification]] of the [[United States Electoral College|Electoral College]] results in Congress. He was one of the 147 Republican members of Congress who voted to overturn the results of the [[2020 United States presidential election|2020 U.S. presidential election]] on January 7, 2021, immediately following the [[2021 storming of the United States Capitol|storming of the U.S. Capitol]].<ext><name>ref</name><attr/><inner>{{Cite news|last=Yourish|first=Karen|last2=Buchanan|first2=Larry|last3=Lu|first3=Denise|date=2021-01-07|title=The 147 Republicans Who Voted to Overturn Election Results|language=en-US|work=The New York Times|url=https://www.nytimes.com/interactive/2021/01/07/us/elections/electoral-college-biden-objectors.html|access-date=2021-01-11|issn=0362-4331}}</inner><close>&lt;/ref&gt;</close></ext> [[President of the United States|President]] [[Donald Trump]] and his allies had made false and baseless claims of fraud in the election, which was won by Democrat [[Joe Biden]]. subsequent objections to the Electoral College results were cited as contributory factors in the insurrection at the U.S. Capitol, which led to calls from some of Moore's colleagues for his expulsion from Congress.<ext><name>ref</name><attr/><inner>{{Cite web|last=Smith|first=Kate|title=Congresswoman proposes legislation to remove house members; including six Alabama congressmen|url=https://www.wbrc.com/2021/01/10/congresswoman-proposes-legislation-remove-house-members-including-six-alabama-congressmen/|access-date=2021-01-10|website=WBRC|language=en-US}}</inner><close>&lt;/ref&gt;</close></ext>\n\nOn January 10, 2021, Moore drew criticism for two controversial posts on Twitter, one of which echoed the of \u201cstealing an election on November 3rd.\u201d Both tweets appeared to understate the seriousness of the armed insurrection at the United States Capitol that took place four days prior on January 6, 2021, and as a result, his account was temporarily suspended by the social media platform. In response, Moore deactivated his account \u201cbecause of the censorship of conservative voices he saw happening.\u201d <ext><name>ref</name><attr/><inner>{{Cite web|last=Specker|first=Lawrence|title= Rep. Barry Moore deletes Twitter account after suspension, controversial Capitol riot tweets|url= https://www.al.com/news/mobile/2021/01/rep-barry-moore-deletes-personal-twitter-account-after-suspension.html |access-date=2021-01-11|website=AL.com|language=en-US}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"11\">== Electoral history ==</h>\n\n<template lineStart=\"1\"><title>Election box begin no change</title><part><name>title</name><equals>=</equals><value>Republican primary results, 2018</value></part></template>\n<template lineStart=\"1\"><title>Election box winning candidate with party link no change\n  </title><part><name>party </name><equals>=</equals><value> Republican Party (United States)\n  </value></part><part><name>candidate </name><equals>=</equals><value> Martha Roby (incumbent)\n  </value></part><part><name>votes </name><equals>=</equals><value> 36,708\n  </value></part><part><name>percentage </name><equals>=</equals><value> 39.0\n</value></part></template>\n<template lineStart=\"1\"><title>Election box winning candidate with party link no change\n  </title><part><name>party </name><equals>=</equals><value> Republican Party (United States)\n  </value></part><part><name>candidate </name><equals>=</equals><value> Bobby Bright\n  </value></part><part><name>votes </name><equals>=</equals><value> 26,481\n  </value></part><part><name>percentage </name><equals>=</equals><value> 28.1\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n  </title><part><name>party </name><equals>=</equals><value> Republican Party (United States)\n  </value></part><part><name>candidate </name><equals>=</equals><value> Barry Moore\n  </value></part><part><name>votes </name><equals>=</equals><value> 18,177\n  </value></part><part><name>percentage </name><equals>=</equals><value> 19.3\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n  </title><part><name>party </name><equals>=</equals><value> Republican Party (United States)\n  </value></part><part><name>candidate </name><equals>=</equals><value> Rich Hobson\n  </value></part><part><name>votes </name><equals>=</equals><value> 7,052\n  </value></part><part><name>percentage </name><equals>=</equals><value> 7.5\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n  </title><part><name>party </name><equals>=</equals><value> Republican Party (United States)\n  </value></part><part><name>candidate </name><equals>=</equals><value> Tommy Amason\n  </value></part><part><name>votes </name><equals>=</equals><value> 5,763\n  </value></part><part><name>percentage </name><equals>=</equals><value> 6.1\n</value></part></template>\n<template lineStart=\"1\"><title>Election box total no change\n  </title><part><name>votes </name><equals>=</equals><value> 94,181\n  </value></part><part><name>percentage </name><equals>=</equals><value> 100.0\n</value></part></template>\n<template lineStart=\"1\"><title>Election box end</title></template>\n\n<template lineStart=\"1\"><title>Election box begin no change\n</title><part><name> title </name><equals>=</equals><value> Republican primary results, 2020\n</value></part></template>\n<template lineStart=\"1\"><title>Election box winning candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Jeff Coleman\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 39,738\n</value></part><part><name> percentage </name><equals>=</equals><value> 38.1\n</value></part></template>\n<template lineStart=\"1\"><title>Election box winning candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Barry Moore\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 21,354\n</value></part><part><name> percentage </name><equals>=</equals><value> 20.4\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Jessica Taylor\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 20,763\n</value></part><part><name> percentage </name><equals>=</equals><value> 19.9\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> [[Troy King]]\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 15,145\n</value></part><part><name> percentage </name><equals>=</equals><value> 14.5\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Terri Hasdorff\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 5,207\n</value></part><part><name> percentage </name><equals>=</equals><value> 5.0\n</value></part></template>\n<template lineStart=\"1\"><title>Election box  candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Thomas W. Brown\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 1,395\n</value></part><part><name> percentage </name><equals>=</equals><value> 1.3\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Bob Rogers\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 824\n</value></part><part><name> percentage </name><equals>=</equals><value> 0.8\n</value></part></template>\n<template lineStart=\"1\"><title>Election box total no change\n</title><part><name> votes </name><equals>=</equals><value> 104,426\n</value></part><part><name> percentage </name><equals>=</equals><value> 100.0%\n</value></part></template>\n<template lineStart=\"1\"><title>Election box end</title></template>\n\n<template lineStart=\"1\"><title>Election box begin no change\n</title><part><name> title </name><equals>=</equals><value> Republican primary runoff results, 2020\n</value></part></template>\n<template lineStart=\"1\"><title>Election box winning candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Barry Moore\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 51,715\n</value></part><part><name> percentage </name><equals>=</equals><value> 60.0%\n</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change\n</title><part><name> candidate </name><equals>=</equals><value> Jeff Coleman\n</value></part><part><name> party </name><equals>=</equals><value> Republican Party (United States)\n</value></part><part><name> votes </name><equals>=</equals><value> 34,503\n</value></part><part><name> percentage </name><equals>=</equals><value> 40.0%\n</value></part></template>\n<template lineStart=\"1\"><title>Election box total no change\n</title><part><name> votes </name><equals>=</equals><value> 86,218\n</value></part><part><name> percentage </name><equals>=</equals><value> 100.0%\n</value></part></template>\n<template lineStart=\"1\"><title>Election box end</title></template>\n\n<template lineStart=\"1\"><title>Election box begin no change</title><part><name>title</name><equals>=</equals><value>Alabama\u2019s 2nd congressional district, 2020<ext><name>ref</name><attr> name=&quot;ALgenr&quot;</attr><inner>{{cite web|title=State of Alabama - Canvass of Results - |url=https://www.sos.alabama.gov/sites/default/files/election-2020/Final%20Canvass%20of%20Results-Merged.pdf |website=Alabama Secretary of State |access-date=November 23, 2020}}</inner><close>&lt;/ref&gt;</close></ext></value></part></template>\n<template lineStart=\"1\"><title>Election box  winning candidate with party link no change</title><part><name>candidate</name><equals>=</equals><value>Barry Moore</value></part><part><name>party</name><equals>=</equals><value>Republican Party (United States)</value></part><part><name>votes</name><equals>=</equals><value>197,996</value></part><part><name>percentage</name><equals>=</equals><value>65.2</value></part></template>\n<template lineStart=\"1\"><title>Election box candidate with party link no change</title><part><name>candidate</name><equals>=</equals><value>Phyllis Harvey-Hall</value></part><part><name>party</name><equals>=</equals><value>Democratic Party (United States)</value></part><part><name>votes</name><equals>=</equals><value>105,286</value></part><part><name>percentage</name><equals>=</equals><value>34.7</value></part></template>\n<template lineStart=\"1\"><title>Election box write-in with party link no change</title><part><name>votes</name><equals>=</equals><value>287</value></part><part><name>percentage</name><equals>=</equals><value>0.1</value></part></template>\n<template lineStart=\"1\"><title>Election box total no change</title><part><name>votes</name><equals>=</equals><value>303,569</value></part><part><name>percentage</name><equals>=</equals><value>100.0</value></part></template>\n<template lineStart=\"1\"><title>Election box hold with party link without swing</title><part><name>winner</name><equals>=</equals><value>Republican Party (United States)</value></part></template>\n<template lineStart=\"1\"><title>Election box end</title></template>\n\n<h level=\"2\" i=\"12\">== Personal life ==</h>\nMoore is married to Heather Moore.<ext><name>ref</name><attr> name=&quot;Britt&quot;</attr><inner>{{cite news |last1=Britt |first1=Bill |title=A brief look at candidate Barry Moore |url=https://www.alreporter.com/2020/06/15/a-brief-look-at-candidate-barry-moore/ |access-date=14 November 2020 |work=Alabama Political Reporter |date=15 June 2020}}</inner><close>&lt;/ref&gt;</close></ext>\n\n<h level=\"2\" i=\"13\">==References==</h>\n<template lineStart=\"1\"><title>Reflist</title></template>\n\n<h level=\"2\" i=\"14\">==External links==</h>\n*[https://barrymoore.house.gov Representative Barry Moore], official U.S. House website\n* [https://barrymooreforcongress.com/ Official campaign website]\n* <template><title>CongLinks </title><part><name> congbio</name><equals>=</equals><value>M001212 </value></part><part><name> votesmart</name><equals>=</equals><value>121792 </value></part><part><name> fec</name><equals>=</equals><value>H8AL02171 </value></part><part><name> congress</name><equals>=</equals><value>barry-moore/M001212</value></part></template>\n* <template><title>Ballotpedia</title><part><name index=\"1\"/><value>Barry_Moore_(Alabama)</value></part><part><name index=\"2\"/><value>Barry Moore</value></part></template>\n\n<template lineStart=\"1\"><title>s-start</title></template>\n<template lineStart=\"1\"><title>s-par</title><part><name index=\"1\"/><value>us-hs</value></part></template>\n<template lineStart=\"1\"><title>s-bef</title><part><name>before</name><equals>=</equals><value>[[Martha Roby]]</value></part></template>\n<template lineStart=\"1\"><title>s-ttl</title><part><name>title</name><equals>=</equals><value>Member of the [[List of United States Representatives from Alabama|U.S. House of Representatives]]&lt;br&gt;from [[Alabama's 2nd congressional district]]</value></part><part><name>years</name><equals>=</equals><value>2021 \u2013present</value></part></template>\n<template lineStart=\"1\"><title>s-inc</title></template>\n|-\n<template lineStart=\"1\"><title>s-prec</title><part><name index=\"1\"/><value>usa</value></part></template>\n<template lineStart=\"1\"><title>s-bef</title><part><name>before</name><equals>=</equals><value>[[Mariannette Miller-Meeks]]</value></part></template>\n<template lineStart=\"1\"><title>s-ttl</title><part><name>title</name><equals>=</equals><value>[[Seniority in the United States House of Representatives|United States Representatives by seniority]]</value></part><part><name>years</name><equals>=</equals><value>415th</value></part></template>\n<template lineStart=\"1\"><title>s-aft</title><part><name>after</name><equals>=</equals><value>[[Blake Moore]]</value></part></template>\n<template lineStart=\"1\"><title>s-end</title></template>\n\n<template lineStart=\"1\"><title>AL-FedRep</title></template>\n<template lineStart=\"1\"><title>Members of the U.S. House of Representatives</title></template>\n<template lineStart=\"1\"><title>USCongRep-start </title><part><name> congresses</name><equals>=</equals><value> 117th\u2013present [[United States Congress]]es </value></part><part><name> state</name><equals>=</equals><value>[[Alabama]]</value></part></template>\n<template lineStart=\"1\"><title>USCongRep/AL/117</title></template>\n<template lineStart=\"1\"><title>USCongRep-end</title></template>\n\n<template lineStart=\"1\"><title>DEFAULTSORT:Moore, Barry</title></template>\n[[Category:1966 births]]\n[[Category:21st-century American politicians]]\n[[Category:Alabama Republicans]]\n[[Category:Auburn University alumni]]\n[[Category:Candidates in the 2020 United States elections]]\n[[Category:Living people]]\n[[Category:Members of the Alabama House of Representatives]]\n[[Category:Members of the United States House of Representatives from Alabama]]\n[[Category:People from Enterprise, Alabama]]\n[[Category:Republican Party members of the United States House of Representatives]]\n[[Category:Troy University alumni]]</root>",
  "contentformat": "text/x-wiki",
  "comment": "/* Controversies */I took the incorrect false claim comments",
  "tags": [
    "mobile edit",
    "mobile web edit",
    "mw-reverted"
  ],
  "*": "{{Use mdy dates|date=November 2020}}\n{{short description|American politician}}\n{{Infobox officeholder\n|name         = Barry Moore\n|image        = Barry Moore 117th U.S Congress.jpg\n|state        = [[Alabama]]\n|district     = {{ushr|AL|2|2nd}}\n|term_start   = January 3, 2021\n|term_end     = \n|predecessor  = [[Martha Roby]]\n|successor    = \n|state_house1 = Alabama\n|district1    = 91st\n|term_start1  = November 3, 2010\n|term_end1    = November 7, 2018\n|predecessor1 = [[Terry Spicer]]\n|successor1   = Rhett Marques\n|birth_name=Felix Barry Moore\n|birth_date   = {{birth date and age|1966|9|26}}\n|birth_place  = [[Enterprise, Alabama]], U.S.\n|death_date   = \n|death_place  = \n|party        = [[Republican Party (United States)|Republican]]\n|spouse       = {{marriage|Heather Hopper|1992}}\n|education    = [[Enterprise State Community College]] ([[Associate of Science|AS]])<br>[[Auburn University]] ([[Bachelor of Science|BS]])\n|website      = {{url|barrymoore.house.gov|House website}}\n| signature   = Barrymooresig.png\n}}\n'''Felix Barry Moore''' (born September 26, 1966) is an American politician serving as the [[United States House of Representatives|U.S. Representative]] for [[Alabama's 2nd congressional district]] since 2021. Before his election to the United States House of Representatives, he served as a member of the [[Alabama House of Representatives]] from the 91st district from 2010 to 2018.<ref>{{cite web|url=http://www.legislature.state.al.us/aliswww/ISD/ALRepresentative.aspx?OID_SPONSOR=86005&OID_PERSON=6676 |archive-url=https://web.archive.org/web/20170204071509/http://www.legislature.state.al.us/aliswww/ISD/ALRepresentative.aspx?OID_SPONSOR=86005&OID_PERSON=6676 |url-status=dead |archive-date=February 4, 2017 |title=Barry Moore |publisher=Legislature.state.al.us |access-date=April 17, 2019}}</ref>\n\nIn May 2017, Moore announced his intention to run for the U.S. House of Representatives for [[Alabama's 2nd congressional district]] against [[incumbent]] [[Republican Party (United States)|Republican]] representative [[Martha Roby]].<ref>{{Cite web|url=https://www.al.com/news/2017/05/rep_barry_moore_to_challenge_m.html|title=Barry Moore challenging Martha Roby for House seat|date=May 12, 2017|website=al}}</ref> He finished third in the [[2018 United States House of Representatives elections in Alabama#District 2|2018 Republican primary]]. After Roby announced in July 2019 that she would not run for reelection in [[2020 United States House of Representatives elections in Alabama#District 2|2020]], Moore announced his candidacy for the open seat<ref>{{cite web|url=https://www.al.com/news/2019/08/former-state-rep-barry-moore-of-enterprise-running-for-congress.html |title=Enterprise's Barry Moore to run for U.S. House of Representatives |publisher=AL.com |date=May 5, 2019 |access-date=May 5, 2019}}</ref> and advanced to a runoff election against Jeff Coleman. Moore defeated Coleman to win the Republican nomination<ref>{{Cite web|url=https://www.al.com/election/2020/07/barry-moore-wins-in-district-2-gop-runoff.html|title=Barry Moore wins in District 2 GOP runoff|date=July 15, 2020|website=al}}</ref> and faced [[Democratic Party (United States)|Democrat]] Phyllis Harvey-Hall in the general election.\n\n==Early life and education==\nBarry Moore grew up on a farm in [[Coffee County, Alabama|Coffee County]], and attended [[Enterprise State Community College]].<ref name=Advertiser>{{cite web|url=https://www.montgomeryadvertiser.com/story/news/2020/02/14/barry-moore-hitting-veteran-status-congressional-run/4750259002/|work=[[Montgomery Advertiser]]|title=Barry Moore hitting veteran status in congressional run|author=Bryan Lyman|date=February 14, 2020|access-date=August 15, 2020}}</ref><ref>{{Cite web|url=https://barrymooreforcongress.com/|title=Barry Moore for US Congress &#124;}}</ref> He later attended [[Auburn University]], where he received a degree in [[agricultural science]] in 1992. While attending Auburn, Moore was enlisted in the [[Alabama National Guard]].\n\nIn 1998, Moore founded Barry Moore Industries, a waste hauling company.\n\n==Alabama House of Representatives==\nMoore was first elected to the Alabama House of Representatives in 2010, defeating Democratic incumbent [[Terry Spicer]].<ref name=APRprofile>{{cite web|url=https://www.alreporter.com/2020/06/15/a-brief-look-at-candidate-barry-moore/|title=A brief look at candidate Barry Moore|work=Alabama Political Reporter|date=June 15, 2020|access-date=August 15, 2020|author=Bill Britt}}</ref> PACs controlled by [[Mike Hubbard (politician)|Mike Hubbard]], a prominent Republican politician in Alabama and convicted felon,<ref>{{Cite web|last=Britt|first=Bill|date=2020-06-15|title=A brief look at candidate Barry Moore|url=https://www.alreporter.com/2020/06/15/a-brief-look-at-candidate-barry-moore/|access-date=2020-11-25|website=Alabama Political Reporter|language=en-US}}</ref> contributed more than $150,000 towards his candidacy.\n\n==U.S. House of Representatives ==\n\n=== Elections ===\n==== 2018 ====\n{{Main|2018 United States House of Representatives elections in Alabama#District 2}}\nIn 2018, Moore challenged incumbent U.S. Representative Martha Roby in the Republican primary for [[Alabama's 2nd congressional district|AL-02]], placing third behind Roby and former U.S. Representative [[Bobby Bright]].<ref name=Advertiser/>\n\n==== 2020 ====\n{{Main|2020 United States House of Representatives elections in Alabama#District 2}}\nMoore again sought the nomination in 2020, placing second in the Republican primary and later defeating [[Dothan, Alabama|Dothan]] businessman Jeff Coleman in the runoff.<ref>{{cite web|url=https://www.montgomeryadvertiser.com/story/news/2020/07/14/barry-moore-defeats-jeff-coleman-gop-nomination-2nd-congressional-district/5429384002/|title=Barry Moore defeats Jeff Coleman for GOP nomination in 2nd Congressional District|work=Montgomery Advertiser|author=Bryan Lyman|date=July 14, 2020|access-date=August 15, 2020}}</ref> Moore faced Democratic nominee Phyllis Harvey-Hall in the general election.\n\nOn November 3, 2020, Moore won the general election with 65.2 percent of the vote.\n\n=== Tenure ===\n\n=== Committee assignments<ref>{{Cite web|title=Rep. Barry Moore to Serve on House Agriculture Committee, House Committee on Veterans\u2019 Affairs in 117th Congress {{!}} Representative Barry Moore|url=https://barrymoore.house.gov/media/press-releases/rep-barry-moore-serve-house-agriculture-committee-house-committee-veterans|access-date=2021-02-02|website=barrymoore.house.gov}}</ref> ===\n\n* '''[[House Agriculture Committee|Committee on Agriculture]]'''\n* '''[[House Veterans Affairs Committee|Committee on Veterans\u2019 Affairs]]'''\n\n=== Caucus memberships ===\n* '''[[Freedom Caucus]]<ref>{{Cite web|title=House Freedom Fund|url=https://www.housefreedomfund.com/|access-date=2020-11-12|website=www.housefreedomfund.com}}</ref>'''\n\n==Controversies==\nTwo months after Moore was elected to the Alabama State House of Representatives in 2010, he and his wife were awarded a contract with the Alabama Department of Environmental Management (ADEM), which is notable because neither Moore nor his wife had ever held state contracts prior to his election to public office. Total payments from ADEM from Fiscal Year 2011 through 2013 totaled $64,612.<ref name=\"Britt\"/><ref>{{cite web|last=Britt|first=Bill|title=Rep. Barry Moore Receives Thousands in Taxpayer Dollars|url=https://www.alreporter.com/2014/03/10/rep-barry-moore-receives-thousands-in-taxpayer-dollars/|access-date=January 11, 2021|website=Alabama Political Reporter|language=en-US}}</ref>\n\nIn April 2014, Moore was arrested for felony perjury and lying to authorities during a grand jury investigation into Moore's friend and mentor, [[Mike Hubbard (politician)|Mike Hubbard]].<ref>{{Cite web|date=April 24, 2014|title=AL Rep. Barry Moore of Enterprise arrested on felony charges|url=https://www.wsfa.com/story/25330913/al-rep-barry-moore-of-enterprise-arrested-on-felony-charges|access-date=2020-11-25|website=WSFA 12 News|language=en-US}}</ref> In late 2014, Moore was acquitted of all charges.<ref name=\"Britt\"/><ref>{{cite web|author=Cliff Sims|title=Alabama Rep. Barry Moore not guilty on all counts|url=https://yellowhammernews.com/breaking-alabama-rep-barry-moore-guilty-counts/|access-date=August 15, 2020|work=Yellowhammer News}}</ref>\n\nOn October 30, 2020, Moore's Twitter account sent a tweet advocating for higher taxes and voting restrictions for those who move from one state to another state. The tweet was deleted shortly after, and Moore's media director, Jonathan Barbee, claimed responsibility, saying that the opinion was a personal view that Moore did not share and that Barbee had intended to send the tweet from his personal account.<ref>{{Cite web|last=Lyman|first=Brian|date=October 30, 2020|title=Barry Moore campaign worker: I sent tweet on voting restrictions for new state residents|url=https://www.montgomeryadvertiser.com/story/news/2020/10/30/barry-moore-campaign-worker-takes-responsibility-tweet-voting-restrictions-alabama-congress/6087008002/|website=The Montgomery Advertiser}}</ref>\n\nOn January 6, 2021, Moore objected to the [[2021 United States Electoral College vote count|certification]] of the [[United States Electoral College|Electoral College]] results in Congress. He was one of the 147 Republican members of Congress who voted to overturn the results of the [[2020 United States presidential election|2020 U.S. presidential election]] on January 7, 2021, immediately following the [[2021 storming of the United States Capitol|storming of the U.S. Capitol]].<ref>{{Cite news|last=Yourish|first=Karen|last2=Buchanan|first2=Larry|last3=Lu|first3=Denise|date=2021-01-07|title=The 147 Republicans Who Voted to Overturn Election Results|language=en-US|work=The New York Times|url=https://www.nytimes.com/interactive/2021/01/07/us/elections/electoral-college-biden-objectors.html|access-date=2021-01-11|issn=0362-4331}}</ref> [[President of the United States|President]] [[Donald Trump]] and his allies had made false and baseless claims of fraud in the election, which was won by Democrat [[Joe Biden]]. subsequent objections to the Electoral College results were cited as contributory factors in the insurrection at the U.S. Capitol, which led to calls from some of Moore's colleagues for his expulsion from Congress.<ref>{{Cite web|last=Smith|first=Kate|title=Congresswoman proposes legislation to remove house members; including six Alabama congressmen|url=https://www.wbrc.com/2021/01/10/congresswoman-proposes-legislation-remove-house-members-including-six-alabama-congressmen/|access-date=2021-01-10|website=WBRC|language=en-US}}</ref>\n\nOn January 10, 2021, Moore drew criticism for two controversial posts on Twitter, one of which echoed the of \u201cstealing an election on November 3rd.\u201d Both tweets appeared to understate the seriousness of the armed insurrection at the United States Capitol that took place four days prior on January 6, 2021, and as a result, his account was temporarily suspended by the social media platform. In response, Moore deactivated his account \u201cbecause of the censorship of conservative voices he saw happening.\u201d <ref>{{Cite web|last=Specker|first=Lawrence|title= Rep. Barry Moore deletes Twitter account after suspension, controversial Capitol riot tweets|url= https://www.al.com/news/mobile/2021/01/rep-barry-moore-deletes-personal-twitter-account-after-suspension.html |access-date=2021-01-11|website=AL.com|language=en-US}}</ref>\n\n== Electoral history ==\n\n{{Election box begin no change|title=Republican primary results, 2018}}\n{{Election box winning candidate with party link no change\n  |party = Republican Party (United States)\n  |candidate = Martha Roby (incumbent)\n  |votes = 36,708\n  |percentage = 39.0\n}}\n{{Election box winning candidate with party link no change\n  |party = Republican Party (United States)\n  |candidate = Bobby Bright\n  |votes = 26,481\n  |percentage = 28.1\n}}\n{{Election box candidate with party link no change\n  |party = Republican Party (United States)\n  |candidate = Barry Moore\n  |votes = 18,177\n  |percentage = 19.3\n}}\n{{Election box candidate with party link no change\n  |party = Republican Party (United States)\n  |candidate = Rich Hobson\n  |votes = 7,052\n  |percentage = 7.5\n}}\n{{Election box candidate with party link no change\n  |party = Republican Party (United States)\n  |candidate = Tommy Amason\n  |votes = 5,763\n  |percentage = 6.1\n}}\n{{Election box total no change\n  |votes = 94,181\n  |percentage = 100.0\n}}\n{{Election box end}}\n\n{{Election box begin no change\n| title = Republican primary results, 2020\n}}\n{{Election box winning candidate with party link no change\n| candidate = Jeff Coleman\n| party = Republican Party (United States)\n| votes = 39,738\n| percentage = 38.1\n}}\n{{Election box winning candidate with party link no change\n| candidate = Barry Moore\n| party = Republican Party (United States)\n| votes = 21,354\n| percentage = 20.4\n}}\n{{Election box candidate with party link no change\n| candidate = Jessica Taylor\n| party = Republican Party (United States)\n| votes = 20,763\n| percentage = 19.9\n}}\n{{Election box candidate with party link no change\n| candidate = [[Troy King]]\n| party = Republican Party (United States)\n| votes = 15,145\n| percentage = 14.5\n}}\n{{Election box candidate with party link no change\n| candidate = Terri Hasdorff\n| party = Republican Party (United States)\n| votes = 5,207\n| percentage = 5.0\n}}\n{{Election box  candidate with party link no change\n| candidate = Thomas W. Brown\n| party = Republican Party (United States)\n| votes = 1,395\n| percentage = 1.3\n}}\n{{Election box candidate with party link no change\n| candidate = Bob Rogers\n| party = Republican Party (United States)\n| votes = 824\n| percentage = 0.8\n}}\n{{Election box total no change\n| votes = 104,426\n| percentage = 100.0%\n}}\n{{Election box end}}\n\n{{Election box begin no change\n| title = Republican primary runoff results, 2020\n}}\n{{Election box winning candidate with party link no change\n| candidate = Barry Moore\n| party = Republican Party (United States)\n| votes = 51,715\n| percentage = 60.0%\n}}\n{{Election box candidate with party link no change\n| candidate = Jeff Coleman\n| party = Republican Party (United States)\n| votes = 34,503\n| percentage = 40.0%\n}}\n{{Election box total no change\n| votes = 86,218\n| percentage = 100.0%\n}}\n{{Election box end}}\n\n{{Election box begin no change|title=Alabama\u2019s 2nd congressional district, 2020<ref name=\"ALgenr\">{{cite web|title=State of Alabama - Canvass of Results - |url=https://www.sos.alabama.gov/sites/default/files/election-2020/Final%20Canvass%20of%20Results-Merged.pdf |website=Alabama Secretary of State |access-date=November 23, 2020}}</ref>}}\n{{Election box  winning candidate with party link no change|candidate=Barry Moore|party=Republican Party (United States)|votes=197,996|percentage=65.2}}\n{{Election box candidate with party link no change|candidate=Phyllis Harvey-Hall|party=Democratic Party (United States)|votes=105,286|percentage=34.7}}\n{{Election box write-in with party link no change|votes=287|percentage=0.1}}\n{{Election box total no change|votes=303,569|percentage=100.0}}\n{{Election box hold with party link without swing|winner=Republican Party (United States)}}\n{{Election box end}}\n\n== Personal life ==\nMoore is married to Heather Moore.<ref name=\"Britt\">{{cite news |last1=Britt |first1=Bill |title=A brief look at candidate Barry Moore |url=https://www.alreporter.com/2020/06/15/a-brief-look-at-candidate-barry-moore/ |access-date=14 November 2020 |work=Alabama Political Reporter |date=15 June 2020}}</ref>\n\n==References==\n{{Reflist}}\n\n==External links==\n*[https://barrymoore.house.gov Representative Barry Moore], official U.S. House website\n* [https://barrymooreforcongress.com/ Official campaign website]\n* {{CongLinks | congbio=M001212 | votesmart=121792 | fec=H8AL02171 | congress=barry-moore/M001212}}\n* {{Ballotpedia|Barry_Moore_(Alabama)|Barry Moore}}\n\n{{s-start}}\n{{s-par|us-hs}}\n{{s-bef|before=[[Martha Roby]]}}\n{{s-ttl|title=Member of the [[List of United States Representatives from Alabama|U.S. House of Representatives]]<br>from [[Alabama's 2nd congressional district]]|years=2021 \u2013present}}\n{{s-inc}}\n|-\n{{s-prec|usa}}\n{{s-bef|before=[[Mariannette Miller-Meeks]]}}\n{{s-ttl|title=[[Seniority in the United States House of Representatives|United States Representatives by seniority]]|years=415th}}\n{{s-aft|after=[[Blake Moore]]}}\n{{s-end}}\n\n{{AL-FedRep}}\n{{Members of the U.S. House of Representatives}}\n{{USCongRep-start | congresses= 117th\u2013present [[United States Congress]]es | state=[[Alabama]]}}\n{{USCongRep/AL/117}}\n{{USCongRep-end}}\n\n{{DEFAULTSORT:Moore, Barry}}\n[[Category:1966 births]]\n[[Category:21st-century American politicians]]\n[[Category:Alabama Republicans]]\n[[Category:Auburn University alumni]]\n[[Category:Candidates in the 2020 United States elections]]\n[[Category:Living people]]\n[[Category:Members of the Alabama House of Representatives]]\n[[Category:Members of the United States House of Representatives from Alabama]]\n[[Category:People from Enterprise, Alabama]]\n[[Category:Republican Party members of the United States House of Representatives]]\n[[Category:Troy University alumni]]"
}
```

To understand the meaning of the JSON files you will want to consult the Wikipedia API documentation:

https://en.wikipedia.org/w/api.php?action=help&modules=query%2Brevisions

## Update

If you run *wikipediarevs* at a particular point in time to collect all the revisions you may want to rerun it later to pick up revisions that have been submitted since the last time you ran it. To do that you simply run it again:

```
wikipediarevs urls.txt
```

