"use strict";
// Generated from the AliCloud ROS Resource Specification
Object.defineProperty(exports, "__esModule", { value: true });
exports.RosServiceMesh = void 0;
const ros = require("@alicloud/ros-cdk-core");
/**
 * Determine whether the given properties match those of a `RosServiceMeshProps`
 *
 * @param properties - the TypeScript properties of a `RosServiceMeshProps`
 *
 * @returns the result of the validation.
 */
function RosServiceMeshPropsValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('opa', RosServiceMesh_OPAPropertyValidator)(properties.opa));
    errors.collect(ros.propertyValidator('enableAudit', ros.validateBoolean)(properties.enableAudit));
    errors.collect(ros.propertyValidator('istioVersion', ros.validateString)(properties.istioVersion));
    errors.collect(ros.propertyValidator('apiServerPublicEip', ros.validateBoolean)(properties.apiServerPublicEip));
    errors.collect(ros.propertyValidator('localityLoadBalancing', ros.validateBoolean)(properties.localityLoadBalancing));
    errors.collect(ros.propertyValidator('telemetry', ros.validateBoolean)(properties.telemetry));
    errors.collect(ros.propertyValidator('outboundTrafficPolicy', ros.validateString)(properties.outboundTrafficPolicy));
    errors.collect(ros.propertyValidator('auditProject', ros.validateString)(properties.auditProject));
    errors.collect(ros.propertyValidator('traceSampling', ros.validateNumber)(properties.traceSampling));
    errors.collect(ros.propertyValidator('name', ros.validateString)(properties.name));
    errors.collect(ros.propertyValidator('proxy', RosServiceMesh_ProxyPropertyValidator)(properties.proxy));
    errors.collect(ros.propertyValidator('vpcId', ros.requiredValidator)(properties.vpcId));
    errors.collect(ros.propertyValidator('vpcId', ros.validateString)(properties.vpcId));
    errors.collect(ros.propertyValidator('pilotPublicEip', ros.validateBoolean)(properties.pilotPublicEip));
    errors.collect(ros.propertyValidator('includeIpRanges', ros.validateString)(properties.includeIpRanges));
    errors.collect(ros.propertyValidator('vSwitches', ros.requiredValidator)(properties.vSwitches));
    errors.collect(ros.propertyValidator('vSwitches', ros.listValidator(ros.validateAny))(properties.vSwitches));
    errors.collect(ros.propertyValidator('tracing', ros.validateBoolean)(properties.tracing));
    errors.collect(ros.propertyValidator('customizedZipkin', ros.validateBoolean)(properties.customizedZipkin));
    return errors.wrap('supplied properties not correct for "RosServiceMeshProps"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh` resource
 *
 * @param properties - the TypeScript properties of a `RosServiceMeshProps`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh` resource.
 */
// @ts-ignore TS6133
function rosServiceMeshPropsToRosTemplate(properties, enableResourcePropertyConstraint) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    if (enableResourcePropertyConstraint) {
        RosServiceMeshPropsValidator(properties).assertSuccess();
    }
    return {
        VpcId: ros.stringToRosTemplate(properties.vpcId),
        VSwitches: ros.listMapper(ros.objectToRosTemplate)(properties.vSwitches),
        ApiServerPublicEip: ros.booleanToRosTemplate(properties.apiServerPublicEip),
        AuditProject: ros.stringToRosTemplate(properties.auditProject),
        CustomizedZipkin: ros.booleanToRosTemplate(properties.customizedZipkin),
        EnableAudit: ros.booleanToRosTemplate(properties.enableAudit),
        IncludeIPRanges: ros.stringToRosTemplate(properties.includeIpRanges),
        IstioVersion: ros.stringToRosTemplate(properties.istioVersion),
        LocalityLoadBalancing: ros.booleanToRosTemplate(properties.localityLoadBalancing),
        Name: ros.stringToRosTemplate(properties.name),
        OPA: rosServiceMeshOPAPropertyToRosTemplate(properties.opa),
        OutboundTrafficPolicy: ros.stringToRosTemplate(properties.outboundTrafficPolicy),
        PilotPublicEip: ros.booleanToRosTemplate(properties.pilotPublicEip),
        Proxy: rosServiceMeshProxyPropertyToRosTemplate(properties.proxy),
        Telemetry: ros.booleanToRosTemplate(properties.telemetry),
        TraceSampling: ros.numberToRosTemplate(properties.traceSampling),
        Tracing: ros.booleanToRosTemplate(properties.tracing),
    };
}
/**
 * A ROS template type:  `ALIYUN::ASM::ServiceMesh`
 */
class RosServiceMesh extends ros.RosResource {
    /**
     * Create a new `ALIYUN::ASM::ServiceMesh`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint) {
        super(scope, id, { type: RosServiceMesh.ROS_RESOURCE_TYPE_NAME, properties: props });
        this.attrServiceMeshId = this.getAtt('ServiceMeshId');
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        this.vpcId = props.vpcId;
        this.vSwitches = props.vSwitches;
        this.apiServerPublicEip = props.apiServerPublicEip;
        this.auditProject = props.auditProject;
        this.customizedZipkin = props.customizedZipkin;
        this.enableAudit = props.enableAudit;
        this.includeIpRanges = props.includeIpRanges;
        this.istioVersion = props.istioVersion;
        this.localityLoadBalancing = props.localityLoadBalancing;
        this.name = props.name;
        this.opa = props.opa;
        this.outboundTrafficPolicy = props.outboundTrafficPolicy;
        this.pilotPublicEip = props.pilotPublicEip;
        this.proxy = props.proxy;
        this.telemetry = props.telemetry;
        this.traceSampling = props.traceSampling;
        this.tracing = props.tracing;
    }
    get rosProperties() {
        return {
            vpcId: this.vpcId,
            vSwitches: this.vSwitches,
            apiServerPublicEip: this.apiServerPublicEip,
            auditProject: this.auditProject,
            customizedZipkin: this.customizedZipkin,
            enableAudit: this.enableAudit,
            includeIpRanges: this.includeIpRanges,
            istioVersion: this.istioVersion,
            localityLoadBalancing: this.localityLoadBalancing,
            name: this.name,
            opa: this.opa,
            outboundTrafficPolicy: this.outboundTrafficPolicy,
            pilotPublicEip: this.pilotPublicEip,
            proxy: this.proxy,
            telemetry: this.telemetry,
            traceSampling: this.traceSampling,
            tracing: this.tracing,
        };
    }
    renderProperties(props) {
        return rosServiceMeshPropsToRosTemplate(props, this.enableResourcePropertyConstraint);
    }
}
exports.RosServiceMesh = RosServiceMesh;
/**
 * The resource type name for this resource class.
 */
RosServiceMesh.ROS_RESOURCE_TYPE_NAME = "ALIYUN::ASM::ServiceMesh";
/**
 * Determine whether the given properties match those of a `OPAProperty`
 *
 * @param properties - the TypeScript properties of a `OPAProperty`
 *
 * @returns the result of the validation.
 */
function RosServiceMesh_OPAPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('opaRequestCpu', ros.validateString)(properties.opaRequestCpu));
    errors.collect(ros.propertyValidator('openAgentPolicy', ros.validateBoolean)(properties.openAgentPolicy));
    errors.collect(ros.propertyValidator('opaLogLevel', ros.validateString)(properties.opaLogLevel));
    errors.collect(ros.propertyValidator('opaLimitCpu', ros.validateString)(properties.opaLimitCpu));
    errors.collect(ros.propertyValidator('opaLimitMemory', ros.validateString)(properties.opaLimitMemory));
    errors.collect(ros.propertyValidator('opaRequestMemory', ros.validateString)(properties.opaRequestMemory));
    return errors.wrap('supplied properties not correct for "OPAProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.OPA` resource
 *
 * @param properties - the TypeScript properties of a `OPAProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.OPA` resource.
 */
// @ts-ignore TS6133
function rosServiceMeshOPAPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServiceMesh_OPAPropertyValidator(properties).assertSuccess();
    return {
        OPARequestCPU: ros.stringToRosTemplate(properties.opaRequestCpu),
        OpenAgentPolicy: ros.booleanToRosTemplate(properties.openAgentPolicy),
        OPALogLevel: ros.stringToRosTemplate(properties.opaLogLevel),
        OPALimitCPU: ros.stringToRosTemplate(properties.opaLimitCpu),
        OPALimitMemory: ros.stringToRosTemplate(properties.opaLimitMemory),
        OPARequestMemory: ros.stringToRosTemplate(properties.opaRequestMemory),
    };
}
/**
 * Determine whether the given properties match those of a `ProxyProperty`
 *
 * @param properties - the TypeScript properties of a `ProxyProperty`
 *
 * @returns the result of the validation.
 */
function RosServiceMesh_ProxyPropertyValidator(properties) {
    if (!ros.canInspect(properties)) {
        return ros.VALIDATION_SUCCESS;
    }
    const errors = new ros.ValidationResults();
    errors.collect(ros.propertyValidator('clusterDomain', ros.validateString)(properties.clusterDomain));
    errors.collect(ros.propertyValidator('proxyLimitCpu', ros.validateString)(properties.proxyLimitCpu));
    errors.collect(ros.propertyValidator('proxyLimitMemory', ros.validateString)(properties.proxyLimitMemory));
    errors.collect(ros.propertyValidator('proxyRequestCpu', ros.validateString)(properties.proxyRequestCpu));
    errors.collect(ros.propertyValidator('proxyRequestMemory', ros.validateString)(properties.proxyRequestMemory));
    return errors.wrap('supplied properties not correct for "ProxyProperty"');
}
/**
 * Renders the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.Proxy` resource
 *
 * @param properties - the TypeScript properties of a `ProxyProperty`
 *
 * @returns the AliCloud ROS Resource properties of an `ALIYUN::ASM::ServiceMesh.Proxy` resource.
 */
// @ts-ignore TS6133
function rosServiceMeshProxyPropertyToRosTemplate(properties) {
    if (!ros.canInspect(properties)) {
        return properties;
    }
    RosServiceMesh_ProxyPropertyValidator(properties).assertSuccess();
    return {
        ClusterDomain: ros.stringToRosTemplate(properties.clusterDomain),
        ProxyLimitCPU: ros.stringToRosTemplate(properties.proxyLimitCpu),
        ProxyLimitMemory: ros.stringToRosTemplate(properties.proxyLimitMemory),
        ProxyRequestCPU: ros.stringToRosTemplate(properties.proxyRequestCpu),
        ProxyRequestMemory: ros.stringToRosTemplate(properties.proxyRequestMemory),
    };
}
//# sourceMappingURL=data:application/json;base64,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