"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.S3PutObjectAction = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const iam = require("@aws-cdk/aws-iam");
const case_1 = require("case");
const role_1 = require("./private/role");
/**
 * The action to write the data from an MQTT message to an Amazon S3 bucket.
 */
class S3PutObjectAction {
    /**
     * @param bucket The Amazon S3 bucket to which to write data.
     * @param props Optional properties to not use default
     */
    constructor(bucket, props = {}) {
        this.bucket = bucket;
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_iot_actions_S3PutObjectActionProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, this.constructor);
            }
            throw error;
        }
        this.accessControl = props.accessControl;
        this.key = props.key;
        this.role = props.role;
    }
    bind(rule) {
        var _b, _c;
        const role = (_b = this.role) !== null && _b !== void 0 ? _b : role_1.singletonActionRole(rule);
        role.addToPrincipalPolicy(new iam.PolicyStatement({
            actions: ['s3:PutObject'],
            resources: [this.bucket.arnForObjects('*')],
        }));
        return {
            configuration: {
                s3: {
                    bucketName: this.bucket.bucketName,
                    cannedAcl: this.accessControl && case_1.kebab(this.accessControl.toString()),
                    key: (_c = this.key) !== null && _c !== void 0 ? _c : '${topic()}/${timestamp()}',
                    roleArn: role.roleArn,
                },
            },
        };
    }
}
exports.S3PutObjectAction = S3PutObjectAction;
_a = JSII_RTTI_SYMBOL_1;
S3PutObjectAction[_a] = { fqn: "@aws-cdk/aws-iot-actions.S3PutObjectAction", version: "1.153.1" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiczMtcHV0LW9iamVjdC1hY3Rpb24uanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJzMy1wdXQtb2JqZWN0LWFjdGlvbi50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSx3Q0FBd0M7QUFHeEMsK0JBQTRDO0FBRTVDLHlDQUFxRDtBQXlCckQ7O0dBRUc7QUFDSCxNQUFhLGlCQUFpQjtJQUs1Qjs7O09BR0c7SUFDSCxZQUE2QixNQUFrQixFQUFFLFFBQWdDLEVBQUU7UUFBdEQsV0FBTSxHQUFOLE1BQU0sQ0FBWTs7Ozs7Ozs7OztRQUM3QyxJQUFJLENBQUMsYUFBYSxHQUFHLEtBQUssQ0FBQyxhQUFhLENBQUM7UUFDekMsSUFBSSxDQUFDLEdBQUcsR0FBRyxLQUFLLENBQUMsR0FBRyxDQUFDO1FBQ3JCLElBQUksQ0FBQyxJQUFJLEdBQUcsS0FBSyxDQUFDLElBQUksQ0FBQztLQUN4QjtJQUVELElBQUksQ0FBQyxJQUFvQjs7UUFDdkIsTUFBTSxJQUFJLFNBQUcsSUFBSSxDQUFDLElBQUksbUNBQUksMEJBQW1CLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDcEQsSUFBSSxDQUFDLG9CQUFvQixDQUFDLElBQUksR0FBRyxDQUFDLGVBQWUsQ0FBQztZQUNoRCxPQUFPLEVBQUUsQ0FBQyxjQUFjLENBQUM7WUFDekIsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxhQUFhLENBQUMsR0FBRyxDQUFDLENBQUM7U0FDNUMsQ0FBQyxDQUFDLENBQUM7UUFFSixPQUFPO1lBQ0wsYUFBYSxFQUFFO2dCQUNiLEVBQUUsRUFBRTtvQkFDRixVQUFVLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVO29CQUNsQyxTQUFTLEVBQUUsSUFBSSxDQUFDLGFBQWEsSUFBSSxZQUFXLENBQUMsSUFBSSxDQUFDLGFBQWEsQ0FBQyxRQUFRLEVBQUUsQ0FBQztvQkFDM0UsR0FBRyxRQUFFLElBQUksQ0FBQyxHQUFHLG1DQUFJLDJCQUEyQjtvQkFDNUMsT0FBTyxFQUFFLElBQUksQ0FBQyxPQUFPO2lCQUN0QjthQUNGO1NBQ0YsQ0FBQztLQUNIOztBQWhDSCw4Q0FpQ0MiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBpb3QgZnJvbSAnQGF3cy1jZGsvYXdzLWlvdCc7XG5pbXBvcnQgKiBhcyBzMyBmcm9tICdAYXdzLWNkay9hd3MtczMnO1xuaW1wb3J0IHsga2ViYWIgYXMgdG9LZWJhYkNhc2UgfSBmcm9tICdjYXNlJztcbmltcG9ydCB7IENvbW1vbkFjdGlvblByb3BzIH0gZnJvbSAnLi9jb21tb24tYWN0aW9uLXByb3BzJztcbmltcG9ydCB7IHNpbmdsZXRvbkFjdGlvblJvbGUgfSBmcm9tICcuL3ByaXZhdGUvcm9sZSc7XG5cbi8qKlxuICogQ29uZmlndXJhdGlvbiBwcm9wZXJ0aWVzIG9mIGFuIGFjdGlvbiBmb3IgczMuXG4gKi9cbmV4cG9ydCBpbnRlcmZhY2UgUzNQdXRPYmplY3RBY3Rpb25Qcm9wcyBleHRlbmRzIENvbW1vbkFjdGlvblByb3BzIHtcbiAgLyoqXG4gICAqIFRoZSBBbWF6b24gUzMgY2FubmVkIEFDTCB0aGF0IGNvbnRyb2xzIGFjY2VzcyB0byB0aGUgb2JqZWN0IGlkZW50aWZpZWQgYnkgdGhlIG9iamVjdCBrZXkuXG4gICAqIEBzZWUgaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL0FtYXpvblMzL2xhdGVzdC91c2VyZ3VpZGUvYWNsLW92ZXJ2aWV3Lmh0bWwjY2FubmVkLWFjbFxuICAgKlxuICAgKiBAZGVmYXVsdCBOb25lXG4gICAqL1xuICByZWFkb25seSBhY2Nlc3NDb250cm9sPzogczMuQnVja2V0QWNjZXNzQ29udHJvbDtcblxuICAvKipcbiAgICogVGhlIHBhdGggdG8gdGhlIGZpbGUgd2hlcmUgdGhlIGRhdGEgaXMgd3JpdHRlbi5cbiAgICpcbiAgICogU3VwcG9ydHMgc3Vic3RpdHV0aW9uIHRlbXBsYXRlcy5cbiAgICogQHNlZSBodHRwczovL2RvY3MuYXdzLmFtYXpvbi5jb20vaW90L2xhdGVzdC9kZXZlbG9wZXJndWlkZS9pb3Qtc3Vic3RpdHV0aW9uLXRlbXBsYXRlcy5odG1sXG4gICAqXG4gICAqIEBkZWZhdWx0ICcke3RvcGljKCl9LyR7dGltZXN0YW1wKCl9J1xuICAgKi9cbiAgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xufVxuXG4vKipcbiAqIFRoZSBhY3Rpb24gdG8gd3JpdGUgdGhlIGRhdGEgZnJvbSBhbiBNUVRUIG1lc3NhZ2UgdG8gYW4gQW1hem9uIFMzIGJ1Y2tldC5cbiAqL1xuZXhwb3J0IGNsYXNzIFMzUHV0T2JqZWN0QWN0aW9uIGltcGxlbWVudHMgaW90LklBY3Rpb24ge1xuICBwcml2YXRlIHJlYWRvbmx5IGFjY2Vzc0NvbnRyb2w/OiBzdHJpbmc7XG4gIHByaXZhdGUgcmVhZG9ubHkga2V5Pzogc3RyaW5nO1xuICBwcml2YXRlIHJlYWRvbmx5IHJvbGU/OiBpYW0uSVJvbGU7XG5cbiAgLyoqXG4gICAqIEBwYXJhbSBidWNrZXQgVGhlIEFtYXpvbiBTMyBidWNrZXQgdG8gd2hpY2ggdG8gd3JpdGUgZGF0YS5cbiAgICogQHBhcmFtIHByb3BzIE9wdGlvbmFsIHByb3BlcnRpZXMgdG8gbm90IHVzZSBkZWZhdWx0XG4gICAqL1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGJ1Y2tldDogczMuSUJ1Y2tldCwgcHJvcHM6IFMzUHV0T2JqZWN0QWN0aW9uUHJvcHMgPSB7fSkge1xuICAgIHRoaXMuYWNjZXNzQ29udHJvbCA9IHByb3BzLmFjY2Vzc0NvbnRyb2w7XG4gICAgdGhpcy5rZXkgPSBwcm9wcy5rZXk7XG4gICAgdGhpcy5yb2xlID0gcHJvcHMucm9sZTtcbiAgfVxuXG4gIGJpbmQocnVsZTogaW90LklUb3BpY1J1bGUpOiBpb3QuQWN0aW9uQ29uZmlnIHtcbiAgICBjb25zdCByb2xlID0gdGhpcy5yb2xlID8/IHNpbmdsZXRvbkFjdGlvblJvbGUocnVsZSk7XG4gICAgcm9sZS5hZGRUb1ByaW5jaXBhbFBvbGljeShuZXcgaWFtLlBvbGljeVN0YXRlbWVudCh7XG4gICAgICBhY3Rpb25zOiBbJ3MzOlB1dE9iamVjdCddLFxuICAgICAgcmVzb3VyY2VzOiBbdGhpcy5idWNrZXQuYXJuRm9yT2JqZWN0cygnKicpXSxcbiAgICB9KSk7XG5cbiAgICByZXR1cm4ge1xuICAgICAgY29uZmlndXJhdGlvbjoge1xuICAgICAgICBzMzoge1xuICAgICAgICAgIGJ1Y2tldE5hbWU6IHRoaXMuYnVja2V0LmJ1Y2tldE5hbWUsXG4gICAgICAgICAgY2FubmVkQWNsOiB0aGlzLmFjY2Vzc0NvbnRyb2wgJiYgdG9LZWJhYkNhc2UodGhpcy5hY2Nlc3NDb250cm9sLnRvU3RyaW5nKCkpLFxuICAgICAgICAgIGtleTogdGhpcy5rZXkgPz8gJyR7dG9waWMoKX0vJHt0aW1lc3RhbXAoKX0nLFxuICAgICAgICAgIHJvbGVBcm46IHJvbGUucm9sZUFybixcbiAgICAgICAgfSxcbiAgICAgIH0sXG4gICAgfTtcbiAgfVxufVxuIl19