# Copyright 2018-2021 Xanadu Quantum Technologies Inc.

# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at

#     http://www.apache.org/licenses/LICENSE-2.0

# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
"""
This module contains basis set parameters defining Gaussian-type orbitals for a selected number of
atoms. The data are taken from the Basis Set Exchange `library <https://www.basissetexchange.org>`_.
The current data include the STO-3G and 6-31G basis sets for atoms with atomic numbers 1-10.
"""

atomic_numbers = {
    "H": 1,
    "He": 2,
    "Li": 3,
    "Be": 4,
    "B": 5,
    "C": 6,
    "N": 7,
    "O": 8,
    "F": 9,
    "Ne": 10,
}

STO3G = {
    "H": {
        "orbitals": ["S"],
        "exponents": [[0.3425250914e01, 0.6239137298e00, 0.1688554040e00]],
        "coefficients": [[0.1543289673e00, 0.5353281423e00, 0.4446345422e00]],
    },
    "He": {
        "orbitals": ["S"],
        "exponents": [[0.6362421394e01, 0.1158922999e01, 0.3136497915e00]],
        "coefficients": [[0.1543289673e00, 0.5353281423e00, 0.4446345422e00]],
    },
    "Li": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.1611957475e02, 0.2936200663e01, 0.7946504870e00],
            [0.6362897469e00, 0.1478600533e00, 0.4808867840e-01],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "Be": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.3016787069e02, 0.5495115306e01, 0.1487192653e01],
            [0.1314833110e01, 0.3055389383e00, 0.9937074560e-01],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "B": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.4879111318e02, 0.8887362172e01, 0.2405267040e01],
            [0.2236956142e01, 0.5198204999e00, 0.1690617600e00],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "C": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.7161683735e02, 0.1304509632e02, 0.3530512160e01],
            [0.2941249355e01, 0.6834830964e00, 0.2222899159e00],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "N": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.9910616896e02, 0.1805231239e02, 0.4885660238e01],
            [0.3780455879e01, 0.8784966449e00, 0.2857143744e00],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "O": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.1307093214e03, 0.2380886605e02, 0.6443608313e01],
            [0.5033151319e01, 0.1169596125e01, 0.3803889600e00],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "F": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.1666791340e03, 0.3036081233e02, 0.8216820672e01],
            [0.6464803249e01, 0.1502281245e01, 0.4885884864e00],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
    "Ne": {
        "orbitals": ["S", "SP"],
        "exponents": [
            [0.2070156070e03, 0.3770815124e02, 0.1020529731e02],
            [0.8246315120e01, 0.1916266291e01, 0.6232292721e00],
        ],
        "coefficients": [
            [0.1543289673e00, 0.5353281423e00, 0.4446345422e00],
            [-0.9996722919e-01, 0.3995128261e00, 0.7001154689e00],
            [0.1559162750e00, 0.6076837186e00, 0.3919573931e00],
        ],
    },
}

POPLE631G = {
    "H": {
        "orbitals": ["S", "S"],
        "exponents": [[18.73113696, 2.825394365, 0.6401216923], [0.1612777588]],
        "coefficients": [[0.03349460434, 0.2347269535, 0.8137573261], [1.0]],
    },
    "He": {
        "orbitals": ["S", "S"],
        "exponents": [[38.421634, 5.77803, 1.241774], [0.297964]],
        "coefficients": [[0.04013973935, 0.261246097, 0.7931846246], [1.0]],
    },
    "Li": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [642.418915, 96.7985153, 22.0911212, 6.20107025, 1.93511768, 0.636735789],
            [2.324918408, 0.6324303556, 0.07905343475],
            [0.03596197175],
        ],
        "coefficients": [
            [0.00214260781, 0.0162088715, 0.0773155725, 0.245786052, 0.470189004, 0.345470845],
            [-0.03509174574, -0.1912328431, 1.083987795],
            [0.008941508043, 0.141009464, 0.9453636953],
            [1.0],
            [1.0],
        ],
    },
    "Be": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [1264.58569, 189.936806, 43.159089, 12.0986627, 3.80632322, 1.2728903],
            [3.196463098, 0.7478133038, 0.2199663302],
            [0.0823099007],
        ],
        "coefficients": [
            [0.00194475759, 0.014835052, 0.07209054629, 0.23715415, 0.4691986519, 0.3565202279],
            [-0.1126487285, -0.2295064079, 1.186916764],
            [0.0559801998, 0.261550611, 0.7939723389],
            [1.0],
            [1.0],
        ],
    },
    "B": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [2068.88225, 310.64957, 70.683033, 19.8610803, 6.29930484, 2.12702697],
            [4.727971071, 1.190337736, 0.3594116829],
            [0.1267512469],
        ],
        "coefficients": [
            [0.00186627459, 0.0142514817, 0.0695516185, 0.232572933, 0.467078712, 0.36343144],
            [-0.1303937974, -0.1307889514, 1.130944484],
            [0.07459757992, 0.3078466771, 0.7434568342],
            [1.0],
            [1.0],
        ],
    },
    "C": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [3047.52488, 457.369518, 103.948685, 29.2101553, 9.28666296, 3.16392696],
            [7.86827235, 1.88128854, 0.544249258],
            [0.1687144782],
        ],
        "coefficients": [
            [
                0.001834737132,
                0.01403732281,
                0.06884262226,
                0.2321844432,
                0.4679413484,
                0.3623119853,
            ],
            [-0.1193324198, -0.1608541517, 1.143456438],
            [0.06899906659, 0.316423961, 0.7443082909],
            [1.0],
            [1.0],
        ],
    },
    "N": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [4173.51146, 627.457911, 142.902093, 40.2343293, 12.8202129, 4.39043701],
            [11.62636186, 2.716279807, 0.7722183966],
            [0.2120314975],
        ],
        "coefficients": [
            [0.00183477216, 0.013994627, 0.06858655181, 0.232240873, 0.4690699481, 0.3604551991],
            [-0.1149611817, -0.1691174786, 1.145851947],
            [0.06757974388, 0.3239072959, 0.7408951398],
            [1.0],
            [1.0],
        ],
    },
    "O": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [5484.67166, 825.234946, 188.046958, 52.9645, 16.8975704, 5.79963534],
            [15.53961625, 3.599933586, 1.01376175],
            [0.2700058226],
        ],
        "coefficients": [
            [0.00183107443, 0.0139501722, 0.0684450781, 0.232714336, 0.470192898, 0.358520853],
            [-0.1107775495, -0.1480262627, 1.130767015],
            [0.07087426823, 0.3397528391, 0.7271585773],
            [1.0],
            [1.0],
        ],
    },
    "F": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [7001.71309, 1051.36609, 239.28569, 67.3974453, 21.5199573, 7.4031013],
            [20.8479528, 4.80830834, 1.34406986],
            [0.358151393],
        ],
        "coefficients": [
            [
                0.001819616901,
                0.01391607961,
                0.06840532453,
                0.2331857601,
                0.4712674392,
                0.3566185462,
            ],
            [-0.1085069751, -0.1464516581, 1.128688581],
            [0.07162872424, 0.3459121027, 0.7224699564],
            [1.0],
            [1.0],
        ],
    },
    "Ne": {
        "orbitals": ["S", "SP", "SP"],
        "exponents": [
            [8425.85153, 1268.5194, 289.621414, 81.859004, 26.2515079, 9.09472051],
            [26.532131, 6.10175501, 1.69627153],
            [0.4458187],
        ],
        "coefficients": [
            [0.00188434805, 0.0143368994, 0.07010962331, 0.237373266, 0.4730071261, 0.348401241],
            [-0.1071182872, -0.1461638213, 1.127773503],
            [0.07190958851, 0.349513372, 0.7199405121],
            [1.0],
            [1.0],
        ],
    },
}
