# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['SecretBackendRole']


class SecretBackendRole(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backend: Optional[pulumi.Input[str]] = None,
                 creation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 db_name: Optional[pulumi.Input[str]] = None,
                 default_ttl: Optional[pulumi.Input[int]] = None,
                 max_ttl: Optional[pulumi.Input[int]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## Import

        Database secret backend roles can be imported using the `backend`, `/roles/`, and the `name` e.g.

        ```sh
         $ pulumi import vault:database/secretBackendRole:SecretBackendRole example postgres/roles/my-role
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[int] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[int] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[str] name: A unique name to give the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            if backend is None:
                raise TypeError("Missing required property 'backend'")
            __props__['backend'] = backend
            if creation_statements is None:
                raise TypeError("Missing required property 'creation_statements'")
            __props__['creation_statements'] = creation_statements
            if db_name is None:
                raise TypeError("Missing required property 'db_name'")
            __props__['db_name'] = db_name
            __props__['default_ttl'] = default_ttl
            __props__['max_ttl'] = max_ttl
            __props__['name'] = name
            __props__['renew_statements'] = renew_statements
            __props__['revocation_statements'] = revocation_statements
            __props__['rollback_statements'] = rollback_statements
        super(SecretBackendRole, __self__).__init__(
            'vault:database/secretBackendRole:SecretBackendRole',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backend: Optional[pulumi.Input[str]] = None,
            creation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            db_name: Optional[pulumi.Input[str]] = None,
            default_ttl: Optional[pulumi.Input[int]] = None,
            max_ttl: Optional[pulumi.Input[int]] = None,
            name: Optional[pulumi.Input[str]] = None,
            renew_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            revocation_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rollback_statements: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'SecretBackendRole':
        """
        Get an existing SecretBackendRole resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backend: The unique name of the Vault mount to configure.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] creation_statements: The database statements to execute when
               creating a user.
        :param pulumi.Input[str] db_name: The unique name of the database connection to use for
               the role.
        :param pulumi.Input[int] default_ttl: The default number of seconds for leases for this
               role.
        :param pulumi.Input[int] max_ttl: The maximum number of seconds for leases for this
               role.
        :param pulumi.Input[str] name: A unique name to give the role.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] renew_statements: The database statements to execute when
               renewing a user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] revocation_statements: The database statements to execute when
               revoking a user.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] rollback_statements: The database statements to execute when
               rolling back creation due to an error.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["backend"] = backend
        __props__["creation_statements"] = creation_statements
        __props__["db_name"] = db_name
        __props__["default_ttl"] = default_ttl
        __props__["max_ttl"] = max_ttl
        __props__["name"] = name
        __props__["renew_statements"] = renew_statements
        __props__["revocation_statements"] = revocation_statements
        __props__["rollback_statements"] = rollback_statements
        return SecretBackendRole(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def backend(self) -> pulumi.Output[str]:
        """
        The unique name of the Vault mount to configure.
        """
        return pulumi.get(self, "backend")

    @property
    @pulumi.getter(name="creationStatements")
    def creation_statements(self) -> pulumi.Output[Sequence[str]]:
        """
        The database statements to execute when
        creating a user.
        """
        return pulumi.get(self, "creation_statements")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> pulumi.Output[str]:
        """
        The unique name of the database connection to use for
        the role.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="defaultTtl")
    def default_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The default number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "default_ttl")

    @property
    @pulumi.getter(name="maxTtl")
    def max_ttl(self) -> pulumi.Output[Optional[int]]:
        """
        The maximum number of seconds for leases for this
        role.
        """
        return pulumi.get(self, "max_ttl")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        A unique name to give the role.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="renewStatements")
    def renew_statements(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The database statements to execute when
        renewing a user.
        """
        return pulumi.get(self, "renew_statements")

    @property
    @pulumi.getter(name="revocationStatements")
    def revocation_statements(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The database statements to execute when
        revoking a user.
        """
        return pulumi.get(self, "revocation_statements")

    @property
    @pulumi.getter(name="rollbackStatements")
    def rollback_statements(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The database statements to execute when
        rolling back creation due to an error.
        """
        return pulumi.get(self, "rollback_statements")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

