# mypy-boto3-workmail

[![PyPI - mypy-boto3-workmail](https://img.shields.io/pypi/v/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-workmail.svg?color=blue)](https://pypi.org/project/mypy-boto3-workmail)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

- [mypy-boto3-workmail](#mypy-boto3-workmail)
  - [How to use](#how-to-use)
  - [Automated type discovery](#automated-type-discovery)


Type annotations for
[boto3.WorkMail 1.13.24](https://boto3.amazonaws.com/v1/documentation/api/1.13.24/reference/services/workmail.html#WorkMail) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 2.0.2](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-workmail](#mypy-boto3-workmail)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `WorkMail` service.

```bash
python -m pip install boto3-stubs[workmail]

# update installed packages index for automated type discovery
python -m mypy_boto3
```

Use `boto3` with `mypy_boto3_workmail` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3_workmail import WorkMailClient

# Now mypy can check if your code is valid.
client: WorkMailClient = boto3.client("workmail")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: WorkMailClient = session.client("workmail")



# Annotated paginators are included as well

import mypy_boto3_workmail.paginator as workmail_paginators

list_aliases_paginator: workmail_paginators.ListAliasesPaginator = client.get_paginator("list_aliases")
list_group_members_paginator: workmail_paginators.ListGroupMembersPaginator = client.get_paginator("list_group_members")
list_groups_paginator: workmail_paginators.ListGroupsPaginator = client.get_paginator("list_groups")
list_mailbox_permissions_paginator: workmail_paginators.ListMailboxPermissionsPaginator = client.get_paginator("list_mailbox_permissions")
list_organizations_paginator: workmail_paginators.ListOrganizationsPaginator = client.get_paginator("list_organizations")
list_resource_delegates_paginator: workmail_paginators.ListResourceDelegatesPaginator = client.get_paginator("list_resource_delegates")
list_resources_paginator: workmail_paginators.ListResourcesPaginator = client.get_paginator("list_resources")
list_users_paginator: workmail_paginators.ListUsersPaginator = client.get_paginator("list_users")
```

## Automated type discovery

`mypy_boto3` package can generate index for `mypy_boto3_workmail` and other installed services.

```bash
# Run this command when you add or remove service packages
python -m mypy_boto3
```

Generated index provides overloads for `boto3.client` and `boto3.service`,
`boto3.Session.client` and `boto3.Session.resource` functions,
so explicit type annotations are not needed.

- `mypy` supports function overloads as expected
- `PyCharm` also supports function overloads, but consumes a lot of RAM, use carefully
- `VSCode` does not currently support function overloads

Also, generated index allows you to import types from `mypy_boto3`:

```python
# you can replace imports
import mypy_boto3_workmail as workmail
from mypy_boto3_workmail import WorkMailClient

# with these
from mypy_boto3 import workmail
from mypy_boto3.workmail import WorkMailClient
```