# Data export

Data generated by *steinbock* can be exported to various formats for downstream data analysis.

## OME-TIFF

To export images to OME-TIFF, with channel names determined by the panel file:

    steinbock export ome

The exported OME-TIFF files are generated by [xtiff](https://github.com/BodenmillerGroup/xtiff); the default destination directory is `ome`.

## CSV

To export specified object data from all images as a single .csv file:

    steinbock export csv intensities regionprops

This will collect object data from the `intensities` and `regionprops` directories and create a single object data table in [object data format](../specs/file-types.md#object-data), with an additional first column indicating the source image. The default destination file is `objects.csv`.

## FCS

To export specified object data from all images as a single .fcs file:

    steinbock export fcs intensities regionprops

This will collect object data from the `intensities` and `regionprops` directories and create a single object data table in FCS format using the [fcswrite](https://github.com/ZELLMECHANIK-DRESDEN/fcswrite) package. The default destination file is `objects.fcs`.

## AnnData

To export specified object data to [AnnData](https://github.com/theislab/anndata):

    steinbock export anndata --x intensities --obs regionprops

By default, this will generate one .h5ad file per image, with object intensities as main data and object regionprops as observations annotation. The default destination directory is `anndata`.

!!! note "AnnData file format"
    To export the data as .loom or .zarr, specify `--format loom` or `--format zarr`, respectively.

!!! note "Multiple observations annotation sources"
    The `--obs` option can be specified multiple times to include different object data as observations annotations.

## Graphs

To export spatial object graphs with object data as node attributes:

    steinbock export graphs --data intensities

By default, this will generate one .graphml file per graph using the [networkx](https://networkx.org) Python package, with object intensities as node attributes. The default destination directory is `graphs`.

!!! note "NetworkX file format"
    To export the graphs as .gexf or .gml, specify `--format gexf` or `--format gml`, respectively.

!!! note "Multiple graph attributes sources"
    The `--data` option can be specified multiple times to include different object data as graph attributes.
