# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables

__all__ = ['CloudIntegrationGcp']


class CloudIntegrationGcp(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 force_save: Optional[pulumi.Input[bool]] = None,
                 json_key: Optional[pulumi.Input[str]] = None,
                 metric_filter_regex: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 service: Optional[pulumi.Input[str]] = None,
                 service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Wavefront Cloud Integration for GCP. This allows GCP cloud integrations to be created,
        updated, and deleted.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_wavefront as wavefront

        gcp = wavefront.CloudIntegrationGcp("gcp",
            json_key=\"\"\"{...your gcp key ...}

        \"\"\",
            project_id="example-gcp-project")
        ```

        ## Import

        GCP Cloud Integrations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/cloudIntegrationGcp:CloudIntegrationGcp gcp a411c16b-3cf7-4f03-bf11-8ca05aab898d
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
               `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
               `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
               `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
               `TPU`, `VPN`
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] json_key: Private key for a Google Cloud Platform (GCP) service account within your project.
               The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] project_id: The Google Cloud Platform (GCP) Project Id
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['additional_tags'] = additional_tags
            __props__['categories'] = categories
            __props__['force_save'] = force_save
            if json_key is None and not opts.urn:
                raise TypeError("Missing required property 'json_key'")
            __props__['json_key'] = json_key
            __props__['metric_filter_regex'] = metric_filter_regex
            __props__['name'] = name
            if project_id is None and not opts.urn:
                raise TypeError("Missing required property 'project_id'")
            __props__['project_id'] = project_id
            if service is None and not opts.urn:
                raise TypeError("Missing required property 'service'")
            __props__['service'] = service
            __props__['service_refresh_rate_in_minutes'] = service_refresh_rate_in_minutes
        super(CloudIntegrationGcp, __self__).__init__(
            'wavefront:index/cloudIntegrationGcp:CloudIntegrationGcp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            additional_tags: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            categories: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            force_save: Optional[pulumi.Input[bool]] = None,
            json_key: Optional[pulumi.Input[str]] = None,
            metric_filter_regex: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            project_id: Optional[pulumi.Input[str]] = None,
            service: Optional[pulumi.Input[str]] = None,
            service_refresh_rate_in_minutes: Optional[pulumi.Input[int]] = None) -> 'CloudIntegrationGcp':
        """
        Get an existing CloudIntegrationGcp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] additional_tags: A list of point tag key-values to add to every point ingested using this integration
        :param pulumi.Input[Sequence[pulumi.Input[str]]] categories: A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
               `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
               `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
               `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
               `TPU`, `VPN`
        :param pulumi.Input[bool] force_save: Forces this resource to save, even if errors are present
        :param pulumi.Input[str] json_key: Private key for a Google Cloud Platform (GCP) service account within your project.
               The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        :param pulumi.Input[str] metric_filter_regex: A regular expression that a metric name must match (case-insensitively) in order to be ingested
        :param pulumi.Input[str] name: The human-readable name of this integration
        :param pulumi.Input[str] project_id: The Google Cloud Platform (GCP) Project Id
        :param pulumi.Input[str] service: A value denoting which cloud service this service integrates with
        :param pulumi.Input[int] service_refresh_rate_in_minutes: How often, in minutes, to refresh the service
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["additional_tags"] = additional_tags
        __props__["categories"] = categories
        __props__["force_save"] = force_save
        __props__["json_key"] = json_key
        __props__["metric_filter_regex"] = metric_filter_regex
        __props__["name"] = name
        __props__["project_id"] = project_id
        __props__["service"] = service
        __props__["service_refresh_rate_in_minutes"] = service_refresh_rate_in_minutes
        return CloudIntegrationGcp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="additionalTags")
    def additional_tags(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        A list of point tag key-values to add to every point ingested using this integration
        """
        return pulumi.get(self, "additional_tags")

    @property
    @pulumi.getter
    def categories(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of Google Cloud Platform (GCP) services.  Valid values are `APPENGINE`, 
        `BIGQUERY`, `BIGTABLE`, `CLOUDFUNCTIONS`, `CLOUDIOT`, `CLOUDSQL`, `CLOUDTASKS`, `COMPUTE`, `CONTAINER`,
        `DATAFLOW`, `DATAPROC`, `DATASTORE`, `FIREBASEDATABASE`, `FIREBASEHOSTING`, `FIRESTORE`, `INTERCONNECT`,
        `LOADBALANCING`, `LOGGING`, `ML`, `MONITORING`, `PUBSUB`, `REDIS`, `ROUTER`, `SERVICERUNTIME`, `SPANNER`, `STORAGE`,
        `TPU`, `VPN`
        """
        return pulumi.get(self, "categories")

    @property
    @pulumi.getter(name="forceSave")
    def force_save(self) -> pulumi.Output[Optional[bool]]:
        """
        Forces this resource to save, even if errors are present
        """
        return pulumi.get(self, "force_save")

    @property
    @pulumi.getter(name="jsonKey")
    def json_key(self) -> pulumi.Output[str]:
        """
        Private key for a Google Cloud Platform (GCP) service account within your project.
        The account must be at least granted Monitoring Viewer permissions. This key must be in the JSON format generated by GCP.
        """
        return pulumi.get(self, "json_key")

    @property
    @pulumi.getter(name="metricFilterRegex")
    def metric_filter_regex(self) -> pulumi.Output[Optional[str]]:
        """
        A regular expression that a metric name must match (case-insensitively) in order to be ingested
        """
        return pulumi.get(self, "metric_filter_regex")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The human-readable name of this integration
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> pulumi.Output[str]:
        """
        The Google Cloud Platform (GCP) Project Id
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def service(self) -> pulumi.Output[str]:
        """
        A value denoting which cloud service this service integrates with
        """
        return pulumi.get(self, "service")

    @property
    @pulumi.getter(name="serviceRefreshRateInMinutes")
    def service_refresh_rate_in_minutes(self) -> pulumi.Output[Optional[int]]:
        """
        How often, in minutes, to refresh the service
        """
        return pulumi.get(self, "service_refresh_rate_in_minutes")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

