# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from . import _utilities, _tables
from . import outputs
from ._inputs import *

__all__ = ['Dashboard']


class Dashboard(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 can_views: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_query_parameters: Optional[pulumi.Input[bool]] = None,
                 display_section_table_of_contents: Optional[pulumi.Input[bool]] = None,
                 event_filter_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 parameter_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardParameterDetailArgs']]]]] = None,
                 sections: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardSectionArgs']]]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 url: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        Provides a Wavefront Dashboard resource.  This allows dashboards to be created, updated, and deleted.

        ## Import

        Dashboards can be imported using the `id`, e.g.

        ```sh
         $ pulumi import wavefront:index/dashboard:Dashboard dashboard tftestimport
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] can_modifies: A list of users that have modify ACL access to the dashboard
        :param pulumi.Input[Sequence[pulumi.Input[str]]] can_views: A list of users that have view ACL access to the dashboard
        :param pulumi.Input[str] description: Human-readable description of the dashboard
        :param pulumi.Input[bool] display_query_parameters: Whether the dashboard parameters section is opened by default when the dashboard
               is shown
        :param pulumi.Input[bool] display_section_table_of_contents: Whether the "pills" quick-linked the sections of the dashboard are 
               displayed by default when the dashboard is shown
        :param pulumi.Input[str] event_filter_type: How charts belonging to this dashboard should display events. BYCHART is default if 
               unspecified; Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`
        :param pulumi.Input[str] name: Name of the dashboard
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardParameterDetailArgs']]]] parameter_details: The current JSON representation of dashboard parameters. See parameter details
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardSectionArgs']]]] sections: Dashboard chart sections. See dashboard sections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of tags to assign to this resource.
        :param pulumi.Input[str] url: Unique identifier, also URL slug, of the dashboard
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['can_modifies'] = can_modifies
            __props__['can_views'] = can_views
            if description is None and not opts.urn:
                raise TypeError("Missing required property 'description'")
            __props__['description'] = description
            __props__['display_query_parameters'] = display_query_parameters
            __props__['display_section_table_of_contents'] = display_section_table_of_contents
            __props__['event_filter_type'] = event_filter_type
            __props__['name'] = name
            __props__['parameter_details'] = parameter_details
            if sections is None and not opts.urn:
                raise TypeError("Missing required property 'sections'")
            __props__['sections'] = sections
            if tags is None and not opts.urn:
                raise TypeError("Missing required property 'tags'")
            __props__['tags'] = tags
            if url is None and not opts.urn:
                raise TypeError("Missing required property 'url'")
            __props__['url'] = url
        super(Dashboard, __self__).__init__(
            'wavefront:index/dashboard:Dashboard',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            can_modifies: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            can_views: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_query_parameters: Optional[pulumi.Input[bool]] = None,
            display_section_table_of_contents: Optional[pulumi.Input[bool]] = None,
            event_filter_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parameter_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardParameterDetailArgs']]]]] = None,
            sections: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardSectionArgs']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            url: Optional[pulumi.Input[str]] = None) -> 'Dashboard':
        """
        Get an existing Dashboard resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] can_modifies: A list of users that have modify ACL access to the dashboard
        :param pulumi.Input[Sequence[pulumi.Input[str]]] can_views: A list of users that have view ACL access to the dashboard
        :param pulumi.Input[str] description: Human-readable description of the dashboard
        :param pulumi.Input[bool] display_query_parameters: Whether the dashboard parameters section is opened by default when the dashboard
               is shown
        :param pulumi.Input[bool] display_section_table_of_contents: Whether the "pills" quick-linked the sections of the dashboard are 
               displayed by default when the dashboard is shown
        :param pulumi.Input[str] event_filter_type: How charts belonging to this dashboard should display events. BYCHART is default if 
               unspecified; Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`
        :param pulumi.Input[str] name: Name of the dashboard
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardParameterDetailArgs']]]] parameter_details: The current JSON representation of dashboard parameters. See parameter details
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DashboardSectionArgs']]]] sections: Dashboard chart sections. See dashboard sections
        :param pulumi.Input[Sequence[pulumi.Input[str]]] tags: A set of tags to assign to this resource.
        :param pulumi.Input[str] url: Unique identifier, also URL slug, of the dashboard
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["can_modifies"] = can_modifies
        __props__["can_views"] = can_views
        __props__["description"] = description
        __props__["display_query_parameters"] = display_query_parameters
        __props__["display_section_table_of_contents"] = display_section_table_of_contents
        __props__["event_filter_type"] = event_filter_type
        __props__["name"] = name
        __props__["parameter_details"] = parameter_details
        __props__["sections"] = sections
        __props__["tags"] = tags
        __props__["url"] = url
        return Dashboard(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="canModifies")
    def can_modifies(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of users that have modify ACL access to the dashboard
        """
        return pulumi.get(self, "can_modifies")

    @property
    @pulumi.getter(name="canViews")
    def can_views(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of users that have view ACL access to the dashboard
        """
        return pulumi.get(self, "can_views")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Human-readable description of the dashboard
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayQueryParameters")
    def display_query_parameters(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the dashboard parameters section is opened by default when the dashboard
        is shown
        """
        return pulumi.get(self, "display_query_parameters")

    @property
    @pulumi.getter(name="displaySectionTableOfContents")
    def display_section_table_of_contents(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether the "pills" quick-linked the sections of the dashboard are 
        displayed by default when the dashboard is shown
        """
        return pulumi.get(self, "display_section_table_of_contents")

    @property
    @pulumi.getter(name="eventFilterType")
    def event_filter_type(self) -> pulumi.Output[Optional[str]]:
        """
        How charts belonging to this dashboard should display events. BYCHART is default if 
        unspecified; Valid options are: `BYCHART`, `AUTOMATIC`, `ALL`, `NONE`, `BYDASHBOARD`, and `BYCHARTANDDASHBOARD`
        """
        return pulumi.get(self, "event_filter_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Name of the dashboard
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parameterDetails")
    def parameter_details(self) -> pulumi.Output[Optional[Sequence['outputs.DashboardParameterDetail']]]:
        """
        The current JSON representation of dashboard parameters. See parameter details
        """
        return pulumi.get(self, "parameter_details")

    @property
    @pulumi.getter
    def sections(self) -> pulumi.Output[Sequence['outputs.DashboardSection']]:
        """
        Dashboard chart sections. See dashboard sections
        """
        return pulumi.get(self, "sections")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Sequence[str]]:
        """
        A set of tags to assign to this resource.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        Unique identifier, also URL slug, of the dashboard
        """
        return pulumi.get(self, "url")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

