# Navigation Grid Visualization

A lightweight Python3 library for visualizing high-dimensional data.
It is designed for experimental research on Navigation problems. However, the same APIs could be useful for a variety of applications.

It is built on Matplotlib with the goal provide an easy interface for 2D representation and annotation of high dimensional state spaces.

For instance, using just one line of code, this library could
- Render n x n state space.
- Label each state.
- Enable state/feature level grid.
- Draw trajectories
- Visualize features such as one-hot indicator variable, vector, and RGB image.


## Installation

To install current release with [pip](https://pypi.python.org/pypi/pip):

    pip install navigation-vis


To install from source:

    python setup.py install


## Usage
If you're curious what it can do, check out some examples on

### 1. Jupyter Notebook
[Raster grid view](./navgridviews_raster.ipynb)

### 2. Google Colab
[![Open In Colab](https://colab.research.google.com/assets/colab-badge.svg)](https://colab.research.google.com/github/yrevar/navigation_vis/blob/main/navgridviews_raster.ipynb)

### 3. My Binder
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/yrevar/navigation_vis/HEAD)
