import re
import os
import os.path

COORD_REGEX = re.compile(os.environ.get('PANKMER_COORD_REGEX', # Not used yet, but will be useful later
                                        '([Cc]hr)?[0-9XY]+:[0-9]+-[0-9]+$'))
GENES_PATH = os.environ.get('PANKMER_GENES_PATH') # Not used yet, but will be useful later

EXAMPLE_DATA_URL = 'https://salk-tm-pub.s3.us-west-2.amazonaws.com/PanKmer_example/PanKmer_example_Sp_Chr19.tar.gz'
EXAMPLE_DATA_DIR = os.environ.get('PANKMER_EXAMPLE_DATA_DIR', os.path.dirname(__file__))
BACTERIAL_DATA_FTP = 'ftp.ncbi.nlm.nih.gov'
BACTERIAL_DATA_PATHS = (
    'genomes/all/GCF/000/772/125/GCF_000772125.1_ASM77212v1/GCF_000772125.1_ASM77212v1_genomic.fna.gz',
    'genomes/all/GCF/000/772/165/GCF_000772165.1_ASM77216v1/GCF_000772165.1_ASM77216v1_genomic.fna.gz',
    'genomes/all/GCF/000/772/205/GCF_000772205.1_ASM77220v1/GCF_000772205.1_ASM77220v1_genomic.fna.gz',
    'genomes/all/GCF/000/782/835/GCF_000782835.1_ASM78283v1/GCF_000782835.1_ASM78283v1_genomic.fna.gz',
    'genomes/all/GCF/000/789/295/GCF_000789295.1_ASM78929v1/GCF_000789295.1_ASM78929v1_genomic.fna.gz',
    'genomes/all/GCF/000/952/895/GCF_000952895.1_BS34ACh/GCF_000952895.1_BS34ACh_genomic.fna.gz',
    'genomes/all/GCF/000/953/615/GCF_000953615.1_BS49Ch/GCF_000953615.1_BS49Ch_genomic.fna.gz',
    'genomes/all/GCF/001/015/095/GCF_001015095.1_ASM101509v1/GCF_001015095.1_ASM101509v1_genomic.fna.gz',
    'genomes/all/GCF/001/037/985/GCF_001037985.1_ASM103798v1/GCF_001037985.1_ASM103798v1_genomic.fna.gz',
    'genomes/all/GCF/001/604/995/GCF_001604995.1_ASM160499v1/GCF_001604995.1_ASM160499v1_genomic.fna.gz',
    'genomes/all/GCF/001/704/095/GCF_001704095.1_ASM170409v1/GCF_001704095.1_ASM170409v1_genomic.fna.gz',
    'genomes/all/GCF/001/720/505/GCF_001720505.1_ASM172050v1/GCF_001720505.1_ASM172050v1_genomic.fna.gz',
    'genomes/all/GCF/001/746/575/GCF_001746575.1_ASM174657v1/GCF_001746575.1_ASM174657v1_genomic.fna.gz',
    'genomes/all/GCF/001/747/445/GCF_001747445.1_ASM174744v1/GCF_001747445.1_ASM174744v1_genomic.fna.gz',
    'genomes/all/GCF/001/808/235/GCF_001808235.1_ASM180823v1/GCF_001808235.1_ASM180823v1_genomic.fna.gz',
    'genomes/all/GCF/001/889/385/GCF_001889385.1_ASM188938v1/GCF_001889385.1_ASM188938v1_genomic.fna.gz',
    'genomes/all/GCF/001/889/625/GCF_001889625.1_ASM188962v1/GCF_001889625.1_ASM188962v1_genomic.fna.gz',
    'genomes/all/GCF/001/890/405/GCF_001890405.1_ASM189040v1/GCF_001890405.1_ASM189040v1_genomic.fna.gz',
    'genomes/all/GCF/001/902/555/GCF_001902555.1_ASM190255v1/GCF_001902555.1_ASM190255v1_genomic.fna.gz',
    'genomes/all/GCF/002/055/965/GCF_002055965.1_ASM205596v1/GCF_002055965.1_ASM205596v1_genomic.fna.gz',
    'genomes/all/GCF/002/072/735/GCF_002072735.1_ASM207273v1/GCF_002072735.1_ASM207273v1_genomic.fna.gz',
    'genomes/all/GCF/002/096/095/GCF_002096095.1_ASM209609v1/GCF_002096095.1_ASM209609v1_genomic.fna.gz',
    'genomes/all/GCF/002/142/595/GCF_002142595.1_ASM214259v1/GCF_002142595.1_ASM214259v1_genomic.fna.gz',
    'genomes/all/GCF/002/163/815/GCF_002163815.1_ASM216381v1/GCF_002163815.1_ASM216381v1_genomic.fna.gz',
    'genomes/all/GCF/002/202/055/GCF_002202055.1_ASM220205v1/GCF_002202055.1_ASM220205v1_genomic.fna.gz',
    'genomes/all/GCF/002/216/085/GCF_002216085.1_ASM221608v1/GCF_002216085.1_ASM221608v1_genomic.fna.gz',
    'genomes/all/GCF/002/269/175/GCF_002269175.1_ASM226917v1/GCF_002269175.1_ASM226917v1_genomic.fna.gz',
    'genomes/all/GCF/002/269/195/GCF_002269195.1_ASM226919v1/GCF_002269195.1_ASM226919v1_genomic.fna.gz',
    'genomes/all/GCF/002/290/305/GCF_002290305.1_ASM229030v1/GCF_002290305.1_ASM229030v1_genomic.fna.gz',
    'genomes/all/GCF/002/893/805/GCF_002893805.1_ASM289380v1/GCF_002893805.1_ASM289380v1_genomic.fna.gz',
    'genomes/all/GCF/002/982/175/GCF_002982175.1_ASM298217v1/GCF_002982175.1_ASM298217v1_genomic.fna.gz',
    'genomes/all/GCF/003/148/355/GCF_003148355.1_ASM314835v2/GCF_003148355.1_ASM314835v2_genomic.fna.gz',
    'genomes/all/GCF/003/184/225/GCF_003184225.1_ASM318422v1/GCF_003184225.1_ASM318422v1_genomic.fna.gz',
    'genomes/all/GCF/003/610/955/GCF_003610955.1_ASM361095v1/GCF_003610955.1_ASM361095v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/345/GCF_004101345.1_ASM410134v1/GCF_004101345.1_ASM410134v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/365/GCF_004101365.1_ASM410136v1/GCF_004101365.1_ASM410136v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/405/GCF_004101405.1_ASM410140v1/GCF_004101405.1_ASM410140v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/425/GCF_004101425.1_ASM410142v1/GCF_004101425.1_ASM410142v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/445/GCF_004101445.1_ASM410144v1/GCF_004101445.1_ASM410144v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/465/GCF_004101465.1_ASM410146v1/GCF_004101465.1_ASM410146v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/485/GCF_004101485.1_ASM410148v1/GCF_004101485.1_ASM410148v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/565/GCF_004101565.1_ASM410156v1/GCF_004101565.1_ASM410156v1_genomic.fna.gz',
    'genomes/all/GCF/004/101/945/GCF_004101945.1_ASM410194v1/GCF_004101945.1_ASM410194v1_genomic.fna.gz',
    'genomes/all/GCF/004/103/535/GCF_004103535.1_ASM410353v1/GCF_004103535.1_ASM410353v1_genomic.fna.gz',
    'genomes/all/GCF/004/103/555/GCF_004103555.1_ASM410355v1/GCF_004103555.1_ASM410355v1_genomic.fna.gz',
    'genomes/all/GCF/004/103/595/GCF_004103595.1_ASM410359v1/GCF_004103595.1_ASM410359v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/535/GCF_004119535.1_ASM411953v1/GCF_004119535.1_ASM411953v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/555/GCF_004119555.1_ASM411955v1/GCF_004119555.1_ASM411955v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/595/GCF_004119595.1_ASM411959v1/GCF_004119595.1_ASM411959v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/615/GCF_004119615.1_ASM411961v1/GCF_004119615.1_ASM411961v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/635/GCF_004119635.1_ASM411963v1/GCF_004119635.1_ASM411963v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/655/GCF_004119655.1_ASM411965v1/GCF_004119655.1_ASM411965v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/675/GCF_004119675.1_ASM411967v1/GCF_004119675.1_ASM411967v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/695/GCF_004119695.1_ASM411969v1/GCF_004119695.1_ASM411969v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/715/GCF_004119715.1_ASM411971v1/GCF_004119715.1_ASM411971v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/775/GCF_004119775.1_ASM411977v1/GCF_004119775.1_ASM411977v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/815/GCF_004119815.1_ASM411981v1/GCF_004119815.1_ASM411981v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/835/GCF_004119835.1_ASM411983v1/GCF_004119835.1_ASM411983v1_genomic.fna.gz',
    'genomes/all/GCF/004/119/875/GCF_004119875.1_ASM411987v1/GCF_004119875.1_ASM411987v1_genomic.fna.gz',
    'genomes/all/GCF/005/160/425/GCF_005160425.1_ASM516042v1/GCF_005160425.1_ASM516042v1_genomic.fna.gz',
    'genomes/all/GCF/005/234/095/GCF_005234095.1_ASM523409v1/GCF_005234095.1_ASM523409v1_genomic.fna.gz',
    'genomes/all/GCF/005/849/145/GCF_005849145.1_ASM584914v1/GCF_005849145.1_ASM584914v1_genomic.fna.gz',
    'genomes/all/GCF/006/165/085/GCF_006165085.1_ASM616508v1/GCF_006165085.1_ASM616508v1_genomic.fna.gz',
    'genomes/all/GCF/006/364/495/GCF_006364495.1_ASM636449v1/GCF_006364495.1_ASM636449v1_genomic.fna.gz',
    'genomes/all/GCF/008/831/405/GCF_008831405.1_ASM883140v1/GCF_008831405.1_ASM883140v1_genomic.fna.gz',
    'genomes/all/GCF/009/363/835/GCF_009363835.1_ASM936383v1/GCF_009363835.1_ASM936383v1_genomic.fna.gz',
    'genomes/all/GCF/009/497/795/GCF_009497795.1_ASM949779v1/GCF_009497795.1_ASM949779v1_genomic.fna.gz',
    'genomes/all/GCF/009/497/815/GCF_009497815.1_ASM949781v1/GCF_009497815.1_ASM949781v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/155/GCF_009662155.1_ASM966215v1/GCF_009662155.1_ASM966215v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/175/GCF_009662175.1_ASM966217v1/GCF_009662175.1_ASM966217v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/195/GCF_009662195.1_ASM966219v1/GCF_009662195.1_ASM966219v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/215/GCF_009662215.1_ASM966221v1/GCF_009662215.1_ASM966221v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/235/GCF_009662235.1_ASM966223v1/GCF_009662235.1_ASM966223v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/255/GCF_009662255.1_ASM966225v1/GCF_009662255.1_ASM966225v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/275/GCF_009662275.1_ASM966227v1/GCF_009662275.1_ASM966227v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/335/GCF_009662335.1_ASM966233v1/GCF_009662335.1_ASM966233v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/355/GCF_009662355.1_ASM966235v1/GCF_009662355.1_ASM966235v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/375/GCF_009662375.1_ASM966237v1/GCF_009662375.1_ASM966237v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/415/GCF_009662415.1_ASM966241v1/GCF_009662415.1_ASM966241v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/435/GCF_009662435.1_ASM966243v1/GCF_009662435.1_ASM966243v1_genomic.fna.gz',
    'genomes/all/GCF/009/662/455/GCF_009662455.1_ASM966245v1/GCF_009662455.1_ASM966245v1_genomic.fna.gz',
    'genomes/all/GCF/009/665/145/GCF_009665145.1_ASM966514v2/GCF_009665145.1_ASM966514v2_genomic.fna.gz',
    'genomes/all/GCF/009/857/115/GCF_009857115.1_ASM985711v1/GCF_009857115.1_ASM985711v1_genomic.fna.gz',
    'genomes/all/GCF/009/866/865/GCF_009866865.1_ASM986686v1/GCF_009866865.1_ASM986686v1_genomic.fna.gz',
    'genomes/all/GCF/009/884/005/GCF_009884005.1_ASM988400v1/GCF_009884005.1_ASM988400v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/255/GCF_009913255.1_ASM991325v1/GCF_009913255.1_ASM991325v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/275/GCF_009913275.1_ASM991327v1/GCF_009913275.1_ASM991327v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/395/GCF_009913395.1_ASM991339v1/GCF_009913395.1_ASM991339v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/515/GCF_009913515.1_ASM991351v1/GCF_009913515.1_ASM991351v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/535/GCF_009913535.1_ASM991353v1/GCF_009913535.1_ASM991353v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/555/GCF_009913555.1_ASM991355v1/GCF_009913555.1_ASM991355v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/575/GCF_009913575.1_ASM991357v1/GCF_009913575.1_ASM991357v1_genomic.fna.gz',
    'genomes/all/GCF/009/913/595/GCF_009913595.1_ASM991359v1/GCF_009913595.1_ASM991359v1_genomic.fna.gz',
    'genomes/all/GCF/009/914/155/GCF_009914155.1_ASM991415v1/GCF_009914155.1_ASM991415v1_genomic.fna.gz',
    'genomes/all/GCF/012/647/565/GCF_012647565.1_ASM1264756v1/GCF_012647565.1_ASM1264756v1_genomic.fna.gz',
    'genomes/all/GCF/013/285/325/GCF_013285325.1_ASM1328532v1/GCF_013285325.1_ASM1328532v1_genomic.fna.gz',
    'genomes/all/GCF/013/388/335/GCF_013388335.1_ASM1338833v1/GCF_013388335.1_ASM1338833v1_genomic.fna.gz',
    'genomes/all/GCF/013/393/725/GCF_013393725.1_ASM1339372v1/GCF_013393725.1_ASM1339372v1_genomic.fna.gz',
    'genomes/all/GCF/014/171/535/GCF_014171535.1_ASM1417153v1/GCF_014171535.1_ASM1417153v1_genomic.fna.gz',
    'genomes/all/GCF/014/879/275/GCF_014879275.1_ASM1487927v1/GCF_014879275.1_ASM1487927v1_genomic.fna.gz',
    'genomes/all/GCF/015/535/655/GCF_015535655.1_ASM1553565v1/GCF_015535655.1_ASM1553565v1_genomic.fna.gz',
    'genomes/all/GCF/015/602/625/GCF_015602625.1_ASM1560262v1/GCF_015602625.1_ASM1560262v1_genomic.fna.gz',
    'genomes/all/GCF/015/654/205/GCF_015654205.1_ASM1565420v1/GCF_015654205.1_ASM1565420v1_genomic.fna.gz',
    'genomes/all/GCF/016/065/415/GCF_016065415.1_ASM1606541v1/GCF_016065415.1_ASM1606541v1_genomic.fna.gz',
    'genomes/all/GCF/016/894/165/GCF_016894165.1_ASM1689416v1/GCF_016894165.1_ASM1689416v1_genomic.fna.gz',
    'genomes/all/GCF/017/753/785/GCF_017753785.1_ASM1775378v1/GCF_017753785.1_ASM1775378v1_genomic.fna.gz',
    'genomes/all/GCF/018/394/175/GCF_018394175.1_ASM1839417v1/GCF_018394175.1_ASM1839417v1_genomic.fna.gz',
    'genomes/all/GCF/018/884/165/GCF_018884165.1_ASM1888416v1/GCF_018884165.1_ASM1888416v1_genomic.fna.gz',
    'genomes/all/GCF/000/523/045/GCF_000523045.1_ASM52304v1/GCF_000523045.1_ASM52304v1_genomic.fna.gz',
    'genomes/all/GCF/000/186/745/GCF_000186745.1_ASM18674v1/GCF_000186745.1_ASM18674v1_genomic.fna.gz',
    'genomes/all/GCF/000/973/605/GCF_000973605.1_ASM97360v1/GCF_000973605.1_ASM97360v1_genomic.fna.gz',
    'genomes/all/GCF/000/971/925/GCF_000971925.1_ASM97192v1/GCF_000971925.1_ASM97192v1_genomic.fna.gz',
    'genomes/all/GCF/000/497/485/GCF_000497485.1_ASM49748v1/GCF_000497485.1_ASM49748v1_genomic.fna.gz',
    'genomes/all/GCF/000/293/765/GCF_000293765.1_ASM29376v1/GCF_000293765.1_ASM29376v1_genomic.fna.gz',
    'genomes/all/GCF/001/597/265/GCF_001597265.1_ASM159726v1/GCF_001597265.1_ASM159726v1_genomic.fna.gz',
    'genomes/all/GCF/001/565/875/GCF_001565875.1_ASM156587v1/GCF_001565875.1_ASM156587v1_genomic.fna.gz',
    'genomes/all/GCF/000/209/795/GCF_000209795.2_ASM20979v2/GCF_000209795.2_ASM20979v2_genomic.fna.gz',
    'genomes/all/GCF/006/094/475/GCF_006094475.1_ASM609447v1/GCF_006094475.1_ASM609447v1_genomic.fna.gz',
    'genomes/all/GCF/000/146/565/GCF_000146565.1_ASM14656v1/GCF_000146565.1_ASM14656v1_genomic.fna.gz',
    'genomes/all/GCF/000/227/465/GCF_000227465.1_ASM22746v1/GCF_000227465.1_ASM22746v1_genomic.fna.gz',
    'genomes/all/GCF/000/827/065/GCF_000827065.1_ASM82706v1/GCF_000827065.1_ASM82706v1_genomic.fna.gz',
    'genomes/all/GCF/001/465/815/GCF_001465815.1_ASM146581v1/GCF_001465815.1_ASM146581v1_genomic.fna.gz',
    'genomes/all/GCF/001/541/905/GCF_001541905.1_ASM154190v1/GCF_001541905.1_ASM154190v1_genomic.fna.gz',
    'genomes/all/GCF/001/660/525/GCF_001660525.1_ASM166052v1/GCF_001660525.1_ASM166052v1_genomic.fna.gz',
    'genomes/all/GCF/001/697/265/GCF_001697265.1_ASM169726v1/GCF_001697265.1_ASM169726v1_genomic.fna.gz',
    'genomes/all/GCF/001/703/495/GCF_001703495.1_ASM170349v1/GCF_001703495.1_ASM170349v1_genomic.fna.gz',
    'genomes/all/GCF/002/173/615/GCF_002173615.1_ASM217361v1/GCF_002173615.1_ASM217361v1_genomic.fna.gz',
    'genomes/all/GCF/002/173/695/GCF_002173695.1_ASM217369v1/GCF_002173695.1_ASM217369v1_genomic.fna.gz',
    'genomes/all/GCF/002/173/715/GCF_002173715.1_ASM217371v1/GCF_002173715.1_ASM217371v1_genomic.fna.gz',
    'genomes/all/GCF/002/201/955/GCF_002201955.1_ASM220195v1/GCF_002201955.1_ASM220195v1_genomic.fna.gz',
    'genomes/all/GCF/002/201/995/GCF_002201995.1_ASM220199v1/GCF_002201995.1_ASM220199v1_genomic.fna.gz',
    'genomes/all/GCF/002/202/035/GCF_002202035.1_ASM220203v1/GCF_002202035.1_ASM220203v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/195/GCF_003665195.1_ASM366519v1/GCF_003665195.1_ASM366519v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/215/GCF_003665215.1_ASM366521v1/GCF_003665215.1_ASM366521v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/235/GCF_003665235.1_ASM366523v1/GCF_003665235.1_ASM366523v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/255/GCF_003665255.1_ASM366525v1/GCF_003665255.1_ASM366525v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/275/GCF_003665275.1_ASM366527v1/GCF_003665275.1_ASM366527v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/295/GCF_003665295.1_ASM366529v1/GCF_003665295.1_ASM366529v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/315/GCF_003665315.1_ASM366531v1/GCF_003665315.1_ASM366531v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/335/GCF_003665335.1_ASM366533v1/GCF_003665335.1_ASM366533v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/355/GCF_003665355.1_ASM366535v1/GCF_003665355.1_ASM366535v1_genomic.fna.gz',
    'genomes/all/GCF/003/665/395/GCF_003665395.1_ASM366539v1/GCF_003665395.1_ASM366539v1_genomic.fna.gz',
    'genomes/all/GCF/004/328/925/GCF_004328925.1_ASM432892v1/GCF_004328925.1_ASM432892v1_genomic.fna.gz',
    'genomes/all/GCF/006/741/845/GCF_006741845.1_ASM674184v1/GCF_006741845.1_ASM674184v1_genomic.fna.gz',
    'genomes/all/GCF/012/648/205/GCF_012648205.1_ASM1264820v1/GCF_012648205.1_ASM1264820v1_genomic.fna.gz',
    'genomes/all/GCF/012/648/345/GCF_012648345.1_ASM1264834v1/GCF_012648345.1_ASM1264834v1_genomic.fna.gz',
    'genomes/all/GCF/014/298/115/GCF_014298115.1_ASM1429811v1/GCF_014298115.1_ASM1429811v1_genomic.fna.gz',
    'genomes/all/GCF/014/961/985/GCF_014961985.1_ASM1496198v1/GCF_014961985.1_ASM1496198v1_genomic.fna.gz',
    'genomes/all/GCF/018/454/405/GCF_018454405.1_ASM1845440v1/GCF_018454405.1_ASM1845440v1_genomic.fna.gz',
    'genomes/all/GCF/000/344/745/GCF_000344745.1_ASM34474v1/GCF_000344745.1_ASM34474v1_genomic.fna.gz',
    'genomes/all/GCF/006/088/795/GCF_006088795.1_ASM608879v1/GCF_006088795.1_ASM608879v1_genomic.fna.gz',
    'genomes/all/GCF/000/009/045/GCF_000009045.1_ASM904v1/GCF_000009045.1_ASM904v1_genomic.fna.gz',
    'genomes/all/GCF/000/789/275/GCF_000789275.1_ASM78927v1/GCF_000789275.1_ASM78927v1_genomic.fna.gz',
    'genomes/all/GCF/012/931/705/GCF_012931705.2_ASM1293170v2/GCF_012931705.2_ASM1293170v2_genomic.fna.gz',
    'genomes/all/GCF/013/009/385/GCF_013009385.1_ASM1300938v1/GCF_013009385.1_ASM1300938v1_genomic.fna.gz',
    'genomes/all/GCF/000/699/525/GCF_000699525.1_ASM69952v1/GCF_000699525.1_ASM69952v1_genomic.fna.gz',
    'genomes/all/GCF/000/349/795/GCF_000349795.1_ASM34979v1/GCF_000349795.1_ASM34979v1_genomic.fna.gz',
    'genomes/all/GCF/000/321/395/GCF_000321395.1_ASM32139v1/GCF_000321395.1_ASM32139v1_genomic.fna.gz',
    'genomes/all/GCF/000/699/465/GCF_000699465.1_ASM69946v1/GCF_000699465.1_ASM69946v1_genomic.fna.gz',
    'genomes/all/GCF/000/706/705/GCF_000706705.1_ASM70670v1/GCF_000706705.1_ASM70670v1_genomic.fna.gz',
    'genomes/all/GCF/000/227/485/GCF_000227485.1_ASM22748v1/GCF_000227485.1_ASM22748v1_genomic.fna.gz',
    'genomes/all/GCF/012/030/675/GCF_012030675.1_ASM1203067v1/GCF_012030675.1_ASM1203067v1_genomic.fna.gz',
    'genomes/all/GCF/000/737/405/GCF_000737405.1_ASM73740v1/GCF_000737405.1_ASM73740v1_genomic.fna.gz',
    'genomes/all/GCF/000/338/735/GCF_000338735.1_ASM33873v1/GCF_000338735.1_ASM33873v1_genomic.fna.gz'
)

