import pytest
import numpy as np
from itertools import product
from pankmer.index import genome_name, break_seq, score_byte_to_blist, add_score_mat_np


@pytest.fixture(scope='session')
def test_seq():
    return b'ACGCAGCAGTCAGTCGATCGACGGGATATCTATATGCGCGATCTAGCATCCACAGCATGATCGACTAGCGGCATCTCGATCATGCAGCTACTATGCGCGATCTAGCTAGCACTAGCTGGCGCATCTTGAGCTACGCGCTACATCGTAGCTCAGTCAGCTGTCTCATCGAATGATCGATCGCACG'

@pytest.fixture(scope='session')
def break_seq_result():
    return [4158743107228753096, 2799914373632848675, 3707353414664053126, 3293455812279087667, 3950451212261574860, 3228461534772955014, 3255301156629155014, 3797832589661844249, 1851884562429025822, 2768814149820950407, 3253612780133860967, 3791079083680668060, 2060875354152934558, 3973983352358774567, 2821388397338584867, 2554216968736117362, 3637040191570866742, 713102711001303259, 3570731747994970697, 2186271339166076338, 4133399338236917450, 2698539297665506091, 1570785153807248558, 1671454596801606331, 2384401863466497842, 3684843456688761782, 904315771472883419, 3617263085891533676, 3197862605957477175, 2535977153135883975, 3658630926692883251, 3682146302755040370, 2822737818283710899, 3574108622951991079, 1329342618249578907, 3791100168382935654, 2770336965985421795, 2542786769737627430, 2820217289920257590, 2752997558474007410, 3618302472877630309, 1901444604314895927, 2552607344913430107, 3577604801590221923, 3948229371195778482, 3970595190071641542, 3219751699576412962, 3655634761450876041, 787480990521340455, 3636404237867096133, 3376323811486671474, 3587640924075142241, 3947167087487130801, 1953610294666359494, 3202755160238050075, 3587648604097424493, 1759907410264410571, 3898741366386643570, 3636895759293160291, 1396592840006012199, 3807912723822043977, 2177027673392863459, 4096424675144065932, 3230032773978548621, 1960429698101484131, 3916762177286497049, 1851909113041613222, 2768820287474097257, 1641734351256864359, 3631815781787672006, 3209319527972890226, 3973983376333982172, 993495844083495543, 2554216970234567837, 1791475747165488935, 3906633450611913161, 2067634058902840163, 3658850217183972749, 1790423404576081607, 3201371253814909147, 3582112978404860782, 3774970255668753947, 1973575433349117667, 3282615714969082765, 3907090823021555254, 3905856055609314614, 3282307023116022605, 3126419764992699603, 4091070713202357782, 2789474620677449421, 1850290159776209331, 3574108613017175451, 3574407648806554011, 2046523416808485478, 3970395368022662297, 3418683848170245577, 2057456429821440519, 3618139700858374173, 1782799192037930551, 3904464311830023565, 976639933566551907, 3906559734266207630, 2655080640237749814, 2553037508703279334, 2760015925380265059, 3955111991833366118, 3919495885308519238, 3329873629777815139, 4096122482256484750, 2549431873743775291, 3546132638660455267, 3897421832481301426, 2815706675281684150, 1040672795660240491, 2566011208128754074, 1851550521162123574, 3907370590480299801, 2129764152226921926, 3207082893691211147, 3604959537910068781, 4068502831002510071, 2339120385432445650, 542511803089368623, 2441470959986036107, 2129752078000108726, 3907322293573047000, 3280739715456538934, 2222658865278015891, 4150327174384244808, 2766250642254815522, 1841630532164486283, 3593547564579407065, 2051308395751698742, 2818670108151618637, 1065442354514922279, 3502806234260409969, 3624706430971595249, 795386141944699111, 3657611049306715705, 2067324266933525902, 2822674075947075427, 3903826499293660967, 3635181643567233142, 2509305749142532722, 2821272238088357767, 3255403838861420326, 3798243318590905499, 1357915219081458286, 2623108378554920327]

@pytest.fixture(scope='session')
def mat_result():
    return np.array([[6, 2, 4], [2, 2, 0], [4, 0, 4]])

def test_genome_name():
    assert genome_name('dir/test.fa') == 'test'

def test_break_seq(test_seq, upper, lower, break_seq_result):
    assert break_seq(test_seq, upper, lower) == break_seq_result

def test_score_byte_to_blist():
    assert score_byte_to_blist(b'\x05', 3) == [1, 0, 1]

def test_add_score_mat_np(mat_result):
    score_multi = np.array([1, 1, 0]) * 2
    mat = np.array([[4, 0, 4], [0, 0, 0], [4, 0, 4]])
    mat = add_score_mat_np(score_multi, mat)
    print(mat)
    for i, j in product(range(3), repeat=2):
        assert mat[i, j] == mat_result[i, j]


