import { IAspect, Stack } from 'aws-cdk-lib';
import { CfnTaskDefinition } from 'aws-cdk-lib/aws-ecs';
import { Policy } from 'aws-cdk-lib/aws-iam';
import { IConstruct } from 'constructs';
/**
 * Configuration properties for ECRRepositoryAspect.
 *
 * @stability stable
 */
export interface ECRRepositoryAspectProps {
    /**
     * Override the ECR repository account id of the Docker Image assets.
     *
     * @default - process.env.BSS_IMAGE_ASSET_ACCOUNT_ID
     * @stability stable
     */
    readonly imageAssetAccountId?: string;
}
/**
 * Abtract aspect for ECR repository.
 *
 * You must provide the account id in props or set BSS_IMAGE_ASSET_ACCOUNT_ID in env
 *
 * @stability stable
 */
export declare abstract class ECRRepositoryAspect implements IAspect {
    /**
     * @internal
     */
    static readonly _repoPolicies: Map<string, Policy>;
    /**
     * @stability stable
     */
    readonly account: string;
    /**
     * @stability stable
     */
    constructor(props?: ECRRepositoryAspectProps);
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    abstract visit(construct: IConstruct): void;
    /**
     * @stability stable
     */
    protected getRepoName(imageUri: string): string | undefined;
    /**
     * @stability stable
     */
    protected crossAccountECRPolicy(stack: Stack, repoName: string): Policy;
}
/**
 * Process the image assets in ECS task definition.
 *
 * @stability stable
 */
export declare class ECSTaskDefinition extends ECRRepositoryAspect {
    /**
     * @stability stable
     */
    constructor(props?: ECRRepositoryAspectProps);
    /**
     * @stability stable
     */
    protected hasBeReplaced(prop: CfnTaskDefinition.ContainerDefinitionProperty): string | undefined;
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(construct: IConstruct): void;
}
/**
 * Process the image assets in SageMaker training job in Step Functions.
 *
 * @stability stable
 */
export declare class StepFunctionsSageMakerTrainingJob extends ECRRepositoryAspect {
    /**
     * @stability stable
     */
    constructor(props?: ECRRepositoryAspectProps);
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(construct: IConstruct): void;
}
/**
 * Default ECR asset aspect, support using ECR assets in below services,.
 *
 * - ECS task definition
 * - SageMaker training job in Step Functions
 *
 * @stability stable
 */
export declare class CompositeECRRepositoryAspect extends ECRRepositoryAspect {
    /**
     * @internal
     */
    readonly _aspects: ECRRepositoryAspect[];
    /**
     * @stability stable
     */
    constructor(props?: ECRRepositoryAspectProps);
    /**
     * All aspects can visit an IConstruct.
     *
     * @stability stable
     */
    visit(construct: IConstruct): void;
}
