import Section from '../../components/section'

# Ton-year

This project implements two widely referenced ton-year accounting methods.

Ton-year accounting refers to a family of approaches that quantify the benefit of temporarily storing carbon dioxide that might otherwise enter the atmosphere and exacerbate climate change. We’ve noticed growing interest in using ton-year accounting to generate carbon offsets – an arrangement that uses temporary storage of CO<sub>2</sub> to justify the on-going carbon pollution.

We originally wrote this code as a way to improve our understanding of the climate science, math, and assumptions underlying ton-year accounting methods. By sharing our code, we hope to help facilitate deep thinking about how we value temporary carbon storage. We wrote a short [explainer](https://carbonplan.org/research/ton-year-explainer) documenting what we’ve learned so far.

Beyond that, here are some additional resources to help you get started:

1. [Conceptual overview](./ton-year/overview)
1. [Quick start](./ton-year/quick-start)
1. [How-to-guide](./ton-year/how-to-guide)
1. [API Reference](./ton-year/api)

export default ({ children }) => <Section name='intro'>{children}</Section>
