# Generated by Django 4.1 on 2022-08-16 18:04

from django.conf import settings
from django.db import migrations, models
import django.utils.timezone
import uuid
import swapper


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ("contenttypes", "0002_remove_content_type_name"),
    ]

    operations = [
        migrations.CreateModel(
            name="Category",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", models.TextField(blank=True, null=True)),
                ("slug", models.SlugField(unique=True)),
                ("is_active", models.BooleanField(default=True)),
                (
                    "created_timestamp",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("updated_timestamp", models.DateTimeField(auto_now=True)),
            ],
            options={
                "verbose_name": "Category",
                "verbose_name_plural": "Categories",
                "abstract": False,
                "swappable": swapper.swappable_setting(
                    "txn_notifications", "Category"
                ),
            },
        ),
        migrations.CreateModel(
            name="Template",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("name", models.CharField(max_length=100)),
                ("description", models.TextField(blank=True, null=True)),
                ("slug", models.SlugField(unique=True)),
                (
                    "title",
                    models.CharField(
                        blank=True,
                        help_text="Markdown and django template language enabled. You can use {{ <data> }}, for example: {{ recipient }}, {{ sender }}, {{ target }}.",
                        max_length=500,
                        null=True,
                        verbose_name="Notification title",
                    ),
                ),
                (
                    "body",
                    models.TextField(
                        blank=True,
                        help_text="Markdown and django template language enabled. You can use {{ <data> }}, for example: {{ recipient }}, {{ sender }}, {{ target }}.",
                        null=True,
                        verbose_name="Notification body",
                    ),
                ),
                (
                    "url",
                    models.TextField(
                        blank=True,
                        help_text="Markdown and django template language enabled. You can use {{ <data> }}, for example: {{ recipient }}, {{ sender }}, {{ target }}.",
                        max_length=500,
                        null=True,
                        verbose_name="Notification url",
                    ),
                ),
                (
                    "url_msg",
                    models.TextField(
                        blank=True,
                        help_text="Markdown and django template language enabled. You can use {{ <data> }}, for example: {{ recipient }}, {{ sender }}, {{ target }}.",
                        max_length=500,
                        null=True,
                        verbose_name="Notification url message",
                    ),
                ),
                (
                    "handler",
                    models.CharField(help_text="handler slug", max_length=50),
                ),
                (
                    "record",
                    models.BooleanField(
                        default=True,
                        help_text="record the notification in the database using `Notification` model.",
                    ),
                ),
                (
                    "check_status",
                    models.BooleanField(
                        default=True,
                        help_text="check that the notification must update sent status, usually using callbacks or webhooks.",
                    ),
                ),
                (
                    "is_active",
                    models.BooleanField(
                        default=True,
                        help_text="if `False`, avoid sending any notification using this template.",
                    ),
                ),
                (
                    "created_timestamp",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                ("updated_timestamp", models.DateTimeField(auto_now=True)),
                (
                    "category",
                    models.ForeignKey(
                        null=True,
                        on_delete=django.db.models.deletion.SET_NULL,
                        related_name="templates",
                        to=settings.TXN_NOTIFICATIONS_CATEGORY_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Template",
                "verbose_name_plural": "Templates",
                "abstract": False,
                "swappable": swapper.swappable_setting(
                    "txn_notifications", "Template"
                ),
            },
        ),
        migrations.CreateModel(
            name="Notification",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("title", models.CharField(max_length=200)),
                ("body", models.TextField(blank=True, null=True)),
                (
                    "url",
                    models.CharField(blank=True, max_length=500, null=True),
                ),
                (
                    "url_msg",
                    models.CharField(blank=True, max_length=100, null=True),
                ),
                ("data", models.JSONField(null=True)),
                (
                    "read",
                    models.BooleanField(
                        default=False,
                        help_text="Notification has been read for the user?",
                    ),
                ),
                (
                    "read_timestamp",
                    models.DateTimeField(blank=True, null=True),
                ),
                (
                    "sent",
                    models.BooleanField(
                        default=False,
                        help_text="Notification has been confirmed sent to the user?",
                    ),
                ),
                (
                    "sent_timestamp",
                    models.DateTimeField(blank=True, null=True),
                ),
                (
                    "prov_id",
                    models.CharField(
                        blank=True,
                        help_text="Provider's notification id",
                        max_length=255,
                        null=True,
                    ),
                ),
                (
                    "prov_status",
                    models.CharField(
                        blank=True,
                        help_text="Provider's internal status",
                        max_length=100,
                        null=True,
                    ),
                ),
                (
                    "target_object_id",
                    models.CharField(blank=True, max_length=255, null=True),
                ),
                (
                    "created_timestamp",
                    models.DateTimeField(default=django.utils.timezone.now),
                ),
                (
                    "callback_id",
                    models.UUIDField(default=uuid.uuid4, editable=False),
                ),
                (
                    "recipient",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "sender",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="sent_notifications",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
                (
                    "target_content_type",
                    models.ForeignKey(
                        blank=True,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        to="contenttypes.contenttype",
                    ),
                ),
                (
                    "template",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notifications",
                        to=settings.TXN_NOTIFICATIONS_TEMPLATE_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "Notification",
                "verbose_name_plural": "Notifications",
                "ordering": ("-created_timestamp",),
                "abstract": False,
                "swappable": swapper.swappable_setting(
                    "txn_notifications", "Notification"
                ),
            },
        ),
        migrations.CreateModel(
            name="UserHandlerSettings",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("handler", models.CharField(max_length=50)),
                ("allow", models.BooleanField(default=True)),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notify_handler_settings",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User handler settings",
                "verbose_name_plural": "User handler settings",
                "abstract": False,
                "swappable": swapper.swappable_setting(
                    "txn_notifications", "UserHandlerSettings"
                ),
                "unique_together": {("user", "handler")},
            },
        ),
        migrations.CreateModel(
            name="UserCategorySettings",
            fields=[
                (
                    "id",
                    models.BigAutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                ("allow", models.BooleanField(default=True)),
                (
                    "category",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to=settings.TXN_NOTIFICATIONS_CATEGORY_MODEL,
                    ),
                ),
                (
                    "user",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="notify_category_settings",
                        to=settings.AUTH_USER_MODEL,
                    ),
                ),
            ],
            options={
                "verbose_name": "User category settings",
                "verbose_name_plural": "User category settings",
                "abstract": False,
                "swappable": swapper.swappable_setting(
                    "txn_notifications", "UserCategorySettings"
                ),
                "unique_together": {("user", "category")},
            },
        ),
    ]
