# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['PriceIndices']

package_data = \
{'': ['*']}

install_requires = \
['matplotlib>=3.6.3,<4.0.0',
 'numpy>=1.24.1,<2.0.0',
 'pandas>=1.4.0,<2.0.0',
 'requests>=2.25.1,<3.0.0']

setup_kwargs = {
    'name': 'priceindices',
    'version': '1.4.0',
    'description': 'A python package to get historical market data of cryptocurrencies, and calculate & plot different price technical indicators.',
    'long_description': '\n\n[![](https://img.shields.io/badge/PriceIndices-1.4.0-blue)](https://github.com/dc-aichara/PriceIndices)\n\n\n## Development Environment\n\n### Poetry\n * Install Poetry\n    ```shell\n    curl -sSL https://install.python-poetry.org | python3 -\n\n    ```\n * Install dependencies\n    ```shell\n    poetry install\n    ```\n * To add new dependencies use `poetry add` \n    ```shell\n    poetry add dependency_name\n    ```\n * Read `Poetry` [documentation](https://python-poetry.org/docs/) for more.\n\n## Installation \n\n### pip \n\n```\npip install PriceIndics\n```\n\n### Poetry\n\n```\npoetry add PriceIndices\n\n```\n\n### From Source (Github)\n \n git clone https://github.com/dc-aichara/Price-Indices.git\n \n cd Price-Indices \n \n python3 setup.py install\n \n## Usages \n \n```python\nfrom PriceIndices import MarketHistory, Indices\n\n```\n## Examples \n\n- #### Get market history and closing price\n\n```python\n>>> history = MarketHistory()\n\n# Get Market History \n\n>>> df_history = history.get_history("bitcoin", "2020-03-16", "2021-03-15")  \n>>> df_history.head()\n         open          high           low         close        volume    market_cap        date\n0  59267.429049  60540.992712  55393.165363  55907.200226  6.641937e+10  1.042946e+12  2021-03-15\n1  61221.134297  61597.918396  59302.316977  59302.316977  4.390123e+10  1.106226e+12  2021-03-14\n2  57343.370247  61683.864014  56217.972382  61243.084766  6.066983e+10  1.142369e+12  2021-03-13\n3  57821.218747  57996.619490  55376.650088  57332.088964  5.568994e+10  1.069366e+12  2021-03-12\n4  55963.180089  58091.062703  54484.593089  57805.123019  5.677234e+10  1.078136e+12  2021-03-11\n\n# Get closing price\n\n>>> price_data  =  history.get_price("bitcoin", "2020-03-16", "2021-03-15") \n\n>>> price_data.head()\n         date         price\n0  2021-03-15  55907.200226\n1  2021-03-14  59302.316977\n2  2021-03-13  61243.084766\n3  2021-03-12  57332.088964\n4  2021-03-11  57805.123019\n\n```\n\n- #### Calculate Volatility Index\n\n```python\nindices = Indices(df=price_data, plot_dir="plots")\n>>> df_bvol = indices.get_vola_index(\n        plot=True,\n        plot_name="vola_index.png",\n        show_plot=False  \n)  \n>>> df_bvol.head()\n        date    price  BVOL_Index\n0 2019-10-29  9427.69    0.711107\n1 2019-10-28  9256.15    0.707269\n2 2019-10-27  9551.71    0.709765\n3 2019-10-26  9244.97    0.698544\n4 2019-10-25  8660.70    0.692656\n\n```\n\n- #### Plot Volatility Index\n Plot will be saved in plots directory as `vola_index.png`.\n\n\n<img src= \'plots/bvol_index.png\' >\n\n- #### Calculate Relative Strength Index (RSI)\n\n```python\n\n>>> df_rsi = indices.get_rsi(\n        plot=True,\n        plot_name="rsi.png",\n        show_plot=False,\n)   \n\n>>> print(df_rsi.head())\n        date    price       RSI_1  RS_Smooth      RSI_2\n0 2019-10-30  9205.73      64.641855   1.624958  61.904151\n1 2019-10-29  9427.69      65.707097   1.709072  63.086984\n2 2019-10-28  9256.15      61.333433   1.597755  61.505224\n3 2019-10-27  9551.71      66.873327   2.012345  66.803267\n4 2019-10-26  9244.97      63.535368   1.791208  64.173219\n\n\n```\n\n- #### Plot RSI\nPlot will be saved in plots directory as `rsi.png`.\n\n\n<img src=\'plots/rsi.png\' >\n\n- #### Get Bollinger Bands and its plot\n\n```python\n>>> df_bb = indices.get_bollinger_bands(\n        days=20, \n        plot=True,\n        plot_name="bollinger_bands.png",\n        show_plot=False,\n        ) \n>>> df_bb.head()\n        date    price     BB_upper   BB_lower\n0 2019-10-30  9205.73  9635.043581 -8428.5855\n1 2019-10-29  9427.69  9550.707153 -8397.6225\n2 2019-10-28  9256.15  9408.263164 -8356.0250\n3 2019-10-27  9551.71  9268.466516 -8304.6565\n4 2019-10-26  9244.97  9003.752779 -8239.3520\n\n\n"""\nThis will also save Bollingers bands plot in your working directory as \'bollinger_bands.png\' in plots folder.\n"""\n\n```\n\n<img src=\'plots/bollinger_bands.png\'>\n\n\n- #### Get Moving Average Convergence Divergence (MACD) and its plot\n\n```python\n\n>>> df_macd = indices.get_moving_average_convergence_divergence(\n        plot=True,\n        plot_name="macd.png",\n        show_plot=False,\n)\n"""\nThis will return a pandas DataFrame and save EMA plot as \'macd.png\' in in plots folder. \n""""\n>>> df_macd.head()\n        date    price       MACD\n0 2019-10-30  9205.73   0.000000\n1 2019-10-29  9427.69  17.706211\n2 2019-10-28  9256.15  17.692715\n3 2019-10-27  9551.71  41.057952\n4 2019-10-26  9244.97  34.426864\n\n\n```\n\n<img src=\'plots/macd.png\'>\n\n- #### Get Simple Moving Average (SMA) and its plot\n\n```python\n>>> df_sma = indices.get_simple_moving_average(\n        days=20,\n        plot=True,\n        plot_name="sma.png",\n        show_plot=False,\n) \n"""This will return a pandas DataFrame and save EMA plot as \'sma.png\' in plots folder.\n""""\n>>> df_sma.head()\n        date    price          SMA\n0 2019-10-30  9205.73  8467.488000\n1 2019-10-29  9427.69  8400.797333\n2 2019-10-28  9256.15  8330.597333\n3 2019-10-27  9551.71  8268.254667\n4 2019-10-26  9244.97  8187.244667\n\n\n```\n\n<img src=\'plots/sma.png\'>\n\n- ### Get Exponential Moving Average (EMA) and its plot\n\n```python\n>>> df_ema = indices.get_exponential_moving_average(\n        periods=(20,70),\n        plot=True,\n        plot_name="ema.png",\n        show_plot=False,\n)\n"""This will return a pandas DataFrame and save EMA plot as \'ema.png\' in plots folder.\n""""\n\n>>> df_ema.head()\n        date    price       EMA_20       EMA_70\n0 2019-10-30  9205.73  9205.730000  9205.730000\n1 2019-10-29  9427.69  9226.869048  9211.982394\n2 2019-10-28  9256.15  9229.657710  9213.226552\n3 2019-10-27  9551.71  9260.329356  9222.761297\n4 2019-10-26  9244.97  9258.866561  9223.386895\n>>> \n\n\n```\n\n<img src=\'plots/ema.png\' >\n\n### License\n \n[MIT](https://choosealicense.com/licenses/mit/) © [Dayal Chand Aichara](https://github.com/dc-aichara)\n\n\n### Check out [webpage](https://dc-aichara.github.io/PriceIndices/) of PriceIndices package. \n\n### I have created a [cryptocurrency technical indicators dashboard](https://crypto-indicators-dashboard.herokuapp.com/) which uses this library. \n### Disclaimer: \n\n```\nAll content provided here, is for educational purpose and your general information only, procured  from third party sources.\nI make no warranties of any kind in relation to this content, including but  not limited to accuracy\nand updatedness. No part of the content that I provide  constitutes  financial  advice, legal advice \nor any other form of advice meant for your specific reliance for any purpose. Any use or reliance on\nmy content is solely at your own risk  and  discretion. You should conduct your own research, review, \nanalyse and  verify my content  before relying  on them. Trading is a highly risky activity that can \nlead to  major  losses, please  therefore  consult your financial advisor before making any decision.\nNo content on this Site is meant to be a solicitation or offer.\n```\n',
    'author': 'Dayal Chand Aichara',
    'author_email': 'dcaichara@gmail.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.8,<4.0',
}


setup(**setup_kwargs)
