# coding: utf-8

# flake8: noqa

"""
    symbl.ai APIs

    <h1>Symbl's APIs for external consumers.</h1> <h2>Language Insights API</h2> Symbl's Language Insights API provides an interface for applications to perform the analysis on the raw text and get insights from it. The API automatically detects sentence boundaries and punctuates the sentences, and also returns the updated messages in the response. Conversations are the most unstructured piece of information that we represent information in, and which most of the leads to lot of loss of information by not being able to capture them correctly.<br/> Language Insights API focuses on understanding such texts and generate the useful and important information from them. <br/> Currently the API supports detection of the Action Items in any type of unstructured text. In future the same API will also have support to detect \"Information\" and \"Event\", where Information is any informational piece and Event is a reference to something that has happened in the past.<br/> <h2>Telephony Integration</h2> Symbl can currently integrate with two types of telephony endpoints: 1. SIP trunks<br/> 2. PSTN endpoints<br/> Results are sent via HTTP WebHooks as and when they are available.<br/> <h2>Flow</h2> 1. External Application invokes REST API to join a meeting/session, with the mode (SIP/PSTN) and joining details<br/> 2. Symbl joins the meeting via SIP or PSTN integration<br/> 3. Symbl continuously processes the audio stream received<br/> 4. Symbl calls WebHook whenever transcription results are available<br/>  # noqa: E501

    OpenAPI spec version: 0.0.1
    Contact: info@symbl.ai
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

# import apis into sdk package
from symbl_rest.api.action_items_api import ActionItemsApi
from symbl_rest.api.analytics_api import AnalyticsApi
from symbl_rest.api.async_api import AsyncApi
from symbl_rest.api.authentication_api import AuthenticationApi
from symbl_rest.api.connection_to_endpoint_api import ConnectionToEndpointApi
from symbl_rest.api.conversation_data_api import ConversationDataApi
from symbl_rest.api.conversations_api import ConversationsApi
from symbl_rest.api.entities_api import EntitiesApi
from symbl_rest.api.external_event_web_hook_api import ExternalEventWebHookApi
from symbl_rest.api.follow_ups_api import FollowUpsApi
from symbl_rest.api.insights_api import InsightsApi
from symbl_rest.api.intents_api import IntentsApi
from symbl_rest.api.jobs_api import JobsApi
from symbl_rest.api.members_api import MembersApi
from symbl_rest.api.messages_api import MessagesApi
from symbl_rest.api.metric_api import MetricApi
from symbl_rest.api.metric_entry_api import MetricEntryApi
from symbl_rest.api.questions_api import QuestionsApi
from symbl_rest.api.topics_api import TopicsApi
from symbl_rest.api.trackers_api import TrackersApi
# import ApiClient
from symbl_rest.api_client import ApiClient
from symbl_rest.configuration import Configuration
# import models into sdk package
from symbl_rest.models.action import Action
from symbl_rest.models.action_item_list_response import ActionItemListResponse
from symbl_rest.models.analytics_list_response import AnalyticsListResponse
from symbl_rest.models.analytics_members_info import AnalyticsMembersInfo
from symbl_rest.models.analytics_members_info_overlap import AnalyticsMembersInfoOverlap
from symbl_rest.models.analytics_members_info_overlap_overlapping_members import AnalyticsMembersInfoOverlapOverlappingMembers
from symbl_rest.models.analytics_members_info_pace import AnalyticsMembersInfoPace
from symbl_rest.models.analytics_members_info_talk_time import AnalyticsMembersInfoTalkTime
from symbl_rest.models.analytics_metrics_info import AnalyticsMetricsInfo
from symbl_rest.models.async_audio_url_parameters import AsyncAudioUrlParameters
from symbl_rest.models.async_confidence_threshold import AsyncConfidenceThreshold
from symbl_rest.models.async_detect_phrases import AsyncDetectPhrases
from symbl_rest.models.async_enable_all_trackers import AsyncEnableAllTrackers
from symbl_rest.models.async_entities_payload import AsyncEntitiesPayload
from symbl_rest.models.async_meeting_name import AsyncMeetingName
from symbl_rest.models.async_messages_field import AsyncMessagesField
from symbl_rest.models.async_messages_field_inner import AsyncMessagesFieldInner
from symbl_rest.models.async_response import AsyncResponse
from symbl_rest.models.async_text_parameters import AsyncTextParameters
from symbl_rest.models.async_trackers import AsyncTrackers
from symbl_rest.models.async_trackers_inner import AsyncTrackersInner
from symbl_rest.models.async_video_url_parameters import AsyncVideoUrlParameters
from symbl_rest.models.audio_config import AudioConfig
from symbl_rest.models.avatar import Avatar
from symbl_rest.models.conversation_action_item import ConversationActionItem
from symbl_rest.models.conversation_data_list_response import ConversationDataListResponse
from symbl_rest.models.conversation_follow_up import ConversationFollowUp
from symbl_rest.models.conversation_insight_item import ConversationInsightItem
from symbl_rest.models.conversation_intent import ConversationIntent
from symbl_rest.models.conversation_message import ConversationMessage
from symbl_rest.models.conversation_question import ConversationQuestion
from symbl_rest.models.conversation_topic import ConversationTopic
from symbl_rest.models.custom_entities import CustomEntities
from symbl_rest.models.duration_payload import DurationPayload
from symbl_rest.models.endpoint import Endpoint
from symbl_rest.models.endpoint_connect_request import EndpointConnectRequest
from symbl_rest.models.endpoint_connect_response import EndpointConnectResponse
from symbl_rest.models.endpoint_request_data import EndpointRequestData
from symbl_rest.models.entities_list_response import EntitiesListResponse
from symbl_rest.models.entities_tag import EntitiesTag
from symbl_rest.models.error import Error
from symbl_rest.models.external_event import ExternalEvent
from symbl_rest.models.follow_up_list_response import FollowUpListResponse
from symbl_rest.models.from_payload import FromPayload
from symbl_rest.models.generic_error import GenericError
from symbl_rest.models.grant import Grant
from symbl_rest.models.insights_list_response import InsightsListResponse
from symbl_rest.models.intent import Intent
from symbl_rest.models.intent_list_response import IntentListResponse
from symbl_rest.models.job_response import JobResponse
from symbl_rest.models.language import Language
from symbl_rest.models.location_trunc import LocationTrunc
from symbl_rest.models.matches_items import MatchesItems
from symbl_rest.models.matches_items_insight_refs import MatchesItemsInsightRefs
from symbl_rest.models.matches_items_message_refs import MatchesItemsMessageRefs
from symbl_rest.models.member_list_response import MemberListResponse
from symbl_rest.models.members_info import MembersInfo
from symbl_rest.models.message_list_response import MessageListResponse
from symbl_rest.models.metric import Metric
from symbl_rest.models.metric_entry import MetricEntry
from symbl_rest.models.metric_entry_create import MetricEntryCreate
from symbl_rest.models.metric_entry_response import MetricEntryResponse
from symbl_rest.models.metric_label import MetricLabel
from symbl_rest.models.metric_response import MetricResponse
from symbl_rest.models.model_from import ModelFrom
from symbl_rest.models.parent_ref import ParentRef
from symbl_rest.models.phrase import Phrase
from symbl_rest.models.question_list_response import QuestionListResponse
from symbl_rest.models.refresh_token_request import RefreshTokenRequest
from symbl_rest.models.revoke_token_request import RevokeTokenRequest
from symbl_rest.models.sentiment import Sentiment
from symbl_rest.models.sentiment_polarity import SentimentPolarity
from symbl_rest.models.session_trunc import SessionTrunc
from symbl_rest.models.session_user import SessionUser
from symbl_rest.models.summary_info import SummaryInfo
from symbl_rest.models.tag import Tag
from symbl_rest.models.text_payload import TextPayload
from symbl_rest.models.time_zone import TimeZone
from symbl_rest.models.token import Token
from symbl_rest.models.topic_list_response import TopicListResponse
from symbl_rest.models.trackers_list_response import TrackersListResponse
from symbl_rest.models.unauthorized_error import UnauthorizedError
from symbl_rest.models.user_trunc import UserTrunc
from symbl_rest.models.word import Word
