"""
Constants of Blob-Creator

Author: Michael Kohlegger
Date: 2021-09
"""


COLORS = [
    ("white", "#97E0F2"),
    ("very light blue", "#0EB3DF"),
    ("light blue", "#0C9DC3"),
    ("green", "#0CC397"),
    ("dark blue", "#09708B"),
    ("very dark blue", "#07596F"),
    ("black", "#02161C")
]

REPLACE_STRING = "#??????"

ALIEN = '''<?xml version="1.0" standalone="yes"?>
<svg
    xmlns="http://www.w3.org/2000/svg"
    xmlns:xlink="http://www.w3.org/1999/xlink"
    xmlns:svg="http://www.w3.org/2000/svg"
    xmlns:inkscape="http://www.inkscape.org/namespaces/inkscape"
    xmlns:sodipodi="http://sodipodi.sourceforge.net/DTD/sodipodi-0.dtd"
    xmlns:ns1="http://sozi.baierouge.fr"
    xmlns:dc="http://purl.org/dc/elements/1.1/"
    xmlns:cc="http://web.resource.org/cc/"
    xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#"
    version="1.1"
    viewBox="0.0 0.0 417.0 476.0"
    fill="none"
    stroke="none"
    stroke-linecap="square"
    stroke-miterlimit="10"
  >
  <clipPath
      id="p.0"
    >
    <path
        d="m0 0l417.0 0l0 476.0l-417.0 0l0 -476.0z"
        clip-rule="nonzero"
    />
  </clipPath
  >
  <g
      clip-path="url(#p.0)"
    >
    <path
        fill="#000000"
        fill-opacity="0.0"
        d="m0 0l417.7244 0l0 476.4252l-417.7244 0z"
        fill-rule="nonzero"
    />
    <path
        fill="#??????"
        d="m198.12862 46.84953c32.014862 -5.320118 70.74803 -6.9386177 100.74803 8.327972c30.0 15.26659 62.685028 51.81322 79.25195 83.271576c16.566925 31.458374 23.059937 69.39389 20.149628 105.47861c-2.9103394 36.0847 -14.3280945 84.890976 -37.611572 111.02968c-23.283447 26.138702 -64.477234 36.31839 -102.08923 45.80249c-37.611984 9.4841 -88.4335 20.586273 -123.58267 11.102173c-35.14917 -9.484131 -67.611115 -38.62976 -87.31233 -68.006805c-19.701225 -29.377045 -30.223536 -77.25949 -30.895014 -108.25551c-0.6714783 -30.996002 11.866142 -52.97026 26.86614 -77.720505c15.0 -24.750244 37.388016 -52.27603 63.133858 -70.78098c25.74585 -18.504944 59.32634 -34.928577 91.34122 -40.2487z"
        fill-rule="nonzero"
    />
    <path
        fill="#ffffff"
        d="m157.82939 183.74278l0 0c0 -36.355118 30.37413 -65.826775 67.84253 -65.826775l0 0c17.99295 0 35.248947 6.9353027 47.97191 19.28022c12.722931 12.34491 19.870605 29.088211 19.870605 46.546555l0 0c0 36.355118 -30.374146 65.82678 -67.842514 65.82678l0 0c-37.4684 0 -67.84253 -29.471664 -67.84253 -65.82678z"
        fill-rule="nonzero"
    />
    <path
        fill="#000000"
        d="m184.6483 183.74278l0 0c0 -23.656921 18.366898 -42.83464 41.02362 -42.83464l0 0c10.880142 0 21.314651 4.512924 29.008087 12.545975c7.693405 8.033051 12.015549 18.928207 12.015549 30.288666l0 0c0 23.656921 -18.366913 42.834656 -41.023636 42.834656l0 0c-22.656723 0 -41.02362 -19.177734 -41.02362 -42.834656z"
        fill-rule="nonzero"
    />
    <path
        fill="#ffffff"
        d="m224.99475 168.96588l0 0c0 -6.679596 5.711014 -12.094498 12.755905 -12.094498l0 0c3.383072 0 6.627594 1.2742462 9.019791 3.5424042c2.3921967 2.268158 3.7361145 5.3444366 3.7361145 8.5520935l0 0c0 6.679596 -5.711014 12.094482 -12.755905 12.094482l0 0c-7.0448914 0 -12.755905 -5.4148865 -12.755905 -12.094482z"
        fill-rule="nonzero"
    />
    <path
        fill="#ffffff"
        d="m247.0222 304.4522c-0.24983215 2.3218384 1.6131592 10.98584 -1.4989929 13.931c-3.112152 2.9451904 -12.907486 4.4993896 -17.17395 3.7400818c-4.266464 -0.75927734 -6.849762 -5.615448 -8.42485 -8.295868c-1.5750885 -2.68042 -0.8547058 -6.488861 -1.02565 -7.786621"
        fill-rule="nonzero"
    />
    <path
        fill="#ffffff"
        d="m276.02222 301.4522c-0.24984741 2.3218384 1.6131592 10.98584 -1.4990234 13.931c-3.112152 2.9451904 -12.907471 4.4993896 -17.17392 3.7400818c-4.2664795 -0.75927734 -6.849777 -5.615448 -8.424866 -8.295868c-1.5750885 -2.68042 -0.8547058 -6.488861 -1.02565 -7.786621"
        fill-rule="nonzero"
    />
    <path
        fill="#ffffff"
        d="m192.23425 302.66754c-0.24983215 2.3218384 -3.8655853 10.61142 -1.4989929 13.931c2.3665924 3.31958 11.44252 6.1633606 15.698547 5.9864807c4.2560425 -0.1769104 7.7602386 -4.6170654 9.8376465 -7.047882c2.077423 -2.4308167 2.1890564 -6.2808533 2.6268616 -7.537018"
        fill-rule="nonzero"
    />
    <path
        fill="#000000"
        fill-opacity="0.0"
        d="m155.13911 280.45407c8.7314 4.253723 32.91075 22.164032 52.388443 25.522308c19.477692 3.3582764 48.582245 -2.9098816 64.47769 -5.372711c15.895447 -2.462799 22.83551 -4.702545 30.89502 -9.404205c8.059479 -4.70166 14.551605 -15.671478 17.461945 -18.805756"
        fill-rule="nonzero"
    />
    <path
        stroke="#000000"
        stroke-width="4.0"
        stroke-linejoin="round"
        stroke-linecap="butt"
        d="m155.13911 280.45407c8.7314 4.253723 32.91075 22.164032 52.388443 25.522308c19.477692 3.3582764 48.582245 -2.9098816 64.47769 -5.372711c15.895447 -2.462799 22.83551 -4.702545 30.89502 -9.404205c8.059479 -4.70166 14.551605 -15.671478 17.461945 -18.805756"
        fill-rule="nonzero"
    />
    <path
        fill="#??????"
        d="m58.77231 149.61713c9.5 -5.8333282 23.666672 -30.166664 44.0 -45.0c20.333336 -14.833336 49.33333 -36.333336 78.0 -44.0c28.666672 -7.666668 71.33333 -4.333332 94.0 -2.0c22.666656 2.333332 32.0 16.666664 42.0 16.0c10.0 -0.6666641 16.666656 -13.833332 18.0 -20.0c1.3333435 -6.166668 -4.0 -13.166668 -10.0 -17.0c-6.0 -3.833332 -17.833344 -9.166668 -26.0 -6.0c-8.1666565 3.166668 -20.166656 24.166668 -23.0 25.0c-2.8333435 0.83333206 6.1666565 -14.833332 6.0 -20.0c-0.1666565 -5.166668 -2.6666565 -7.5 -7.0 -11.0c-4.3333435 -3.5 -13.0 -10.166667 -19.0 -10.000001c-6.0 0.16666698 -12.833328 4.333333 -17.0 11.000001c-4.1666718 6.666668 -6.5 27.333332 -8.0 29.0c-1.5 1.6666679 2.8333282 -13.333332 -1.0 -19.0c-3.8333282 -5.666668 -15.0 -12.666668 -22.0 -15.0c-7.0 -2.333334 -15.0 -0.83333397 -20.0 1.0c-5.0 1.8333321 -7.3333282 4.166666 -10.0 10.0c-2.6666718 5.833332 -3.6666718 23.166668 -6.0 25.0c-2.3333282 1.8333321 -3.0 -10.833332 -8.0 -14.0c-5.0 -3.166668 -15.166672 -5.333332 -22.0 -5.0c-6.8333282 0.33333206 -15.666664 1.5 -19.0 7.0c-3.3333282 5.5 -2.6666641 19.833336 -1.0 26.0c1.6666718 6.166664 13.833328 11.333336 11.0 11.0c-2.8333282 -0.33333588 -21.0 -10.166664 -28.0 -13.0c-7.0 -2.8333359 -8.833328 -5.166664 -14.0 -4.0c-5.166664 1.1666641 -13.166664 5.5 -17.0 11.0c-3.8333282 5.5 -7.3333282 14.666664 -6.0 22.0c1.3333359 7.333336 14.5 20.666664 14.0 22.0c-0.5 1.3333359 -11.166664 -11.333336 -17.0 -14.0c-5.833332 -2.6666641 -13.5 -4.5 -18.0 -2.0c-4.5 2.5 -8.833332 11.166664 -9.0 17.0c-0.16666412 5.833336 4.5 13.333328 8.0 18.0c3.5 4.6666718 3.5 15.833328 13.0 10.0z"
        fill-rule="nonzero"
    />
    <path
        fill="#??????"
        d="m82.73034 373.77652c-4.1897507 15.770874 -11.774239 51.095795 -7.5401993 66.212494c4.2340317 15.116699 19.10881 22.798859 32.944397 24.487701c13.835579 1.6888428 42.528915 2.9427185 50.06909 -14.354584c7.5401917 -17.297333 4.8178406 -71.969574 -4.8279877 -89.42932c-9.6458435 -17.459717 -41.27279 -17.509705 -53.047005 -15.329102c-11.774216 2.1806335 -13.408554 12.641937 -17.598297 28.412811z"
        fill-rule="nonzero"
    />
    <path
        fill="#??????"
        d="m335.72153 350.07913c6.632263 14.444763 19.870209 47.194702 18.813812 62.852295c-1.0563965 15.657593 -13.026398 26.409088 -25.152191 31.093292c-12.125824 4.684204 -37.682068 12.207947 -47.6026 -2.9880981c-9.920563 -15.196045 -17.414154 -69.05914 -11.920624 -88.18811c5.4935303 -19.128967 33.904877 -26.124115 44.881805 -26.585693c10.976929 -0.46154785 14.347534 9.3715515 20.979797 23.816315z"
        fill-rule="nonzero"
    />
  </g>
</svg
>
'''
WIDTH_ALIEN = 417
HEIGHT_ALIEN = 476

MONSTER = """<?xml version="1.0" encoding="iso-8859-1"?>
<!-- Generator: Adobe Illustrator 19.0.0, SVG Export Plug-In . SVG Version: 6.00 Build 0)  -->
<svg version="1.1" id="Layer_1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px"
	 viewBox="0 0 512 512" style="enable-background:new 0 0 512 512;" xml:space="preserve">
<path style="fill:#??????;" d="M356.512,267.136c-1.131,0-2.272-0.119-3.424-0.353c-9.032-1.88-14.826-10.723-12.946-19.75
	l21.087-101.305c1.88-9.038,10.706-14.788,19.75-12.946c9.032,1.88,14.826,10.723,12.946,19.75l-21.087,101.305
	C371.197,261.718,364.251,267.136,356.512,267.136z"/>
<path style="fill:#??????;" d="M389.881,166.957c-46.032,0-83.478-37.446-83.478-83.478S343.849,0,389.881,0
	s83.478,37.446,83.478,83.478S435.915,166.957,389.881,166.957z"/>
<path style="fill:#FFFFFF;" d="M389.881,133.565c-27.619,0-50.087-22.468-50.087-50.087s22.468-50.087,50.087-50.087
	s50.087,22.468,50.087,50.087S417.501,133.565,389.881,133.565z"/>
<path style="fill:#??????;" d="M156.121,267.136c-7.739,0-14.684-5.418-16.326-13.299l-21.077-101.305
	c-1.88-9.027,3.923-17.87,12.946-19.75c9.066-1.804,17.87,3.919,19.75,12.946l21.077,101.305c1.88,9.027-3.923,17.87-12.946,19.75
	C158.393,267.016,157.251,267.136,156.121,267.136z"/>
<circle style="fill:#5A6680;" cx="389.878" cy="83.478" r="16.696"/>
<g>
	<path style="fill:#??????;" d="M20.197,433.544c-1.783,0-3.554-0.125-5.337-0.381c-9.13-1.304-15.478-9.761-14.173-18.886
		c1.304-9.13,9.826-15.516,18.892-14.168c2.913,0.441,6.206-2.566,7.5-3.864c6.098-6.098,10.065-16.549,9.021-23.799
		c-2.239-15.657,3.282-31.87,14.782-43.364c10.761-10.778,25.228-15.789,39.522-13.723c9.13,1.304,15.478,9.761,14.173,18.886
		c-1.304,9.125-9.848,15.446-18.892,14.168c-5.305-0.756-9.283,2.353-11.196,4.277c-4.033,4.038-6.076,9.799-5.326,15.033
		c2.511,17.619-4.913,38.57-18.479,52.13C41.751,428.793,31.088,433.544,20.197,433.544z"/>
	<path style="fill:#??????;" d="M191.773,512c-5.077,0-10.088-2.304-13.37-6.674c-5.533-7.375-4.033-17.842,3.337-23.375
		c2.815-2.109,5.837-8.408,5.837-17.25c0-8.853-3.022-15.152-5.837-17.261c-12.011-9.011-19.184-24.929-19.184-42.565
		c0-17.652,7.174-33.565,19.184-42.576c7.402-5.533,17.848-4.044,23.381,3.337c5.533,7.375,4.033,17.837-3.337,23.369
		c-3.489,2.62-5.837,8.995-5.837,15.87c0,6.864,2.347,13.24,5.837,15.859c12.011,9.011,19.184,25.445,19.184,43.967
		c0,18.511-7.174,34.945-19.184,43.956C198.784,510.913,195.262,512,191.773,512z"/>
	<path style="fill:#??????;" d="M97.458,483.147c-7.445,0-14.228-5.016-16.163-12.56c-2.283-8.929,3.098-18.027,12.033-20.315
		c2.869-0.733,6.131-4.615,8.316-9.881c3.782-9.13,3.141-18.581,0.62-22.842c-8.097-13.668-8.957-31.423-2.304-47.489
		c6.152-14.864,17.706-25.44,31.696-29.027c8.934-2.283,18.021,3.103,20.315,12.033c2.283,8.929-3.098,18.027-12.033,20.315
		c-3.652,0.935-7.066,4.473-9.13,9.456c-2.532,6.12-2.456,13.229,0.196,17.695c8.326,14.071,8.913,34.734,1.489,52.641
		c-6.348,15.31-17.598,26.043-30.88,29.446C100.218,482.973,98.827,483.147,97.458,483.147z"/>
</g>
<g>
	<path style="fill:#??????;" d="M320.229,512c-3.489,0-7-1.087-10.011-3.342c-12.011-9.011-19.184-25.445-19.184-43.956
		c0-18.522,7.174-34.956,19.184-43.967c3.489-2.62,5.837-8.994,5.837-15.859c0-6.875-2.347-13.25-5.837-15.87
		c-7.369-5.533-8.87-15.994-3.337-23.369c5.543-7.381,16-8.87,23.381-3.337c12.011,9.011,19.184,24.924,19.184,42.576
		c0,17.636-7.174,33.554-19.184,42.565c-2.815,2.109-5.837,8.408-5.837,17.261c0,8.842,3.022,15.142,5.837,17.25
		c7.369,5.533,8.87,16,3.337,23.375C330.317,509.696,325.306,512,320.229,512z"/>
	<path style="fill:#??????;" d="M414.544,483.147c-1.369,0-2.76-0.174-4.152-0.528c-13.283-3.403-24.533-14.136-30.88-29.446
		c-7.424-17.908-6.837-38.57,1.489-52.636c2.652-4.473,2.728-11.587,0.185-17.712c-2.065-4.979-5.467-8.51-9.119-9.445
		c-8.934-2.288-14.315-11.385-12.033-20.315c2.294-8.929,11.359-14.315,20.315-12.033c13.979,3.582,25.532,14.158,31.685,29.01
		c6.663,16.066,5.805,33.826-2.294,47.506c-2.522,4.261-3.163,13.712,0.62,22.842c2.185,5.266,5.446,9.147,8.316,9.88
		c8.934,2.288,14.315,11.385,12.033,20.315C428.773,478.13,421.99,483.147,414.544,483.147z"/>
	<path style="fill:#??????;" d="M491.805,433.544c-10.891,0-21.554-4.745-30.49-13.69c-13.566-13.56-20.989-34.511-18.479-52.125
		c0.75-5.239-1.293-11-5.326-15.038c-1.913-1.924-5.891-5.038-11.196-4.277c-9.076,1.288-17.576-5.043-18.892-14.168
		c-1.305-9.125,5.043-17.582,14.173-18.886c14.283-2.049,28.761,2.951,39.522,13.723c11.5,11.494,17.022,27.707,14.782,43.37
		c-1.044,7.245,2.924,17.695,9.021,23.794c1.305,1.299,4.543,4.315,7.5,3.864c9.066-1.353,17.576,5.038,18.892,14.168
		c1.304,9.125-5.043,17.582-14.174,18.886C495.36,433.418,493.588,433.544,491.805,433.544z"/>
</g>
<path style="fill:#??????;" d="M256.316,400.696c-134.25,0-240.815-100.527-245.283-104.81c-3.293-3.147-5.152-7.505-5.152-12.06
	s1.859-8.913,5.152-12.06c4.468-4.283,111.033-104.81,245.283-104.81s240.815,100.527,245.282,104.81
	c3.294,3.147,5.152,7.505,5.152,12.06c0,4.555-1.859,8.913-5.152,12.06C497.132,300.169,390.566,400.696,256.316,400.696z"/>
<path style="fill:#??????;" d="M256.316,166.957c-0.228,0-0.445,0.03-0.673,0.03v233.678c0.228,0.001,0.445,0.03,0.673,0.03
	c134.25,0,240.815-100.527,245.282-104.81c3.294-3.147,5.152-7.505,5.152-12.06c0-4.555-1.859-8.913-5.152-12.06
	C497.132,267.483,390.566,166.957,256.316,166.957z"/>
<path style="fill:#??????;" d="M122.751,166.957c-46.032,0-83.478-37.446-83.478-83.478S76.719,0,122.751,0
	s83.478,37.446,83.478,83.478S168.784,166.957,122.751,166.957z"/>
<path style="fill:#FFFFFF;" d="M122.751,133.565c-27.619,0-50.087-22.468-50.087-50.087s22.468-50.087,50.087-50.087
	s50.087,22.468,50.087,50.087S150.371,133.565,122.751,133.565z"/>
<circle style="fill:#5A6680;" cx="122.748" cy="83.478" r="16.696"/>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
<g>
</g>
</svg>
"""

WIDTH_MONSTER = 512
HEIGHT_MONSTER = 512

BOY = '''<svg width="229" height="490" xmlns="http://www.w3.org/2000/svg">

 <g label="Capa 1" id="imagebot_4">
  <title label="Capa 1"/>
  <metadata label="Capa 1" id="imagebot_35"/>
  <metadata label="Capa 1" id="imagebot_34"/>
  <metadata label="Capa 1" id="imagebot_31"/>
  <polyline label="Capa 1" id="imagebot_30" points="727.054,1527.21 581.045,1503.28 576.258,1208.87" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(22.5 -18.75) matrix(0.312007 0 0 0.312007 -48.6768 5.62204)"/>
  <polyline label="Capa 1" id="imagebot_29" points="399.132,1204.08 384.77,1491.31 255.517,1534.39" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-15 -16.25) matrix(0.312007 0 0 0.312007 -48.6768 5.62204)"/>
  <polygon label="Capa 1" id="imagebot_28" points="329.717,932.407 300.994,1241.18 478.119,1243.57 506.842,1174.16 533.173,1235.2 740.218,1201.69 689.953,946.769 646.868,891.717" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="#000000" clip-rule="evenodd" fill-rule="evenodd" transform="translate(2.5 -46.25) matrix(0.401209 0 0 0.401209 -100.557 -69.264)"/>
  <path label="Capa 1" id="imagebot_27" d="M306.978,593.714C299.30419,599.77751 305.17772,596.36693 296.2068,599.69835L174.1338,677.49035L305.7808,801.95635L317.7495,841.45055" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(0 -11.25) matrix(0.312007 0 0 0.312007 -48.6768 5.62204)"/>
  <polyline label="Capa 1" id="imagebot_26" points="704.315,824.696 873.063,702.623 747.399,608.075" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(0 -12.5) matrix(0.312007 0 0 0.312007 -46.1768 5.62204)"/>
  <path label="Capa 1" id="imagebot_25" d="M416.455,921.28C437.9159,1020.0727 404.216,1075.244 315.355,1086.794" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <path label="Capa 1" id="imagebot_24" d="M610.217,896.42C606.02841,1029.871 637.3942,1087.345 704.3145,1068.842" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <polygon label="Capa 1" id="imagebot_23" points="273.467,951.556 735.431,908.471 644.475,682.277 747.399,697.835 774.925,542.252 536.763,487.199 450.594,476.428 273.467,556.614 306.978,681.081 376.392,669.112" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="#??????" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-5 -3.75) matrix(0.413957 0 0 0.413957 -97.9638 -56.232)"/>
  <ellipse label="Capa 1" id="imagebot_22" transform="translate(0 -1.25) matrix(0.311106 -0.0236988 0.0236988 0.311106 208.229 89.9558)" rx="40.0924" ry="26.9273" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="#ffd4aa" clip-rule="evenodd" fill-rule="evenodd" cx="0" cy="0"/>
  <ellipse label="Capa 1" id="imagebot_21" transform="translate(2.5 0) matrix(0.306506 -0.0583332 0.0583332 0.306506 30.8591 91.9114)" rx="42.4864" ry="27.5255" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="#ffd4aa" clip-rule="evenodd" fill-rule="evenodd" cx="0" cy="0"/>
  <path transform="translate(0 -3.75) matrix(0.312007 0 0 0.312007 -50.2393 5.62204)" label="Capa 1" id="imagebot_19" d="M 348.96772124557987 401.04014443981436 C 436.1296288635155 520.8876590375726 649.3659544275499 490.2768194919714 713.1800090424977 442.54633081456063 C 795.6061060966201 380.89582599290856 808.3253928552979 284.94030315355724 759.873807614978 199.73784994487377 C 721.8697558399185 132.90866318230871 652.3066966688339 85.32045170337503 565.8349331702632 76.25927558342154 C 469.20782033736896 66.13323136371423 387.69451691247673 109.27287442298764 340.6676110904236 185.21100984442205 C 294.1091535946177 260.39362819850146 303.35673798801776 338.3232975925254 348.96806805167006 401.0397109322017 L 348.96772124557987 401.04014443981436 z" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="#ffd4aa" clip-rule="evenodd" fill-rule="evenodd"/>
  <polyline label="Capa 1" id="imagebot_18" points="795.271,846.238 715.086,836.664 759.367,895.307" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(2.5 -15) matrix(0.312007 0 0 0.312007 -48.6768 5.62204)"/>
  <path label="Capa 1" id="imagebot_17" d="M257.909,874.961C259.81219,871.32764 260.37534,869.75918 262.6958,866.58381L305.7804,801.95581M305.7804,801.95581L232.7763,853.41871L233.97272,851.02474" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-5 -13.75) matrix(0.312007 0 0 0.312007 -48.6768 5.62204)"/>
  <line label="Capa 1" id="imagebot_15" x1="394.344" y1="112.602" x2="373.998" y2="41.9911" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <path label="Capa 1" id="imagebot_14" d="M424.264,95.8469L427.85438,93.45293C427.85438,90.67109 427.55358,92.65796 431.44476,87.46971L424.26399,27.62961" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <line label="Capa 1" id="imagebot_13" x1="480.513" y1="85.0757" x2="479.317" y2="4.89084" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(0 -2.5) matrix(0.312007 0 0 0.312007 -48.6768 5.62204)"/>
  <line label="Capa 1" id="imagebot_12" x1="533.173" y1="65.9274" x2="534.369" y2="0.1029" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <line label="Capa 1" id="imagebot_11" x1="591.815" y1="69.5178" x2="600.193" y2="1.30045" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <line label="Capa 1" id="imagebot_10" x1="628.917" y1="79.0914" x2="652.852" y2="19.2524" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <line label="Capa 1" id="imagebot_9" x1="672.001" y1="99.4372" x2="685.165" y2="32.4164" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <path label="Capa 1" id="imagebot_8" d="M704.315,118.586C705.87781,113.89645 705.51142,115.68768 705.51142,111.40523L723.46332,61.13983" stroke="rgb(55, 52, 53)" stroke-width="11.3083" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <ellipse label="Capa 1" id="imagebot_7" cx="528.983" cy="202.96" rx="14.9597" ry="19.7477" stroke="rgb(55, 52, 53)" stroke-width="2.26166" fill="rgb(55, 52, 53)" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <ellipse label="Capa 1" id="imagebot_6" cx="591.815" cy="204.756" rx="14.9597" ry="19.7477" stroke="rgb(55, 52, 53)" stroke-width="2.26166" fill="rgb(55, 52, 53)" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
  <path label="Capa 1" id="imagebot_5" d="M388.36,244.25C421.499,435.001 726.282,441.384 735.431,274.1695" stroke="rgb(55, 52, 53)" stroke-width="16.9624" fill="none" clip-rule="evenodd" fill-rule="evenodd" transform="translate(-25.2393 -2.16896) matrix(0.312007 0 0 0.312007 -23.4375 7.791)"/>
 </g>
 <metadata id="imagebot_3">image/svg+xmlOpenclipart</metadata>
</svg>'''

WIDTH_BOY = 600
HEIGHT_BOY = 600

MARSIAN = '''<?xml version="1.0"?>
<svg xmlns:rdf="http://www.w3.org/1999/02/22-rdf-syntax-ns#" xmlns="http://www.w3.org/2000/svg" xmlns:cc="http://web.resource.org/cc/" xmlns:dc="http://purl.org/dc/elements/1.1/" xmlns:svg="http://www.w3.org/2000/svg" id="svg2" viewBox="0 0 291.39 369.59" version="1.0">
  <g id="layer1" fill-rule="evenodd" transform="translate(-16.598 -6.4449)">
    <path id="path17290" style="color:#000000" d="m2095.7 955.33a247.08 25.279 0 1 1 -494.2 0 247.08 25.279 0 1 1 494.2 0z" fill-opacity=".99569" transform="matrix(.55469 .0098483 -.0080660 .45431 -854.84 -87.918)" fill="#b3b3b3"/>
    <path id="path16238" d="m204.86 6.5019c19.01-1.3938 31.98 23.064 20.22 38.023-11.87 10.411-8.44 29.035-12.99 43.333-2.5 16.822-6.62 33.692-5.99 50.762 15.21 32.57 37.39 64.52 35.73 102.12-0.29 29.42-13.96 57.19-32.91 79.1-8.36 21.1 25.85 10.19 37.45 15.85 16.22 0.77 32.7 2.17 46.13 11.97 14.48 4.1 23.69 22.33 1.37 19.06-29.34-7.08-61.04-9.86-91.17-6.29-13.44-0.04-27.91 5.22-39.44-4.44-6.75-2.74-22.49 6.15-33.46 1.8-31.957-3.96-63.776-3.44-95.009 4.64-17.803 6.77-23.78-8.98-5.205-15.07 13.697-10.02 30.787-14.08 47.772-14.1 14.941-1.42 31.322-2.8 46.332-3.16-17.23-19.37-38.414-40.85-42.344-67.68 4.342-39.37 18.237-78.38 44.604-108.19 11.36-5.56 28.67-21.2 15.37-32.34-14.88-7.12-16.53-31.816-0.12-37.216 16.77-9.217 34.84 5.586 28.63 23.796-6.57 9.48-19.86 15.81-8.95 30.8 11.3 12.37 33.52-1.65 34.52-21.05 5.34-20.958 6.84-46.571 3.82-67.56-17.64-6.158-23.08-30.818-6.97-40.23 3.74-2.4381 8.15-3.8514 12.61-3.9281z" style="color:#000000" fill="#??????"/>
    <path id="path13301" d="m201.39 9.6924c-22.2-0.6467-27.27 33.739-6.53 39.972 5.85 8.384 1.93 24.311 3.03 35.268-1.5 18.818-2.42 40.478-16.25 54.808-18.63 8.63 12.81 2.9 13.88-6.98 7.19-10.97 5.04-24.83 8.41-37.727 3.52-14.55 3.24-29.831 1.31-44.474-14.97-5.086-22.48-30.247-4.62-39.123 4.26-1.337 4.31-1.8932 0.77-1.7436zm-53.46 74.459c-16.87-1.743-26.52 19.559-15.56 31.639 12.88 3.55 14.65 23.64 4.21 30.93-15.63 8.94-26.49 23.72-34.06 39.85-11.768 24.45-21.881 51.14-21.369 78.57 8.04 24.43 25.449 44.59 43.189 62.62 11.46 1.17-26.069 4.63-8.47 2.98 5.65-1.47 29.33-0.96 14.06-6.51-16.48-18.38-36.045-36.74-38.126-66.68-2.08-29.94 16.386-65.1 36.546-94.05 6.33-12.22 23.85-14.81 23.06-30.53 4.32-14.18-12.57-14.74-14.41-26.21-3.8-10.683 6.75-21.878 10.93-22.609zm-23.07 245.64c-41.02 3.05-77.104-1.7-106.27 26.04-2.466 7.37 3.891-1.33 7.387-3.04 3.429-1.69 24.707-12.55 36.679-14.51 11.943-1.95 66.514-6.53 62.204-8.49z" style="color:#000000" fill="#aaa"/>
    <path id="path13295" d="m202.73 133.55c-3.13 17.48 12.65 54.05 20.58 70.98 9.12 38.45 3.87 80.51-27.68 105.76l5.68 19.87 4.26-10.65 13.48-19.87 15.62-29.1 6.38-40.46-14.9-48.97-22.72-44.01-0.7-3.55zm-75.58 174.16c6.42 9.19 13.44 12.08 18.67 21.76 4.28 9.89-0.9 24.85-13.81 22.24-14.91-1.47-29.68-5.38-44.797-3.51-16.474 1.33-29.725 3.57-40.537 6.73-10.811 3.15-17.757 6.78-28.438 5.23 4.864 3.52 13.602 5.26 24.118 2.58 26.569-6.74 52.583-8.34 79.754-5.68 11.93 0.25 26.17 5.47 37.3-0.72 4.45-2.7 9.82 8.48 17.42 6.02 27.35-1.28 55.41-3.92 82.76 0.19 13.49 1.18 26.25 5.45 39.75 5.95 6.95 0.6 9.64-7.09 7.57-9.65-2.5-5.65-9.04-8.23-6.97 0.49-8.62 5.78-19.44-1.02-28.82-1.68-26.95-4.1-54.43-8.52-81.67-4.51-11.17 3.37-25.72-1.83-19.23-14.69 5.25-5.56 7.76-18.21 17.97-24.43 5.32-3.69-3.76-0.41-14.22 1.04-10.45 1.44-28.39 3.63-46.82-7.36z" style="color:#000000" fill="#aaaa"/>
    <path id="path18331" d="m214.04 332.82l-14.76-1.23s6.76 6.15 12.91 6.15 31.98 0 45.5 2.46c13.53 2.46 19.68 4.3 24.6 5.53s7.38 0 7.38 0l-14.76-5.53-19.06-4.3-41.81-3.08z" style="color:#000000" fill="#fff"/>
    <path id="path5915" d="m205.24 6.5781c-18.73-0.457-30.78 23.909-18.71 38.396 15.46 7.155 11.54 23.942 11.8 38.475-1.33 18.461-2 39.591-15.07 54.001-12.51 14.52-36.4-6.64-20.5-17.16 16.87-7.66 12-36.517-6.3-38.655-16.69-4.639-34.11 12.38-27.05 29.065 5.21 10.73 22.04 18.07 10.82 31.97-13.8 8.57-24.81 20.67-32.62 34.92-15.521 25.79-25.728 54.91-28.729 84.9 3.938 26.84 24.399 46.18 41.639 65.55-22.231 1.03-44.619 2.32-66.559 5.97-13.791 4.77-27.564 12.14-37.363 23.06 1.409 15.09 24.191 5.68 34.529 4.21 32.205-7.63 65.213-2.73 97.713-0.83 9.32-1.92 12.95-6.25 19.9 1.81 14.51 4.46 29.87-1.19 44.72-0.96 27.21-2.74 54.52 1.94 80.98 8.01 18.05 3.78 17.2-15.4 2.52-20.01-13.63-9.99-30.02-14.43-46.92-14.6-13-4.82-36.31 3.12-42.5-8.15 5.1-15.75 20.24-27.01 25.28-43.45 15.62-33.71 10.51-73.48-6.82-105.47-6.48-13.51-14.43-26.59-19.74-40.57 1.27-29.21 8.08-57.903 13.2-86.63 16.83-10.22 11.9-38.836-7.33-43.004-2.24-0.6139-4.57-0.8932-6.89-0.8479zm-0.04 3.4095c16.56-1.2784 27.66 20.031 17.32 32.94-12.35 9.611-8.37 28.435-13.05 42.334-2.77 17.638-6.53 34.648-6.74 51.928 11.69 30.86 34.56 58.88 34.67 93.34 1.74 31.8-13.27 62.1-34.91 84.61-4.38 6.67-2.74 17.01-3.67 17.56 30.07 6.95 63.11-0.16 91.21 15.31 10.08 3.27 28.25 20.39 5.74 19.12-27.47-6.49-55.71-11.42-84.06-8.91-14.54-0.68-30.58 6-44.11-0.97-5.86-10.61 5.93-23.17 7.96-34.33-0.54-3.92 3.37-3.88 5.9-5.56 1.19-0.63 3.97-2.26 3.95-2.5-8.44 3.77-18.01 5.01-26.98 4.24-8.41 1.06-18.03-1.34-24.46-6.64 4.52 5.47 11.29 8.56 18.08 10.04 7.6 13.76 14.11 39.96-10.8 34.09-33.73-3.22-67.356-5.04-100.31 4.25-9.601 6.51-33.806-0.47-15.894-9.7 18.731-15.04 43.304-19.06 66.712-18.12 13.212-0.79 27.132-0.65 39.682-4.82-12.9-4.91-20.4-20.5-29.67-30.83-9.047-13.67-20.836-29.3-16.1-46.68 4.988-32.58 17.53-64.74 38.05-90.68 8.82-9.63 27.23-14.59 22.91-31.08-2.62-12.72-22.77-18.84-13.07-35.308 8.69-14.687 36.37-10.989 36.03 7.828 0.37 15.97-25.64 20.64-11.9 39.17 15.1 12.45 36.4-2.09 38.53-19.51 6.47-22.455 6.7-46.501 4.22-69.454-14.97-5.089-22.47-30.24-4.61-39.117 2.86-1.579 6.11-2.466 9.37-2.5514zm3.29 228.78c-7.11 24.87-35.14 44.22-60.76 34.27-7.94-2.25-27.09-12.6-9.95-2 19.35 11.56 45.69 7.72 60.54-9.38 6.37-5.06 11.99-21.16 10.94-4.43 1.25 12.7 2.93-16.42-0.77-18.46z"/>
    <path id="path9033" style="color:#000000" d="m1945.4 289.08a27.519 27.519 0 1 1 -55 0 27.519 27.519 0 1 1 55 0z" transform="matrix(.58067 0 0 .58067 -910.1 -135.08)" stroke="#000" stroke-width="3.5016" fill="#fff"/>
    <path id="path10004" style="color:#000000" d="m1932.7 309.07a16.221 16.221 0 1 1 -32.5 0 16.221 16.221 0 1 1 32.5 0z" transform="matrix(.47091 0 0 .47091 -699.21 -108.69)" stroke="#000" stroke-width="17.353" fill="#fff"/>
    <g id="g11950" stroke="#000" transform="matrix(.44385 0 0 .44385 -705.46 -26.155)" fill="#fff">
      <path id="path11946" style="color:#000000" stroke-width="3.5016" transform="matrix(1.1549 0 0 1.1549 -294.79 -39.568)" d="m1945.4 289.08a27.519 27.519 0 1 1 -55 0 27.519 27.519 0 1 1 55 0z"/>
      <path id="path11948" style="color:#000000" stroke-width="17.353" transform="matrix(.93661 0 0 .93661 124.68 12.931)" d="m1932.7 309.07a16.221 16.221 0 1 1 -32.5 0 16.221 16.221 0 1 1 32.5 0z"/>
    </g>
    <path id="path16260" d="m150.83 157.07c0 0.84-0.69 1.53-1.53 1.53-0.85 0-1.53-0.69-1.53-1.53 0-0.85 0.68-1.53 1.53-1.53 0.84 0 1.53 0.68 1.53 1.53zm15.47 3.74c0 1.1-0.89 1.99-1.99 1.99s-1.99-0.89-1.99-1.99 0.89-1.99 1.99-1.99 1.99 0.89 1.99 1.99zm-9.5 19.75c0 0.93-0.76 1.69-1.69 1.69-0.92 0-1.68-0.76-1.68-1.69s0.76-1.68 1.68-1.68c0.93 0 1.69 0.75 1.69 1.68zm13.52 14.19c0 0.84-0.69 1.53-1.53 1.53-0.85 0-1.53-0.69-1.53-1.53 0-0.85 0.68-1.54 1.53-1.54 0.84 0 1.53 0.69 1.53 1.54zm23.81-34.99c0 1.43-1.17 2.6-2.61 2.6-1.43 0-2.6-1.17-2.6-2.6 0-1.44 1.17-2.61 2.6-2.61 1.44 0 2.61 1.17 2.61 2.61zm3.14 15.75c0 0.76-0.62 1.38-1.38 1.38s-1.38-0.62-1.38-1.38 0.62-1.38 1.38-1.38 1.38 0.62 1.38 1.38zm-11.03 14.85c0 1.52-1.23 2.76-2.75 2.76s-2.76-1.24-2.76-2.76 1.24-2.76 2.76-2.76 2.75 1.24 2.75 2.76zm-11.04-14.43c0 1.52-1.23 2.75-2.76 2.75-1.52 0-2.75-1.23-2.75-2.75s1.23-2.76 2.75-2.76c1.53 0 2.76 1.24 2.76 2.76zm-23.86 22.33c0 1.95-1.58 3.52-3.53 3.52-1.94 0-3.52-1.57-3.52-3.52 0-1.94 1.58-3.52 3.52-3.52 1.95 0 3.53 1.58 3.53 3.52zm-9.59-27.59c0 1.02-0.82 1.84-1.84 1.84-1.01 0-1.84-0.82-1.84-1.84 0-1.01 0.83-1.84 1.84-1.84 1.02 0 1.84 0.83 1.84 1.84zm-16.45 16.63c0 0.67-0.55 1.22-1.22 1.22-0.68 0-1.23-0.55-1.23-1.22 0-0.68 0.55-1.23 1.23-1.23 0.67 0 1.22 0.55 1.22 1.23zm-2 15.06c0 0.7-0.58 1.27-1.3 1.27-0.71 0-1.29-0.57-1.29-1.27 0-0.71 0.58-1.28 1.29-1.28 0.72 0 1.3 0.57 1.3 1.28zm38.14 11.18c0 0.84-0.69 1.53-1.53 1.53-0.85 0-1.54-0.69-1.54-1.53 0-0.85 0.69-1.53 1.54-1.53 0.84 0 1.53 0.68 1.53 1.53zm44.66-22.3c0 0.68-0.55 1.22-1.23 1.22s-1.22-0.54-1.22-1.22 0.54-1.23 1.22-1.23 1.23 0.55 1.23 1.23zm-2 15.06c0 0.7-0.59 1.27-1.3 1.27-0.72 0-1.3-0.57-1.3-1.27 0-0.71 0.58-1.28 1.3-1.28 0.71 0 1.3 0.57 1.3 1.28z" style="color:#000000" fill="#ffffff"/>
  </g>
  <metadata>
    <rdf:RDF>
      <cc:Work>
        <dc:format>image/svg+xml</dc:format>
        <dc:type rdf:resource="http://purl.org/dc/dcmitype/StillImage"/>
        <cc:license rdf:resource="http://creativecommons.org/licenses/publicdomain/"/>
        <dc:publisher>
          <cc:Agent rdf:about="http://openclipart.org/">
            <dc:title>Openclipart</dc:title>
          </cc:Agent>
        </dc:publisher>
        <dc:title>comic alien</dc:title>
        <dc:date>2008-03-30T18:21:51</dc:date>
        <dc:description>alien, clip art, clipart, comic, green, outline, space, </dc:description>
        <dc:source>http://openclipart.org/detail/16059/comic-alien-by-chrisdesign</dc:source>
        <dc:creator>
          <cc:Agent>
            <dc:title>Chrisdesign</dc:title>
          </cc:Agent>
        </dc:creator>
        <dc:subject>
          <rdf:Bag>
            <rdf:li>alien</rdf:li>
            <rdf:li>clip art</rdf:li>
            <rdf:li>clipart</rdf:li>
            <rdf:li>comic</rdf:li>
            <rdf:li>green</rdf:li>
            <rdf:li>outline</rdf:li>
            <rdf:li>space</rdf:li>
          </rdf:Bag>
        </dc:subject>
      </cc:Work>
      <cc:License rdf:about="http://creativecommons.org/licenses/publicdomain/">
        <cc:permits rdf:resource="http://creativecommons.org/ns#Reproduction"/>
        <cc:permits rdf:resource="http://creativecommons.org/ns#Distribution"/>
        <cc:permits rdf:resource="http://creativecommons.org/ns#DerivativeWorks"/>
      </cc:License>
    </rdf:RDF>
  </metadata>
</svg>
'''

WIDTH_MARSIAN = 600
HEIGHT_MARSIAN = 600
