"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContainerGroup = exports.ContainerGroupProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const eci_generated_1 = require("./eci.generated");
Object.defineProperty(exports, "ContainerGroupProperty", { enumerable: true, get: function () { return eci_generated_1.RosContainerGroup; } });
/**
 * A ROS resource type:  `ALIYUN::ECI::ContainerGroup`
 */
class ContainerGroup extends ros.Resource {
    /**
     * Create a new `ALIYUN::ECI::ContainerGroup`.
     *
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        const rosContainerGroup = new eci_generated_1.RosContainerGroup(this, id, {
            resourceGroupId: props.resourceGroupId,
            securityContextSysctl: props.securityContextSysctl,
            memory: props.memory,
            initContainer: props.initContainer,
            cpu: props.cpu,
            eipInstanceId: props.eipInstanceId,
            containerGroupName: props.containerGroupName,
            container: props.container,
            imageSnapshotId: props.imageSnapshotId,
            ramRoleName: props.ramRoleName,
            dnsConfig: props.dnsConfig,
            autoMatchImageCache: props.autoMatchImageCache,
            ipv6AddressCount: props.ipv6AddressCount,
            imageRegistryCredential: props.imageRegistryCredential,
            spotPriceLimit: props.spotPriceLimit,
            instanceType: props.instanceType,
            spotStrategy: props.spotStrategy,
            activeDeadlineSeconds: props.activeDeadlineSeconds,
            hostAliase: props.hostAliase,
            zoneId: props.zoneId,
            terminationGracePeriodSeconds: props.terminationGracePeriodSeconds,
            vSwitchId: props.vSwitchId,
            securityGroupId: props.securityGroupId,
            slsEnable: props.slsEnable,
            restartPolicy: props.restartPolicy,
            volume: props.volume,
            acrRegistryInfo: props.acrRegistryInfo,
            tag: props.tag,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosContainerGroup;
        this.attrContainerGroupId = rosContainerGroup.attrContainerGroupId;
        this.attrContainerGroupName = rosContainerGroup.attrContainerGroupName;
        this.attrEniInstanceId = rosContainerGroup.attrEniInstanceId;
        this.attrInternetIp = rosContainerGroup.attrInternetIp;
        this.attrIntranetIp = rosContainerGroup.attrIntranetIp;
        this.attrIpv6Address = rosContainerGroup.attrIpv6Address;
        this.attrRegionId = rosContainerGroup.attrRegionId;
        this.attrSecurityGroupId = rosContainerGroup.attrSecurityGroupId;
        this.attrVSwitchId = rosContainerGroup.attrVSwitchId;
        this.attrZoneId = rosContainerGroup.attrZoneId;
    }
}
exports.ContainerGroup = ContainerGroup;
//# sourceMappingURL=data:application/json;base64,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