"""Constants for the Tesla Powerwall integration."""

DOMAIN = "powerwall"

POWERWALL_OBJECT = "powerwall"
POWERWALL_COORDINATOR = "coordinator"

UPDATE_INTERVAL = 30

ATTR_REGION = "region"
ATTR_GRID_CODE = "grid_code"
ATTR_FREQUENCY = "frequency"
ATTR_ENERGY_EXPORTED = "energy_exported"
ATTR_ENERGY_IMPORTED = "energy_imported"
ATTR_INSTANT_AVERAGE_VOLTAGE = "instant_average_voltage"
ATTR_NOMINAL_SYSTEM_POWER = "nominal_system_power_kW"

SITE_INFO_UTILITY = "utility"
SITE_INFO_GRID_CODE = "grid_code"
SITE_INFO_NOMINAL_SYSTEM_POWER_KW = "nominal_system_power_kW"
SITE_INFO_NOMINAL_SYSTEM_ENERGY_KWH = "nominal_system_energy_kWh"
SITE_INFO_REGION = "region"

DEVICE_TYPE_DEVICE_TYPE = "device_type"

STATUS_VERSION = "version"

POWERWALL_SITE_NAME = "site_name"

POWERWALL_API_METERS = "meters"
POWERWALL_API_CHARGE = "charge"
POWERWALL_API_GRID_STATUS = "grid_status"
POWERWALL_API_SITEMASTER = "sitemaster"
POWERWALL_API_STATUS = "status"
POWERWALL_API_DEVICE_TYPE = "device_type"
POWERWALL_API_SITE_INFO = "site_info"

POWERWALL_HTTP_SESSION = "http_session"

POWERWALL_GRID_ONLINE = "SystemGridConnected"
POWERWALL_CONNECTED_KEY = "connected_to_tesla"
POWERWALL_RUNNING_KEY = "running"


MODEL = "PowerWall 2"
MANUFACTURER = "Tesla"

ENERGY_KILO_WATT = "kW"
