"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.appInstanceValidator = void 0;
var NAME = /^[\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*$/;
var CLIENTREQUESTTOKEN = /^[-_a-zA-Z0-9]*$/;
function appInstanceValidator(props) {
    if (props.name) {
        if (props.name.length > 256) {
            throw new Error('Name length must be >1 and <256');
        }
        if (!NAME.test(props.name)) {
            throw new Error('Invalid name.  Must fit pattern: [\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*');
        }
    }
    if (props.metadata) {
        if (props.metadata.length > 1024) {
            throw new Error('Metadata length cannote exceed 1024');
        }
    }
    if (props.clientRequestToken) {
        if (props.clientRequestToken.length < 2 ||
            props.clientRequestToken.length > 64) {
            throw new Error('ClientRequestToken length must be >2 and <64');
        }
        if (!CLIENTREQUESTTOKEN.test(props.clientRequestToken)) {
            throw new Error('Invlaid Client Request Token.  Must fit pattern: [-_a-zA-Z0-9]*');
        }
    }
    return true;
}
exports.appInstanceValidator = appInstanceValidator;
//# sourceMappingURL=data:application/json;base64,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