"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.channelFlowValidator = void 0;
var NAME = /^[\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*$/;
var CLIENTREQUESTTOKEN = /^[-_a-zA-Z0-9]*$/;
function channelFlowValidator(props) {
    if (props.name) {
        if (props.name.length < 1 || props.name.length > 256) {
            throw new Error('Name length must be >1 and <256');
        }
        if (!NAME.test(props.name)) {
            throw new Error('Invalid channel flow name.  Must fit pattern: [\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*');
        }
    }
    if (props.clientRequestToken) {
        if (props.clientRequestToken.length < 2 ||
            props.clientRequestToken.length > 64) {
            throw new Error('ClientRequestToken length must be >2 and <64');
        }
        if (!CLIENTREQUESTTOKEN.test(props.clientRequestToken)) {
            throw new Error('Invlaid Client Request Token.  Must fit pattern: [-_a-zA-Z0-9]*');
        }
    }
    if (props.processors) {
        if (Object.keys(props.processors).length < 1 ||
            Object.keys(props.processors).length > 3) {
            throw new Error('Processor count must be between 1 and 3');
        }
        for (var processor of props.processors) {
            if (processor.executionOrder < 1 || processor.executionOrder > 3) {
                throw new Error('Execution Order must be between 1 and 3');
            }
            if (processor.name.length < 1 || processor.name.length > 256) {
                throw new Error('Name length must be >1 and <256');
            }
            if (!NAME.test(processor.name)) {
                throw new Error('Invalid processor name.  Must fit pattern: [\u0009\u000A\u000D\u0020-\u007E\u0085\u00A0-\uD7FF\uE000-\uFFFD\u10000-\u10FFFF]*');
            }
        }
    }
    return true;
}
exports.channelFlowValidator = channelFlowValidator;
//# sourceMappingURL=data:application/json;base64,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