# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union
from .. import _utilities, _tables

__all__ = ['PolicyTag']


class PolicyTag(pulumi.CustomResource):
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 parent_policy_tag: Optional[pulumi.Input[str]] = None,
                 taxonomy: Optional[pulumi.Input[str]] = None,
                 __props__=None,
                 __name__=None,
                 __opts__=None):
        """
        ## Import

        PolicyTag can be imported using any of these accepted formats

        ```sh
         $ pulumi import gcp:datacatalog/policyTag:PolicyTag default {{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of this policy tag. It must: contain only unicode characters, tabs,
               newlines, carriage returns and page breaks; and be at most 2000 bytes long when
               encoded in UTF-8. If not set, defaults to an empty description.
               If not set, defaults to an empty description.
        :param pulumi.Input[str] display_name: User defined name of this policy tag. It must: be unique within the parent
               taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
               not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        :param pulumi.Input[str] parent_policy_tag: Resource name of this policy tag's parent policy tag.
               If empty, it means this policy tag is a top level policy tag.
               If not set, defaults to an empty string.
        :param pulumi.Input[str] taxonomy: Taxonomy the policy tag is associated with
        """
        if __name__ is not None:
            warnings.warn("explicit use of __name__ is deprecated", DeprecationWarning)
            resource_name = __name__
        if __opts__ is not None:
            warnings.warn("explicit use of __opts__ is deprecated, use 'opts' instead", DeprecationWarning)
            opts = __opts__
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = dict()

            __props__['description'] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__['display_name'] = display_name
            __props__['parent_policy_tag'] = parent_policy_tag
            if taxonomy is None and not opts.urn:
                raise TypeError("Missing required property 'taxonomy'")
            __props__['taxonomy'] = taxonomy
            __props__['child_policy_tags'] = None
            __props__['name'] = None
        super(PolicyTag, __self__).__init__(
            'gcp:datacatalog/policyTag:PolicyTag',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            child_policy_tags: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            parent_policy_tag: Optional[pulumi.Input[str]] = None,
            taxonomy: Optional[pulumi.Input[str]] = None) -> 'PolicyTag':
        """
        Get an existing PolicyTag resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] child_policy_tags: Resource names of child policy tags of this policy tag.
        :param pulumi.Input[str] description: Description of this policy tag. It must: contain only unicode characters, tabs,
               newlines, carriage returns and page breaks; and be at most 2000 bytes long when
               encoded in UTF-8. If not set, defaults to an empty description.
               If not set, defaults to an empty description.
        :param pulumi.Input[str] display_name: User defined name of this policy tag. It must: be unique within the parent
               taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
               not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        :param pulumi.Input[str] name: Resource name of this policy tag, whose format is:
               "projects/{project}/locations/{region}/taxonomies/{taxonomy}/policyTags/{policytag}"
        :param pulumi.Input[str] parent_policy_tag: Resource name of this policy tag's parent policy tag.
               If empty, it means this policy tag is a top level policy tag.
               If not set, defaults to an empty string.
        :param pulumi.Input[str] taxonomy: Taxonomy the policy tag is associated with
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = dict()

        __props__["child_policy_tags"] = child_policy_tags
        __props__["description"] = description
        __props__["display_name"] = display_name
        __props__["name"] = name
        __props__["parent_policy_tag"] = parent_policy_tag
        __props__["taxonomy"] = taxonomy
        return PolicyTag(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="childPolicyTags")
    def child_policy_tags(self) -> pulumi.Output[Sequence[str]]:
        """
        Resource names of child policy tags of this policy tag.
        """
        return pulumi.get(self, "child_policy_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        Description of this policy tag. It must: contain only unicode characters, tabs,
        newlines, carriage returns and page breaks; and be at most 2000 bytes long when
        encoded in UTF-8. If not set, defaults to an empty description.
        If not set, defaults to an empty description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        User defined name of this policy tag. It must: be unique within the parent
        taxonomy; contain only unicode letters, numbers, underscores, dashes and spaces;
        not start or end with spaces; and be at most 200 bytes long when encoded in UTF-8.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Resource name of this policy tag, whose format is:
        "projects/{project}/locations/{region}/taxonomies/{taxonomy}/policyTags/{policytag}"
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="parentPolicyTag")
    def parent_policy_tag(self) -> pulumi.Output[Optional[str]]:
        """
        Resource name of this policy tag's parent policy tag.
        If empty, it means this policy tag is a top level policy tag.
        If not set, defaults to an empty string.
        """
        return pulumi.get(self, "parent_policy_tag")

    @property
    @pulumi.getter
    def taxonomy(self) -> pulumi.Output[str]:
        """
        Taxonomy the policy tag is associated with
        """
        return pulumi.get(self, "taxonomy")

    def translate_output_property(self, prop):
        return _tables.CAMEL_TO_SNAKE_CASE_TABLE.get(prop) or prop

    def translate_input_property(self, prop):
        return _tables.SNAKE_TO_CAMEL_CASE_TABLE.get(prop) or prop

