#!/usr/bin/env python3
#
# GlobalChem - Common Lube Ingredients
#
# ------------------------------------

class Lube(object):

    def __init__(self):

        self.name = 'lube'

    @staticmethod
    def get_smiles():

        smiles = {
            'water': 'O',
            'glycerin': 'C(C(CO)O)O',
            'dimethicone': 'C[Si](C)(C)O[Si](C)(C)C',
            'vinyl dimethicone': 'C[Si](C)(C)O[Si](C)(C)O[Si](C)(C=C)O[Si](C)(C)C',
            'cyclomethicone': 'C[Si]1(O[Si](O[Si](O[Si](O[Si](O1)(C)C)(C)C)(C)C)(C)C)C',
            'phenyl trimethicone': 'C[Si](C)(C)O[Si](C1=CC=CC=C1)(O[Si](C)(C)C)O[Si](C)(C)C',
            'cyclopentasiloxane': 'C[Si](O[Si]1(C)C)(O[Si](C)(O[Si](C)(C)O[Si](C)(C)O1)C)C',
            'polyethylene glycol': 'COCCCCO',
            'propylene glycol': 'CC(CO)O',
            'propanediol': 'CCC(O)O',
            'polyoxyethylene': 'CCCCCCCCC=CCCCCCCCC(=O)OCCOCC(C1C(CC(O1)OCCO)OCCO)OCCO',
            'optifio H370VF': '',
            'carboxymethylcellulose': 'CC(=O)[O-].C(C(C(C(C(C=O)O)O)O)O)O',
            'hydroxyethylcellulose': 'CC(COCC1C(C(C(C(O1)OC2C(OC(C(C2OCC(C)O)OCC(C)O)OCC(C)O)COCC(C)O)OCC(C)O)OCC(C)O)OCC(C)O)O',
            'xanthan gum': 'CC(=O)OCC1C(C(C(C(O1)OC2C(C(OC(C2OC3C(C(C(C(O3)CO)OP)O)O)CO)CP)O)OC4C(C(C(C(O4)C(=O)O)OC5C(C(C6C(O5)COC(O6)(C)C(=O)O)O)O)O)O)O)O',
            'agar': 'CC1C(C2C(C(O1)CO2)OC3C(C(C(C(O3)CO)O)OC)O)O',
            'pectin': 'C1(C(C(OC(C1O)O)C(=O)O)O)O',
            'maltodextrin': 'OCC(O)C(O)C(O)C(O)C=O',
            'sodium benzoate': 'C1=CC=C(C=C1)C(=O)[O-].[Na+]',
            'potassium sorbate': 'CC=CC=CC(=O)[O-].[K+]',
            'chlorhexidine': 'C1=CC(=CC=C1NC(=NC(=NCCCCCCN=C(N)N=C(N)NC2=CC=C(C=C2)Cl)N)N)Cl',
            'phenoxyethanol': 'C1=CC=C(C=C1)OCCO',
            'pethylhexylglycerin': 'OC(COCC(CCCC)CC)CO',
            'pentylene glycol': 'CCCC(CO)O',
            'methylparaben': 'COC(=O)C1=CC=C(C=C1)O',
            'propylparaben': 'CCCOC(=O)C1=CC=C(C=C1)O',
            'butylparaben': 'CCCCOC(=O)C1=CC=C(C=C1)O',
            'phthalates': 'COC(=O)C1=CC=CC=C1C(=O)OC',
            'chlorhexidine digluconate': 'C1=CC(=CC=C1NC(=NC(=NCCCCCCN=C(N)N=C(N)NC2=CC=C(C=C2)Cl)N)N)Cl.C(C(C(C(C(C(=O)O)O)O)O)O)O.C(C(C(C(C(C(=O)O)O)O)O)O)O',
            'diazolidinyl urea': 'C(NC(=O)N(CO)C1C(=O)N(C(=O)N1CO)CO)O',
            'sucralose': 'C(C1C(C(C(C(O1)OC2(C(C(C(O2)CCl)O)O)CCl)O)O)Cl)O',
            'sodium saccharine': 'C1=CC=C2C(=C1)C(=O)NS2(=O)=O.[Na+',
            'rebaudioside a': 'CC12CCCC(C1CCC34C2CCC(C3)(C(=C)C4)OC5C(C(C(C(O5)CO)O)OC6C(C(C(C(O6)CO)O)O)O)OC7C(C(C(C(O7)CO)O)O)O)(C)C(=O)OC8C(C(C(C(O8)CO)O)O)O',
            'tocopheryl acetate': 'CC1=C(C(=C(C2=C1OC(CC2)(C)CCCC(C)CCCC(C)CCCC(C)C)C)OC(=O)C)C',
            'sodium hydroxide': 'NaO',
            'gluconolactone': 'C(C1C(C(C(C(=O)O1)O)O)O)O',
            'sodium hyaluronate': 'CC(=O)NC1CC(C(OC1OC2C(C(C(OC2C(=O)[O-])O)O)O)CO)O.[Na+]',
            'castor oil': 'CCCCCCC(CC=CCCCCCCCC(=O)OCC(COC(=O)CCCCCCCC=CCC(CCCCCC)O)OC(=O)CCCCCCCC=CCC(CCCCCC)O)O',
            'benzocaine': 'CCOC(=O)C1=CC=C(C=C1)N',
        }

        return smiles

    @staticmethod
    def get_smarts():

        smarts = {
            'water': '[#8]',
            'glycerin': '[#6](-[#6](-[#6]-[#8])-[#8])-[#8]',
            'dimethicone': '[#6]-[Si](-[#6])(-[#6])-[#8]-[Si](-[#6])(-[#6])-[#6]',
            'vinyl dimethicone': '[#6]-[Si](-[#6])(-[#6])-[#8]-[Si](-[#6])(-[#6])-[#8]-[Si](-[#6])(-[#6]=[#6])-[#8]-[Si](-[#6])(-[#6])-[#6]',
            'cyclomethicone': '[#6]-[Si]1(-[#8]-[Si](-[#8]-[Si](-[#8]-[Si](-[#8]-[Si](-[#8]-1)(-[#6])-[#6])(-[#6])-[#6])(-[#6])-[#6])(-[#6])-[#6])-[#6]',
            'phenyl trimethicone': '[#6]-[Si](-[#6])(-[#6])-[#8]-[Si](-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1)(-[#8]-[Si](-[#6])(-[#6])-[#6])-[#8]-[Si](-[#6])(-[#6])-[#6]',
            'cyclopentasiloxane': '[#6]-[Si]1(-[#8]-[Si](-[#6])(-[#6])-[#8]-[Si](-[#8]-[Si](-[#8]-[Si](-[#8]-1)(-[#6])-[#6])(-[#6])-[#6])(-[#6])-[#6])-[#6]',
            'polyethylene glycol': '[#6]-[#8]-[#6]-[#6]-[#6]-[#6]-[#8]',
            'propylene glycol': '[#6]-[#6](-[#6]-[#8])-[#8]',
            'propanediol': '[#6]-[#6]-[#6](-[#8])-[#8]',
            'polyoxyethylene': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6]-[#8]-[#6]-[#6](-[#6]1-[#6](-[#6]-[#6](-[#8]-1)-[#8]-[#6]-[#6]-[#8])-[#8]-[#6]-[#6]-[#8])-[#8]-[#6]-[#6]-[#8]',
            'optifio H370VF': '',
            'carboxymethylcellulose': '[#6]-[#6](=[#8])-[#8-].[#6](-[#6](-[#6](-[#6](-[#6](-[#6]=[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'hydroxyethylcellulose': '[#6]-[#6](-[#6]-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#8]-[#6](-[#6](-[#6]-1-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#6]-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]-[#6]-[#6](-[#6])-[#8])-[#8]',
            'xanthan gum': '[#6]-[#6](=[#8])-[#8]-[#6]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1-[#6](-[#6](-[#8]-[#6](-[#6]-1-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8]-[#15])-[#8])-[#8])-[#6]-[#8])-[#6]-[#15])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6](=[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6]2-[#6](-[#8]-1)-[#6]-[#8]-[#6](-[#8]-2)(-[#6])-[#6](=[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'agar': '[#6]-[#6]1-[#6](-[#6]2-[#6](-[#6](-[#8]-1)-[#6]-[#8]-2)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8]-[#6])-[#8])-[#8]',
            'pectin': '[#6]1(-[#6](-[#6](-[#8]-[#6](-[#6]-1-[#8])-[#8])-[#6](=[#8])-[#8])-[#8])-[#8]',
            'maltodextrin': '[#8]-[#6]-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])-[#6](-[#8])-[#6]=[#8]',
            'sodium benzoate': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#6](=[#8])-[#8-].[Na+]',
            'potassium sorbate': '[#6]-[#6]=[#6]-[#6]=[#6]-[#6](=[#8])-[#8-].[K+]',
            'chlorhexidine': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#7]-[#6](=[#7]-[#6](=[#7]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#7]=[#6](-[#7])-[#7]=[#6](-[#7])-[#7]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#17])-[#7])-[#7])-[#17]',
            'phenoxyethanol': '[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]-[#6]-[#6]-[#8]',
            'pethylhexylglycerin': '[#8]-[#6](-[#6]-[#8]-[#6]-[#6](-[#6]-[#6]-[#6]-[#6])-[#6]-[#6])-[#6]-[#8]',
            'pentylene glycol': '[#6]-[#6]-[#6]-[#6](-[#6]-[#8])-[#8]',
            'methylparaben': '[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'propylparaben': '[#6]-[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'butylparaben': '[#6]-[#6]-[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#8]',
            'phthalates': '[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6]:[#6]:[#6]:1-[#6](=[#8])-[#8]-[#6]',
            'chlorhexidine digluconate': '[#6]1:[#6]:[#6](:[#6]:[#6]:[#6]:1-[#7]-[#6](=[#7]-[#6](=[#7]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#7]=[#6](-[#7])-[#7]=[#6](-[#7])-[#7]-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#17])-[#7])-[#7])-[#17].[#6](-[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8].[#6](-[#6](-[#6](-[#6](-[#6](-[#6](=[#8])-[#8])-[#8])-[#8])-[#8])-[#8])-[#8]',
            'diazolidinyl urea': '[#6](-[#7]-[#6](=[#8])-[#7](-[#6]-[#8])-[#6]1-[#6](=[#8])-[#7](-[#6](=[#8])-[#7]-1-[#6]-[#8])-[#6]-[#8])-[#8]',
            'sucralose': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#8]-[#6]1(-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#17])-[#8])-[#8])-[#6]-[#17])-[#8])-[#8])-[#17])-[#8]',
            'sodium saccharine': '[#6]1:[#6]:[#6]:[#6]2:[#6](:[#6]:1)-[#6](=[#8])-[#7]-[#16]-2(=[#8])=[#8].[Na+]',
            'rebaudioside a': '[#6]-[#6]12-[#6]-[#6]-[#6]-[#6](-[#6]-1-[#6]-[#6]-[#6]13-[#6]-2-[#6]-[#6]-[#6](-[#6]-1)(-[#6](=[#6])-[#6]-3)-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8])(-[#6])-[#6](=[#8])-[#8]-[#6]1-[#6](-[#6](-[#6](-[#6](-[#8]-1)-[#6]-[#8])-[#8])-[#8])-[#8]',
            'tocopheryl acetate': '[#6]-[#6]1:[#6](:[#6](:[#6](:[#6]2:[#6]:1-[#8]-[#6](-[#6]-[#6]-2)(-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6]-[#6]-[#6]-[#6](-[#6])-[#6])-[#6])-[#8]-[#6](=[#8])-[#6])-[#6]',
            'sodium hydroxide': '[Na+].[#8]',
            'gluconolactone': '[#6](-[#6]1-[#6](-[#6](-[#6](-[#6](=[#8])-[#8]-1)-[#8])-[#8])-[#8])-[#8]',
            'sodium hyaluronate': '[#6]-[#6](=[#8])-[#7]-[#6]1-[#6]-[#6](-[#6](-[#8]-[#6]-1-[#8]-[#6]1-[#6](-[#6](-[#6](-[#8]-[#6]-1-[#6](=[#8])-[#8-])-[#8])-[#8])-[#8])-[#6]-[#8])-[#8].[Na+]',
            'castor oil': '[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](-[#6]-[#6]=[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6](=[#8])-[#8]-[#6]-[#6](-[#6]-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])-[#8])-[#8]-[#6](=[#8])-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]-[#6]=[#6]-[#6]-[#6](-[#6]-[#6]-[#6]-[#6]-[#6]-[#6])-[#8])-[#8]',
            'benzocaine': '[#6]-[#6]-[#8]-[#6](=[#8])-[#6]1:[#6]:[#6]:[#6](:[#6]:[#6]:1)-[#7]',
        }

        return smarts

    @staticmethod
    def get_bit_vector():

        bit_vector = {
            'water': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'glycerin': '01000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000001100000000000000000001000000000',
            'dimethicone': '00000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010100000000000000000000000000000000000000000000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000',
            'vinyl dimethicone': '00000000000000000000000000000000010000000001000000000001000000000000000000000000000000000000000000000000000001000000000000000000000000000000000010000000000000000000100000000000000000110000000000000000000100000000000010000000000000000000000000000000100000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000010100000000000000000000000000000000000010000000000000000000000000000000000000000000000100010000000000000000000000000000000000000000000',
            'cyclomethicone': '00000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000010000000000000000000000000000000000000100000000000000000000000000000000000100000000000000000000000000000',
            'phenyl trimethicone': '00000000000000000000000000000000010000000000000000000000000000001000000100000000000000000000000000000000000000000000000000001000000000000000000010000000000000000000000000000001000000010000000000000000000000000000001000000000000000000000100000000000000000000000100000000000000000000000000000000000100000000000000000000000000000000000000001000000000000000000100000000000000000000010100000000100000000000000000000000000000000000000000000000000000000000000000000000000100010000000000001000000000000000000000000000000',
            'cyclopentasiloxane': '00000000000000000000000100000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000010000000000000000000000000000000000000100000000000000000000000000000000000100000000000000000000000000000',
            'polyethylene glycol': '00000000000001000000000000000100010000000000000000000000000000000000000000000000100000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000010010000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000100000000000000000000000000000000000000000000010000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000100000000000010000001000000000000000000',
            'propylene glycol': '01000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000001000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000010000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000',
            'propanediol': '01000000100000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000000011000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'polyoxyethylene': '01010000001001000000000000001000010000000000000000000100000000000000000000000001100100000000000000000000000000000100001100000000000000000010000010010000000000000000010000010000000000110000000000000000000000000100000000011010000000000000000000010000000000000000000100001000100000000010001000000011000000000000000100001000000000000000100000010000010000000000000000100000000000010000010001000000001000000100000000010010100010000000000001000010000000000000000010000000000000010100000000000100000000000000000000011000',
            'optifio H370VF': '00000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'carboxymethylcellulose': '01000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000100010000000000000001100000000000000000010000100010000000000000000000000000000000000000000010000100000000000000001000000000000000000000101000000000000000000000000000000000000000000000000000000001100010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000001001000',
            'hydroxyethylcellulose': '01000000000000000000000000000000010000000000000000000100000010000000000000000000100000000000000000100000100000001000001000000000000000000000000010000100000001010001000000000000000001010000000000000000100000000000000000000000000110000000000000000000000000000000000000000000000000000001000000000001000100000000010100000000000000000000000000010000000000000000010000000000000000000000000001000000000000000100000000010010000000000000000000010000010000000000000110000000000000000000000000000000000000000000000000010000',
            'xanthan gum': '00000000000100000011001001000000010010001000001000000100001010001000000000000000100000000100010000100000000000001001000000000010000000000010000010010000010101100000000000000000000000111000000000000010000000000000000000000110000010000100000000000000101000000000000000000000000000000001000000000001000100000000100010000000000010010000001000000010000000000000010100000000000000000000010001010110000000000000000100100010000000000000000000000000010100111000000000000001000000000000001001000000010010000000000001110000',
            'agar': '00000000010000000000000000000000010000100100000000000100001000000000000000000000100000000000000000100000000000000000000000000000000000000000000010000000000000000000000000000000001000010010010000000000000000000010000000000110000010000100000000000000000000000000000000000010000000000001110000100001010100000000000000000000000000000100000000000000000000000000010000000000000000000000000001010000000000001000000000000010000000000100000000000000010100000000000000000001000000000000000000000000000010000000000000010000',
            'pectin': '00000000000001000000000000000010000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000001010000010000000000000100000000000000000000000100000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000001000000000000000000000010001000100000000000000000100000000000000000000000000000000000000001000000000000001000000000000000000000000000000000000000000010000',
            'maltodextrin': '01000000000000000000000000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000010000001000000000000000000000000000000000000100010000000000000000000000000000000000010000100010000000000000000000000000000000000000000000000100000000000000001000000000000000000000101000000000000000000000000000000000000000000000000000000001100000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100000000010000000000000001000',
            'sodium benzoate': '00000000000000000000000000000000100000000000000000000000000000001000000000000000000000000000000000000000100000000000000000000000000000000010000000000000000100000000000000000001000000000000010000000000001100000000001000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000001000000000000000000100001000000000000000000010000000100000000000000000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000000000',
            'potassium sorbate': '00000000000000000000000000000001010000000000000000000000000000000000000000000000010001000000000000000000000000000000000010001000000000000010000000000000000000000000000000000000000000100000000000000000001100001000000000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000100000010000000000000000000000000000000000000000010000010000000000000000000000000000000000000001000010000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'chlorhexidine': '00000000000000000000000000000000000000000000001001000100000000010000000000000000100000000001000000000000000000000000000100000000100000000000100010011000000000000000000000000000011000000000000100010000000000001001011010000000000000000000000000000000000000000000000100000000000000001000000000000001000000001000000000000000000000000001000001000000000000000000100000000000000000010000000000000000000000000010000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000000',
            'phenoxyethanol': '00000000001001000000000000000000000000000000000000100000000000001000000000000000100000000000000000000010000000000000000000000000000000001000000000000000000000000000000000000001000000010000000000000000000000000000001000000010000000000000000000000000000000000000000000000000000000000000000000000001000000000000000000000000001000000000000001000000010000000000100000000000000000000000000000000100000000000000000000000000000000000000100000000000000000000000000000000000000000000100000000000000000000000000000000000000',
            'pethylhexylglycerin': '01000000100000100000000000000000010000000000000000000000000000000000000000000001100000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000010000001000100000000001000000000000000010000100000000000000000000000000000000000000000000000000000010000000000011000000001000100000000000000000000000000000000000000000000000001000000000000000010000000000000000000010000000000000000000000000000000000000001000010000000000000010000000000000000000000000100000000000000000001000000000',
            'pentylene glycol': '01000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000010000100000000000000000000000000000000000000000000000000000010000010000011000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000000000000000000000000000000100100000000000000001000000000',
            'methylparaben': '00000000000000000000000000000000010000000000000000000000000000000010000000000000000000000000001000000000000000000000000000000000100000000010000001000000000000000100000000000000000100010000000000000000000000000000001000000000000000000100000000100000000000000000000000000000000000000000000001000001000000000000000000000000000000000100000001000000000000000000100001000000000000000000010000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000',
            'propylparaben': '00000000000001000000000000000000010000000000000000000000100000000010000000000000100000000000001000000000000000000000000000000000000000000010000001010000000000000100000100000000000000010000000000000000000000000000001000000000000000000100000000100000000000000000000000000000000000000010000001000011000000000000000000000000000000000000000001000000000000000000101001000000000000000000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000',
            'butylparaben': '00000000000001000000000000000000010000000000000000000000100000000010000000000001100000000000001000000000000000000000000000000000000000000010000001010000000000000100000000000000000000010000000000000010000000100000001000000000000000000100000000100000000000000000000000000000000000000010000001000011000000000000000000000000000000000000000001000000000000000000100001000000000000010000010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000010000000000000',
            'phthalates': '00000000000000000000000000000000010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000100000000010000001000000000000000000000000000001000000010000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000000000000000000001000000000000000100000000000000000100000001000000000000000000100000000000000000000000010000000000001000000000000000000000000000011000000000000000000000000000000100000000000000000000000000000000000000000000000000000000',
            'chlorhexidine digluconate': '01000000000000000000000000000000000000000000001001000100000000010000000000000000100000000001000000000000000000000000000100000000100000000010100011011000000000000000000000000000011000000000000100010000000000001001011010000010000100000000000000000000000000000000000100000000000000001000000000000001000000001000100000000101000000000001000001000000000000000000100000001000000000011100010000010100000000000010000000010000000000000000000000000000000000000000000000000000000010000000000000100000000000000000000000000000',
            'diazolidinyl urea': '00000100000000000000000000000000000000001000000000000000000000000000010000001000100000000000101000000000000000000000000000000000100000000010000000000000000010000000001000010000000000000000000001000100000000000000010000000010000000000000000101000000000000001001000000000000000000000000000000000001000000000000000000100000000000000000000000000000000000000000100010000000010000000000010000000000100000000000100000010000100000010000000100000000000000000000001000000000000000000000000000000000000000000000000000010000',
            'sucralose': '10000000000000000000000000000000000010000000001000000100000000001000100000000100100001000000000000100010000000000000000000000000000000000000000010010000000000000000000000000000000000010100000000000001000010000000000000000011000010010100000000000000000000000000000000000000000000000100000000000001000100000000000000000000000000000001000000000000000000000000100000000000000000000000000001000000000000000000100000000000000000001000000000000000010000001000010000000001000000000000000000000000010010000000000000010001',                                                                                                                                                                                        'rebaudioside a': '00001000000001000000000000000001010110000000000000000101000001000000000000000000100000000000000000100010000000000001000010001100000000000010000010000000010100100000000000000000000000010000000000000000001010000010000000000011010010000100000000000000001000000000000000110000000000100000000000000001000101000000100001000000010000000000000000000010000000000000110000000000000000000100010001000000000000100000000000000110000000000000100000010000010100000000010000000001000000000000001000000010010010000000000010010000',
            'tocopheryl acetate': '01000000000100000000000000100000010010000000000000000000000000000000000000000000100000010000000000000000000000000000001000000000000000000010000010100000000000001000000000100000000000010010010001000000001000000000000000000000000111000000000100010000001010000010001000000010000000000001000000000001000000000000000100000000000010000000010000000000100000000000100001000000000000010000010100000000000000000000001000000010000000000000000000000000010000000000000000000000000000000000000000000000010000000000000001000000',
            'gluconolactone': '00000000000100000000000000000000000000000000000000000000000000000000000000000000100000000000000000100000000000000000000000000000000000000110000010000000000000000000100000000000000000000000000000000000000000000000000000000010000010000100001000000000000000000000000000000000000000000000000000000001000000000000100000100010000000000000000000000000000000000000100000000000001000000000000000000000000000000000000000000000001000000000010000000000000000000000000000000001000000000000000000000000000010000000000000010000',
            'sodium hyaluronate': '00000000000000000000000000000000010000000000000000100100000000001000000000000000100000100100000000100000000000000000000000000000100000000010000010000000000010100000000000000000000000010000010000010000001100000000000000000010000010000100000010000100100000000000000000001001000000000000000000000001000100000000000000000000000000000000100001000000000000000000011000000000100000100001010001010000000000000000000000000010000000000000000000000000010000001000000000000001000000000000000000000000000010000000000001010000',
            'castor oil': '01000000000000000000000000001000010000000000000000000000000000100000010000000001100100000000000000000000000100000000001100000100000001000010000000010000000000000000010000000000000000110000000000100000000000000000000001010000000100000000000000010000000000000001000100000000000000000010000000000011000000000000000000000000000000000000100000000000000000000000000000100000100000010000010000000000000000000100000000000000110010000000000000000000010000000000000000000000000000000000000100000000000000000000001000000000',
            'benzocaine': '00000000000000000000000000000000010000000000000000000000000000000000000000000000100000000000001000000000000000000000000000000000000000000010000011010000000000000100000000000000000000010010000000000000000000000000001000000000000000000000000000000001000000000000000000001000000000000000000000000011000000000000000000000000000000000000000001000000000000000000100001000000000000001000010000000000000000000000000000000000000000000000000001000000000000000000000000000000000000000000000000000000000000000010000000000000',
        }

        return bit_vector