# Generated by Django 3.2.22 on 2024-10-28 20:32

from django.db import migrations, models
import uuid

def copy_uuid_to_queue_uuid(apps, schema_editor):
    ticketerqueue = apps.get_model('internal', 'TicketerQueue')

    for queue in ticketerqueue.objects.all():
        queue.queue_uuid = queue.topic.uuid
        queue.save()

class Migration(migrations.Migration):

    dependencies = [
        ('internal', '0002_project'),
    ]

    operations = [
        migrations.AddField(
            model_name='ticketerqueue',
            name='queue_uuid',
            field=models.UUIDField(default=uuid.uuid4),
        ),
        migrations.RunPython(copy_uuid_to_queue_uuid),
    ]

