#!/usr/bin/env python
# setup.py generated by flit for tools that don't yet use PEP 517

from distutils.core import setup

packages = \
['microsoft_auth', 'microsoft_auth.migrations']

package_data = \
{'': ['*'],
 'microsoft_auth': ['static/*',
                    'static/microsoft/*',
                    'static/microsoft/css/*',
                    'static/microsoft/js/*',
                    'templates/*',
                    'templates/microsoft/*']}

install_requires = \
['django>=2.2', 'pyjwt[crypto]<3.0', 'requests-oauthlib', 'requests']

extras_require = \
{'dev': ['bandit',
         'black',
         'djangoql',
         'doc8',
         'flake8-bugbear',
         'flake8-builtins',
         'flake8-commas',
         'flake8-comprehensions',
         'flake8',
         'flit',
         'furo',
         'ipython',
         'isort',
         'pip-tools',
         'pyproject-flake8',
         'snooty-lextudio',
         'sphinx'],
 'ql': ['djangoql'],
 'test': ['coverage', 'pytest', 'pytest-cov', 'pytest-django', 'pytest-sugar']}

setup(name='django_microsoft_auth',
      version='2.4.1',
      description='Simple app to enable Microsoft Account, Office 365 and Xbox Live authentcation as a',
      author=None,
      author_email='Christopher Bailey <cbailey@mort.is>',
      url=None,
      packages=packages,
      package_data=package_data,
      install_requires=install_requires,
      extras_require=extras_require,
      python_requires='>=3.8',
     )
