from nlu.pipe.extractors.extractor_base_data_classes import SparkNLPExtractor, SparkNLPExtractorConfig
from nlu.pipe.extractors.extractor_methods.helper_extractor_methods import *
from nlu.pipe.extractors.extractor_methods.base_extractor_methods import *

"""
This file contains methods to get pre-defined configurations for every annotator in OCR
Extractor_resolver.py should be used to resolve SparkNLP Annotator classes to methods 
in this file, which return the corrosponding configs that need to be passed to 
the master_extractor() call.

This file is where all the in extractor_base_data_classes.py Dataclasses are combined with the 
extractors defined in extractor_methods.py.

"""
def default_text_recognizer_config(output_col_prefix='ocr_text'):
    return SparkOCRExtractorConfig(
        get_text=True,
        output_col_prefix=output_col_prefix,
        name='default text recognizer config',
        description='Gets the text from an text recognizing OCR transformer',
    )


def default_visual_classifier_config(output_col_prefix='visual_classifier'):
    return SparkOCRExtractorConfig(
        output_col_prefix=output_col_prefix,
        name='visual_classifier label and confidence ',
        description='Gets label and confidence of visual classifier',
    )


def default_binary_to_image_config(output_col_prefix='binary_image'):
    return SparkOCRExtractorConfig(
        output_col_prefix=output_col_prefix,
        get_image_origin=True,
        get_image_height=True,
        get_image_width=True,
        get_image_n_channels=True,
        get_image_mode=True,
        get_image_resolution=True,
        get_image_data = True,
        name='FULL binary to image extractor ',
        description='Gets all fields generated by binary to image Transformer ',
    )
