from nlu.universe.feature_node_ids import NLP_NODE_IDS, NLP_HC_NODE_IDS, OCR_NODE_IDS


class Spellbook:
    trainable_models = {
        # map NLU references to NLP approaches
        'train.deep_sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.classifier_dl': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.classifier': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,  # classifier DL alias
        'train.named_entity_recognizer_dl': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.ner': NLP_NODE_IDS.TRAINABLE_NER_DL,  # ner DL alias
        'train.sentiment_dl': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.sentiment': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,  # sent DL alias
        'train.pos': NLP_NODE_IDS.TRAINABLE_POS,
        'train.multi_classifier': NLP_NODE_IDS.TRAINABLE_MULTI_CLASSIFIER_DL,
        'train.generic_classifier': NLP_HC_NODE_IDS.TRAINABLE_GENERIC_CLASSIFIER,
        'train.resolve_sentence': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.resolve': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.assertion': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assert': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assertion_dl': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,

        # 'train.sentence_detector': '',  # deep sentence detector alias
        # 'train.symmetric_spell': '',
        # 'train.context_spell': '',
        # 'train.spell': '',  ## context spell alias
        # 'train.norvig_spell': '',
        # 'train.unlabeled_dependency_parser': '',
        # 'train.labeled_dependency_parser': '',
        # 'train.vivekn_sentiment': '',

    }

    # Reference to all datasets for which we have pretrained models
    datasets = []
    chunk_embeddings = ['embed_sentence']
    # The vocabulary of the nlu Namespace. Any of this references give you a model_anno_obj
    # keys inside a language dict are NLU references and value is the name in SparkNLP

    component_alias_references = {
        # references for SparkNLPAnnotators without pretrained models.
        #  These are names for NLU components that can be created withouth a language prefix

        # multi lang pipes
        'lang': ('detect_language_375', 'component_list'),  # multi lang alias

        # Aliases
        'classify.lang': ('detect_language_375', 'component_list'),  # multi lang detector default

        # eng pipes
        'classify': ('analyze_sentiment', 'component_list'),  # default classifier
        'explain': ('explain_document_ml', 'component_list'),  # default explain
        'explain.ml': ('explain_document_ml', 'component_list'),
        'explain.dl': ('explain_document_dl', 'component_list'),
        'ner.conll': ('recognize_entities_dl', 'component_list'),  # default ner
        'ner.dl': ('recognize_entities_dl', 'component_list'),
        'ner.bert': ('recognize_entities_bert', 'component_list'),
        'ner': ('onto_recognize_entities_sm', 'component_list'),  # default  ner.onto
        'ner.onto': ('onto_recognize_entities_sm', 'component_list'),  # default  ner.onto
        'ner.onto.sm': ('onto_recognize_entities_sm', 'component_list'),

        # 'match.text': ('text_matcher', 'model_anno_obj'),
        # 'match.regex': ('regex_matcher', 'model_anno_obj'),
        # 'match.date': ('date_matcher', 'model_anno_obj'),
        # 'match.context': ('context_parser', 'model_anno_obj'),
        # 'context_parser': ('context_parser', 'model_anno_obj'),

        'match.chunks': ('match_chunks', 'component_list'),
        'clean.stop': ('clean_stop', 'component_list'),
        # 'clean.pattern': ('clean_pattern', 'component_list'),
        'clean.slang': ('clean_slang', 'component_list'),
        # 'spell': ('check_spelling','component_list'),  # bad spell_checker,
        'spell': ('spellcheck_dl', 'model_anno_obj'),  # default spell
        'sentiment': ('sentimentdl_glove_imdb', 'model_anno_obj'),
        'emotion': ('classifierdl_use_emotion', 'model_anno_obj'),  # default emotion model_anno_obj

        'sentiment.imdb': ('analyze_sentimentdl_use_imdb', 'component_list'),
        'sentiment.imdb.use': ('analyze_sentimentdl_use_imdb', 'component_list'),
        'sentiment.twitter.use': ('analyze_sentimentdl_use_twitter', 'component_list'),
        'sentiment.twitter': ('analyze_sentimentdl_use_twitter', 'component_list'),
        'dependency': ('dependency_conllu', 'model_anno_obj'),

        'tokenize': ('spark_nlp_tokenizer', 'model_anno_obj'),  # tokenizer rule based model_anno_obj
        'stem': ('stemmer', 'model_anno_obj'),  # stem rule based model_anno_obj
        'norm': ('normalizer', 'model_anno_obj'),  # rule based model_anno_obj
        'norm_document': ('document_normalizer', 'model_anno_obj'),  # rule based model_anno_obj

        'chunk': ('default_chunker', 'model_anno_obj'),  # rule based model_anno_obj
        'embed_chunk': ('chunk_embeddings', 'model_anno_obj'),  # rule based model_anno_obj
        'ngram': ('ngram', 'model_anno_obj'),  # rule based model_anno_obj

        'lemma': ('lemma_antbnc', 'model_anno_obj'),  # lemma default en
        'lemma.antbnc': ('lemma_antbnc', 'model_anno_obj'),
        'pos': ('pos_anc', 'model_anno_obj'),  # pos default en
        'pos.anc': ('pos_anc', 'model_anno_obj'),
        'pos.ud_ewt': ('pos_ud_ewt', 'model_anno_obj'),
        # 'ner.crf' :'ner_crf', # crf not supported in NLU
        'ner.dl.glove.6B_100d': ('ner_dl', 'model_anno_obj'),
        'ner.dl.bert': ('ner_dl_bert', 'model_anno_obj'),  # points ner bert
        'ner.onto.glove.6B_100d': ('onto_100', 'model_anno_obj'),
        'ner.onto.glove.6B_300d': ('onto_300', 'model_anno_obj'),  # this uses multi lang embeds!
        'sentence_detector': ('sentence_detector_dl', 'model_anno_obj'),
        'sentence_detector.deep': ('sentence_detector_dl', 'model_anno_obj'),  # ALIAS

        'sentence_detector.pragmatic': ('pragmatic_sentence_detector', 'model_anno_obj'),

        'spell.symmetric': ('spellcheck_sd', 'model_anno_obj'),  # TODO erronous
        'spell.norivg': ('spellcheck_norvig', 'model_anno_obj'),
        'sentiment.vivekn': ('sentiment_vivekn', 'model_anno_obj'),
        'dep.untyped.conllu': ('dependency_conllu', 'model_anno_obj'),
        'dep.untyped': ('dependency_conllu', 'model_anno_obj'),  # default untyped dependency
        'dep': ('dependency_typed_conllu', 'model_anno_obj'),  # default typed dependency
        'dep.typed': ('dependency_typed_conllu', 'model_anno_obj'),  # default typed dependency dataset
        'dep.typed.conllu': ('dependency_typed_conllu', 'model_anno_obj'),
        'stopwords': ('stopwords_en', 'model_anno_obj'),

        # embeddings models
        'embed': ('glove_100d', 'model_anno_obj'),  # default overall embed
        'glove': ('glove_100d', 'model_anno_obj'),  # default glove
        'embed.glove': ('glove_100d', 'model_anno_obj'),  # default glove en
        'embed.glove.100d': ('glove_100d', 'model_anno_obj'),
        'bert': ('small_bert_L2_128', 'model_anno_obj'),  # default bert
        'covidbert': ('covidbert_large_uncased', 'model_anno_obj'),

        'embed.bert': ('bert_base_uncased', 'model_anno_obj'),  # default bert
        'embed.bert_base_uncased': ('bert_base_uncased', 'model_anno_obj'),
        'embed.bert_base_cased': ('bert_base_cased', 'model_anno_obj'),
        'embed.bert_large_uncased': ('bert_large_uncased', 'model_anno_obj'),
        'embed.bert_large_cased': ('bert_large_cased', 'model_anno_obj'),
        'biobert': ('biobert_pubmed_base_cased', 'model_anno_obj'),  # alias
        'embed.biobert': ('biobert_pubmed_base_cased', 'model_anno_obj'),  # default bio bert
        'embed.biobert_pubmed_base_cased': ('biobert_pubmed_base_cased', 'model_anno_obj'),
        'embed.biobert_pubmed_large_cased': ('biobert_pubmed_large_cased', 'model_anno_obj'),
        'embed.biobert_pmc_base_cased': ('biobert_pmc_base_cased', 'model_anno_obj'),
        'embed.biobert_pubmed_pmc_base_cased': ('biobert_pubmed_pmc_base_cased', 'model_anno_obj'),
        'embed.biobert_clinical_base_cased': ('biobert_clinical_base_cased', 'model_anno_obj'),
        'embed.biobert_discharge_base_cased': ('biobert_discharge_base_cased', 'model_anno_obj'),
        'elmo': ('elmo', 'model_anno_obj'),

        'embed.electra': ('electra_small_uncased', 'model_anno_obj'),
        'electra': ('electra_small_uncased', 'model_anno_obj'),
        'e2e': ('multiclassifierdl_use_e2e', 'model_anno_obj'),

        'embed.elmo': ('elmo', 'model_anno_obj'),
        'embed_sentence': ('tfhub_use', 'model_anno_obj'),  # default use
        'embed_sentence.small_bert_L2_128': ('sent_small_bert_L2_128', 'model_anno_obj'),
        'embed_sentence.bert': ('sent_small_bert_L2_128', 'model_anno_obj'),
        'embed_sentence.electra': ('sent_electra_small_uncased', 'model_anno_obj'),

        'embed_sentence.use': ('tfhub_use', 'model_anno_obj'),  # default use
        'use': ('tfhub_use', 'model_anno_obj'),  # alias
        'embed_sentence.tfhub_use': ('tfhub_use', 'model_anno_obj'),
        'embed_sentence.use_lg': ('tfhub_use_lg', 'model_anno_obj'),  # alias
        'embed_sentence.tfhub_use_lg': ('tfhub_use_lg', 'model_anno_obj'),
        'albert': ('albert_base_uncased', 'model_anno_obj'),  # albert alias en
        'embed.albert_base_uncased': ('albert_base_uncased', 'model_anno_obj'),
        'embed.albert_large_uncased': ('albert_large_uncased', 'model_anno_obj'),
        'embed.albert_xlarge_uncased': ('albert_xlarge_uncased', 'model_anno_obj'),
        'embed.albert_xxlarge_uncased': ('albert_xxlarge_uncased', 'model_anno_obj'),
        'embed.xlnet': ('xlnet_base_cased', 'model_anno_obj'),  # xlnet default en
        'xlnet': ('xlnet_base_cased', 'model_anno_obj'),  # xlnet alias
        'embed.xlnet_base_cased': ('xlnet_base_cased', 'model_anno_obj'),
        'embed.xlnet_large_cased': ('xlnet_large_cased', 'model_anno_obj'),

        # classifiers and sentiment models
        'classify.trec6.use': ('classifierdl_use_trec6', 'model_anno_obj'),
        'classify.trec50.use': ('classifierdl_use_trec50', 'model_anno_obj'),
        'classify.questions': ('classifierdl_use_trec50', 'model_anno_obj'),
        'questions': ('classifierdl_use_trec50', 'model_anno_obj'),

        'classify.spam.use': ('classifierdl_use_spam', 'model_anno_obj'),
        'classify.fakenews.use': ('classifierdl_use_fakenews', 'model_anno_obj'),
        'classify.emotion.use': ('classifierdl_use_emotion', 'model_anno_obj'),
        'classify.cyberbullying.use': ('classifierdl_use_cyberbullying', 'model_anno_obj'),
        'classify.sarcasm.use': ('classifierdl_use_sarcasm', 'model_anno_obj'),
        'sentiment.imdb.glove': ('sentimentdl_glove_imdb', 'model_anno_obj'),
        'classify.trec6': ('classifierdl_use_trec6', 'model_anno_obj'),  # Alias withouth embedding
        'classify.trec50': ('classifierdl_use_trec50', 'model_anno_obj'),  # Alias withouth embedding
        'classify.spam': ('classifierdl_use_spam', 'model_anno_obj'),  # Alias withouth embedding
        'spam': ('classifierdl_use_spam', 'model_anno_obj'),  # Alias withouth embedding
        'toxic': ('multiclassifierdl_use_toxic', 'model_anno_obj'),

        'classify.fakenews': ('classifierdl_use_fakenews', 'model_anno_obj'),  # Alias withouth embedding
        'classify.emotion': ('classifierdl_use_emotion', 'model_anno_obj'),  # Alias withouth embedding
        'classify.cyberbullying': ('classifierdl_use_cyberbullying', 'model_anno_obj'),  # Alias withouth embedding
        'cyberbullying': ('classifierdl_use_cyberbullying', 'model_anno_obj'),  # Alias withouth embedding

        'classify.sarcasm': ('classifierdl_use_sarcasm', 'model_anno_obj'),  # Alias withouth embedding
        'sarcasm': ('classifierdl_use_sarcasm', 'model_anno_obj'),  # Alias withouth embedding

        'embed.glove.840B_300': ('glove_840B_300', 'model_anno_obj'),
        'yake': ('yake', 'model_anno_obj'),

        # # 2.7.0 new aliases
        't5': ('t5_base', 'model_anno_obj'),
        'summarize': ('t5_base', 'model_anno_obj', {'setTask': '"summarize: "'}),
        'grammar_correctness': ('t5_base', 'model_anno_obj', {'setTask': '"cola sentence: "'}),
        'answer_question': ('t5_base', 'model_anno_obj', {'setTask': '"question: "'}),
        'classify.sentiment_t5': ('t5_base', 'model_anno_obj', {'setTask': '"sst2 sentence: "'}),

    }
    # multi lang models
    pretrained_pipe_references = {

        'da': {
            'da.explain': 'explain_document_sm',
            'da.explain.sm': 'explain_document_sm',
            'da.explain.md': 'explain_document_md',
            'da.explain.lg': 'explain_document_lg',
            'da.ner': 'entity_recognizer_sm',
            'da.ner.sm': 'entity_recognizer_sm',
            'da.ner.md': 'entity_recognizer_md',
            'da.ner.lg': 'entity_recognizer_lg'},

        'nl': {
            'nl.explain': 'explain_document_sm',  # default
            'nl.explain.sm': 'explain_document_sm',
            'nl.explain.md': 'explain_document_md',
            'nl.explain.lg': 'explain_document_lg',
            'nl.ner': 'entity_recognizer_sm',
            # default,calling it nl.ner this makes creating actual NER object impossible!
            'nl.ner.sm': 'entity_recognizer_sm',
            'nl.ner.md': 'entity_recognizer_md',
            'nl.ner.lg': 'entity_recognizer_lg',
        },
        'en': {

            'en.classify': 'analyze_sentiment',  # default classifier
            'en.explain': 'explain_document_ml',  # default explain
            'en.explain.ml': 'explain_document_ml',
            'en.explain.dl': 'explain_document_dl',
            'en.ner': 'recognize_entities_dl',  # default ner
            'en.ner.conll': 'recognize_entities_dl',  # default ner

            'en.ner.dl': 'recognize_entities_dl',
            'en.ner.bert': 'recognize_entities_bert',
            # 'en.ner.onto': 'onto_recognize_entities_sm',  # default  ner.onto
            'en.ner.onto.sm': 'onto_recognize_entities_sm',
            'en.ner.onto.lg': 'onto_recognize_entities_lg',
            # 'en.match.datetime': 'match_datetime',
            'en.match.chunks': 'match_chunks',
            'en.clean.stop': 'clean_stop',
            # 'en.clean.pattern': 'clean_pattern',
            'en.clean.slang': 'clean_slang',
            'en.spell': 'check_spelling_dl',  # dfault spell

            'en.spell.dl': 'check_spelling_dl',
            'en.spell.context': 'check_spelling_dl',
            'en.sentiment': 'analyze_sentiment',
            'en.classify.sentiment': 'analyze_sentiment',

            'en.sentiment.imdb': 'analyze_sentimentdl_use_imdb',
            'en.sentiment.imdb.use': 'analyze_sentimentdl_use_imdb',
            # 'en.sentiment.twitter.use': 'analyze_sentimentdl_use_twitter',
            'en.sentiment.twitter': 'analyze_sentimentdl_use_twitter',
            # 'en.dependency': 'dependency_parse',

            # 2.7
            'en.ner.onto.bert.base': 'onto_recognize_entities_bert_base',
            'en.ner.onto.bert.large': 'onto_recognize_entities_bert_large',
            'en.ner.onto.bert.medium': 'onto_recognize_entities_bert_medium',
            'en.ner.onto.bert.mini': 'onto_recognize_entities_bert_mini',
            'en.ner.onto.bert.small': 'onto_recognize_entities_bert_small',
            'en.ner.onto.bert.tiny': 'onto_recognize_entities_bert_tiny',
            'en.ner.onto.electra.base': 'onto_recognize_entities_electra_base',
            'en.ner.onto.electra.small': 'onto_recognize_entities_electra_small',

            # 2.7.1 and 2.7.2
            "en.sentiment.glove": "analyze_sentimentdl_glove_imdb",
            "en.sentiment.glove.imdb": "analyze_sentimentdl_glove_imdb",
            "en.classify.sentiment.glove.imdb": "analyze_sentimentdl_glove_imdb",
            "en.classify.sentiment.glove": "analyze_sentimentdl_glove_imdb",
            "en.classify.trec50.component_list": "classifierdl_use_trec50_pipeline",
            "en.ner.onto.large": "onto_recognize_entities_electra_large",

        },
        'fa': {
            'fa.ner.dl': 'recognize_entities_dl',
        },
        'he': {
            'he.explain_document': 'explain_document_lg',
            'he.explain_document.lg': 'explain_document_lg',
        },
        'ko': {
            'ko.explain_document': 'explain_document_lg',
            'ko.explain_document.lg': 'explain_document_lg',

        },
        'sv': {
            'sv.explain': 'explain_document_sm',
            'sv.explain.sm': 'explain_document_sm',
            'sv.explain.md': 'explain_document_md',
            'sv.explain.lg': 'explain_document_lg',
            'sv.ner': 'entity_recognizer_sm',
            'sv.ner.sm': 'entity_recognizer_sm',
            'sv.ner.md': 'entity_recognizer_md',
            'sv.ner.lg': 'entity_recognizer_lg'},

        'fi': {
            'fi.explain': 'explain_document_sm',
            'fi.explain.sm': 'explain_document_sm',
            'fi.explain.md': 'explain_document_md',
            'fi.explain.lg': 'explain_document_lg',
            'fi.ner': 'entity_recognizer_sm',
            'fi.ner.sm': 'entity_recognizer_sm',
            'fi.ner.md': 'entity_recognizer_md',
            'fi.ner.lg': 'entity_recognizer_lg'},

        'fr': {
            'fr.explain': 'explain_document_lg',  # default fr explain
            'fr.explain.lg': 'explain_document_lg',
            'fr.explain.md': 'explain_document_md',
            'fr.ner': 'entity_recognizer_lg',  # default fr ner component_list
            'fr.ner.lg': 'entity_recognizer_lg',
            'fr.ner.md': 'entity_recognizer_md',
        },
        'de': {
            'de.explain.document': 'explain_document_md',  # default de explain
            'de.explain.document.md': 'explain_document_md',
            'de.explain.document.lg': 'explain_document_lg',
            'de.ner.recognizer': 'entity_recognizer_md',  # default de ner
            'de.ner.recognizer.md': 'entity_recognizer_md',
            'de.ner.recognizer.lg': 'entity_recognizer_lg',
        },
        'it': {
            'it.explain.document': 'explain_document_md',  # it default explain
            'it.explain.document.md': 'explain_document_md',
            'it.explain.document.lg': 'explain_document_lg',
            'it.ner': 'entity_recognizer_md',  # it default ner
            'it.ner.md': 'entity_recognizer_md',
            'it.ner.lg': 'entity_recognizer_lg',

        },
        'no': {
            'no.explain': 'explain_document_sm',  # default no explain
            'no.explain.sm': 'explain_document_sm',
            'no.explain.md': 'explain_document_md',
            'no.explain.lg': 'explain_document_lg',
            'no.ner': 'entity_recognizer_sm',  # default no ner
            'no.ner.sm': 'entity_recognizer_sm',
            'no.ner.md': 'entity_recognizer_md',
            'no.ner.lg': 'entity_recognizer_lg',
        },
        'pl': {
            'pl.explain': 'explain_document_sm',  # defaul pl explain
            'pl.explain.sm': 'explain_document_sm',
            'pl.explain.md': 'explain_document_md',
            'pl.explain.lg': 'explain_document_lg',
            'pl.ner': 'entity_recognizer_sm',  # default pl ner
            'pl.ner.sm': 'entity_recognizer_sm',
            'pl.ner.md': 'entity_recognizer_md',
            'pl.ner.lg': 'entity_recognizer_lg',
        },
        'pt': {
            'pt.explain': 'explain_document_sm',  # default explain pt
            'pt.explain.sm': 'explain_document_sm',
            'pt.explain.md': 'explain_document_md',
            'pt.explain.lg': 'explain_document_lg',
            'pt.ner': 'entity_recognizer_sm',  # default ner pt
            'pt.ner.sm': 'entity_recognizer_sm',
            'pt.ner.md': 'entity_recognizer_md',
            'pt.ner.lg': 'entity_recognizer_lg',

        },
        'ru': {
            'ru.explain': 'explain_document_sm',  # default ru explain
            'ru.explain.sm': 'explain_document_sm',
            'ru.explain.md': 'explain_document_md',
            'ru.explain.lg': 'explain_document_lg',
            'ru.ner': 'entity_recognizer_sm',  # default ru ner
            'ru.ner.sm': 'entity_recognizer_sm',
            'ru.ner.md': 'entity_recognizer_md',
            'ru.ner.lg': 'entity_recognizer_lg',
        },
        'es': {
            'es.explain': 'explain_document_sm',  # es expplain deflaut
            'es.explain.sm': 'explain_document_sm',
            'es.explain.md': 'explain_document_md',
            'es.explain.lg': 'explain_document_lg',
            'es.ner': 'entity_recognizer_sm',  # es ner default
            'es.ner.sm': 'entity_recognizer_sm',
            'es.ner.md': 'entity_recognizer_md',
            'es.ner.lg': 'entity_recognizer_lg',
        },
        'xx': {
            'lang': 'detect_language_375',  # default lang classifer
            'lang.7': 'detect_language_7',  # multi lang detector alias
            'lang.20': 'detect_language_20',  # multi lang detector alias
            'xx.classify.lang.20': 'detect_language_20',  # multi lang detector default
            'xx.classify.lang.7': 'detect_language_7',

            # 2.7 lang classifiers

            'xx.classify.lang': 'detect_language_375',  # default lang classifer
            'xx.classify.lang.21': 'detect_language_21',
            'xx.classify.lang.43': 'detect_language_43',
            'xx.classify.lang.95': 'detect_language_95',
            'xx.classify.lang.99': 'detect_language_99',
            'xx.classify.lang.220': 'detect_language_220',
            'xx.classify.lang.231': 'detect_language_231',
            'xx.classify.lang.bigru': 'detect_language_bigru_21',
            'lang.21': 'detect_language_21',
            'lang.43': 'detect_language_43',
            'lang.95': 'detect_language_95',
            'lang.99': 'detect_language_99',
            'lang.220': 'detect_language_220',
            'lang.231': 'detect_language_231',
            'lang.bigru': 'detect_language_bigru_21',

            # 2.7 marian translate component_list references
            "xx.zlw.translate_to.en": "translate_zlw_en",
            "xx.en.translate_to.ti": "translate_en_ti",
            "xx.bem.translate_to.en": "translate_bem_en",
            "xx.ny.translate_to.en": "translate_ny_en",
            "xx.en.translate_to.lu": "translate_en_lu",
            "xx.taw.translate_to.en": "translate_taw_en",
            "xx.en.translate_to.ga": "translate_en_ga",
            "xx.en.translate_to.sw": "translate_en_sw",
            "xx.war.translate_to.en": "translate_war_en",
            "xx.en.translate_to.hu": "translate_en_hu",
            "xx.pqe.translate_to.en": "translate_pqe_en",
            "xx.en.translate_to.bem": "translate_en_bem",
            "xx.en.translate_to.tiv": "translate_en_tiv",
            "xx.en.translate_to.tll": "translate_en_tll",
            "xx.en.translate_to.cpp": "translate_en_cpp",
            "xx.efi.translate_to.en": "translate_efi_en",
            "xx.en.translate_to.itc": "translate_en_itc",
            "xx.uk.translate_to.en": "translate_uk_en",
            "xx.ee.translate_to.en": "translate_ee_en",
            "xx.nso.translate_to.en": "translate_nso_en",
            "xx.urj.translate_to.en": "translate_urj_en",
            "xx.sv.translate_to.en": "translate_sv_en",
            "xx.en.translate_to.rn": "translate_en_rn",
            "xx.nic.translate_to.en": "translate_nic_en",
            "xx.en.translate_to.bcl": "translate_en_bcl",
            "xx.en.translate_to.lg": "translate_en_lg",
            "xx.kwy.translate_to.en": "translate_kwy_en",
            "xx.en.translate_to.gmq": "translate_en_gmq",
            "xx.en.translate_to.ts": "translate_en_ts",
            "xx.bnt.translate_to.en": "translate_bnt_en",
            "xx.en.translate_to.pis": "translate_en_pis",
            "xx.kwn.translate_to.en": "translate_kwn_en",
            "xx.fi.translate_to.en": "translate_fi_en",
            "xx.en.translate_to.gaa": "translate_en_gaa",
            "xx.afa.translate_to.en": "translate_afa_en",
            "xx.itc.translate_to.en": "translate_itc_en",
            "xx.mh.translate_to.en": "translate_mh_en",
            "xx.en.translate_to.ln": "translate_en_ln",
            "xx.en.translate_to.zls": "translate_en_zls",
            "xx.en.translate_to.cy": "translate_en_cy",
            "xx.et.translate_to.en": "translate_et_en",
            "xx.en.translate_to.dra": "translate_en_dra",
            "xx.en.translate_to.sn": "translate_en_sn",
            "xx.lua.translate_to.en": "translate_lua_en",
            "xx.ln.translate_to.en": "translate_ln_en",
            "xx.ja.translate_to.en": "translate_ja_en",
            "xx.loz.translate_to.en": "translate_loz_en",
            "xx.en.translate_to.bi": "translate_en_bi",
            "xx.mg.translate_to.en": "translate_mg_en",
            "xx.vi.translate_to.en": "translate_vi_en",
            "xx.en.translate_to.vi": "translate_en_vi",
            "xx.hy.translate_to.en": "translate_hy_en",
            "xx.en.translate_to.mt": "translate_en_mt",
            "xx.ng.translate_to.en": "translate_ng_en",
            "xx.mkh.translate_to.en": "translate_mkh_en",
            "xx.en.translate_to.cpf": "translate_en_cpf",
            "xx.wal.translate_to.en": "translate_wal_en",
            "xx.en.translate_to.crs": "translate_en_crs",
            "xx.en.translate_to.zle": "translate_en_zle",
            "xx.en.translate_to.phi": "translate_en_phi",
            "xx.ine.translate_to.en": "translate_ine_en",
            "xx.en.translate_to.pap": "translate_en_pap",
            "xx.en.translate_to.sit": "translate_en_sit",
            "xx.bg.translate_to.en": "translate_bg_en",
            "xx.en.translate_to.ml": "translate_en_ml",
            "xx.en.translate_to.ss": "translate_en_ss",
            "xx.en.translate_to.tw": "translate_en_tw",
            "xx.en.translate_to.gv": "translate_en_gv",
            "xx.ca.translate_to.en": "translate_ca_en",
            "xx.umb.translate_to.en": "translate_umb_en",
            "xx.alv.translate_to.en": "translate_alv_en",
            "xx.gem.translate_to.en": "translate_gem_en",
            "xx.chk.translate_to.en": "translate_chk_en",
            "xx.kqn.translate_to.en": "translate_kqn_en",
            "xx.en.translate_to.afa": "translate_en_afa",
            "xx.gl.translate_to.en": "translate_gl_en",
            "xx.en.translate_to.ber": "translate_en_ber",
            "xx.en.translate_to.ig": "translate_en_ig",
            "xx.ase.translate_to.en": "translate_ase_en",
            "xx.en.translate_to.cs": "translate_en_cs",
            "xx.en.translate_to.pag": "translate_en_pag",
            "xx.en.translate_to.nic": "translate_en_nic",
            "xx.en.translate_to.hil": "translate_en_hil",
            "xx.en.translate_to.cel": "translate_en_cel",
            "xx.nl.translate_to.en": "translate_nl_en",
            "xx.en.translate_to.ho": "translate_en_ho",
            "xx.en.translate_to.inc": "translate_en_inc",
            "xx.ts.translate_to.en": "translate_ts_en",
            "xx.en.translate_to.tl": "translate_en_tl",
            "xx.ve.translate_to.en": "translate_ve_en",
            "xx.ceb.translate_to.en": "translate_ceb_en",
            "xx.en.translate_to.iir": "translate_en_iir",
            "xx.en.translate_to.aav": "translate_en_aav",
            "xx.en.translate_to.bat": "translate_en_bat",
            "xx.en.translate_to.alv": "translate_en_alv",
            "xx.ar.translate_to.en": "translate_ar_en",
            "xx.fiu.translate_to.en": "translate_fiu_en",
            "xx.en.translate_to.eu": "translate_en_eu",
            "xx.is.translate_to.en": "translate_is_en",
            "xx.wa.translate_to.en": "translate_wa_en",
            "xx.en.translate_to.tn": "translate_en_tn",
            "xx.ig.translate_to.en": "translate_ig_en",
            "xx.luo.translate_to.en": "translate_luo_en",
            "xx.en.translate_to.kwn": "translate_en_kwn",
            "xx.niu.translate_to.en": "translate_niu_en",
            "xx.en.translate_to.gl": "translate_en_gl",
            "xx.en.translate_to.ilo": "translate_en_ilo",
            "xx.en.translate_to.ur": "translate_en_ur",
            "xx.cus.translate_to.en": "translate_cus_en",
            "xx.phi.translate_to.en": "translate_phi_en",
            "xx.en.translate_to.loz": "translate_en_loz",
            "xx.tiv.translate_to.en": "translate_tiv_en",
            "xx.en.translate_to.id": "translate_en_id",
            "xx.zle.translate_to.en": "translate_zle_en",
            "xx.en.translate_to.mfe": "translate_en_mfe",
            "xx.id.translate_to.en": "translate_id_en",
            "xx.lv.translate_to.en": "translate_lv_en",
            "xx.en.translate_to.pon": "translate_en_pon",
            "xx.en.translate_to.sq": "translate_en_sq",
            "xx.tum.translate_to.en": "translate_tum_en",
            "xx.pl.translate_to.en": "translate_pl_en",
            "xx.xh.translate_to.en": "translate_xh_en",
            "xx.kab.translate_to.en": "translate_kab_en",
            "xx.tvl.translate_to.en": "translate_tvl_en",
            "xx.pa.translate_to.en": "translate_pa_en",
            "xx.iso.translate_to.en": "translate_iso_en",
            "xx.ho.translate_to.en": "translate_ho_en",
            "xx.cel.translate_to.en": "translate_cel_en",
            "xx.en.translate_to.om": "translate_en_om",
            "xx.kg.translate_to.en": "translate_kg_en",
            "xx.en.translate_to.lus": "translate_en_lus",
            "xx.om.translate_to.en": "translate_om_en",
            "xx.lun.translate_to.en": "translate_lun_en",
            "xx.crs.translate_to.en": "translate_crs_en",
            "xx.cy.translate_to.en": "translate_cy_en",
            "xx.tll.translate_to.en": "translate_tll_en",
            "xx.gil.translate_to.en": "translate_gil_en",
            "xx.en.translate_to.mkh": "translate_en_mkh",
            "xx.en.translate_to.euq": "translate_en_euq",
            "xx.en.translate_to.sem": "translate_en_sem",
            "xx.cs.translate_to.en": "translate_cs_en",
            "xx.en.translate_to.sk": "translate_en_sk",
            "xx.en.translate_to.bzs": "translate_en_bzs",
            "xx.en.translate_to.trk": "translate_en_trk",
            "xx.cpf.translate_to.en": "translate_cpf_en",
            "xx.bi.translate_to.en": "translate_bi_en",
            "xx.en.translate_to.mul": "translate_en_mul",
            "xx.en.translate_to.gmw": "translate_en_gmw",
            "xx.en.translate_to.fi": "translate_en_fi",
            "xx.en.translate_to.zlw": "translate_en_zlw",
            "xx.lg.translate_to.en": "translate_lg_en",
            "xx.en.translate_to.pqe": "translate_en_pqe",
            "xx.en.translate_to.xh": "translate_en_xh",
            "xx.en.translate_to.hi": "translate_en_hi",
            "xx.en.translate_to.nyk": "translate_en_nyk",
            "xx.th.translate_to.en": "translate_th_en",
            "xx.en.translate_to.umb": "translate_en_umb",
            "xx.en.translate_to.af": "translate_en_af",
            "xx.tpi.translate_to.en": "translate_tpi_en",
            "xx.ti.translate_to.en": "translate_ti_en",
            "xx.en.translate_to.chk": "translate_en_chk",
            "xx.mos.translate_to.en": "translate_mos_en",
            "xx.en.translate_to.sm": "translate_en_sm",
            "xx.pon.translate_to.en": "translate_pon_en",
            "xx.en.translate_to.bg": "translate_en_bg",
            "xx.en.translate_to.ny": "translate_en_ny",
            "xx.kl.translate_to.en": "translate_kl_en",
            "xx.en.translate_to.hy": "translate_en_hy",
            "xx.nyk.translate_to.en": "translate_nyk_en",
            "xx.it.translate_to.en": "translate_it_en",
            "xx.mt.translate_to.en": "translate_mt_en",
            "xx.pap.translate_to.en": "translate_pap_en",
            "xx.srn.translate_to.en": "translate_srn_en",
            "xx.da.translate_to.en": "translate_da_en",
            "xx.en.translate_to.lue": "translate_en_lue",
            "xx.rn.translate_to.en": "translate_rn_en",
            "xx.en.translate_to.tut": "translate_en_tut",
            "xx.lu.translate_to.en": "translate_lu_en",
            "xx.ru.translate_to.en": "translate_ru_en",
            "xx.en.translate_to.toi": "translate_en_toi",
            "xx.ccs.translate_to.en": "translate_ccs_en",
            "xx.aav.translate_to.en": "translate_aav_en",
            "xx.en.translate_to.ha": "translate_en_ha",
            "xx.rnd.translate_to.en": "translate_rnd_en",
            "xx.de.translate_to.en": "translate_de_en",
            "xx.en.translate_to.luo": "translate_en_luo",
            "xx.fr.translate_to.en": "translate_fr_en",
            "xx.bcl.translate_to.en": "translate_bcl_en",
            "xx.ilo.translate_to.en": "translate_ilo_en",
            "xx.en.translate_to.jap": "translate_en_jap",
            "xx.en.translate_to.fj": "translate_en_fj",
            "xx.sk.translate_to.en": "translate_sk_en",
            "xx.bzs.translate_to.en": "translate_bzs_en",
            "xx.ka.translate_to.en": "translate_ka_en",
            "xx.ko.translate_to.en": "translate_ko_en",
            "xx.sq.translate_to.en": "translate_sq_en",
            "xx.mul.translate_to.en": "translate_mul_en",
            "xx.en.translate_to.run": "translate_en_run",
            "xx.sn.translate_to.en": "translate_sn_en",
            "xx.en.translate_to.pqw": "translate_en_pqw",
            "xx.ss.translate_to.en": "translate_ss_en",
            "xx.sm.translate_to.en": "translate_sm_en",
            "xx.en.translate_to.kwy": "translate_en_kwy",
            "xx.jap.translate_to.en": "translate_jap_en",
            "xx.en.translate_to.kqn": "translate_en_kqn",
            "xx.mk.translate_to.en": "translate_mk_en",
            "xx.hu.translate_to.en": "translate_hu_en",
            "xx.en.translate_to.map": "translate_en_map",
            "xx.yo.translate_to.en": "translate_yo_en",
            "xx.hi.translate_to.en": "translate_hi_en",
            "xx.iir.translate_to.en": "translate_iir_en",
            "xx.en.translate_to.guw": "translate_en_guw",
            "xx.en.translate_to.es": "translate_en_es",
            "xx.en.translate_to.gem": "translate_en_gem",
            "xx.en.translate_to.ht": "translate_en_ht",
            "xx.zls.translate_to.en": "translate_zls_en",
            "xx.sg.translate_to.en": "translate_sg_en",
            "xx.en.translate_to.ty": "translate_en_ty",
            "xx.en.translate_to.lun": "translate_en_lun",
            "xx.guw.translate_to.en": "translate_guw_en",
            "xx.trk.translate_to.en": "translate_trk_en",
            "xx.mfe.translate_to.en": "translate_mfe_en",
            "xx.en.translate_to.nl": "translate_en_nl",
            "xx.en.translate_to.sv": "translate_en_sv",
            "xx.ber.translate_to.en": "translate_ber_en",
            "xx.to.translate_to.en": "translate_to_en",
            "xx.en.translate_to.da": "translate_en_da",
            "xx.en.translate_to.urj": "translate_en_urj",
            "xx.inc.translate_to.en": "translate_inc_en",
            "xx.wls.translate_to.en": "translate_wls_en",
            "xx.pis.translate_to.en": "translate_pis_en",
            "xx.en.translate_to.mh": "translate_en_mh",
            "xx.en.translate_to.iso": "translate_en_iso",
            "xx.en.translate_to.ru": "translate_en_ru",
            "xx.swc.translate_to.en": "translate_swc_en",
            "xx.en.translate_to.rnd": "translate_en_rnd",
            "xx.en.translate_to.nso": "translate_en_nso",
            "xx.en.translate_to.swc": "translate_en_swc",
            "xx.ur.translate_to.en": "translate_ur_en",
            "xx.en.translate_to.ro": "translate_en_ro",
            "xx.ml.translate_to.en": "translate_ml_en",
            "xx.grk.translate_to.en": "translate_grk_en",
            "xx.rw.translate_to.en": "translate_rw_en",
            "xx.tr.translate_to.en": "translate_tr_en",
            "xx.gmq.translate_to.en": "translate_gmq_en",
            "xx.euq.translate_to.en": "translate_euq_en",
            "xx.en.translate_to.tdt": "translate_en_tdt",
            "xx.eo.translate_to.en": "translate_eo_en",
            "xx.cau.translate_to.en": "translate_cau_en",
            "xx.en.translate_to.mk": "translate_en_mk",
            "xx.en.translate_to.mr": "translate_en_mr",
            "xx.af.translate_to.en": "translate_af_en",
            "xx.run.translate_to.en": "translate_run_en",
            "xx.en.translate_to.ng": "translate_en_ng",
            "xx.en.translate_to.mg": "translate_en_mg",
            "xx.en.translate_to.bnt": "translate_en_bnt",
            "xx.en.translate_to.kj": "translate_en_kj",
            "xx.en.translate_to.he": "translate_en_he",
            "xx.en.translate_to.sla": "translate_en_sla",
            "xx.en.translate_to.el": "translate_en_el",
            "xx.ht.translate_to.en": "translate_ht_en",
            "xx.en.translate_to.et": "translate_en_et",
            "xx.en.translate_to.poz": "translate_en_poz",
            "xx.roa.translate_to.en": "translate_roa_en",
            "xx.en.translate_to.de": "translate_en_de",
            "xx.fj.translate_to.en": "translate_fj_en",
            "xx.en.translate_to.lua": "translate_en_lua",
            "xx.en.translate_to.kg": "translate_en_kg",
            "xx.en.translate_to.fiu": "translate_en_fiu",
            "xx.gv.translate_to.en": "translate_gv_en",
            "xx.cpp.translate_to.en": "translate_cpp_en",
            "xx.en.translate_to.tpi": "translate_en_tpi",
            "xx.en.translate_to.grk": "translate_en_grk",
            "xx.en.translate_to.sal": "translate_en_sal",
            "xx.en.translate_to.niu": "translate_en_niu",
            "xx.en.translate_to.ca": "translate_en_ca",
            "xx.en.translate_to.roa": "translate_en_roa",
            "xx.sal.translate_to.en": "translate_sal_en",
            "xx.ha.translate_to.en": "translate_ha_en",
            "xx.sem.translate_to.en": "translate_sem_en",
            "xx.tn.translate_to.en": "translate_tn_en",
            "xx.gaa.translate_to.en": "translate_gaa_en",
            "xx.en.translate_to.to": "translate_en_to",
            "xx.en.translate_to.ee": "translate_en_ee",
            "xx.toi.translate_to.en": "translate_toi_en",
            "xx.lue.translate_to.en": "translate_lue_en",
            "xx.en.translate_to.rw": "translate_en_rw",
            "xx.st.translate_to.en": "translate_st_en",
            "xx.dra.translate_to.en": "translate_dra_en",
            "xx.en.translate_to.mos": "translate_en_mos",
            "xx.eu.translate_to.en": "translate_eu_en",
            "xx.lus.translate_to.en": "translate_lus_en",
            "xx.sla.translate_to.en": "translate_sla_en",
            "xx.en.translate_to.ceb": "translate_en_ceb",
            "xx.art.translate_to.en": "translate_art_en",
            "xx.bat.translate_to.en": "translate_bat_en",
            "xx.az.translate_to.en": "translate_az_en",
            "xx.en.translate_to.ine": "translate_en_ine",
            "xx.pag.translate_to.en": "translate_pag_en",
            "xx.yap.translate_to.en": "translate_yap_en",
            "xx.en.translate_to.eo": "translate_en_eo",
            "xx.en.translate_to.tvl": "translate_en_tvl",
            "xx.kj.translate_to.en": "translate_kj_en",
            "xx.en.translate_to.st": "translate_en_st",
            "xx.gmw.translate_to.en": "translate_gmw_en",
            "xx.mr.translate_to.en": "translate_mr_en",
            "xx.es.translate_to.en": "translate_es_en",
            "xx.en.translate_to.sg": "translate_en_sg",
            "xx.en.translate_to.cus": "translate_en_cus",
            "xx.en.translate_to.it": "translate_en_it",
            "xx.ga.translate_to.en": "translate_ga_en",
            "xx.bn.translate_to.en": "translate_bn_en",
            "xx.en.translate_to.efi": "translate_en_efi",
            "xx.en.translate_to.az": "translate_en_az",
            "xx.en.translate_to.zh": "translate_en_zh",
            "xx.en.translate_to.is": "translate_en_is",
            "xx.zh.translate_to.en": "translate_zh_en",
            "xx.hil.translate_to.en": "translate_hil_en",
            "xx.en.translate_to.ar": "translate_en_ar",
            "xx.tl.translate_to.en": "translate_tl_en",
            "xx.en.translate_to.gil": "translate_en_gil",
            "xx.en.translate_to.uk": "translate_en_uk",
            "xx.en.translate_to.fr": "translate_en_fr",
            # 3.1 Translator Pipe references

            "xx.es.translate_to.af": "translate_af_es",
            "xx.nl.translate_to.af": "translate_af_nl",
            "xx.eo.translate_to.af": "translate_af_eo",
            "xx.afa.translate_to.afa": "translate_afa_afa",
            "xx.sv.translate_to.af": "translate_af_sv",
            "xx.es.translate_to.aed": "translate_aed_es",
            "xx.fr.translate_to.af": "translate_af_fr",
            "xx.fi.translate_to.af": "translate_af_fi",
            "xx.de.translate_to.af": "translate_af_de",
            "xx.ru.translate_to.af": "translate_af_ru",
            "xx.es.translate_to.az": "translate_az_es",
            "xx.de.translate_to.bcl": "translate_bcl_de",
            "xx.sv.translate_to.bem": "translate_bem_sv",
            "xx.tr.translate_to.az": "translate_az_tr",
            "xx.sv.translate_to.bcl": "translate_bcl_sv",
            "xx.es.translate_to.ar": "translate_ar_es",
            "xx.es.translate_to.bem": "translate_bem_es",
            "xx.ru.translate_to.ar": "translate_ar_ru",
            "xx.es.translate_to.be": "translate_be_es",
            "xx.fr.translate_to.bem": "translate_bem_fr",
            "xx.he.translate_to.ar": "translate_ar_he",
            "xx.es.translate_to.bcl": "translate_bcl_es",
            "xx.es.translate_to.ase": "translate_ase_es",
            "xx.de.translate_to.ar": "translate_ar_de",
            "xx.pl.translate_to.ar": "translate_ar_pl",
            "xx.tr.translate_to.ar": "translate_ar_tr",
            "xx.sv.translate_to.ase": "translate_ase_sv",
            "xx.fi.translate_to.bcl": "translate_bcl_fi",
            "xx.el.translate_to.ar": "translate_ar_el",
            "xx.fr.translate_to.bcl": "translate_bcl_fr",
            "xx.fi.translate_to.bem": "translate_bem_fi",
            "xx.fr.translate_to.ase": "translate_ase_fr",
            "xx.fr.translate_to.ar": "translate_ar_fr",
            "xx.eo.translate_to.ar": "translate_ar_eo",
            "xx.it.translate_to.ar": "translate_ar_it",
            "xx.sv.translate_to.am": "translate_am_sv",
            "xx.de.translate_to.ase": "translate_ase_de",
            "xx.uk.translate_to.bg": "translate_bg_uk",
            "xx.it.translate_to.bg": "translate_bg_it",
            "xx.sv.translate_to.bzs": "translate_bzs_sv",
            "xx.pt.translate_to.ca": "translate_ca_pt",
            "xx.es.translate_to.ber": "translate_ber_es",
            "xx.it.translate_to.ca": "translate_ca_it",
            "xx.eo.translate_to.bg": "translate_bg_eo",
            "xx.sv.translate_to.ceb": "translate_ceb_sv",
            "xx.fr.translate_to.bi": "translate_bi_fr",
            "xx.sv.translate_to.bg": "translate_bg_sv",
            "xx.fr.translate_to.ca": "translate_ca_fr",
            "xx.tr.translate_to.bg": "translate_bg_tr",
            "xx.es.translate_to.ceb": "translate_ceb_es",
            "xx.de.translate_to.ca": "translate_ca_de",
            "xx.fi.translate_to.ceb": "translate_ceb_fi",
            "xx.es.translate_to.ca": "translate_ca_es",
            "xx.es.translate_to.bg": "translate_bg_es",
            "xx.uk.translate_to.ca": "translate_ca_uk",
            "xx.sv.translate_to.bi": "translate_bi_sv",
            "xx.sv.translate_to.chk": "translate_chk_sv",
            "xx.fr.translate_to.ceb": "translate_ceb_fr",
            "xx.es.translate_to.bzs": "translate_bzs_es",
            "xx.de.translate_to.crs": "translate_crs_de",
            "xx.nl.translate_to.ca": "translate_ca_nl",
            "xx.es.translate_to.chk": "translate_chk_es",
            "xx.fr.translate_to.ber": "translate_ber_fr",
            "xx.fi.translate_to.bzs": "translate_bzs_fi",
            "xx.es.translate_to.crs": "translate_crs_es",
            "xx.fi.translate_to.bg": "translate_bg_fi",
            "xx.cpp.translate_to.cpp": "translate_cpp_cpp",
            "xx.de.translate_to.bg": "translate_bg_de",
            "xx.es.translate_to.bi": "translate_bi_es",
            "xx.fr.translate_to.bzs": "translate_bzs_fr",
            "xx.fr.translate_to.bg": "translate_bg_fr",
            "xx.fr.translate_to.chk": "translate_chk_fr",
            "xx.ru.translate_to.bg": "translate_bg_ru",
            "xx.fi.translate_to.cs": "translate_cs_fi",
            "xx.ha.translate_to.de": "translate_de_ha",
            "xx.ee.translate_to.de": "translate_de_ee",
            "xx.eo.translate_to.de": "translate_de_eo",
            "xx.gil.translate_to.de": "translate_de_gil",
            "xx.fj.translate_to.de": "translate_de_fj",
            "xx.fr.translate_to.de": "translate_de_fr",
            "xx.sv.translate_to.cs": "translate_cs_sv",
            "xx.es.translate_to.csn": "translate_csn_es",
            "xx.ru.translate_to.da": "translate_da_ru",
            "xx.no.translate_to.da": "translate_da_no",
            "xx.iso.translate_to.de": "translate_de_iso",
            "xx.eu.translate_to.de": "translate_de_eu",
            "xx.nl.translate_to.de": "translate_de_nl",
            "xx.ilo.translate_to.de": "translate_de_ilo",
            "xx.hr.translate_to.de": "translate_de_hr",
            "xx.mt.translate_to.de": "translate_de_mt",
            "xx.es.translate_to.da": "translate_da_es",
            "xx.ar.translate_to.de": "translate_de_ar",
            "xx.is.translate_to.de": "translate_de_is",
            "xx.sv.translate_to.crs": "translate_crs_sv",
            "xx.fr.translate_to.da": "translate_da_fr",
            "xx.gaa.translate_to.de": "translate_de_gaa",
            "xx.niu.translate_to.de": "translate_de_niu",
            "xx.da.translate_to.de": "translate_de_da",
            "xx.de.translate_to.da": "translate_da_de",
            "xx.ase.translate_to.de": "translate_de_ase",
            "xx.ig.translate_to.de": "translate_de_ig",
            "xx.lua.translate_to.de": "translate_de_lua",
            "xx.de.translate_to.de": "translate_de_de",
            "xx.bi.translate_to.de": "translate_de_bi",
            "xx.fr.translate_to.cs": "translate_cs_fr",
            "xx.ms.translate_to.de": "translate_de_ms",
            "xx.fi.translate_to.crs": "translate_crs_fi",
            "xx.eo.translate_to.da": "translate_da_eo",
            "xx.af.translate_to.de": "translate_de_af",
            "xx.uk.translate_to.cs": "translate_cs_uk",
            "xx.bg.translate_to.de": "translate_de_bg",
            "xx.no.translate_to.de": "translate_de_no",
            "xx.de.translate_to.cs": "translate_cs_de",
            "xx.it.translate_to.de": "translate_de_it",
            "xx.ho.translate_to.de": "translate_de_ho",
            "xx.ln.translate_to.de": "translate_de_ln",
            "xx.guw.translate_to.de": "translate_de_guw",
            "xx.efi.translate_to.de": "translate_de_efi",
            "xx.hil.translate_to.de": "translate_de_hil",
            "xx.cs.translate_to.de": "translate_de_cs",
            "xx.es.translate_to.csg": "translate_csg_es",
            "xx.es.translate_to.de": "translate_de_es",
            "xx.bcl.translate_to.de": "translate_de_bcl",
            "xx.ht.translate_to.de": "translate_de_ht",
            "xx.loz.translate_to.de": "translate_de_loz",
            "xx.kg.translate_to.de": "translate_de_kg",
            "xx.eo.translate_to.cs": "translate_cs_eo",
            "xx.el.translate_to.de": "translate_de_el",
            "xx.fi.translate_to.de": "translate_de_fi",
            "xx.he.translate_to.de": "translate_de_he",
            "xx.bzs.translate_to.de": "translate_de_bzs",
            "xx.fr.translate_to.crs": "translate_crs_fr",
            "xx.crs.translate_to.de": "translate_de_crs",
            "xx.fi.translate_to.da": "translate_da_fi",
            "xx.hu.translate_to.de": "translate_de_hu",
            "xx.et.translate_to.de": "translate_de_et",
            "xx.lt.translate_to.de": "translate_de_lt",
            "xx.ca.translate_to.de": "translate_de_ca",
            "xx.pl.translate_to.de": "translate_de_pl",
            "xx.sv.translate_to.el": "translate_el_sv",
            "xx.de.translate_to.ee": "translate_ee_de",
            "xx.pag.translate_to.de": "translate_de_pag",
            "xx.ar.translate_to.el": "translate_el_ar",
            "xx.nso.translate_to.de": "translate_de_nso",
            "xx.pon.translate_to.de": "translate_de_pon",
            "xx.pap.translate_to.de": "translate_de_pap",
            "xx.fr.translate_to.efi": "translate_efi_fr",
            "xx.pis.translate_to.de": "translate_de_pis",
            "xx.de.translate_to.efi": "translate_efi_de",
            "xx.eo.translate_to.el": "translate_el_eo",
            "xx.fi.translate_to.ee": "translate_ee_fi",
            "xx.es.translate_to.ee": "translate_ee_es",
            "xx.fr.translate_to.ee": "translate_ee_fr",
            "xx.fi.translate_to.efi": "translate_efi_fi",
            "xx.fr.translate_to.el": "translate_el_fr",
            "xx.tl.translate_to.de": "translate_de_tl",
            "xx.ny.translate_to.de": "translate_de_ny",
            "xx.uk.translate_to.de": "translate_de_uk",
            "xx.sv.translate_to.efi": "translate_efi_sv",
            "xx.sv.translate_to.ee": "translate_ee_sv",
            "xx.vi.translate_to.de": "translate_de_vi",
            "xx.fi.translate_to.el": "translate_el_fi",
            "xx.cs.translate_to.eo": "translate_eo_cs",
            "xx.bzs.translate_to.es": "translate_es_bzs",
            "xx.he.translate_to.eo": "translate_eo_he",
            "xx.hu.translate_to.eo": "translate_eo_hu",
            "xx.ro.translate_to.eo": "translate_eo_ro",
            "xx.ber.translate_to.es": "translate_es_ber",
            "xx.ca.translate_to.es": "translate_es_ca",
            "xx.bcl.translate_to.es": "translate_es_bcl",
            "xx.ceb.translate_to.es": "translate_es_ceb",
            "xx.da.translate_to.eo": "translate_eo_da",
            "xx.bi.translate_to.es": "translate_es_bi",
            "xx.ee.translate_to.es": "translate_es_ee",
            "xx.ru.translate_to.eo": "translate_eo_ru",
            "xx.csg.translate_to.es": "translate_es_csg",
            "xx.fi.translate_to.eo": "translate_eo_fi",
            "xx.it.translate_to.eo": "translate_eo_it",
            "xx.nl.translate_to.eo": "translate_eo_nl",
            "xx.et.translate_to.es": "translate_es_et",
            "xx.bg.translate_to.es": "translate_es_bg",
            "xx.de.translate_to.eo": "translate_eo_de",
            "xx.ar.translate_to.es": "translate_es_ar",
            "xx.cs.translate_to.es": "translate_es_cs",
            "xx.aed.translate_to.es": "translate_es_aed",
            "xx.ase.translate_to.es": "translate_es_ase",
            "xx.el.translate_to.es": "translate_es_el",
            "xx.eo.translate_to.es": "translate_es_eo",
            "xx.af.translate_to.eo": "translate_eo_af",
            "xx.af.translate_to.es": "translate_es_af",
            "xx.pl.translate_to.eo": "translate_eo_pl",
            "xx.de.translate_to.es": "translate_es_de",
            "xx.es.translate_to.eo": "translate_eo_es",
            "xx.da.translate_to.es": "translate_es_da",
            "xx.crs.translate_to.es": "translate_es_crs",
            "xx.pt.translate_to.eo": "translate_eo_pt",
            "xx.eu.translate_to.es": "translate_es_eu",
            "xx.es.translate_to.es": "translate_es_es",
            "xx.csn.translate_to.es": "translate_es_csn",
            "xx.sv.translate_to.eo": "translate_eo_sv",
            "xx.efi.translate_to.es": "translate_es_efi",
            "xx.sh.translate_to.eo": "translate_eo_sh",
            "xx.bg.translate_to.eo": "translate_eo_bg",
            "xx.fr.translate_to.eo": "translate_eo_fr",
            "xx.el.translate_to.eo": "translate_eo_el",
            "xx.pl.translate_to.es": "translate_es_pl",
            "xx.ro.translate_to.es": "translate_es_ro",
            "xx.is.translate_to.es": "translate_es_is",
            "xx.ln.translate_to.es": "translate_es_ln",
            "xx.to.translate_to.es": "translate_es_to",
            "xx.no.translate_to.es": "translate_es_no",
            "xx.nl.translate_to.es": "translate_es_nl",
            "xx.pag.translate_to.es": "translate_es_pag",
            "xx.tvl.translate_to.es": "translate_es_tvl",
            "xx.fr.translate_to.es": "translate_es_fr",
            "xx.he.translate_to.es": "translate_es_he",
            "xx.lus.translate_to.es": "translate_es_lus",
            "xx.hil.translate_to.es": "translate_es_hil",
            "xx.ny.translate_to.es": "translate_es_ny",
            "xx.pap.translate_to.es": "translate_es_pap",
            "xx.id.translate_to.es": "translate_es_id",
            "xx.wls.translate_to.es": "translate_es_wls",
            "xx.gaa.translate_to.es": "translate_es_gaa",
            "xx.nso.translate_to.es": "translate_es_nso",
            "xx.mk.translate_to.es": "translate_es_mk",
            "xx.mt.translate_to.es": "translate_es_mt",
            "xx.pis.translate_to.es": "translate_es_pis",
            "xx.gl.translate_to.es": "translate_es_gl",
            "xx.sn.translate_to.es": "translate_es_sn",
            "xx.hr.translate_to.es": "translate_es_hr",
            "xx.swc.translate_to.es": "translate_es_swc",
            "xx.lua.translate_to.es": "translate_es_lua",
            "xx.it.translate_to.es": "translate_es_it",
            "xx.fj.translate_to.es": "translate_es_fj",
            "xx.gil.translate_to.es": "translate_es_gil",
            "xx.sm.translate_to.es": "translate_es_sm",
            "xx.guw.translate_to.es": "translate_es_guw",
            "xx.kg.translate_to.es": "translate_es_kg",
            "xx.tl.translate_to.es": "translate_es_tl",
            "xx.rn.translate_to.es": "translate_es_rn",
            "xx.mfs.translate_to.es": "translate_es_mfs",
            "xx.iso.translate_to.es": "translate_es_iso",
            "xx.loz.translate_to.es": "translate_es_loz",
            "xx.tpi.translate_to.es": "translate_es_tpi",
            "xx.ha.translate_to.es": "translate_es_ha",
            "xx.ht.translate_to.es": "translate_es_ht",
            "xx.uk.translate_to.es": "translate_es_uk",
            "xx.tw.translate_to.es": "translate_es_tw",
            "xx.st.translate_to.es": "translate_es_st",
            "xx.sg.translate_to.es": "translate_es_sg",
            "xx.ilo.translate_to.es": "translate_es_ilo",
            "xx.ru.translate_to.es": "translate_es_ru",
            "xx.yo.translate_to.es": "translate_es_yo",
            "xx.pon.translate_to.es": "translate_es_pon",
            "xx.niu.translate_to.es": "translate_es_niu",
            "xx.lt.translate_to.es": "translate_es_lt",
            "xx.ty.translate_to.es": "translate_es_ty",
            "xx.ig.translate_to.es": "translate_es_ig",
            "xx.tzo.translate_to.es": "translate_es_tzo",
            "xx.rw.translate_to.es": "translate_es_rw",
            "xx.war.translate_to.es": "translate_es_war",
            "xx.tll.translate_to.es": "translate_es_tll",
            "xx.prl.translate_to.es": "translate_es_prl",
            "xx.xh.translate_to.es": "translate_es_xh",
            "xx.yua.translate_to.es": "translate_es_yua",
            "xx.ho.translate_to.es": "translate_es_ho",
            "xx.ve.translate_to.es": "translate_es_ve",
            "xx.sl.translate_to.es": "translate_es_sl",
            "xx.tn.translate_to.es": "translate_es_tn",
            "xx.vi.translate_to.es": "translate_es_vi",
            "xx.srn.translate_to.es": "translate_es_srn",
            "xx.fi.translate_to.es": "translate_es_fi",
            "xx.lua.translate_to.fi": "translate_fi_lua",
            "xx.ny.translate_to.fi": "translate_fi_ny",
            "xx.pon.translate_to.fi": "translate_fi_pon",
            "xx.crs.translate_to.fi": "translate_fi_crs",
            "xx.nso.translate_to.fi": "translate_fi_nso",
            "xx.iso.translate_to.fi": "translate_fi_iso",
            "xx.kqn.translate_to.fi": "translate_fi_kqn",
            "xx.gaa.translate_to.fi": "translate_fi_gaa",
            "xx.ru.translate_to.eu": "translate_eu_ru",
            "xx.eo.translate_to.fi": "translate_fi_eo",
            "xx.ig.translate_to.fi": "translate_fi_ig",
            "xx.bem.translate_to.fi": "translate_fi_bem",
            "xx.es.translate_to.et": "translate_et_es",
            "xx.fj.translate_to.fi": "translate_fi_fj",
            "xx.et.translate_to.fi": "translate_fi_et",
            "xx.bcl.translate_to.fi": "translate_fi_bcl",
            "xx.fi.translate_to.fi": "translate_fi_fi",
            "xx.el.translate_to.fi": "translate_fi_el",
            "xx.efi.translate_to.fi": "translate_fi_efi",
            "xx.ht.translate_to.fi": "translate_fi_ht",
            "xx.ceb.translate_to.fi": "translate_fi_ceb",
            "xx.lg.translate_to.fi": "translate_fi_lg",
            "xx.pap.translate_to.fi": "translate_fi_pap",
            "xx.kg.translate_to.fi": "translate_fi_kg",
            "xx.ee.translate_to.fi": "translate_fi_ee",
            "xx.lv.translate_to.fi": "translate_fi_lv",
            "xx.fr.translate_to.et": "translate_et_fr",
            "xx.de.translate_to.et": "translate_et_de",
            "xx.bzs.translate_to.fi": "translate_fi_bzs",
            "xx.mos.translate_to.fi": "translate_fi_mos",
            "xx.zh.translate_to.es": "translate_es_zh",
            "xx.id.translate_to.fi": "translate_fi_id",
            "xx.gil.translate_to.fi": "translate_fi_gil",
            "xx.pis.translate_to.fi": "translate_fi_pis",
            "xx.no.translate_to.fi": "translate_fi_no",
            "xx.it.translate_to.fi": "translate_fi_it",
            "xx.es.translate_to.fi": "translate_fi_es",
            "xx.ha.translate_to.fi": "translate_fi_ha",
            "xx.fr.translate_to.fi": "translate_fi_fr",
            "xx.de.translate_to.fi": "translate_fi_de",
            "xx.bg.translate_to.fi": "translate_fi_bg",
            "xx.zai.translate_to.es": "translate_es_zai",
            "xx.hil.translate_to.fi": "translate_fi_hil",
            "xx.cs.translate_to.fi": "translate_fi_cs",
            "xx.es.translate_to.eu": "translate_eu_es",
            "xx.ilo.translate_to.fi": "translate_fi_ilo",
            "xx.pag.translate_to.fi": "translate_fi_pag",
            "xx.ln.translate_to.fi": "translate_fi_ln",
            "xx.sv.translate_to.et": "translate_et_sv",
            "xx.niu.translate_to.fi": "translate_fi_niu",
            "xx.hr.translate_to.fi": "translate_fi_hr",
            "xx.de.translate_to.eu": "translate_eu_de",
            "xx.lus.translate_to.fi": "translate_fi_lus",
            "xx.ru.translate_to.et": "translate_et_ru",
            "xx.af.translate_to.fi": "translate_fi_af",
            "xx.mh.translate_to.fi": "translate_fi_mh",
            "xx.guw.translate_to.fi": "translate_fi_guw",
            "xx.mfe.translate_to.fi": "translate_fi_mfe",
            "xx.ho.translate_to.fi": "translate_fi_ho",
            "xx.fse.translate_to.fi": "translate_fi_fse",
            "xx.lu.translate_to.fi": "translate_fi_lu",
            "xx.hu.translate_to.fi": "translate_fi_hu",
            "xx.mk.translate_to.fi": "translate_fi_mk",
            "xx.nl.translate_to.fi": "translate_fi_nl",
            "xx.mg.translate_to.fi": "translate_fi_mg",
            "xx.mt.translate_to.fi": "translate_fi_mt",
            "xx.he.translate_to.fi": "translate_fi_he",
            "xx.fi.translate_to.et": "translate_et_fi",
            "xx.is.translate_to.fi": "translate_fi_is",
            "xx.lue.translate_to.fi": "translate_fi_lue",
            "xx.guw.translate_to.fr": "translate_fr_guw",
            "xx.ber.translate_to.fr": "translate_fr_ber",
            "xx.uk.translate_to.fi": "translate_fi_uk",
            "xx.efi.translate_to.fr": "translate_fr_efi",
            "xx.tr.translate_to.fi": "translate_fi_tr",
            "xx.tn.translate_to.fi": "translate_fi_tn",
            "xx.es.translate_to.fr": "translate_fr_es",
            "xx.srn.translate_to.fi": "translate_fi_srn",
            "xx.bcl.translate_to.fr": "translate_fr_bcl",
            "xx.sl.translate_to.fi": "translate_fi_sl",
            "xx.ht.translate_to.fr": "translate_fr_ht",
            "xx.zne.translate_to.fi": "translate_fi_zne",
            "xx.de.translate_to.fr": "translate_fr_de",
            "xx.war.translate_to.fi": "translate_fi_war",
            "xx.tpi.translate_to.fi": "translate_fi_tpi",
            "xx.ca.translate_to.fr": "translate_fr_ca",
            "xx.yap.translate_to.fi": "translate_fi_yap",
            "xx.sn.translate_to.fi": "translate_fi_sn",
            "xx.hr.translate_to.fr": "translate_fr_hr",
            "xx.gil.translate_to.fr": "translate_fr_gil",
            "xx.id.translate_to.fr": "translate_fr_id",
            "xx.sv.translate_to.fi": "translate_fi_sv",
            "xx.toi.translate_to.fi": "translate_fi_toi",
            "xx.sk.translate_to.fi": "translate_fi_sk",
            "xx.he.translate_to.fr": "translate_fr_he",
            "xx.sq.translate_to.fi": "translate_fi_sq",
            "xx.ve.translate_to.fi": "translate_fi_ve",
            "xx.tw.translate_to.fi": "translate_fi_tw",
            "xx.tvl.translate_to.fi": "translate_fi_tvl",
            "xx.hil.translate_to.fr": "translate_fr_hil",
            "xx.sw.translate_to.fi": "translate_fi_sw",
            "xx.eo.translate_to.fr": "translate_fr_eo",
            "xx.xh.translate_to.fi": "translate_fi_xh",
            "xx.bi.translate_to.fr": "translate_fr_bi",
            "xx.ru.translate_to.fi": "translate_fi_ru",
            "xx.ceb.translate_to.fr": "translate_fr_ceb",
            "xx.ig.translate_to.fr": "translate_fr_ig",
            "xx.el.translate_to.fr": "translate_fr_el",
            "xx.sm.translate_to.fi": "translate_fi_sm",
            "xx.to.translate_to.fi": "translate_fi_to",
            "xx.ase.translate_to.fr": "translate_fr_ase",
            "xx.yo.translate_to.fi": "translate_fi_yo",
            "xx.sg.translate_to.fi": "translate_fi_sg",
            "xx.rw.translate_to.fi": "translate_fi_rw",
            "xx.ts.translate_to.fi": "translate_fi_ts",
            "xx.wls.translate_to.fi": "translate_fi_wls",
            "xx.ho.translate_to.fr": "translate_fr_ho",
            "xx.tll.translate_to.fi": "translate_fi_tll",
            "xx.st.translate_to.fi": "translate_fi_st",
            "xx.fiu.translate_to.fiu": "translate_fiu_fiu",
            "xx.ro.translate_to.fi": "translate_fi_ro",
            "xx.tiv.translate_to.fi": "translate_fi_tiv",
            "xx.ha.translate_to.fr": "translate_fr_ha",
            "xx.ee.translate_to.fr": "translate_fr_ee",
            "xx.gaa.translate_to.fr": "translate_fr_gaa",
            "xx.hu.translate_to.fr": "translate_fr_hu",
            "xx.ty.translate_to.fi": "translate_fi_ty",
            "xx.fr.translate_to.fj": "translate_fj_fr",
            "xx.run.translate_to.fi": "translate_fi_run",
            "xx.bem.translate_to.fr": "translate_fr_bem",
            "xx.bzs.translate_to.fr": "translate_fr_bzs",
            "xx.fj.translate_to.fr": "translate_fr_fj",
            "xx.ar.translate_to.fr": "translate_fr_ar",
            "xx.swc.translate_to.fi": "translate_fi_swc",
            "xx.crs.translate_to.fr": "translate_fr_crs",
            "xx.bg.translate_to.fr": "translate_fr_bg",
            "xx.af.translate_to.fr": "translate_fr_af",
            "xx.loz.translate_to.fr": "translate_fr_loz",
            "xx.st.translate_to.fr": "translate_fr_st",
            "xx.tn.translate_to.fr": "translate_fr_tn",
            "xx.srn.translate_to.fr": "translate_fr_srn",
            "xx.to.translate_to.fr": "translate_fr_to",
            "xx.sk.translate_to.fr": "translate_fr_sk",
            "xx.tum.translate_to.fr": "translate_fr_tum",
            "xx.ts.translate_to.fr": "translate_fr_ts",
            "xx.iso.translate_to.fr": "translate_fr_iso",
            "xx.sv.translate_to.fr": "translate_fr_sv",
            "xx.mt.translate_to.fr": "translate_fr_mt",
            "xx.pap.translate_to.fr": "translate_fr_pap",
            "xx.wls.translate_to.fr": "translate_fr_wls",
            "xx.lua.translate_to.fr": "translate_fr_lua",
            "xx.ro.translate_to.fr": "translate_fr_ro",
            "xx.tll.translate_to.fr": "translate_fr_tll",
            "xx.ilo.translate_to.fr": "translate_fr_ilo",
            "xx.ve.translate_to.fr": "translate_fr_ve",
            "xx.ny.translate_to.fr": "translate_fr_ny",
            "xx.tpi.translate_to.fr": "translate_fr_tpi",
            "xx.uk.translate_to.fr": "translate_fr_uk",
            "xx.ln.translate_to.fr": "translate_fr_ln",
            "xx.mfe.translate_to.fr": "translate_fr_mfe",
            "xx.lue.translate_to.fr": "translate_fr_lue",
            "xx.mos.translate_to.fr": "translate_fr_mos",
            "xx.pon.translate_to.fr": "translate_fr_pon",
            "xx.tvl.translate_to.fr": "translate_fr_tvl",
            "xx.run.translate_to.fr": "translate_fr_run",
            "xx.pag.translate_to.fr": "translate_fr_pag",
            "xx.sg.translate_to.fr": "translate_fr_sg",
            "xx.no.translate_to.fr": "translate_fr_no",
            "xx.ty.translate_to.fr": "translate_fr_ty",
            "xx.tl.translate_to.fr": "translate_fr_tl",
            "xx.sl.translate_to.fr": "translate_fr_sl",
            "xx.tiv.translate_to.fr": "translate_fr_tiv",
            "xx.rw.translate_to.fr": "translate_fr_rw",
            "xx.lus.translate_to.fr": "translate_fr_lus",
            "xx.swc.translate_to.fr": "translate_fr_swc",
            "xx.sm.translate_to.fr": "translate_fr_sm",
            "xx.pl.translate_to.fr": "translate_fr_pl",
            "xx.kg.translate_to.fr": "translate_fr_kg",
            "xx.niu.translate_to.fr": "translate_fr_niu",
            "xx.lg.translate_to.fr": "translate_fr_lg",
            "xx.ms.translate_to.fr": "translate_fr_ms",
            "xx.nso.translate_to.fr": "translate_fr_nso",
            "xx.war.translate_to.fr": "translate_fr_war",
            "xx.xh.translate_to.fr": "translate_fr_xh",
            "xx.pis.translate_to.fr": "translate_fr_pis",
            "xx.tw.translate_to.fr": "translate_fr_tw",
            "xx.kwy.translate_to.fr": "translate_fr_kwy",
            "xx.rnd.translate_to.fr": "translate_fr_rnd",
            "xx.vi.translate_to.fr": "translate_fr_vi",
            "xx.lu.translate_to.fr": "translate_fr_lu",
            "xx.mh.translate_to.fr": "translate_fr_mh",
            "xx.ru.translate_to.fr": "translate_fr_ru",
            "xx.sn.translate_to.fr": "translate_fr_sn",
            "xx.kqn.translate_to.fr": "translate_fr_kqn",
            "xx.ar.translate_to.he": "translate_he_ar",
            "xx.de.translate_to.he": "translate_he_de",
            "xx.es.translate_to.gil": "translate_gil_es",
            "xx.de.translate_to.gaa": "translate_gaa_de",
            "xx.fr.translate_to.hu": "translate_hu_fr",
            "xx.fr.translate_to.gil": "translate_gil_fr",
            "xx.de.translate_to.guw": "translate_guw_de",
            "xx.fr.translate_to.ht": "translate_ht_fr",
            "xx.uk.translate_to.he": "translate_he_uk",
            "xx.fi.translate_to.hu": "translate_hu_fi",
            "xx.uk.translate_to.hu": "translate_hu_uk",
            "xx.zne.translate_to.fr": "translate_fr_zne",
            "xx.sv.translate_to.gaa": "translate_gaa_sv",
            "xx.es.translate_to.guw": "translate_guw_es",
            "xx.gmq.translate_to.gmq": "translate_gmq_gmq",
            "xx.fi.translate_to.hil": "translate_hil_fi",
            "xx.fi.translate_to.guw": "translate_guw_fi",
            "xx.es.translate_to.he": "translate_he_es",
            "xx.ur.translate_to.hi": "translate_hi_ur",
            "xx.de.translate_to.hil": "translate_hil_de",
            "xx.gmw.translate_to.gmw": "translate_gmw_gmw",
            "xx.fi.translate_to.gaa": "translate_gaa_fi",
            "xx.fi.translate_to.he": "translate_he_fi",
            "xx.eo.translate_to.hu": "translate_hu_eo",
            "xx.fi.translate_to.ht": "translate_ht_fi",
            "xx.yo.translate_to.fr": "translate_fr_yo",
            "xx.sv.translate_to.hr": "translate_hr_sv",
            "xx.fr.translate_to.ha": "translate_ha_fr",
            "xx.fi.translate_to.ha": "translate_ha_fi",
            "xx.sv.translate_to.ha": "translate_ha_sv",
            "xx.pt.translate_to.gl": "translate_gl_pt",
            "xx.fr.translate_to.guw": "translate_guw_fr",
            "xx.es.translate_to.ht": "translate_ht_es",
            "xx.de.translate_to.hu": "translate_hu_de",
            "xx.sv.translate_to.ht": "translate_ht_sv",
            "xx.es.translate_to.hr": "translate_hr_es",
            "xx.fr.translate_to.gaa": "translate_gaa_fr",
            "xx.ru.translate_to.he": "translate_he_ru",
            "xx.es.translate_to.gl": "translate_gl_es",
            "xx.ru.translate_to.hy": "translate_hy_ru",
            "xx.fi.translate_to.gil": "translate_gil_fi",
            "xx.sv.translate_to.hu": "translate_hu_sv",
            "xx.sv.translate_to.gil": "translate_gil_sv",
            "xx.fi.translate_to.fse": "translate_fse_fi",
            "xx.gem.translate_to.gem": "translate_gem_gem",
            "xx.es.translate_to.ha": "translate_ha_es",
            "xx.it.translate_to.he": "translate_he_it",
            "xx.sv.translate_to.guw": "translate_guw_sv",
            "xx.sv.translate_to.he": "translate_he_sv",
            "xx.yap.translate_to.fr": "translate_fr_yap",
            "xx.fr.translate_to.hr": "translate_hr_fr",
            "xx.eo.translate_to.he": "translate_he_eo",
            "xx.es.translate_to.gaa": "translate_gaa_es",
            "xx.fi.translate_to.hr": "translate_hr_fi",
            "xx.fr.translate_to.he": "translate_he_fr",
            "xx.fi.translate_to.ilo": "translate_ilo_fi",
            "xx.sv.translate_to.iso": "translate_iso_sv",
            "xx.he.translate_to.ja": "translate_ja_he",
            "xx.fi.translate_to.id": "translate_id_fi",
            "xx.de.translate_to.ja": "translate_ja_de",
            "xx.he.translate_to.it": "translate_it_he",
            "xx.it.translate_to.ja": "translate_ja_it",
            "xx.is.translate_to.it": "translate_it_is",
            "xx.bg.translate_to.ja": "translate_ja_bg",
            "xx.de.translate_to.ig": "translate_ig_de",
            "xx.bg.translate_to.it": "translate_it_bg",
            "xx.es.translate_to.id": "translate_id_es",
            "xx.fr.translate_to.id": "translate_id_fr",
            "xx.es.translate_to.ja": "translate_ja_es",
            "xx.sv.translate_to.ja": "translate_ja_sv",
            "xx.es.translate_to.iso": "translate_iso_es",
            "xx.es.translate_to.ilo": "translate_ilo_es",
            "xx.it.translate_to.is": "translate_is_it",
            "xx.sv.translate_to.it": "translate_it_sv",
            "xx.sv.translate_to.is": "translate_is_sv",
            "xx.ru.translate_to.ja": "translate_ja_ru",
            "xx.es.translate_to.kg": "translate_kg_es",
            "xx.fi.translate_to.ig": "translate_ig_fi",
            "xx.fr.translate_to.iso": "translate_iso_fr",
            "xx.de.translate_to.ko": "translate_ko_de",
            "xx.sv.translate_to.ilo": "translate_ilo_sv",
            "xx.es.translate_to.is": "translate_is_es",
            "xx.da.translate_to.ja": "translate_ja_da",
            "xx.nl.translate_to.ja": "translate_ja_nl",
            "xx.inc.translate_to.inc": "translate_inc_inc",
            "xx.de.translate_to.is": "translate_is_de",
            "xx.fr.translate_to.is": "translate_is_fr",
            "xx.lt.translate_to.it": "translate_it_lt",
            "xx.sv.translate_to.ig": "translate_ig_sv",
            "xx.de.translate_to.ilo": "translate_ilo_de",
            "xx.ar.translate_to.it": "translate_it_ar",
            "xx.fr.translate_to.kg": "translate_kg_fr",
            "xx.vi.translate_to.ja": "translate_ja_vi",
            "xx.ru.translate_to.ka": "translate_ka_ru",
            "xx.uk.translate_to.it": "translate_it_uk",
            "xx.vi.translate_to.it": "translate_it_vi",
            "xx.ms.translate_to.it": "translate_it_ms",
            "xx.ar.translate_to.ja": "translate_ja_ar",
            "xx.eo.translate_to.is": "translate_is_eo",
            "xx.ca.translate_to.it": "translate_it_ca",
            "xx.sh.translate_to.ja": "translate_ja_sh",
            "xx.fi.translate_to.ja": "translate_ja_fi",
            "xx.iir.translate_to.iir": "translate_iir_iir",
            "xx.itc.translate_to.itc": "translate_itc_itc",
            "xx.ms.translate_to.ja": "translate_ja_ms",
            "xx.fr.translate_to.it": "translate_it_fr",
            "xx.fr.translate_to.ja": "translate_ja_fr",
            "xx.pt.translate_to.ja": "translate_ja_pt",
            "xx.eo.translate_to.it": "translate_it_eo",
            "xx.fi.translate_to.iso": "translate_iso_fi",
            "xx.pl.translate_to.ja": "translate_ja_pl",
            "xx.tr.translate_to.ja": "translate_ja_tr",
            "xx.es.translate_to.ig": "translate_ig_es",
            "xx.fr.translate_to.ig": "translate_ig_fr",
            "xx.sv.translate_to.id": "translate_id_sv",
            "xx.hu.translate_to.ja": "translate_ja_hu",
            "xx.sv.translate_to.kg": "translate_kg_sv",
            "xx.es.translate_to.it": "translate_it_es",
            "xx.ine.translate_to.ine": "translate_ine_ine",
            "xx.de.translate_to.it": "translate_it_de",
            "xx.fi.translate_to.is": "translate_is_fi",
            "xx.es.translate_to.mk": "translate_mk_es",
            "xx.es.translate_to.lue": "translate_lue_es",
            "xx.es.translate_to.lv": "translate_lv_es",
            "xx.fi.translate_to.lue": "translate_lue_fi",
            "xx.es.translate_to.ln": "translate_ln_es",
            "xx.fr.translate_to.loz": "translate_loz_fr",
            "xx.sv.translate_to.kwy": "translate_kwy_sv",
            "xx.es.translate_to.lus": "translate_lus_es",
            "xx.fr.translate_to.lv": "translate_lv_fr",
            "xx.fr.translate_to.lu": "translate_lu_fr",
            "xx.de.translate_to.lt": "translate_lt_de",
            "xx.tr.translate_to.lt": "translate_lt_tr",
            "xx.fr.translate_to.lus": "translate_lus_fr",
            "xx.es.translate_to.mg": "translate_mg_es",
            "xx.sv.translate_to.lua": "translate_lua_sv",
            "xx.fr.translate_to.lg": "translate_lg_fr",
            "xx.fr.translate_to.kwy": "translate_kwy_fr",
            "xx.es.translate_to.lt": "translate_lt_es",
            "xx.sv.translate_to.ko": "translate_ko_sv",
            "xx.es.translate_to.kqn": "translate_kqn_es",
            "xx.fr.translate_to.ko": "translate_ko_fr",
            "xx.sv.translate_to.kqn": "translate_kqn_sv",
            "xx.fi.translate_to.ko": "translate_ko_fi",
            "xx.es.translate_to.mh": "translate_mh_es",
            "xx.fr.translate_to.lua": "translate_lua_fr",
            "xx.it.translate_to.lt": "translate_lt_it",
            "xx.sv.translate_to.lt": "translate_lt_sv",
            "xx.es.translate_to.lu": "translate_lu_es",
            "xx.fi.translate_to.lua": "translate_lua_fi",
            "xx.fr.translate_to.kqn": "translate_kqn_fr",
            "xx.de.translate_to.loz": "translate_loz_de",
            "xx.fr.translate_to.ms": "translate_ms_fr",
            "xx.fr.translate_to.lt": "translate_lt_fr",
            "xx.ru.translate_to.lv": "translate_lv_ru",
            "xx.ms.translate_to.ms": "translate_ms_ms",
            "xx.sv.translate_to.lus": "translate_lus_sv",
            "xx.fr.translate_to.lue": "translate_lue_fr",
            "xx.fi.translate_to.lu": "translate_lu_fi",
            "xx.eo.translate_to.lt": "translate_lt_eo",
            "xx.fi.translate_to.mk": "translate_mk_fi",
            "xx.es.translate_to.ko": "translate_ko_es",
            "xx.sv.translate_to.lue": "translate_lue_sv",
            "xx.pl.translate_to.lt": "translate_lt_pl",
            "xx.es.translate_to.mfe": "translate_mfe_es",
            "xx.fi.translate_to.loz": "translate_loz_fi",
            "xx.sv.translate_to.loz": "translate_loz_sv",
            "xx.ru.translate_to.ko": "translate_ko_ru",
            "xx.fi.translate_to.lg": "translate_lg_fi",
            "xx.fi.translate_to.mh": "translate_mh_fi",
            "xx.sv.translate_to.lv": "translate_lv_sv",
            "xx.hu.translate_to.ko": "translate_ko_hu",
            "xx.es.translate_to.lua": "translate_lua_es",
            "xx.fi.translate_to.lv": "translate_lv_fi",
            "xx.ru.translate_to.lt": "translate_lt_ru",
            "xx.de.translate_to.ms": "translate_ms_de",
            "xx.fi.translate_to.lus": "translate_lus_fi",
            "xx.es.translate_to.lg": "translate_lg_es",
            "xx.de.translate_to.ln": "translate_ln_de",
            "xx.es.translate_to.mfs": "translate_mfs_es",
            "xx.fr.translate_to.mk": "translate_mk_fr",
            "xx.fr.translate_to.ln": "translate_ln_fr",
            "xx.es.translate_to.loz": "translate_loz_es",
            "xx.sv.translate_to.lu": "translate_lu_sv",
            "xx.it.translate_to.ms": "translate_ms_it",
            "xx.sv.translate_to.lg": "translate_lg_sv",
            "xx.ar.translate_to.pl": "translate_pl_ar",
            "xx.fr.translate_to.ro": "translate_ro_fr",
            "xx.sv.translate_to.niu": "translate_niu_sv",
            "xx.eo.translate_to.pl": "translate_pl_eo",
            "xx.nl.translate_to.no": "translate_no_nl",
            "xx.es.translate_to.no": "translate_no_es",
            "xx.es.translate_to.pag": "translate_pag_es",
            "xx.ru.translate_to.rn": "translate_rn_ru",
            "xx.sv.translate_to.pag": "translate_pag_sv",
            "xx.uk.translate_to.pt": "translate_pt_uk",
            "xx.uk.translate_to.pl": "translate_pl_uk",
            "xx.de.translate_to.pl": "translate_pl_de",
            "xx.sv.translate_to.nl": "translate_nl_sv",
            "xx.fr.translate_to.no": "translate_no_fr",
            "xx.es.translate_to.niu": "translate_niu_es",
            "xx.uk.translate_to.no": "translate_no_uk",
            "xx.lt.translate_to.pl": "translate_pl_lt",
            "xx.tl.translate_to.pt": "translate_pt_tl",
            "xx.gl.translate_to.pt": "translate_pt_gl",
            "xx.da.translate_to.ru": "translate_ru_da",
            "xx.da.translate_to.no": "translate_no_da",
            "xx.uk.translate_to.nl": "translate_nl_uk",
            "xx.sv.translate_to.pon": "translate_pon_sv",
            "xx.fr.translate_to.pis": "translate_pis_fr",
            "xx.fr.translate_to.niu": "translate_niu_fr",
            "xx.af.translate_to.nl": "translate_nl_af",
            "xx.fi.translate_to.nso": "translate_nso_fi",
            "xx.fi.translate_to.pon": "translate_pon_fi",
            "xx.de.translate_to.pap": "translate_pap_de",
            "xx.de.translate_to.rn": "translate_rn_de",
            "xx.es.translate_to.pon": "translate_pon_es",
            "xx.es.translate_to.pis": "translate_pis_es",
            "xx.ca.translate_to.pt": "translate_pt_ca",
            "xx.sv.translate_to.rnd": "translate_rnd_sv",
            "xx.sv.translate_to.pl": "translate_pl_sv",
            "xx.ru.translate_to.no": "translate_no_ru",
            "xx.fi.translate_to.niu": "translate_niu_fi",
            "xx.de.translate_to.pag": "translate_pag_de",
            "xx.fr.translate_to.pl": "translate_pl_fr",
            "xx.fi.translate_to.no": "translate_no_fi",
            "xx.pl.translate_to.no": "translate_no_pl",
            "xx.de.translate_to.nso": "translate_nso_de",
            "xx.fr.translate_to.rn": "translate_rn_fr",
            "xx.sv.translate_to.nso": "translate_nso_sv",
            "xx.sv.translate_to.ro": "translate_ro_sv",
            "xx.no.translate_to.pl": "translate_pl_no",
            "xx.fr.translate_to.nl": "translate_nl_fr",
            "xx.es.translate_to.nso": "translate_nso_es",
            "xx.no.translate_to.nl": "translate_nl_no",
            "xx.fi.translate_to.pis": "translate_pis_fi",
            "xx.ca.translate_to.nl": "translate_nl_ca",
            "xx.es.translate_to.nl": "translate_nl_es",
            "xx.es.translate_to.ny": "translate_ny_es",
            "xx.fr.translate_to.pap": "translate_pap_fr",
            "xx.fi.translate_to.nl": "translate_nl_fi",
            "xx.sv.translate_to.no": "translate_no_sv",
            "xx.fr.translate_to.pon": "translate_pon_fr",
            "xx.fr.translate_to.rnd": "translate_rnd_fr",
            "xx.es.translate_to.pap": "translate_pap_es",
            "xx.es.translate_to.prl": "translate_prl_es",
            "xx.eo.translate_to.ro": "translate_ro_eo",
            "xx.sv.translate_to.pis": "translate_pis_sv",
            "xx.af.translate_to.ru": "translate_ru_af",
            "xx.fr.translate_to.nso": "translate_nso_fr",
            "xx.eo.translate_to.pt": "translate_pt_eo",
            "xx.ar.translate_to.ru": "translate_ru_ar",
            "xx.fr.translate_to.mt": "translate_mt_fr",
            "xx.es.translate_to.rn": "translate_rn_es",
            "xx.sv.translate_to.mt": "translate_mt_sv",
            "xx.de.translate_to.niu": "translate_niu_de",
            "xx.es.translate_to.mt": "translate_mt_es",
            "xx.es.translate_to.pl": "translate_pl_es",
            "xx.fi.translate_to.pag": "translate_pag_fi",
            "xx.de.translate_to.no": "translate_no_de",
            "xx.de.translate_to.ny": "translate_ny_de",
            "xx.fi.translate_to.mt": "translate_mt_fi",
            "xx.no.translate_to.no": "translate_no_no",
            "xx.eo.translate_to.nl": "translate_nl_eo",
            "xx.bg.translate_to.ru": "translate_ru_bg",
            "xx.fi.translate_to.pap": "translate_pap_fi",
            "xx.fi.translate_to.ro": "translate_ro_fi",
            "xx.sv.translate_to.st": "translate_st_sv",
            "xx.kg.translate_to.sv": "translate_sv_kg",
            "xx.sv.translate_to.sq": "translate_sq_sv",
            "xx.ee.translate_to.sv": "translate_sv_ee",
            "xx.es.translate_to.srn": "translate_srn_es",
            "xx.lv.translate_to.ru": "translate_ru_lv",
            "xx.cs.translate_to.sv": "translate_sv_cs",
            "xx.ha.translate_to.sv": "translate_sv_ha",
            "xx.kqn.translate_to.sv": "translate_sv_kqn",
            "xx.fr.translate_to.rw": "translate_rw_fr",
            "xx.fr.translate_to.sn": "translate_sn_fr",
            "xx.eu.translate_to.ru": "translate_ru_eu",
            "xx.fi.translate_to.st": "translate_st_fi",
            "xx.efi.translate_to.sv": "translate_sv_efi",
            "xx.ho.translate_to.sv": "translate_sv_ho",
            "xx.id.translate_to.sv": "translate_sv_id",
            "xx.eo.translate_to.sv": "translate_sv_eo",
            "xx.guw.translate_to.sv": "translate_sv_guw",
            "xx.sv.translate_to.sk": "translate_sk_sv",
            "xx.fr.translate_to.srn": "translate_srn_fr",
            "xx.ceb.translate_to.sv": "translate_sv_ceb",
            "xx.es.translate_to.sq": "translate_sq_es",
            "xx.sv.translate_to.rw": "translate_rw_sv",
            "xx.is.translate_to.sv": "translate_sv_is",
            "xx.es.translate_to.sm": "translate_sm_es",
            "xx.bcl.translate_to.sv": "translate_sv_bcl",
            "xx.kwy.translate_to.sv": "translate_sv_kwy",
            "xx.es.translate_to.run": "translate_run_es",
            "xx.el.translate_to.sv": "translate_sv_el",
            "xx.es.translate_to.sk": "translate_sk_es",
            "xx.iso.translate_to.sv": "translate_sv_iso",
            "xx.lu.translate_to.sv": "translate_sv_lu",
            "xx.af.translate_to.sv": "translate_sv_af",
            "xx.bg.translate_to.sv": "translate_sv_bg",
            "xx.fr.translate_to.sm": "translate_sm_fr",
            "xx.hr.translate_to.sv": "translate_sv_hr",
            "xx.sv.translate_to.sn": "translate_sn_sv",
            "xx.no.translate_to.ru": "translate_ru_no",
            "xx.fr.translate_to.sg": "translate_sg_fr",
            "xx.es.translate_to.sl": "translate_sl_es",
            "xx.bzs.translate_to.sv": "translate_sv_bzs",
            "xx.fr.translate_to.st": "translate_st_fr",
            "xx.hu.translate_to.sv": "translate_sv_hu",
            "xx.sv.translate_to.sg": "translate_sg_sv",
            "xx.sem.translate_to.sem": "translate_sem_sem",
            "xx.uk.translate_to.sh": "translate_sh_uk",
            "xx.ln.translate_to.sv": "translate_sv_ln",
            "xx.fi.translate_to.sk": "translate_sk_fi",
            "xx.ht.translate_to.sv": "translate_sv_ht",
            "xx.es.translate_to.st": "translate_st_es",
            "xx.fr.translate_to.ru": "translate_ru_fr",
            "xx.chk.translate_to.sv": "translate_sv_chk",
            "xx.fr.translate_to.sk": "translate_sk_fr",
            "xx.lg.translate_to.sv": "translate_sv_lg",
            "xx.sv.translate_to.srn": "translate_srn_sv",
            "xx.crs.translate_to.sv": "translate_sv_crs",
            "xx.uk.translate_to.ru": "translate_ru_uk",
            "xx.et.translate_to.ru": "translate_ru_et",
            "xx.et.translate_to.sv": "translate_sv_et",
            "xx.es.translate_to.rw": "translate_rw_es",
            "xx.sla.translate_to.sla": "translate_sla_sla",
            "xx.ru.translate_to.sl": "translate_sl_ru",
            "xx.fj.translate_to.sv": "translate_sv_fj",
            "xx.es.translate_to.sn": "translate_sn_es",
            "xx.lua.translate_to.sv": "translate_sv_lua",
            "xx.hil.translate_to.sv": "translate_sv_hil",
            "xx.es.translate_to.ru": "translate_ru_es",
            "xx.lue.translate_to.sv": "translate_sv_lue",
            "xx.gaa.translate_to.sv": "translate_sv_gaa",
            "xx.hy.translate_to.ru": "translate_ru_hy",
            "xx.bem.translate_to.sv": "translate_sv_bem",
            "xx.sv.translate_to.run": "translate_run_sv",
            "xx.gil.translate_to.sv": "translate_sv_gil",
            "xx.lus.translate_to.sv": "translate_sv_lus",
            "xx.he.translate_to.ru": "translate_ru_he",
            "xx.vi.translate_to.ru": "translate_ru_vi",
            "xx.he.translate_to.sv": "translate_sv_he",
            "xx.sv.translate_to.ru": "translate_ru_sv",
            "xx.fi.translate_to.ru": "translate_ru_fi",
            "xx.es.translate_to.sv": "translate_sv_es",
            "xx.es.translate_to.sg": "translate_sg_es",
            "xx.eo.translate_to.ru": "translate_ru_eo",
            "xx.lv.translate_to.sv": "translate_sv_lv",
            "xx.fi.translate_to.sg": "translate_sg_fi",
            "xx.es.translate_to.ssp": "translate_ssp_es",
            "xx.ilo.translate_to.sv": "translate_sv_ilo",
            "xx.fi.translate_to.sv": "translate_sv_fi",
            "xx.lt.translate_to.ru": "translate_ru_lt",
            "xx.bi.translate_to.sv": "translate_sv_bi",
            "xx.sv.translate_to.sl": "translate_sl_sv",
            "xx.fr.translate_to.sv": "translate_sv_fr",
            "xx.uk.translate_to.sl": "translate_sl_uk",
            "xx.fi.translate_to.sl": "translate_sl_fi",
            "xx.sl.translate_to.ru": "translate_ru_sl",
            "xx.ig.translate_to.sv": "translate_sv_ig",
            "xx.ase.translate_to.sv": "translate_sv_ase",
            "xx.eo.translate_to.sh": "translate_sh_eo",
            "xx.fr.translate_to.sl": "translate_sl_fr",
            "xx.es.translate_to.tl": "translate_tl_es",
            "xx.sv.translate_to.tw": "translate_tw_sv",
            "xx.lt.translate_to.tr": "translate_tr_lt",
            "xx.fi.translate_to.tll": "translate_tll_fi",
            "xx.sn.translate_to.sv": "translate_sv_sn",
            "xx.tn.translate_to.sv": "translate_sv_tn",
            "xx.sv.translate_to.toi": "translate_toi_sv",
            "xx.uk.translate_to.sv": "translate_sv_uk",
            "xx.tiv.translate_to.sv": "translate_sv_tiv",
            "xx.sk.translate_to.sv": "translate_sv_sk",
            "xx.ty.translate_to.sv": "translate_sv_ty",
            "xx.es.translate_to.toi": "translate_toi_es",
            "xx.rw.translate_to.sv": "translate_sv_rw",
            "xx.ny.translate_to.sv": "translate_sv_ny",
            "xx.rnd.translate_to.sv": "translate_sv_rnd",
            "xx.es.translate_to.tn": "translate_tn_es",
            "xx.sv.translate_to.tn": "translate_tn_sv",
            "xx.es.translate_to.tvl": "translate_tvl_es",
            "xx.pon.translate_to.sv": "translate_sv_pon",
            "xx.ve.translate_to.sv": "translate_sv_ve",
            "xx.fr.translate_to.tvl": "translate_tvl_fr",
            "xx.es.translate_to.tum": "translate_tum_es",
            "xx.run.translate_to.sv": "translate_sv_run",
            "xx.de.translate_to.tl": "translate_tl_de",
            "xx.fi.translate_to.tw": "translate_tw_fi",
            "xx.es.translate_to.ty": "translate_ty_es",
            "xx.fr.translate_to.toi": "translate_toi_fr",
            "xx.sv.translate_to.tll": "translate_tll_sv",
            "xx.sg.translate_to.sv": "translate_sv_sg",
            "xx.az.translate_to.tr": "translate_tr_az",
            "xx.es.translate_to.ts": "translate_ts_es",
            "xx.fr.translate_to.ts": "translate_ts_fr",
            "xx.fr.translate_to.th": "translate_th_fr",
            "xx.zne.translate_to.sv": "translate_sv_zne",
            "xx.tw.translate_to.sv": "translate_sv_tw",
            "xx.mh.translate_to.sv": "translate_sv_mh",
            "xx.pag.translate_to.sv": "translate_sv_pag",
            "xx.fr.translate_to.tum": "translate_tum_fr",
            "xx.no.translate_to.sv": "translate_sv_no",
            "xx.ts.translate_to.sv": "translate_sv_ts",
            "xx.mt.translate_to.sv": "translate_sv_mt",
            "xx.yo.translate_to.sv": "translate_sv_yo",
            "xx.fr.translate_to.to": "translate_to_fr",
            "xx.sv.translate_to.sv": "translate_sv_sv",
            "xx.fi.translate_to.toi": "translate_toi_fi",
            "xx.ro.translate_to.sv": "translate_sv_ro",
            "xx.es.translate_to.tw": "translate_tw_es",
            "xx.niu.translate_to.sv": "translate_sv_niu",
            "xx.uk.translate_to.tr": "translate_tr_uk",
            "xx.to.translate_to.sv": "translate_sv_to",
            "xx.fi.translate_to.ts": "translate_ts_fi",
            "xx.tll.translate_to.sv": "translate_sv_tll",
            "xx.fr.translate_to.tll": "translate_tll_fr",
            "xx.pt.translate_to.tl": "translate_tl_pt",
            "xx.nso.translate_to.sv": "translate_sv_nso",
            "xx.sq.translate_to.sv": "translate_sv_sq",
            "xx.sv.translate_to.tpi": "translate_tpi_sv",
            "xx.yap.translate_to.sv": "translate_sv_yap",
            "xx.sv.translate_to.tr": "translate_tr_sv",
            "xx.fr.translate_to.swc": "translate_swc_fr",
            "xx.nl.translate_to.sv": "translate_sv_nl",
            "xx.fi.translate_to.ty": "translate_ty_fi",
            "xx.fr.translate_to.tr": "translate_tr_fr",
            "xx.sv.translate_to.tum": "translate_tum_sv",
            "xx.swc.translate_to.sv": "translate_sv_swc",
            "xx.fi.translate_to.swc": "translate_swc_fi",
            "xx.eo.translate_to.tr": "translate_tr_eo",
            "xx.xh.translate_to.sv": "translate_sv_xh",
            "xx.sv.translate_to.tvl": "translate_tvl_sv",
            "xx.sl.translate_to.sv": "translate_sv_sl",
            "xx.tum.translate_to.sv": "translate_sv_tum",
            "xx.es.translate_to.to": "translate_to_es",
            "xx.fr.translate_to.tn": "translate_tn_fr",
            "xx.sv.translate_to.ty": "translate_ty_sv",
            "xx.sv.translate_to.swc": "translate_swc_sv",
            "xx.mos.translate_to.sv": "translate_sv_mos",
            "xx.ar.translate_to.tr": "translate_tr_ar",
            "xx.ru.translate_to.sv": "translate_sv_ru",
            "xx.srn.translate_to.sv": "translate_sv_srn",
            "xx.pis.translate_to.sv": "translate_sv_pis",
            "xx.pap.translate_to.sv": "translate_sv_pap",
            "xx.tvl.translate_to.sv": "translate_sv_tvl",
            "xx.sv.translate_to.to": "translate_to_sv",
            "xx.th.translate_to.sv": "translate_sv_th",
            "xx.war.translate_to.sv": "translate_sv_war",
            "xx.sv.translate_to.ts": "translate_ts_sv",
            "xx.fr.translate_to.tw": "translate_tw_fr",
            "xx.st.translate_to.sv": "translate_sv_st",
            "xx.fr.translate_to.tiv": "translate_tiv_fr",
            "xx.tpi.translate_to.sv": "translate_sv_tpi",
            "xx.fi.translate_to.tvl": "translate_tvl_fi",
            "xx.fr.translate_to.ty": "translate_ty_fr",
            "xx.sm.translate_to.sv": "translate_sv_sm",
            "xx.es.translate_to.swc": "translate_swc_es",
            "xx.sv.translate_to.tiv": "translate_tiv_sv",
            "xx.toi.translate_to.sv": "translate_sv_toi",
            "xx.mfe.translate_to.sv": "translate_sv_mfe",
            "xx.wls.translate_to.sv": "translate_sv_wls",
            "xx.umb.translate_to.sv": "translate_sv_umb",
            "xx.es.translate_to.tr": "translate_tr_es",
            "xx.es.translate_to.tll": "translate_tll_es",
            "xx.pt.translate_to.uk": "translate_uk_pt",
            "xx.it.translate_to.zh": "translate_zh_it",
            "xx.no.translate_to.uk": "translate_uk_no",
            "xx.sh.translate_to.uk": "translate_uk_sh",
            "xx.sv.translate_to.wls": "translate_wls_sv",
            "xx.pl.translate_to.uk": "translate_uk_pl",
            "xx.es.translate_to.yo": "translate_yo_es",
            "xx.es.translate_to.war": "translate_war_es",
            "xx.sv.translate_to.zh": "translate_zh_sv",
            "xx.tr.translate_to.uk": "translate_uk_tr",
            "xx.fi.translate_to.war": "translate_war_fi",
            "xx.de.translate_to.zh": "translate_zh_de",
            "xx.uk.translate_to.zh": "translate_zh_uk",
            "xx.eo.translate_to.vi": "translate_vi_eo",
            "xx.bg.translate_to.zh": "translate_zh_bg",
            "xx.es.translate_to.zne": "translate_zne_es",
            "xx.fr.translate_to.uk": "translate_uk_fr",
            "xx.zls.translate_to.zls": "translate_zls_zls",
            "xx.fr.translate_to.yo": "translate_yo_fr",
            "xx.bg.translate_to.uk": "translate_uk_bg",
            "xx.fr.translate_to.xh": "translate_xh_fr",
            "xx.ca.translate_to.uk": "translate_uk_ca",
            "xx.fi.translate_to.zh": "translate_zh_fi",
            "xx.es.translate_to.zai": "translate_zai_es",
            "xx.es.translate_to.uk": "translate_uk_es",
            "xx.nl.translate_to.uk": "translate_uk_nl",
            "xx.sv.translate_to.yap": "translate_yap_sv",
            "xx.he.translate_to.uk": "translate_uk_he",
            "xx.sl.translate_to.uk": "translate_uk_sl",
            "xx.es.translate_to.ve": "translate_ve_es",
            "xx.zlw.translate_to.zlw": "translate_zlw_zlw",
            "xx.es.translate_to.tzo": "translate_tzo_es",
            "xx.hu.translate_to.uk": "translate_uk_hu",
            "xx.de.translate_to.vi": "translate_vi_de",
            "xx.fi.translate_to.yo": "translate_yo_fi",
            "xx.ru.translate_to.uk": "translate_uk_ru",
            "xx.ms.translate_to.zh": "translate_zh_ms",
            "xx.urj.translate_to.urj": "translate_urj_urj",
            "xx.it.translate_to.uk": "translate_uk_it",
            "xx.sv.translate_to.war": "translate_war_sv",
            "xx.fr.translate_to.wls": "translate_wls_fr",
            "xx.zle.translate_to.zle": "translate_zle_zle",
            "xx.vi.translate_to.zh": "translate_zh_vi",
            "xx.es.translate_to.vsl": "translate_vsl_es",
            "xx.fi.translate_to.zne": "translate_zne_fi",
            "xx.fi.translate_to.uk": "translate_uk_fi",
            "xx.ru.translate_to.vi": "translate_vi_ru",
            "xx.nl.translate_to.zh": "translate_zh_nl",
            "xx.sv.translate_to.xh": "translate_xh_sv",
            "xx.es.translate_to.xh": "translate_xh_es",
            "xx.he.translate_to.zh": "translate_zh_he",
            "xx.fr.translate_to.war": "translate_war_fr",
            "xx.fr.translate_to.zne": "translate_zne_fr",
            "xx.sv.translate_to.yo": "translate_yo_sv",
            "xx.fr.translate_to.vi": "translate_vi_fr",
            "xx.it.translate_to.vi": "translate_vi_it",
            "xx.sv.translate_to.zne": "translate_zne_sv",
            "xx.fr.translate_to.yap": "translate_yap_fr",
            "xx.cs.translate_to.uk": "translate_uk_cs",
            "xx.es.translate_to.vi": "translate_vi_es",
            "xx.de.translate_to.uk": "translate_uk_de",
            "xx.sv.translate_to.uk": "translate_uk_sv",

        },

    }
    pretrained_models_references = {
        'ab': {'ab.speech2text.wav2vec2': 'asr_hf_challenge_test',
               'ab.speech2text.wav2vec2.base': 'asr_baseline',
               'ab.speech2text.wav2vec2.base_gpu': 'asr_baseline_gpu',
               'ab.speech2text.wav2vec2.by_mofe': 'asr_speech_sprint_test',
               'ab.speech2text.wav2vec2.gpu': 'asr_hf_challenge_test_gpu',
               'ab.speech2text.wav2vec2.v2': 'asr_wav2vec2_common_voice_ab_demo',
               'ab.speech2text.wav2vec2.v2_gpu': 'asr_wav2vec2_common_voice_ab_demo_gpu',
               'ab.speech2text.wav2vec_xls': 'asr_xls_test',
               'ab.speech2text.wav2vec_xlsr': 'asr_xls_r_ab_spanish',
               'ab.speech2text.wav2vec_xlsr.by_baaastien': 'asr_xls_r_ab_test_by_baaastien',
               'ab.speech2text.wav2vec_xlsr.by_cahya': 'asr_xls_r_ab_test_by_cahya',
               'ab.speech2text.wav2vec_xlsr.by_chmanoj': 'asr_xls_r_demo_test',
               'ab.speech2text.wav2vec_xlsr.by_fitods': 'asr_xls_r_ab_test_by_fitods',
               'ab.speech2text.wav2vec_xlsr.by_hf_test': 'asr_xls_r_ab_test_by_hf_test',
               'ab.speech2text.wav2vec_xlsr.by_mattchurgin': 'asr_xls_r_eng',
               'ab.speech2text.wav2vec_xlsr.by_muneson': 'asr_xls_r_ab_test_by_muneson',
               'ab.speech2text.wav2vec_xlsr.by_pablouribe': 'asr_xls_r_ab_test_by_pablouribe',
               'ab.speech2text.wav2vec_xlsr.gpu': 'asr_xls_r_ab_spanish_gpu',
               'ab.speech2text.wav2vec_xlsr.gpu.by_cahya': 'asr_xls_r_ab_test_by_cahya_gpu',
               'ab.speech2text.wav2vec_xlsr.gpu.by_chmanoj': 'asr_xls_r_demo_test_gpu',
               'ab.speech2text.wav2vec_xlsr.gpu.by_fitods': 'asr_xls_r_ab_test_by_fitods_gpu',
               'ab.speech2text.wav2vec_xlsr.gpu.by_hf_test': 'asr_xls_r_ab_test_by_hf_test_gpu',
               'ab.speech2text.wav2vec_xlsr.gpu.by_mattchurgin': 'asr_xls_r_eng_gpu',
               'ab.speech2text.wav2vec_xlsr.gpu.by_pablouribe': 'asr_xls_r_ab_test_by_pablouribe_gpu',
               'ab.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m_ab_cv8',
               'ab.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_ab_cv8_gpu'},
        'af': {'af.embed.w2v_cc_300d': 'w2v_cc_300d',
               'af.lemma': 'lemma',
               'af.lemma.afribooms': 'lemma_afribooms',
               'af.pos': 'pos_afribooms',
               'af.stopwords': 'stopwords_iso',
               'af.stopwords.iso': 'stopwords_iso'},
        'als': {'als.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'am': {'am.embed.am_roberta': 'roberta_embeddings_am_roberta',
               'am.embed.w2v_cc_300d': 'w2v_cc_300d',
               'am.embed.xlm_roberta': 'xlm_roberta_base_finetuned_amharic',
               'am.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_amharic',
               'am.lemma': 'lemma',
               'am.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_xlm_roberta_base_finetuned_amharic_finetuned_ner_amharic',
               'am.ner.xlmr_roberta.base_finetuned_amharic.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_ner_amharic',
               'am.ner.xlmr_roberta.base_finetuned_swahili_amharic.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_swahili_finetuned_ner_amharic',
               'am.pos': 'pos_ud_att',
               'am.stopwords': 'stopwords_iso'},
        'an': {'an.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ar': {'ar.answer_question.arabert.v2': 'bert_qa_arabert_v2',
               'ar.answer_question.bert': 'bert_qa_arap_qa_bert',
               'ar.answer_question.bert.cased_multilingual_base': 'bert_qa_multilingual_bert_base_cased_arabic',
               'ar.answer_question.bert.large_v2': 'bert_qa_arap_qa_bert_large_v2',
               'ar.answer_question.bert.squad_arcd.finetuned': 'bert_qa_arabert_finetuned_arcd',
               'ar.answer_question.bert.v2': 'bert_qa_arap_qa_bert_v2',
               'ar.answer_question.electra': 'electra_qa_AraELECTRA_discriminator_SOQAL',
               'ar.answer_question.squad_arcd.electra': 'electra_qa_araElectra_SQUAD_ARCD',
               'ar.answer_question.squad_arcd.electra.768d': 'electra_qa_araElectra_SQUAD_ARCD_768',
               'ar.answer_question.squad_arcd.electra.base': 'electra_qa_AraElectra_base_finetuned_ARCD',
               'ar.answer_question.tydiqa.electra.base': 'electra_qa_ara_base_artydiqa',
               'ar.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_arabic',
               'ar.answer_question.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_arabic_qa',
               'ar.classify.bert': 'bert_classifier_arabic_marbert_dialect_identification_city',
               'ar.classify.bert.base': 'bert_classifier_bert_base_arabic_camelbert_ca_poetry',
               'ar.classify.bert.base_finetuned': 'bert_classifier_base_arabic_camel_mix_poetry_finetuned_qawaf',
               'ar.classify.bert.by_ammar_alhaj_ali': 'bert_classifier_arabic_marbert_poetry_classification',
               'ar.classify.bert.by_azizkh': 'bert_classifier_autotrain_j_multi_classification_1181044057',
               'ar.classify.bert.by_m47labs': 'bert_classifier_binary_classification_arabic',
               'ar.classify.bert.by_researchaccount': 'bert_classifier_sa_sub5',
               'ar.classify.bert.by_yah216': 'bert_classifier_poem_qafiyah_detection',
               'ar.classify.bert.hate.': 'bert_classifier_dehatebert_mono_arabic',
               'ar.classify.bert.news.': 'bert_classifier_arabic_marbert_news_article_classification',
               'ar.classify.bert.news.by_m47labs': 'bert_classifier_ara_multiclass_news',
               'ar.classify.bert.sentiment.': 'bert_classifier_arabic_marbert_sentiment',
               'ar.classify.bert.sentiment.base': 'bert_classifier_bert_base_arabic_camelbert_ca_sentiment',
               'ar.classify.bert.sentiment.base_da_sentiment.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_da_sentiment',
               'ar.classify.bert.sentiment.base_mix_sentiment.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_mix_sentiment',
               'ar.classify.bert.sentiment.base_msa_sentiment.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_msa_sentiment',
               'ar.classify.bert.twitter.base': 'bert_classifier_bert_base_arabic_camelbert_msa_did_madar_twitter5',
               'ar.classify.da_poetry.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_da_poetry',
               'ar.classify.mix_did_madar_corpus26.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_mix_did_madar_corpus26',
               'ar.classify.mix_did_madar_corpus6.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_mix_did_madar_corpus6',
               'ar.classify.mix_did_nadi.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_mix_did_nadi',
               'ar.classify.mix_poetry.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_mix_poetry',
               'ar.classify.msa_did_nadi.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_msa_did_nadi',
               'ar.classify.msa_poetry.bert.base.by_camel_lab': 'bert_classifier_bert_base_arabic_camelbert_msa_poetry',
               'ar.classify.poetry.bert.by_zenkri': 'bert_classifier_autotrain_arabic_poetry_by_subject_920730227',
               'ar.classify.poetry.v2.bert.by_zenkri': 'bert_classifier_autotrain_arabic_poetry_by_subject_920730230',
               'ar.embed': 'arabic_w2v_cc_300d',
               'ar.embed.AraBertMo_base_V1': 'bert_embeddings_AraBertMo_base_V1',
               'ar.embed.Ara_DialectBERT': 'bert_embeddings_Ara_DialectBERT',
               'ar.embed.DarijaBERT': 'bert_embeddings_DarijaBERT',
               'ar.embed.MARBERT': 'bert_embeddings_MARBERT',
               'ar.embed.MARBERTv2': 'bert_embeddings_MARBERTv2',
               'ar.embed.albert': 'albert_embeddings_albert_base_arabic',
               'ar.embed.albert_large_arabic': 'albert_embeddings_albert_large_arabic',
               'ar.embed.albert_xlarge_arabic': 'albert_embeddings_albert_xlarge_arabic',
               'ar.embed.aner': 'arabic_w2v_cc_300d',
               'ar.embed.aner.300d': 'arabic_w2v_cc_300d',
               'ar.embed.arabert_c19': 'bert_embeddings_arabert_c19',
               'ar.embed.arbert': 'bert_embeddings_ARBERT',
               'ar.embed.bert': 'bert_embeddings_arbert',
               'ar.embed.bert.base': 'bert_embeddings_base_arabert',
               'ar.embed.bert.base.by_asafaya': 'bert_embeddings_base_arabic',
               'ar.embed.bert.base.v1.by_aubmindlab': 'bert_embeddings_base_arabertv01',
               'ar.embed.bert.base.v2.by_aubmindlab': 'bert_embeddings_base_arabertv02',
               'ar.embed.bert.base_mix.by_camel_lab': 'bert_embeddings_base_arabic_camel_mix',
               'ar.embed.bert.base_msa.by_camel_lab': 'bert_embeddings_base_arabic_camel_msa',
               'ar.embed.bert.base_msa_eighth.by_camel_lab': 'bert_embeddings_base_arabic_camel_msa_eighth',
               'ar.embed.bert.base_msa_half.by_camel_lab': 'bert_embeddings_base_arabic_camel_msa_half',
               'ar.embed.bert.base_msa_quarter.by_camel_lab': 'bert_embeddings_base_arabic_camel_msa_quarter',
               'ar.embed.bert.base_msa_sixteenth.by_camel_lab': 'bert_embeddings_base_arabic_camel_msa_sixteenth',
               'ar.embed.bert.by_ubc_nlp': 'bert_embeddings_marbert',
               'ar.embed.bert.cased_base': 'bert_embeddings_base_ar_cased',
               'ar.embed.bert.large': 'bert_embeddings_large_arabertv02',
               'ar.embed.bert.large.by_asafaya': 'bert_embeddings_large_arabic',
               'ar.embed.bert.medium': 'bert_embeddings_medium_arabic',
               'ar.embed.bert.mini': 'bert_embeddings_mini_arabic',
               'ar.embed.bert.v2': 'bert_embeddings_marbertv2',
               'ar.embed.bert.v2_base': 'bert_embeddings_base_arabertv2',
               'ar.embed.bert.v2_large': 'bert_embeddings_large_arabertv2',
               'ar.embed.bert_base_arabert': 'bert_embeddings_bert_base_arabert',
               'ar.embed.bert_base_arabertv01': 'bert_embeddings_bert_base_arabertv01',
               'ar.embed.bert_base_arabertv02': 'bert_embeddings_bert_base_arabertv02',
               'ar.embed.bert_base_arabertv02_twitter': 'bert_embeddings_bert_base_arabertv02_twitter',
               'ar.embed.bert_base_arabertv2': 'bert_embeddings_bert_base_arabertv2',
               'ar.embed.bert_base_arabic': 'bert_embeddings_bert_base_arabic',
               'ar.embed.bert_base_arabic_camelbert_mix': 'bert_embeddings_bert_base_arabic_camelbert_mix',
               'ar.embed.bert_base_arabic_camelbert_msa': 'bert_embeddings_bert_base_arabic_camelbert_msa',
               'ar.embed.bert_base_arabic_camelbert_msa_eighth': 'bert_embeddings_bert_base_arabic_camelbert_msa_eighth',
               'ar.embed.bert_base_arabic_camelbert_msa_half': 'bert_embeddings_bert_base_arabic_camelbert_msa_half',
               'ar.embed.bert_base_arabic_camelbert_msa_quarter': 'bert_embeddings_bert_base_arabic_camelbert_msa_quarter',
               'ar.embed.bert_base_arabic_camelbert_msa_sixteenth': 'bert_embeddings_bert_base_arabic_camelbert_msa_sixteenth',
               'ar.embed.bert_base_qarib': 'bert_embeddings_bert_base_qarib',
               'ar.embed.bert_base_qarib60_1790k': 'bert_embeddings_bert_base_qarib60_1790k',
               'ar.embed.bert_base_qarib60_860k': 'bert_embeddings_bert_base_qarib60_860k',
               'ar.embed.bert_large_arabertv02': 'bert_embeddings_bert_large_arabertv02',
               'ar.embed.bert_large_arabertv02_twitter': 'bert_embeddings_bert_large_arabertv02_twitter',
               'ar.embed.bert_large_arabertv2': 'bert_embeddings_bert_large_arabertv2',
               'ar.embed.bert_large_arabic': 'bert_embeddings_bert_large_arabic',
               'ar.embed.bert_medium_arabic': 'bert_embeddings_bert_medium_arabic',
               'ar.embed.bert_mini_arabic': 'bert_embeddings_bert_mini_arabic',
               'ar.embed.cbow': 'arabic_w2v_cc_300d',
               'ar.embed.cbow.300d': 'arabic_w2v_cc_300d',
               'ar.embed.distilbert': 'distilbert_embeddings_distilbert_base_ar_cased',
               'ar.embed.dziribert': 'bert_embeddings_dziribert',
               'ar.embed.electra.base': 'electra_embeddings_araelectra_base_generator',
               'ar.embed.glove': 'arabic_w2v_cc_300d',
               'ar.embed.mbert_ar_c19': 'bert_embeddings_mbert_ar_c19',
               'ar.embed.multi_dialect_bert_base_arabic': 'bert_embeddings_multi_dialect_bert_base_arabic',
               'ar.lemma': 'lemma_padt',
               'ar.lemma.padt': 'lemma_padt',
               'ar.ner': 'aner_cc_300d',
               'ar.ner.ANER': 'bert_ner_ANER',
               'ar.ner.aner': 'aner_cc_300d',
               'ar.ner.arabert_ner': 'bert_ner_arabert_ner',
               'ar.ner.arabic_camelbert_da_ner': 'bert_ner_bert_base_arabic_camelbert_da_ner',
               'ar.ner.arabic_camelbert_mix_ner': 'bert_ner_bert_base_arabic_camelbert_mix_ner',
               'ar.ner.arabic_camelbert_msa_ner': 'bert_ner_bert_base_arabic_camelbert_msa_ner',
               'ar.ner.bert': 'bert_ner_arabic_ner',
               'ar.ner.bert.base': 'bert_ner_bert_base_arabic_camelbert_ca_ner',
               'ar.ner.bert.by_holako': 'bert_ner_ner_camelbert',
               'ar.ner.bert.wikiann.': 'bert_token_classifier_ara_ner',
               'ar.ner.multilingual_cased_ner_hrl': 'bert_ner_bert_base_multilingual_cased_ner_hrl',
               'ar.ner.pos.base': 'bert_pos_bert_base_arabic_camelbert_ca_pos_msa',
               'ar.ner.xlmr_roberta': 'xlmroberta_ner_lge_panx_dataset',
               'ar.ner.xlmr_roberta.base': 'xlmroberta_ner_base_panx_dataset',
               'ar.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_recipe',
               'ar.poem_meter.classify.bert.by_yah216': 'bert_classifier_arabic_poem_meter_3',
               'ar.poem_meter.classify.bert.v2.by_yah216': 'bert_classifier_arabic_poem_meter_classification',
               'ar.pos': 'pos_padt',
               'ar.pos.arabic_camelbert_ca_pos_egy': 'bert_pos_bert_base_arabic_camelbert_ca_pos_egy',
               'ar.pos.arabic_camelbert_ca_pos_glf': 'bert_pos_bert_base_arabic_camelbert_ca_pos_glf',
               'ar.pos.arabic_camelbert_da_pos_egy': 'bert_pos_bert_base_arabic_camelbert_da_pos_egy',
               'ar.pos.arabic_camelbert_da_pos_glf': 'bert_pos_bert_base_arabic_camelbert_da_pos_glf',
               'ar.pos.arabic_camelbert_da_pos_msa': 'bert_pos_bert_base_arabic_camelbert_da_pos_msa',
               'ar.pos.arabic_camelbert_mix_pos_egy': 'bert_pos_bert_base_arabic_camelbert_mix_pos_egy',
               'ar.pos.arabic_camelbert_mix_pos_glf': 'bert_pos_bert_base_arabic_camelbert_mix_pos_glf',
               'ar.pos.arabic_camelbert_mix_pos_msa': 'bert_pos_bert_base_arabic_camelbert_mix_pos_msa',
               'ar.pos.arabic_camelbert_msa_pos_egy': 'bert_pos_bert_base_arabic_camelbert_msa_pos_egy',
               'ar.pos.arabic_camelbert_msa_pos_glf': 'bert_pos_bert_base_arabic_camelbert_msa_pos_glf',
               'ar.pos.arabic_camelbert_msa_pos_msa': 'bert_pos_bert_base_arabic_camelbert_msa_pos_msa',
               'ar.pos.padt': 'pos_padt',
               'ar.stopwords': 'stopwords_iso',
               'ar.stopwords.iso': 'stopwords_iso'},
        'arz': {'arz.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'as': {'as.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ast': {'ast.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'az': {'az.embed.w2v_cc_300d': 'w2v_cc_300d', 'az.stopwords': 'stopwords_iso'},
        'azb': {'azb.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ba': {'ba.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ba.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_bashkir_cv7_opt',
               'ba.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_bashkir_cv7_opt_gpu'},
        'bar': {'bar.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'bcl': {'bcl.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'be': {'be.embed.w2v_cc_300d': 'w2v_cc_300d',
               'be.lemma': 'lemma_hse',
               'be.pos': 'pos_hse',
               'be.pos.hse': 'pos_hse'},
        'bem': {
            'bem.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xls_r_1b_bemba_fds',
            'bem.speech2text.wav2vec_xlsr.v2_large.by_csikasote': 'asr_wav2vec2_large_xlsr_bemba',
            'bem.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_bemba_fds',
            'bem.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_bemba_fds_gpu',
            'bem.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xls_r_1b_bemba_fds_gpu',
            'bem.speech2text.wav2vec_xlsr.v2_large_gpu.by_csikasote': 'asr_wav2vec2_large_xlsr_bemba_gpu'},
        'bg': {'bg.embed.bert.cased_base': 'bert_embeddings_base_bg_cased',
               'bg.embed.roberta.base': 'roberta_embeddings_base_bulgarian',
               'bg.embed.roberta.small': 'roberta_embeddings_small_bulgarian',
               'bg.embed.w2v_cc_300d': 'w2v_cc_300d',
               'bg.lemma': 'lemma',
               'bg.lemma.btb': 'lemma_btb',
               'bg.pos': 'pos_btb',
               'bg.pos.ud_btb': 'pos_ud_btb',
               'bg.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_d2',
               'bg.speech2text.wav2vec_xlsr.v2_large_300m_d2_gpu': 'asr_wav2vec2_large_xls_r_300m_d2_gpu',
               'bg.stopwords': 'stopwords_iso',
               'bg.stopwords.iso': 'stopwords_iso'},
        'bh': {'bh.embed.w2v_cc_300d': 'w2v_cc_300d',
               'bh.lemma': 'lemma',
               'bh.pos': 'pos_ud_bhtb'},
        'bn': {
            'bn.answer_question.tydiqa.multi_lingual_bert': 'bert_qa_mbert_bengali_tydiqa_qa',
            'bn.classify.roberta': 'roberta_classifier_autotrain_citizen_nlu_bn_1370652766',
            'bn.embed': 'bengali_cc_300d',
            'bn.embed.bangala_bert': 'bert_embeddings_bangla_bert_base',
            'bn.embed.bangla_bert': 'bert_embeddings_bangla_bert',
            'bn.embed.bert': 'bert_embeddings_indic_transformers',
            'bn.embed.bert.base': 'bert_embeddings_bangla_base',
            'bn.embed.distil_bert': 'distilbert_embeddings_indic_transformers',
            'bn.embed.glove': 'bengali_cc_300d',
            'bn.embed.indic_transformers_bn_bert': 'bert_embeddings_indic_transformers_bn_bert',
            'bn.embed.indic_transformers_bn_distilbert': 'distilbert_embeddings_indic_transformers_bn_distilbert',
            'bn.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
            'bn.embed.roberta': 'roberta_embeddings_indic_transformers',
            'bn.embed.w2v_cc_300d': 'w2v_cc_300d',
            'bn.embed.xlmr_roberta': 'xlmroberta_embeddings_indic_transformers_bn_xlmroberta',
            'bn.lemma': 'lemma',
            'bn.ner': 'bengaliner_cc_300d',
            'bn.ner.glove': 'ner_jifs_glove_840B_300d',
            'bn.ner.jifs': 'ner_jifs_glove_840B_300d',
            'bn.pos': 'pos_msri',
            'bn.stopwords': 'stopwords_iso',
            'bn.stopwords.iso': 'stopwords_iso'},
        'bo': {'bo.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'bpy': {'bpy.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'br': {'br.embed.w2v_cc_300d': 'w2v_cc_300d',
               'br.lemma': 'lemma',
               'br.pos': 'pos_ud_keb',
               'br.stopwords': 'stopwords_br'},
        'bs': {'bs.detect_sentence': 'sentence_detector_dl',
               'bs.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ca': {
            'ca.answer_question.roberta.base_cased': 'roberta_qa_roberta_base_ca_cased_qa',
            'ca.answer_question.roberta.cased_base': 'roberta_qa_base_ca_cased',
            'ca.answer_question.roberta.cased_v2_base': 'roberta_qa_base_ca_v2_cased',
            'ca.answer_question.roberta.squad.base': 'roberta_qa_roberta_base_squad',
            'ca.classify.roberta.base_finetuned': 'roberta_classifier_base_ca_finetuned_cyberbullying_catalan',
            'ca.classify.roberta.base_finetuned.by_jonatangk': 'roberta_classifier_base_ca_finetuned_tecla',
            'ca.classify.roberta.cased_base': 'roberta_classifier_base_ca_sts_cased',
            'ca.classify.roberta.cased_base.tc.by_projecte_aina': 'roberta_classifier_base_ca_tc_cased',
            'ca.classify.roberta.cased_base.te.by_projecte_aina': 'roberta_classifier_base_ca_te_cased',
            'ca.classify.roberta.cased_v2_base': 'roberta_classifier_base_ca_v2_sts_cased',
            'ca.classify.roberta.cased_v2_base.tc.by_projecte_aina': 'roberta_classifier_base_ca_v2_tc_cased',
            'ca.classify.roberta.cased_v2_base.te.by_projecte_aina': 'roberta_classifier_base_ca_v2_te_cased',
            'ca.classify.roberta.catalonia_independence.base_finetuned': 'roberta_classifier_base_ca_finetuned_catalonia_independence_detector',
            'ca.embed.w2v_cc_300d': 'w2v_cc_300d',
            'ca.lemma': 'lemma_spacylookup',
            'ca.lemma.ancora': 'lemma_ancora',
            'ca.lemma.spacylookup': 'lemma_spacylookup',
            'ca.ner.pos.universal_dependencies.': 'roberta_pos_veganuary_pos',
            'ca.ner.roberta.cased_base': 'roberta_ner_roberta_base_ca_cased_ner',
            'ca.pos': 'pos_ud_ancora',
            'ca.pos.ancora': 'pos_ancora',
            'ca.speech2text.wav2vec2.voxpopuli.v2_large': 'asr_wav2vec2_large_100k_voxpopuli_catala_by_ccoreilly',
            'ca.speech2text.wav2vec2.voxpopuli.v2_large.by_softcatala': 'asr_wav2vec2_large_100k_voxpopuli_catala_by_softcatala',
            'ca.speech2text.wav2vec2.voxpopuli.v2_large_gpu': 'asr_wav2vec2_large_100k_voxpopuli_catala_by_ccoreilly_gpu',
            'ca.speech2text.wav2vec2.voxpopuli.v2_large_gpu.by_softcatala': 'asr_wav2vec2_large_100k_voxpopuli_catala_by_softcatala_gpu',
            'ca.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_catalan',
            'ca.stopwords': 'stopwords_iso',
            'ca.stopwords.iso': 'stopwords_iso'},
        'ce': {'ce.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ce.ner.bert.conll.finetuned': 'bert_ner_ce_bert_finetuned_ner'},
        'ceb': {'ceb.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ch': {'ch.answer_question.roberta': 'roberta_qa_addi_ch_roberta',
               'ch.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_CH_XLM_R'},
        'ckb': {},
        'co': {'co.embed.roberta.small': 'roberta_embeddings_codeberta_small_v1',
               'co.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'cop': {'cop.lemma': 'lemma_scriptorium',
                'cop.lemma.scriptorium': 'lemma_scriptorium',
                'cop.pos': 'pos_scriptorium'},
        'cs': {'cs.embed.bert': 'bert_embeddings_fernet_c5',
               'cs.embed.roberta.news.': 'roberta_embeddings_fernet_news',
               'cs.embed.w2v_cc_300d': 'w2v_cc_300d',
               'cs.lemma': 'lemma_cltt',
               'cs.lemma.cac': 'lemma_cac',
               'cs.lemma.cltt': 'lemma_cltt',
               'cs.lemma.fictree': 'lemma_fictree',
               'cs.lemma.pdt': 'lemma_pdt',
               'cs.lemma.spacylookup': 'lemma_spacylookup',
               'cs.pos': 'pos_fictree',
               'cs.pos.cac': 'pos_cac',
               'cs.pos.cltt': 'pos_cltt',
               'cs.pos.fictree': 'pos_fictree',
               'cs.pos.pdt': 'pos_pdt',
               'cs.pos.ud_pdt': 'pos_ud_pdt',
               'cs.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m_250',
               'cs.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_250_gpu',
               'cs.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_czech',
               'cs.speech2text.wav2vec_xlsr.v2_large.by_arampacha': 'asr_wav2vec2_large_xlsr_czech',
               'cs.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_czech_gpu',
               'cs.stopwords': 'stopwords_iso',
               'cs.stopwords.iso': 'stopwords_iso'},
        'cu': {'cu.lemma': 'lemma_proiel',
               'cu.lemma.proiel': 'lemma_proiel',
               'cu.pos': 'pos_proiel'},
        'cv': {'cv.answer_question.roberta': 'roberta_qa_cv_custom_ds',
               'cv.answer_question.roberta.by_sunitha': 'roberta_qa_cv_merge_ds',
               'cv.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'cy': {'cy.embed.w2v_cc_300d': 'w2v_cc_300d',
               'cy.lemma': 'lemma',
               'cy.lemma.ccg': 'lemma_ccg',
               'cy.pos.ccg': 'pos_ccg'},
        'da': {'da.answer_question.squad.bert': 'bert_qa_danish_bert_botxo_qa_squad',
               'da.answer_question.squad.xlmr_roberta.base': 'xlm_roberta_qa_xlmr_base_texas_squad_da_da_saattrupdan',
               'da.classify.bert': 'bert_classifier_analytical',
               'da.classify.bert.by_larskjeldgaard': 'bert_classifier_larskjeldgaard_senda',
               'da.classify.bert.by_nikolajmunch': 'bert_classifier_danish_emotion_classification',
               'da.classify.bert.by_pin': 'bert_classifier_pin_senda',
               'da.classify.bert.go_emotions.': 'bert_classifier_da_hyggebert',
               'da.classify.bert.hate.': 'bert_classifier_da_hatespeech_classification',
               'da.classify.bert.hate.by_danlp': 'bert_classifier_da_hatespeech_detection',
               'da.classify.bert.sentiment.': 'bert_sequence_classifier_sentiment',
               'da.classify.bert.sentiment.by_danlp': 'bert_classifier_da_tone_sentiment_polarity',
               'da.classify.bert.twitter.': 'bert_classifier_da_tone_subjective_objective',
               'da.classify.emotion.bert.by_danlp': 'bert_classifier_da_emotion_classification',
               'da.classify.emotion_binary.bert.by_danlp': 'bert_classifier_da_emotion_binary',
               'da.classify.xlmr_roberta': 'xlmroberta_classifier_da_xlmr_ned',
               'da.embed.bert.cased_base': 'bert_embeddings_base_da_cased',
               'da.embed.w2v_cc_300d': 'w2v_cc_300d',
               'da.lemma': 'lemma_spacylookup',
               'da.lemma.ddt': 'lemma_ddt',
               'da.lemma.spacylookup': 'lemma_spacylookup',
               'da.ner': 'dane_ner_6B_100',
               'da.ner.6B_100D': 'dane_ner_6B_100',
               'da.ner.6B_300D': 'dane_ner_6B_300',
               'da.ner.840B_300D': 'dane_ner_840B_300',
               'da.ner.bert': 'bert_ner_da_bert_ner',
               'da.ner.bert.by_maltehb': 'bert_ner_danish_bert_botxo_ner_dane',
               'da.ner.pos': 'bert_pos_bert_punct_restoration_da_alvenir',
               'da.ner.xlmr_roberta': 'xlmroberta_ner_employment_contract_ner',
               'da.pos': 'pos_ud_ddt',
               'da.pos.ddt': 'pos_ddt',
               'da.speech2text.wav2vec2.v2_base': 'asr_alvenir_wav2vec2_base_nst_cv9',
               'da.speech2text.wav2vec2.v2_base.by_alvenir': 'asr_wav2vec2_base_nst',
               'da.speech2text.wav2vec2.v2_base_gpu': 'asr_wav2vec2_base_nst_gpu',
               'da.speech2text.wav2vec_xlsr.300m': 'asr_xls_r_300m_danish_nst_cv9',
               'da.speech2text.wav2vec_xlsr.300m.by_chcaa': 'asr_xls_r_300m_nst_cv9',
               'da.speech2text.wav2vec_xlsr.300m_gpu': 'asr_xls_r_300m_nst_cv9_gpu',
               'da.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m_ftspeech',
               'da.stopwords': 'stopwords_iso'},
        'de': {'de.answer_question.bert': 'bert_qa_GBERTQnA',
               'de.answer_question.bert.cased_multilingual_base': 'bert_qa_multilingual_bert_base_cased_german',
               'de.answer_question.electra': 'electra_qa_German_question_answer',
               'de.answer_question.electra.base': 'electra_qa_g_base_germanquad',
               'de.answer_question.electra.distilled_base': 'electra_qa_g_base_germanquad_distilled',
               'de.answer_question.electra.large': 'electra_qa_g_large_germanquad',
               'de.answer_question.roberta': 'roberta_qa_addi_de_roberta',
               'de.answer_question.squad_de_tuned.xlmr_roberta.base.by_saattrupdan': 'xlm_roberta_qa_xlmr_base_texas_squad_de_de_saattrupdan',
               'de.answer_question.squad_spanish_tuned.xlmr_roberta.base.by_saattrupdan': 'xlm_roberta_qa_xlmr_base_texas_squad_es_es_saattrupdan',
               'de.answer_question.squadv2.bert': 'bert_qa_bert_multi_english_german_squad2',
               'de.answer_question.squadv2.electra.base': 'electra_qa_base_squad2',
               'de.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_DE_XLM_R',
               'de.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_german',
               'de.classify.bert': 'bert_classifier_autonlp_doctor_de_24595545',
               'de.classify.bert.base': 'bert_classifier_gbert_base_germandpr_reranking',
               'de.classify.bert.base_finetuned': 'bert_classifier_gbert_base_finetuned_cefr',
               'de.classify.bert.by_muhtasham': 'bert_classifier_autonlp_doctor_de_24595546',
               'de.classify.bert.cased_base': 'bert_classifier_bert_base_german_cased_german_hotel_classification',
               'de.classify.bert.cased_base.by_mathking': 'bert_classifier_bert_base_german_cased_gnad10',
               'de.classify.bert.hate.': 'bert_classifier_dehatebert_mono_german',
               'de.classify.bert.hate.cased_base': 'bert_classifier_base_german_cased_hatespeech_germeval18coarse',
               'de.classify.bert.large': 'bert_classifier_gbert_large_jobad_classification_34',
               'de.classify.bert.multi2convai.': 'bert_classifier_multi2convai_corona',
               'de.classify.bert.news_sentiment.': 'bert_classifier_german_news_sentiment',
               'de.classify.bert.pawsx_xtreme.cased_base_finetuned': 'bert_sequence_classifier_base_german_dbmdz_cased_finetuned_pawsx',
               'de.classify.bert.sentiment.': 'bert_sequence_classifier_sentiment',
               'de.classify.bert.sentiment.by_oliverguhr': 'bert_classifier_german_sentiment',
               'de.classify.bert.sentiment.cased_base': 'bert_classifier_bert_base_german_cased_german_hotel_sentiment',
               'de.classify.bert.sentiment.cased_base.by_deepset': 'bert_classifier_base_german_cased_sentiment_germeval17',
               'de.classify.bert.sentiment_twitter.': 'bert_classifier_german_sentiment_twitter',
               'de.classify.bert.uncased_base': 'bert_classifier_bert_base_uncased_german_multilable_classification',
               'de.classify.distil_bert': 'distilbert_sequence_classifier_autonlp_doctor_de_24595544',
               'de.classify.distil_bert.base': 'distilbert_base_sequence_classifier_toxicity',
               'de.classify.distil_bert.base.by_ml6team': 'distilbert_sequence_classifier_cross_encoder_mmarco_german_distilbert_base',
               'de.classify.distil_bert.cased_base': 'distilbert_sequence_classifier_distilbert_base_german_cased_toxic_comments',
               'de.classify.gewerke.bert.by_cm_mueller': 'bert_classifier_bacnet_klassifizierung_gewerke',
               'de.classify.heizungstechnik.bert.by_cm_mueller': 'bert_classifier_bacnet_klassifizierung_heizungstechnik',
               'de.classify.kaeltettechnik.bert.by_cm_mueller': 'bert_classifier_bacnet_klassifizierung_kaeltettechnik',
               'de.classify.logistics.bert.multi2convai.by_inovex': 'bert_classifier_multi2convai_logistics',
               'de.classify.news': 'classifierdl_bert_news',
               'de.classify.news_sentiment.bert': 'bert_sequence_classifier_news_sentiment',
               'de.classify.quality.bert.multi2convai.by_inovex': 'bert_classifier_multi2convai_quality',
               'de.classify.raumlufttechnik.bert.by_cm_mueller': 'bert_classifier_bacnet_klassifizierung_raumlufttechnik',
               'de.classify.roberta': 'roberta_classifier_autonlp_doctor_de_24595548',
               'de.classify.sanitaertechnik.bert.by_cm_mueller': 'bert_classifier_bacnet_klassifizierung_sanitaertechnik',
               'de.classify.sentiment.bert': 'classifierdl_bert_sentiment',
               'de.embed.albert_german_ner': 'albert_embeddings_albert_german_ner',
               'de.embed.bert': 'bert_base_german_cased',
               'de.embed.bert.base': 'bert_embeddings_g_base',
               'de.embed.bert.by_smanjil': 'bert_embeddings_german_medbert',
               'de.embed.bert.cased_base': 'bert_embeddings_base_de_cased',
               'de.embed.bert.cased_base.by_dbmdz': 'bert_embeddings_dbmdz_base_german_cased',
               'de.embed.bert.cased_base.by_uploaded by huggingface': 'bert_embeddings_base_german_cased',
               'de.embed.bert.finance': 'bert_sentence_embeddings_financial',
               'de.embed.bert.large': 'bert_embeddings_g_large',
               'de.embed.bert.uncased': 'bert_base_german_uncased',
               'de.embed.bert.uncased_base': 'bert_embeddings_base_german_uncased',
               'de.embed.bert_base_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
               'de.embed.bert_base_de_cased': 'bert_embeddings_bert_base_de_cased',
               'de.embed.bert_base_german_cased_oldvocab': 'bert_embeddings_bert_base_german_cased_oldvocab',
               'de.embed.bert_base_german_dbmdz_cased': 'bert_embeddings_bert_base_german_dbmdz_cased',
               'de.embed.bert_base_german_dbmdz_uncased': 'bert_embeddings_bert_base_german_dbmdz_uncased',
               'de.embed.bert_base_german_uncased': 'bert_embeddings_bert_base_german_uncased',
               'de.embed.bert_base_historical_german_rw_cased': 'bert_embeddings_bert_base_historical_german_rw_cased',
               'de.embed.distilbert_base_de_cased': 'distilbert_embeddings_distilbert_base_de_cased',
               'de.embed.distilbert_base_german_cased': 'distilbert_embeddings_distilbert_base_german_cased',
               'de.embed.electra.base': 'electra_embeddings_gelectra_base_generator',
               'de.embed.electra.cased_base_64d': 'electra_embeddings_electra_base_gc4_64k_0_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_100000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_100000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_1000000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_1000000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_200000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_200000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_300000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_300000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_400000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_400000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_500000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_500000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_600000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_600000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_700000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_700000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_800000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_800000_cased_generator',
               'de.embed.electra.cased_base_gc4_64k_900000.by_stefan_it': 'electra_embeddings_electra_base_gc4_64k_900000_cased_generator',
               'de.embed.electra.large': 'electra_embeddings_gelectra_large_generator',
               'de.embed.gbert_base': 'bert_embeddings_gbert_base',
               'de.embed.gbert_large': 'bert_embeddings_gbert_large',
               'de.embed.german_financial_statements_bert': 'bert_embeddings_german_financial_statements_bert',
               'de.embed.medbert': 'bert_embeddings_German_MedBERT',
               'de.embed.roberta': 'roberta_embeddings_hotelbert',
               'de.embed.roberta.small': 'roberta_embeddings_hotelbert_small',
               'de.embed.roberta_base_wechsel_german': 'roberta_embeddings_roberta_base_wechsel_german',
               'de.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
               'de.lemma': 'lemma_spacylookup',
               'de.lemma.gsd': 'lemma_gsd',
               'de.lemma.hdt': 'lemma_hdt',
               'de.lemma.spacylookup': 'lemma_spacylookup',
               'de.ner': 'wikiner_840B_300',
               'de.ner.bert': 'bert_ner_bert_de_ner',
               'de.ner.bert.base': 'bert_ner_gbert_base_germaner',
               'de.ner.bert.base_finetuned': 'bert_token_classifier_base_german_finetuned_ler',
               'de.ner.bert.by_elenanereiss': 'bert_token_classifier_german_ler',
               'de.ner.bert.by_severinsimmler': 'bert_ner_german_press_bert',
               'de.ner.bert.by_tariqyousef': 'bert_ner_german_intensifiers_tagging',
               'de.ner.bert.by_vera_pro': 'bert_ner_bert_mention_de_vera_pro',
               'de.ner.bert.cased_base': 'bert_ner_bert_base_german_cased_20000_ner',
               'de.ner.bert.cased_base.by_domischwimmbeck': 'bert_ner_bert_base_german_cased_fine_tuned_ner',
               'de.ner.bert.large': 'bert_ner_gbert_large_germaner',
               'de.ner.bert.legal': 'bert_token_classifier_ner_legal',
               'de.ner.bert.own_data.cased_base.by_domischwimmbeck': 'bert_ner_bert_base_german_cased_own_data_ner',
               'de.ner.bert.uncased_base': 'bert_ner_bert_base_german_cased_20000_ner_uncased',
               'de.ner.distil_bert.cased_base': 'distilbert_ner_distilbert_base_german_europeana_cased_germeval_14',
               'de.ner.literary.bert.by_severinsimmler': 'bert_ner_literary_german_bert',
               'de.ner.pos': 'bert_pos_bert_punct_restoration_de_alvenir',
               'de.ner.pos.universal_dependencies.base': 'bert_pos_bert_base_german_upos',
               'de.ner.pos.universal_dependencies.large': 'bert_pos_bert_large_german_upos',
               'de.ner.wikiner': 'wikiner_840B_300',
               'de.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
               'de.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
               'de.ner.xlm': 'xlm_roberta_large_token_classifier_conll03',
               'de.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_atlantis_base_finetuned_panx',
               'de.ner.xlmr_roberta.base_finetuned.by_evs': 'xlmroberta_ner_evs_base_finetuned_panx',
               'de.ner.xlmr_roberta.base_finetuned.by_xugenpeng': 'xlmroberta_ner_xugenpeng_base_finetuned_panx',
               'de.ner.xlmr_roberta.conll.large_finetuned': 'xlmroberta_ner_xlm_roberta_large_finetuned_conll03_german',
               'de.ner.xlmr_roberta.large': 'xlmroberta_ner_gpt2_large_detector_de_v1',
               'de.ner.xlmr_roberta.xtreme.base_finetuned': 'xlmroberta_ner_akshat_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_ArneD': 'xlmroberta_ner_arned_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_Cole': 'xlmroberta_ner_cole_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_KayKozaronek': 'xlmroberta_ner_kaykozaronek_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_Leizhang': 'xlmroberta_ner_leizhang_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_ManqingLiu': 'xlmroberta_ner_manqingliu_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_Neha2608': 'xlmroberta_ner_neha2608_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_Ninh': 'xlmroberta_ner_ninh_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_Rgl73': 'xlmroberta_ner_rgl73_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_SelamatPagi': 'xlmroberta_ner_selamatpagi_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_SimulSt': 'xlmroberta_ner_simulst_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_V3RX2000': 'xlmroberta_ner_v3rx2000_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_andyjennings': 'xlmroberta_ner_andyjennings_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_ardallie': 'xlmroberta_ner_ardallie_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_arrandi': 'xlmroberta_ner_arrandi_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_aytugkaya': 'xlmroberta_ner_aytugkaya_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_be4rr': 'xlmroberta_ner_be4rr_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_cj_mills': 'xlmroberta_ner_cj_mills_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_claytonsamples': 'xlmroberta_ner_claytonsamples_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_clisi2000': 'xlmroberta_ner_clisi2000_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_coolzhao': 'xlmroberta_ner_coolzhao_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_danhsf': 'xlmroberta_ner_danhsf_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_davidenam': 'xlmroberta_ner_davinam_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_dfsj': 'xlmroberta_ner_dfsj_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_dkasti': 'xlmroberta_ner_dkasti_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_edwardjross': 'xlmroberta_ner_edwardjross_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_ericklerouge123': 'xlmroberta_ner_ericklerouge123_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_flood': 'xlmroberta_ner_flood_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_furyhawk': 'xlmroberta_ner_furyhawk_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_fvector': 'xlmroberta_ner_fvector_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_gbennett': 'xlmroberta_ner_gbennett_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_hadxu': 'xlmroberta_ner_hadxu_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_haesun': 'xlmroberta_ner_haesun_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_harish3110': 'xlmroberta_ner_harish3110_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_hugsao123': 'xlmroberta_ner_hugsao123_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_iis2009002': 'xlmroberta_ner_iis2009002_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_imyday': 'xlmroberta_ner_imyday_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jamesmarcel': 'xlmroberta_ner_jamesmarcel_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jamie613': 'xlmroberta_ner_jamie613_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jasonyim2': 'xlmroberta_ner_jasonyim2_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jdang': 'xlmroberta_ner_jdang_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jdeboever': 'xlmroberta_ner_jboever_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jgriffi': 'xlmroberta_ner_jgriffi_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_jonfrank': 'xlmroberta_ner_jonfrank_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_k3nneth': 'xlmroberta_ner_k3nneth_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_leixu': 'xlmroberta_ner_leixu_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_lijingxin': 'xlmroberta_ner_lijingxin_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_mertyrgn': 'xlmroberta_ner_mertyrgn_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_miyagawaorj': 'xlmroberta_ner_miyagawaorj_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_moghis': 'xlmroberta_ner_base_finetuned_panx_de_data',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_mubikan': 'xlmroberta_ner_mubikan_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_naam': 'xlmroberta_ner_naam_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_naomiyjchen': 'xlmroberta_ner_naomiyjchen_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_netoass': 'xlmroberta_ner_netoass_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_novarac23': 'xlmroberta_ner_novarac23_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_olpa': 'xlmroberta_ner_olpa_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_osanseviero': 'xlmroberta_ner_osanseviero_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_pdroberts': 'xlmroberta_ner_pdroberts_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_pglauner': 'xlmroberta_ner_pglauner_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_pitspits': 'xlmroberta_ner_pitspits_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_radev': 'xlmroberta_ner_rav_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_rishav_hub': 'xlmroberta_ner_rishav_hub_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_rishiyoung': 'xlmroberta_ner_rishiyoung_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_robkayinto': 'xlmroberta_ner_robkayinto_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_skr3178': 'xlmroberta_ner_skr3178_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_transformersbook': 'xlmroberta_ner_transformersbook_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_venturaville': 'xlmroberta_ner_venturaville_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_victen': 'xlmroberta_ner_victen_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_xliu128': 'xlmroberta_ner_xliu128_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_yomexa': 'xlmroberta_ner_yomexa_base_finetuned_panx',
               'de.ner.xlmr_roberta.xtreme.base_finetuned.by_zdepablo': 'xlmroberta_ner_zpablo_base_finetuned_panx',
               'de.pos': 'pos_ud_hdt',
               'de.pos.gsd': 'pos_gsd',
               'de.pos.hdt': 'pos_hdt',
               'de.pos.ud_hdt': 'pos_ud_hdt',
               'de.speech2text.wav2vec2.v2_base': 'asr_wav2vec2_base_german',
               'de.speech2text.wav2vec2.v2_base.by_oliverguhr': 'asr_wav2vec2_base_german_cv9',
               'de.speech2text.wav2vec2.v2_base_gpu': 'asr_wav2vec2_base_german_cv9_gpu',
               'de.speech2text.wav2vec2.v2_base_gpu.by_aware_ai': 'asr_wav2vec2_base_german_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s103_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s103_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s377_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s377_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s37_exp': 'asr_exp_w2v2t_r_wav2vec2_s37_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s3_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s3_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s445_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_8_austria_2_s445_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s460_exp': 'asr_exp_w2v2t_r_wav2vec2_s460_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s466_exp': 'asr_exp_w2v2t_r_wav2vec2_s466_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s468_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s468_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s527_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s527_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s545_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s545_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s627_vp_exp': 'asr_exp_w2v2t_vp_100k_s627_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s732_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s732_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s756_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s756_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s779_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s779_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s803_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s803_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s957_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s957_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s95_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s95_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s962_vp_exp': 'asr_exp_w2v2t_vp_s962_gpu',
               'de.speech2text.wav2vec2.v2_gpu_s982_exp': 'asr_exp_w2v2t_wav2vec2_s982_gpu',
               'de.speech2text.wav2vec2.v2_s103_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s103',
               'de.speech2text.wav2vec2.v2_s184_vp_exp': 'asr_exp_w2v2t_vp_s184',
               'de.speech2text.wav2vec2.v2_s377_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s377',
               'de.speech2text.wav2vec2.v2_s37_exp': 'asr_exp_w2v2t_r_wav2vec2_s37',
               'de.speech2text.wav2vec2.v2_s3_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s3',
               'de.speech2text.wav2vec2.v2_s445_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_8_austria_2_s445',
               'de.speech2text.wav2vec2.v2_s460_exp': 'asr_exp_w2v2t_r_wav2vec2_s460',
               'de.speech2text.wav2vec2.v2_s466_exp': 'asr_exp_w2v2t_r_wav2vec2_s466',
               'de.speech2text.wav2vec2.v2_s468_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s468',
               'de.speech2text.wav2vec2.v2_s527_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s527',
               'de.speech2text.wav2vec2.v2_s545_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s545',
               'de.speech2text.wav2vec2.v2_s627_vp_exp': 'asr_exp_w2v2t_vp_100k_s627',
               'de.speech2text.wav2vec2.v2_s732_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s732',
               'de.speech2text.wav2vec2.v2_s756_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s756',
               'de.speech2text.wav2vec2.v2_s779_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s779',
               'de.speech2text.wav2vec2.v2_s803_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s803',
               'de.speech2text.wav2vec2.v2_s946_vp_exp': 'asr_exp_w2v2t_vp_s946',
               'de.speech2text.wav2vec2.v2_s957_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s957',
               'de.speech2text.wav2vec2.v2_s95_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s95',
               'de.speech2text.wav2vec2.v2_s962_vp_exp': 'asr_exp_w2v2t_vp_s962',
               'de.speech2text.wav2vec2.v2_s982_exp': 'asr_exp_w2v2t_wav2vec2_s982',
               'de.speech2text.wav2vec_xlsr.gender_male_female.v2_gpu_s204_exp': 'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s204_gpu',
               'de.speech2text.wav2vec_xlsr.gender_male_female.v2_gpu_s896_exp': 'asr_exp_w2v2r_xls_r_gender_male_5_female_5_s896_gpu',
               'de.speech2text.wav2vec_xlsr.gender_male_female.v2_s204_exp': 'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s204',
               'de.speech2text.wav2vec_xlsr.gender_male_female.v2_s896_exp': 'asr_exp_w2v2r_xls_r_gender_male_5_female_5_s896',
               'de.speech2text.wav2vec_xlsr.gender_male_female.v2_s922_exp': 'asr_exp_w2v2r_xls_r_gender_male_0_female_10_s922',
               'de.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m_english_by_aware_ai',
               'de.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_english_by_aware_ai_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s143_exp': 'asr_exp_w2v2t_xls_r_s143_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s350_exp': 'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s350_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s381_exp': 'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s381_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s412_exp': 'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s412_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s42_exp': 'asr_exp_w2v2r_xls_r_accent_germany_8_austria_2_s42_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s438_exp': 'asr_exp_w2v2t_xls_r_s438_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s458_exp': 'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s458_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s534_exp': 'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s534_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s543_exp': 'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s543_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s673_exp': 'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s673_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s728_exp': 'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s728_gpu',
               'de.speech2text.wav2vec_xlsr.v2_gpu_s886_exp': 'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s886_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_german_by_facebook',
               'de.speech2text.wav2vec_xlsr.v2_large.by_aware_ai': 'asr_wav2vec2_large_xlsr_53_german_with_lm',
               'de.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_german_by_jonatasgrosman',
               'de.speech2text.wav2vec_xlsr.v2_large.by_marcel': 'asr_wav2vec2_large_xlsr_53_german_by_marcel',
               'de.speech2text.wav2vec_xlsr.v2_large.by_maxidl': 'asr_wav2vec2_large_xlsr_german_by_maxidl',
               'de.speech2text.wav2vec_xlsr.v2_large.by_mehdihosseinimoghadam': 'asr_wav2vec2_large_xlsr_53_german',
               'de.speech2text.wav2vec_xlsr.v2_large.by_oliverguhr': 'asr_wav2vec2_large_xlsr_53_german_by_oliverguhr',
               'de.speech2text.wav2vec_xlsr.v2_large_cv8.by_oliverguhr': 'asr_wav2vec2_large_xlsr_53_german_cv8',
               'de.speech2text.wav2vec_xlsr.v2_large_cv8_gpu.by_oliverguhr': 'asr_wav2vec2_large_xlsr_53_german_cv8_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large_cv9.by_oliverguhr': 'asr_wav2vec2_large_xlsr_53_german_cv9',
               'de.speech2text.wav2vec_xlsr.v2_large_cv9_gpu.by_oliverguhr': 'asr_wav2vec2_large_xlsr_53_german_cv9_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_german_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large_gpu.by_facebook': 'asr_wav2vec2_large_xlsr_53_german_by_facebook_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large_gpu.by_marcel': 'asr_wav2vec2_large_xlsr_53_german_by_marcel_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large_gpu.by_maxidl': 'asr_wav2vec2_large_xlsr_german_by_maxidl_gpu',
               'de.speech2text.wav2vec_xlsr.v2_large_gpu.by_oliverguhr': 'asr_wav2vec2_large_xlsr_53_german_by_oliverguhr_gpu',
               'de.speech2text.wav2vec_xlsr.v2_s143_exp': 'asr_exp_w2v2t_xls_r_s143',
               'de.speech2text.wav2vec_xlsr.v2_s295_exp': 'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s295',
               'de.speech2text.wav2vec_xlsr.v2_s350_exp': 'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s350',
               'de.speech2text.wav2vec_xlsr.v2_s368_exp': 'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s368',
               'de.speech2text.wav2vec_xlsr.v2_s381_exp': 'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s381',
               'de.speech2text.wav2vec_xlsr.v2_s412_exp': 'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s412',
               'de.speech2text.wav2vec_xlsr.v2_s42_exp': 'asr_exp_w2v2r_xls_r_accent_germany_8_austria_2_s42',
               'de.speech2text.wav2vec_xlsr.v2_s438_exp': 'asr_exp_w2v2t_xls_r_s438',
               'de.speech2text.wav2vec_xlsr.v2_s458_exp': 'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s458',
               'de.speech2text.wav2vec_xlsr.v2_s534_exp': 'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s534',
               'de.speech2text.wav2vec_xlsr.v2_s543_exp': 'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s543',
               'de.speech2text.wav2vec_xlsr.v2_s673_exp': 'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s673',
               'de.speech2text.wav2vec_xlsr.v2_s728_exp': 'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s728',
               'de.speech2text.wav2vec_xlsr.v2_s886_exp': 'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s886',
               'de.speech2text.wav2vec_xlsr.v3_large.by_marcel': 'asr_wav2vec2_large_xlsr_german_demo',
               'de.stopwords': 'stopwords_iso',
               'de.stopwords.iso': 'stopwords_iso'},
        'diq': {'diq.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'dv': {
            'dv.classify.electra.news.small': 'electra_classifier_dv_small_news_classification',
            'dv.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'el': {'el.answer_question.bert': 'bert_qa_qacombination_bert_el_Danastos',
               'el.answer_question.bert.danastos': 'bert_qa_nq_bert_el_danastos',
               'el.answer_question.bert.news_sqa.': 'bert_qa_newsqa_bert_el_danastos',
               'el.answer_question.bert.news_sqa.by_danastos': 'bert_qa_newsqa_el_4',
               'el.answer_question.bert.squad.': 'bert_qa_squad_bert_el_danastos',
               'el.answer_question.bert.squad.v1.by_danastos': 'bert_qa_nq_squad_el_3',
               'el.answer_question.bert.squad.v2.by_danastos': 'bert_qa_nq_squad_el_4',
               'el.answer_question.bert.squad.v3.by_danastos': 'bert_qa_squad_el_4',
               'el.answer_question.bert.trivia.': 'bert_qa_triviaqa_bert_el_danastos',
               'el.answer_question.bert.trivia.by_danastos': 'bert_qa_triviaqa_el_4',
               'el.answer_question.bert_v1.by_danastos': 'bert_qa_nq_el_4',
               'el.answer_question.bert_v2.by_danastos': 'bert_qa_qacombination_el_4',
               'el.answer_question.bert_v3.by_danastos': 'bert_qa_qacombined_el_3',
               'el.answer_question.bert_v4.by_danastos': 'bert_qa_qacombined_el_4',
               'el.classify.roberta': 'roberta_classifier_mediawatch_el_topics',
               'el.classify.roberta.by_cvcio': 'roberta_classifier_comments_el_toxic',
               'el.embed.bert.base_uncased': 'bert_base_uncased',
               'el.embed.bert.cased_base': 'bert_embeddings_base_el_cased',
               'el.embed.bert.uncased_base': 'bert_embeddings_greeksocial_base_greek_uncased_v1',
               'el.embed.roberta.uncased_base': 'roberta_embeddings_palobert_base_greek_uncased_v1',
               'el.embed_sentence.bert.base_uncased': 'sent_bert_base_uncased',
               'el.lemma': 'lemma',
               'el.lemma.gdt': 'lemma_gdt',
               'el.pos': 'pos_ud_gdt',
               'el.pos.gdt': 'pos_gdt',
               'el.pos.ud_gdt': 'pos_ud_gdt',
               'el.speech2text.wav2vec2': 'asr_greek_lsr_1',
               'el.speech2text.wav2vec_xlsr.v2': 'asr_xlsr_53_wav2vec_greek',
               'el.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_greek_by_perelluis13',
               'el.speech2text.wav2vec_xlsr.v2_large.by_bagus': 'asr_wav2vec2_large_xlsr_bahasa_indonesia',
               'el.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_greek_by_jonatasgrosman',
               'el.speech2text.wav2vec_xlsr.v2_large.by_lighteternal': 'asr_wav2vec2_large_xlsr_53_greek_by_lighteternal',
               'el.speech2text.wav2vec_xlsr.v2_large.by_skylord': 'asr_wav2vec2_large_xlsr_greek_1',
               'el.speech2text.wav2vec_xlsr.v2_large.by_vasilis': 'asr_wav2vec2_large_xlsr_53_greek_by_vasilis',
               'el.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_greek_by_perelluis13_gpu',
               'el.speech2text.wav2vec_xlsr.v2_large_gpu.by_bagus': 'asr_wav2vec2_large_xlsr_bahasa_indonesia_gpu',
               'el.speech2text.wav2vec_xlsr.v2_large_gpu.by_lighteternal': 'asr_wav2vec2_large_xlsr_53_greek_by_lighteternal_gpu',
               'el.speech2text.wav2vec_xlsr.v2_large_gpu.by_skylord': 'asr_wav2vec2_large_xlsr_greek_1_gpu',
               'el.speech2text.wav2vec_xlsr.v3_large.by_skylord': 'asr_wav2vec2_large_xlsr_greek_2',
               'el.speech2text.wav2vec_xlsr.v3_large_gpu.by_skylord': 'asr_wav2vec2_large_xlsr_greek_2_gpu',
               'el.stopwords': 'stopwords_iso',
               'el.stopwords.iso': 'stopwords_iso'},
        'eml': {'eml.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'en': {
            'en.distilbert.zero_shot_classifier': 'distilbert_base_zero_shot_classifier_uncased_mnli',
            'en.classify_image.convnext.tiny': 'image_classifier_convnext_tiny_224_local',
            'en.bert.zero_shot_classifier': 'bert_base_cased_zero_shot_classifier_xnli',
            'en.roberta.zero_shot_classifier': 'roberta_base_zero_shot_classifier_nli',
            'en.seq2seq.distilbart_xsum_12_6': 'distilbart_xsum_12_6',
            'en.seq2seq.bart_large_cnn': 'bart_large_cnn',
            'en.seq2seq.distilbart_cnn_6_6': 'distilbart_cnn_6_6',
            'en.seq2seq.distilbart_cnn_12_6': 'distilbart_cnn_12_6',
            'en.seq2seq.distilbart_xsum_6_6': 'distilbart_xsum_6_6',
            'en.classify_image.swin.tiny': 'image_classifier_swin_tiny_patch4_window7_224',
            'en.speech2text.hubert': 'asr_hubert_large_ls960',
            'en.speech2text.hubert.large_ls960': 'asr_hubert_large_ls960',
            'en.albert': 'albert_base_uncased',
            'en.answer_qu estion.mqa_cls.bert.by_xraychen': 'bert_qa_mqa_cls',
            'en.answer_question.albert': 'albert_qa_generic',
            'en.answer_question.albert.by_AyushPJ': 'albert_qa_ai_club_inductions_21_nlp',
            'en.answer_question.albert.by_SalmanMo': 'albert_qa_QA_1e',
            'en.answer_question.albert.by_nlpunibo': 'albert_qa_nlpunibo',
            'en.answer_question.albert.by_rowan1224': 'albert_qa_slp',
            'en.answer_question.albert.by_saburbutt': 'albert_qa_generic',
            'en.answer_question.albert.xl': 'albert_qa_xlarge_finetuned',
            'en.answer_question.attribute_correction_mlm.bert.uncased_base.by_ksabeh': 'bert_qa_base_uncased_attribute_correction_mlm',
            'en.answer_question.attribute_correction_mlm_titles.bert.uncased_base.by_ksabeh': 'bert_qa_base_uncased_attribute_correction_mlm_titles',
            'en.answer_question.bert': 'bert_qa_no_need_to_name_this',
            'en.answer_question.bert.32d': 'bert_qa_bert_set_date_1_lr_2e_5_bs_32_ep_4',
            'en.answer_question.bert.abs': 'bert_qa_bertlargeabsa',
            'en.answer_question.bert.augmented': 'bert_qa_augmented',
            'en.answer_question.bert.base': 'bert_qa_bert_base_faquad',
            'en.answer_question.bert.base.by_peggyhuang': 'bert_qa_finetune_bert_base_v1',
            'en.answer_question.bert.base.by_ricardo-filho': 'bert_qa_bert_base_faquad',
            'en.answer_question.bert.base.by_slavka': 'bert_qa_xdzadi00_based_v4',
            'en.answer_question.bert.base.by_xraychen': 'bert_qa_mqa_baseline',
            'en.answer_question.bert.base.serini.cmrc': 'bert_qa_bertserini_base_cmrc',
            'en.answer_question.bert.base_cased': 'bert_qa_bert_base_turkish_cased_finetuned_lr_2e_05_epochs_3',
            'en.answer_question.bert.base_cased.by_CenIA': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_tar',
            'en.answer_question.bert.base_cased.by_husnu': 'bert_qa_bert_base_turkish_cased_finetuned_lr_2e_05_epochs_3',
            'en.answer_question.bert.base_cased.by_nntadotzip': 'bert_qa_bert_base_cased_IUChatbot_ontologyDts',
            'en.answer_question.bert.base_uncased': 'bert_qa_bert_base_uncased_coqa',
            'en.answer_question.bert.base_uncased.by_CenIA': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_tar',
            'en.answer_question.bert.base_uncased.by_machine2049': 'bert_qa_bert_base_uncased_finetuned_duorc_bert',
            'en.answer_question.bert.base_uncased.by_peggyhuang': 'bert_qa_bert_base_uncased_coqa',
            'en.answer_question.bert.base_uncased.by_vanadhi': 'bert_qa_bert_base_uncased_fiqa_flm_sq_flit',
            'en.answer_question.bert.base_v2': 'bert_qa_finetune_bert_base_v2',
            'en.answer_question.bert.base_v3.by_peggyhuang': 'bert_qa_finetune_bert_base_v3',
            'en.answer_question.bert.by_Danastos': 'bert_qa_nq_bert_el_Danastos',
            'en.answer_question.bert.by_ForutanRad': 'bert_qa_bert_fa_QA_v1',
            'en.answer_question.bert.by_HankyStyle': 'bert_qa_Multi_ling_BERT',
            'en.answer_question.bert.by_LenaSchmidt': 'bert_qa_no_need_to_name_this',
            'en.answer_question.bert.by_Rocketknight1': 'bert_qa_bert_finetuned_qa',
            'en.answer_question.bert.by_SanayCo': 'bert_qa_model_output',
            'en.answer_question.bert.by_aozorahime': 'bert_qa_my_new_model',
            'en.answer_question.bert.by_aymanm419': 'bert_qa_araSpeedest',
            'en.answer_question.bert.by_enoriega': 'bert_qa_rule_softmatching',
            'en.answer_question.bert.by_ericRosello': 'bert_qa_results',
            'en.answer_question.bert.by_hendrixcosta': 'bert_qa_hendrixcosta',
            'en.answer_question.bert.by_internetoftim': 'bert_qa_demo',
            'en.answer_question.bert.by_jackh1995': 'bert_qa_bert_finetuned_jackh1995',
            'en.answer_question.bert.by_krinal214': 'bert_qa_bert_all_translated',
            'en.answer_question.bert.by_manav': 'bert_qa_causal_qa',
            'en.answer_question.bert.by_mezes': 'bert_qa_eauction_section_parsing_from_pretrained',
            'en.answer_question.bert.by_motiondew': 'bert_qa_bert_finetuned_lr2_e5_b16_ep2',
            'en.answer_question.bert.by_mrm8488': 'bert_qa_ManuERT_for_xqua',
            'en.answer_question.bert.by_nlpunibo': 'bert_qa_bert',
            'en.answer_question.bert.by_nvkha': 'bert_qa_bert_qa_vi_nvkha',
            'en.answer_question.bert.by_piEsposito': 'bert_qa_braquad_bert_qna',
            'en.answer_question.bert.by_ponmari': 'bert_qa_questionansweing',
            'en.answer_question.bert.by_songhee': 'bert_qa_i_manual_m',
            'en.answer_question.bert.by_voidful': 'bert_qa_question_answering_zh_voidful',
            'en.answer_question.bert.by_z-uo': 'bert_qa_bert_qasper',
            'en.answer_question.bert.cased_base': 'bert_qa_base_cased_iuchatbot_ontologydts_berttokenizer_12april2022',
            'en.answer_question.bert.cased_base_finetuned': 'bert_qa_base_cased_finetuned_log_parser_winlogbeat_nowhitespac',
            'en.answer_question.bert.cased_base_finetuned.by_slavka': 'bert_qa_base_cased_finetuned_log_parser_winlogbeat_nowhitespace_larg',
            'en.answer_question.bert.cased_multilingual_base_finetuned': 'bert_qa_base_multilingual_cased_finetuned_viquad',
            'en.answer_question.bert.distilled_base_uncased': 'bert_qa_distilbert_base_uncased_finetuned_custom',
            'en.answer_question.bert.docvqa.base_uncased.by_tiennvcs': 'bert_qa_bert_base_uncased_finetuned_docvqa',
            'en.answer_question.bert.infovqa.base_uncased.by_tiennvcs': 'bert_qa_bert_base_uncased_finetuned_infovqa',
            'en.answer_question.bert.large': 'bert_qa_bert_large_question_answering_finetuned_legal',
            'en.answer_question.bert.large.by_Sounak': 'bert_qa_bert_large_finetuned',
            'en.answer_question.bert.large.by_atharvamundada99': 'bert_qa_bert_large_question_answering_finetuned_legal',
            'en.answer_question.bert.large.by_ricardo-filho': 'bert_qa_bert_large_faquad',
            'en.answer_question.bert.large_cased': 'bert_qa_muril_large_cased_hita_qa',
            'en.answer_question.bert.large_uncased': 'bert_qa_bert_large_uncased_finetuned_docvqa',
            'en.answer_question.bert.legal': 'bert_qa_legal',
            'en.answer_question.bert.mlqa.base': 'bert_qa_base_multi_mlqa_dev',
            'en.answer_question.bert.mlqa.finetuned': 'bert_qa_mbert_finetuned_mlqa_dev',
            'en.answer_question.bert.multilingual_arabic_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_arabic',
            'en.answer_question.bert.multilingual_english_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_english',
            'en.answer_question.bert.multilingual_german_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_german',
            'en.answer_question.bert.multilingual_hindi_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_hindi',
            'en.answer_question.bert.multilingual_spanish_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_spanish',
            'en.answer_question.bert.multilingual_vietnamese_tuned_base_cased.by_bhavikardeshna': 'bert_qa_multilingual_bert_base_cased_vietnamese',
            'en.answer_question.bert.news_sqa.uncased_large': 'bert_qa_unqover_large_uncased_newsqa',
            'en.answer_question.bert.sd1.by_motiondew': 'bert_qa_sd1',
            'en.answer_question.bert.sd2.by_motiondew': 'bert_qa_sd2',
            'en.answer_question.bert.sd2_lr_5e_5_bs_32_e_3': 'bert_qa_sd2_lr_5e_5_bs_32_e_3',
            'en.answer_question.bert.sd3.by_motiondew': 'bert_qa_sd3',
            'en.answer_question.bert.set_date_1_impartit_4.by_motiondew': 'bert_qa_set_date_1_impartit_4',
            'en.answer_question.bert.sim.by_xraychen': 'bert_qa_mqa_sim',
            'en.answer_question.bert.small': 'bert_qa_sd1_small',
            'en.answer_question.bert.small.sd2_small.by_motiondew': 'bert_qa_sd2_small',
            'en.answer_question.bert.small.sd3_small.by_motiondew': 'bert_qa_sd3_small',
            'en.answer_question.bert.squad.': 'bert_qa_kd_squad1.1',
            'en.answer_question.bert.squad.by_nadav': 'bert_qa_macsquad',
            'en.answer_question.bert.squad.cased_base_finetuned': 'bert_qa_baru98_base_cased_finetuned_squad',
            'en.answer_question.bert.squad.cased_base_finetuned.by_anas_awadalla': 'bert_qa_base_cased_finetuned_squad_r3f',
            'en.answer_question.bert.squad.cased_base_finetuned.by_victorlee071200': 'bert_qa_victorlee071200_base_cased_finetuned_squad',
            'en.answer_question.bert.squad.cased_multilingual_base_finetuned': 'bert_qa_khanh_base_multilingual_cased_finetuned_squad',
            'en.answer_question.bert.squad.distilled_uncased_base_finetuned': 'bert_qa_negfir_distilbert_base_uncased_finetuned_squad',
            'en.answer_question.bert.squad.finetuned': 'bert_qa_aiyshwariya_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_Callmenicky': 'bert_qa_callmenicky_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_CherylTSW': 'bert_qa_cheryltsw_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_DaisyMak': 'bert_qa_finetuned_squad_transformerfrozen_testtoken',
            'en.answer_question.bert.squad.finetuned.by_LeoFelix': 'bert_qa_leofelix_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_MyMild': 'bert_qa_mymild_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_Nausheen': 'bert_qa_nausheen_finetuned_squad_accelera',
            'en.answer_question.bert.squad.finetuned.by_ParanoidAndroid': 'bert_qa_paranoidandroid_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_WounKai': 'bert_qa_wounkai_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_akmal2500': 'bert_qa_akmal2500_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_chanifrusydi': 'bert_qa_chanifrusydi_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_cjjie': 'bert_qa_cjjie_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_ericw0530': 'bert_qa_ericw0530_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_irenelizihui': 'bert_qa_irenelizihui_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_lewtun': 'bert_qa_lewtun_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_mkkc58': 'bert_qa_mkkc58_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_qgrantq': 'bert_qa_qgrantq_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_susghosh': 'bert_qa_susghosh_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_wiselinjayajos': 'bert_qa_wiselinjayajos_finetuned_squad',
            'en.answer_question.bert.squad.finetuned.by_yossra': 'bert_qa_yossra_finetuned_squad',
            'en.answer_question.bert.squad.finetuned_accelera.by_spasis': 'bert_qa_spasis_finetuned_squad_accelera',
            'en.answer_question.bert.squad.finetuned_squad.by_KFlash': 'bert_qa_kflash_finetuned_squad',
            'en.answer_question.bert.squad.finetuned_squad.by_SebastianS': 'bert_qa_sebastians_finetuned_squad',
            'en.answer_question.bert.squad.finetuned_squad.by_clementgyj': 'bert_qa_clementgyj_finetuned_squad',
            'en.answer_question.bert.squad.finetuned_squad.by_spasis': 'bert_qa_spasis_finetuned_squad',
            'en.answer_question.bert.squad.finetuned_squad_50k.by_clementgyj': 'bert_qa_finetuned_squad_50k',
            'en.answer_question.bert.squad.finetuned_squad_accelera.by_KFlash': 'bert_qa_kflash_finetuned_squad_accelera',
            'en.answer_question.bert.squad.finetuned_squad_accelera.by_SebastianS': 'bert_qa_sebastians_finetuned_squad_accelera',
            'en.answer_question.bert.squad.mini_finetuned': 'bert_qa_mini_finetuned_squad',
            'en.answer_question.bert.squad.tiny': 'bert_qa_tinybert_general_4l_312d_squad',
            'en.answer_question.bert.squad.tiny_finetuned': 'bert_qa_tiny_wrslb_finetuned_squadv1',
            'en.answer_question.bert.squad.uncased_base_finetuned': 'bert_qa_base_uncased_squad_v1.0_finetuned',
            'en.answer_question.bert.squad.uncased_finetuned': 'bert_qa_uncased_finetuned_squad_indonesian',
            'en.answer_question.bert.squad.uncased_mini_lm_mini': 'bert_qa_minilm_l12_h384_uncased_squad',
            'en.answer_question.bert.squad.uncased_seed_0_base_1024d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_1024_finetuned_squad_seed_0',
            'en.answer_question.bert.squad.uncased_seed_0_base_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_16_finetuned_squad_seed_0',
            'en.answer_question.bert.squad.uncased_seed_10_base_1024d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_1024_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_10_base_128d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_128_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_10_base_256d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_256_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_10_base_32d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_32_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_10_base_512d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_512_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_10_base_64d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_64_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_10_base_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_16_finetuned_squad_seed_10',
            'en.answer_question.bert.squad.uncased_seed_2_base_1024d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_1024_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_2_base_128d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_128_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_2_base_256d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_256_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_2_base_32d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_32_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_2_base_512d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_512_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_2_base_64d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_64_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_2_base_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_16_finetuned_squad_seed_2',
            'en.answer_question.bert.squad.uncased_seed_42_base_128d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_128_finetuned_squad_seed_42',
            'en.answer_question.bert.squad.uncased_seed_4_base_1024d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_1024_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_4_base_128d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_128_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_4_base_256d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_256_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_4_base_32d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_32_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_4_base_512d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_512_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_4_base_64d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_64_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_4_base_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_16_finetuned_squad_seed_4',
            'en.answer_question.bert.squad.uncased_seed_6_base_1024d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_1024_finetuned_squad_seed_6',
            'en.answer_question.bert.squad.uncased_seed_6_base_128d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_128_finetuned_squad_seed_6',
            'en.answer_question.bert.squad.uncased_seed_6_base_256d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_256_finetuned_squad_seed_6',
            'en.answer_question.bert.squad.uncased_seed_6_base_32d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_32_finetuned_squad_seed_6',
            'en.answer_question.bert.squad.uncased_seed_6_base_512d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_512_finetuned_squad_seed_6',
            'en.answer_question.bert.squad.uncased_seed_6_base_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_16_finetuned_squad_seed_6',
            'en.answer_question.bert.squad.uncased_seed_8_base_1024d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_1024_finetuned_squad_seed_8',
            'en.answer_question.bert.squad.uncased_seed_8_base_128d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_128_finetuned_squad_seed_8',
            'en.answer_question.bert.squad.uncased_seed_8_base_256d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_256_finetuned_squad_seed_8',
            'en.answer_question.bert.squad.uncased_seed_8_base_32d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_32_finetuned_squad_seed_8',
            'en.answer_question.bert.squad.uncased_seed_8_base_512d_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_512_finetuned_squad_seed_8',
            'en.answer_question.bert.squad.uncased_seed_8_base_finetuned_few_shot': 'bert_qa_base_uncased_few_shot_k_16_finetuned_squad_seed_8',
            'en.answer_question.bert.squadv2.': 'bert_qa_emanuals_squad2.0',
            'en.answer_question.bert.squadv2.base': 'bert_qa_unsup_consert_base_squad2.0',
            'en.answer_question.bert.squadv2.base_epochs_1': 'bert_qa_rule_based_hier_quadruplet_0.1_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.based_hier_quadruplet_epochs_1_shard_1_squad2.by_AnonymousSub': 'bert_qa_rule_based_hier_quadruplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.based_hier_triplet_0.by_AnonymousSub': 'bert_qa_rule_based_hier_triplet_0.1_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.based_hier_triplet_epochs_1_shard_1_kldiv_squad2.by_AnonymousSub': 'bert_qa_rule_based_hier_triplet_epochs_1_shard_1_kldiv_squad2.0',
            'en.answer_question.bert.squadv2.based_hier_triplet_epochs_1_shard_1_squad2.by_AnonymousSub': 'bert_qa_rule_based_hier_triplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.based_only_classfn_epochs_1_shard_1_squad2.by_AnonymousSub': 'bert_qa_rule_based_only_classfn_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.based_quadruplet_epochs_1_shard_1_squad2.by_AnonymousSub': 'bert_qa_rule_based_quadruplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.based_triplet_epochs_1_shard_1_squad2.by_AnonymousSub': 'bert_qa_rule_based_triplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.bert.squadv2.by_anonymoussub': 'bert_qa_specter_model_squad2.0',
            'en.answer_question.bert.squadv2.cased_v2_base_finetuned': 'bert_qa_base_cased_finetuned_squad_v2',
            'en.answer_question.bert.squadv2.large_tiny_768d': 'bert_qa_tinybert_6l_768d_squad2_large_teach',
            'en.answer_question.bert.squadv2.large_tiny_768d.by_MichelBartels': 'bert_qa_tinybert_6l_768d_squad2_large_teacher_dummy',
            'en.answer_question.bert.squadv2.uncased_2l_128d_a2a_128d': 'bert_qa_uncased_l_2_h_128_a_2_squad2',
            'en.answer_question.bert.squadv2.uncased_base': 'bert_qa_base_uncased_squad2.0',
            'en.answer_question.bert.squadv2.uncased_mini_lm_mini_finetuned': 'bert_qa_ahujaniharika95_minilm_uncased_squad2_finetuned_squad',
            'en.answer_question.bert.squadv2.uncased_mini_lm_mini_finetuned.by_Renukswamy': 'bert_qa_renukswamy_minilm_uncased_squad2_finetuned_squad',
            'en.answer_question.bert.squadv2.uncased_v2': 'bert_qa_multi_uncased_trained_squadv2',
            'en.answer_question.bert.squadv2.uncased_v2_base_finetuned': 'bert_qa_base_uncased_squad_v2.0_finetuned',
            'en.answer_question.bert.squadv2.v2_mini_finetuned': 'bert_qa_mini_finetuned_squadv2',
            'en.answer_question.bert.squadv2.v2_tiny_finetuned': 'bert_qa_tiny_finetuned_squadv2',
            'en.answer_question.bert.squadv2_contracts.uncased_v2_base_finetuned': 'bert_qa_base_uncased_contracts_finetuned_on_squadv2',
            'en.answer_question.bert.squadv2_cord19.uncased_2l_128d_a2a_128d': 'bert_qa_uncased_l_2_h_128_a_2_cord19_200616_squad2',
            'en.answer_question.bert.squadv2_cord19.uncased_6l_128d_a2a_128d': 'bert_qa_uncased_l_6_h_128_a_2_cord19_200616_squad2',
            'en.answer_question.bert.squadv2_covid.uncased_2l_128d_a2a_128d': 'bert_qa_uncased_l_2_h_128_a_2_squad2_covid_qna',
            'en.answer_question.bert.squadv2_covid_cord19.uncased_2l_128d_a2a_128d': 'bert_qa_uncased_l_2_h_128_a_2_cord19_200616_squad2_covid_qna',
            'en.answer_question.bert.squadv2_covid_cord19.uncased_2l_512d_a8a_512d': 'bert_qa_uncased_l_2_h_512_a_8_cord19_200616_squad2_covid_qna',
            'en.answer_question.bert.squadv2_covid_cord19.uncased_6l_128d_a2a_128d': 'bert_qa_uncased_l_6_h_128_a_2_cord19_200616_squad2_covid_qna',
            'en.answer_question.bert.techqa.': 'bert_qa_consert_techqa',
            'en.answer_question.bert.tquad.xtremedistiled_uncased_finetuned_epochs_3': 'bert_qa_xtremedistil_l6_h256_uncased_tquad_finetuned_lr_2e_05_epochs_3',
            'en.answer_question.bert.tquad.xtremedistiled_uncased_finetuned_epochs_6': 'bert_qa_xtremedistil_l6_h256_uncased_tquad_finetuned_lr_2e_05_epochs_6',
            'en.answer_question.bert.trivia.base_1024d': 'bert_qa_base_1024_full_trivia',
            'en.answer_question.bert.tydiqa.': 'bert_qa_part_2_mbert_model_e1',
            'en.answer_question.bert.uncased_base': 'bert_qa_base_uncased_attribute_correction',
            'en.answer_question.bert.uncased_base.by_michaelrglass': 'bert_qa_base_uncased_ssp',
            'en.answer_question.bert.uncased_base_finetuned': 'bert_qa_base_uncased_pretrain_finetuned_coqa_fal',
            'en.answer_question.bert.uncased_base_finetuned.by_alistvt': 'bert_qa_base_uncased_pretrain_finetuned_coqa_falttened',
            'en.answer_question.bert.uncased_large': 'bert_qa_large_uncased_ssp',
            'en.answer_question.bert.uncased_large_finetuned': 'bert_qa_large_uncased_finetuned_infovqa',
            'en.answer_question.bert.uncased_large_finetuned.by_tiennvcs': 'bert_qa_large_uncased_finetuned_vi_infovqa',
            'en.answer_question.bert.unsupsim.by_xraychen': 'bert_qa_mqa_unsupsim',
            'en.answer_question.bert.v1.lr_2e_5_bs_32_ep_3.by_motiondew': 'bert_qa_set_date_1_lr_2e_5_bs_32_ep_3',
            'en.answer_question.bert.v2.lr_2e_5_bs_32_ep_3.by_motiondew': 'bert_qa_set_date_2_lr_2e_5_bs_32_ep_3',
            'en.answer_question.bert.v3.lr_2e_5_bs_32_ep_3.by_motiondew': 'bert_qa_set_date_3_lr_2e_5_bs_32_ep_3',
            'en.answer_question.bert.v4.lr_2e_5_bs_32_ep_4.by_motiondew': 'bert_qa_set_date_2_lr_2e_5_bs_32_ep_4',
            'en.answer_question.bert.v5.lr_2e_5_bs_32_ep_4.by_motiondew': 'bert_qa_set_date_3_lr_2e_5_bs_32_ep_4',
            'en.answer_question.bert.v6.lr_3e_5_bs_32_ep_3.by_motiondew': 'bert_qa_set_date_1_lr_3e_5_bs_32_ep_3',
            'en.answer_question.bert.v7.lr_3e_5_bs_32_ep_3.by_motiondew': 'bert_qa_set_date_2_lr_3e_5_bs_32_ep_3',
            'en.answer_question.bert.v8.lr_3e_5_bs_32_ep_3.by_motiondew': 'bert_qa_set_date_3_lr_3e_5_bs_32_ep_3',
            'en.answer_question.bert.vi_infovqa.base_uncased.by_tiennvcs': 'bert_qa_bert_base_uncased_finetuned_vi_infovqa',
            'en.answer_question.bert.xtremedistiled_uncased_lr_2e_05_epochs_3.by_husnu': 'bert_qa_xtremedistil_l6_h256_uncased_finetuned_lr_2e_05_epochs_3',
            'en.answer_question.bert.xtremedistiled_uncased_lr_2e_05_epochs_6.by_husnu': 'bert_qa_xtremedistil_l6_h256_uncased_finetuned_lr_2e_05_epochs_6',
            'en.answer_question.bert.zero_shot': 'bert_qa_fewrel_zero_shot',
            'en.answer_question.bert.zero_shot.by_fractalego': 'bert_qa_fewrel_zero_shot',
            'en.answer_question.bert.zero_shot.by_krinal214': 'bert_qa_zero_shot',
            'en.answer_question.bio_clinical.bert': 'bert_qa_sagemaker_BioclinicalBERT_ADR',
            'en.answer_question.bio_medical.bert.base': 'bert_qa_biomedical_slot_filling_reader_base',
            'en.answer_question.bio_medical.bert.large': 'bert_qa_biomedical_slot_filling_reader_large',
            'en.answer_question.biobert': 'bert_qa_biobert_bioasq',
            'en.answer_question.biobert.bio_medical.': 'bert_qa_biobert_v1.1_biomedicalquestionanswering',
            'en.answer_question.biobert.squad.cased_large': 'bert_qa_biobert_large_cased_v1.1_squad',
            'en.answer_question.chaii.bert.base_cased': 'bert_qa_bert_base_cased_chaii',
            'en.answer_question.chaii.bert.cased': 'bert_qa_bert_multi_cased_finetuned_chaii',
            'en.answer_question.chaii.bert.large_uncased_uncased_whole_word_masking.by_SauravMaheshkar': 'bert_qa_bert_large_uncased_whole_word_masking_chaii',
            'en.answer_question.chaii.bert.large_uncased_uncased_whole_word_masking_finetuned.by_SauravMaheshkar': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_chaii',
            'en.answer_question.chaii.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_chaii',
            'en.answer_question.chaii.bert.uncased': 'bert_qa_bert_multi_uncased_finetuned_chaii',
            'en.answer_question.chaii.distil_bert': 'distilbert_qa_multi_finetuned_for_xqua_on_chaii',
            'en.answer_question.chaii.distil_bert.base_cased': 'distilbert_qa_base_cased_distilled_chaii',
            'en.answer_question.chaii.distil_bert.base_uncased': 'distilbert_qa_base_uncased_distilled_chaii',
            'en.answer_question.chaii.electra.base': 'electra_qa_base_chaii',
            'en.answer_question.chaii.roberta.base': 'roberta_qa_roberta_base_chaii',
            'en.answer_question.chaii.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_finetuned_chaii',
            'en.answer_question.chaii.xlm_roberta.base.by_SauravMaheshkar': 'xlm_roberta_qa_xlm_roberta_base_chaii',
            'en.answer_question.chaii.xlm_roberta.base.by_tyqiangz': 'xlm_roberta_qa_xlm_roberta_base_finetuned_chaii',
            'en.answer_question.chaii.xlm_roberta.large.by_SauravMaheshkar': 'xlm_roberta_qa_xlm_roberta_large_chaii',
            'en.answer_question.chaii.xlm_roberta.large_multi.by_SauravMaheshkar': 'xlm_roberta_qa_xlm_multi_roberta_large_chaii',
            'en.answer_question.clinical.distil_bert': 'distilbert_qa_BERT_ClinicalQA',
            'en.answer_question.conll.distil_bert.base_uncased': 'distilbert_qa_base_uncased_qa_with_ner',
            'en.answer_question.cord19.bert.by_JAlexis': 'bert_qa_Bertv1_fine',
            'en.answer_question.cord19.bert.small': 'bert_qa_bert_small_cord19qa',
            'en.answer_question.cord19.prueba_bert.by_JAlexis': 'bert_qa_PruebaBert',
            'en.answer_question.covid.distil_bert.a.by_rahulkuruvilla': 'distilbert_qa_COVID_DistilBERTa',
            'en.answer_question.covid.distil_bert.b.by_rahulkuruvilla': 'distilbert_qa_COVID_DistilBERTb',
            'en.answer_question.covid.distil_bert.c.by_rahulkuruvilla': 'distilbert_qa_COVID_DistilBERTc',
            'en.answer_question.covid.longformer': 'longformer_qa_covid',
            'en.answer_question.covid_bert.a.by_rahulkuruvilla': 'bert_qa_COVID_BERTa',
            'en.answer_question.covid_bert.b.by_rahulkuruvilla': 'bert_qa_COVID_BERTb',
            'en.answer_question.covid_bert.c.by_rahulkuruvilla': 'bert_qa_COVID_BERTc',
            'en.answer_question.cuad.roberta.base': 'roberta_qa_marshmellow77_roberta_base_cuad',
            'en.answer_question.cuad.roberta.base.by_Gam': 'roberta_qa_roberta_base_finetuned_cuad',
            'en.answer_question.cuad.roberta.base.by_Rakib': 'roberta_qa_roberta_base_on_cuad',
            'en.answer_question.cuad.roberta.base.by_akdeniz27': 'roberta_qa_akdeniz27_roberta_base_cuad',
            'en.answer_question.cuad.roberta.base.by_marshmellow77': 'roberta_qa_marshmellow77_roberta_base_cuad',
            'en.answer_question.cuad.roberta.large': 'roberta_qa_roberta_large_cuad',
            'en.answer_question.cuad_gam.roberta.base.by_Gam': 'roberta_qa_roberta_base_finetuned_cuad_gam',
            'en.answer_question.distil_bert': 'distilbert_qa_projectmodel_bert',
            'en.answer_question.distil_bert.base': 'distilbert_qa_robustqa_baseline_02',
            'en.answer_question.distil_bert.base.by_leemii18': 'distilbert_qa_robustqa_baseline_02',
            'en.answer_question.distil_bert.base.by_minhdang241': 'distilbert_qa_robustqa_baseline_01',
            'en.answer_question.distil_bert.base_cased': 'distilbert_qa_bert_base_cased_finetuned_log_parser_winlogbeat',
            'en.answer_question.distil_bert.base_cased.by_Slavka': 'distilbert_qa_bert_base_cased_finetuned_log_parser_winlogbeat',
            'en.answer_question.distil_bert.base_cased.by_adamlin': 'distilbert_qa_base_cased_sgd_qa_step5000',
            'en.answer_question.distil_bert.base_config1.by_nlpunibo': 'distilbert_qa_base_config1',
            'en.answer_question.distil_bert.base_config2.by_nlpunibo': 'distilbert_qa_base_config2',
            'en.answer_question.distil_bert.base_config3.by_nlpunibo': 'distilbert_qa_base_config3',
            'en.answer_question.distil_bert.base_uncased': 'distilbert_qa_base_uncased_finetuned_advers',
            'en.answer_question.distil_bert.base_uncased.by_T-qualizer': 'distilbert_qa_base_uncased_finetuned_advers',
            'en.answer_question.distil_bert.base_uncased.by_charlieoneill': 'distilbert_qa_base_uncased_gradient_clinic',
            'en.answer_question.distil_bert.base_uncased.by_datarpit': 'distilbert_qa_base_uncased_finetuned_natural_questions',
            'en.answer_question.distil_bert.base_uncased.by_machine2049': 'distilbert_qa_base_uncased_finetuned_duorc_',
            'en.answer_question.distil_bert.base_uncased.by_tiennvcs': 'distilbert_qa_base_uncased_finetuned_infovqa',
            'en.answer_question.distil_bert.by_Ifenna': 'distilbert_qa_dbert_3epoch',
            'en.answer_question.distil_bert.by_LucasS': 'distilbert_qa_distilBertABSA',
            'en.answer_question.distil_bert.by_Sarmad': 'distilbert_qa_projectmodel_bert',
            'en.answer_question.distil_bert.by_Sounak': 'distilbert_qa_finetuned',
            'en.answer_question.distil_bert.by_ajaypyatha': 'distilbert_qa_sdsqna',
            'en.answer_question.distil_bert.by_alinemati': 'distilbert_qa_BERT',
            'en.answer_question.distil_bert.by_keras-io': 'distilbert_qa_transformers_qa',
            'en.answer_question.distil_bert.by_minhdang241': 'distilbert_qa_robustqa_tapt',
            'en.answer_question.distil_bert.by_pakupoko': 'distilbert_qa_bizlin_distil_model',
            'en.answer_question.distil_bert.by_poom-sci': 'distilbert_qa_qa',
            'en.answer_question.distil_bert.custom.by_aszidon': 'distilbert_qa_custom',
            'en.answer_question.distil_bert.custom3.by_aszidon': 'distilbert_qa_custom3',
            'en.answer_question.distil_bert.custom4.by_aszidon': 'distilbert_qa_custom4',
            'en.answer_question.distil_bert.custom5.by_aszidon': 'distilbert_qa_custom5',
            'en.answer_question.distil_bert.flat_n_max.by_mcurmei': 'distilbert_qa_flat_N_max',
            'en.answer_question.distil_bert.log_parser.by_Slavka': 'distilbert_qa_distil_bert_finetuned_log_parser_1',
            'en.answer_question.distil_bert.log_parser_winlogbeat.by_Slavka': 'distilbert_qa_distil_bert_finetuned_log_parser_winlogbeat',
            'en.answer_question.distil_bert.single_label_n_max.by_mcurmei': 'distilbert_qa_single_label_N_max',
            'en.answer_question.distil_bert.single_label_n_max_long_training.by_mcurmei': 'distilbert_qa_single_label_N_max_long_training',
            'en.answer_question.distil_bert.unique_n_max.by_mcurmei': 'distilbert_qa_unique_N_max',
            'en.answer_question.electra': 'electra_qa_TestQA2',
            'en.answer_question.electra.by_Andranik': 'electra_qa_TestQA2',
            'en.answer_question.electra.by_carlosserquen': 'electra_qa_elctrafp',
            'en.answer_question.electra.by_rowan1224': 'electra_qa_slp',
            'en.answer_question.electra.finetuning_1': 'electra_qa_DSPFirst_Finetuning_1',
            'en.answer_question.electra.finetuning_2': 'electra_qa_DSPFirst_Finetuning_2',
            'en.answer_question.electra.finetuning_3': 'electra_qa_DSPFirst_Finetuning_3',
            'en.answer_question.electra.finetuning_4': 'electra_qa_DSPFirst_Finetuning_4',
            'en.answer_question.electra.finetuning_5': 'electra_qa_DSPFirst_Finetuning_5',
            'en.answer_question.klue.bert': 'bert_qa_Klue_CommonSense_model',
            'en.answer_question.klue.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_klue',
            'en.answer_question.klue.xlm_roberta.base': 'xlm_roberta_qa_klue_mrc_roberta_base',
            'en.answer_question.korquad.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_korquad_v1',
            'en.answer_question.korquad.bert.multilingual_base_cased.by_eliza-dukim': 'bert_qa_bert_base_multilingual_cased_korquad_v1',
            'en.answer_question.korquad.bert.multilingual_base_cased.by_sangrimlee': 'bert_qa_bert_base_multilingual_cased_korquad',
            'en.answer_question.korquad.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_korquad_mask',
            'en.answer_question.link_bert.squad.base_finetuned': 'bert_qa_linkbert_base_finetuned_squad',
            'en.answer_question.longformer': 'longformer_qa_ponmari',
            'en.answer_question.longformer.by_Nomi97': 'longformer_qa_Chatbot',
            'en.answer_question.longformer.by_manishiitg': 'longformer_qa_recruit',
            'en.answer_question.longformer.by_ponmari': 'longformer_qa_ponmari',
            'en.answer_question.longformer.large': 'longformer_qa_recruit_large',
            'en.answer_question.longformer.v2': 'longformer_qa_recruit_v2',
            'en.answer_question.mitmovie_squad.roberta.by_thatdramebaazguy': 'roberta_qa_movie_roberta_MITmovie_squad',
            'en.answer_question.mlqa.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_mlqa',
            'en.answer_question.mlqa.bert.base_uncased': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_mlqa',
            'en.answer_question.movie_squad.roberta.base': 'roberta_qa_roberta_base_MITmovie_squad',
            'en.answer_question.movie_squad.roberta.by_thatdramebaazguy': 'roberta_qa_movie_roberta_squad',
            'en.answer_question.movie_squadv2.bert.large_uncased': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_movie_with_neg_with_repeat',
            'en.answer_question.mqa_cls.bert.by_xraychen': 'bert_qa_mqa_cls',
            'en.answer_question.multi_lingual_bert': 'bert_qa_mBERT_all_ty_SQen_SQ20_1',
            'en.answer_question.multi_lingual_bert.by_horsbug98': 'bert_qa_Part_1_mBERT_Model_E2',
            'en.answer_question.multi_lingual_bert.by_krinal214': 'bert_qa_mBERT_all_ty_SQen_SQ20_1',
            'en.answer_question.news.bert': 'bert_qa_newsqa_bert_el_Danastos',
            'en.answer_question.news.bert.base_uncased': 'bert_qa_unqover_bert_base_uncased_newsqa',
            'en.answer_question.news.bert.base_uncased.by_mirbostani': 'bert_qa_bert_base_uncased_finetuned_newsqa',
            'en.answer_question.news.bert.base_uncased.by_tli8hf': 'bert_qa_unqover_bert_base_uncased_newsqa',
            'en.answer_question.news.bert.by_AnonymousSub': 'bert_qa_news_pretrain_bert_FT_newsqa',
            'en.answer_question.news.bert.by_Danastos': 'bert_qa_newsqa_bert_el_Danastos',
            'en.answer_question.news.bert.fpdm_ft.by_AnonymousSub': 'bert_qa_fpdm_bert_FT_newsqa',
            'en.answer_question.news.bert.fpdm_ft_new.by_AnonymousSub': 'bert_qa_fpdm_bert_FT_new_newsqa',
            'en.answer_question.news.bert.fpdm_hier_ft.by_AnonymousSub': 'bert_qa_fpdm_hier_bert_FT_newsqa',
            'en.answer_question.news.bert.fpdm_hier_ft_by_AnonymousSub': 'bert_qa_fpdm_hier_bert_FT_new_newsqa',
            'en.answer_question.news.bert.ft.by_AnonymousSub': 'bert_qa_bert_FT_newsqa',
            'en.answer_question.news.bert.ft_new.by_AnonymousSub': 'bert_qa_bert_FT_new_newsqa',
            'en.answer_question.news.bert.new.by_AnonymousSub': 'bert_qa_news_pretrain_bert_FT_new_newsqa',
            'en.answer_question.news.bert.qa_fpdm_triplet_ft.by_AnonymousSub': 'bert_qa_fpdm_triplet_bert_FT_newsqa',
            'en.answer_question.news.bert.qa_fpdm_triplet_ft_new.by_AnonymousSub': 'bert_qa_fpdm_triplet_bert_FT_new_newsqa',
            'en.answer_question.news.distil_bert.base_uncased': 'distilbert_qa_unqover_base_uncased_newsqa',
            'en.answer_question.news.roberta.base': 'roberta_qa_unqover_roberta_base_newsqa',
            'en.answer_question.news.roberta.large': 'roberta_qa_unqover_roberta_large_newsqa',
            'en.answer_question.news.roberta.qa_fpdm_hier_roberta_ft_new_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_hier_roberta_FT_new_newsqa',
            'en.answer_question.news.roberta.qa_fpdm_hier_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_hier_roberta_FT_newsqa',
            'en.answer_question.news.roberta.qa_fpdm_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_roberta_FT_newsqa',
            'en.answer_question.news.roberta.qa_fpdm_triplet_roberta_ft_new_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_triplet_roberta_FT_new_newsqa',
            'en.answer_question.news.roberta.qa_fpdm_triplet_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_fpdm_triplet_roberta_FT_newsqa',
            'en.answer_question.news.roberta.qa_ft.by_AnonymousSub': 'roberta_qa_news_pretrain_roberta_FT_newsqa',
            'en.answer_question.news.roberta.qa_ft_new.by_AnonymousSub': 'roberta_qa_news_pretrain_roberta_FT_new_newsqa',
            'en.answer_question.news.roberta.qa_roberta_ft_new_newsqa.by_AnonymousSub': 'roberta_qa_roberta_FT_new_newsqa',
            'en.answer_question.news.roberta.qa_roberta_ft_newsqa.by_AnonymousSub': 'roberta_qa_roberta_FT_newsqa',
            'en.answer_question.output_files.bert.by_sunitha': 'bert_qa_output_files',
            'en.answer_question.pubmed.bert.base_uncased': 'bert_qa_Sotireas_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT',
            'en.answer_question.pubmed.bert.base_uncased.by_Shushant': 'bert_qa_Shushant_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT',
            'en.answer_question.pubmed.bert.base_uncased.by_Sotireas': 'bert_qa_Sotireas_BiomedNLP_PubMedBERT_base_uncased_abstract_fulltext_ContaminationQAmodel_PubmedBERT',
            'en.answer_question.roberta': 'roberta_qa_robertaBaseABSA',
            'en.answer_question.roberta.756523213.by_AlirezaBaneshi': 'roberta_qa_autotrain_test2_756523213',
            'en.answer_question.roberta.756523214.by_AlirezaBaneshi': 'roberta_qa_autotrain_test2_756523214',
            'en.answer_question.roberta.augmented': 'roberta_qa_roberta_unaugmentedv3',
            'en.answer_question.roberta.base': 'roberta_qa_roberta_base_custom_QA',
            'en.answer_question.roberta.base.by_123tarunanand': 'roberta_qa_roberta_base_finetuned',
            'en.answer_question.roberta.base.by_eAsyle': 'roberta_qa_roberta_base_custom_QA',
            'en.answer_question.roberta.base.by_emr-se-miniproject': 'roberta_qa_roberta_base_emr',
            'en.answer_question.roberta.base.by_nlpconnect': 'roberta_qa_dpr_nq_reader_roberta_base',
            'en.answer_question.roberta.base.by_rsvp-ai': 'roberta_qa_bertserini_roberta_base',
            'en.answer_question.roberta.base_v2': 'roberta_qa_dpr_nq_reader_roberta_base_v2',
            'en.answer_question.roberta.by_AmazonScience': 'roberta_qa_qanlu',
            'en.answer_question.roberta.by_Andranik': 'roberta_qa_TestQaV1',
            'en.answer_question.roberta.by_AyushPJ': 'roberta_qa_ai_club_inductions_21_nlp_roBERTa',
            'en.answer_question.roberta.by_Beri': 'roberta_qa_legal_qa',
            'en.answer_question.roberta.by_CNT-UPenn': 'roberta_qa_RoBERTa_for_seizureFrequency_QA',
            'en.answer_question.roberta.by_Ching': 'roberta_qa_negation_detector',
            'en.answer_question.roberta.by_LucasS': 'roberta_qa_robertaBaseABSA',
            'en.answer_question.roberta.by_Mr-Wick': 'roberta_qa_Roberta',
            'en.answer_question.roberta.by_Nakul24': 'roberta_qa_RoBERTa_emotion_extraction',
            'en.answer_question.roberta.by_amazonscience': 'roberta_qa_nlu',
            'en.answer_question.roberta.by_aravind-812': 'roberta_qa_roberta_train_json',
            'en.answer_question.roberta.by_arjunth2001': 'roberta_qa_priv_qna',
            'en.answer_question.roberta.by_billfrench': 'roberta_qa_cyberlandr_door',
            'en.answer_question.roberta.by_nlpunibo': 'roberta_qa_nlpunibo_roberta',
            'en.answer_question.roberta.by_pierrerappolt': 'roberta_qa_cart',
            'en.answer_question.roberta.by_shmuelamar': 'roberta_qa_REQA_RoBERTa',
            'en.answer_question.roberta.by_stevemobs': 'roberta_qa_quales_iberlef',
            'en.answer_question.roberta.by_sunitha': 'roberta_qa_roberta_customds_finetune',
            'en.answer_question.roberta.by_veronica320': 'roberta_qa_QA_for_Event_Extraction',
            'en.answer_question.roberta.by_vesteinn': 'roberta_qa_IceBERT_QA',
            'en.answer_question.roberta.by_yirenl2': 'roberta_qa_plm',
            'en.answer_question.roberta.by_z-uo': 'roberta_qa_roberta_qasper',
            'en.answer_question.roberta.by_z_uo': 'roberta_qa_sper',
            'en.answer_question.roberta.carbonblog': 'roberta_qa_carbonblog',
            'en.answer_question.roberta.ch_tuned.by_Gantenbein': 'roberta_qa_ADDI_CH_RoBERTa',
            'en.answer_question.roberta.cuad.base': 'roberta_qa_akdeniz27_base_cuad',
            'en.answer_question.roberta.cuad.base.by_Rakib': 'roberta_qa_base_on_cuad',
            'en.answer_question.roberta.cuad.base.by_marshmellow77': 'roberta_qa_marshmellow77_base_cuad',
            'en.answer_question.roberta.cuad.base_finetuned': 'roberta_qa_base_cuad_finetuned',
            'en.answer_question.roberta.cuad.large': 'roberta_qa_large_cuad',
            'en.answer_question.roberta.cv_custom_ds.by_sunitha': 'roberta_qa_CV_Custom_DS',
            'en.answer_question.roberta.cv_merge_ds.by_sunitha': 'roberta_qa_CV_Merge_DS',
            'en.answer_question.roberta.de_tuned.by_Gantenbein': 'roberta_qa_ADDI_DE_RoBERTa',
            'en.answer_question.roberta.eda_and_parav3.by_comacrae': 'roberta_qa_roberta_eda_and_parav3',
            'en.answer_question.roberta.edav3.by_comacrae': 'roberta_qa_roberta_edav3',
            'en.answer_question.roberta.fi_tuned.by_Gantenbein': 'roberta_qa_ADDI_FI_RoBERTa',
            'en.answer_question.roberta.fr_tuned.by_Gantenbein': 'roberta_qa_ADDI_FR_RoBERTa',
            'en.answer_question.roberta.it_tuned.by_Gantenbein': 'roberta_qa_ADDI_IT_RoBERTa',
            'en.answer_question.roberta.large_init_large_seed_0.by_anas-awadalla': 'roberta_qa_roberta_large_initialization_seed_0',
            'en.answer_question.roberta.large_seed_0.by_anas-awadalla': 'roberta_qa_roberta_large_data_seed_0',
            'en.answer_question.roberta.large_seed_4': 'roberta_qa_roberta_large_data_seed_4',
            'en.answer_question.roberta.paraphrasev3.by_comacrae': 'roberta_qa_roberta_paraphrasev3',
            'en.answer_question.roberta.squad.base': 'roberta_qa_base_squad',
            'en.answer_question.roberta.squad.base.by_csarron': 'roberta_qa_base_squad_v1',
            'en.answer_question.roberta.squad.base_finetuned': 'roberta_qa_base_1b_1_finetuned_squadv1',
            'en.answer_question.roberta.squad_movie.': 'roberta_qa_movie_mitmovie_squad',
            'en.answer_question.roberta.squad_movie.base': 'roberta_qa_base_mitmovie_squad',
            'en.answer_question.roberta.squad_movie.by_thatdramebaazguy': 'roberta_qa_movie_squad',
            'en.answer_question.roberta.squadv2.base': 'roberta_qa_autoevaluate_base_squad2',
            'en.answer_question.roberta.squadv2.base.by_deepset': 'roberta_qa_deepset_base_squad2',
            'en.answer_question.roberta.squadv2.base.by_navteca': 'roberta_qa_navteca_base_squad2',
            'en.answer_question.roberta.squadv2.base.by_ydshieh': 'roberta_qa_ydshieh_base_squad2',
            'en.answer_question.roberta.squadv2.distilled_base': 'roberta_qa_base_squad2_distilled',
            'en.answer_question.roberta.squadv2.large': 'roberta_qa_deepset_large_squad2',
            'en.answer_question.roberta.squadv2.large.by_navteca': 'roberta_qa_navteca_large_squad2',
            'en.answer_question.roberta.squadv2.large_finetuned': 'roberta_qa_large_finetuned_squad2',
            'en.answer_question.roberta.squadv2.tiny': 'roberta_qa_tiny_squad2',
            'en.answer_question.roberta.squadv2.v2_base': 'roberta_qa_base_squad_v2',
            'en.answer_question.roberta.squadv2.v2_base_finetuned': 'roberta_qa_base_1b_1_finetuned_squadv2',
            'en.answer_question.roberta.synqa.large': 'roberta_qa_large_syn',
            'en.answer_question.roberta.synqa.large.by_mbartolo': 'roberta_qa_large_syn_ext',
            'en.answer_question.roberta.techqa_cline.by_AnonymousSub': 'roberta_qa_cline_techqa',
            'en.answer_question.roberta.techqa_cline_emanuals.by_AnonymousSub': 'roberta_qa_cline_emanuals_techqa',
            'en.answer_question.roberta.techqa_declutr.by_AnonymousSub': 'roberta_qa_declutr_techqa',
            'en.answer_question.roberta.techqa_declutr_emanuals.by_AnonymousSub': 'roberta_qa_declutr_emanuals_techqa',
            'en.answer_question.roberta.testabsa.by_eAsyle': 'roberta_qa_testABSA',
            'en.answer_question.roberta.testabsa3.by_eAsyle': 'roberta_qa_testABSA3',
            'en.answer_question.roberta.tiny_6l_768d': 'roberta_qa_tiny_6l_768d',
            'en.answer_question.roberta.tiny_768d': 'roberta_qa_tinyroberta_6l_768d',
            'en.answer_question.roberta.unaugv3.by_comacrae': 'roberta_qa_roberta_unaugv3',
            'en.answer_question.roberta_absa': 'roberta_qa_robertaABSA',
            'en.answer_question.scibert.scibert.': 'bert_qa_scibert_coqa',
            'en.answer_question.scibert.scibert.v2': 'bert_qa_finetune_scibert_v2',
            'en.answer_question.scibert.v2': 'bert_qa_nolog_SciBert_v2',
            'en.answer_question.span_bert': 'bert_qa_Spanbert_emotion_extraction',
            'en.answer_question.span_bert.by_Nakul24': 'bert_qa_Spanbert_emotion_extraction',
            'en.answer_question.span_bert.by_manishiitg': 'bert_qa_spanbert_recruit_qa',
            'en.answer_question.span_bert.large': 'bert_qa_spanbert_large_recruit_qa',
            'en.answer_question.span_bert.squad.base_finetuned': 'bert_qa_spanbert_base_finetuned_squad_r3f',
            'en.answer_question.span_bert.squad.cased_seed_0_base_128d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_0',
            'en.answer_question.span_bert.squad.cased_seed_0_base_256d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_0',
            'en.answer_question.span_bert.squad.cased_seed_0_base_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_0',
            'en.answer_question.span_bert.squad.cased_seed_10_base_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_10',
            'en.answer_question.span_bert.squad.cased_seed_2_base_256d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_2',
            'en.answer_question.span_bert.squad.cased_seed_2_base_512d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_2',
            'en.answer_question.span_bert.squad.cased_seed_2_base_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_2',
            'en.answer_question.span_bert.squad.cased_seed_42_base_128d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_42',
            'en.answer_question.span_bert.squad.cased_seed_4_base_256d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_4',
            'en.answer_question.span_bert.squad.cased_seed_4_base_32d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_4',
            'en.answer_question.span_bert.squad.cased_seed_4_base_512d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_4',
            'en.answer_question.span_bert.squad.cased_seed_4_base_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_4',
            'en.answer_question.span_bert.squad.cased_seed_6_base_256d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_6',
            'en.answer_question.span_bert.squad.cased_seed_6_base_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_6',
            'en.answer_question.span_bert.squad.cased_seed_8_base_256d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_8',
            'en.answer_question.span_bert.squad.cased_seed_8_base_32d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_8',
            'en.answer_question.span_bert.squad.cased_seed_8_base_64d_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_8',
            'en.answer_question.span_bert.squad.cased_seed_8_base_finetuned_few_shot': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_8',
            'en.answer_question.sqac.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_sqac',
            'en.answer_question.sqac.bert.base_uncased': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_sqac',
            'en.answer_question.squad.albert': 'albert_qa_squad_2.0',
            'en.answer_question.squad.albert.base_v2': 'albert_qa_base_v2_squad',
            'en.answer_question.squad.albert.by_SS8': 'albert_qa_squad_2.0',
            'en.answer_question.squad.albert.by_rowan1224': 'albert_qa_squad_slp',
            'en.answer_question.squad.albert.xl': 'albert_qa_xlarge_finetuned_squad',
            'en.answer_question.squad.albert.xxl': 'albert_qa_xxlarge_finetuned_squad',
            'en.answer_question.squad.bert': 'bert_qa_neuralmagic_bert_squad_12layer_0sparse',
            'en.answer_question.squad.bert.accelerate.by_KevinChoi': 'bert_qa_KevinChoi_bert_finetuned_squad_accelerate',
            'en.answer_question.squad.bert.accelerate.by_huggingface-course': 'bert_qa_huggingface_course_bert_finetuned_squad_accelerate',
            'en.answer_question.squad.bert.accelerate.by_peterhsu': 'bert_qa_peterhsu_bert_finetuned_squad_accelerate',
            'en.answer_question.squad.bert.accelerate.by_youngjae': 'bert_qa_youngjae_bert_finetuned_squad_accelerate',
            'en.answer_question.squad.bert.augmented': 'bert_qa_augmented_Squad_Translated',
            'en.answer_question.squad.bert.base': 'bert_qa_bert_mini_wrslb_finetuned_squadv1',
            'en.answer_question.squad.bert.base.by_mrm8488': 'bert_qa_bert_mini_wrslb_finetuned_squadv1',
            'en.answer_question.squad.bert.base.by_rsvp-ai': 'bert_qa_bertserini_bert_base_squad',
            'en.answer_question.squad.bert.base.by_vuiseng9': 'bert_qa_bert_base_squadv1',
            'en.answer_question.squad.bert.base.by_xraychen': 'bert_qa_squad_baseline',
            'en.answer_question.squad.bert.base.by_zhufy': 'bert_qa_squad_en_bert_base',
            'en.answer_question.squad.bert.base_cased': 'bert_qa_andresestevez_bert_base_cased_finetuned_squad',
            'en.answer_question.squad.bert.base_cased.by_KB': 'bert_qa_bert_base_swedish_cased_squad_experimental',
            'en.answer_question.squad.bert.base_cased.by_Seongkyu': 'bert_qa_Seongkyu_bert_base_cased_finetuned_squad',
            'en.answer_question.squad.bert.base_cased.by_SreyanG-NVIDIA': 'bert_qa_SreyanG_NVIDIA_bert_base_cased_finetuned_squad',
            'en.answer_question.squad.bert.base_cased.by_andresestevez': 'bert_qa_andresestevez_bert_base_cased_finetuned_squad',
            'en.answer_question.squad.bert.base_cased.by_batterydata': 'bert_qa_bert_base_cased_squad_v1',
            'en.answer_question.squad.bert.base_cased.by_ncduy': 'bert_qa_bert_base_cased_finetuned_squad_test',
            'en.answer_question.squad.bert.base_uncased': 'bert_qa_SreyanG_NVIDIA_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.1.1_block_sparse_0.32_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.32_v1',
            'en.answer_question.squad.bert.base_uncased.by_HomayounSadri': 'bert_qa_HomayounSadri_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_Intel': 'bert_qa_bert_base_uncased_squadv1.1_sparse_80_1x4_block_pruneofa',
            'en.answer_question.squad.bert.base_uncased.by_SreyanG-NVIDIA': 'bert_qa_SreyanG_NVIDIA_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_SupriyaArun': 'bert_qa_SupriyaArun_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_Tianle': 'bert_qa_Tianle_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_bdickson': 'bert_qa_bdickson_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_csarron': 'bert_qa_csarron_bert_base_uncased_squad_v1',
            'en.answer_question.squad.bert.base_uncased.by_jgammack': 'bert_qa_MTL_bert_base_uncased_ww_squad',
            'en.answer_question.squad.bert.base_uncased.by_jimypbr': 'bert_qa_jimypbr_bert_base_uncased_squad',
            'en.answer_question.squad.bert.base_uncased.by_kaporter': 'bert_qa_kaporter_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_lewtun': 'bert_qa_bert_base_uncased_finetuned_squad_v1',
            'en.answer_question.squad.bert.base_uncased.by_madlag': 'bert_qa_bert_base_uncased_squad_v1_sparse0.25',
            'en.answer_question.squad.bert.base_uncased.by_srmukundb': 'bert_qa_srmukundb_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_tli8hf': 'bert_qa_unqover_bert_base_uncased_squad',
            'en.answer_question.squad.bert.base_uncased.by_victoraavila': 'bert_qa_victoraavila_bert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.base_uncased.by_vuiseng9': 'bert_qa_vuiseng9_bert_base_uncased_squad',
            'en.answer_question.squad.bert.base_uncased.x1.16_f88.1_d8_unstruct.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x1.16_f88.1_d8_unstruct_v1',
            'en.answer_question.squad.bert.base_uncased_1024d_seed_42': 'bert_qa_bert_base_uncased_few_shot_k_1024_finetuned_squad_seed_42',
            'en.answer_question.squad.bert.base_uncased_128d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_128_finetuned_squad_seed_0',
            'en.answer_question.squad.bert.base_uncased_1_block_sparse_0.13_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x1.84_f88.7_d36_hybrid_filled_v1',
            'en.answer_question.squad.bert.base_uncased_1_block_sparse_0.20_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.13_v1',
            'en.answer_question.squad.bert.base_uncased_256d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_256_finetuned_squad_seed_0',
            'en.answer_question.squad.bert.base_uncased_32d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_32_finetuned_squad_seed_0',
            'en.answer_question.squad.bert.base_uncased_512d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_512_finetuned_squad_seed_0',
            'en.answer_question.squad.bert.base_uncased_64d_seed_0': 'bert_qa_bert_base_uncased_few_shot_k_64_finetuned_squad_seed_0',
            'en.answer_question.squad.bert.base_uncased_l3.by_howey': 'bert_qa_bert_base_uncased_squad_L3',
            'en.answer_question.squad.bert.base_uncased_l6.by_howey': 'bert_qa_bert_base_uncased_squad_L6',
            'en.answer_question.squad.bert.base_uncased_seed_42': 'bert_qa_bert_base_uncased_few_shot_k_16_finetuned_squad_seed_42',
            'en.answer_question.squad.bert.base_uncased_v2': 'bert_qa_bert_base_uncased_squad1.1_pruned_x3.2_v2',
            'en.answer_question.squad.bert.base_uncased_v2.by_ericRosello': 'bert_qa_bert_base_uncased_finetuned_squad_frozen_v2',
            'en.answer_question.squad.bert.base_uncased_v2.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_pruned_x3.2_v2',
            'en.answer_question.squad.bert.base_uncased_x1.16_f88.1_d8_unstruct_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.20_v1',
            'en.answer_question.squad.bert.base_uncased_x1.84_f88.7_d36_hybrid_filled_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x1.96_f88.3_d27_hybrid_filled_opt_v1',
            'en.answer_question.squad.bert.base_uncased_x1.96_f88.3_d27_hybrid_filled_opt_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x2.01_f89.2_d30_hybrid_rewind_opt_v1',
            'en.answer_question.squad.bert.base_uncased_x2.01_f89.2_d30_hybrid_rewind_opt_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x2.32_f86.6_d15_hybrid_v1',
            'en.answer_question.squad.bert.base_uncased_x2.32_f86.6_d15_hybrid_v1.by_madlag': 'bert_qa_bert_base_uncased_squadv1_x2.44_f87.7_d26_hybrid_filled_v1',
            'en.answer_question.squad.bert.base_uncased_x2.44_f87.7_d26_hybrid_filled_v1.by_madlag': 'bert_qa_bert_base_uncased_squad1.1_block_sparse_0.07_v1',
            'en.answer_question.squad.bert.by_Alexander-Learn': 'bert_qa_Alexander_Learn_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_ArpanZS': 'bert_qa_debug_squad',
            'en.answer_question.squad.bert.by_DaisyMak': 'bert_qa_bert_finetuned_squad_accelerate_10epoch_transformerfrozen',
            'en.answer_question.squad.bert.by_Danastos': 'bert_qa_squad_bert_el_Danastos',
            'en.answer_question.squad.bert.by_FardinSaboori': 'bert_qa_FardinSaboori_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_Ghost1': 'bert_qa_bert_finetuned_squad1',
            'en.answer_question.squad.bert.by_Harsit': 'bert_qa_Harsit_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_KevinChoi': 'bert_qa_KevinChoi_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_Kutay': 'bert_qa_fine_tuned_squad_aip',
            'en.answer_question.squad.bert.by_Laikokwei': 'bert_qa_Laikokwei_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_Neulvo': 'bert_qa_Neulvo_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_andresestevez': 'bert_qa_andresestevez_bert_finetuned_squad_accelerate',
            'en.answer_question.squad.bert.by_ankitkupadhyay': 'bert_qa_ankitkupadhyay_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_datauma': 'bert_qa_datauma_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_hendrixcosta': 'bert_qa_bertimbau_squad1.1',
            'en.answer_question.squad.bert.by_huggingface-course': 'bert_qa_huggingface_course_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_jatinshah': 'bert_qa_jatinshah_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_maroo93': 'bert_qa_squad1.1',
            'en.answer_question.squad.bert.by_mrbalazs5': 'bert_qa_mrbalazs5_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_mrp': 'bert_qa_mrp_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_nickmuchi': 'bert_qa_nickmuchi_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_peterhsu': 'bert_qa_tf_bert_finetuned_squad',
            'en.answer_question.squad.bert.by_ruselkomp': 'bert_qa_tests_finetuned_squad_test_bert',
            'en.answer_question.squad.bert.by_spacemanidol': 'bert_qa_neuralmagic_bert_squad_12layer_0sparse',
            'en.answer_question.squad.bert.by_stevemobs': 'bert_qa_bert_finetuned_squad_pytorch',
            'en.answer_question.squad.bert.by_vanichandna': 'bert_qa_muril_finetuned_squad',
            'en.answer_question.squad.bert.by_youngjae': 'bert_qa_youngjae_bert_finetuned_squad',
            'en.answer_question.squad.bert.cased': 'bert_qa_bert_multi_cased_squad_sv_marbogusz',
            'en.answer_question.squad.bert.distilled_base_uncased': 'bert_qa_kamilali_distilbert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.distilled_base_uncased.by_huggingface': 'bert_qa_prunebert_base_uncased_6_finepruned_w_distil_squad',
            'en.answer_question.squad.bert.distilled_base_uncased.by_juliusco': 'bert_qa_juliusco_distilbert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.distilled_base_uncased.by_kamilali': 'bert_qa_kamilali_distilbert_base_uncased_finetuned_squad',
            'en.answer_question.squad.bert.large': 'bert_qa_sbert_large_nlu_ru_finetuned_squad',
            'en.answer_question.squad.bert.large.by_rsvp-ai': 'bert_qa_bertserini_bert_large_squad',
            'en.answer_question.squad.bert.large.by_ruselkomp': 'bert_qa_sbert_large_nlu_ru_finetuned_squad',
            'en.answer_question.squad.bert.large_cased': 'bert_qa_bert_large_cased_whole_word_masking_finetuned_squad',
            'en.answer_question.squad.bert.large_uncased': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad',
            'en.answer_question.squad.bert.large_uncased.by_Graphcore': 'bert_qa_Graphcore_bert_large_uncased_squad',
            'en.answer_question.squad.bert.large_uncased.by_haddadalwi': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad_finetuned_islamic_squad',
            'en.answer_question.squad.bert.large_uncased.by_howey': 'bert_qa_howey_bert_large_uncased_squad',
            'en.answer_question.squad.bert.large_uncased.by_internetoftim': 'bert_qa_internetoftim_bert_large_uncased_squad',
            'en.answer_question.squad.bert.large_uncased.by_ofirzaf': 'bert_qa_ofirzaf_bert_large_uncased_squad',
            'en.answer_question.squad.bert.large_uncased.by_uploaded by huggingface': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squad',
            'en.answer_question.squad.bert.large_uncased_sparse_80_1x4_block_pruneofa.by_Intel': 'bert_qa_bert_large_uncased_squadv1.1_sparse_80_1x4_block_pruneofa',
            'en.answer_question.squad.bert.large_uncased_sparse_90_unstructured.by_Intel': 'bert_qa_bert_large_uncased_squadv1.1_sparse_90_unstructured',
            'en.answer_question.squad.bert.medium': 'bert_qa_bert_medium_wrslb_finetuned_squadv1',
            'en.answer_question.squad.bert.medium.by_anas-awadalla': 'bert_qa_bert_medium_finetuned_squad',
            'en.answer_question.squad.bert.medium.by_mrm8488': 'bert_qa_bert_medium_wrslb_finetuned_squadv1',
            'en.answer_question.squad.bert.medium_finetuned.by_anas-awadalla': 'bert_qa_bert_medium_pretrained_finetuned_squad',
            'en.answer_question.squad.bert.mini_lm_base_uncased': 'bert_qa_MiniLM_L12_H384_uncased_finetuned_squad',
            'en.answer_question.squad.bert.ms_tuned.base.by_zhufy': 'bert_qa_squad_ms_bert_base',
            'en.answer_question.squad.bert.multilingual_base_cased': 'bert_qa_salti_bert_base_multilingual_cased_finetuned_squad',
            'en.answer_question.squad.bert.multilingual_base_cased.by_Paul-Vinh': 'bert_qa_Paul_Vinh_bert_base_multilingual_cased_finetuned_squad',
            'en.answer_question.squad.bert.multilingual_base_cased.by_salti': 'bert_qa_salti_bert_base_multilingual_cased_finetuned_squad',
            'en.answer_question.squad.bert.multilingual_base_cased.by_vanichandna': 'bert_qa_bert_base_multilingual_cased_finetuned_squadv1',
            'en.answer_question.squad.bert.multilingual_base_uncased': 'bert_qa_bert_base_multilingual_uncased_finetuned_squad',
            'en.answer_question.squad.bert.sl256.by_vuiseng9': 'bert_qa_bert_l_squadv1.1_sl256',
            'en.answer_question.squad.bert.sl384.by_vuiseng9': 'bert_qa_bert_l_squadv1.1_sl384',
            'en.answer_question.squad.bert.small': 'bert_qa_bert_small_wrslb_finetuned_squadv1',
            'en.answer_question.squad.bert.small.by_anas-awadalla': 'bert_qa_bert_small_finetuned_squad',
            'en.answer_question.squad.bert.small.by_mrm8488': 'bert_qa_bert_small_wrslb_finetuned_squadv1',
            'en.answer_question.squad.bert.small_finetuned.by_anas-awadalla': 'bert_qa_bert_small_pretrained_finetuned_squad',
            'en.answer_question.squad.bert.tiny': 'bert_qa_bert_tiny_finetuned_squad',
            'en.answer_question.squad.bert.v1.1.by_maroo93': 'bert_qa_squad1.1_1',
            'en.answer_question.squad.bert.v1.by_vanichandna': 'bert_qa_muril_finetuned_squadv1',
            'en.answer_question.squad.bert.v2.by_peterhsu': 'bert_qa_peterhsu_bert_finetuned_squad',
            'en.answer_question.squad.bert.v2.by_ruselkomp': 'bert_qa_tests_finetuned_squad_test_bert_2',
            'en.answer_question.squad.biobert.base_cased': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_biobert',
            'en.answer_question.squad.biobert.base_cased.by_dmis-lab': 'bert_qa_biobert_base_cased_v1.1_squad',
            'en.answer_question.squad.biobert.base_cased.by_juliusco': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_biobert',
            'en.answer_question.squad.bioformer.cased': 'bert_qa_bioformer_cased_v1.0_squad1',
            'en.answer_question.squad.covid_bert': 'bert_qa_covidbert_squad',
            'en.answer_question.squad.covid_biobert.base_cased': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_covbiobert',
            'en.answer_question.squad.covid_roberta.base_cased': 'bert_qa_biobert_base_cased_v1.1_squad_finetuned_covdrobert',
            'en.answer_question.squad.distil_bert': 'distilbert_qa_checkpoint_500_finetuned_squad',
            'en.answer_question.squad.distil_bert.base': 'distilbert_qa_base_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_cased': 'distilbert_qa_base_cased_distilled_squad_finetuned_squad_test',
            'en.answer_question.squad.distil_bert.base_cased.by_ncduy': 'distilbert_qa_base_cased_distilled_squad_finetuned_squad_test',
            'en.answer_question.squad.distil_bert.base_cased.by_uploaded by huggingface': 'distilbert_qa_base_cased_distilled_squad',
            'en.answer_question.squad.distil_bert.base_small_cased': 'distilbert_qa_base_cased_distilled_squad_finetuned_squad_small',
            'en.answer_question.squad.distil_bert.base_tiny_cased': 'distilbert_qa_tiny_base_cased_distilled_squad',
            'en.answer_question.squad.distil_bert.base_uncased': 'distilbert_qa_MYX4567_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_21iridescent': 'distilbert_qa_21iridescent_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Adrian': 'distilbert_qa_Adrian_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Ayoola': 'distilbert_qa_Ayoola_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_FOFer': 'distilbert_qa_FOFer_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Firat': 'distilbert_qa_Firat_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Gayathri': 'distilbert_qa_Gayathri_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Hoang': 'distilbert_qa_Hoang_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_HomayounSadri': 'distilbert_qa_HomayounSadri_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_MYX4567': 'distilbert_qa_MYX4567_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Nadhiya': 'distilbert_qa_Nadhiya_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_ParulChaudhari': 'distilbert_qa_ParulChaudhari_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Plimpton': 'distilbert_qa_Plimpton_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Raphaelg9': 'distilbert_qa_Raphaelg9_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Rocketknight1': 'distilbert_qa_Rocketknight1_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_SEISHIN': 'distilbert_qa_SEISHIN_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Shashidhar': 'distilbert_qa_Shashidhar_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Sourabh714': 'distilbert_qa_Sourabh714_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_SupriyaArun': 'distilbert_qa_SupriyaArun_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Thitaree': 'distilbert_qa_Thitaree_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Tianle': 'distilbert_qa_Tianle_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_V3RX2000': 'distilbert_qa_V3RX2000_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_Wiam': 'distilbert_qa_Wiam_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_aaraki': 'distilbert_qa_aaraki_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_abhinavkulkarni': 'distilbert_qa_abhinavkulkarni_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_akr': 'distilbert_qa_akr_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_andi611': 'distilbert_qa_andi611_base_uncased_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_anurag0077': 'distilbert_qa_base_uncased_finetuned_squad3',
            'en.answer_question.squad.distil_bert.base_uncased.by_arvalinno': 'distilbert_qa_arvalinno_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_avioo1': 'distilbert_qa_avioo1_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_bdickson': 'distilbert_qa_bdickson_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_caiosantillo': 'distilbert_qa_caiosantillo_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_deepakvk': 'distilbert_qa_base_uncased_distilled_squad_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_emre': 'distilbert_qa_emre_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_en': 'distilbert_qa_en_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_fadhilarkan': 'distilbert_qa_fadhilarkan_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_gokulkarthik': 'distilbert_qa_gokulkarthik_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_graviraja': 'distilbert_qa_graviraja_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_guhuawuli': 'distilbert_qa_guhuawuli_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_hark99': 'distilbert_qa_hark99_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_hcy11': 'distilbert_qa_hcy11_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_hiiii23': 'distilbert_qa_hiiii23_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_holtin': 'distilbert_qa_base_uncased_holtin_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_huggingfaceepita': 'distilbert_qa_huggingfaceepita_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_huxxx657': 'distilbert_qa_huxxx657_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_jgammack': 'distilbert_qa_jgammack_base_uncased_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_jhoonk': 'distilbert_qa_jhoonk_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_jsunster': 'distilbert_qa_jsunster_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_kaggleodin': 'distilbert_qa_kaggleodin_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_lewtun': 'distilbert_qa_base_uncased_finetuned_squad_v1',
            'en.answer_question.squad.distil_bert.base_uncased.by_machine2049': 'distilbert_qa_base_uncased_finetuned_squad_',
            'en.answer_question.squad.distil_bert.base_uncased.by_manudotc': 'distilbert_qa_transformers_base_uncased_finetuneQA_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_sunitha': 'distilbert_qa_base_uncased_3feb_2022_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_tli8hf': 'distilbert_qa_unqover_base_uncased_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_tucan9389': 'distilbert_qa_tucan9389_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_uploaded by huggingface': 'distilbert_qa_base_uncased_distilled_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_usami': 'distilbert_qa_usami_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_vitusya': 'distilbert_qa_vitusya_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_vkmr': 'distilbert_qa_vkmr_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased.by_vkrishnamoorthy': 'distilbert_qa_vkrishnamoorthy_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased_colab.by_Adrian': 'distilbert_qa_base_uncased_finetuned_squad_colab',
            'en.answer_question.squad.distil_bert.base_uncased_full.by_holtin': 'distilbert_qa_base_uncased_holtin_finetuned_full_squad',
            'en.answer_question.squad.distil_bert.base_uncased_mtl.by_jgammack': 'distilbert_qa_MTL_base_uncased_squad',
            'en.answer_question.squad.distil_bert.base_uncased_sae.by_jgammack': 'distilbert_qa_SAE_base_uncased_squad',
            'en.answer_question.squad.distil_bert.base_uncased_v2': 'distilbert_qa_base_uncased_finetuned_indosquad_v2',
            'en.answer_question.squad.distil_bert.base_uncased_v2.by_arvalinno': 'distilbert_qa_base_uncased_finetuned_indosquad_v2',
            'en.answer_question.squad.distil_bert.base_uncased_v2.by_ericRosello': 'distilbert_qa_base_uncased_finetuned_squad_frozen_v2',
            'en.answer_question.squad.distil_bert.base_uncased_v2.by_holtin': 'distilbert_qa_holtin_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.base_uncased_v2.by_huxxx657': 'distilbert_qa_base_uncased_finetuned_jumbling_squad_15',
            'en.answer_question.squad.distil_bert.base_uncased_v3.by_anurag0077': 'distilbert_qa_anurag0077_base_uncased_finetuned_squad',
            'en.answer_question.squad.distil_bert.by_AyushPJ': 'distilbert_qa_test_squad_trained_finetuned_squad',
            'en.answer_question.squad.distil_bert.by_ZYW': 'distilbert_qa_test_squad_trained',
            'en.answer_question.squad.distil_bert.by_abhilash1910': 'distilbert_qa_squadv1',
            'en.answer_question.squad.distil_bert.by_rowan1224': 'distilbert_qa_squad_slp',
            'en.answer_question.squad.distil_bert.by_sunitha': 'distilbert_qa_AQG_CV_Squad',
            'en.answer_question.squad.distil_bert.by_tabo': 'distilbert_qa_checkpoint_500_finetuned_squad',
            'en.answer_question.squad.electra': 'electra_qa_squad_slp',
            'en.answer_question.squad.electra.base': 'electra_qa_base_discriminator_finetuned_squad',
            'en.answer_question.squad.electra.base.by_Palak': 'electra_qa_google_base_discriminator_squad',
            'en.answer_question.squad.electra.base.by_mrm8488': 'electra_qa_base_finetuned_squadv1',
            'en.answer_question.squad.electra.base.by_usami': 'electra_qa_base_discriminator_finetuned_squad',
            'en.answer_question.squad.electra.base.by_valhalla': 'electra_qa_base_discriminator_finetuned_squadv1',
            'en.answer_question.squad.electra.large': 'electra_qa_large_squad',
            'en.answer_question.squad.electra.large.by_howey': 'electra_qa_large_squad',
            'en.answer_question.squad.electra.large.by_mrm8488': 'electra_qa_large_finetuned_squadv1',
            'en.answer_question.squad.electra.small': 'electra_qa_small_finetuned_squadv1',
            'en.answer_question.squad.electra.small.by_Palak': 'electra_qa_google_small_discriminator_squad',
            'en.answer_question.squad.electra.small.by_bdickson': 'electra_qa_small_discriminator_finetuned_squad_1',
            'en.answer_question.squad.electra.small.by_hankzhong': 'electra_qa_hankzhong_small_discriminator_finetuned_squad',
            'en.answer_question.squad.electra.small.by_mrm8488': 'electra_qa_small_finetuned_squadv1',
            'en.answer_question.squad.electra.small_v2.by_bdickson': 'electra_qa_small_discriminator_finetuned_squad_2',
            'en.answer_question.squad.ixam_bert.by_MarcBrun': 'bert_qa_ixambert_finetuned_squad',
            'en.answer_question.squad.ixam_bert.eu_en_tunedby_MarcBrun': 'bert_qa_ixambert_finetuned_squad_eu_en_MarcBrun',
            'en.answer_question.squad.ixam_bert.eu_tuned.by_MarcBrun': 'bert_qa_ixambert_finetuned_squad_eu_MarcBrun',
            'en.answer_question.squad.link_bert.large': 'bert_qa_linkbert_large_finetuned_squad',
            'en.answer_question.squad.multi_lingual_bert.by_ZYW': 'bert_qa_squad_mbert_model',
            'en.answer_question.squad.multi_lingual_bert.en_de_es.by_ZYW': 'bert_qa_squad_mbert_en_de_es_model',
            'en.answer_question.squad.multi_lingual_bert.en_de_es_vi_zh.by_ZYW': 'bert_qa_squad_mbert_en_de_es_vi_zh_model',
            'en.answer_question.squad.multi_lingual_bert.v2.by_ZYW': 'bert_qa_squad_mbert_model_2',
            'en.answer_question.squad.roberta': 'roberta_qa_roberta_l_squadv1.1',
            'en.answer_question.squad.roberta.base': 'roberta_qa_roberta_base_1B_1_finetuned_squadv1',
            'en.answer_question.squad.roberta.base.by_Firat': 'roberta_qa_Firat_roberta_base_finetuned_squad',
            'en.answer_question.squad.roberta.base.by_ahmedattia143': 'roberta_qa_roberta_squadv1_base',
            'en.answer_question.squad.roberta.base.by_csarron': 'roberta_qa_roberta_base_squad_v1',
            'en.answer_question.squad.roberta.base.by_huxxx657': 'roberta_qa_huxxx657_roberta_base_finetuned_squad',
            'en.answer_question.squad.roberta.base.by_jgammack': 'roberta_qa_roberta_base_squad',
            'en.answer_question.squad.roberta.base.by_mrm8488': 'roberta_qa_roberta_base_1B_1_finetuned_squadv1',
            'en.answer_question.squad.roberta.base.by_rahulchakwate': 'roberta_qa_rahulchakwate_roberta_base_finetuned_squad',
            'en.answer_question.squad.roberta.base.by_tli8hf': 'roberta_qa_unqover_roberta_base_squad',
            'en.answer_question.squad.roberta.base_1024d_seed_0': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_1024d_seed_10': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_1024d_seed_2': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_1024d_seed_4': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_1024d_seed_42': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_42',
            'en.answer_question.squad.roberta.base_1024d_seed_6': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_1024d_seed_8': 'roberta_qa_roberta_base_few_shot_k_1024_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_128d_seed_0': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_128d_seed_10': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_128d_seed_2': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_128d_seed_4': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_128d_seed_42': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_42',
            'en.answer_question.squad.roberta.base_128d_seed_6': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_128d_seed_8': 'roberta_qa_roberta_base_few_shot_k_128_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_256d_seed_0': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_256d_seed_10': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_256d_seed_2': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_256d_seed_4': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_256d_seed_6': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_256d_seed_8': 'roberta_qa_roberta_base_few_shot_k_256_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_32d_seed_0': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_32d_seed_10': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_32d_seed_2': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_32d_seed_4': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_32d_seed_6': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_32d_seed_8': 'roberta_qa_roberta_base_few_shot_k_32_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_512d_seed_0': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_512d_seed_10': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_512d_seed_2': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_512d_seed_4': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_512d_seed_6': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_512d_seed_8': 'roberta_qa_roberta_base_few_shot_k_512_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_64d_seed_0': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_64d_seed_10': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_64d_seed_2': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_64d_seed_4': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_64d_seed_6': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_64d_seed_8': 'roberta_qa_roberta_base_few_shot_k_64_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_deletion_10.by_huxxx657': 'roberta_qa_roberta_base_finetuned_deletion_squad_10',
            'en.answer_question.squad.roberta.base_deletion_15.by_huxxx657': 'roberta_qa_roberta_base_finetuned_deletion_squad_15',
            'en.answer_question.squad.roberta.base_sae.by_jgammack': 'roberta_qa_SAE_roberta_base_squad',
            'en.answer_question.squad.roberta.base_scrambled_10.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_10',
            'en.answer_question.squad.roberta.base_scrambled_10_new.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_10_new',
            'en.answer_question.squad.roberta.base_scrambled_15.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_15',
            'en.answer_question.squad.roberta.base_scrambled_15_v2.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_15_new',
            'en.answer_question.squad.roberta.base_scrambled_5.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_5',
            'en.answer_question.squad.roberta.base_scrambled_sq.by_huxxx657': 'roberta_qa_roberta_base_finetuned_scrambled_squad_5_new',
            'en.answer_question.squad.roberta.base_seed_0': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_0',
            'en.answer_question.squad.roberta.base_seed_10': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_10',
            'en.answer_question.squad.roberta.base_seed_2': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_2',
            'en.answer_question.squad.roberta.base_seed_4': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_4',
            'en.answer_question.squad.roberta.base_seed_42': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_42',
            'en.answer_question.squad.roberta.base_seed_6': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_6',
            'en.answer_question.squad.roberta.base_seed_8': 'roberta_qa_roberta_base_few_shot_k_16_finetuned_squad_seed_8',
            'en.answer_question.squad.roberta.base_v1.by_huxxx657': 'roberta_qa_roberta_base_finetuned_squad_1',
            'en.answer_question.squad.roberta.base_v2.by_huxxx657': 'roberta_qa_roberta_base_finetuned_squad_2',
            'en.answer_question.squad.roberta.base_v3.by_huxxx657': 'roberta_qa_roberta_base_finetuned_squad_3',
            'en.answer_question.squad.roberta.by_cgou': 'roberta_qa_fin_RoBERTa_v1_finetuned_squad',
            'en.answer_question.squad.roberta.by_sunitha': 'roberta_qa_Roberta_Custom_Squad_DS',
            'en.answer_question.squad.roberta.by_vuiseng9': 'roberta_qa_roberta_l_squadv1.1',
            'en.answer_question.squad.roberta.distilled': 'roberta_qa_distilroberta_finetuned_squadv1',
            'en.answer_question.squad.roberta.distilled_base': 'roberta_qa_distilroberta_base_squad',
            'en.answer_question.squad.roberta.large': 'roberta_qa_roberta_large_squad_v1',
            'en.answer_question.squad.roberta.large.by_csarron': 'roberta_qa_roberta_large_squad_v1',
            'en.answer_question.squad.roberta.large.by_rahulchakwate': 'roberta_qa_roberta_large_finetuned_squad',
            'en.answer_question.squad.scibert': 'bert_qa_scibert_nli_squad',
            'en.answer_question.squad.scibert.by_amoux': 'bert_qa_scibert_nli_squad',
            'en.answer_question.squad.scibert.by_ixa-ehu': 'bert_qa_SciBERT_SQuAD_QuAC',
            'en.answer_question.squad.scibert.uncased': 'bert_qa_scibert_scivocab_uncased_squad',
            'en.answer_question.squad.span_bert': 'bert_qa_spanbert_finetuned_squadv1',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_0',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_10',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_2': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_2',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_4': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_4',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_42': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_42',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_6',
            'en.answer_question.squad.span_bert.base_cased_1024d_seed_8': 'bert_qa_spanbert_base_cased_few_shot_k_1024_finetuned_squad_seed_8',
            'en.answer_question.squad.span_bert.base_cased_128d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_10',
            'en.answer_question.squad.span_bert.base_cased_128d_seed_4': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_4',
            'en.answer_question.squad.span_bert.base_cased_128d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_6',
            'en.answer_question.squad.span_bert.base_cased_128d_seed_8': 'bert_qa_spanbert_base_cased_few_shot_k_128_finetuned_squad_seed_8',
            'en.answer_question.squad.span_bert.base_cased_256d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_256_finetuned_squad_seed_10',
            'en.answer_question.squad.span_bert.base_cased_32d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_0',
            'en.answer_question.squad.span_bert.base_cased_32d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_10',
            'en.answer_question.squad.span_bert.base_cased_32d_seed_2': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_2',
            'en.answer_question.squad.span_bert.base_cased_32d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_32_finetuned_squad_seed_6',
            'en.answer_question.squad.span_bert.base_cased_512d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_0',
            'en.answer_question.squad.span_bert.base_cased_512d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_10',
            'en.answer_question.squad.span_bert.base_cased_512d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_6',
            'en.answer_question.squad.span_bert.base_cased_512d_seed_8': 'bert_qa_spanbert_base_cased_few_shot_k_512_finetuned_squad_seed_8',
            'en.answer_question.squad.span_bert.base_cased_64d_seed_0': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_0',
            'en.answer_question.squad.span_bert.base_cased_64d_seed_10': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_10',
            'en.answer_question.squad.span_bert.base_cased_64d_seed_2': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_2',
            'en.answer_question.squad.span_bert.base_cased_64d_seed_4': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_4',
            'en.answer_question.squad.span_bert.base_cased_64d_seed_6': 'bert_qa_spanbert_base_cased_few_shot_k_64_finetuned_squad_seed_6',
            'en.answer_question.squad.span_bert.base_cased_seed_42': 'bert_qa_spanbert_base_cased_few_shot_k_16_finetuned_squad_seed_42',
            'en.answer_question.squad.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_squad_v1.1',
            'en.answer_question.squad.xlm_roberta.by_jakobwes': 'xlm_roberta_qa_xlm_roberta_squad_v1.1',
            'en.answer_question.squad.xlm_roberta.by_meghana': 'xlm_roberta_qa_hitalmqa_finetuned_squad',
            'en.answer_question.squad_battery.bert.base_uncased': 'bert_qa_batterydata_bert_base_uncased_squad_v1',
            'en.answer_question.squad_battery.bert.cased.by_batterydata': 'bert_qa_batterybert_cased_squad_v1',
            'en.answer_question.squad_battery.bert.cased_only_bert.by_batterydata': 'bert_qa_batteryonlybert_cased_squad_v1',
            'en.answer_question.squad_battery.bert.uncased.by_batterydata': 'bert_qa_batterybert_uncased_squad_v1',
            'en.answer_question.squad_battery.bert.uncased_only_bert.by_batterydata': 'bert_qa_batteryonlybert_uncased_squad_v1',
            'en.answer_question.squad_battery.scibert.cased': 'bert_qa_batteryscibert_cased_squad_v1',
            'en.answer_question.squad_battery.scibert.uncased': 'bert_qa_batteryscibert_uncased_squad_v1',
            'en.answer_question.squad_ben_tel.bert.by_krinal214': 'bert_qa_bert_all_squad_ben_tel_context',
            'en.answer_question.squad_covid.bert': 'bert_qa_covid_squad',
            'en.answer_question.squad_pubmed.biobert': 'bert_qa_biobert_v1.1_pubmed_finetuned_squad',
            'en.answer_question.squad_translated.bert.by_krinal214': 'bert_qa_bert_all_squad_all_translated',
            'en.answer_question.squad_translated.bert.que.by_krinal214': 'bert_qa_bert_all_squad_que_translated',
            'en.answer_question.squadv2.albert.base_v2': 'albert_qa_vumichien_base_v2_squad2',
            'en.answer_question.squadv2.albert.base_v2.by_elgeish': 'albert_qa_cs224n_squad2.0_base_v2',
            'en.answer_question.squadv2.albert.base_v2.by_vumichien': 'albert_qa_vumichien_base_v2_squad2',
            'en.answer_question.squadv2.albert.large_v2': 'albert_qa_cs224n_squad2.0_large_v2',
            'en.answer_question.squadv2.albert.xl_v2': 'albert_qa_xlarge_v2_squad_v2',
            'en.answer_question.squadv2.albert.xxl': 'albert_qa_xxlarge_v1_finetuned_squad2',
            'en.answer_question.squadv2.albert.xxl.by_elgeish': 'albert_qa_cs224n_squad2.0_xxlarge_v1',
            'en.answer_question.squadv2.albert.xxl.by_replydotai': 'albert_qa_xxlarge_v1_finetuned_squad2',
            'en.answer_question.squadv2.albert.xxl.by_sultan': 'albert_qa_BioM_xxlarge_SQuAD2',
            'en.answer_question.squadv2.albert.xxl_512d': 'albert_qa_xxlargev1_squad2_512',
            'en.answer_question.squadv2.albert.xxl_v2': 'albert_qa_xxlarge_v2_squad2',
            'en.answer_question.squadv2.bert': 'bert_qa_squad2.0',
            'en.answer_question.squadv2.bert.base': 'bert_qa_bert_base_finetuned_squad2',
            'en.answer_question.squadv2.bert.base_cased': 'bert_qa_tf_bert_base_cased_squad2',
            'en.answer_question.squadv2.bert.base_cased.by_deepset': 'bert_base_cased_qa_squad2',
            'en.answer_question.squadv2.bert.base_cased.by_vumichien': 'bert_qa_tf_bert_base_cased_squad2',
            'en.answer_question.squadv2.bert.base_cased.by_ydshieh': 'bert_qa_ydshieh_bert_base_cased_squad2',
            'en.answer_question.squadv2.bert.base_uncased': 'bert_qa_deepset_bert_base_uncased_squad2',
            'en.answer_question.squadv2.bert.base_uncased.by_Vasanth': 'bert_qa_bert_base_uncased_qa_squad2',
            'en.answer_question.squadv2.bert.base_uncased.by_deepset': 'bert_qa_deepset_bert_base_uncased_squad2',
            'en.answer_question.squadv2.bert.base_uncased.by_twmkn9': 'bert_qa_twmkn9_bert_base_uncased_squad2',
            'en.answer_question.squadv2.bert.base_uncased_v2': 'bert_qa_bert_base_uncased_finetuned_squad_v2',
            'en.answer_question.squadv2.bert.base_v2.by_mrm8488': 'bert_qa_bert_mini_finetuned_squadv2',
            'en.answer_question.squadv2.bert.base_v2_5.by_mrm8488': 'bert_qa_bert_mini_5_finetuned_squadv2',
            'en.answer_question.squadv2.bert.by_augustoortiz': 'bert_qa_bert_finetuned_squad2',
            'en.answer_question.squadv2.bert.by_maroo93': 'bert_qa_squad2.0',
            'en.answer_question.squadv2.bert.by_pinecone': 'bert_qa_bert_reader_squad2',
            'en.answer_question.squadv2.bert.distilled': 'bert_qa_xdistil_l12_h384_squad2',
            'en.answer_question.squadv2.bert.distilled_medium': 'bert_qa_bert_medium_squad2_distilled',
            'en.answer_question.squadv2.bert.large': 'bert_qa_muril_large_squad2',
            'en.answer_question.squadv2.bert.large.by_Sindhu': 'bert_qa_muril_large_squad2',
            'en.answer_question.squadv2.bert.large.by_phiyodr': 'bert_qa_bert_large_finetuned_squad2',
            'en.answer_question.squadv2.bert.large_tiny_768d.by_MichelBartels': 'bert_qa_tinybert_6l_768d_squad2_large_teacher_finetuned',
            'en.answer_question.squadv2.bert.large_tiny_768d_v2.by_MichelBartels': 'bert_qa_tinybert_6l_768d_squad2_large_teacher_finetuned_step1',
            'en.answer_question.squadv2.bert.large_uncased': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_restaurant_with_neg_with_repeat',
            'en.answer_question.squadv2.bert.large_uncased.by_Salesforce': 'bert_qa_qaconv_bert_large_uncased_whole_word_masking_squad2',
            'en.answer_question.squadv2.bert.large_uncased.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_mit_restaurant_with_neg_with_repeat',
            'en.answer_question.squadv2.bert.large_uncased.by_deepset': 'bert_qa_bert_large_uncased_whole_word_masking_squad2',
            'en.answer_question.squadv2.bert.large_uncased_v2.by_madlag': 'bert_qa_bert_large_uncased_squadv2',
            'en.answer_question.squadv2.bert.large_uncased_v2_x2.15_f83.2_d25_hybrid.by_madlag': 'bert_qa_bert_large_uncased_wwm_squadv2_x2.15_f83.2_d25_hybrid_v1',
            'en.answer_question.squadv2.bert.large_uncased_v2_x2.63_f82.6_d16_hybrid.by_madlag': 'bert_qa_bert_large_uncased_wwm_squadv2_x2.63_f82.6_d16_hybrid_v1',
            'en.answer_question.squadv2.bert.large_uncased_whole_word_masking_v2.by_madlag': 'bert_qa_bert_large_uncased_whole_word_masking_finetuned_squadv2',
            'en.answer_question.squadv2.bert.medium_v2': 'bert_qa_bert_medium_finetuned_squadv2',
            'en.answer_question.squadv2.bert.mini_lm_base_uncased': 'bert_qa_minilm_uncased_squad2',
            'en.answer_question.squadv2.bert.small.by_mrm8488': 'bert_qa_bert_small_finetuned_squadv2',
            'en.answer_question.squadv2.bert.small_v2.by_mrm8488': 'bert_qa_bert_small_2_finetuned_squadv2',
            'en.answer_question.squadv2.bert.tiny_.by_mrm8488': 'bert_qa_bert_tiny_finetuned_squadv2',
            'en.answer_question.squadv2.bert.tiny_768d': 'bert_qa_tinybert_6l_768d_squad2',
            'en.answer_question.squadv2.bert.tiny_v2.by_mrm8488': 'bert_qa_bert_tiny_2_finetuned_squadv2',
            'en.answer_question.squadv2.bert.tiny_v3.by_mrm8488': 'bert_qa_bert_tiny_3_finetuned_squadv2',
            'en.answer_question.squadv2.bert.tiny_v4.by_mrm8488': 'bert_qa_bert_tiny_4_finetuned_squadv2',
            'en.answer_question.squadv2.bert.tiny_v5.by_mrm8488': 'bert_qa_bert_tiny_5_finetuned_squadv2',
            'en.answer_question.squadv2.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_squad2',
            'en.answer_question.squadv2.bert.uncased_2l_512d_a8a_512d': 'bert_qa_bert_uncased_L_2_H_512_A_8_squad2',
            'en.answer_question.squadv2.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_squad2',
            'en.answer_question.squadv2.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_squad2',
            'en.answer_question.squadv2.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_squad2',
            'en.answer_question.squadv2.bert.uncased_6l_128d_a2a_128d': 'bert_qa_bert_uncased_L_6_H_128_A_2_squad2',
            'en.answer_question.squadv2.biobert.cased': 'bert_qa_biobert_squad2_cased',
            'en.answer_question.squadv2.biobert.cased.by_clagator': 'bert_qa_biobert_squad2_cased',
            'en.answer_question.squadv2.biobert.cased.by_ptnv-s': 'bert_qa_biobert_squad2_cased_finetuned_squad',
            'en.answer_question.squadv2.deberta': 'deberta_v3_xsmall_qa_squad2',
            'en.answer_question.squadv2.distil_bert.base': 'distilbert_qa_base_squad2_custom_dataset',
            'en.answer_question.squadv2.distil_bert.base_cased': 'distilbert_base_cased_qa_squad2',
            'en.answer_question.squadv2.distil_bert.base_uncased': 'distilbert_qa_mvonwyl_base_uncased_finetuned_squad2',
            'en.answer_question.squadv2.distil_bert.base_uncased.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_mit_restaurant_with_neg_with_repeat',
            'en.answer_question.squadv2.distil_bert.base_uncased.by_anurag0077': 'distilbert_qa_anurag0077_base_uncased_finetuned_squad2',
            'en.answer_question.squadv2.distil_bert.base_uncased.by_mvonwyl': 'distilbert_qa_mvonwyl_base_uncased_finetuned_squad2',
            'en.answer_question.squadv2.distil_bert.base_uncased.by_tabo': 'distilbert_qa_tabo_base_uncased_finetuned_squad2',
            'en.answer_question.squadv2.distil_bert.base_uncased.by_twmkn9': 'distilbert_qa_base_uncased_squad2',
            'en.answer_question.squadv2.distil_bert.by_threem': 'distilbert_qa_mysquadv2_finetuned_squad',
            'en.answer_question.squadv2.distil_bert.v2.by_threem': 'distilbert_qa_mysquadv2_8Jan22_finetuned_squad',
            'en.answer_question.squadv2.electra.base': 'electra_qa_base_best_squad2',
            'en.answer_question.squadv2.electra.base.by_PremalMatalia': 'electra_qa_base_best_squad2',
            'en.answer_question.squadv2.electra.base.by_navteca': 'electra_qa_base_squad2',
            'en.answer_question.squadv2.electra.base.by_sultan': 'electra_qa_BioM_Base_SQuAD2',
            'en.answer_question.squadv2.electra.base_v2': 'electra_qa_base_finetuned_squadv2',
            'en.answer_question.squadv2.electra.large': 'electra_qa_BioM_Large_SQuAD2',
            'en.answer_question.squadv2.electra.large.by_sultan': 'electra_qa_BioM_Large_SQuAD2',
            'en.answer_question.squadv2.electra.large.by_superspray': 'electra_qa_large_discriminator_squad2_custom_dataset',
            'en.answer_question.squadv2.electra.large_512d': 'electra_qa_large_discriminator_squad2_512',
            'en.answer_question.squadv2.electra.small_v2': 'electra_qa_small_finetuned_squadv2',
            'en.answer_question.squadv2.longformer.base': 'longformer_base_base_qa_squad2',
            'en.answer_question.squadv2.longformer.base_v2': 'longformer_qa_base_4096_finetuned_squadv2',
            'en.answer_question.squadv2.roberta.base': 'roberta_qa_navteca_roberta_base_squad2',
            'en.answer_question.squadv2.roberta.base.by_21iridescent': 'roberta_qa_RoBERTa_base_finetuned_squad2_lwt',
            'en.answer_question.squadv2.roberta.base.by_AnonymousSub': 'roberta_qa_roberta_base_squad2.0',
            'en.answer_question.squadv2.roberta.base.by_PremalMatalia': 'roberta_qa_roberta_base_best_squad2',
            'en.answer_question.squadv2.roberta.base.by_Shappey': 'roberta_qa_roberta_base_QnA_squad2_trained',
            'en.answer_question.squadv2.roberta.base.by_Teepika': 'roberta_qa_roberta_base_squad2_finetuned_selqa',
            'en.answer_question.squadv2.roberta.base.by_avioo1': 'roberta_qa_avioo1_roberta_base_squad2_finetuned_squad',
            'en.answer_question.squadv2.roberta.base.by_deepakvk': 'roberta_qa_deepakvk_roberta_base_squad2_finetuned_squad',
            'en.answer_question.squadv2.roberta.base.by_deepset': 'roberta_base_qa_squad2',
            'en.answer_question.squadv2.roberta.base.by_mvonwyl': 'roberta_qa_roberta_base_finetuned_squad2',
            'en.answer_question.squadv2.roberta.base.by_navteca': 'roberta_qa_navteca_roberta_base_squad2',
            'en.answer_question.squadv2.roberta.base.by_nlpconnect': 'roberta_qa_roberta_base_squad2_nq',
            'en.answer_question.squadv2.roberta.base.by_prk': 'roberta_qa_prk_roberta_base_squad2_finetuned_squad',
            'en.answer_question.squadv2.roberta.base.by_shahrukhx01': 'roberta_qa_roberta_base_squad2_boolq_baseline',
            'en.answer_question.squadv2.roberta.base.by_sumba': 'roberta_qa_sumba_roberta_base_squad2_finetuned_squad',
            'en.answer_question.squadv2.roberta.base.by_ydshieh': 'roberta_qa_ydshieh_roberta_base_squad2',
            'en.answer_question.squadv2.roberta.base_rule_based_hier_quadruplet_0.1_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_quadruplet_0.1_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_hier_quadruplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_quadruplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_hier_triplet_0.1_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_triplet_0.1_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_hier_triplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_hier_triplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_only_classfn_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_only_classfn_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_only_classfn_twostage_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_only_classfn_twostage_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_quadruplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_bert_quadruplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_twostage_quadruplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostage_quadruplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_twostagequadruplet_hier_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostagequadruplet_hier_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_twostagetriplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostagetriplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_rule_based_twostagetriplet_hier_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_twostagetriplet_hier_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_ruletriplet_epochs_1_shard_1.by_AnonymousSub': 'roberta_qa_rule_based_roberta_bert_triplet_epochs_1_shard_1_squad2.0',
            'en.answer_question.squadv2.roberta.base_v2': 'roberta_qa_roberta_base_1B_1_finetuned_squadv2',
            'en.answer_question.squadv2.roberta.base_v2.by_AyushPJ': 'roberta_qa_ai_club_inductions_21_nlp_roBERTa_base_squad_v2',
            'en.answer_question.squadv2.roberta.base_v2.by_mrm8488': 'roberta_qa_roberta_base_1B_1_finetuned_squadv2',
            'en.answer_question.squadv2.roberta.cline.by_AnonymousSub': 'roberta_qa_cline_squad2.0',
            'en.answer_question.squadv2.roberta.declutr.by_AnonymousSub': 'roberta_qa_declutr_model_squad2.0',
            'en.answer_question.squadv2.roberta.distilled_base': 'roberta_qa_distilroberta_base_finetuned_squad2_lwt',
            'en.answer_question.squadv2.roberta.distilled_base.by_21iridescent': 'roberta_qa_distilroberta_base_finetuned_squad2_lwt',
            'en.answer_question.squadv2.roberta.distilled_base.by_deepset': 'roberta_qa_roberta_base_squad2_distilled',
            'en.answer_question.squadv2.roberta.distilled_base.by_twmkn9': 'roberta_qa_distilroberta_base_squad2',
            'en.answer_question.squadv2.roberta.distilled_base_128d_32d_v2': 'roberta_qa_distilrobert_base_squadv2_328seq_128stride_test',
            'en.answer_question.squadv2.roberta.distilled_base_v2': 'roberta_qa_distilroberta_base_squad_v2',
            'en.answer_question.squadv2.roberta.emanuals.by_AnonymousSub': 'roberta_qa_EManuals_RoBERTa_squad2.0',
            'en.answer_question.squadv2.roberta.large': 'roberta_qa_roberta_large_squad2',
            'en.answer_question.squadv2.roberta.large.by_Salesforce': 'roberta_qa_qaconv_roberta_large_squad2',
            'en.answer_question.squadv2.roberta.large.by_deepset': 'roberta_qa_roberta_large_squad2_hp',
            'en.answer_question.squadv2.roberta.large.by_navteca': 'roberta_qa_roberta_large_squad2',
            'en.answer_question.squadv2.roberta.large.by_phiyodr': 'roberta_qa_roberta_large_finetuned_squad2',
            'en.answer_question.squadv2.roberta.tiny.by_deepset': 'roberta_qa_tinyroberta_squad2',
            'en.answer_question.squadv2.roberta.tiny.v2.by_deepset': 'roberta_qa_tinyroberta_squad2_step1',
            'en.answer_question.squadv2.scibert.uncased_v2': 'bert_qa_scibert_scivocab_uncased_squad_v2',
            'en.answer_question.squadv2.span_bert.v2': 'bert_qa_spanbert_finetuned_squadv2',
            'en.answer_question.squadv2.xlm_roberta.base': 'xlm_roberta_base_qa_squad2',
            'en.answer_question.squadv2.xlm_roberta.base.by_deepset': 'xlm_roberta_base_qa_squad2',
            'en.answer_question.squadv2.xlm_roberta.base_24465514.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465514',
            'en.answer_question.squadv2.xlm_roberta.base_24465515.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465515',
            'en.answer_question.squadv2.xlm_roberta.base_24465516.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465516',
            'en.answer_question.squadv2.xlm_roberta.base_24465517.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465517',
            'en.answer_question.squadv2.xlm_roberta.base_24465518.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465518',
            'en.answer_question.squadv2.xlm_roberta.base_24465519.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465519',
            'en.answer_question.squadv2.xlm_roberta.base_24465520.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465520',
            'en.answer_question.squadv2.xlm_roberta.base_24465521.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465521',
            'en.answer_question.squadv2.xlm_roberta.base_24465522.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465522',
            'en.answer_question.squadv2.xlm_roberta.base_24465523.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465523',
            'en.answer_question.squadv2.xlm_roberta.base_24465524.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465524',
            'en.answer_question.squadv2.xlm_roberta.base_24465525.by_teacookies': 'xlm_roberta_qa_autonlp_roberta_base_squad2_24465525',
            'en.answer_question.squadv2.xlm_roberta.base_v2': 'xlm_roberta_qa_squadv2_xlm_roberta_base',
            'en.answer_question.squadv2.xlm_roberta.distilled_base': 'xlm_roberta_qa_xlm_roberta_base_squad2_distilled',
            'en.answer_question.squadv2.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_squad2',
            'en.answer_question.squadv2_bioasq8b.electra.base': 'electra_qa_BioM_Base_SQuAD2_BioASQ8B',
            'en.answer_question.squadv2_bioasq8b.electra.large': 'electra_qa_BioM_Large_SQuAD2_BioASQ8B',
            'en.answer_question.squadv2_chaii.xlm_roberta.distilled_base': 'xlm_roberta_qa_xlm_roberta_base_squad2_distilled_finetuned_chaii',
            'en.answer_question.squadv2_chaii.xlm_roberta.distilled_base_small': 'xlm_roberta_qa_xlm_roberta_base_squad2_distilled_finetuned_chaii_small',
            'en.answer_question.squadv2_chemical.bert.uncased': 'bert_qa_chemical_bert_uncased_squad2',
            'en.answer_question.squadv2_conll.bert.large_uncased.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_conll2003_with_neg_with_repeat',
            'en.answer_question.squadv2_conll.bert.large_uncased_pistherea.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_Pistherea_conll2003_with_neg_with_repeat',
            'en.answer_question.squadv2_conll.bert.large_uncased_pwhatisthe.by_andi611': 'bert_qa_bert_large_uncased_whole_word_masking_squad2_with_ner_Pwhatisthe_conll2003_with_neg_with_repeat',
            'en.answer_question.squadv2_conll.distil_bert.base_uncased.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner',
            'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg',
            'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg_with_multi.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_multi',
            'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg_with_multi_with_repeat.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_multi_with_repeat',
            'en.answer_question.squadv2_conll.distil_bert.base_uncased_with_neg_with_repeat.by_andi611': 'distilbert_qa_base_uncased_squad2_with_ner_with_neg_with_repeat',
            'en.answer_question.squadv2_cord19.bert.small': 'bert_qa_bert_small_cord19_squad2',
            'en.answer_question.squadv2_cord19.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_cord19_200616_squad2',
            'en.answer_question.squadv2_cord19.bert.uncased_2l_512d_a8a_512d': 'bert_qa_bert_uncased_L_2_H_512_A_8_cord19_200616_squad2',
            'en.answer_question.squadv2_cord19.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_cord19_200616_squad2',
            'en.answer_question.squadv2_cord19.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_cord19_200616_squad2',
            'en.answer_question.squadv2_cord19.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_cord19_200616_squad2',
            'en.answer_question.squadv2_covid.albert.xxl_v2': 'albert_qa_xxlarge_v2_squad2_covid_deepset',
            'en.answer_question.squadv2_covid.bert.base_uncased': 'bert_qa_bert_base_uncased_squad2_covid_qa_deepset',
            'en.answer_question.squadv2_covid.bert.large_uncased': 'bert_qa_bert_large_uncased_squad2_covid_qa_deepset',
            'en.answer_question.squadv2_covid.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_squad2_covid_qna',
            'en.answer_question.squadv2_covid.bert.uncased_2l_512d_a8a_512d': 'bert_qa_bert_uncased_L_2_H_512_A_8_squad2_covid_qna',
            'en.answer_question.squadv2_covid.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_squad2_covid_qna',
            'en.answer_question.squadv2_covid.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_squad2_covid_qna',
            'en.answer_question.squadv2_covid.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_squad2_covid_qna',
            'en.answer_question.squadv2_covid.bert.uncased_6l_128d_a2a_128d': 'bert_qa_bert_uncased_L_6_H_128_A_2_squad2_covid_qna',
            'en.answer_question.squadv2_covid.distil_bert.base_uncased': 'distilbert_qa_base_uncased_squad2_covid_qa_deepset',
            'en.answer_question.squadv2_covid.electra.base': 'electra_qa_base_squad2_covid_deepset',
            'en.answer_question.squadv2_covid.roberta.base': 'roberta_qa_roberta_base_squad2_covid',
            'en.answer_question.squadv2_covid.roberta.base.by_armageddon': 'roberta_qa_roberta_base_squad2_covid_qa_deepset',
            'en.answer_question.squadv2_covid.roberta.base.by_deepset': 'roberta_qa_roberta_base_squad2_covid',
            'en.answer_question.squadv2_covid.roberta.large': 'roberta_qa_roberta_large_squad2_covid_qa_deepset',
            'en.answer_question.squadv2_covid_cord19.bert.uncased_10l_512d_a8a_512d': 'bert_qa_bert_uncased_L_10_H_512_A_8_cord19_200616_squad2_covid_qna',
            'en.answer_question.squadv2_covid_cord19.bert.uncased_4l_256d_a4a_256d': 'bert_qa_bert_uncased_L_4_H_256_A_4_cord19_200616_squad2_covid_qna',
            'en.answer_question.squadv2_covid_cord19.bert.uncased_4l_512d_a8a_512d': 'bert_qa_bert_uncased_L_4_H_512_A_8_cord19_200616_squad2_covid_qna',
            'en.answer_question.squadv2_covid_cord19.bert.uncased_4l_768d_a12a_768d': 'bert_qa_bert_uncased_L_4_H_768_A_12_cord19_200616_squad2_covid_qna',
            'en.answer_question.squadv2_pubmed.bert.v2': 'bert_qa_pubmed_bert_squadv2',
            'en.answer_question.squadv2_pubmed.biobert.v2': 'bert_qa_biobert_v1.1_pubmed_squad_v2',
            'en.answer_question.squadv2_pubmed.sapbert': 'bert_qa_sapbert_from_pubmedbert_squad2',
            'en.answer_question.synqa.electra.large': 'electra_qa_large_synqa',
            'en.answer_question.synqa.roberta.large.by_mbartolo': 'roberta_qa_roberta_large_synqa',
            'en.answer_question.synqa_ext.roberta.large.by_mbartolo': 'roberta_qa_roberta_large_synqa_ext',
            'en.answer_question.tapas': 'table_qa_table_question_answering_tapas',
            'en.answer_question.tapas.by_uploaded by huggingface': 'table_qa_tapas_temporary_repo',
            'en.answer_question.tapas.sqa.base_finetuned': 'table_qa_tapas_base_finetuned_sqa',
            'en.answer_question.tapas.sqa.large_finetuned': 'table_qa_tapas_large_finetuned_sqa',
            'en.answer_question.tapas.sqa.medium_finetuned': 'table_qa_tapas_medium_finetuned_sqa',
            'en.answer_question.tapas.sqa.mini_finetuned': 'table_qa_tapas_mini_finetuned_sqa',
            'en.answer_question.tapas.sqa.small_finetuned': 'table_qa_tapas_small_finetuned_sqa',
            'en.answer_question.tapas.sqa.tiny_finetuned': 'table_qa_tapas_tiny_finetuned_sqa',
            'en.answer_question.tapas.wikisql.base_finetuned': 'table_qa_tapas_base_finetuned_wikisql_supervised',
            'en.answer_question.tapas.wikisql.large_finetuned': 'table_qa_tapas_large_finetuned_wikisql_supervised',
            'en.answer_question.tapas.wikisql.medium_finetuned': 'table_qa_tapas_medium_finetuned_wikisql_supervised',
            'en.answer_question.tapas.wikisql.small_finetuned': 'table_qa_tapas_small_finetuned_wikisql_supervised',
            'en.answer_question.tapas.wtq.large_finetuned': 'table_qa_tapas_large_finetuned_wtq',
            'en.answer_question.tapas.wtq.medium_finetuned': 'table_qa_tapas_medium_finetuned_wtq',
            'en.answer_question.tapas.wtq.mini_finetuned': 'table_qa_tapas_mini_finetuned_wtq',
            'en.answer_question.tapas.wtq.small_finetuned': 'table_qa_tapas_small_finetuned_wtq',
            'en.answer_question.tapas.wtq.tiny_finetuned': 'table_qa_tapas_tiny_finetuned_wtq',
            'en.answer_question.tquad.bert.xtremedistiled_uncased': 'bert_qa_xtremedistil_l6_h256_uncased_TQUAD_finetuned_lr_2e_05_epochs_9',
            'en.answer_question.trial.bert.by_sunitha': 'bert_qa_Trial_3_Results',
            'en.answer_question.trivia.albert.xxl': 'albert_qa_xxlarge_tweetqa',
            'en.answer_question.trivia.bert': 'bert_qa_fine_tuned_tweetqa_aip',
            'en.answer_question.trivia.bert.base_1024d': 'bert_qa_bert_base_1024_full_trivia_copied_embeddings',
            'en.answer_question.trivia.bert.base_2048.by_MrAnderson': 'bert_qa_bert_base_2048_full_trivia_copied_embeddings',
            'en.answer_question.trivia.bert.base_4096.by_MrAnderson': 'bert_qa_bert_base_4096_full_trivia_copied_embeddings',
            'en.answer_question.trivia.bert.base_512d': 'bert_qa_bert_base_512_full_trivia',
            'en.answer_question.trivia.bert.by_Danastos': 'bert_qa_triviaqa_bert_el_Danastos',
            'en.answer_question.trivia.bert.by_Kutay': 'bert_qa_fine_tuned_tweetqa_aip',
            'en.answer_question.trivia.distil_bert.base_uncased': 'distilbert_qa_base_uncased_finetuned_triviaqa',
            'en.answer_question.trivia.longformer.large': 'longformer_qa_large_4096_finetuned_triviaqa',
            'en.answer_question.trivia.roberta': 'roberta_qa_roberta_fine_tuned_tweet_sentiment_extractor',
            'en.answer_question.trivia.roberta.base': 'roberta_qa_roberta_base_tweetqa_model',
            'en.answer_question.trivia.roberta.large': 'roberta_qa_roberta_large_tweetqa',
            'en.answer_question.trivia.xlmr_roberta.large': 'xlm_roberta_qa_xlmroberta_large_tweetqa',
            'en.answer_question.tydiqa.bert': 'bert_qa_bert_all',
            'en.answer_question.tydiqa.bert.multilingual': 'bert_qa_Part_2_BERT_Multilingual_Dutch_Model_E1',
            'en.answer_question.tydiqa.distil_bert': 'distilbert_qa_multi_finetuned_for_xqua_on_tydiqa',
            'en.answer_question.tydiqa.multi_lingual_bert': 'bert_qa_Part_2_mBERT_Model_E2',
            'en.answer_question.tydiqa.roberta': 'roberta_qa_roberta_tydiqa',
            'en.answer_question.tydiqa.xlm_roberta': 'xlm_roberta_qa_xlm_all',
            'en.answer_question.tydiqa.xlm_roberta.3lang': 'xlm_roberta_qa_xlm_3lang',
            'en.answer_question.tydiqa.xlm_roberta.by_horsbug98': 'xlm_roberta_qa_Part_1_XLM_Model_E1',
            'en.answer_question.tydiqa.xlm_roberta.by_krinal214': 'xlm_roberta_qa_xlm_all',
            'en.answer_question.tydiqa.xlm_roberta.v2.by_horsbug98': 'xlm_roberta_qa_Part_2_XLM_Model_E1',
            'en.answer_question.xlm_roberta': 'xlm_roberta_qa_mrc2reader',
            'en.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_finetune_qa',
            'en.answer_question.xlm_roberta.by_Dongjae': 'xlm_roberta_qa_mrc2reader',
            'en.answer_question.xlm_roberta.by_Srini99': 'xlm_roberta_qa_TQA',
            'en.answer_question.xlm_roberta.by_anukaver': 'xlm_roberta_qa_xlm_roberta_est_qa',
            'en.answer_question.xlm_roberta.by_jeew': 'xlm_roberta_qa_xlm_roberta_ckpt_95000',
            'en.answer_question.xlm_roberta.by_laifuchicago': 'xlm_roberta_qa_farm2tran',
            'en.answer_question.xlm_roberta.by_ncthuan': 'xlm_roberta_qa_xlm_l_uetqa',
            'en.answer_question.xlm_roberta.distilled': 'xlm_roberta_qa_distill_xlm_mrc',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265897': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265897',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265898': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265898',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265899': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265899',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265900': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265900',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265901': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265901',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265902': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265902',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265903': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265903',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265904': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265904',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265905': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265905',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265906': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265906',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265907': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265907',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265908': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265908',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265909': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265909',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265910': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265910',
            'en.answer_question.xlm_roberta.fine_tune_24465520_26265911': 'xlm_roberta_qa_autonlp_more_fine_tune_24465520_26265911',
            'en.answer_question.xlm_roberta.fr_tuned.by_Gantenbein': 'roberta_qa_ADDI_FR_XLM_R',
            'en.answer_question.xlmr_roberta': 'xlm_roberta_qa_XLMr_ENIS_QA_IsQ_EnA',
            'en.answer_question.xquad.bert.multilingual_base': 'bert_qa_bert_base_multilingual_xquad',
            'en.answer_question.xquad.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_xquad',
            'en.answer_question.xquad.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_xquad',
            'en.answer_question.xquad_chaii.bert.cased': 'bert_qa_bert_multi_cased_finedtuned_xquad_chaii',
            'en.answer_question.xquad_squad.bert.cased': 'bert_qa_bert_multi_cased_finetuned_xquadv1_finetuned_squad_colab',
            'en.bert': 'bert_base_uncased',
            'en.chunk': 'default_chunker',
            'en.classify.acts_feedback.roberta.by_mp6kv': 'roberta_classifier_acts_feedback1',
            'en.classify.ag_news.longformer': 'longformer_base_sequence_classifier_ag_news',
            'en.classify.ag_news.xlnet': 'xlnet_base_sequence_classifier_ag_news',
            'en.classify.albert.ag_news': 'albert_base_sequence_classifier_ag_news',
            'en.classify.albert.imdb': 'albert_base_sequence_classifier_imdb',
            'en.classify.bbc.roberta.by_abhishek': 'roberta_classifier_autonlp_bbc_37249301',
            'en.classify.bert': 'bert_sequence_classifier_antisemitism',
            'en.classify.bert.64d': 'bert_classifier_autonlp_cai_out_of_scope_649919116',
            'en.classify.bert.amazon.uncased_base': 'bert_classifier_base_uncased_amazon_polarity',
            'en.classify.bert.amazon_sentiment.': 'bert_classifier_amazon_review_sentiment_analysis',
            'en.classify.bert.banking.': 'bert_classifier_bert_banking77',
            'en.classify.bert.base': 'bert_classifier_base_gpt2detector_topp92',
            'en.classify.bert.base.by_beomi': 'bert_classifier_beep_kc_base_bias',
            'en.classify.bert.base.by_cffl': 'bert_classifier_base_styleclassification_subjective_neutral',
            'en.classify.bert.base.by_zamachi': 'bert_classifier_base_for_multilabel_sentence_classification',
            'en.classify.bert.base_finetuned': 'bert_sequence_classifier_electricidad_base_finetuned_sst2',
            'en.classify.bert.base_random.by_baykenney': 'bert_classifier_base_gpt2detector_random',
            'en.classify.bert.base_topk40.by_baykenney': 'bert_classifier_base_gpt2detector_topk40',
            'en.classify.bert.base_topp96.by_baykenney': 'bert_classifier_base_gpt2detector_topp96',
            'en.classify.bert.battery.cased': 'bert_classifier_batterybert_cased_abstract',
            'en.classify.bert.battery.cased.by_batterydata': 'bert_classifier_batteryonlybert_cased_abstract',
            'en.classify.bert.battery.uncased': 'bert_classifier_batterybert_uncased_abstract',
            'en.classify.bert.battery.uncased.by_batterydata': 'bert_classifier_batteryonlybert_uncased_abstract',
            'en.classify.bert.bio_pubmed.by_pritamdeka': 'bert_classifier_bio_pubmed200krct',
            'en.classify.bert.by_404e': 'bert_classifier_autotrain_formality_1026434913',
            'en.classify.bert.by_adamlin': 'bert_classifier_text_cls',
            'en.classify.bert.by_adrianmoses': 'bert_classifier_autonlp_auto_nlp_lyrics_classification_19333717',
            'en.classify.bert.by_aimendo': 'bert_classifier_autonlp_triage_35248482',
            'en.classify.bert.by_ajay191191': 'bert_classifier_autonlp_test_530014983',
            'en.classify.bert.by_akilesh96': 'bert_classifier_autonlp_mrcooper_text_classification_529614927',
            'en.classify.bert.by_alperiox': 'bert_classifier_autonlp_user_review_classification_536415182',
            'en.classify.bert.by_astarostap': 'bert_classifier_autonlp_antisemitism_2_21194454',
            'en.classify.bert.by_asvs': 'bert_classifier_qs',
            'en.classify.bert.by_aujer': 'bert_classifier_ni_model_8_19',
            'en.classify.bert.by_aychang': 'bert_sequence_classifier_trec_coarse',
            'en.classify.bert.by_benword': 'bert_classifier_autotrain_apm2_1212245840',
            'en.classify.bert.by_braveoni': 'bert_classifier_2ch_text_classification',
            'en.classify.bert.by_bush': 'bert_classifier_autonlp_bp_29016523',
            'en.classify.bert.by_crcb': 'bert_classifier_dvs_f',
            'en.classify.bert.by_danl': 'bert_classifier_scientific_challenges_and_directions',
            'en.classify.bert.by_deepesh0x': 'bert_classifier_autotrain_wikipedia_sst_2_1034235509',
            'en.classify.bert.by_ecoli': 'bert_classifier_sb',
            'en.classify.bert.by_edmundhui': 'bert_classifier_mental_health_trainer',
            'en.classify.bert.by_erica': 'bert_classifier_krm_sa3',
            'en.classify.bert.by_ericpeter': 'bert_classifier_comments_text_classification_model',
            'en.classify.bert.by_esiebomajeremiah': 'bert_classifier_autonlp_email_classification_657119381',
            'en.classify.bert.by_fan_s': 'bert_classifier_reddit_tc',
            'en.classify.bert.by_financeinc': 'bert_classifier_finbert_fls',
            'en.classify.bert.by_foundkim': 'bert_classifier_topic',
            'en.classify.bert.by_hcklab': 'bert_classifier_bi_classification',
            'en.classify.bert.by_huaen': 'bert_classifier_question_detection',
            'en.classify.bert.by_idrimadrid': 'bert_classifier_autonlp_creator_classifications_4021083',
            'en.classify.bert.by_imzachjohnson': 'bert_classifier_autonlp_spinner_check_16492731',
            'en.classify.bert.by_jerimee': 'bert_classifier_autotrain_dontknowwhatimdoing_980432459',
            'en.classify.bert.by_jonaskoenig': 'bert_classifier_topic_classification_04',
            'en.classify.bert.by_joniponi': 'bert_classifier_multilabel_inpatient_comments_14labels',
            'en.classify.bert.by_jpreilly123': 'bert_classifier_emojify_mvp',
            'en.classify.bert.by_juancavallotti': 'bert_classifier_sentence',
            'en.classify.bert.by_juliensimon': 'bert_classifier_autonlp_song_lyrics_18753417',
            'en.classify.bert.by_justpyschitry': 'bert_classifier_medical_article_by_icd_11_chapter',
            'en.classify.bert.by_kamivao': 'bert_classifier_autonlp_entity_selection_5771228',
            'en.classify.bert.by_khu1998': 'bert_classifier_clog_assessment_model',
            'en.classify.bert.by_leonweber': 'bert_classifier_semantic_relations',
            'en.classify.bert.by_lewtun': 'bert_classifier_test_hub_pr_1',
            'en.classify.bert.by_lucifermorninstar011': 'bert_classifier_autotrain_lucifer_multi_auto_831626529',
            'en.classify.bert.by_lysandre': 'bert_classifier_dum',
            'en.classify.bert.by_m3tafl0ps': 'bert_classifier_autonlp_nlpisfun_251844',
            'en.classify.bert.by_madhurjindalworkmail': 'bert_classifier_autonlp_gibb_detect_515314387',
            'en.classify.bert.by_marieke93': 'bert_classifier_evidence_types',
            'en.classify.bert.by_mim': 'bert_classifier_pro_cell_expert',
            'en.classify.bert.by_mlkorra': 'bert_classifier_ogbv_gder_hi_mlkorra',
            'en.classify.bert.by_mohsenfayyaz': 'bert_classifier_toxicity',
            'en.classify.bert.by_nbroad': 'bert_classifier_esg',
            'en.classify.bert.by_ndavid': 'bert_classifier_autotrain_trec_fine_739422530',
            'en.classify.bert.by_nicktien': 'bert_classifier_taipeiqa_v1',
            'en.classify.bert.by_nikunjbjj': 'bert_classifier_jd_resume_model',
            'en.classify.bert.by_nitishkumargundapu793': 'bert_classifier_autotrain_chat_bot_responses_949231426',
            'en.classify.bert.by_palakagl': 'bert_classifier_bert_textclassification',
            'en.classify.bert.by_panashe': 'bert_classifier_autonlp_eo_590516680',
            'en.classify.bert.by_patrickquick': 'bert_classifier_berticelli',
            'en.classify.bert.by_priyamm': 'bert_classifier_autotrain_keywordextraction_882328335',
            'en.classify.bert.by_prompsit': 'bert_classifier_paraphrase',
            'en.classify.bert.by_prosusai': 'bert_classifier_finbert',
            'en.classify.bert.by_ptro': 'bert_classifier_model1_test',
            'en.classify.bert.by_pwz98': 'bert_classifier_test_model',
            'en.classify.bert.by_sampathkethineedi': 'bert_classifier_industry_classification_api',
            'en.classify.bert.by_santarabantoosoo': 'bert_classifier_pathology_meningioma',
            'en.classify.bert.by_sasha': 'bert_classifier_regardv3',
            'en.classify.bert.by_sbrandeis': 'bert_classifier_autonlp_emotion_clf',
            'en.classify.bert.by_serenay': 'bert_classifier_autonlp_emotion_14722565',
            'en.classify.bert.by_sgugger': 'bert_classifier_test_dynamic_pipeline',
            'en.classify.bert.by_shuvam': 'bert_classifier_autonlp_college_classification_164469',
            'en.classify.bert.by_slowturtle': 'bert_classifier_topic_v5',
            'en.classify.bert.by_snap': 'bert_classifier_autotrain_argument_feedback_1154042511',
            'en.classify.bert.by_someshfengde': 'bert_classifier_autonlp_kaggledays_625717986',
            'en.classify.bert.by_tcaputi': 'bert_classifier_guns_relevant',
            'en.classify.bert.by_tristantristantristan': 'bert_classifier_rumor',
            'en.classify.bert.by_unitary': 'bert_classifier_toxic',
            'en.classify.bert.by_vijaygoriya': 'bert_classifier_vijaygoriya_test_trainer',
            'en.classify.bert.by_vinaydngowda': 'bert_classifier_robertabase_ana4',
            'en.classify.bert.by_vreese2414': 'bert_classifier_autotrain_test_frank_896929583',
            'en.classify.bert.by_world_wide': 'bert_classifier_sent_sci_irrelevance',
            'en.classify.bert.by_yonichi': 'bert_classifier_cbert',
            'en.classify.bert.by_zwang199': 'bert_classifier_autonlp_traffic_nlp_451311592',
            'en.classify.bert.cased_base': 'bert_classifier_bert_base_cased_abstract',
            'en.classify.bert.cased_base.by_aychang': 'bert_classifier_bert_base_cased_trec_coarse',
            'en.classify.bert.cased_base.by_dipesh': 'bert_classifier_intent_classification_base_cased',
            'en.classify.bert.cased_base.by_seongju': 'bert_classifier_kor_3i4k_base_cased',
            'en.classify.bert.cased_base_finetuned': 'bert_classifier_base_cased_finetuned_sst2',
            'en.classify.bert.cased_base_medium': 'bert_classifier_base_cased_cv_studio_name_medium',
            'en.classify.bert.cased_large': 'bert_classifier_mnli_large_cased',
            'en.classify.bert.cased_large.by_boychaboy': 'bert_classifier_snli_large_cased',
            'en.classify.bert.catalonia_independence.': 'bert_classifier_autonlp_text_classification_catalonia_independence_autonlp_633018323',
            'en.classify.bert.chemical.': 'bert_classifier_autotrain_chemprot_re_838426740',
            'en.classify.bert.cl.by_yuan1729': 'bert_classifier_cl_1',
            'en.classify.bert.clinical.': 'bert_classifier_core_clinical_mortality_prediction',
            'en.classify.bert.clinical.by_bvanaken': 'bert_classifier_clinical_assertion_negation',
            'en.classify.bert.cola1.': 'bert_classifier_autonlp_cola_gram_208681',
            'en.classify.bert.cola1.by_abirate': 'bert_classifier_fine_tuned_cola',
            'en.classify.bert.cola1.by_vanhoan': 'bert_classifier_fine_tuned_cola1',
            'en.classify.bert.cola2.by_vanhoan': 'bert_classifier_fine_tuned_cola2',
            'en.classify.bert.cord19.': 'bert_classifier_coronabert',
            'en.classify.bert.covid.': 'bert_classifier_covid_misinfo',
            'en.classify.bert.distilled_512d_tiny_512d': 'bert_classifier_tiny_sst2_distilled_l4_h_512',
            'en.classify.bert.distilled_mini': 'bert_classifier_mini_sst2_distilled',
            'en.classify.bert.distilled_tiny': 'bert_classifier_tiny_aug_sst2_distilled',
            'en.classify.bert.distilled_tiny.by_lupinlevorace': 'bert_classifier_lupinlevorace_tiny_sst2_distilled',
            'en.classify.bert.distilled_tiny.by_sayan01': 'bert_classifier_tiny_qqp_distilled',
            'en.classify.bert.distilled_tiny.by_smith123': 'bert_classifier_tiny_sst2_distilled_l6_h128',
            'en.classify.bert.email_spam.': 'bert_classifier_trash_mail_cls_2022',
            'en.classify.bert.emotion.distilled_uncased_base_finetuned': 'bert_classifier_distil_base_uncased_finetuned_emotion',
            'en.classify.bert.emotion.finetuned': 'bert_classifier_finetuned_emotion',
            'en.classify.bert.emotion.mini_lm_mini_finetuned': 'bert_classifier_minilm_finetuned_emotion_nm',
            'en.classify.bert.emotion.mini_lm_mini_finetuned.by_lewtun': 'bert_classifier_minilm_finetuned_emotion',
            'en.classify.bert.emotion.uncased_base': 'bert_classifier_bhadresh_savani_base_uncased_emotion',
            'en.classify.bert.emotion.uncased_base.by_nateraw': 'bert_classifier_nateraw_base_uncased_emotion',
            'en.classify.bert.emotion.xtremedistiled': 'bert_classifier_xtremedistil_emotion',
            'en.classify.bert.emotion.xtremedistiled.by_bergum': 'bert_classifier_xtremedistil_l6_h384_emotion',
            'en.classify.bert.fever.mini_lm_mini': 'bert_classifier_minilm_l6_mnli_fever_docnli_ling_2c',
            'en.classify.bert.finetuned': 'bert_classifier_amitkayal_finetuned_sem_eval_english',
            'en.classify.bert.finetuned.by_abderrahim2': 'bert_classifier_finetuned_location',
            'en.classify.bert.finetuned.by_has_abi': 'bert_classifier_finetuned_resumes_sections',
            'en.classify.bert.finetuned.by_hazrulakmal': 'bert_classifier_benchmark_finetuned',
            'en.classify.bert.finetuned.by_jboomc': 'bert_classifier_rotten_tomatoes_finetuned',
            'en.classify.bert.finetuned.by_joniponi': 'bert_classifier_joniponi_finetuned_sem_eval_english',
            'en.classify.bert.finetuned.by_nickmuchi': 'bert_classifier_sec_finetuned_finance_classification',
            'en.classify.bert.glue.': 'bert_classifier_autotrain_gluemodels_1010733562',
            'en.classify.bert.glue.6l_256d_a8a_256d': 'bert_classifier_sead_l_6_h_256_a_8_mrpc',
            'en.classify.bert.glue.6l_384d_a12a': 'bert_classifier_sead_l_6_h_384_a_12_mrpc',
            'en.classify.bert.glue.base': 'bert_classifier_platzi_base_mrpc_glue_omar_espejel',
            'en.classify.bert.glue.by_jxuhf': 'bert_classifier_fine_tuning_text_classification_model_habana_gaudi',
            'en.classify.bert.glue.by_navsad': 'bert_classifier_navid_test',
            'en.classify.bert.glue.by_sgugger': 'bert_classifier_glue_mrpc',
            'en.classify.bert.glue.cased_base_finetuned': 'bert_classifier_bert_base_cased_finetuned_mnli',
            'en.classify.bert.glue.cased_large_finetuned': 'bert_classifier_bert_large_cased_finetuned_mrpc',
            'en.classify.bert.glue.cased_large_finetuned.by_gchhablani': 'bert_classifier_bert_large_cased_finetuned_rte',
            'en.classify.bert.glue.cased_large_whole_word_masking': 'bert_classifier_large_cased_whole_word_masking_sst2',
            'en.classify.bert.glue.distilled_tiny': 'bert_classifier_ibrahim2030_tiny_sst2_distilled',
            'en.classify.bert.glue.distilled_tiny.by_ilana': 'bert_classifier_ilana_tiny_sst2_distilled',
            'en.classify.bert.glue.distilled_tiny.by_nbhimte': 'bert_classifier_tiny_mnli_distilled',
            'en.classify.bert.glue.distilled_tiny.by_philschmid': 'bert_classifier_philschmid_tiny_sst2_distilled',
            'en.classify.bert.glue.distilled_tiny_mobile.by_gokuls': 'bert_classifier_tiny_sst2_mobile_distillation',
            'en.classify.bert.glue.finetuned': 'bert_classifier_bert_finetuned_mrpc',
            'en.classify.bert.glue.finetuned.by_Riad': 'bert_classifier_riad_finetuned_mrpc',
            'en.classify.bert.glue.finetuned.by_deepesh0x': 'bert_classifier_autotrain_gluefinetunedmodel_1013533786',
            'en.classify.bert.glue.finetuned.by_sgugger': 'bert_classifier_sgugger_finetuned_mrpc',
            'en.classify.bert.glue.finetuned.by_shahma': 'bert_classifier_shahma_finetuned_mrpc',
            'en.classify.bert.glue.finetuned.by_wiselinjayajos': 'bert_classifier_wiselinjayajos_finetuned_mrpc',
            'en.classify.bert.glue.finetuning_': 'bert_classifier_bert_finetuning_cn',
            'en.classify.bert.glue.mobile_multi_teacher_distilled_tiny.by_gokuls': 'bert_classifier_tiny_sst2_1_mobile_and_multi_teacher_distillation',
            'en.classify.bert.glue.mobile_only_distilled_tiny.by_gokuls': 'bert_classifier_tiny_sst2_1_mobile_only_distillation',
            'en.classify.bert.glue.only_distilled_tiny.by_gokuls': 'bert_classifier_tiny_sst2_1_mobile_2_only_distillation',
            'en.classify.bert.glue.small_finetuned': 'bert_classifier_small_finetuned_glue_rte',
            'en.classify.bert.glue.ssts2.distilled_tiny.by_gokuls': 'bert_classifier_tiny_sst2_distilled_model',
            'en.classify.bert.glue.ssts2.mobile.distilled_tiny.by_gokuls': 'bert_classifier_tiny_sst2_1_mobile_2_distillation',
            'en.classify.bert.glue.tiny_finetuned': 'bert_classifier_tiny_finetuned_glue_rte',
            'en.classify.bert.glue.uncased_base': 'bert_classifier_intel_base_uncased_mrpc',
            'en.classify.bert.glue.uncased_base.by_JeremiahZ': 'bert_classifier_jeremiahz_base_uncased_mrpc',
            'en.classify.bert.glue.uncased_mini_lm_mini': 'bert_classifier_minilm_l12_h384_uncased_mrpc',
            'en.classify.bert.glue.v1.by_junzai': 'bert_classifier_demo',
            'en.classify.bert.glue.v2.by_junzai': 'bert_classifier_demotest',
            'en.classify.bert.glue_cola1.': 'bert_classifier_sgugger_fine_tuned_cola',
            'en.classify.bert.glue_cola1.by_vanhoan': 'bert_classifier_vanhoan_fine_tuned_cola',
            'en.classify.bert.glue_cola1.cased_base_finetuned': 'bert_classifier_bert_base_cased_finetuned_cola',
            'en.classify.bert.glue_cola1.cased_large_finetuned': 'bert_classifier_bert_large_cased_finetuned_cola',
            'en.classify.bert.glue_cola1.uncased_base_finetuned': 'bert_classifier_base_uncased_finetuned_glue_cola',
            'en.classify.bert.glue_gold_labels.distilled_tiny.by_gokuls': 'bert_classifier_tiny_sst2_1_mobile_2_3_gold_labels_distillation',
            'en.classify.bert.glue_mrpc.cased_base_finetuned.by_gchhablani': 'bert_classifier_bert_base_cased_finetuned_mrpc',
            'en.classify.bert.glue_qnli.6l_256d_a8a_256d.by_course5i': 'bert_classifier_sead_l_6_h_256_a_8_qnli',
            'en.classify.bert.glue_qnli.6l_384d_a12a.by_course5i': 'bert_classifier_sead_l_6_h_384_a_12_qnli',
            'en.classify.bert.glue_qnli.cased_base_finetuned.by_gchhablani': 'bert_classifier_bert_base_cased_finetuned_qnli',
            'en.classify.bert.glue_qqp.6l_256d_a8a_256d.by_course5i': 'bert_classifier_sead_l_6_h_256_a_8_qqp',
            'en.classify.bert.glue_qqp.6l_384d_a12a.by_course5i': 'bert_classifier_sead_l_6_h_384_a_12_qqp',
            'en.classify.bert.glue_qqp.cased_base_finetuned.by_gchhablani': 'bert_classifier_bert_base_cased_finetuned_qqp',
            'en.classify.bert.glue_rte.6l_256d_a8a_256d.by_course5i': 'bert_classifier_sead_l_6_h_256_a_8_rte',
            'en.classify.bert.glue_rte.6l_384d_a12a.by_course5i': 'bert_classifier_sead_l_6_h_384_a_12_rte',
            'en.classify.bert.glue_rte.cased_base_finetuned.by_gchhablani': 'bert_classifier_bert_base_cased_finetuned_rte',
            'en.classify.bert.glue_sst2.6l_256d_a8a_256d.by_course5i': 'bert_classifier_sead_l_6_h_256_a_8_sst2',
            'en.classify.bert.glue_sst2.6l_384d_a12a.by_course5i': 'bert_classifier_sead_l_6_h_384_a_12_sst2',
            'en.classify.bert.glue_sst2.cased_base_finetuned.by_gchhablani': 'bert_classifier_bert_base_cased_finetuned_sst2',
            'en.classify.bert.go_emotions.xtremedistiled': 'bert_classifier_xtremedistil_l6_h384_go_emotion',
            'en.classify.bert.go_emotions.xtremedistiled_uncased': 'bert_classifier_xtremedistil_l6_h256_uncased_go_emotion',
            'en.classify.bert.hate.': 'bert_sequence_classifier_hatexplain',
            'en.classify.bert.hate.by_crcb': 'bert_classifier_hateval_re',
            'en.classify.bert.hate.by_risingodegua': 'bert_classifier_hate_speech_detector',
            'en.classify.bert.hate.large': 'bert_classifier_bert_large_hatexplain',
            'en.classify.bert.hate.mono_english.by_hate_speech_cnerg': 'bert_classifier_dehatebert_mono_english',
            'en.classify.bert.hate.mono_indonesian.by_hate_speech_cnerg': 'bert_classifier_dehate_mono_indonesian',
            'en.classify.bert.hate.uncased_base': 'bert_classifier_bert_base_uncased_hatexplain',
            'en.classify.bert.hate.uncased_base.by_hate_speech_cnerg': 'bert_classifier_bert_base_uncased_hatexplain_rationale_two',
            'en.classify.bert.imdb.': 'bert_classifier_autonlp_imdb_classification_596216804',
            'en.classify.bert.imdb.1h': 'bert_classifier_bert_imdb_1hidden',
            'en.classify.bert.imdb.by_mmcquade11': 'bert_classifier_autonlp_imdb_test_21134442',
            'en.classify.bert.imdb.uncased_base': 'bert_classifier_fabriceyhc_base_uncased_imdb',
            'en.classify.bert.imdb.uncased_base.by_nateraw': 'bert_classifier_nateraw_base_uncased_imdb',
            'en.classify.bert.imdb.v1.by_abhishek': 'bert_classifier_autonlp_imdb_eval_71421',
            'en.classify.bert.imdb.v2.by_abhishek': 'bert_classifier_autotrain_imdbtestmodel_9215210',
            'en.classify.bert.imdb_sentiment.': 'bert_classifier_autonlp_imdb_sentiment_analysis_623817873',
            'en.classify.bert.imdb_sentiment.by_yosemite': 'bert_classifier_autonlp_imdb_sentiment_analysis_english_470512388',
            'en.classify.bert.joy.': 'bert_classifier_emo_nojoylove',
            'en.classify.bert.klue.cased_multilingual_base': 'bert_classifier_klue_tc_base_multilingual_cased',
            'en.classify.bert.lang': 'bert_classifier_manglish_offensive_language_identification',
            'en.classify.bert.large': 'bert_classifier_bert_large_mnli',
            'en.classify.bert.large.by_tehrannlp_org': 'bert_classifier_bert_large_sst2',
            'en.classify.bert.large.random.by_baykenney': 'bert_classifier_large_gpt2detector_random',
            'en.classify.bert.large.topk40.by_baykenney': 'bert_classifier_large_gpt2detector_topk40',
            'en.classify.bert.mini_lm_mini': 'bert_classifier_minilm_l6_mnli',
            'en.classify.bert.mini_lm_mini.by_moritzlaurer': 'bert_classifier_minilm_l6_mnli_binary',
            'en.classify.bert.movie_hate.uncased_base': 'bert_classifier_bert_based_uncased_hatespeech_movies',
            'en.classify.bert.multi2convai.': 'bert_classifier_multi2convai_corona',
            'en.classify.bert.multi2convai.logistics.by_inovex': 'bert_classifier_multi2convai_logistics',
            'en.classify.bert.multi2convai.quality.by_inovex': 'bert_classifier_multi2convai_quality',
            'en.classify.bert.news.': 'bert_sequence_classifier_age_news',
            'en.classify.bert.news.by_abhishek': 'bert_classifier_autonlp_bbc_news_classification_37229289',
            'en.classify.bert.news.cased_base': 'bert_classifier_base_cased_clickbait_news',
            'en.classify.bert.news.cased_base.by_elozano': 'bert_classifier_base_cased_news_category',
            'en.classify.bert.news.mini_finetuned': 'bert_sequence_classifier_mini_finetuned_age_news_classification',
            'en.classify.bert.news.tiny_finetuned': 'bert_sequence_classifier_tiny_finetuned_fake_news_detection',
            'en.classify.bert.news.uncased_base': 'bert_classifier_bert_base_uncased_ag_news',
            'en.classify.bert.non_cl.by_yuan1729': 'bert_classifier_non_cl',
            'en.classify.bert.pubmed.': 'bert_classifier_multi_label_classification_of_pubmed_articles',
            'en.classify.bert.pubmed.by_pritamdeka': 'bert_classifier_pubmed_pubmed200krct',
            'en.classify.bert.pubmed_bluebert.uncased_12l_768d_a12a_768d': 'bert_classifier_bluebert_pubmed_uncased_l_12_h_768_a_12_pub_section',
            'en.classify.bert.sa_sub1.by_researchaccount': 'bert_classifier_sa_sub1',
            'en.classify.bert.sa_sub2.by_researchaccount': 'bert_classifier_sa_sub2',
            'en.classify.bert.sa_sub3.by_researchaccount': 'bert_classifier_sa_sub3',
            'en.classify.bert.sa_sub4.by_researchaccount': 'bert_classifier_sa_sub4',
            'en.classify.bert.sentiment.': 'bert_classifier_autonlp_sentiment_detection_1781580',
            'en.classify.bert.sentiment.base': 'bert_classifier_base_finance_sentiment_noisy_search',
            'en.classify.bert.sentiment.by_ahmedrachid': 'bert_classifier_financialbert_sentiment_analysis',
            'en.classify.bert.sentiment.by_charly': 'bert_classifier_autotrain_sentiment_4_812425472',
            'en.classify.bert.sentiment.by_gilf': 'bert_classifier_english_yelp_sentiment',
            'en.classify.bert.sentiment.by_ktangri': 'bert_classifier_autotrain_financial_sentiment_765323474',
            'en.classify.bert.sentiment.by_shahidul034': 'bert_classifier_drug_sentiment_analysis',
            'en.classify.bert.sentiment.by_souvikcmsa': 'bert_classifier_bert_sentiment_analysis',
            'en.classify.bert.sentiment.by_tomato': 'bert_classifier_sentiment_analysis',
            'en.classify.bert.sentiment.cased_base': 'bert_classifier_base_cased_tamil_mix_sentiment',
            'en.classify.bert.sentiment.finetuned': 'bert_classifier_auditor_sentiment_finetuned',
            'en.classify.bert.sentiment_twitter.': 'bert_classifier_twitter_sentiment',
            'en.classify.bert.sms_spam.': 'bert_sequence_classifier_sms_spam',
            'en.classify.bert.sms_spam.tiny_finetuned': 'bert_sequence_classifier_tiny_finetuned_sms_spam_detection',
            'en.classify.bert.tiny': 'bert_classifier_tiny_best',
            'en.classify.bert.tiny.by_chatwithnerd': 'bert_classifier_tiny_master',
            'en.classify.bert.tiny_finetuned': 'bert_sequence_classifier_tiny_finetuned_yahoo_answers_topics',
            'en.classify.bert.tweet.': 'bert_classifier_bert_tweet_eval_emotion',
            'en.classify.bert.tweet.base_128d': 'bert_classifier_autotrain_base_tweeteval_1281248996',
            'en.classify.bert.tweet.base_128d_v1.by_sasha': 'bert_classifier_autotrain_base_tweeteval_1281248997',
            'en.classify.bert.tweet.base_128d_v2.by_sasha': 'bert_classifier_autotrain_base_tweeteval_1281248998',
            'en.classify.bert.tweet.base_128d_v3.by_sasha': 'bert_classifier_autotrain_base_tweeteval_1281248999',
            'en.classify.bert.tweet.base_128d_v4.by_sasha': 'bert_classifier_autotrain_base_tweeteval_1281249000',
            'en.classify.bert.tweet.by_dtai_kuleuven': 'bert_classifier_m_corona_tweets_belgium_topics',
            'en.classify.bert.tweet_sentiment.': 'bert_classifier_english_tweetsentiment',
            'en.classify.bert.uncased': 'bert_classifier_sci_uncased_topics',
            'en.classify.bert.uncased_base': 'bert_classifier_bert_base_uncased_abstract',
            'en.classify.bert.uncased_base.by_boychaboy': 'bert_classifier_snli_base_uncased',
            'en.classify.bert.uncased_base.by_ehsanaghazadeh': 'bert_classifier_based_uncased_sst2_e1',
            'en.classify.bert.uncased_base.by_li': 'bert_classifier_base_uncased_qnli',
            'en.classify.bert.uncased_base.by_splend1dchan': 'bert_classifier_base_uncased_slue_goldtrascription_e3_lr1e_4',
            'en.classify.bert.uncased_base.by_tennessejoyce': 'bert_classifier_titlewave_base_uncased',
            'en.classify.bert.uncased_base.by_tobias': 'bert_classifier_base_uncased_english_multilable_classification',
            'en.classify.bert.uncased_base.by_tomhosking': 'bert_classifier_base_uncased_debiased_nli',
            'en.classify.bert.uncased_base_finetuned': 'bert_classifier_bert_base_uncased_finetuned_surveyclassification',
            'en.classify.bert.uncased_base_finetuned.by_hazrulakmal': 'bert_classifier_base_uncased_finetuned',
            'en.classify.bert.uncased_base_finetuned.by_transformersbook': 'bert_classifier_base_uncased_finetuned_clinc',
            'en.classify.bert.uncased_base_finetuned.by_yuetian': 'bert_classifier_base_uncased_finetuned_plutchik_emotion',
            'en.classify.bert.uncased_mini_lm_mini': 'bert_classifier_minilm_l12_h384_uncased_sst2_all_train',
            'en.classify.bert.v1.by_bshlgrs': 'bert_classifier_autonlp_classification_9522090',
            'en.classify.bert.v1.by_clem': 'bert_classifier_autonlp_test3_2101779',
            'en.classify.bert.v1by_shogumbo': 'bert_classifier_testing3_multilavel',
            'en.classify.bert.v2': 'bert_classifier_sponsorblock_v2',
            'en.classify.bert.v2.by_bshlgrs': 'bert_classifier_autonlp_classification_with_all_labellers_9532137',
            'en.classify.bert.v2.by_clem': 'bert_classifier_autonlp_test3_2101782',
            'en.classify.bert.v2_2m': 'bert_classifier_autotrain_apmv2multiclass_1216046004',
            'en.classify.bert.v2by_shogumbo': 'bert_classifier_testing4_multilabel',
            'en.classify.bert.v3.by_bshlgrs': 'bert_classifier_autonlp_old_data_trained_10022181',
            'en.classify.bert.wnli_glue.6l_256d_a8a_256d': 'bert_classifier_sead_l_6_h_256_a_8_wnli',
            'en.classify.bert.wnli_glue.6l_384d_a12a': 'bert_classifier_sead_l_6_h_384_a_12_wnli',
            'en.classify.bert.wnli_glue.cased_base_finetuned': 'bert_classifier_bert_base_cased_finetuned_wnli',
            'en.classify.bert.wnli_glue.cased_large_finetuned': 'bert_classifier_bert_large_cased_finetuned_wnli',
            'en.classify.bert.xtreme.': 'bert_classifier_extreme_go_emotion',
            'en.classify.bert.xtremedistiled_uncased': 'bert_classifier_xtremedistil_l12_h384_uncased_pub_section',
            'en.classify.bert_sequence.ag_news': 'bert_base_sequence_classifier_ag_news',
            'en.classify.bert_sequence.dbpedia_14': 'bert_base_sequence_classifier_dbpedia_14',
            'en.classify.bert_sequence.dehatebert_mono': 'bert_sequence_classifier_dehatebert_mono',
            'en.classify.bert_sequence.finbert': 'bert_sequence_classifier_finbert',
            'en.classify.bert_sequence.imdb': 'bert_base_sequence_classifier_imdb',
            'en.classify.bert_sequence.imdb_large': 'bert_large_sequence_classifier_imdb',
            'en.classify.beto_bert': 'bert_classifier_beto_4d',
            'en.classify.beto_bert.sentiment.': 'bert_classifier_beto_headlines_sentiment_analysis',
            'en.classify.biobert': 'bert_classifier_biobert_v1.1_pub_section',
            'en.classify.bioformer.cased': 'bert_classifier_bioformer_cased_v1.0_mnli',
            'en.classify.bioformer.cased.by_bioformers': 'bert_classifier_bioformer_cased_v1.0_qnli',
            'en.classify.carer.roberta.by_crcb': 'roberta_classifier_carer_new',
            'en.classify.carer.roberta.v2.by_crcb': 'roberta_classifier_carer_2',
            'en.classify.claim.bert.by_thinkcerca': 'bert_classifier_claim_hugging',
            'en.classify.counterargument.bert.by_thinkcerca': 'bert_classifier_counterargument_hugging',
            'en.classify.ctrl44.roberta.by_liamcripwell': 'roberta_classifier_ctrl44',
            'en.classify.ctrl44_clf.roberta.by_liamcripwell': 'roberta_classifier_ctrl44_clf',
            'en.classify.curiosity_bio.bert.by_k_partha': 'bert_classifier_curiosity_bio',
            'en.classify.cyberbullying': 'classifierdl_use_cyberbullying',
            'en.classify.cyberbullying.use': 'classifierdl_use_cyberbullying',
            'en.classify.cyberlandr_ai.bert.v1.by_billfrench': 'bert_classifier_autonlp_cyberlandr_ai_4_614417500',
            'en.classify.cyberlandr_ai.bert.v2.by_billfrench': 'bert_classifier_autonlp_cyberlandr_ai_4_614417501',
            'en.classify.dbpedia': 'deberta_v3_small_sequence_classifier_dbpedia_14',
            'en.classify.decision_style_bio.bert.by_k_partha': 'bert_classifier_decision_style_bio',
            'en.classify.distil_bert': 'distilbert_sequence_classifier_wiki_complexity',
            'en.classify.distil_bert.base.by_datasets': 'distilbert_base_sequence_classifier_airlines',
            'en.classify.distil_bert.by_abhishek': 'distilbert_sequence_classifier_autonlp_toxic_new_30516963',
            'en.classify.distil_bert.by_bitmorse': 'distilbert_sequence_classifier_autonlp_ks_530615016',
            'en.classify.distil_bert.by_chijioke': 'distilbert_sequence_classifier_autonlp_mono_625317956',
            'en.classify.distil_bert.by_clem': 'distilbert_sequence_classifier_autonlp_test3_2101787',
            'en.classify.distil_bert.by_d4data': 'distilbert_sequence_classifier_bias_detection_model',
            'en.classify.distil_bert.by_danitg95': 'distilbert_sequence_classifier_autotrain_kaggle_effective_arguments_1086739296',
            'en.classify.distil_bert.by_furiouslyasleep': 'distilbert_sequence_classifier_markingmulticlass',
            'en.classify.distil_bert.by_juliensimon': 'distilbert_sequence_classifier_autonlp_song_lyrics_18753423',
            'en.classify.distil_bert.by_lingwave_admin': 'distilbert_sequence_classifier_state_op_detector',
            'en.classify.distil_bert.by_madhurjindal': 'distilbert_sequence_classifier_autonlp_gibberish_detector_492513457',
            'en.classify.distil_bert.by_martin_ha': 'distilbert_sequence_classifier_toxic_comment_model',
            'en.classify.distil_bert.by_mhaegeman': 'distilbert_sequence_classifier_autotrain_country_recognition_1059336697',
            'en.classify.distil_bert.by_moritzlaurer': 'distilbert_sequence_classifier_policy_distilbert_7d',
            'en.classify.distil_bert.by_palakagl': 'distilbert_sequence_classifier_distilbert_multiclass_textclassification',
            'en.classify.distil_bert.by_preetiha': 'distilbert_sequence_classifier_clause_classification',
            'en.classify.distil_bert.by_sampathkethineedi': 'distilbert_sequence_classifier_industry_classification',
            'en.classify.distil_bert.by_sathira': 'distilbert_sequence_classifier_autotrain_mbtinlp_798824628',
            'en.classify.distil_bert.by_someshfengde': 'distilbert_sequence_classifier_autonlp_kaggledays_625717992',
            'en.classify.distil_bert.by_valurank': 'distilbert_sequence_classifier_distilbert_quality',
            'en.classify.distil_bert.by_world_wide': 'distilbert_sequence_classifier_is_legit_kwd_march_27',
            'en.classify.distil_bert.by_xinsignia': 'distilbert_sequence_classifier_autotrain_online_orders_755323156',
            'en.classify.distil_bert.cased_base': 'distilbert_sequence_classifier_arxiv_topics_distilbert_base_cased',
            'en.classify.distil_bert.cased_base.by_aychang': 'distilbert_sequence_classifier_distilbert_base_cased_trec_coarse',
            'en.classify.distil_bert.emotion.uncased_base': 'distilbert_sequence_classifier_bert_base_uncased_emotion',
            'en.classify.distil_bert.emotion.uncased_base.by_bhadresh_savani': 'distilbert_sequence_classifier_bhadresh_savani_distilbert_base_uncased_emotion',
            'en.classify.distil_bert.emotion.uncased_base.by_nanopass': 'distilbert_sequence_classifier_distilbert_base_uncased_emotion_2',
            'en.classify.distil_bert.emotion.uncased_base.by_philschmid': 'distilbert_sequence_classifier_philschmid_distilbert_base_uncased_emotion',
            'en.classify.distil_bert.environment.': 'distilbert_sequence_classifier_environmental_due_diligence_model',
            'en.classify.distil_bert.finetuned': 'distilbert_sequence_classifier_autotrain_finetunedmodelbert_1034335535',
            'en.classify.distil_bert.finetuned.by_svenstahlmann': 'distilbert_sequence_classifier_finetuned_distilbert_needmining',
            'en.classify.distil_bert.glue.': 'distilbert_sequence_classifier_testing',
            'en.classify.distil_bert.glue.uncased_base_finetuned': 'distilbert_sequence_classifier_distilbert_base_uncased_finetuned_sst_2_english',
            'en.classify.distil_bert.go_emotions.uncased_base': 'distilbert_sequence_classifier_distilbert_base_uncased_go_emotions_student',
            'en.classify.distil_bert.imdb.': 'distilbert_sequence_classifier_autotrain_imdb_1166543171',
            'en.classify.distil_bert.ma_mlc.by_couchcat': 'distilbert_sequence_classifier_ma_mlc_v7_distil',
            'en.classify.distil_bert.ma_sa.by_couchcat': 'distilbert_sequence_classifier_ma_sa_v7_distil',
            'en.classify.distil_bert.multi.by_lucifermorninstar011': 'distilbert_sequence_classifier_autotrain_lucifer_multi_844026969',
            'en.classify.distil_bert.multi_all.by_lucifermorninstar011': 'distilbert_sequence_classifier_autotrain_lucifer_multi_auto_all_837626708',
            'en.classify.distil_bert.news.uncased_base': 'distilbert_classifier_base_uncased_newspop_student',
            'en.classify.distil_bert.news.uncased_base.by_andi611': 'distilbert_sequence_classifier_distilbert_base_uncased_ner_agnews',
            'en.classify.distil_bert.news.uncased_base.by_joeddav': 'distilbert_sequence_classifier_distilbert_base_uncased_agnews_student',
            'en.classify.distil_bert.news.uncased_base_finetuned': 'distilbert_sequence_classifier_distilbert_base_uncased_finetuned_ag_news',
            'en.classify.distil_bert.sentiment.': 'distilbert_sequence_classifier_sentimentanalysisdistillbert',
            'en.classify.distil_bert.sentiment.by_ck42': 'distilbert_sequence_classifier_sentiment_analysis_sbcbi',
            'en.classify.distil_bert.sentiment.uncased_base': 'distilbert_sequence_classifier_distilbert_base_uncased_sentiment_sst2',
            'en.classify.distil_bert.tweet.': 'distilbert_sequence_classifier_distilbert_tweet_eval_emotion',
            'en.classify.distil_bert.tweet.by_bgoel4132': 'distilbert_sequence_classifier_tweet_disaster_classifier',
            'en.classify.distil_bert.tweet.by_m_newhauser': 'distilbert_sequence_classifier_distilbert_political_tweets',
            'en.classify.distil_bert.tweet.by_monsia': 'distilbert_sequence_classifier_autonlp_tweets_classification_23044997',
            'en.classify.distil_bert.tweet_emotion.uncased_base_finetuned': 'distilbert_sequence_classifier_distilbert_base_uncased_finetuned_emotion_en_tweets',
            'en.classify.distil_bert.tweet_sentiment.': 'distilbert_sequence_classifier_autonlp_tweet_sentiment_extraction_20114061',
            'en.classify.distil_bert.uncased_base': 'distilbert_sequence_classifier_distilbert_base_uncased_if',
            'en.classify.distil_bert.uncased_base.by_andi611': 'distilbert_sequence_classifier_distilbert_base_uncased_qa_boolq',
            'en.classify.distil_bert.uncased_base_finetuned': 'distilbert_sequence_classifier_ane_distilbert_base_uncased_finetuned_sst_2_english',
            'en.classify.distil_bert.uncased_base_finetuned.by_nsi319': 'distilbert_sequence_classifier_distilbert_base_uncased_finetuned_app',
            'en.classify.distil_bert.uncased_base_finetuned.by_speeqo': 'distilbert_sequence_classifier_speeqo_distilbert_base_uncased_finetuned_sst_2_english',
            'en.classify.distil_roberta.distilled': 'roberta_classifier_finetune_emotion_distilroberta',
            'en.classify.distil_roberta.distilled.by_aristotletan': 'roberta_classifier_scim_distilroberta',
            'en.classify.distil_roberta.distilled.by_jpcorb20': 'roberta_classifier_toxic_detector_distilroberta',
            'en.classify.distil_roberta.distilled_base_finetuned': 'roberta_sequence_classifier_distilroberta_base_finetuned_suicide_depression',
            'en.classify.distil_roberta.news.distilled_finetuned': 'roberta_sequence_classifier_distilroberta_finetuned_age_news_classification',
            'en.classify.distil_roberta.news_sentiment.distilled_finetuned': 'roberta_sequence_classifier_distilroberta_finetuned_financial_news_sentiment_analysis',
            'en.classify.distil_roberta.sentiment.distilled_finetuned': 'roberta_sequence_classifier_distilroberta_finetuned_rotten_tomatoes_sentiment_analysis',
            'en.classify.distil_roberta.tweet_hate.distilled_finetuned': 'roberta_sequence_classifier_distilroberta_finetuned_tweets_hate_speech',
            'en.classify.distilbert_sequence.ag_news': 'distilbert_base_sequence_classifier_ag_news',
            'en.classify.distilbert_sequence.amazon_polarity': 'distilbert_base_sequence_classifier_amazon_polarity',
            'en.classify.distilbert_sequence.banking77': 'distilbert_sequence_classifier_banking77',
            'en.classify.distilbert_sequence.emotion': 'distilbert_sequence_classifier_emotion',
            'en.classify.distilbert_sequence.imdb': 'distilbert_base_sequence_classifier_imdb',
            'en.classify.distilbert_sequence.industry': 'distilbert_sequence_classifier_industry',
            'en.classify.distilbert_sequence.policy': 'distilbert_sequence_classifier_policy',
            'en.classify.distilbert_sequence.sst2': 'distilbert_sequence_classifier_sst2',
            'en.classify.e2e': 'multiclassifierdl_use_e2e',
            'en.classify.electra': 'electra_classifier_mfma',
            'en.classify.electra.base': 'electra_classifier_base_discriminator_offenseval2019_downsample',
            'en.classify.electra.fever.large': 'electra_classifier_large_discriminator_snli_mnli_fever_anli_r1_r2_r3_nli',
            'en.classify.electra.hate.large': 'electra_classifier_large_discriminator_nli_efl_hateval',
            'en.classify.electra.imdb.small_finetuned': 'electra_classifier_small_finetuned_imdb',
            'en.classify.electra.tweet.large': 'electra_classifier_large_discriminator_nli_efl_tweeteval',
            'en.classify.emotion': 'classifierdl_use_emotion',
            'en.classify.emotion.bert': 'bert_sequence_classifier_emotion',
            'en.classify.emotion.bert.minilm_v1.by_dinithi': 'bert_classifier_minlm_finetuned_emotionnew1',
            'en.classify.emotion.bert.minilm_v2.by_dinithi': 'bert_classifier_minlm_finetuned_emotionnew2',
            'en.classify.emotion.use': 'classifierdl_use_emotion',
            'en.classify.esg.bert.by_yiyanghkust': 'bert_classifier_finbert_esg',
            'en.classify.extra_bio.bert.by_k_partha': 'bert_classifier_extra_bio',
            'en.classify.fakenews': 'classifierdl_use_fakenews',
            'en.classify.fakenews.use': 'classifierdl_use_fakenews',
            'en.classify.feedback_intent_test.roberta.by_mp6kv': 'roberta_classifier_feedback_intent_test',
            'en.classify.finance_sentiment': 'bert_sequence_classifier_finbert_tone',
            'en.classify.food.distil_bert.base': 'distilbert_base_sequence_classifier_food',
            'en.classify.fred2.roberta.by_abhishek': 'roberta_classifier_autonlp_fred2_2682064',
            'en.classify.hashtag_to_hashtag.bert.by_bryan0123': 'bert_classifier_hashtag_to_hashtag',
            'en.classify.hashtag_to_hashtag_20.bert.by_bryan0123': 'bert_classifier_hashtag_to_hashtag_20',
            'en.classify.imdb.longformer': 'longformer_base_sequence_classifier_imdb',
            'en.classify.imdb.xlnet': 'xlnet_base_sequence_classifier_imdb',
            'en.classify.intent.airline': 'classifierdl_use_atis',
            'en.classify.intent.atis': 'classifierdl_use_atis',
            'en.classify.iqa_classification.roberta.by_mp6kv': 'roberta_classifier_iqa_classification',
            'en.classify.isear_bert.roberta.by_crcb': 'roberta_classifier_isear_bert',
            'en.classify.main_intent_test.roberta.by_mp6kv': 'roberta_classifier_main_intent_test',
            'en.classify.manibert.by_niksmer': 'roberta_classifier_manibert',
            'en.classify.mbert.multi2convai.quality.by_inovex': 'bert_classifier_multi2convai_quality_en_mbert',
            'en.classify.mnli.bert.cased_base.by_boychaboy': 'bert_classifier_mnli_base_cased_3',
            'en.classify.mnli.roberta.base.by_boychaboy': 'roberta_classifier_mnli_base',
            'en.classify.multi.bert.by_palakagl': 'bert_classifier_bert_multiclass_textclassification',
            'en.classify.news.deberta': 'deberta_v3_xsmall_sequence_classifier_ag_news',
            'en.classify.news.deberta.small': 'deberta_v3_small_sequence_classifier_ag_news',
            'en.classify.not_interested..bert.by_aujer': 'bert_classifier_autotrain_not_interested_2_1213045881',
            'en.classify.offense..bert.uncased_base.by_mohsenfayyaz': 'bert_classifier_base_uncased_offenseval2019_unbalanced',
            'en.classify.offensive.roberta.beta.by_khailai': 'roberta_classifier_offensive_beta',
            'en.classify.offensive.roberta.by_khailai': 'roberta_classifier_offensive',
            'en.classify.paper_feedback_intent.roberta.by_mp6kv': 'roberta_classifier_paper_feedback_intent',
            'en.classify.policyberta.by_niksmer': 'roberta_classifier_policyberta_7d',
            'en.classify.prot_bfd_localization.bert.by_rostlab': 'bert_classifier_prot_bfd_localization',
            'en.classify.prot_bfd_membrane.bert.by_rostlab': 'bert_classifier_prot_bfd_membrane',
            'en.classify.pubmed_bert.pubmed.uncased_base': 'bert_classifier_biomednlp_pubmedbert_base_uncased_abstract_fulltext_pub_section',
            'en.classify.pump_intent_test.roberta.by_mp6kv': 'roberta_classifier_pump_intent_test',
            'en.classify.qn.roberta.by_lucianpopa': 'roberta_classifier_autotrain_qn_classification_1015534072',
            'en.classify.qqp.distil_bert.base': 'distilbert_base_sequence_classifier_qqp',
            'en.classify.question': 'classifierdl_use_trec50',
            'en.classify.question_vs_statement': 'bert_sequence_classifier_question_statement',
            'en.classify.questionpair': 'classifierdl_electra_questionpair',
            'en.classify.questions': 'classifierdl_use_trec50',
            'en.classify.questions.airline': 'classifierdl_use_atis',
            'en.classify.questions.atis': 'classifierdl_use_atis',
            'en.classify.reasoning.bert.by_thinkcerca': 'bert_classifier_reasoning_hugging',
            'en.classify.rile.roberta.by_niksmer': 'roberta_classifier_rile',
            'en.classify.roberta': 'roberta_classifier_autonlp_cml_412010597',
            'en.classify.roberta.128d': 'roberta_classifier_autotrain_neurips_chanllenge_1287149282',
            'en.classify.roberta.32d': 'roberta_classifier_autonlp_formality_scoring_2_32597818',
            'en.classify.roberta.adverse_drug_event': 'roberta_classifier_parrot_adequacy_model',
            'en.classify.roberta.ag_news': 'roberta_base_sequence_classifier_ag_news',
            'en.classify.roberta.all_mnli.large.by_veronica320': 'roberta_classifier_spte_large_all_mnli',
            'en.classify.roberta.amazon.': 'roberta_classifier_autotrain_amazon_shoe_reviews_classification_1104340243',
            'en.classify.roberta.banking.': 'roberta_classifier_banking77',
            'en.classify.roberta.banking.distilled_finetuned': 'roberta_classifier_distil_finetuned_banking77',
            'en.classify.roberta.base': 'roberta_classifier_base_formality_ranker',
            'en.classify.roberta.base.by_mohsenfayyaz': 'roberta_classifier_base_toxicity',
            'en.classify.roberta.base.by_onewithnickelcoins': 'roberta_classifier_base_stars',
            'en.classify.roberta.base.by_stremie': 'roberta_classifier_base_clickbait',
            'en.classify.roberta.base_4h': 'roberta_classifier_base_adr_smm4h2022',
            'en.classify.roberta.base_finetuned': 'roberta_sequence_classifier_codebert_base_finetuned_detect_insecure_cod',
            'en.classify.roberta.base_finetuned.by_aristotletan': 'roberta_classifier_aristotletan_base_finetuned_sst2',
            'en.classify.roberta.base_finetuned.by_peter2000': 'roberta_classifier_base_finetuned_osdg',
            'en.classify.roberta.by_aaroncu': 'roberta_classifier_attribute_classification',
            'en.classify.roberta.by_alecmullen': 'roberta_classifier_autonlp_group_classification_441411446',
            'en.classify.roberta.by_anamika': 'roberta_classifier_autonlp_fa_473312409',
            'en.classify.roberta.by_anthos23': 'roberta_classifier_my_awesome_model',
            'en.classify.roberta.by_avacaondata': 'roberta_classifier_bertin_exist22_task1',
            'en.classify.roberta.by_biu_nlp': 'roberta_classifier_superpal',
            'en.classify.roberta.by_blinjrm': 'roberta_classifier_finsent',
            'en.classify.roberta.by_cathy': 'roberta_classifier_reranking_model',
            'en.classify.roberta.by_chkla': 'roberta_classifier_argument',
            'en.classify.roberta.by_cjbarrie': 'roberta_classifier_autotrain_atc2',
            'en.classify.roberta.by_deepesh0x': 'roberta_classifier_autotrain_mlsec_1013333734',
            'en.classify.roberta.by_ds198799': 'roberta_classifier_autonlp_predict_roi_1_29797730',
            'en.classify.roberta.by_edwin923': 'roberta_classifier_fyp2022',
            'en.classify.roberta.by_emekaboris': 'roberta_classifier_autonlp_txc_17923124',
            'en.classify.roberta.by_furiouslyasleep': 'roberta_classifier_unhappyzebra100',
            'en.classify.roberta.by_idjotherwise': 'roberta_classifier_autonlp_reading_prediction_172506',
            'en.classify.roberta.by_johny201': 'roberta_classifier_autotrain_article_pred_1142742075',
            'en.classify.roberta.by_julien_c': 'roberta_classifier_reactiongif',
            'en.classify.roberta.by_kamuuung': 'roberta_classifier_autonlp_lessons_tagging_606217261',
            'en.classify.roberta.by_kco4776': 'roberta_classifier_soongsil_bert_wellness',
            'en.classify.roberta.by_lucifermorninstar011': 'roberta_classifier_autotrain_lucifer_multi_auto_all_837626712',
            'en.classify.roberta.by_luiz826': 'roberta_classifier_to_music_genre',
            'en.classify.roberta.by_lumalik': 'roberta_classifier_vent_emotion',
            'en.classify.roberta.by_masifayub': 'roberta_classifier_autotrain_pan_976832386',
            'en.classify.roberta.by_nihaldsouza1': 'roberta_classifier_yelp_rating_classification',
            'en.classify.roberta.by_nlpscholars': 'roberta_classifier_earning_call_transcript_classification',
            'en.classify.roberta.by_noob123': 'roberta_classifier_autotrain_app_review_train_1314150168',
            'en.classify.roberta.by_nthanhha26': 'roberta_classifier_autotrain_test_project_879428192',
            'en.classify.roberta.by_p_christ': 'roberta_classifier_qandaclassifier',
            'en.classify.roberta.by_palakagl': 'roberta_classifier_multiclass_textclassification',
            'en.classify.roberta.by_paulagarciaserrano': 'roberta_classifier_depression_detection',
            'en.classify.roberta.by_phucle': 'roberta_classifier_lro_v1.0.2a',
            'en.classify.roberta.by_rabiaqayyum': 'roberta_classifier_autotrain_mental_health_analysis_752423172',
            'en.classify.roberta.by_rti_international': 'roberta_classifier_rota',
            'en.classify.roberta.by_saattrupdan': 'roberta_classifier_verdict',
            'en.classify.roberta.by_shenzy': 'roberta_classifier_sentence_classification4designtutor',
            'en.classify.roberta.by_shubh024': 'roberta_classifier_autotrain_intentclassificationfilipino_715021714',
            'en.classify.roberta.by_siddish': 'roberta_classifier_autotrain_yes_or_no_on_circa_1009033469',
            'en.classify.roberta.by_sindhu': 'roberta_classifier_emo',
            'en.classify.roberta.by_skolkovoinstitute': 'roberta_classifier_toxicity',
            'en.classify.roberta.by_tayyaba': 'roberta_classifier_autotrain_pan_977432399',
            'en.classify.roberta.by_unitary': 'roberta_classifier_unbiased_toxic',
            'en.classify.roberta.by_unjustify': 'roberta_classifier_autotrain_commonsense_1_696121179',
            'en.classify.roberta.by_wanghao2023': 'roberta_classifier_uganda_labor_market_interview_text_classification',
            'en.classify.roberta.by_wanyu': 'roberta_classifier_iterater_intention',
            'en.classify.roberta.by_xyhy': 'roberta_classifier_autonlp_123_478412765',
            'en.classify.roberta.by_zamachi': 'roberta_classifier_for_multilabel_sentence_classification',
            'en.classify.roberta.by_zwang199': 'roberta_classifier_autonlp_traffic_nlp_binary_537215209',
            'en.classify.roberta.car_review.v1.by_qualitydatalab': 'roberta_classifier_autotrain_car_review_project_966432120',
            'en.classify.roberta.car_review.v2.by_qualitydatalab': 'roberta_classifier_autotrain_car_review_project_966432121',
            'en.classify.roberta.clickbait.distilled.by_valurank': 'roberta_classifier_distil_clickbait',
            'en.classify.roberta.clinc.large_finetuned.by_lewtun': 'roberta_classifier_lewtun_large_finetuned_clinc',
            'en.classify.roberta.clinc.v1.large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_314',
            'en.classify.roberta.clinc.v2.large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_1234567',
            'en.classify.roberta.clinc.v2large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_1',
            'en.classify.roberta.clinc.v3large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_12',
            'en.classify.roberta.clinc.v4large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_123',
            'en.classify.roberta.clinc.v5large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_1234',
            'en.classify.roberta.clinc.v6large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_12345',
            'en.classify.roberta.clinc.v7large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_123456',
            'en.classify.roberta.clinc.v9large_finetuned.by_lewtun': 'roberta_classifier_large_finetuned_clinc_3141',
            'en.classify.roberta.cord19_sentiment.': 'roberta_classifier_discord_nft_sentiment',
            'en.classify.roberta.covid.': 'roberta_classifier_autonlp_bert_covid_407910467',
            'en.classify.roberta.covid.by_anelnurkayeva': 'roberta_classifier_autonlp_covid_432211280',
            'en.classify.roberta.covid.by_moritzlaurer': 'roberta_classifier_covid_policy_21',
            'en.classify.roberta.covid_news.': 'roberta_classifier_autonlp_fake_covid_news_36769078',
            'en.classify.roberta.crypto.': 'roberta_classifier_cryptobert',
            'en.classify.roberta.crypto_sentiment.': 'roberta_classifier_autotrain_nlu_crypto_sentiment_analysis_754123133',
            'en.classify.roberta.cuad.': 'roberta_classifier_cuad_contract_type',
            'en.classify.roberta.current.distilled.by_valurank': 'roberta_classifier_distil_current',
            'en.classify.roberta.distilled': 'roberta_classifier_distil_bias',
            'en.classify.roberta.distilled.by_anthos23': 'roberta_classifier_fs_distil_fine_tuned',
            'en.classify.roberta.distilled_base': 'roberta_classifier_emotion_english_distil_base',
            'en.classify.roberta.distilled_base.by_azizbarank': 'roberta_classifier_distil_base_sst2_distilled',
            'en.classify.roberta.distilled_base.by_j_hartmann': 'roberta_classifier_concreteness_english_distil_base',
            'en.classify.roberta.distilled_finetuned': 'roberta_classifier_distil_finetuned_financial_text_classification',
            'en.classify.roberta.distilled_finetuned.by_narrativa': 'roberta_classifier_distil_finetuned_stereotype_detection',
            'en.classify.roberta.distilled_mini_lm_mini': 'roberta_classifier_minilm_l12_clinc_distilled',
            'en.classify.roberta.distilled_mini_lm_mini.by_moshew': 'roberta_classifier_minilm_l6_clinc_distilled',
            'en.classify.roberta.distilled_v2_mini_lm_mini_finetuned': 'roberta_classifier_lewtun_minilmv2_l12_h384_distilled_finetuned_clinc',
            'en.classify.roberta.distilled_v2_mini_lm_mini_finetuned.by_optimum': 'roberta_classifier_optimum_minilmv2_l12_h384_distilled_finetuned_clinc',
            'en.classify.roberta.distilled_v2_mini_lm_mini_finetuned.by_philschmid': 'roberta_classifier_philschmid_minilmv2_l12_h384_distilled_finetuned_clinc',
            'en.classify.roberta.election_relevancy_best.by_sefaozalpadl': 'roberta_classifier_election_relevancy_best',
            'en.classify.roberta.email_spam.distilled_v2_mini_lm_mini_finetuned': 'roberta_classifier_minilmv2_l12_h384_distilled_finetuned_spam_detection',
            'en.classify.roberta.emotion.base': 'roberta_classifier_base_emotion',
            'en.classify.roberta.emotion.base.by_Jorgeutd': 'roberta_classifier_sagemaker_base_emotion',
            'en.classify.roberta.emotion.by_osiris': 'roberta_classifier_emotion',
            'en.classify.roberta.emotion.v2_mini_lm_mini': 'roberta_classifier_minilmv2_l12_h384_emotion',
            'en.classify.roberta.emotion.v2_mini_lm_mini.by_philschmid': 'roberta_classifier_minilmv2_l6_h384_emotion',
            'en.classify.roberta.environment.': 'roberta_classifier_environmental_claims',
            'en.classify.roberta.fakeddit.': 'roberta_classifier_fakeddit',
            'en.classify.roberta.fever.': 'roberta_classifier_fever',
            'en.classify.roberta.fever.large': 'roberta_classifier_large_snli_mnli_fever_anli_r1_r2_r3_nli',
            'en.classify.roberta.finetuned': 'roberta_sequence_classifier_codebert2codebert_finetuned_code_defect_detection',
            'en.classify.roberta.finetuned.by_ali2066': 'roberta_classifier_finetuned_sentence_itr0_2e_05_all_01_03_2022_02_53_51',
            'en.classify.roberta.glue.': 'roberta_classifier_cuenb_mnli',
            'en.classify.roberta.glue.base': 'roberta_classifier_intel_base_mrpc',
            'en.classify.roberta.glue.distilled_base': 'roberta_classifier_platzi_distil_base_mrpc_glue_omar_espejel',
            'en.classify.roberta.glue.distilled_mini_lm_mini': 'roberta_classifier_minilm_l12_h384_sst2_distilled',
            'en.classify.roberta.glue.large': 'roberta_classifier_philschmid_large_sst2',
            'en.classify.roberta.glue.v2_mini_lm_mini': 'roberta_classifier_minilmv2_l12_h384_sst2',
            'en.classify.roberta.glue.v2_mini_lm_mini_l6_h384_sst2.by_philschmid': 'roberta_classifier_minilmv2_l6_h384_sst2',
            'en.classify.roberta.glue.v2_mini_lm_mini_l6_h768_sst2.by_philschmid': 'roberta_classifier_minilmv2_l6_h768_sst2',
            'en.classify.roberta.glue_cola1.base': 'roberta_classifier_base_cola',
            'en.classify.roberta.go_emotions.': 'roberta_classifier_emoroberta',
            'en.classify.roberta.hate.': 'roberta_classifier_hate_speech_dynabench_r1_target',
            'en.classify.roberta.hate.base': 'roberta_classifier_base_frenk_hate',
            'en.classify.roberta.hate.distilled': 'roberta_classifier_distil_hatespeech',
            'en.classify.roberta.hate.dynabench_r2_target.by_facebook': 'roberta_classifier_hate_speech_dynabench_r2_target',
            'en.classify.roberta.hate.dynabench_r3_target.by_facebook': 'roberta_classifier_hate_speech_dynabench_r3_target',
            'en.classify.roberta.hate.dynabench_r4_target.by_facebook': 'roberta_classifier_hate_speech_dynabench_r4_target',
            'en.classify.roberta.imdb': 'roberta_base_sequence_classifier_imdb',
            'en.classify.roberta.imdb.': 'roberta_classifier_autonlp_imdb_demo_hf_16622775',
            'en.classify.roberta.imdb.base': 'roberta_classifier_base_imdb',
            'en.classify.roberta.imdb.base.by_abhishek': 'roberta_classifier_autonlp_imdb_base_3662644',
            'en.classify.roberta.imdb.base_v1.by_sasha': 'roberta_classifier_autotrain_base_imdb_1275248775',
            'en.classify.roberta.imdb.base_v2.by_sasha': 'roberta_classifier_autotrain_base_imdb_1275248776',
            'en.classify.roberta.imdb.base_v3.by_sasha': 'roberta_classifier_autotrain_base_imdb_1275248777',
            'en.classify.roberta.imdb.base_v4.by_sasha': 'roberta_classifier_autotrain_base_imdb_1275248778',
            'en.classify.roberta.imdb.base_v5.by_sasha': 'roberta_classifier_autotrain_base_imdb_1275248779',
            'en.classify.roberta.imdb.by_kaveh8': 'roberta_classifier_autonlp_imdb_rating_625417974',
            'en.classify.roberta.imdb.by_mmcquade11': 'roberta_classifier_autonlp_imdb_test_21134453',
            'en.classify.roberta.imdb_sentiment.': 'roberta_classifier_autonlp_imdb_sentiment_classification_31154',
            'en.classify.roberta.imdb_sentiment.32d': 'roberta_classifier_autonlp_imdb_reviews_sentiment_329982',
            'en.classify.roberta.imdb_sentiment.by_pierric': 'roberta_classifier_autonlp_my_own_imdb_sentiment_analysis_2131817',
            'en.classify.roberta.lang': 'roberta_classifier_codeberta_language_identification',
            'en.classify.roberta.lang.by_addy88': 'roberta_classifier_programming_lang_identifier',
            'en.classify.roberta.large': 'roberta_classifier_emotion_english_large',
            'en.classify.roberta.large.by_alisawuffles': 'roberta_classifier_large_wanli',
            'en.classify.roberta.large.by_cestwc': 'roberta_classifier_large',
            'en.classify.roberta.large.by_deeppavlov': 'roberta_classifier_large_winogrande',
            'en.classify.roberta.large.by_j_hartmann': 'roberta_classifier_purchase_intention_english_large',
            'en.classify.roberta.large.by_mcgill_nlp': 'roberta_classifier_large_faithcritic',
            'en.classify.roberta.large.by_sam890914': 'roberta_classifier_autonlp_large2_479012819',
            'en.classify.roberta.large.by_uploaded by huggingface': 'roberta_classifier_large_mnli',
            'en.classify.roberta.large_4h': 'roberta_classifier_autotrain_smm4h_large_clean_874027878',
            'en.classify.roberta.large_finetuned': 'roberta_classifier_autonlp_large_finetuned_467612250',
            'en.classify.roberta.large_finetuned.by_dbounds': 'roberta_classifier_dbounds_large_finetuned_clinc',
            'en.classify.roberta.large_finetuned.by_optimum': 'roberta_classifier_optimum_large_finetuned_clinc',
            'en.classify.roberta.large_finetuned.by_philschmid': 'roberta_classifier_philschmid_large_finetuned_clinc',
            'en.classify.roberta.large_finetuned.by_yuetian': 'roberta_classifier_large_finetuned_plutchik_emotion',
            'en.classify.roberta.large_finetuned_adverse_drug_event': 'roberta_classifier_large_mnli_finetuned_header',
            'en.classify.roberta.live_demo_question_intimacy.by_pedropei': 'roberta_classifier_live_demo_question_intimacy',
            'en.classify.roberta.mbfc_bias.distilled.by_valurank': 'roberta_classifier_distil_mbfc_bias',
            'en.classify.roberta.mbfc_bias_4class.distilled.by_valurank': 'roberta_classifier_distil_mbfc_bias_4class',
            'en.classify.roberta.mnli.distilled_base.by_boychaboy': 'roberta_classifier_mnli_distil_base',
            'en.classify.roberta.mnli_200.large.by_veronica320': 'roberta_classifier_spte_large_mnli_200',
            'en.classify.roberta.mnli_large.large.by_boychaboy': 'roberta_classifier_mnli_large',
            'en.classify.roberta.mnli_misogyny_sexism.tweet.large_4tweets_3e_05_0.05.by_annahaz': 'roberta_classifier_large_mnli_misogyny_sexism_4tweets_3e_05_0.05',
            'en.classify.roberta.mnli_misogyny_sexism.tweet.large_4tweets_3e_05_0.055_4.by_annahaz': 'roberta_classifier_large_mnli_misogyny_sexism_4tweets_3e_05_0.055_4',
            'en.classify.roberta.mnli_misogyny_sexism.tweet.large_4tweets_3e_05_0.05_singledt.by_annahaz': 'roberta_classifier_large_mnli_misogyny_sexism_4tweets_3e_05_0.05_singledt',
            'en.classify.roberta.mnli_misogyny_sexism.tweet.large_4tweets_3e_05_0.07.by_annahaz': 'roberta_classifier_large_mnli_misogyny_sexism_4tweets_3e_05_0.07',
            'en.classify.roberta.mrpc.glue.base.by_JeremiahZ': 'roberta_classifier_jeremiahz_base_mrpc',
            'en.classify.roberta.neutral_non_neutral.by_osiris': 'roberta_classifier_neutral_non_neutral',
            'en.classify.roberta.news.': 'roberta_classifier_autotrain_news_916530070',
            'en.classify.roberta.news.by_hamzab': 'roberta_classifier_fake_news_classification',
            'en.classify.roberta.news.by_nithiwat': 'roberta_classifier_fake_news_debunker',
            'en.classify.roberta.news.distilled_base_finetuned': 'roberta_classifier_distil_base_finetuned_fake_news_english',
            'en.classify.roberta.news.distilled_small': 'roberta_classifier_distil_news_small',
            'en.classify.roberta.news_sentiment.': 'roberta_classifier_news_sentiment_analysis',
            'en.classify.roberta.news_sentiment_twitter.base_finetuned': 'roberta_classifier_twitter_base_sentiment_latest_finetuned_fg_single_sentence_news',
            'en.classify.roberta.news_sentiment_twitter.d_base_finetuned': 'roberta_classifier_twitter_base_sentiment_latest_finetuned_fg_concat_sentence_h_news',
            'en.classify.roberta.not_interested.by_aujer': 'roberta_classifier_autotrain_not_interested_1_1213145894',
            'en.classify.roberta.not_interested.v2.by_aujer': 'roberta_classifier_not_interested_v0',
            'en.classify.roberta.offensive.distilled.by_valurank': 'roberta_classifier_distil_offensive',
            'en.classify.roberta.propaganda_2class.distilled.by_valurank': 'roberta_classifier_distil_propaganda_2class',
            'en.classify.roberta.proppy.distilled.by_valurank': 'roberta_classifier_distil_proppy',
            'en.classify.roberta.pyrxsum.large.by_shiyue': 'roberta_classifier_large_pyrxsum',
            'en.classify.roberta.qnli.glue.base.by_JeremiahZ': 'roberta_classifier_qnli_base',
            'en.classify.roberta.qqp.glue.base.by_JeremiahZ': 'roberta_classifier_qqp_base',
            'en.classify.roberta.question_intimacy.by_pedropei': 'roberta_classifier_question_intimacy',
            'en.classify.roberta.realsumm.large.by_shiyue': 'roberta_classifier_large_realsumm',
            'en.classify.roberta.realsumm_by_examples_fold1.large.by_shiyue': 'roberta_classifier_large_realsumm_by_examples_fold1',
            'en.classify.roberta.realsumm_by_examples_fold2.large.by_shiyue': 'roberta_classifier_large_realsumm_by_examples_fold2',
            'en.classify.roberta.realsumm_by_examples_fold3.large.by_shiyue': 'roberta_classifier_large_realsumm_by_examples_fold3',
            'en.classify.roberta.realsumm_by_examples_fold4.large.by_shiyue': 'roberta_classifier_large_realsumm_by_examples_fold4',
            'en.classify.roberta.realsumm_by_examples_fold5.large.by_shiyue': 'roberta_classifier_large_realsumm_by_examples_fold5',
            'en.classify.roberta.realsumm_by_systems_fold1.large.by_shiyue': 'roberta_classifier_large_realsumm_by_systems_fold1',
            'en.classify.roberta.realsumm_by_systems_fold2.large.by_shiyue': 'roberta_classifier_large_realsumm_by_systems_fold2',
            'en.classify.roberta.realsumm_by_systems_fold3.large.by_shiyue': 'roberta_classifier_large_realsumm_by_systems_fold3',
            'en.classify.roberta.realsumm_by_systems_fold4.large.by_shiyue': 'roberta_classifier_large_realsumm_by_systems_fold4',
            'en.classify.roberta.realsumm_by_systems_fold5.large.by_shiyue': 'roberta_classifier_large_realsumm_by_systems_fold5',
            'en.classify.roberta.rte.glue.base.by_JeremiahZ': 'roberta_classifier_rte_base',
            'en.classify.roberta.security_text.': 'roberta_classifier_autotrain_security_texts_classification_688020754',
            'en.classify.roberta.security_text.distilled': 'roberta_classifier_autotrain_security_texts_classification_distil_688220764',
            'en.classify.roberta.sentiment.': 'roberta_classifier_autotrain_sentiment_polarity_918130222',
            'en.classify.roberta.sentiment.base': 'roberta_classifier_base_indonesian_1.5g_sentiment_analysis_smsa',
            'en.classify.roberta.sentiment.base.by_veb': 'roberta_classifier_twitch_base_sentiment_latest',
            'en.classify.roberta.sentiment.by_acho0057': 'roberta_classifier_sentiment_analysis_custom',
            'en.classify.roberta.sentiment.by_souvikcmsa': 'roberta_classifier_sentiment_analysis',
            'en.classify.roberta.sentiment.finetuning_': 'roberta_classifier_finetuning_cardiffnlp_sentiment_model',
            'en.classify.roberta.sentiment.large': 'roberta_classifier_sentiment_large_english',
            'en.classify.roberta.sentiment.large.by_j_hartmann': 'roberta_classifier_sentiment_large_english_3_classes',
            'en.classify.roberta.sentiment.large.by_soleimanian': 'roberta_classifier_financial_large_sentiment',
            'en.classify.roberta.sentiment_twitter.': 'roberta_classifier_robbert_twitter_sentiment',
            'en.classify.roberta.sentiment_twitter.base': 'roberta_classifier_twitter_base_sentiment_latest',
            'en.classify.roberta.sentiment_twitter.base_finetuned': 'roberta_classifier_twitter_base_mar2022_finetuned_sentiment',
            'en.classify.roberta.small': 'roberta_classifier_indonesia_emotion_small',
            'en.classify.roberta.snli.distilled_base.by_boychaboy': 'roberta_classifier_snli_distil_base',
            'en.classify.roberta.snli_large.large.by_boychaboy': 'roberta_classifier_snli_large',
            'en.classify.roberta.stop_the_steal_relevancy_analysis_binary.by_sefaozalpadl': 'roberta_classifier_stop_the_steal_relevancy_analysis_binary',
            'en.classify.roberta.tac08.large.by_shiyue': 'roberta_classifier_large_tac08',
            'en.classify.roberta.tac08_tac09.large.by_shiyue': 'roberta_classifier_large_tac08_tac09',
            'en.classify.roberta.tac09.large.by_shiyue': 'roberta_classifier_large_tac09',
            'en.classify.roberta.tweet.': 'roberta_classifier_tweet_offensive_eval',
            'en.classify.roberta.tweet.base_128d': 'roberta_classifier_autotrain_basetweeteval_1281048986',
            'en.classify.roberta.tweet.base_128d_1281048987.by_sasha': 'roberta_classifier_autotrain_basetweeteval_1281048987',
            'en.classify.roberta.tweet.base_128d_1281048988.by_sasha': 'roberta_classifier_autotrain_basetweeteval_1281048988',
            'en.classify.roberta.tweet.base_128d_1281048989.by_sasha': 'roberta_classifier_autotrain_basetweeteval_1281048989',
            'en.classify.roberta.tweet.base_128d_1281048990.by_sasha': 'roberta_classifier_autotrain_basetweeteval_1281048990',
            'en.classify.roberta.tweet.by_keithhorgan': 'roberta_classifier_tweetclimateanalysis',
            'en.classify.roberta.tweet.large': 'roberta_classifier_large_mnli_misogyny_sexism_4tweets_2e_05_0.05',
            'en.classify.roberta.tweet_sentiment.': 'roberta_classifier_tweet_sentiment_eval',
            'en.classify.roberta.tweet_topic_19_multi.by_cardiffnlp': 'roberta_classifier_tweet_topic_19_multi',
            'en.classify.roberta.tweet_topic_19_single.by_cardiffnlp': 'roberta_classifier_tweet_topic_19_single',
            'en.classify.roberta.tweet_topic_21_multi.by_cardiffnlp': 'roberta_classifier_tweet_topic_21_multi',
            'en.classify.roberta.tweet_topic_21_single.by_cardiffnlp': 'roberta_classifier_tweet_topic_21_single',
            'en.classify.roberta.twisent_siebert.by_shatabdi': 'roberta_classifier_twisent_siebert',
            'en.classify.roberta.twisent_twisent.by_shatabdi': 'roberta_classifier_twisent_twisent',
            'en.classify.roberta.twitter.': 'roberta_classifier_stress_twitter',
            'en.classify.roberta.twitter.base': 'roberta_classifier_twitter_base_dec2021_rbam_fine_tuned',
            'en.classify.roberta.twitter.base.by_cardiffnlp': 'roberta_classifier_twitter_base_emotion',
            'en.classify.roberta.twitter.base.by_maxpe': 'roberta_classifier_twitter_base_jun2022_sem_eval_2018_task_1',
            'en.classify.roberta.twitter.base_finetuned': 'roberta_classifier_twitter_base_mar2022_finetuned_emotion',
            'en.classify.roberta.twitter.v2_base': 'roberta_classifier_twitter_base_stance_abortionv2',
            'en.classify.roberta.v2_mini_lm_mini_finetuned': 'roberta_classifier_minilmv2_l12_h384_finetuned_clinc',
            'en.classify.sarcasm': 'classifierdl_use_sarcasm',
            'en.classify.sarcasm.use': 'classifierdl_use_sarcasm',
            'en.classify.scibert.battery_scibert.cased': 'bert_classifier_batteryscibert_cased_abstract',
            'en.classify.scibert.battery_scibert.uncased': 'bert_classifier_batteryscibert_uncased_abstract',
            'en.classify.scibert.scibert.cased': 'bert_classifier_scibert_scivocab_cased_pub_section',
            'en.classify.scibert.scibert.uncased': 'bert_classifier_scibert_scivocab_uncased_pub_section',
            'en.classify.sentiment.imdb.deberta': 'deberta_v3_xsmall_sequence_classifier_imdb',
            'en.classify.sentiment.imdb.deberta.base': 'deberta_v3_base_sequence_classifier_imdb',
            'en.classify.sentiment.imdb.deberta.large': 'deberta_v3_large_sequence_classifier_imdb',
            'en.classify.sentiment.imdb.deberta.small': 'deberta_v3_small_sequence_classifier_imdb',
            'en.classify.snips': 'nerdl_snips_100d',
            'en.classify.snli.bert.cased_base.by_boychaboy': 'bert_classifier_snli_base_cased',
            'en.classify.snli.roberta.base.by_boychaboy': 'roberta_classifier_snli_base',
            'en.classify.song_lyrics': 'bert_sequence_classifier_song_lyrics',
            'en.classify.spam': 'classifierdl_use_spam',
            'en.classify.spam.use': 'classifierdl_use_spam',
            'en.classify.sst1.roberta.by_lucianpopa': 'roberta_classifier_autonlp_sst1_529214890',
            'en.classify.target_group.bert.base.by_thusken': 'bert_classifier_nb_base_target_group',
            'en.classify.token_albert.xlarge_token_classifier_conll03': 'albert_xlarge_token_classifier_conll03',
            'en.classify.token_albert_base_token_classifier_conll03': 'albert_base_token_classifier_conll03',
            'en.classify.token_albert_large_token_classifier_conll03': 'albert_large_token_classifier_conll03',
            'en.classify.token_bert.classifier_ner_btc': 'bert_token_classifier_ner_btc',
            'en.classify.token_bert.conll03': 'bert_base_token_classifier_conll03',
            'en.classify.token_bert.few_nerd': 'bert_base_token_classifier_few_nerd',
            'en.classify.token_bert.large_conll03': 'bert_large_token_classifier_conll03',
            'en.classify.token_bert.large_ontonote': 'bert_large_token_classifier_ontonote',
            'en.classify.token_bert.ontonote': 'bert_base_token_classifier_ontonote',
            'en.classify.token_distilroberta_base_token_classifier_ontonotes': 'distilroberta_base_token_classifier_ontonotes',
            'en.classify.token_longformer.base_token_classifier_conll03': 'longformer_base_token_classifier_conll03',
            'en.classify.token_roberta.large_token_classifier_ontonotes': 'roberta_large_token_classifier_ontonotes',
            'en.classify.token_roberta_base_token_classifier_conll03': 'roberta_base_token_classifier_conll03',
            'en.classify.token_roberta_base_token_classifier_ontonotes': 'roberta_base_token_classifier_ontonotes',
            'en.classify.token_roberta_large_token_classifier_conll03': 'roberta_large_token_classifier_conll03',
            'en.classify.token_xlnet.large_token_classifier_conll03': 'xlnet_large_token_classifier_conll03',
            'en.classify.token_xlnet_base_token_classifier_conll03': 'xlnet_base_token_classifier_conll03',
            'en.classify.tone.bert.by_yiyanghkust': 'bert_classifier_finbert_tone',
            'en.classify.toxic': 'multiclassifierdl_use_toxic',
            'en.classify.toxic.sm': 'multiclassifierdl_use_toxic_sm',
            'en.classify.toxicity.bert.uncased_base.by_mohsenfayyaz': 'bert_classifier_base_uncased_toxicity_a',
            'en.classify.trec.roberta.by_lucianpopa': 'roberta_classifier_autonlp_trec_classification_522314623',
            'en.classify.trec50': 'classifierdl_use_trec50',
            'en.classify.trec50.use': 'classifierdl_use_trec50',
            'en.classify.trec6': 'classifierdl_use_trec6',
            'en.classify.trec6.use': 'classifierdl_use_trec6',
            'en.classify.typos.distilbert': 'distilbert_token_classifier_typo_detector',
            'en.classify.user_needs.bert.base.by_thusken': 'bert_classifier_nb_base_user_needs',
            'en.classify.xlm_roberta.ag_news': 'xlm_roberta_base_sequence_classifier_ag_news',
            'en.classify.xlm_roberta.imdb': 'xlm_roberta_base_sequence_classifier_imdb',
            'en.classify.xlmr_roberta.glue.base': 'xlmroberta_classifier_base_mrpc',
            'en.classify_image.ALL': 'image_classifier_vit_ALL',
            'en.classify_image.CarViT': 'image_classifier_vit_CarViT',
            'en.classify_image.Check_Aligned_Teeth': 'image_classifier_vit_Check_Aligned_Teeth',
            'en.classify_image.Check_GoodBad_Teeth': 'image_classifier_vit_Check_GoodBad_Teeth',
            'en.classify_image.Check_Gum_Teeth': 'image_classifier_vit_Check_Gum_Teeth',
            'en.classify_image.Check_Missing_Teeth': 'image_classifier_vit_Check_Missing_Teeth',
            'en.classify_image.Infrastructures': 'image_classifier_vit_Infrastructures',
            'en.classify_image.Insectodoptera': 'image_classifier_vit_Insectodoptera',
            'en.classify_image.PANDA_ViT': 'image_classifier_vit_PANDA_ViT',
            'en.classify_image.PanJuOffset_TwoClass': 'image_classifier_vit_PanJuOffset_TwoClass',
            'en.classify_image.SDO_VT1': 'image_classifier_vit_SDO_VT1',
            'en.classify_image.Teeth_A': 'image_classifier_vit_Teeth_A',
            'en.classify_image.Teeth_B': 'image_classifier_vit_Teeth_B',
            'en.classify_image.Teeth_C': 'image_classifier_vit_Teeth_C',
            'en.classify_image.Test_Model': 'image_classifier_vit_Test_Model',
            'en.classify_image.Tomato_Leaf_Classifier': 'image_classifier_vit_Tomato_Leaf_Classifier',
            'en.classify_image.VIT_Basic': 'image_classifier_vit_VIT_Basic',
            'en.classify_image.ViTFineTuned': 'image_classifier_vit_ViTFineTuned',
            'en.classify_image.ViT_FaceMask_Finetuned': 'image_classifier_vit_ViT_FaceMask_Finetuned',
            'en.classify_image.Visual_transformer_chihuahua_cookies': 'image_classifier_vit_Visual_transformer_chihuahua_cookies',
            'en.classify_image.WEC_types': 'image_classifier_vit_WEC_types',
            'en.classify_image._beans': 'image_classifier_vit__beans',
            'en.classify_image._flyswot_test': 'image_classifier_vit__flyswot_test',
            'en.classify_image._spectrogram': 'image_classifier_vit__spectrogram',
            'en.classify_image.age_classifier': 'image_classifier_vit_age_classifier',
            'en.classify_image.airplanes': 'image_classifier_vit_airplanes',
            'en.classify_image.ak__base_patch16_224_in21k_image_classification': 'image_classifier_vit_ak__base_patch16_224_in21k_image_classification',
            'en.classify_image.amgerindaf': 'image_classifier_vit_amgerindaf',
            'en.classify_image.animal_classifier': 'image_classifier_vit_animal_classifier',
            'en.classify_image.animal_classifier_huggingface': 'image_classifier_vit_animal_classifier_huggingface',
            'en.classify_image.animals_classifier': 'image_classifier_vit_animals_classifier',
            'en.classify_image.anomaly': 'image_classifier_vit_anomaly',
            'en.classify_image.apes': 'image_classifier_vit_apes',
            'en.classify_image.architectural_styles': 'image_classifier_vit_architectural_styles',
            'en.classify_image.asl': 'image_classifier_vit_asl',
            'en.classify_image.autotrain_cifar10__base': 'image_classifier_vit_autotrain_cifar10__base',
            'en.classify_image.autotrain_dog_vs_food': 'image_classifier_vit_autotrain_dog_vs_food',
            'en.classify_image.autotrain_fashion_mnist__base': 'image_classifier_vit_autotrain_fashion_mnist__base',
            'en.classify_image.baked_goods': 'image_classifier_vit_baked_goods',
            'en.classify_image.base_avengers_v1': 'image_classifier_vit_base_avengers_v1',
            'en.classify_image.base_beans': 'image_classifier_vit_base_beans',
            'en.classify_image.base_beans_demo': 'image_classifier_vit_base_beans_demo',
            'en.classify_image.base_beans_demo_v2': 'image_classifier_vit_base_beans_demo_v2',
            'en.classify_image.base_beans_demo_v3': 'image_classifier_vit_base_beans_demo_v3',
            'en.classify_image.base_beans_demo_v5': 'image_classifier_vit_base_beans_demo_v5',
            'en.classify_image.base_cats_vs_dogs': 'image_classifier_vit_base_cats_vs_dogs',
            'en.classify_image.base_cifar10': 'image_classifier_vit_base_cifar10',
            'en.classify_image.base_food101': 'image_classifier_vit_base_food101',
            'en.classify_image.base_movie_scenes_v1': 'image_classifier_vit_base_movie_scenes_v1',
            'en.classify_image.base_mri': 'image_classifier_vit_base_mri',
            'en.classify_image.base_patch16_224': 'image_classifier_vit_base_patch16_224',
            'en.classify_image.base_patch16_224.by_google': 'image_classifier_vit_base_patch16_224',
            'en.classify_image.base_patch16_224_cifar10': 'image_classifier_vit_base_patch16_224_cifar10',
            'en.classify_image.base_patch16_224_finetuned_eurosat': 'image_classifier_vit_base_patch16_224_finetuned_eurosat',
            'en.classify_image.base_patch16_224_finetuned_kvasirv2_colonoscopy': 'image_classifier_vit_base_patch16_224_finetuned_kvasirv2_colonoscopy',
            'en.classify_image.base_patch16_224_finetuned_largerDataSet_docSeperator_more_labels_all_apache2': 'image_classifier_vit_base_patch16_224_finetuned_largerDataSet_docSeperator_more_labels_all_apache2',
            'en.classify_image.base_patch16_224_finetuned_pneumothorax': 'image_classifier_vit_base_patch16_224_finetuned_pneumothorax',
            'en.classify_image.base_patch16_224_in21k_aidSat': 'image_classifier_vit_base_patch16_224_in21k_aidSat',
            'en.classify_image.base_patch16_224_in21k_bantai_v1': 'image_classifier_vit_base_patch16_224_in21k_bantai_v1',
            'en.classify_image.base_patch16_224_in21k_classify_4scence': 'image_classifier_vit_base_patch16_224_in21k_classify_4scence',
            'en.classify_image.base_patch16_224_in21k_euroSat': 'image_classifier_vit_base_patch16_224_in21k_euroSat',
            'en.classify_image.base_patch16_224_in21k_finetuned_cifar10': 'image_classifier_vit_base_patch16_224_in21k_finetuned_cifar10',
            'en.classify_image.base_patch16_224_in21k_snacks': 'image_classifier_vit_base_patch16_224_in21k_snacks',
            'en.classify_image.base_patch16_224_in21k_ucSat': 'image_classifier_vit_base_patch16_224_in21k_ucSat',
            'en.classify_image.base_patch16_224_recylce_ft': 'image_classifier_vit_base_patch16_224_recylce_ft',
            'en.classify_image.base_patch16_384': 'image_classifier_vit_base_patch16_384',
            'en.classify_image.base_patch16_384.by_google': 'image_classifier_vit_base_patch16_384',
            'en.classify_image.base_patch32_384': 'image_classifier_vit_base_patch32_384',
            'en.classify_image.base_patch32_384.by_google': 'image_classifier_vit_base_patch32_384',
            'en.classify_image.base_patch32_384_finetuned_eurosat': 'image_classifier_vit_base_patch32_384_finetuned_eurosat',
            'en.classify_image.base_xray_pneumonia': 'image_classifier_vit_base_xray_pneumonia',
            'en.classify_image.baseball_stadium_foods': 'image_classifier_vit_baseball_stadium_foods',
            'en.classify_image.beer_vs_wine': 'image_classifier_vit_beer_vs_wine',
            'en.classify_image.beer_whisky_wine_detection': 'image_classifier_vit_beer_whisky_wine_detection',
            'en.classify_image.blocks': 'image_classifier_vit_blocks',
            'en.classify_image.cifar10': 'image_classifier_vit_cifar10',
            'en.classify_image.cifar_10_2': 'image_classifier_vit_cifar_10_2',
            'en.classify_image.computer_stuff': 'image_classifier_vit_computer_stuff',
            'en.classify_image.croupier_creature_classifier': 'image_classifier_vit_croupier_creature_classifier',
            'en.classify_image.deit_base_patch16_224': 'image_classifier_vit_deit_base_patch16_224',
            'en.classify_image.deit_base_patch16_224.by_facebook': 'image_classifier_vit_deit_base_patch16_224',
            'en.classify_image.deit_flyswot': 'image_classifier_vit_deit_flyswot',
            'en.classify_image.deit_small_patch16_224': 'image_classifier_vit_deit_small_patch16_224',
            'en.classify_image.deit_small_patch16_224.by_facebook': 'image_classifier_vit_deit_small_patch16_224',
            'en.classify_image.deit_tiny_patch16_224': 'image_classifier_vit_deit_tiny_patch16_224',
            'en.classify_image.deit_tiny_patch16_224.by_facebook': 'image_classifier_vit_deit_tiny_patch16_224',
            'en.classify_image.demo': 'image_classifier_vit_demo',
            'en.classify_image.denver_nyc_paris': 'image_classifier_vit_denver_nyc_paris',
            'en.classify_image.diam': 'image_classifier_vit_diam',
            'en.classify_image.digital': 'image_classifier_vit_digital',
            'en.classify_image.dog': 'image_classifier_vit_dog',
            'en.classify_image.dog_breed_classifier': 'image_classifier_vit_dog_breed_classifier',
            'en.classify_image.dog_food__base_patch16_224_in21k': 'image_classifier_vit_dog_food__base_patch16_224_in21k',
            'en.classify_image.dog_races': 'image_classifier_vit_dog_races',
            'en.classify_image.dog_vs_chicken': 'image_classifier_vit_dog_vs_chicken',
            'en.classify_image.doggos_lol': 'image_classifier_vit_doggos_lol',
            'en.classify_image.dogs': 'image_classifier_vit_dogs',
            'en.classify_image.dwarf_goats': 'image_classifier_vit_dwarf_goats',
            'en.classify_image.electric_2': 'image_classifier_vit_electric_2',
            'en.classify_image.electric_pole_type_classification': 'image_classifier_vit_electric_pole_type_classification',
            'en.classify_image.ex_for_evan': 'image_classifier_vit_ex_for_evan',
            'en.classify_image.exper1_mesum5': 'image_classifier_vit_exper1_mesum5',
            'en.classify_image.exper2_mesum5': 'image_classifier_vit_exper2_mesum5',
            'en.classify_image.exper3_mesum5': 'image_classifier_vit_exper3_mesum5',
            'en.classify_image.exper4_mesum5': 'image_classifier_vit_exper4_mesum5',
            'en.classify_image.exper5_mesum5': 'image_classifier_vit_exper5_mesum5',
            'en.classify_image.exper6_mesum5': 'image_classifier_vit_exper6_mesum5',
            'en.classify_image.exper7_mesum5': 'image_classifier_vit_exper7_mesum5',
            'en.classify_image.exper_batch_16_e4': 'image_classifier_vit_exper_batch_16_e4',
            'en.classify_image.exper_batch_16_e8': 'image_classifier_vit_exper_batch_16_e8',
            'en.classify_image.exper_batch_32_e4': 'image_classifier_vit_exper_batch_32_e4',
            'en.classify_image.exper_batch_32_e8': 'image_classifier_vit_exper_batch_32_e8',
            'en.classify_image.exper_batch_8_e4': 'image_classifier_vit_exper_batch_8_e4',
            'en.classify_image.exper_batch_8_e8': 'image_classifier_vit_exper_batch_8_e8',
            'en.classify_image.fancy_animales': 'image_classifier_vit_fancy_animales',
            'en.classify_image.finetuned_cats_dogs': 'image_classifier_vit_finetuned_cats_dogs',
            'en.classify_image.finetuned_chest_xray_pneumonia': 'image_classifier_vit_finetuned_chest_xray_pneumonia',
            'en.classify_image.finetuned_eurosat_kornia': 'image_classifier_vit_finetuned_eurosat_kornia',
            'en.classify_image.flowers': 'image_classifier_vit_flowers',
            'en.classify_image.food': 'image_classifier_vit_food',
            'en.classify_image.fruits': 'image_classifier_vit_fruits',
            'en.classify_image.garbage_classification': 'image_classifier_vit_garbage_classification',
            'en.classify_image.generation_xyz': 'image_classifier_vit_generation_xyz',
            'en.classify_image.grain': 'image_classifier_vit_grain',
            'en.classify_image.greens': 'image_classifier_vit_greens',
            'en.classify_image.gtsrb_model': 'image_classifier_vit_gtsrb_model',
            'en.classify_image.hot_dog_or_sandwich': 'image_classifier_vit_hot_dog_or_sandwich',
            'en.classify_image.hotdog_not_hotdog': 'image_classifier_vit_hotdog_not_hotdog',
            'en.classify_image.housing_categories': 'image_classifier_vit_housing_categories',
            'en.classify_image.hugging_geese': 'image_classifier_vit_hugging_geese',
            'en.classify_image.huggingpics_package_demo_2': 'image_classifier_vit_huggingpics_package_demo_2',
            'en.classify_image.ice_cream': 'image_classifier_vit_ice_cream',
            'en.classify_image.iiif_manuscript_': 'image_classifier_vit_iiif_manuscript_',
            'en.classify_image.indian_snacks': 'image_classifier_vit_indian_snacks',
            'en.classify_image.koala_panda_wombat': 'image_classifier_vit_koala_panda_wombat',
            'en.classify_image.lawn_weeds': 'image_classifier_vit_lawn_weeds',
            'en.classify_image.llama_alpaca_guanaco_vicuna': 'image_classifier_vit_llama_alpaca_guanaco_vicuna',
            'en.classify_image.llama_alpaca_snake': 'image_classifier_vit_llama_alpaca_snake',
            'en.classify_image.llama_or_potato': 'image_classifier_vit_llama_or_potato',
            'en.classify_image.llama_or_what': 'image_classifier_vit_llama_or_what',
            'en.classify_image.lotr': 'image_classifier_vit_lotr',
            'en.classify_image.lucky_model': 'image_classifier_vit_lucky_model',
            'en.classify_image.lung_cancer': 'image_classifier_vit_lung_cancer',
            'en.classify_image.mit_indoor_scenes': 'image_classifier_vit_mit_indoor_scenes',
            'en.classify_image.modelversion01': 'image_classifier_vit_modelversion01',
            'en.classify_image.modeversion1_m6_e4': 'image_classifier_vit_modeversion1_m6_e4',
            'en.classify_image.modeversion1_m6_e4n': 'image_classifier_vit_modeversion1_m6_e4n',
            'en.classify_image.modeversion1_m7_e4': 'image_classifier_vit_modeversion1_m7_e4',
            'en.classify_image.modeversion28_7': 'image_classifier_vit_modeversion28_7',
            'en.classify_image.modeversion2_m7_e8': 'image_classifier_vit_modeversion2_m7_e8',
            'en.classify_image.my_bean_VIT': 'image_classifier_vit_my_bean_VIT',
            'en.classify_image.new_exper3': 'image_classifier_vit_new_exper3',
            'en.classify_image.new_york_tokyo_london': 'image_classifier_vit_new_york_tokyo_london',
            'en.classify_image.occupation_prediction': 'image_classifier_vit_occupation_prediction',
            'en.classify_image.opencampus_age_detection': 'image_classifier_vit_opencampus_age_detection',
            'en.classify_image.orcs_and_friends': 'image_classifier_vit_orcs_and_friends',
            'en.classify_image.oz_fauna': 'image_classifier_vit_oz_fauna',
            'en.classify_image.pasta_pizza_ravioli': 'image_classifier_vit_pasta_pizza_ravioli',
            'en.classify_image.pasta_shapes': 'image_classifier_vit_pasta_shapes',
            'en.classify_image.places': 'image_classifier_vit_places',
            'en.classify_image.planes_airlines': 'image_classifier_vit_planes_airlines',
            'en.classify_image.planes_trains_automobiles': 'image_classifier_vit_planes_trains_automobiles',
            'en.classify_image.platzi__base_beans_omar_espejel': 'image_classifier_vit_platzi__base_beans_omar_espejel',
            'en.classify_image.pneumonia_bielefeld_dl_course': 'image_classifier_vit_pneumonia_bielefeld_dl_course',
            'en.classify_image.pneumonia_test_attempt': 'image_classifier_vit_pneumonia_test_attempt',
            'en.classify_image.pond': 'image_classifier_vit_pond',
            'en.classify_image.pond_image_classification_1': 'image_classifier_vit_pond_image_classification_1',
            'en.classify_image.pond_image_classification_10': 'image_classifier_vit_pond_image_classification_10',
            'en.classify_image.pond_image_classification_11': 'image_classifier_vit_pond_image_classification_11',
            'en.classify_image.pond_image_classification_12': 'image_classifier_vit_pond_image_classification_12',
            'en.classify_image.pond_image_classification_2': 'image_classifier_vit_pond_image_classification_2',
            'en.classify_image.pond_image_classification_3': 'image_classifier_vit_pond_image_classification_3',
            'en.classify_image.pond_image_classification_4': 'image_classifier_vit_pond_image_classification_4',
            'en.classify_image.pond_image_classification_5': 'image_classifier_vit_pond_image_classification_5',
            'en.classify_image.pond_image_classification_6': 'image_classifier_vit_pond_image_classification_6',
            'en.classify_image.pond_image_classification_7': 'image_classifier_vit_pond_image_classification_7',
            'en.classify_image.pond_image_classification_8': 'image_classifier_vit_pond_image_classification_8',
            'en.classify_image.pond_image_classification_9': 'image_classifier_vit_pond_image_classification_9',
            'en.classify_image.puppies_classify': 'image_classifier_vit_puppies_classify',
            'en.classify_image.rare_bottle': 'image_classifier_vit_rare_bottle',
            'en.classify_image.rare_puppers': 'image_classifier_vit_rare_puppers',
            'en.classify_image.rare_puppers2': 'image_classifier_vit_rare_puppers2',
            'en.classify_image.rare_puppers3': 'image_classifier_vit_rare_puppers3',
            'en.classify_image.rare_puppers_09_04_2021': 'image_classifier_vit_rare_puppers_09_04_2021',
            'en.classify_image.rare_puppers_demo': 'image_classifier_vit_rare_puppers_demo',
            'en.classify_image.rare_puppers_new_auth': 'image_classifier_vit_rare_puppers_new_auth',
            'en.classify_image.resnet_50_euroSat': 'image_classifier_vit_resnet_50_euroSat',
            'en.classify_image.resnet_50_ucSat': 'image_classifier_vit_resnet_50_ucSat',
            'en.classify_image.road_good_damaged_condition': 'image_classifier_vit_road_good_damaged_condition',
            'en.classify_image.robot2': 'image_classifier_vit_robot2',
            'en.classify_image.robot22': 'image_classifier_vit_robot22',
            'en.classify_image.rock_challenge_DeiT_solo': 'image_classifier_vit_rock_challenge_DeiT_solo',
            'en.classify_image.rock_challenge_DeiT_solo_2': 'image_classifier_vit_rock_challenge_DeiT_solo_2',
            'en.classify_image.rock_challenge_ViT_two_by_two': 'image_classifier_vit_rock_challenge_ViT_two_by_two',
            'en.classify_image.roomclassifier': 'image_classifier_vit_roomclassifier',
            'en.classify_image.roomidentifier': 'image_classifier_vit_roomidentifier',
            'en.classify_image.rust_image_classification_1': 'image_classifier_vit_rust_image_classification_1',
            'en.classify_image.rust_image_classification_10': 'image_classifier_vit_rust_image_classification_10',
            'en.classify_image.rust_image_classification_11': 'image_classifier_vit_rust_image_classification_11',
            'en.classify_image.rust_image_classification_12': 'image_classifier_vit_rust_image_classification_12',
            'en.classify_image.rust_image_classification_2': 'image_classifier_vit_rust_image_classification_2',
            'en.classify_image.rust_image_classification_3': 'image_classifier_vit_rust_image_classification_3',
            'en.classify_image.rust_image_classification_4': 'image_classifier_vit_rust_image_classification_4',
            'en.classify_image.rust_image_classification_5': 'image_classifier_vit_rust_image_classification_5',
            'en.classify_image.rust_image_classification_6': 'image_classifier_vit_rust_image_classification_6',
            'en.classify_image.rust_image_classification_7': 'image_classifier_vit_rust_image_classification_7',
            'en.classify_image.rust_image_classification_8': 'image_classifier_vit_rust_image_classification_8',
            'en.classify_image.rust_image_classification_9': 'image_classifier_vit_rust_image_classification_9',
            'en.classify_image.sea_mammals': 'image_classifier_vit_sea_mammals',
            'en.classify_image.shirt_identifier': 'image_classifier_vit_shirt_identifier',
            'en.classify_image.simple_kitchen': 'image_classifier_vit_simple_kitchen',
            'en.classify_image.skin_type': 'image_classifier_vit_skin_type',
            'en.classify_image.snacks': 'image_classifier_vit_snacks',
            'en.classify_image.south_indian_foods': 'image_classifier_vit_south_indian_foods',
            'en.classify_image.string_instrument_detector': 'image_classifier_vit_string_instrument_detector',
            'en.classify_image.taco_or_what': 'image_classifier_vit_taco_or_what',
            'en.classify_image.teeth_test': 'image_classifier_vit_teeth_test',
            'en.classify_image.teeth_verify': 'image_classifier_vit_teeth_verify',
            'en.classify_image.test': 'image_classifier_vit_test',
            'en.classify_image.test_model_a': 'image_classifier_vit_test_model_a',
            'en.classify_image.tiny__random': 'image_classifier_vit_tiny__random',
            'en.classify_image.tiny_patch16_224': 'image_classifier_vit_tiny_patch16_224',
            'en.classify_image.trainer_rare_puppers': 'image_classifier_vit_trainer_rare_puppers',
            'en.classify_image.upside_down_classifier': 'image_classifier_vit_upside_down_classifier',
            'en.classify_image.vc_bantai__withoutAMBI': 'image_classifier_vit_vc_bantai__withoutAMBI',
            'en.classify_image.vc_bantai__withoutAMBI_adunest': 'image_classifier_vit_vc_bantai__withoutAMBI_adunest',
            'en.classify_image.vc_bantai__withoutAMBI_adunest_trial': 'image_classifier_vit_vc_bantai__withoutAMBI_adunest_trial',
            'en.classify_image.vc_bantai__withoutAMBI_adunest_v1': 'image_classifier_vit_vc_bantai__withoutAMBI_adunest_v1',
            'en.classify_image.vc_bantai__withoutAMBI_adunest_v2': 'image_classifier_vit_vc_bantai__withoutAMBI_adunest_v2',
            'en.classify_image.vc_bantai__withoutAMBI_adunest_v3': 'image_classifier_vit_vc_bantai__withoutAMBI_adunest_v3',
            'en.classify_image.violation_classification_bantai_': 'image_classifier_vit_violation_classification_bantai_',
            'en.classify_image.violation_classification_bantai__v100ep': 'image_classifier_vit_violation_classification_bantai__v100ep',
            'en.classify_image.violation_classification_bantai__v80ep': 'image_classifier_vit_violation_classification_bantai__v80ep',
            'en.classify_image.violation_classification_bantai__withES': 'image_classifier_vit_violation_classification_bantai__withES',
            'en.classify_image.vision_transformer_fmri_classification_ft': 'image_classifier_vit_vision_transformer_fmri_classification_ft',
            'en.classify_image.vision_transformer_v3': 'image_classifier_vit_vision_transformer_v3',
            'en.classify_image.vision_transformers_spain_or_italy_fan': 'image_classifier_vit_vision_transformers_spain_or_italy_fan',
            'en.classify_image.vliegmachine': 'image_classifier_vit_vliegmachine',
            'en.classify_image.where_am_I_hospital_balcony_hallway_airport_coffee_house': 'image_classifier_vit_where_am_I_hospital_balcony_hallway_airport_coffee_house',
            'en.classify_image.where_am_I_hospital_balcony_hallway_airport_coffee_house_apartment_office': 'image_classifier_vit_where_am_I_hospital_balcony_hallway_airport_coffee_house_apartment_office',
            'en.classify_image.world_landmarks': 'image_classifier_vit_world_landmarks',
            'en.coreference.spanbert': 'spanbert_base_coref',
            'en.dep': 'dependency_typed_conllu',
            'en.dep.typed': 'dependency_typed_conllu',
            'en.dep.typed.conllu': 'dependency_typed_conllu',
            'en.dep.untyped': 'dependency_conllu',
            'en.dep.untyped.conllu': 'dependency_conllu',
            'en.e2e': 'multiclassifierdl_use_e2e',
            'en.embed': 'glove_100d',
            'en.embed.Bible_roberta_base': 'roberta_embeddings_Bible_roberta_base',
            'en.embed.COVID_SciBERT': 'bert_embeddings_COVID_SciBERT',
            'en.embed.DiLBERT': 'bert_embeddings_DiLBERT',
            'en.embed.FinancialBERT': 'bert_embeddings_FinancialBERT',
            'en.embed.SecBERT': 'bert_embeddings_SecBERT',
            'en.embed.SecRoBERTa': 'roberta_embeddings_SecRoBERTa',
            'en.embed.agriculture_bert_uncased': 'bert_embeddings_agriculture_bert_uncased',
            'en.embed.albert': 'albert_base_uncased',
            'en.embed.albert.base_uncased': 'albert_base_uncased',
            'en.embed.albert.large_uncased': 'albert_large_uncased',
            'en.embed.albert.xlarge_uncased': 'albert_xlarge_uncased',
            'en.embed.albert.xxlarge_uncased': 'albert_xxlarge_uncased',
            'en.embed.albert_base_v1': 'albert_embeddings_albert_base_v1',
            'en.embed.albert_xlarge_v1': 'albert_embeddings_albert_xlarge_v1',
            'en.embed.albert_xxlarge_v1': 'albert_embeddings_albert_xxlarge_v1',
            'en.embed.bert': 'bert_base_uncased',
            'en.embed.bert.base': 'bert_embeddings_v_2021_base',
            'en.embed.bert.base_cased': 'bert_base_cased',
            'en.embed.bert.base_uncased': 'bert_base_uncased',
            'en.embed.bert.base_uncased_legal': 'bert_base_uncased_legal',
            'en.embed.bert.by_anferico': 'bert_embeddings_for_patents',
            'en.embed.bert.by_beatrice_portelli': 'bert_embeddings_dilbert',
            'en.embed.bert.by_law_ai': 'bert_embeddings_incaselawbert',
            'en.embed.bert.by_philschmid': 'bert_embeddings_fin_pretrain_yiyanghkust',
            'en.embed.bert.cased_base': 'bert_embeddings_jobbert_base_cased',
            'en.embed.bert.cased_base.by_ayansinha': 'bert_embeddings_lic_class_scancode_base_cased_l32_1',
            'en.embed.bert.cased_base.by_geotrend': 'bert_embeddings_base_en_cased',
            'en.embed.bert.cased_base.by_model_attribution_challenge': 'bert_embeddings_model_attribution_challenge_base_cased',
            'en.embed.bert.cased_base.by_uploaded by huggingface': 'bert_embeddings_base_cased',
            'en.embed.bert.cased_large': 'bert_embeddings_large_cased',
            'en.embed.bert.cased_large_whole_word_masking': 'bert_embeddings_large_cased_whole_word_masking',
            'en.embed.bert.contracts.large_small_finetuned_legal': 'bert_embeddings_bert_small_finetuned_legal_contracts_larger20_5_1',
            'en.embed.bert.contracts.large_small_finetuned_legal.by_muhtasham': 'bert_embeddings_bert_small_finetuned_legal_contracts_larger4010',
            'en.embed.bert.contracts.small_finetuned_legal': 'bert_embeddings_bert_small_finetuned_legal_contracts10train10val',
            'en.embed.bert.contracts.uncased_base': 'bert_base_uncased_contracts',
            'en.embed.bert.covid_bio_clinical.finetuned': 'bert_embeddings_bioclinicalbert_finetuned_covid_papers',
            'en.embed.bert.large': 'bert_embeddings_v_2021_large',
            'en.embed.bert.large_cased': 'bert_large_cased',
            'en.embed.bert.large_legal_7m': 'bert_embeddings_legalbert_large_1.7m_1',
            'en.embed.bert.large_legal_7m.by_pile_of_law': 'bert_embeddings_legalbert_large_1.7m_2',
            'en.embed.bert.large_uncased': 'bert_large_uncased',
            'en.embed.bert.legal': 'bert_embeddings_inlegalbert',
            'en.embed.bert.phs': 'bert_embeddings_phs_bert',
            'en.embed.bert.pubmed': 'bert_pubmed',
            'en.embed.bert.pubmed.uncased': 'bert_biomed_pubmed_uncased',
            'en.embed.bert.pubmed_squad2': 'bert_pubmed_squad2',
            'en.embed.bert.small_L10_128': 'small_bert_L10_128',
            'en.embed.bert.small_L10_256': 'small_bert_L10_256',
            'en.embed.bert.small_L10_512': 'small_bert_L10_512',
            'en.embed.bert.small_L10_768': 'small_bert_L10_768',
            'en.embed.bert.small_L12_128': 'small_bert_L12_128',
            'en.embed.bert.small_L12_256': 'small_bert_L12_256',
            'en.embed.bert.small_L12_512': 'small_bert_L12_512',
            'en.embed.bert.small_L12_768': 'small_bert_L12_768',
            'en.embed.bert.small_L2_128': 'small_bert_L2_128',
            'en.embed.bert.small_L2_256': 'small_bert_L2_256',
            'en.embed.bert.small_L2_512': 'small_bert_L2_512',
            'en.embed.bert.small_L2_768': 'small_bert_L2_768',
            'en.embed.bert.small_L4_128': 'small_bert_L4_128',
            'en.embed.bert.small_L4_256': 'small_bert_L4_256',
            'en.embed.bert.small_L4_512': 'small_bert_L4_512',
            'en.embed.bert.small_L4_768': 'small_bert_L4_768',
            'en.embed.bert.small_L6_128': 'small_bert_L6_128',
            'en.embed.bert.small_L6_256': 'small_bert_L6_256',
            'en.embed.bert.small_L6_512': 'small_bert_L6_512',
            'en.embed.bert.small_L6_768': 'small_bert_L6_768',
            'en.embed.bert.small_L8_128': 'small_bert_L8_128',
            'en.embed.bert.small_L8_256': 'small_bert_L8_256',
            'en.embed.bert.small_L8_512': 'small_bert_L8_512',
            'en.embed.bert.small_L8_768': 'small_bert_L8_768',
            'en.embed.bert.small_finetuned_legal': 'bert_embeddings_bert_small_finetuned_legal_definitions',
            'en.embed.bert.small_finetuned_legal.by_muhtasham': 'bert_embeddings_bert_small_finetuned_legal_definitions_longer',
            'en.embed.bert.tiny_finetuned_legal': 'bert_embeddings_bert_tiny_finetuned_legal_definitions',
            'en.embed.bert.uncased_base': 'bert_embeddings_base_uncased',
            'en.embed.bert.uncased_base.by_model_attribution_challenge': 'bert_embeddings_model_attribution_challenge_base_uncased',
            'en.embed.bert.uncased_base_finetuned_legal': 'bert_embeddings_legal_bert_base_uncased_finetuned_rramicus',
            'en.embed.bert.uncased_base_finetuned_legal.by_hatemestinbejaia': 'bert_embeddings_legal_bert_base_uncased_finetuned_ledgarscotus7',
            'en.embed.bert.uncased_large': 'bert_embeddings_large_uncased',
            'en.embed.bert.uncased_large_whole_word_masking': 'bert_embeddings_large_uncased_whole_word_masking',
            'en.embed.bert.wiki_books': 'bert_wiki_books',
            'en.embed.bert.wiki_books_mnli': 'bert_wiki_books_mnli',
            'en.embed.bert.wiki_books_qnli': 'bert_wiki_books_qnli',
            'en.embed.bert.wiki_books_qqp': 'bert_wiki_books_qqp',
            'en.embed.bert.wiki_books_squad2': 'bert_wiki_books_squad2',
            'en.embed.bert.wiki_books_sst2': 'bert_wiki_books_sst2',
            'en.embed.bert_base_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
            'en.embed.bert_base_en_cased': 'bert_embeddings_bert_base_en_cased',
            'en.embed.bert_base_uncased_dstc9': 'bert_embeddings_bert_base_uncased_dstc9',
            'en.embed.bert_base_uncased_mnli_sparse_70_unstructured_no_classifier': 'bert_embeddings_bert_base_uncased_mnli_sparse_70_unstructured_no_classifier',
            'en.embed.bert_base_uncased_sparse_70_unstructured': 'bert_embeddings_bert_base_uncased_sparse_70_unstructured',
            'en.embed.bert_for_patents': 'bert_embeddings_bert_for_patents',
            'en.embed.bert_large_cased_whole_word_masking': 'bert_embeddings_bert_large_cased_whole_word_masking',
            'en.embed.bert_large_uncased_whole_word_masking': 'bert_embeddings_bert_large_uncased_whole_word_masking',
            'en.embed.bert_political_election2020_twitter_mlm': 'bert_embeddings_bert_political_election2020_twitter_mlm',
            'en.embed.biobert': 'biobert_pubmed_base_cased',
            'en.embed.biobert.clinical_base_cased': 'biobert_clinical_base_cased',
            'en.embed.biobert.discharge_base_cased': 'biobert_discharge_base_cased',
            'en.embed.biobert.pmc_base_cased': 'biobert_pmc_base_cased',
            'en.embed.biobert.pubmed.cased_base': 'biobert_pubmed_base_cased_v1.2',
            'en.embed.biobert.pubmed_large_cased': 'biobert_pubmed_large_cased',
            'en.embed.biobert.pubmed_pmc_base_cased': 'biobert_pubmed_pmc_base_cased',
            'en.embed.bioformer.cased': 'bert_embeddings_bioformer_cased_v1.0',
            'en.embed.chEMBL26_smiles_v2': 'roberta_embeddings_chEMBL26_smiles_v2',
            'en.embed.chEMBL_smiles_v1': 'roberta_embeddings_chEMBL_smiles_v1',
            'en.embed.chemical_bert_uncased': 'bert_embeddings_chemical_bert_uncased',
            'en.embed.childes_bert': 'bert_embeddings_childes_bert',
            'en.embed.clinical_pubmed_bert_base_128': 'bert_embeddings_clinical_pubmed_bert_base_128',
            'en.embed.clinical_pubmed_bert_base_512': 'bert_embeddings_clinical_pubmed_bert_base_512',
            'en.embed.covidbert': 'covidbert_large_uncased',
            'en.embed.covidbert.large_uncased': 'covidbert_large_uncased',
            'en.embed.crosloengual_bert': 'bert_embeddings_crosloengual_bert',
            'en.embed.danbert_small_cased': 'bert_embeddings_danbert_small_cased',
            'en.embed.deberta_base_uncased': 'bert_embeddings_deberta_base_uncased',
            'en.embed.deberta_v3_base': 'deberta_v3_base',
            'en.embed.deberta_v3_large': 'deberta_v3_large',
            'en.embed.deberta_v3_small': 'deberta_v3_small',
            'en.embed.deberta_v3_xsmall': 'deberta_v3_xsmall',
            'en.embed.distil_bert': 'distilbert_embeddings_test_text',
            'en.embed.distil_bert.finetuned': 'distilbert_embeddings_finetuned_sarcasm_classification',
            'en.embed.distil_bert.uncased_base': 'distilbert_embeddings_base_uncased',
            'en.embed.distil_bert.uncased_base_sparse_85_unstructured_pruneofa.by_intel': 'distilbert_embeddings_base_uncased_sparse_85_unstructured_pruneofa',
            'en.embed.distil_bert.uncased_base_sparse_90_unstructured_pruneofa.by_intel': 'distilbert_embeddings_base_uncased_sparse_90_unstructured_pruneofa',
            'en.embed.distilbert': 'distilbert_base_cased',
            'en.embed.distilbert.base': 'distilbert_base_cased',
            'en.embed.distilbert.base.uncased': 'distilbert_base_uncased',
            'en.embed.distilbert_base_en_cased': 'distilbert_embeddings_distilbert_base_en_cased',
            'en.embed.distilbert_base_uncased_sparse_85_unstructured_pruneofa': 'distilbert_embeddings_distilbert_base_uncased_sparse_85_unstructured_pruneofa',
            'en.embed.distilbert_base_uncased_sparse_90_unstructured_pruneofa': 'distilbert_embeddings_distilbert_base_uncased_sparse_90_unstructured_pruneofa',
            'en.embed.distilroberta': 'distilroberta_base',
            'en.embed.distilroberta_base': 'roberta_embeddings_distilroberta_base',
            'en.embed.distilroberta_base_climate_d': 'roberta_embeddings_distilroberta_base_climate_d',
            'en.embed.distilroberta_base_climate_d_s': 'roberta_embeddings_distilroberta_base_climate_d_s',
            'en.embed.distilroberta_base_climate_f': 'roberta_embeddings_distilroberta_base_climate_f',
            'en.embed.distilroberta_base_finetuned_jira_qt_issue_title': 'roberta_embeddings_distilroberta_base_finetuned_jira_qt_issue_title',
            'en.embed.distilroberta_base_finetuned_jira_qt_issue_titles_and_bodies': 'roberta_embeddings_distilroberta_base_finetuned_jira_qt_issue_titles_and_bodies',
            'en.embed.e': 'bert_biolink_base',
            'en.embed.electra': 'electra_small_uncased',
            'en.embed.electra.base': 'electra_embeddings_electra_base_generator',
            'en.embed.electra.base_uncased': 'electra_base_uncased',
            'en.embed.electra.large': 'electra_embeddings_electra_large_generator',
            'en.embed.electra.large_uncased': 'electra_large_uncased',
            'en.embed.electra.medical': 'electra_medal_acronym',
            'en.embed.electra.small': 'electra_embeddings_electra_small_generator',
            'en.embed.electra.small_uncased': 'electra_small_uncased',
            'en.embed.elmo': 'elmo',
            'en.embed.fairlex_ecthr_minilm': 'roberta_embeddings_fairlex_ecthr_minilm',
            'en.embed.fairlex_scotus_minilm': 'roberta_embeddings_fairlex_scotus_minilm',
            'en.embed.false_positives_scancode_bert_base_uncased_L8_1': 'bert_embeddings_false_positives_scancode_bert_base_uncased_L8_1',
            'en.embed.finbert_pretrain_yiyanghkust': 'bert_embeddings_finbert_pretrain_yiyanghkust',
            'en.embed.finest_bert': 'bert_embeddings_finest_bert',
            'en.embed.ge': 'bert_biolink_large',
            'en.embed.glove': 'glove_100d',
            'en.embed.glove.100d': 'glove_100d',
            'en.embed.hateBERT': 'bert_embeddings_hateBERT',
            'en.embed.legal.osf_lemmatized_legal': 'word2vec_osf_lemmatized_legal',
            'en.embed.legal.osf_raw_legal': 'word2vec_osf_raw_legal',
            'en.embed.legal.osf_replaced_lemmatized_legal': 'word2vec_osf_replaced_lemmatized_legal',
            'en.embed.legal.osf_replaced_raw_legal': 'word2vec_osf_replaced_raw_legal',
            'en.embed.legal_bert_base_uncased': 'bert_embeddings_legal_bert_base_uncased',
            'en.embed.legal_bert_small_uncased': 'bert_embeddings_legal_bert_small_uncased',
            'en.embed.legal_roberta_base': 'roberta_embeddings_legal_roberta_base',
            'en.embed.legalbert.legal.by_zlucia': 'bert_embeddings_legalbert',
            'en.embed.legalbert.legal.custom.by_zlucia': 'bert_embeddings_custom_legalbert',
            'en.embed.lic_class_scancode_bert_base_cased_L32_1': 'bert_embeddings_lic_class_scancode_bert_base_cased_L32_1',
            'en.embed.longformer': 'longformer_base_4096',
            'en.embed.longformer.base_legal': 'legal_longformer_base',
            'en.embed.longformer.clinical': 'clinical_longformer',
            'en.embed.longformer.large': 'longformer_large_4096',
            'en.embed.muppet_roberta_base': 'roberta_embeddings_muppet_roberta_base',
            'en.embed.muppet_roberta_large': 'roberta_embeddings_muppet_roberta_large',
            'en.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
            'en.embed.netbert': 'bert_embeddings_netbert',
            'en.embed.pmc_med_bio_mlm_roberta_large': 'roberta_embeddings_pmc_med_bio_mlm_roberta_large',
            'en.embed.pos.uncased_base': 'bert_embeddings_false_positives_scancode_base_uncased_l8_1',
            'en.embed.psych_search': 'bert_embeddings_psych_search',
            'en.embed.roberta': 'roberta_base',
            'en.embed.roberta.base': 'roberta_base',
            'en.embed.roberta.base.by_model_attribution_challenge': 'roberta_embeddings_model_attribution_challenge_base',
            'en.embed.roberta.base_finetuned': 'roberta_embeddings_ruperta_base_finetuned_spa_constitution',
            'en.embed.roberta.base_legal': 'roberta_embeddings_legal_base',
            'en.embed.roberta.cord19.1m': 'roberta_embeddings_cord19_1m7k',
            'en.embed.roberta.distilled_base': 'roberta_embeddings_distil_base',
            'en.embed.roberta.financial': 'roberta_embeddings_financial',
            'en.embed.roberta.large': 'roberta_large',
            'en.embed.roberta_pubmed': 'roberta_embeddings_roberta_pubmed',
            'en.embed.scibert.cord19_scibert.finetuned': 'bert_embeddings_scibert_scivocab_finetuned_cord19',
            'en.embed.scibert.covid_scibert.': 'bert_embeddings_covid_scibert',
            'en.embed.sec_bert_base': 'bert_embeddings_sec_bert_base',
            'en.embed.sec_bert_num': 'bert_embeddings_sec_bert_num',
            'en.embed.sec_bert_sh': 'bert_embeddings_sec_bert_sh',
            'en.embed.w2v_cc_300d': 'w2v_cc_300d',
            'en.embed.word2vec.gigaword': 'word2vec_gigaword_300',
            'en.embed.word2vec.gigaword_wiki': 'word2vec_gigaword_wiki_300',
            'en.embed.xlmr_roberta': 'xlmroberta_embeddings_litlat_bert',
            'en.embed.xlnet': 'xlnet_base_cased',
            'en.embed.xlnet_base_cased': 'xlnet_base_cased',
            'en.embed.xlnet_large_cased': 'xlnet_large_cased',
            'en.embed_chunk': 'chunk_embeddings',
            'en.embed_sentence': 'tfhub_use',
            'en.embed_sentence.albert': 'albert_base_uncased',
            'en.embed_sentence.bert': 'sent_bert_base_uncased',
            'en.embed_sentence.bert.base_uncased_legal': 'sent_bert_base_uncased_legal',
            'en.embed_sentence.bert.finetuned': 'sbert_setfit_finetuned_financial_text_classification',
            'en.embed_sentence.bert.pubmed': 'sent_bert_pubmed',
            'en.embed_sentence.bert.pubmed_squad2': 'sent_bert_pubmed_squad2',
            'en.embed_sentence.bert.wiki_books': 'sent_bert_wiki_books',
            'en.embed_sentence.bert.wiki_books_mnli': 'sent_bert_wiki_books_mnli',
            'en.embed_sentence.bert.wiki_books_qnli': 'sent_bert_wiki_books_qnli',
            'en.embed_sentence.bert.wiki_books_qqp': 'sent_bert_wiki_books_qqp',
            'en.embed_sentence.bert.wiki_books_squad2': 'sent_bert_wiki_books_squad2',
            'en.embed_sentence.bert.wiki_books_sst2': 'sent_bert_wiki_books_sst2',
            'en.embed_sentence.bert_base_cased': 'sent_bert_base_cased',
            'en.embed_sentence.bert_base_uncased': 'sent_bert_base_uncased',
            'en.embed_sentence.bert_large_cased': 'sent_bert_large_cased',
            'en.embed_sentence.bert_large_uncased': 'sent_bert_large_uncased',
            'en.embed_sentence.bert_use_cmlm_en_base': 'sent_bert_use_cmlm_en_base',
            'en.embed_sentence.bert_use_cmlm_en_large': 'sent_bert_use_cmlm_en_large',
            'en.embed_sentence.biobert.clinical_base_cased': 'sent_biobert_clinical_base_cased',
            'en.embed_sentence.biobert.discharge_base_cased': 'sent_biobert_discharge_base_cased',
            'en.embed_sentence.biobert.pmc_base_cased': 'sent_biobert_pmc_base_cased',
            'en.embed_sentence.biobert.pubmed_base_cased': 'sent_biobert_pubmed_base_cased',
            'en.embed_sentence.biobert.pubmed_large_cased': 'sent_biobert_pubmed_large_cased',
            'en.embed_sentence.biobert.pubmed_pmc_base_cased': 'sent_biobert_pubmed_pmc_base_cased',
            'en.embed_sentence.covidbert.large_uncased': 'sent_covidbert_large_uncased',
            'en.embed_sentence.distil_roberta.distilled_base': 'sent_distilroberta_base',
            'en.embed_sentence.doc2vec': 'doc2vec_gigaword_300',
            'en.embed_sentence.doc2vec.gigaword_300': 'doc2vec_gigaword_300',
            'en.embed_sentence.doc2vec.gigaword_wiki_300': 'doc2vec_gigaword_wiki_300',
            'en.embed_sentence.electra': 'sent_electra_small_uncased',
            'en.embed_sentence.electra_base_uncased': 'sent_electra_base_uncased',
            'en.embed_sentence.electra_large_uncased': 'sent_electra_large_uncased',
            'en.embed_sentence.electra_small_uncased': 'sent_electra_small_uncased',
            'en.embed_sentence.roberta.base': 'sent_roberta_base',
            'en.embed_sentence.roberta.large': 'sent_roberta_large',
            'en.embed_sentence.small_bert_L10_128': 'sent_small_bert_L10_128',
            'en.embed_sentence.small_bert_L10_256': 'sent_small_bert_L10_256',
            'en.embed_sentence.small_bert_L10_512': 'sent_small_bert_L10_512',
            'en.embed_sentence.small_bert_L10_768': 'sent_small_bert_L10_768',
            'en.embed_sentence.small_bert_L12_128': 'sent_small_bert_L12_128',
            'en.embed_sentence.small_bert_L12_256': 'sent_small_bert_L12_256',
            'en.embed_sentence.small_bert_L12_512': 'sent_small_bert_L12_512',
            'en.embed_sentence.small_bert_L12_768': 'sent_small_bert_L12_768',
            'en.embed_sentence.small_bert_L2_128': 'sent_small_bert_L2_128',
            'en.embed_sentence.small_bert_L2_256': 'sent_small_bert_L2_256',
            'en.embed_sentence.small_bert_L2_512': 'sent_small_bert_L2_512',
            'en.embed_sentence.small_bert_L2_768': 'sent_small_bert_L2_768',
            'en.embed_sentence.small_bert_L4_128': 'sent_small_bert_L4_128',
            'en.embed_sentence.small_bert_L4_256': 'sent_small_bert_L4_256',
            'en.embed_sentence.small_bert_L4_512': 'sent_small_bert_L4_512',
            'en.embed_sentence.small_bert_L4_768': 'sent_small_bert_L4_768',
            'en.embed_sentence.small_bert_L6_128': 'sent_small_bert_L6_128',
            'en.embed_sentence.small_bert_L6_256': 'sent_small_bert_L6_256',
            'en.embed_sentence.small_bert_L6_512': 'sent_small_bert_L6_512',
            'en.embed_sentence.small_bert_L6_768': 'sent_small_bert_L6_768',
            'en.embed_sentence.small_bert_L8_128': 'sent_small_bert_L8_128',
            'en.embed_sentence.small_bert_L8_256': 'sent_small_bert_L8_256',
            'en.embed_sentence.small_bert_L8_512': 'sent_small_bert_L8_512',
            'en.embed_sentence.small_bert_L8_768': 'sent_small_bert_L8_768',
            'en.embed_sentence.tfhub_use': 'tfhub_use',
            'en.embed_sentence.tfhub_use.lg': 'tfhub_use_lg',
            'en.embed_sentence.use': 'tfhub_use',
            'en.embed_sentence.use.lg': 'tfhub_use_lg',
            'en.generate.gpt2.large': 'gpt_large',
            'en.glove': 'glove_100d',
            'en.gpt2': 'gpt2',
            'en.gpt2.distilled': 'gpt2_distilled',
            'en.gpt2.large': 'gpt_large',
            'en.gpt2.medium': 'gpt2_medium',
            'en.lemma': 'lemma_lines',
            'en.lemma.antbnc': 'lemma_antbnc',
            'en.lemma.atis': 'lemma_atis',
            'en.lemma.esl': 'lemma_esl',
            'en.lemma.ewt': 'lemma_ewt',
            'en.lemma.gum': 'lemma_gum',
            'en.lemma.lines': 'lemma_lines',
            'en.lemma.partut': 'lemma_partut',
            'en.lemma.spacylookup': 'lemma_spacylookup',
            'en.ner.airline': 'nerdl_atis_840b_300d',
            'en.ner.aspect.airline': 'nerdl_atis_840b_300d',
            'en.ner.aspect.atis': 'nerdl_atis_840b_300d',
            'en.ner.atis': 'nerdl_atis_840b_300d',
            'en.ner.bert.accelerate.by_alexander_learn': 'bert_ner_alexander_learn_bert_finetuned_ner_accelerate',
            'en.ner.bert.accelerate.by_artemis13fowl': 'bert_ner_artemis13fowl_bert_finetuned_ner_accelerate',
            'en.ner.bert.accelerate.by_peterhsu': 'bert_ner_peterhsu_bert_finetuned_ner_accelerate',
            'en.ner.bert.adr.by_ytsai25': 'bert_ner_ytsai25_bert_finetuned_ner_adr',
            'en.ner.bert.airi..by_airi': 'bert_ner_airi_bert_finetuned_ner',
            'en.ner.bert.ard.by_cwan6830': 'bert_ner_cwan6830_bert_finetuned_ard',
            'en.ner.bert.artemis13fowl.by_artemis13fowl': 'bert_ner_artemis13fowl_bert_finetuned_ner',
            'en.ner.bert.base': 'bert_ner_far50brbert_base',
            'en.ner.bert.base.by_adwayk': 'bert_ner_base_bert_tuned_on_tac2017_as_ner',
            'en.ner.bert.base.by_biasedai': 'bert_ner_bert_based_ner',
            'en.ner.bert.base.by_brad1141': 'bert_ner_baseline_bertv3',
            'en.ner.bert.base.by_leonweber': 'bert_ner_bunsen_base_best',
            'en.ner.bert.base.by_nbailab': 'bert_ner_nb_bert_base_ner',
            'en.ner.bert.base.by_rexhaif': 'bert_ner_rubert_base_srl_seqlabeling',
            'en.ner.bert.base.by_wanjiru': 'bert_ner_ag_based_ner',
            'en.ner.bert.base.tcm_0.5.by_ricardo_filho': 'bert_ner_bert_base_tcm_0.5',
            'en.ner.bert.base.tcm_0.6.by_ricardo_filho': 'bert_ner_bert_base_tcm_0.6',
            'en.ner.bert.base.tcm_0.7.by_ricardo_filho': 'bert_ner_bert_base_tcm_0.7',
            'en.ner.bert.base.tcm_0.8.by_ricardo_filho': 'bert_ner_bert_base_tcm_0.8',
            'en.ner.bert.base.tcm_no_objeto_0.8.by_ricardo_filho': 'bert_ner_bert_base_tcm_no_objeto_0.8',
            'en.ner.bert.base.tcm_teste.by_ricardo_filho': 'bert_ner_bert_base_tcm_teste',
            'en.ner.bert.base_finetuned': 'bert_ner_bert_base_ner_finetuned_ner_isu',
            'en.ner.bert.base_finetuned.by_deval': 'bert_ner_deval_bert_base_ner_finetuned_ner',
            'en.ner.bert.base_finetuned.by_mcdzwil': 'bert_ner_mcdzwil_bert_base_ner_finetuned_ner',
            'en.ner.bert.bc5cdr_bluebert.original_disease': 'bert_ner_original_bluebert_bc5cdr_disease',
            'en.ner.bert.bc5cdr_ncbi.disease': 'bert_token_classifier_ncbi_bc5cdr_disease',
            'en.ner.bert.bgc_accession.by_maaly': 'bert_ner_bgc_accession',
            'en.ner.bert.bio_medical.base': 'bert_ner_mbert_base_biomedical_ner',
            'en.ner.bert.biomuppet.by_leonweber': 'bert_ner_biomuppet',
            'en.ner.bert.bluebert.': 'bert_ner_wlt_bluebert_linnaeus',
            'en.ner.bert.bluebert.512d_modified': 'bert_ner_bionlp13_modified_bluebert_512',
            'en.ner.bert.bluebert.original': 'bert_ner_original_bluebert_linnaeus',
            'en.ner.bert.bluebert_bc2gm.original': 'bert_ner_original_bluebert_bc2gm',
            'en.ner.bert.bluebert_ncbi.': 'bert_ner_orignial_bluebert_ncbi',
            'en.ner.bert.bluebert_ncbi.by_ghadeermobasher': 'bert_ner_wlt_bluebert_ncbi',
            'en.ner.bert.body_site.by_maaly': 'bert_ner_body_site',
            'en.ner.bert.by_abnv15': 'bert_ner_mlma',
            'en.ner.bert.by_adamlin': 'bert_ner_adamlin_recipe_tag_model',
            'en.ner.bert.by_aleksandar': 'bert_ner_bert_srb_ner_setimes',
            'en.ner.bert.by_alexbrandsen': 'bert_ner_archeobertje_ner',
            'en.ner.bert.by_alichte': 'bert_ner_tg_relation_model',
            'en.ner.bert.by_andrija': 'bert_ner_m_bert_ner',
            'en.ner.bert.by_avialfont': 'bert_ner_ner_dummy_model',
            'en.ner.bert.by_bigscience_biomedical': 'bert_ner_bigbio_mtl',
            'en.ner.bert.by_blckwdw61': 'bert_ner_sysformbatches2acs',
            'en.ner.bert.by_browndw': 'bert_ner_docusco_bert',
            'en.ner.bert.by_ckauth': 'bert_ner_ck_ner_subgroup',
            'en.ner.bert.by_clairev': 'bert_ner_mlma_lab8',
            'en.ner.bert.by_connorboyle': 'bert_ner_bert_ner_i2b2',
            'en.ner.bert.by_danielmantisnlp': 'bert_ner_autotrain_oms_ner_bi_1044135953',
            'en.ner.bert.by_deeq': 'bert_ner_dbert_ner',
            'en.ner.bert.by_ehsanyb': 'bert_ner_bert_ehsan_ner_accelerate',
            'en.ner.bert.by_fagner': 'bert_ner_envoy',
            'en.ner.bert.by_fgravelaine': 'bert_ner_ner_test',
            'en.ner.bert.by_gauravnuti': 'bert_ner_agro_ner',
            'en.ner.bert.by_icelab': 'bert_ner_spacebert_cr',
            'en.ner.bert.by_justadvancetechonology': 'bert_ner_bert_fine_tuned_medical_insurance_ner',
            'en.ner.bert.by_kevinjesse': 'bert_ner_bert_mt4ts',
            'en.ner.bert.by_kleinay': 'bert_ner_nominalization_candidate_classifier',
            'en.ner.bert.by_kunalr63': 'bert_ner_simple_transformer',
            'en.ner.bert.by_lauler': 'bert_ner_deformer',
            'en.ner.bert.by_leemeng': 'bert_ner_core_term_ner_v1',
            'en.ner.bert.by_lewtun': 'bert_ner_autotrain_acronym_identification_7324788',
            'en.ner.bert.by_media1129': 'bert_ner_keyword_tag_model',
            'en.ner.bert.by_mirikwa': 'bert_ner_gro_ner_2',
            'en.ner.bert.by_myorg123': 'bert_ner_tinparadox_job_search',
            'en.ner.bert.by_ncats': 'bert_ner_epiextract4gard_v1',
            'en.ner.bert.by_nguyenkhoa2407': 'bert_token_classifier_autotrain_ner_favsbot',
            'en.ner.bert.by_nila_yuki': 'bert_ner_final_lab',
            'en.ner.bert.by_noahjadallah': 'bert_ner_cause_effect_detection',
            'en.ner.bert.by_obi': 'bert_ner_deid_bert_i2b2',
            'en.ner.bert.by_pucpr': 'bert_ner_ehelpbertpt',
            'en.ner.bert.by_rdchambers': 'bert_ner_bert_finetuned_filler_2',
            'en.ner.bert.by_rj3vans': 'bert_ner_ssmnspantagger',
            'en.ner.bert.by_rohanvb': 'bert_ner_umlsbert_ner',
            'en.ner.bert.by_rostlab': 'bert_ner_prot_bert_bfd_ss3',
            'en.ner.bert.by_satyaalmasian': 'bert_ner_temporal_tagger_bert_tokenclassifier',
            'en.ner.bert.by_schnell': 'bert_ner_wakaformer',
            'en.ner.bert.by_shenzy2': 'bert_token_classifier_autotrain_tk_1181244086',
            'en.ner.bert.by_skolkovoinstitute': 'bert_token_classifier_lewip_informal_tagger',
            'en.ner.bert.by_superman': 'bert_ner_testingmodel',
            'en.ner.bert.by_tartunlp': 'bert_ner_estbert_ner',
            'en.ner.bert.by_varsha12': 'bert_ner_bert_dnrti',
            'en.ner.bert.by_vera_pro': 'bert_ner_bert_mention_en_vera_pro',
            'en.ner.bert.by_wanjiru': 'bert_token_classifier_autotrain_gro_ner',
            'en.ner.bert.by_wzkariampuzha': 'bert_ner_epiextract4gard',
            'en.ner.bert.by_yanekyuk': 'bert_ner_bert_keyword_extractor',
            'en.ner.bert.by_yihahn': 'bert_ner_ner_2006',
            'en.ner.bert.by_ytsai25': 'bert_ner_ytsai25_bert_finetuned_ner',
            'en.ner.bert.by_zhuzhusleepearly': 'bert_ner_bert_finetuned',
            'en.ner.bert.cased': 'bert_ner_bert_ner_cased_sonar1_nld',
            'en.ner.bert.cased.by_yanekyuk': 'bert_token_classifier_cased_keyword_discriminator',
            'en.ner.bert.cased_base': 'bert_ner_bert_base_cased_chunking',
            'en.ner.bert.cased_base.by_qcri': 'bert_ner_bert_base_cased_sem',
            'en.ner.bert.cased_base_original': 'bert_ner_hiner_original_muril_base_cased',
            'en.ner.bert.cased_large_finetuned': 'bert_ner_bert_large_cased_finetuned_ner',
            'en.ner.bert.cased_multilingual_base': 'bert_ner_bert_base_multilingual_cased_sem_english',
            'en.ner.bert.cased_multilingual_base_finetuned': 'bert_ner_bert_base_multilingual_cased_finetuned_sonar_ner',
            'en.ner.bert.cased_multilingual_base_finetuned.by_wietsedv': 'bert_ner_bert_base_multilingual_cased_finetuned_udlassy_ner',
            'en.ner.bert.chemical_bc5cdr_bluebert.512d_modified': 'bert_ner_bc5cdr_chem_modified_bluebert_512',
            'en.ner.bert.chemical_bc5cdr_bluebert.512d_original': 'bert_ner_bc5cdr_chem_original_bluebert_512',
            'en.ner.bert.chemical_bc5cdr_bluebert.original': 'bert_ner_bc5cdr_chem_original_bluebert_384',
            'en.ner.bert.chemical_bc5cdr_bluebert.original.by_ghadeermobasher': 'bert_ner_original_bluebert_bc5cdr_chemical',
            'en.ner.bert.chemical_biored_bluebert.512d_modified': 'bert_ner_modified_bluebert_biored_chem_512_5_30',
            'en.ner.bert.chemical_biored_bluebert.512d_original': 'bert_ner_original_bluebert_biored_chem_512_5_30',
            'en.ner.bert.chemical_biored_bluebert.original': 'bert_ner_original_bluebert_biored_chem',
            'en.ner.bert.chemical_bluebert.512d_modified': 'bert_ner_bc4chemd_chem_modified_bluebert_512',
            'en.ner.bert.chemical_bluebert.512d_original': 'bert_ner_bc4chemd_chem_original_bluebert_512',
            'en.ner.bert.chemical_bluebert.modified': 'bert_ner_bc4chemd_chem_modified_bluebert_384',
            'en.ner.bert.chemical_bluebert.original': 'bert_ner_bc4chemd_chem_original_bluebert_384',
            'en.ner.bert.chemical_bluebert.original.by_ghadeermobasher': 'bert_ner_original_bluebert_bc4chemd',
            'en.ner.bert.chemical_bluebert_bionlp13cg.512d_original': 'bert_ner_bionlp13cg_chem_chem_original_bluebert_512',
            'en.ner.bert.chemical_bluebert_bionlp13cg.original': 'bert_ner_bionlp13cg_chem_chem_original_bluebert_384',
            'en.ner.bert.chemical_pubmed_bc5cdr.modified': 'bert_ner_bc5cdr_chem_modified_pubmed_abstract_3',
            'en.ner.bert.chemical_pubmed_bc5cdr_bluebert.uncased_12l_768d_a12a_768d_imbalanced': 'bert_ner_bc5cdr_chemical_imbalanced_bluebert_pubmed_uncased_l_12_h_768_a_12_latest',
            'en.ner.bert.chemical_pubmed_bc5cdr_bluebert.uncased_12l_768d_a12a_768d_modified': 'bert_ner_bc5cdr_chem_modified_bluebert_pubmed_uncased_l_12_h_768_a_12_latest',
            'en.ner.bert.chemical_pubmed_bc5cdr_full.modified.by_ghadeermobasher': 'bert_ner_bc5cdr_chem_modified_pubmed_full_3',
            'en.ner.bert.chemical_pubmed_bc5cdr_latest.modified.by_ghadeermobasher': 'bert_ner_bc5cdr_chem_modified_pubmed_abstract_latest',
            'en.ner.bert.chemical_pubmed_bionlp13cg.modified': 'bert_ner_bionlp13cg_chem_modified_pubmedabstract_latest',
            'en.ner.bert.chemical_pubmed_craft_bluebert.uncased_12l_768d_a12a_768d_modified': 'bert_ner_craft_chem_modified_bluebert_pubmed_uncased_l_12_h_768_a_12',
            'en.ner.bert.chemical_pubmed_craft_bluebert.uncased_12l_768d_a12a_768d_original': 'bert_ner_craft_chem_original_bluebert_pubmed_uncased_l_12_h_768_a_12',
            'en.ner.bert.clinical.cased': 'bert_ner_nlp_cic_wfu_clinical_cases_ner_paragraph_tokenized_mbert_cased_fine_tuned',
            'en.ner.bert.clinical.cased.by_ajtamayoh': 'bert_ner_nlp_cic_wfu_clinical_cases_ner_mbert_cased_fine_tuned',
            'en.ner.bert.clinical.cased_sents_tokenized.by_ajtamayoh': 'bert_ner_nlp_cic_wfu_clinical_cases_ner_sents_tokenized_mbert_cased_fine_tuned',
            'en.ner.bert.clinical.uncased_base': 'bert_ner_bert_base_uncased_clinical_ner',
            'en.ner.bert.clinical_chemical_pubmed.modified': 'bert_ner_bc4chemd_modified_pubmed_clinical',
            'en.ner.bert.co_imb.by_ghadeermobasher': 'bert_ner_model_co_imb',
            'en.ner.bert.codeswitch_nepeng_lid_lince.by_sagorsarker': 'bert_ner_codeswitch_nepeng_lid_lince',
            'en.ner.bert.codeswitch_spaeng_lid_lince.by_sagorsarker': 'bert_ner_codeswitch_spaeng_lid_lince',
            'en.ner.bert.codeswitch_spaeng_ner_lince.by_sagorsarker': 'bert_ner_codeswitch_spaeng_ner_lince',
            'en.ner.bert.col_mod.by_ghadeermobasher': 'bert_ner_model_col_mod',
            'en.ner.bert.conll.': 'bert_ner_ner_conll2003',
            'en.ner.bert.conll.base': 'bert_ner_bert_base_ner',
            'en.ner.bert.conll.by_ramybaly': 'bert_ner_ner_conll2003',
            'en.ner.bert.conll.cased': 'bert_ner_bert_ner_cased_conll2002_nld',
            'en.ner.bert.conll.cased_base': 'bert_ner_kamalkraj_bert_base_cased_ner_conll2003',
            'en.ner.bert.conll.cased_base.by_StivenLancheros': 'bert_ner_mbert_base_cased_ner_conll',
            'en.ner.bert.conll.cased_large_finetuned': 'bert_ner_dbmdz_bert_large_cased_finetuned_conll03_english',
            'en.ner.bert.conll.cased_large_finetuned.by_imvladikon': 'bert_ner_imvladikon_bert_large_cased_finetuned_conll03_english',
            'en.ner.bert.conll.cased_large_tiny_finetuned': 'bert_ner_tiny_dbmdz_bert_large_cased_finetuned_conll03_english',
            'en.ner.bert.conll.cased_multilingual_base_finetuned': 'bert_ner_bert_base_multilingual_cased_finetuned_conll2002_ner',
            'en.ner.bert.conll.distilled': 'bert_ner_importsmart_bert_to_distilbert_ner',
            'en.ner.bert.conll.distilled.by_kushaljoseph': 'bert_ner_kushaljoseph_bert_to_distilbert_ner',
            'en.ner.bert.conll.finetuned': 'bert_ner_ajgp_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_AlexanderPeter': 'bert_ner_alexanderpeter_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Aneela': 'bert_ner_aneela_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Buntan': 'bert_ner_buntan_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_DaveMSE': 'bert_ner_davemse_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Emmanuel': 'bert_ner_emmanuel_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Ghost1': 'bert_ner_bert_finetuned_ner3',
            'en.ner.bert.conll.finetuned.by_JoanTirant': 'bert_ner_joantirant_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Laure996': 'bert_ner_laure996_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Mascariddu8': 'bert_ner_mascariddu8_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Neulvo': 'bert_ner_neulvo_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Nonzerophilip': 'bert_ner_nonzerophilip_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_RayMelius': 'bert_ner_raymelius_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_SebastianS': 'bert_ner_sebastians_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Wende': 'bert_ner_wende_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_Yv': 'bert_ner_yv_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_aditya22': 'bert_ner_aditya22_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_alwaysgetbetter': 'bert_ner_alwaysgetbetter_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_amir36': 'bert_ner_amir36_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_animalthemuppet': 'bert_ner_animalthemuppet_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_awilli': 'bert_ner_awilli_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_batya66': 'bert_ner_batya66_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_brjezierski': 'bert_ner_brjezierski_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_buehlpa': 'bert_ner_buehlpa_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_butchland': 'bert_ner_butchland_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_chandrasutrisnotjhong': 'bert_ner_chandrasutrisnotjhong_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_dani_91': 'bert_ner_dani_91_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_datauma': 'bert_ner_datauma_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_dpuccine': 'bert_ner_dpuccine_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_dsghrg': 'bert_ner_dsghrg_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_dshvadskiy': 'bert_ner_dshvadskiy_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_fancyerii': 'bert_ner_fancyerii_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_huggingface_course': 'bert_ner_huggingface_course_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_jatinshah': 'bert_ner_jatinshah_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_jdang': 'bert_ner_jdang_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_kurama': 'bert_ner_kurama_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_kurianbenoy': 'bert_ner_kurianbenoy_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_leander': 'bert_ner_leander_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_lewtun': 'bert_ner_lewtun_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_mateocolina': 'bert_ner_mateocolina_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_mbateman': 'bert_ner_mbateman_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_mdroth': 'bert_ner_mdroth_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_michojan': 'bert_ner_michojan_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_mldev': 'bert_ner_mldev_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_ncduy': 'bert_ner_ncduy_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_peterhsu': 'bert_ner_peterhsu_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_phijve': 'bert_ner_phijve_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_romainlhardy': 'bert_ner_romainlhardy_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_russellc': 'bert_ner_russellc_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_sagerpascal': 'bert_ner_sagerpascal_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_siegelou': 'bert_ner_siegelou_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_spasis': 'bert_ner_spasis_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_stefan_jo': 'bert_ner_stefan_jo_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_suonbo': 'bert_ner_suonbo_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_tolgahanturker': 'bert_ner_tolgahanturker_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_vikasaeta': 'bert_ner_vikasaeta_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_xkang': 'bert_ner_xkang_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_yannis95': 'bert_ner_yannis95_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned.by_ysharma': 'bert_ner_ysharma_bert_finetuned_ner',
            'en.ner.bert.conll.finetuned_ubb_conll.by_BeardedJohn': 'bert_ner_bert_finetuned_ner_ubb_conll',
            'en.ner.bert.conll.finetuned_ubb_conll_endava_only_misc.by_BeardedJohn': 'bert_ner_bert_finetuned_ner_ubb_conll_endava_only_misc',
            'en.ner.bert.conll.finetuned_ubb_endava_conll.by_BeardedJohn': 'bert_ner_bert_finetuned_ner_ubb_endava_conll',
            'en.ner.bert.conll.finetuned_v2.by_Wende': 'bert_ner_bert_finetuned_ner1',
            'en.ner.bert.conll.large': 'bert_ner_bert_large_ner',
            'en.ner.bert.conll.large.by_51la5': 'bert_token_classifier_large_ner',
            'en.ner.bert.conll.uncased_large_finetuned': 'bert_ner_bert_large_uncased_finetuned_ner',
            'en.ner.bert.conll.v2': 'bert_ner_conll12v2',
            'en.ner.bert.conll.v2.by_Xiaoman': 'bert_ner_ner_conll2003_v2',
            'en.ner.bert.conll.v3.by_xiaoman': 'bert_ner_ner_conll2003_v3',
            'en.ner.bert.conll.v4.by_xiaoman': 'bert_ner_ner_conll2003_v4',
            'en.ner.bert.craft_bluebert.512d_modified': 'bert_ner_craft_modified_bluebert_512',
            'en.ner.bert.craft_bluebert.512d_original': 'bert_ner_craft_original_bluebert_512',
            'en.ner.bert.craft_bluebert.modified': 'bert_ner_craft_modified_bluebert_384',
            'en.ner.bert.craft_bluebert.original': 'bert_ner_craft_original_bluebert_384',
            'en.ner.bert.custom.by_jiaxin97': 'bert_ner_bert_finetuned_ner_custom',
            'en.ner.bert.defector.by_lucifermorninstar011': 'bert_ner_autotrain_defector_ner_multi_847927015',
            'en.ner.bert.degree_major_ner_1000.by_pkushiqiang': 'bert_ner_bert_degree_major_ner_1000',
            'en.ner.bert.designtutor.by_shenzy2': 'bert_token_classifier_ner4designtutor',
            'en.ner.bert.disease': 'bert_ner_ck_ner_disease',
            'en.ner.bert.distilled': 'bert_ner_distilbert_jur',
            'en.ner.bert.distilled.by_kaushalkhator': 'bert_ner_kaushalkhator_bert_to_distilbert_ner',
            'en.ner.bert.distilled_cased_base_tiny': 'bert_ner_tiny_distilbert_base_cased',
            'en.ner.bert.distilled_finetuned': 'bert_ner_distilbert_finetuned_ner',
            'en.ner.bert.final_784824206.by_lucifermorningstar011': 'bert_token_classifier_autotrain_final_784824206',
            'en.ner.bert.final_784824213.by_lucifermorningstar011': 'bert_token_classifier_autotrain_final_784824213',
            'en.ner.bert.finetuned': 'bert_ner_alekseykorshuk_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_aalogan': 'bert_ner_aalogan_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_anarise1': 'bert_ner_anarise1_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_anery': 'bert_ner_anery_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_balamurugan1603': 'bert_ner_balamurugan1603_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_binay1999': 'bert_ner_binay1999_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_brad1141': 'bert_ner_bert_finetuned_comp2',
            'en.ner.bert.finetuned.by_canlinzhang': 'bert_ner_canlinzhang_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_caotianyu1996': 'bert_ner_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_carblacac': 'bert_ner_carblacac_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_chanifrusydi': 'bert_ner_chanifrusydi_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_dheerajdhanvee': 'bert_ner_dheerajdhanvee_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_dizex': 'bert_ner_dizex_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_dshvadskiy': 'bert_ner_dshvadskiy_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_eduardopds': 'bert_ner_eduardopds_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_evanz37': 'bert_ner_evanz37_bert_finetuned_ard',
            'en.ner.bert.finetuned.by_ghost1': 'bert_ner_ghost1_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_hilmluo': 'bert_ner_hilmluo_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_hsattar': 'bert_ner_hsattar_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_huggingface_course': 'bert_ner_huggingface_course_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_jameswrbrookes': 'bert_ner_jameswrbrookes_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_jimmywu': 'bert_ner_jimmywu_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_jjglilleberg': 'bert_ner_jjglilleberg_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_joantirant': 'bert_ner_joantirant_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_jplago': 'bert_ner_jplago_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_jrubin01': 'bert_ner_jrubin01_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_juancopi81': 'bert_ner_juancopi81_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_kakkidaisuki': 'bert_ner_kakkidaisuki_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_kalex': 'bert_ner_kalex_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_kevinform': 'bert_ner_kevinform_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_khan27': 'bert_ner_khan27_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_krimo11': 'bert_ner_krimo11_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_ksaluja': 'bert_ner_ksaluja_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_liyingz': 'bert_ner_liyingz_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_lordli': 'bert_ner_lordli_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_ludoviciarraga': 'bert_ner_ludoviciarraga_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_mascariddu8': 'bert_ner_mascariddu8_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_mattchurgin': 'bert_ner_mattchurgin_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_mbateman': 'bert_ner_mbateman_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_mdroth': 'bert_ner_mdroth_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_mordred501': 'bert_ner_mordred501_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_neulvo': 'bert_ner_neulvo_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_nicholasdino': 'bert_ner_nicholasdino_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_nielsr': 'bert_ner_nielsr_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_nilavoboral': 'bert_ner_nilavo_bert_finetuned',
            'en.ner.bert.finetuned.by_rocketknight1': 'bert_ner_test_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_russellc': 'bert_ner_russellc_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_satwiksstp': 'bert_ner_satwiksstp_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_sgrannemann': 'bert_ner_sgrannemann_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_shaopeng': 'bert_ner_shaopeng_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_silviacamplani': 'bert_ner_silviacamplani_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_spasis': 'bert_ner_spasis_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_ssavla2': 'bert_ner_ssavla2_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_syedyusufali': 'bert_ner_syedyusufali_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_t_202': 'bert_ner_t_202_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_tushar_rishav': 'bert_ner_tushar_rishav_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_vanmas': 'bert_ner_vanmas_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_vdsouza1': 'bert_ner_vdsouza1_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_wende': 'bert_ner_wende_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_winson': 'bert_ner_winson_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_xesaad': 'bert_ner_xesaad_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_xkang': 'bert_ner_xkang_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned.by_xzt': 'bert_ner_xzt_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_yfu2307': 'bert_ner_yfu2307_bert_finetuned_ner',
            'en.ner.bert.finetuned.by_yv': 'bert_ner_yv_bert_finetuned_ner_accelerate',
            'en.ner.bert.finetuned_0h': 'bert_ner_jo0hnd0e_bert_finetuned_ner',
            'en.ner.bert.finetuned_adverse_drug_event': 'bert_ner_bert_finetuned_ades_model_1',
            'en.ner.bert.foo.by_leonweber': 'bert_ner_foo',
            'en.ner.bert.host.by_maaly': 'bert_ner_host',
            'en.ner.bert.imb.by_ghadeermobasher': 'bert_ner_model_imb',
            'en.ner.bert.imb_1.by_ghadeermobasher': 'bert_ner_model_imb_1',
            'en.ner.bert.imb_2.by_ghadeermobasher': 'bert_ner_model_imb_2',
            'en.ner.bert.ingredient.': 'bert_ner_keyword_tag_model_10000_9_16_more_ingredient',
            'en.ner.bert.ingredient.2000_9_16.by_media1129': 'bert_ner_keyword_tag_model_2000_9_16_more_ingredient',
            'en.ner.bert.ingredient.4000_9_16.by_media1129': 'bert_ner_keyword_tag_model_4000_9_16_more_ingredient',
            'en.ner.bert.ingredient.6000_9_16.by_media1129': 'bert_ner_keyword_tag_model_6000_9_16_more_ingredient',
            'en.ner.bert.ingredient.8000_9_16.by_media1129': 'bert_ner_keyword_tag_model_8000_9_16_more_ingredient',
            'en.ner.bert.ingredient.by_test123': 'bert_token_classifier_autonlp_ingredient_pseudo_label_training_ner_29576765',
            'en.ner.bert.job_title.by_lucifermorninstar011': 'bert_ner_autotrain_lucifer_job_title_comb_858027260',
            'en.ner.bert.keyword_tag_model_2000.by_media1129': 'bert_ner_keyword_tag_model_2000',
            'en.ner.bert.keyword_tag_model_2000_9_16.by_media1129': 'bert_ner_keyword_tag_model_2000_9_16',
            'en.ner.bert.keyword_tag_model_4000.by_media1129': 'bert_ner_keyword_tag_model_4000',
            'en.ner.bert.keyword_tag_model_6000.by_media1129': 'bert_ner_keyword_tag_model_6000',
            'en.ner.bert.lab9_1.by_annaeze': 'bert_ner_lab9_1',
            'en.ner.bert.lab9_2.by_annaeze': 'bert_ner_lab9_2',
            'en.ner.bert.learn.by_alexander_learn': 'bert_ner_alexander_learn_bert_finetuned_ner',
            'en.ner.bert.legal': 'bert_ner_legalbert_beneficiary_single',
            'en.ner.bert.legal.by_anery': 'bert_ner_legalbert_clause_combined',
            'en.ner.bert.lmr_hd_tb.by_rsuwaileh': 'bert_ner_idrisi_lmr_hd_tb',
            'en.ner.bert.lmr_hd_tb_partition.by_rsuwaileh': 'bert_ner_idrisi_lmr_hd_tb_partition',
            'en.ner.bert.lmr_hd_tl.by_rsuwaileh': 'bert_ner_idrisi_lmr_hd_tl',
            'en.ner.bert.lmr_hd_tl_partition.by_rsuwaileh': 'bert_ner_idrisi_lmr_hd_tl_partition',
            'en.ner.bert.male_female.': 'bert_ner_ner_for_female_names',
            'en.ner.bert.mutation_recognition_0.by_salvatore': 'bert_ner_bert_finetuned_mutation_recognition_0',
            'en.ner.bert.mutation_recognition_1.by_salvatore': 'bert_ner_bert_finetuned_mutation_recognition_1',
            'en.ner.bert.mutation_recognition_2.by_salvatore': 'bert_ner_bert_finetuned_mutation_recognition_2',
            'en.ner.bert.mutation_recognition_3.by_salvatore': 'bert_ner_bert_finetuned_mutation_recognition_3',
            'en.ner.bert.mutation_recognition_4.by_salvatore': 'bert_ner_bert_finetuned_mutation_recognition_4',
            'en.ner.bert.name.by_lucifermorninstar011': 'bert_ner_autotrain_lucifer_name_894029080',
            'en.ner.bert.ner.by_cwan6830': 'bert_ner_cwan6830_bert_finetuned_ner',
            'en.ner.bert.ner.by_jiaxin97': 'bert_ner_jiaxin97_bert_finetuned_ner_adr',
            'en.ner.bert.ner.by_lideming7757': 'bert_ner_lideming7757_bert_finetuned_ner',
            'en.ner.bert.ner.by_peterhsu': 'bert_ner_tf_bert_finetuned_ner',
            'en.ner.bert.nerd.by_ramybaly': 'bert_ner_ner_nerd',
            'en.ner.bert.nerd_fine.by_ramybaly': 'bert_ner_ner_nerd_fine',
            'en.ner.bert.org.by_ghadeermobasher': 'bert_ner_model_org',
            'en.ner.bert.org_1.by_ghadeermobasher': 'bert_ner_model_org_1',
            'en.ner.bert.org_2.by_ghadeermobasher': 'bert_ner_model_org_2',
            'en.ner.bert.per_loc_org.by_tesemnikov_av': 'bert_ner_ner_rubert_per_loc_org',
            'en.ner.bert.peyma.base': 'bert_ner_peyma_ner_bert_base',
            'en.ner.bert.prodigy': 'bert_ner_autonlp_prodigy_10_3362554',
            'en.ner.bert.protagonist.by_airi': 'bert_ner_bert_finetuned_protagonist',
            'en.ner.bert.pubmed_bc5cdr_bluebert.uncased_12l_768d_a12a_768d_disease_imbalanced': 'bert_ner_bc5cdr_disease_imbalanced_bluebert_pubmed_uncased_l_12_h_768_a_12_latest',
            'en.ner.bert.pubmed_bc5cdr_bluebert.uncased_12l_768d_a12a_768d_modified_disease': 'bert_ner_bc5cdr_disease_modified_bluebert_pubmed_uncased_l_12_h_768_a_12_latest',
            'en.ner.bert.pubmed_bionlp13cg.modified': 'bert_ner_bionlp13cg_modified_pubmedabstract_latest',
            'en.ner.bert.pubmed_bluebert.uncased_12l_768d_a12a_768d_modified': 'bert_ner_bc4_modified_bluebert_pubmed_uncased_l_12_h_768_a_12',
            'en.ner.bert.pubmed_bluebert.uncased_12l_768d_a12a_768d_original': 'bert_ner_bc4_original_bluebert_pubmed_uncased_l_12_h_768_a_12',
            'en.ner.bert.pubmed_bluebert_bionlp13cg.uncased_12l_768d_a12a_768d_modified': 'bert_ner_bionlp13cg_modified_bluebert_pubmed_uncased_l_12_h_768_a_12_latest',
            'en.ner.bert.pubmed_bluebert_bionlp13cg.uncased_12l_768d_a12a_768d_original': 'bert_ner_bionlp13cg_original_bluebert_pubmed_uncased_l_12_h_768_a_12_latest',
            'en.ner.bert.rdchambers.by_rdchambers': 'bert_ner_rdchambers_bert_finetuned_ner',
            'en.ner.bert.recipe_tag_model.by_media1129': 'bert_ner_media1129_recipe_tag_model',
            'en.ner.bert.salvatore.by_salvatore': 'bert_ner_salvatore_bert_finetuned_ner',
            'en.ner.bert.sentiment_ingredient.': 'bert_token_classifier_autonlp_ingredient_sentiment_analysis_19126711',
            'en.ner.bert.small': 'bert_ner_small',
            'en.ner.bert.small.by_narsil': 'bert_ner_small2',
            'en.ner.bert.small_finetuned': 'bert_ner_bert_small_finetuned_typo_detection',
            'en.ner.bert.sourcerecognition.by_lamine': 'bert_ner_bert_finetuned_ner_sourcerecognition',
            'en.ner.bert.sourcerecognition.v2.by_lamine': 'bert_ner_bert_finetuned_ner2',
            'en.ner.bert.split_title_org.by_pkushiqiang': 'bert_ner_bert_split_title_org',
            'en.ner.bert.tac.by_lideming7757': 'bert_ner_tac_bert_finetuned_ner',
            'en.ner.bert.task5_finetuned.by_zhuzhusleepearly': 'bert_ner_bert_task5finetuned',
            'en.ner.bert.tele.by_ksaluja': 'bert_ner_autonlp_tele_new_5k_557515810',
            'en.ner.bert.tele_red.by_ksaluja': 'bert_ner_autonlp_tele_red_data_model_585716433',
            'en.ner.bert.tiny': 'bert_ner_rubert_tiny2_sentence_compression',
            'en.ner.bert.tiny.by_hf_internal_testing': 'bert_ner_tiny_bert_for_token_classification',
            'en.ner.bert.tiny.by_satyamrajawat1994': 'bert_ner_tinybert_fincorp',
            'en.ner.bert.title_org.by_pkushiqiang': 'bert_ner_bert_title_org',
            'en.ner.bert.toxic.by_tesemnikov_av': 'bert_ner_rubert_ner_toxicity',
            'en.ner.bert.tweet.base': 'bert_ner_bert_base_tweetner_2020',
            'en.ner.bert.tweet.large': 'bert_ner_bert_large_tweetner_2020',
            'en.ner.bert.twiner.base.by_overfit': 'bert_ner_twiner_bert_base',
            'en.ner.bert.twiner.base_mtl.by_overfit': 'bert_ner_twiner_bert_base_mtl',
            'en.ner.bert.ubb_endava.by_beardedjohn': 'bert_ner_bert_finetuned_ner_ubb_endava',
            'en.ner.bert.ubb_endava_1.by_beardedjohn': 'bert_ner_bert_finetuned_ner_ubb_endava_1',
            'en.ner.bert.ubb_endava_2.by_beardedjohn': 'bert_ner_bert_finetuned_ner_ubb_endava_2',
            'en.ner.bert.ubb_endava_only_misc.by_beardedjohn': 'bert_ner_bert_finetuned_ner_ubb_endava_only_misc',
            'en.ner.bert.uncased': 'bert_ner_bert_uncased_keyword_discriminator',
            'en.ner.bert.uncased.by_yanekyuk': 'bert_ner_bert_uncased_keyword_extractor',
            'en.ner.bert.uncased_base': 'bert_ner_bert_base_ner_uncased',
            'en.ner.bert.uncased_base.by_ml6team': 'bert_token_classifier_base_uncased_city_country_ner',
            'en.ner.bert.uncased_base.kin.by_arnolfokam': 'bert_ner_bert_base_uncased_kin',
            'en.ner.bert.uncased_base.pcm.by_arnolfokam': 'bert_ner_bert_base_uncased_pcm',
            'en.ner.bert.uncased_finetuned': 'bert_ner_bert_finetuned_ner_uncased',
            'en.ner.bert.uncased_large': 'bert_ner_bert_large_uncased_med_ner',
            'en.ner.bert.v1.by_ksaluja': 'bert_ner_new_test_model',
            'en.ner.bert.v2': 'bert_ner_epiextract4gard_v2',
            'en.ner.bert.v2.3000_v2.by_media1129': 'bert_ner_keyword_tag_model_3000_v2',
            'en.ner.bert.v2.6000_v2.by_media1129': 'bert_ner_keyword_tag_model_6000_v2',
            'en.ner.bert.v2.9000_v2.by_media1129': 'bert_ner_keyword_tag_model_9000_v2',
            'en.ner.bert.v2.by_ksaluja': 'bert_ner_new_test_model2',
            'en.ner.bert.v2.by_tartunlp': 'bert_ner_estbert_ner_v2',
            'en.ner.bert.wikiann.': 'bert_ner_bert_srb_ner',
            'en.ner.bert.wikiann.finetuned': 'bert_ner_ravindra001_bert_finetuned_ner',
            'en.ner.bert.wikineural.multilingual': 'bert_ner_mohitsingh_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_Shiva12': 'bert_ner_shiva12_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_Shivanand': 'bert_ner_shivanand_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_Shwetabh': 'bert_ner_shwetabh_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_VikasMani': 'bert_ner_vikasmani_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_Vikings03': 'bert_ner_vikings03_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_Vinspatel4': 'bert_ner_vinspatel4_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_Zainab18': 'bert_ner_zainab18_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_amasi': 'bert_ner_amasi_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_amrita03': 'bert_ner_amrita03_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_ashwathgojo234': 'bert_ner_ashwathgojo234_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_gk07': 'bert_ner_gk07_wikineural_multilingual_ner',
            'en.ner.bert.wikineural.multilingual.by_silpa': 'bert_ner_silpa_wikineural_multilingual_ner',
            'en.ner.bert_base_cased': 'ner_dl_bert_base_cased',
            'en.ner.biobert': 'bert_ner_biobert_genetic_ner',
            'en.ner.biobert.512d_modified': 'bert_ner_bionlp13_modified_biobert_512',
            'en.ner.biobert.bc2gm.': 'bert_ner_biobert_ner_bc2gm_corpus',
            'en.ner.biobert.bc2gm.original': 'bert_ner_original_biobert_bc2gm',
            'en.ner.biobert.bc5cdr.cased_base_imbalanced': 'bert_ner_bc5cdr_imbalanced_biobert_base_cased_v1.2',
            'en.ner.biobert.bc5cdr.disease_imbalanced': 'bert_ner_bc5cdr_disease_imbalanced_biobert_v1.1',
            'en.ner.biobert.bc5cdr.modified_disease': 'bert_ner_bc5cdr_disease_modified_biobert_v1.1',
            'en.ner.biobert.bc5cdr.original_disease': 'bert_ner_original_biobert_bc5cdr_disease',
            'en.ner.biobert.bionlp13cg.modified': 'bert_ner_bionlp13cg_modified_biobert_v1.1_latest',
            'en.ner.biobert.bionlp13cg.original': 'bert_ner_bionlp13cg_original_biobert_v1.1_latest',
            'en.ner.biobert.cased_base_finetuned': 'bert_ner_hossay_biobert_base_cased_v1.2_finetuned_ner',
            'en.ner.biobert.chemical.': 'bert_ner_biobert_chemical_ner',
            'en.ner.biobert.chemical.512d_modified': 'bert_ner_bc4chemd_chem_modified_biobert_512',
            'en.ner.biobert.chemical.512d_original': 'bert_ner_bc4chemd_chem_original_biobert_512',
            'en.ner.biobert.chemical.base_imbalanced': 'bert_ner_bc4chemd_imbalanced_biobert_base_casesd_v1.1',
            'en.ner.biobert.chemical.modified': 'bert_ner_bc4chemd_chem_modified_biobert_384',
            'en.ner.biobert.chemical.modified.by_ghadeermobasher': 'bert_ner_bchem4_modified_biobert_v1',
            'en.ner.biobert.chemical.original': 'bert_ner_bc4chemd_original_biobert_384',
            'en.ner.biobert.chemical_bc5cdr.512d_modified': 'bert_ner_bc5cdr_chem_modified_biobert_512',
            'en.ner.biobert.chemical_bc5cdr.512d_original': 'bert_ner_bc5cdr_chem_original_biobert_512',
            'en.ner.biobert.chemical_bc5cdr.cased_base_disease': 'bert_ner_bc5cdr_chemical_disease_balanced_biobert_base_cased_v1.2',
            'en.ner.biobert.chemical_bc5cdr.cased_large_modified': 'bert_ner_bc5cdr_chem_modified_biobert_large_cased',
            'en.ner.biobert.chemical_bc5cdr.imbalanced': 'bert_ner_bc5cdr_chemical_imbalanced_biobert',
            'en.ner.biobert.chemical_bc5cdr.imbalanced.by_ghadeermobasher': 'bert_ner_bc5cdr_chemical_imbalanced_biobert_v1.1_latest',
            'en.ner.biobert.chemical_bc5cdr.modified': 'bert_ner_bc5cdr_chem_modified_biobert_384',
            'en.ner.biobert.chemical_bc5cdr.modified.by_ghadeermobasher': 'bert_ner_bc5cdr_chem_modified_biobert_v1.1_latest',
            'en.ner.biobert.chemical_bc5cdr.original': 'bert_ner_bc5cdr_chem_original_biobert_384',
            'en.ner.biobert.chemical_bc5cdr.original.by_ghadeermobasher': 'bert_ner_original_biobert_bc5cdr_chemical',
            'en.ner.biobert.chemical_bionlp13cg.512d_original': 'bert_ner_bionlp13cg_chem_chem_original_biobert_512',
            'en.ner.biobert.chemical_bionlp13cg.imbalanced': 'bert_ner_bionlp13cg_chem_imbalanced_biobert',
            'en.ner.biobert.chemical_bionlp13cg.large_modified': 'bert_ner_bionlp13cg_chem_modified_biobert_large',
            'en.ner.biobert.chemical_bionlp13cg.modified': 'bert_ner_bionlp13cg_chem_modified_biobert_384',
            'en.ner.biobert.chemical_bionlp13cg.original': 'bert_ner_bionlp13cg_chem_original_biobert_384',
            'en.ner.biobert.chemical_craft.cased_large_modified': 'bert_ner_craft_chem_modified_biobert_large_cased',
            'en.ner.biobert.chemical_craft.modified': 'bert_ner_craft_chem_modified_biobert_v1.1',
            'en.ner.biobert.chemical_craft.original': 'bert_ner_craft_chem_original_biobert_v1.1',
            'en.ner.biobert.craft.512d_modified': 'bert_ner_craft_modified_biobert_512',
            'en.ner.biobert.craft.512d_original': 'bert_ner_craft_original_biobert_512',
            'en.ner.biobert.craft.cased_base_finetuned': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft',
            'en.ner.biobert.craft.modified': 'bert_ner_craft_modified_biobert_384',
            'en.ner.biobert.craft.original': 'bert_ner_craft_original_biobert_384',
            'en.ner.biobert.finetuned': 'bert_ner_biobert_finetuned_ner',
            'en.ner.biobert.finetuned_k.by_krishadow': 'bert_ner_biobert_finetuned_ner_k',
            'en.ner.biobert.finetuned_k2.by_krishadow': 'bert_ner_biobert_finetuned_ner_k2',
            'en.ner.biobert.mlma.by_adwayk': 'bert_ner_hugging_face_biobert_mlma',
            'en.ner.biobert.mlmav3.by_adwayk': 'bert_ner_hugging_face_biobert_mlmav3',
            'en.ner.biobert.modified': 'bert_ner_bc4_modified_biobert_v1.1',
            'en.ner.biobert.ncbi.': 'bert_ner_wlt_biobert_ncbi',
            'en.ner.biobert.ncbi.disease': 'bert_ner_biobert_ner_ncbi_disease',
            'en.ner.biobert.ncbi.disease.by_AdwayK': 'bert_ner_biobert_ncbi_disease_ner_tuned_on_tac2017',
            'en.ner.biobert.ncbi.disease.by_ugaray96': 'bert_ner_biobert_ncbi_disease_ner',
            'en.ner.biobert.ncbi.original': 'bert_ner_original_biobert_ncbi',
            'en.ner.biobert.on_adr_as_ner.by_adwayk': 'bert_ner_biobert_on_adr_as_ner',
            'en.ner.biobert.original': 'bert_ner_bc4_original_biobert_v1.1',
            'en.ner.biobert.original.by_ghadeermobasher': 'bert_ner_original_biobert_linnaeus',
            'en.ner.biobert.pubmed.finetuned': 'bert_ner_biobert_v1.1_pubmed_finetuned_ner',
            'en.ner.biobert.pubmed.finetuned.by_fidukm34': 'bert_ner_biobert_v1.1_pubmed_finetuned_ner_finetuned_ner',
            'en.ner.biobert.v2': 'bert_ner_hugging_face_biobert_mlmav2',
            'en.ner.bioformer.bc2gm.cased': 'bert_ner_bioformer_cased_v1.0_bc2gm',
            'en.ner.bioformer.chemical_bionlp13cg.modified': 'bert_ner_bionlp13cg_chem_modified_bioformers',
            'en.ner.bioformer.chemical_bionlp13cg.modified.by_ghadeermobasher': 'bert_ner_bionlp13cg_chem_modified_bioformers_2',
            'en.ner.bioformer.chemical_craft.modified': 'bert_ner_craft_chem_modified_bioformers',
            'en.ner.bioformer.ncbi.cased_disease': 'bert_ner_bioformer_cased_v1.0_ncbi_disease',
            'en.ner.camembert': 'camembert_classifier_berties',
            'en.ner.camembert.base': 'camembert_base_token_classifier_wikiner',
            'en.ner.camembert.base_finetuned': 'camembert_classifier_base_wikipedia_4gb_finetuned_job_ner',
            'en.ner.camembert.by_cassandra_themis': 'camembert_classifier_test_tcp_ca_cassandra_themis',
            'en.ner.camembert.finetuned': 'camembert_classifier_das22_41_pretrained_finetuned_ref',
            'en.ner.camembert.finetuned_das22_42_ref.by_hueynemud': 'camembert_classifier_das22_42_finetuned_ref',
            'en.ner.camembert.finetuned_das22_43_pero.by_hueynemud': 'camembert_classifier_das22_43_pretrained_finetuned_pero',
            'en.ner.camembert.finetuned_das22_44_pero.by_hueynemud': 'camembert_classifier_das22_44_finetuned_pero',
            'en.ner.camembert.large': 'camembert_large_token_classifier_wikiner',
            'en.ner.conll.base': 'nerdl_conll_deberta_base',
            'en.ner.conll.dl.elmo.': 'nerdl_conll_elmo',
            'en.ner.conll.elmo.': 'ner_conll_elmo',
            'en.ner.conll.large': 'nerdl_conll_deberta_large',
            'en.ner.conll_albert_base_uncased': 'ner_conll_albert_base_uncased',
            'en.ner.conll_albert_large_uncased': 'ner_conll_albert_large_uncased',
            'en.ner.conll_bert_base_cased': 'ner_conll_bert_base_cased',
            'en.ner.conll_distilbert_base_cased': 'ner_conll_distilbert_base_cased',
            'en.ner.conll_longformer_large_4096': 'ner_conll_longformer_large_4096',
            'en.ner.conll_roberta_base': 'ner_conll_roberta_base',
            'en.ner.conll_roberta_large': 'ner_conll_roberta_large',
            'en.ner.conll_xlm_roberta_base': 'ner_conll_xlm_roberta_base',
            'en.ner.conll_xlnet_base_cased': 'ner_conll_xlnet_base_cased',
            'en.ner.debertav3_base.conll03': 'deberta_v3_base_token_classifier_conll03',
            'en.ner.debertav3_base.ontonotes': 'deberta_v3_base_token_classifier_ontonotes',
            'en.ner.debertav3_large.conll03': 'deberta_v3_large_token_classifier_conll03',
            'en.ner.debertav3_large.ontonotes': 'deberta_v3_large_token_classifier_ontonotes',
            'en.ner.debertav3_small.conll03': 'deberta_v3_small_token_classifier_conll03',
            'en.ner.debertav3_small.ontonotes': 'deberta_v3_small_token_classifier_ontonotes',
            'en.ner.debertav3_xsmall.conll03': 'deberta_v3_xsmall_token_classifier_conll03',
            'en.ner.debertav3_xsmall.ontonotes': 'deberta_v3_xsmall_token_classifier_ontonotes',
            'en.ner.distil_bert': 'distilbert_ner_autotrain_defector_ner_846726994',
            'en.ner.distil_bert.by_couchcat': 'distilbert_ner_ma_ner_v7_distil',
            'en.ner.distil_bert.company.by_lucifermorninstar011': 'distilbert_ner_autotrain_luicfer_company_861827409',
            'en.ner.distil_bert.conll.base': 'distilbert_base_token_classifier_conll03',
            'en.ner.distil_bert.conll.cased_base_finetuned': 'distilbert_ner_distilbert_base_cased_finetuned_conll03_english',
            'en.ner.distil_bert.conll.uncased_base_finetuned': 'distilbert_ner_distilbert_base_uncased_finetuned_conll03_english',
            'en.ner.distil_bert.few_nerd.base': 'distilbert_base_token_classifier_few_nerd',
            'en.ner.distil_bert.job_title.by_lucifermorninstar011': 'distilbert_ner_autotrain_lucifer_job_title_853727204',
            'en.ner.distil_bert.keyphrase.': 'distilbert_ner_keyphrase_extraction_distilbert_inspec',
            'en.ner.distil_bert.keyphrase.kptimes.by_dedeckerthomas': 'distilbert_ner_keyphrase_extraction_distilbert_kptimes',
            'en.ner.distil_bert.keyphrase.openkp.by_dedeckerthomas': 'distilbert_ner_keyphrase_extraction_distilbert_openkp',
            'en.ner.distil_bert.morningstar_job.by_lucifermorninstar011': 'distilbert_ner_autotrain_lucifer_morningstar_job_859227344',
            'en.ner.distil_bert.ontonotes.base': 'distilbert_base_token_classifier_ontonotes',
            'en.ner.distil_roberta.conll.distilled_base': 'roberta_ner_distilroberta_base_ner_conll2003',
            'en.ner.distil_roberta.conll_wikiann.distilled_base': 'roberta_ner_distilroberta_base_ner_wikiann_conll2003_3_class',
            'en.ner.distil_roberta.conll_wikiann.distilled_base.by_philschmid': 'roberta_ner_distilroberta_base_ner_wikiann_conll2003_4_class',
            'en.ner.distil_roberta.wikiann.distilled_base': 'roberta_ner_distilroberta_base_ner_wikiann',
            'en.ner.dl': 'ner_dl',
            'en.ner.dl.bert': 'ner_dl_bert',
            'en.ner.farbrbert.base.by_giggio': 'bert_ner_farbrbert_base',
            'en.ner.farbrbert.base_75.by_giggio': 'bert_ner_far75brbert_base',
            'en.ner.fewnerd': 'nerdl_fewnerd_100d',
            'en.ner.fewnerd_subentity': 'nerdl_fewnerd_subentity_100d',
            'en.ner.glove': 'ner_dl_sentence',
            'en.ner.glove.100d': 'ner_dl_sentence',
            'en.ner.indo_bert.finetuned': 'bert_ner_chanifrusydi_indobert_finetuned_ner',
            'en.ner.indo_bert.finetuned.by_xenergy': 'bert_ner_xenergy_indobert_finetuned_ner',
            'en.ner.longformer.conll.large': 'longformer_large_token_classifier_conll03',
            'en.ner.mit_movie_complex_bert': 'ner_mit_movie_complex_bert_base_cased',
            'en.ner.mit_movie_complex_distilbert': 'ner_mit_movie_complex_distilbert_base_cased',
            'en.ner.mit_movie_simple': 'ner_mit_movie_simple_distilbert_base_cased',
            'en.ner.movie': 'ner_mit_movie_complex_bert_base_cased',
            'en.ner.movie_complex': 'ner_mit_movie_complex_bert_base_cased',
            'en.ner.movie_simple': 'ner_mit_movie_complex_bert_base_cased',
            'en.ner.ner_chemical_bionlp_bc5cdr_pubmed': 'roberta_ner_ner_chemical_bionlp_bc5cdr_pubmed',
            'en.ner.ner_disease_ncbi_bionlp_bc5cdr_pubmed': 'roberta_ner_ner_disease_ncbi_bionlp_bc5cdr_pubmed',
            'en.ner.ner_gene_dna_rna_jnlpba_pubmed': 'roberta_ner_ner_gene_dna_rna_jnlpba_pubmed',
            'en.ner.onto': 'onto_100',
            'en.ner.onto.bert.cased_base': 'onto_bert_base_cased',
            'en.ner.onto.bert.cased_large': 'onto_bert_large_cased',
            'en.ner.onto.bert.small_l2_128': 'onto_small_bert_L2_128',
            'en.ner.onto.bert.small_l4_256': 'onto_small_bert_L4_256',
            'en.ner.onto.bert.small_l4_512': 'onto_small_bert_L4_512',
            'en.ner.onto.bert.small_l8_512': 'onto_small_bert_L8_512',
            'en.ner.onto.electra.uncased_base': 'onto_electra_base_uncased',
            'en.ner.onto.electra.uncased_large': 'onto_electra_large_uncased',
            'en.ner.onto.electra.uncased_small': 'onto_electra_small_uncased',
            'en.ner.onto.glove.6B_100d': 'onto_100',
            'en.ner.onto.glove.840B_300d': 'onto_300',
            'en.ner.ontonotes_distilbert_base_cased': 'ner_ontonotes_distilbert_base_cased',
            'en.ner.ontonotes_roberta_base': 'ner_ontonotes_roberta_base',
            'en.ner.ontonotes_roberta_large': 'ner_ontonotes_roberta_large',
            'en.ner.pos': 'bert_pos_codeswitch_spaeng_pos_lince',
            'en.ner.pos.128d': 'bert_pos_estbert_morph_128',
            'en.ner.pos.4l_weight_decay.by_kktoto': 'bert_pos_4l_weight_decay',
            'en.ner.pos.amhariccacopostag.by_mitiku': 'bert_pos_amhariccacopostag',
            'en.ner.pos.amharicwicpostag.by_mitiku': 'bert_pos_amharicwicpostag',
            'en.ner.pos.amharicwicpostag10tags.by_mitiku': 'bert_pos_amharicwicpostag10tags',
            'en.ner.pos.base_finetuned': 'roberta_pos_roberto_base_finetuned_pos',
            'en.ner.pos.by_alice_hml': 'bert_pos_mbert_grammatical_error_tagger',
            'en.ner.pos.by_alvenir': 'bert_pos_bert_punct_restoration_en_alvenir',
            'en.ner.pos.by_kitaev': 'bert_pos_tetra_tag_en_kitaev',
            'en.ner.pos.by_proycon': 'roberta_pos_veganuary_pos',
            'en.ner.pos.cased': 'bert_pos_bert_pos_cased_deepfrog_nld',
            'en.ner.pos.cased.by_proycon': 'roberta_pos_robbert2_pos_cased_deepfrog_nld',
            'en.ner.pos.cased_base': 'bert_pos_bert_base_cased_ccg',
            'en.ner.pos.cased_base.by_qcri': 'bert_pos_bert_base_cased_pos',
            'en.ner.pos.cased_multilingual_base': 'bert_pos_bert_base_multilingual_cased_pos_english',
            'en.ner.pos.cased_multilingual_base.by_qcri': 'bert_pos_bert_base_multilingual_cased_chunking_english',
            'en.ner.pos.ccvspantagger.by_rj3vans': 'bert_pos_ccvspantagger',
            'en.ner.pos.clnspantagger.by_rj3vans': 'bert_pos_clnspantagger',
            'en.ner.pos.cmn1spantagger.by_rj3vans': 'bert_pos_cmn1spantagger',
            'en.ner.pos.cmv1spantagger.by_rj3vans': 'bert_pos_cmv1spantagger',
            'en.ner.pos.conll.': 'bert_pos_tr_kg_pos_conllu_bert',
            'en.ner.pos.conll.finetuned': 'bert_pos_bert_finetuned_conll2003_pos',
            'en.ner.pos.conll.finetuned.by_Fredvv': 'bert_pos_bert_finetuned_pos',
            'en.ner.pos.estbert_upos.128d.by_tartunlp': 'bert_pos_estbert_upos_128',
            'en.ner.pos.estbert_xpos.128d.by_tartunlp': 'bert_pos_estbert_xpos_128',
            'en.ner.pos.finetuned': 'bert_pos_bert_finetuned_chunking',
            'en.ner.pos.finetuned_accelerate.by_deborah': 'bert_pos_bertimbau_finetuned_pos_accelerate',
            'en.ner.pos.finetuned_accelerate2.by_deborah': 'bert_pos_bertimbau_finetuned_pos_accelerate2',
            'en.ner.pos.finetuned_accelerate3.by_deborah': 'bert_pos_bertimbau_finetuned_pos_accelerate3',
            'en.ner.pos.finetuned_accelerate_5.by_camilag': 'bert_pos_bertimbau_finetuned_pos_accelerate_5',
            'en.ner.pos.finetuned_accelerate_6.by_camilag': 'bert_pos_bertimbau_finetuned_pos_accelerate_6',
            'en.ner.pos.finetuned_accelerate_7.by_camilag': 'bert_pos_bertimbau_finetuned_pos_accelerate_7',
            'en.ner.pos.focal_alpah.tiny.by_kktoto': 'bert_pos_tiny_focal_alpah',
            'en.ner.pos.focal_alpah75.tiny.by_kktoto': 'bert_pos_tiny_focal_alpah75',
            'en.ner.pos.focal_ckpt.tiny.by_kktoto': 'bert_pos_tiny_focal_ckpt',
            'en.ner.pos.focal_v3.tiny.by_kktoto': 'bert_pos_tiny_focal_v3',
            'en.ner.pos.kt_punctuator.tiny.by_kktoto': 'bert_pos_tiny_kt_punctuator',
            'en.ner.pos.ktoto_punctuator.tiny.by_kktoto': 'bert_pos_tiny_ktoto_punctuator',
            'en.ner.pos.lr_kk_kktoto.tiny.by_kktoto': 'bert_pos_tiny_lr_kk_kktoto',
            'en.ner.pos.pars_bert.finetuned': 'bert_pos_parsbert_finetuned_pos',
            'en.ner.pos.signtagger.by_rj3vans': 'bert_pos_signtagger',
            'en.ner.pos.ssccvspantagger.by_rj3vans': 'bert_pos_ssccvspantagger',
            'en.ner.pos.ssccvspantagger.v2.by_rj3vans': 'bert_pos_13.05.2022.ssccvspantagger',
            'en.ner.pos.tiny': 'bert_pos_tiny_bb_wd',
            'en.ner.pos.tiny.tiny.by_kktoto': 'bert_pos_wwdd_tiny',
            'en.ner.pos.toto_punctuator.tiny.by_kktoto': 'bert_pos_tiny_toto_punctuator',
            'en.ner.pos.ty_punctuator.by_kktoto': 'bert_pos_ty_punctuator',
            'en.ner.pos.uncased_finetuned': 'bert_pos_bert_english_uncased_finetuned_chunk',
            'en.ner.pos.uncased_finetuned.by_vblagoje': 'bert_pos_bert_english_uncased_finetuned_pos',
            'en.ner.pos.universal_dependencies.base': 'xlmroberta_pos_xlm_roberta_base_english_upos',
            'en.ner.pos.universal_dependencies.distilled': 'roberta_pos_distil_slovakbert_upos',
            'en.ner.pos.v2_tiny': 'bert_pos_tiny_focal_v2_label',
            'en.ner.pos.v2_tiny.by_kktoto': 'bert_pos_tiny_no_focal_v2',
            'en.ner.pubmed_bert.chemical_pubmed.': 'bert_ner_bc4_chem_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed.512d_modified': 'bert_ner_bc5cd_chem_modified_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed.512d_original': 'bert_ner_bc4chemd_chem_original_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed.imbalanced': 'bert_ner_bc4chemd_imbalancedpubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed.modified': 'bert_ner_bc4chemd_chem_modified_pubmedbert_384',
            'en.ner.pubmed_bert.chemical_pubmed.modified.by_ghadeermobasher': 'bert_ner_bc4chemd_modified_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed.original': 'bert_ner_bc4chemd_chem_original_pubmedbert_384',
            'en.ner.pubmed_bert.chemical_pubmed.original.by_ghadeermobasher': 'bert_ner_original_pubmedbert_bc4chemd',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.512d_original': 'bert_ner_bc5cdr_chem_original_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.disease': 'bert_ner_bc5cdr_chemical_disease_balanced_sapbert_from_pubmedbert_fulltext',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.disease.by_ghadeermobasher': 'bert_ner_bc5cdr_chemical_disease_balanced_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.imbalanced': 'bert_ner_bc5cdr_chemical_imbalanced_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.modified': 'bert_ner_bc5cdr_chem_modified_pubmedbert_384',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.modified.by_ghadeermobasher': 'bert_ner_bc5cdr_chemical_modified_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.original': 'bert_ner_original_pubmedbert_bc5cdr_chemical',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.uncased_base_disease': 'bert_ner_bc5cdr_chemical_disease_balanced_biomednlp_pubmedbert_base_uncased_abstract_fulltext',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.uncased_base_imbalanced': 'bert_ner_bc5cdr_chem2_imbalanced_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.uncased_base_imbalanced.by_ghadeermobasher': 'bert_ner_bc5cdr_chemical_imbalanced_pubmedbert_base_uncased_abstract_latest',
            'en.ner.pubmed_bert.chemical_pubmed_bc5cdr.uncased_base_modified': 'bert_ner_bc5cdr_chem2_modified_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.512d_modified': 'bert_ner_bionlp13cg_chem_modified_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.512d_original': 'bert_ner_bionlp13cg_chem_original_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.imbalanced': 'bert_ner_bionlp13cg_chem_imbalancedpubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.modified': 'bert_ner_bionlp13cg_chem_modified_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.modified_384.by_ghadeermobasher': 'bert_ner_bionlp13cg_chem_modified_pubmedbert_384',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.modified_abstract_3.by_ghadeermobasher': 'bert_ner_bionlp13cg_chem_modified_pubmedbert_abstract_3',
            'en.ner.pubmed_bert.chemical_pubmed_bionlp13cg.modified_full_3.by_ghadeermobasher': 'bert_ner_bionlp13cg_chem_modified_pubmedbert_full_3',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_32d_modified': 'bert_ner_biored_chem_modified_pubmedbert_128_32',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_32d_original': 'bert_ner_biored_chem_original_pubmedbert_128_32',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_modified': 'bert_ner_biored_chem_modified_pubmedbert_128_10',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_modified_128_20.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_128_20',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_modified_128_5.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_128_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_original': 'bert_ner_biored_chem_original_pubmedbert_128_10',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_original_128_20.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_128_20',
            'en.ner.pubmed_bert.chemical_pubmed_biored.128d_original_128_5.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_128_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.256d_modified': 'bert_ner_biored_chem_modified_pubmedbert_256_13',
            'en.ner.pubmed_bert.chemical_pubmed_biored.256d_modified_256_40.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_256_40',
            'en.ner.pubmed_bert.chemical_pubmed_biored.256d_modified_256_5.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_256_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.256d_original': 'bert_ner_biored_chem_original_pubmedbert_256_13',
            'en.ner.pubmed_bert.chemical_pubmed_biored.256d_original_256_40.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_256_40',
            'en.ner.pubmed_bert.chemical_pubmed_biored.256d_original_256_5.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_256_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.32d_modified': 'bert_ner_biored_chem_modified_pubmedbert_320_8',
            'en.ner.pubmed_bert.chemical_pubmed_biored.32d_modified.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_320_8_10',
            'en.ner.pubmed_bert.chemical_pubmed_biored.32d_original': 'bert_ner_biored_chem_original_pubmedbert_320_8',
            'en.ner.pubmed_bert.chemical_pubmed_biored.512d_modified': 'bert_ner_biored_chem_modified_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed_biored.512d_modified_512_5.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_512_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.512d_modified_512_5_30.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_512_5_30',
            'en.ner.pubmed_bert.chemical_pubmed_biored.512d_original': 'bert_ner_biored_chem_original_pubmedbert_512',
            'en.ner.pubmed_bert.chemical_pubmed_biored.512d_original_512_5.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_512_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.512d_original_512_5_30.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_512_5_30',
            'en.ner.pubmed_bert.chemical_pubmed_biored.modified': 'bert_ner_biored_chem_modified_pubmedbert_384_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.modified_384_8.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_384_8',
            'en.ner.pubmed_bert.chemical_pubmed_biored.modified_384_8_10.by_ghadeermobasher': 'bert_ner_biored_chem_modified_pubmedbert_384_8_10',
            'en.ner.pubmed_bert.chemical_pubmed_biored.original': 'bert_ner_biored_chem_original_pubmedbert_384_5',
            'en.ner.pubmed_bert.chemical_pubmed_biored.original.by_ghadeermobasher': 'bert_ner_biored_chem_original_pubmedbert_384_8',
            'en.ner.pubmed_bert.chemical_pubmed_craft.imbalanced': 'bert_ner_craft_chem_imbalancedpubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_craft.modified': 'bert_ner_craft_chem_modified_pubmedbert',
            'en.ner.pubmed_bert.chemical_pubmed_craft.uncased_base_modified': 'bert_ner_craft_chem_modified_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.chemical_pubmed_craft.uncased_base_original': 'bert_ner_craft_chem_original_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.pubmed.': 'bert_ner_wlt_pubmedbert_linnaeus',
            'en.ner.pubmed_bert.pubmed.modified': 'bert_ner_bionlp13_modified_pubmedbert_384',
            'en.ner.pubmed_bert.pubmed.original': 'bert_ner_bc4_original_pubmedbert',
            'en.ner.pubmed_bert.pubmed.original.by_ghadeermobasher': 'bert_ner_original_pubmedbert_linnaeus',
            'en.ner.pubmed_bert.pubmed.small_modified': 'bert_ner_bc4_modified_pubmedbert_small',
            'en.ner.pubmed_bert.pubmed.small_original': 'bert_ner_bc4_original_pubmedbert_small',
            'en.ner.pubmed_bert.pubmed.uncased_base_modified': 'bert_ner_bc4_modified_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.pubmed.uncased_base_original': 'bert_ner_bc4_original_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.pubmed_bc2gm.': 'bert_ner_wlt_pubmedbert_bc2gm',
            'en.ner.pubmed_bert.pubmed_bc2gm.imbalanced': 'bert_ner_bc2gm_gene_imbalancedpubmedbert',
            'en.ner.pubmed_bert.pubmed_bc2gm.modified': 'bert_ner_bc2gm_gene_modified_pubmedbert',
            'en.ner.pubmed_bert.pubmed_bc2gm.original': 'bert_ner_original_pubmedbert_bc2gm',
            'en.ner.pubmed_bert.pubmed_bc5cdr.disease': 'bert_ner_bc5cdr_disease_balancedpubmedbert',
            'en.ner.pubmed_bert.pubmed_bc5cdr.imbalanced': 'bert_ner_bc5cdr_imbalanced_pubmedbert',
            'en.ner.pubmed_bert.pubmed_bc5cdr.imbalanced.by_ghadeermobasher': 'bert_ner_bc5cdr_imbalanced_sapbert_from_pubmedbert_fulltext',
            'en.ner.pubmed_bert.pubmed_bc5cdr.modified_disease': 'bert_ner_bc5cdr_disease_modified_pubmedbert',
            'en.ner.pubmed_bert.pubmed_bc5cdr.original_disease': 'bert_ner_original_pubmedbert_bc5cdr_disease',
            'en.ner.pubmed_bert.pubmed_bc5cdr.uncased_base_disease_imbalanced': 'bert_ner_bc5cdr_disease_imbalanced_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.pubmed_bc5cdr.uncased_base_modified_disease': 'bert_ner_bc5cdr_disease_modified_biomednlp_pubmedbert_base_uncased_abstract',
            'en.ner.pubmed_bert.pubmed_bionlp13cg.original': 'bert_ner_bionlp13cg_original_pubmedbert_abstract_latest',
            'en.ner.pubmed_bert.pubmed_biored.128d_32d_modified': 'bert_ner_biored_dis_modified_pubmedbert_128_32',
            'en.ner.pubmed_bert.pubmed_biored.128d_32d_original': 'bert_ner_biored_dis_original_pubmedbert_128_32',
            'en.ner.pubmed_bert.pubmed_biored.256d_modified': 'bert_ner_biored_dis_modified_pubmedbert_256_13',
            'en.ner.pubmed_bert.pubmed_biored.256d_modified.by_ghadeermobasher': 'bert_ner_biored_dis_modified_pubmedbert_256_5',
            'en.ner.pubmed_bert.pubmed_biored.256d_original': 'bert_ner_biored_dis_original_pubmedbert_256_13',
            'en.ner.pubmed_bert.pubmed_biored.256d_original.by_ghadeermobasher': 'bert_ner_biored_dis_original_pubmedbert_256_5',
            'en.ner.pubmed_bert.pubmed_biored.32d_modified': 'bert_ner_biored_dis_modified_pubmedbert_320_8',
            'en.ner.pubmed_bert.pubmed_biored.32d_modified.by_ghadeermobasher': 'bert_ner_biored_dis_modified_pubmedbert_320_8_10',
            'en.ner.pubmed_bert.pubmed_biored.32d_original': 'bert_ner_biored_dis_original_pubmedbert_320_8',
            'en.ner.pubmed_bert.pubmed_biored.512d_modified': 'bert_ner_biored_cd_modified_pubmedbert_512',
            'en.ner.pubmed_bert.pubmed_biored.512d_modified_512.by_ghadeermobasher': 'bert_ner_biored_dis_modified_pubmedbert_512',
            'en.ner.pubmed_bert.pubmed_biored.512d_modified_512_5.by_ghadeermobasher': 'bert_ner_biored_dis_modified_pubmedbert_512_5',
            'en.ner.pubmed_bert.pubmed_biored.512d_original': 'bert_ner_biored_cd_original_pubmedbert_512',
            'en.ner.pubmed_bert.pubmed_biored.512d_original_512.by_ghadeermobasher': 'bert_ner_biored_dis_original_pubmedbert_512',
            'en.ner.pubmed_bert.pubmed_biored.512d_original_512_5.by_ghadeermobasher': 'bert_ner_biored_dis_original_pubmedbert_512_5',
            'en.ner.pubmed_bert.pubmed_biored.modified': 'bert_ner_biored_dis_modified_pubmedbert_384_5',
            'en.ner.pubmed_bert.pubmed_biored.modified_384_8.by_ghadeermobasher': 'bert_ner_biored_dis_modified_pubmedbert_384_8',
            'en.ner.pubmed_bert.pubmed_biored.modified_384_8_10.by_ghadeermobasher': 'bert_ner_biored_dis_modified_pubmedbert_384_8_10',
            'en.ner.pubmed_bert.pubmed_biored.original': 'bert_ner_biored_dis_original_pubmedbert_384_5',
            'en.ner.pubmed_bert.pubmed_biored.original.by_ghadeermobasher': 'bert_ner_biored_dis_original_pubmedbert_384_8',
            'en.ner.pubmed_bert.pubmed_craft.512d_modified': 'bert_ner_craft_modified_pubmedbert_512',
            'en.ner.pubmed_bert.pubmed_craft.512d_original': 'bert_ner_craft_original_pubmedbert_512',
            'en.ner.pubmed_bert.pubmed_craft.modified': 'bert_ner_craft_modified_pubmedbert_384',
            'en.ner.pubmed_bert.pubmed_craft.original': 'bert_ner_craft_original_pubmedbert_384',
            'en.ner.pubmed_bert.pubmed_ncbi.original': 'bert_ner_original_pubmedbert_ncbi',
            'en.ner.restaurant': 'nerdl_restaurant_100d',
            'en.ner.roberta': 'roberta_ner_clulab_roberta_timex_semeval',
            'en.ner.roberta.base': 'roberta_ner_mimics_tagging_roberta_base',
            'en.ner.roberta.base.by_djagatiya': 'roberta_ner_ner_roberta_base_ontonotesv5_englishv4',
            'en.ner.roberta.base.by_ganzorig': 'roberta_ner_ganzorig_roberta_base_ner_demo',
            'en.ner.roberta.base.by_omunkhuush': 'roberta_ner_omunkhuush_roberta_base_ner_demo',
            'en.ner.roberta.base_finetuned': 'roberta_ner_codebert_base_finetuned_stackoverflow',
            'en.ner.roberta.base_finetuned.by_abhishek_shrm': 'roberta_ner_roberta_base_finetuned_beer_ner',
            'en.ner.roberta.base_finetuned.by_alekseykorshuk': 'roberta_ner_alekseykorshuk_roberta_base_finetuned_ner',
            'en.ner.roberta.base_finetuned.by_mrm8488': 'roberta_ner_codebert_base_finetuned_stackoverflow_ner',
            'en.ner.roberta.base_finetuned.by_surrey_nlp': 'roberta_ner_roberta_base_finetuned_abbr',
            'en.ner.roberta.base_finetuned_v0.by_gozdi': 'roberta_ner_roberta_base_finetuned_ner_0',
            'en.ner.roberta.base_finetuned_v1.by_gozdi': 'roberta_ner_roberta_base_finetuned_ner_1',
            'en.ner.roberta.base_finetuned_v2.by_gozdi': 'roberta_ner_roberta_base_finetuned_ner_2',
            'en.ner.roberta.base_finetuned_v3.by_gozdi': 'roberta_ner_roberta_base_finetuned_ner_3',
            'en.ner.roberta.base_finetuned_v4.by_gozdi': 'roberta_ner_roberta_base_finetuned_ner_4',
            'en.ner.roberta.by_andrija': 'roberta_ner_sroberta_nlp',
            'en.ner.roberta.by_egoitz': 'roberta_ner_egoitz_roberta_timex_semeval',
            'en.ner.roberta.by_iammartahir': 'roberta_ner_domain_adapted_timex',
            'en.ner.roberta.by_icelab': 'roberta_ner_spaceroberta_cr',
            'en.ner.roberta.by_nates': 'roberta_ner_ler_roberta',
            'en.ner.roberta.by_obi': 'roberta_ner_deid_roberta_i2b2',
            'en.ner.roberta.by_recognai': 'roberta_ner_veganuary_ner',
            'en.ner.roberta.by_scarlettsun9': 'roberta_ner_autotrain_zuozhuan_1100540141',
            'en.ner.roberta.by_vesteinn': 'roberta_ner_icebert_ner',
            'en.ner.roberta.by_wolfrage89': 'roberta_ner_company_segment_ner',
            'en.ner.roberta.cased': 'roberta_ner_robbert2_ner_cased_sonar1_nld',
            'en.ner.roberta.cased.by_proycon': 'roberta_ner_robbert_ner_cased_sonar1_nld',
            'en.ner.roberta.codebert_mt4ts.by_kevinjesse': 'roberta_ner_codebert_mt4ts',
            'en.ner.roberta.codeberta_mt4ts.by_kevinjesse': 'roberta_ner_codeberta_mt4ts',
            'en.ner.roberta.conll.base_finetuned': 'roberta_ner_roberta_base_finetuned_ner_kmeans',
            'en.ner.roberta.conll.large_finetuned': 'roberta_ner_romainlhardy_roberta_large_finetuned_ner',
            'en.ner.roberta.finetuned': 'roberta_ner_bergurth_icebert_finetuned_ner',
            'en.ner.roberta.finetuned.by_eliasbe': 'roberta_ner_eliasbe_icebert_finetuned_ner',
            'en.ner.roberta.finetuned.by_orri': 'roberta_ner_orri_icebert_finetuned_ner',
            'en.ner.roberta.finetuned.by_thorduragust': 'roberta_ner_thorduragust_icebert_finetuned_ner',
            'en.ner.roberta.finetuned_protagonist_english.by_airi': 'roberta_ner_bert_finetuned_protagonist_english',
            'en.ner.roberta.finetuned_protagonist_english_pc.by_airi': 'roberta_ner_bert_finetuned_protagonist_english_pc',
            'en.ner.roberta.finetuning_': 'roberta_ner_jurisbert_finetuning_ner',
            'en.ner.roberta.fnrbt.by_mehari': 'roberta_ner_fnrbt',
            'en.ner.roberta.graphcodebert_mt4ts.by_kevinjesse': 'roberta_ner_graphcodebert_mt4ts',
            'en.ner.roberta.graphpolygot_mt4ts.by_kevinjesse': 'roberta_ner_graphpolygot_mt4ts',
            'en.ner.roberta.keyphrase.': 'roberta_ner_keyphrase_extraction_kbir_inspec',
            'en.ner.roberta.keyphrase.kbir_kpcrowd.by_ml6team': 'roberta_ner_keyphrase_extraction_kbir_kpcrowd',
            'en.ner.roberta.keyphrase.kbir_kptimes.by_ml6team': 'roberta_ner_keyphrase_extraction_kbir_kptimes',
            'en.ner.roberta.keyphrase.kbir_openkp.by_ml6team': 'roberta_ner_keyphrase_extraction_kbir_openkp',
            'en.ner.roberta.keyphrase.kbir_semeval2017.by_ml6team': 'roberta_ner_keyphrase_extraction_kbir_semeval2017',
            'en.ner.roberta.large': 'roberta_ner_tner_roberta_large_multiconer_en_asahi417',
            'en.ner.roberta.large_finetuned_adverse_drug_event': 'roberta_ner_roberta_large_finetuned_ades_model_2',
            'en.ner.roberta.large_legal': 'roberta_ner_roberta_large_legal_act_extraction',
            'en.ner.roberta.meds.by_cariai': 'roberta_ner_meds',
            'en.ner.roberta.medslabs.by_cariai': 'roberta_ner_medslabs',
            'en.ner.roberta.polygot_mt4ts.by_kevinjesse': 'roberta_ner_polygot_mt4ts',
            'en.ner.roberta.roberta_mt4ts.by_kevinjesse': 'roberta_ner_roberta_mt4ts',
            'en.ner.roberta.troberta.by_mehari': 'roberta_ner_troberta',
            'en.ner.roberta.tweet.base': 'roberta_ner_roberta_base_tweetner_2020',
            'en.ner.roberta.tweet.base.by_asahi417': 'roberta_ner_tner_roberta_base_tweet_2020',
            'en.ner.roberta.tweet.large': 'roberta_ner_roberta_large_tweetner_2020',
            'en.ner.roberta.tweet.large.by_asahi417': 'roberta_ner_tner_roberta_large_tweet_2020',
            'en.ner.roberta.tweet.tweetner_2020.large.by_tner': 'roberta_ner_bertweet_large_tweetner_2020',
            'en.ner.roberta.tweet.tweetner_2020_2021_concat.base.by_tner': 'roberta_ner_roberta_base_tweetner_2020_2021_concat',
            'en.ner.roberta.tweet.tweetner_2020_2021_concat.large.by_tner': 'roberta_ner_roberta_large_tweetner_2020_2021_concat',
            'en.ner.roberta.tweet.tweetner_2020_2021_continuous.base.by_tner': 'roberta_ner_roberta_base_tweetner_2020_2021_continuous',
            'en.ner.roberta.tweet.tweetner_2020_2021_continuous.large.by_tner': 'roberta_ner_roberta_large_tweetner_2020_2021_continuous',
            'en.ner.roberta.tweet.tweetner_2020_selflabel2020_concat.large.by_tner': 'roberta_ner_roberta_large_tweetner_2020_selflabel2020_concat',
            'en.ner.roberta.tweet.tweetner_2020_selflabel2020_continuous.large.by_tner': 'roberta_ner_roberta_large_tweetner_2020_selflabel2020_continuous',
            'en.ner.roberta.tweet.tweetner_2020_selflabel2021_concat.large.by_tner': 'roberta_ner_roberta_large_tweetner_2020_selflabel2021_concat',
            'en.ner.roberta.tweet.tweetner_2020_selflabel2021_continuous.large.by_tner': 'roberta_ner_roberta_large_tweetner_2020_selflabel2021_continuous',
            'en.ner.roberta.tweet.tweetner_2021.base.by_tner': 'roberta_ner_roberta_base_tweetner_2021',
            'en.ner.roberta.tweet.tweetner_2021.large.by_tner': 'roberta_ner_roberta_large_tweetner_2021',
            'en.ner.roberta.tweet.tweetner_random.large.by_tner': 'roberta_ner_roberta_large_tweetner_random',
            'en.ner.roberta.tweet.tweetner_selflabel2020.large.by_tner': 'roberta_ner_roberta_large_tweetner_selflabel2020',
            'en.ner.roberta.tweet.tweetner_selflabel2021.large.by_tner': 'roberta_ner_roberta_large_tweetner_selflabel2021',
            'en.ner.roberta.tweet_twitter.2019_90m_tweetner_2020_2021_concat.base_90m.by_tner': 'roberta_ner_twitter_roberta_base_2019_90m_tweetner_2020_2021_concat',
            'en.ner.roberta.tweet_twitter.2019_90m_tweetner_2020_2021_continuous.base_90m.by_tner': 'roberta_ner_twitter_roberta_base_2019_90m_tweetner_2020_2021_continuous',
            'en.ner.roberta.tweet_twitter.2019_90m_tweetner_2021.base_90m.by_tner': 'roberta_ner_twitter_roberta_base_2019_90m_tweetner_2021',
            'en.ner.roberta.tweet_twitter.2019_90m_tweetner_random.base_90m.by_tner': 'roberta_ner_twitter_roberta_base_2019_90m_tweetner_random',
            'en.ner.roberta.tweet_twitter.base': 'roberta_ner_twitter_roberta_base_dec2021_tweetner_2020_2021_continuous',
            'en.ner.roberta.tweet_twitter.base_90m': 'roberta_ner_twitter_roberta_base_2019_90m_tweetner_2020',
            'en.ner.roberta.tweet_twitter.dec2020_tweetner_2020.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2020_tweetner_2020',
            'en.ner.roberta.tweet_twitter.dec2020_tweetner_2020_2021_concat.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2020_tweetner_2020_2021_concat',
            'en.ner.roberta.tweet_twitter.dec2020_tweetner_2020_2021_continuous.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2020_tweetner_2020_2021_continuous',
            'en.ner.roberta.tweet_twitter.dec2020_tweetner_2021.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2020_tweetner_2021',
            'en.ner.roberta.tweet_twitter.dec2020_tweetner_random.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2020_tweetner_random',
            'en.ner.roberta.tweet_twitter.dec2021_tweetner_2020.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2021_tweetner_2020',
            'en.ner.roberta.tweet_twitter.dec2021_tweetner_2020_2021_concat.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2021_tweetner_2020_2021_concat',
            'en.ner.roberta.tweet_twitter.dec2021_tweetner_2021.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2021_tweetner_2021',
            'en.ner.roberta.tweet_twitter.dec2021_tweetner_random.base.by_tner': 'roberta_ner_twitter_roberta_base_dec2021_tweetner_random',
            'en.ner.roberta_classics_ner': 'roberta_ner_roberta_classics_ner',
            'en.ner.roberta_large_finetuned_abbr': 'roberta_ner_roberta_large_finetuned_abbr',
            'en.ner.roberta_large_ner_english': 'roberta_ner_roberta_large_ner_english',
            'en.ner.roberta_ticker': 'roberta_ner_roberta_ticker',
            'en.ner.scibert.bc5cdr_scibert.cased_imbalanced': 'bert_ner_bc5cdr_imbalanced_scibert_scivocab_cased',
            'en.ner.scibert.bc5cdr_scibert.cased_modified_disease': 'bert_ner_bc5cdr_disease_modified_scibert_scivocab_cased',
            'en.ner.scibert.bc5cdr_scibert.original_disease': 'bert_ner_original_scibert_bc5cdr_disease',
            'en.ner.scibert.bc5cdr_scibert.uncased_disease_imbalanced': 'bert_ner_bc5cdr_disease_imbalanced_scibert_scivocab_uncased',
            'en.ner.scibert.bc5cdr_scibert.uncased_modified_disease': 'bert_ner_bc5cdr_disease_modified_scibert_scivocab_uncased',
            'en.ner.scibert.chemical_bc5cdr_scibert.512d_modified': 'bert_ner_bc5cdr_chem_modified_scibert_512',
            'en.ner.scibert.chemical_bc5cdr_scibert.512d_original': 'bert_ner_bc5cdr_chem_original_scibert_512',
            'en.ner.scibert.chemical_bc5cdr_scibert.cased_disease': 'bert_ner_bc5cdr_chemical_disease_balanced_scibert_scivocab_cased',
            'en.ner.scibert.chemical_bc5cdr_scibert.cased_imbalanced': 'bert_ner_bc5cdr_chemical_imbalanced_scibert_scivocab_cased',
            'en.ner.scibert.chemical_bc5cdr_scibert.cased_modified': 'bert_ner_bc5cdr_chemical_modified_scibert_scivocab_cased',
            'en.ner.scibert.chemical_bc5cdr_scibert.modified': 'bert_ner_bc5cdr_chem_modified_scibert_384',
            'en.ner.scibert.chemical_bc5cdr_scibert.original': 'bert_ner_bc5cdr_chem_original_scibert_384',
            'en.ner.scibert.chemical_bc5cdr_scibert.original.by_ghadeermobasher': 'bert_ner_original_scibert_bc5cdr_chemical',
            'en.ner.scibert.chemical_bc5cdr_scibert.original_t.by_ghadeermobasher': 'bert_ner_original_scibert_bc5cdr_chemical_t',
            'en.ner.scibert.chemical_bc5cdr_scibert.original_t1.by_ghadeermobasher': 'bert_ner_original_scibert_bc5cdr_chemical_t1',
            'en.ner.scibert.chemical_bc5cdr_scibert.original_t2.by_ghadeermobasher': 'bert_ner_original_scibert_bc5cdr_chemical_t2',
            'en.ner.scibert.chemical_bc5cdr_scibert.uncased_imbalanced': 'bert_ner_bc5cdr_chemical_imbalanced_scibert_scivocab_uncased_latest',
            'en.ner.scibert.chemical_bc5cdr_scibert.uncased_modified': 'bert_ner_bc5cdr_chem_modified_scibert_scivocab_uncased_latest',
            'en.ner.scibert.chemical_craft_scibert.imbalanced': 'bert_ner_craft_chem_imbalanced_scibert',
            'en.ner.scibert.chemical_craft_scibert.modified': 'bert_ner_craft_chem_modified_scibert',
            'en.ner.scibert.chemical_craft_scibert.uncased_modified': 'bert_ner_craft_chem_modified_scibert_scivocab_uncased',
            'en.ner.scibert.chemical_craft_scibert.uncased_original': 'bert_ner_craft_chem_original_scibert_scivocab_uncased',
            'en.ner.scibert.chemical_scibert.512d_modified': 'bert_ner_bc4chemd_chem_modified_scibert_512',
            'en.ner.scibert.chemical_scibert.512d_original': 'bert_ner_bc4chemd_chem_original_scibert_512',
            'en.ner.scibert.chemical_scibert.cased_imbalanced': 'bert_ner_bc4chemd_imbalancedscibert_scivocab_cased',
            'en.ner.scibert.chemical_scibert.cased_modified': 'bert_ner_bc4chemd_modified_scibert_scivocab_cased',
            'en.ner.scibert.chemical_scibert.modified': 'bert_ner_bc4chemd_chem_modified_scibert_384',
            'en.ner.scibert.chemical_scibert.original': 'bert_ner_bc4chemd_chem_original_scibert_384',
            'en.ner.scibert.chemical_scibert.original.by_ghadeermobasher': 'bert_ner_original_scibert_bc4chemd',
            'en.ner.scibert.chemical_scibert.original_o.by_ghadeermobasher': 'bert_ner_original_scibert_bc4chemd_o',
            'en.ner.scibert.chemical_scibert_bionlp13cg.512d_original': 'bert_ner_bionlp13cg_chem_chem_original_scibert_512',
            'en.ner.scibert.chemical_scibert_bionlp13cg.cased_imbalanced': 'bert_ner_bionlp13cg_chem_imbalanced_scibert_scivocab_cased',
            'en.ner.scibert.chemical_scibert_bionlp13cg.modified': 'bert_ner_bionlp13cg_chem_modified_scibert',
            'en.ner.scibert.chemical_scibert_bionlp13cg.original': 'bert_ner_bionlp13cg_chem_chem_original_scibert_384',
            'en.ner.scibert.craft_scibert.512d_modified': 'bert_ner_craft_modified_scibert_512',
            'en.ner.scibert.craft_scibert.512d_original': 'bert_ner_craft_original_scibert_512',
            'en.ner.scibert.craft_scibert.modified': 'bert_ner_craft_modified_scibert_384',
            'en.ner.scibert.craft_scibert.original': 'bert_ner_craft_original_scibert_384',
            'en.ner.scibert.scibert.': 'bert_ner_wlt_scibert_linnaeus',
            'en.ner.scibert.scibert.512d_modified': 'bert_ner_bionlp13_modified_scibert_512',
            'en.ner.scibert.scibert.by_icelab': 'bert_ner_spacescibert_cr',
            'en.ner.scibert.scibert.cased': 'bert_ner_scibert_scivocab_cased_sdu21_ai',
            'en.ner.scibert.scibert.cased.by_fran_martinez': 'bert_ner_scibert_scivocab_cased_ner_jnlpba',
            'en.ner.scibert.scibert.modified': 'bert_ner_bionlp13_modified_scibert_384',
            'en.ner.scibert.scibert.original': 'bert_ner_original_scibert_linnaeus',
            'en.ner.scibert.scibert.uncased': 'bert_ner_scibert_scivocab_uncased_sdu21_ai',
            'en.ner.scibert.scibert.uncased_modified': 'bert_ner_bc4_modified_scibert_scivocab_uncased',
            'en.ner.scibert.scibert.uncased_original': 'bert_ner_bc4_original_scibert_scivocab_uncased',
            'en.ner.scibert.scibert.uncased_scivocab_ft_sdu21_ai.by_napsternxg': 'bert_ner_scibert_scivocab_uncased_ft_sdu21_ai',
            'en.ner.scibert.scibert.uncased_scivocab_ft_tv_sdu21_ai.by_napsternxg': 'bert_ner_scibert_scivocab_uncased_ft_tv_sdu21_ai',
            'en.ner.scibert.scibert.uncased_scivocab_tv_sdu21_ai.by_napsternxg': 'bert_ner_scibert_scivocab_uncased_tv_sdu21_ai',
            'en.ner.scibert.scibert_bc2gm.': 'bert_ner_wlt_scibert_bc2gm',
            'en.ner.scibert.scibert_bc2gm.cased_imbalanced': 'bert_ner_bc2gm_gene_imbalancedscibert_scivocab_cased',
            'en.ner.scibert.scibert_bc2gm.cased_modified': 'bert_ner_bc2gm_gene_modified_scibert_scivocab_cased',
            'en.ner.scibert.scibert_bc2gm.original': 'bert_ner_original_scibert_bc2gm',
            'en.ner.scibert.scibert_bionlp13cg.original': 'bert_ner_bionlp13cg_original_scibert_latest',
            'en.ner.scibert.scibert_bionlp13cg.uncased_modified': 'bert_ner_bionlp13cg_modified_scibert_uncased_latest',
            'en.ner.scibert.scibert_ncbi.': 'bert_ner_orignal_scibert_ncbi',
            'en.ner.snips': 'classifierdl_use_snips',
            'en.ner.span_bert.cased_v2_large_finetuned_adverse_drug_event': 'bert_ner_spanbert_large_cased_finetuned_ade_corpus_v2',
            'en.ner.span_bert.conll.cased_base': 'roberta_ner_spanberta_base_cased_ner_conll02',
            'en.ner.span_bert.conll.cased_base_finetuned': 'roberta_ner_spanberta_base_cased_ner_conll02_finetuned_ner',
            'en.ner.stocks_ticker': 'roberta_token_classifier_ticker',
            'en.ner.time': 'roberta_token_classifier_timex_semeval',
            'en.ner.xlm_roberta.base': 'xlm_roberta_base_token_classifier_ontonotes',
            'en.ner.xlm_roberta.conll.base': 'xlm_roberta_base_token_classifier_conll03',
            'en.ner.xlmr_roberta.all_english.uncased_base.by_tner': 'xlmroberta_ner_base_uncased_all_english',
            'en.ner.xlmr_roberta.all_english.uncased_large.by_tner': 'xlmroberta_ner_large_uncased_all_english',
            'en.ner.xlmr_roberta.base': 'xlmroberta_ner_base_bionlp2004',
            'en.ner.xlmr_roberta.base.by_ai4sec': 'xlmroberta_ner_cyner_base',
            'en.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_recipe_all',
            'en.ner.xlmr_roberta.bc5cdr.base': 'xlmroberta_ner_base_bc5cdr',
            'en.ner.xlmr_roberta.bc5cdr.large': 'xlmroberta_ner_tner_large_bc5cdr',
            'en.ner.xlmr_roberta.bc5cdr.uncased_base': 'xlmroberta_ner_base_uncased_bc5cdr',
            'en.ner.xlmr_roberta.bc5cdr.uncased_large': 'xlmroberta_ner_large_uncased_bc5cdr',
            'en.ner.xlmr_roberta.bionlp2004.large.by_tner': 'xlmroberta_ner_large_bionlp2004',
            'en.ner.xlmr_roberta.bionlp2004.uncased_base.by_tner': 'xlmroberta_ner_base_uncased_bionlp2004',
            'en.ner.xlmr_roberta.bionlp2004.uncased_large.by_tner': 'xlmroberta_ner_large_uncased_bionlp2004',
            'en.ner.xlmr_roberta.conll.base': 'xlmroberta_ner_tner_base_conll2003',
            'en.ner.xlmr_roberta.conll.base.by_Yaxin': 'xlmroberta_ner_yaxin_base_conll2003',
            'en.ner.xlmr_roberta.conll.large': 'xlmroberta_ner_large_conll2003',
            'en.ner.xlmr_roberta.conll.large_finetuned': 'xlmroberta_ner_large_finetuned_conll03_english',
            'en.ner.xlmr_roberta.conll.uncased_base': 'xlmroberta_ner_base_uncased_conll2003',
            'en.ner.xlmr_roberta.conll.uncased_large': 'xlmroberta_ner_large_uncased_conll2003',
            'en.ner.xlmr_roberta.large': 'xlmroberta_ner_tner_large_all_english',
            'en.ner.xlmr_roberta.mit_restaurant.uncased_base.by_tner': 'xlmroberta_ner_base_uncased_mit_restaurant',
            'en.ner.xlmr_roberta.mit_restaurant.uncased_large.by_tner': 'xlmroberta_ner_large_uncased_mit_restaurant',
            'en.ner.xlmr_roberta.multiconer_multi.large.by_asahi417': 'xlmroberta_ner_tner_large_multiconer_multi',
            'en.ner.xlmr_roberta.ontonotes5.base.by_asahi417': 'xlmroberta_ner_tner_base_ontonotes5',
            'en.ner.xlmr_roberta.ontonotes5.large.by_asahi417': 'xlmroberta_ner_tner_large_ontonotes5',
            'en.ner.xlmr_roberta.panx.uncased_large.by_tner': 'xlmroberta_ner_large_uncased_panx_dataset',
            'en.ner.xlmr_roberta.panx_dataset.base.by_tner': 'xlmroberta_ner_base_panx_dataset',
            'en.ner.xlmr_roberta.panx_dataset.large.by_tner': 'xlmroberta_ner_large_panx_dataset',
            'en.ner.xlmr_roberta.panx_dataset.uncased_base.by_tner': 'xlmroberta_ner_base_uncased_panx_dataset',
            'en.ner.xlmr_roberta.tner.base.by_asahi417': 'xlmroberta_ner_tner_base_all_english',
            'en.ner.xlmr_roberta.trivia_movie.uncased_base': 'xlmroberta_ner_base_uncased_mit_movie_trivia',
            'en.ner.xlmr_roberta.trivia_movie.uncased_large': 'xlmroberta_ner_large_uncased_mit_movie_trivia',
            'en.ner.xlmr_roberta.uncased_base': 'xlmroberta_ner_tner_base_uncased_ontonotes5',
            'en.ner.xlmr_roberta.uncased_large': 'xlmroberta_ner_tner_large_uncased_ontonotes5',
            'en.ner.xlmr_roberta.wnut2017.base.by_tner': 'xlmroberta_ner_base_wnut2017',
            'en.ner.xlmr_roberta.wnut2017.large.by_tner': 'xlmroberta_ner_large_wnut2017',
            'en.ner.xlmr_roberta.wnut2017.uncased_base.by_tner': 'xlmroberta_ner_base_uncased_wnut2017',
            'en.ner.xlmr_roberta.wnut2017.uncased_large.by_tner': 'xlmroberta_ner_large_uncased_wnut2017',
            'en.ner.xlmr_roberta.xtreme.base_finetuned': 'xlmroberta_ner_cj_mills_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_Neha2608': 'xlmroberta_ner_neha2608_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_V3RX2000': 'xlmroberta_ner_v3rx2000_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_dkasti': 'xlmroberta_ner_dkasti_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_edwardjross': 'xlmroberta_ner_edwardjross_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_flood': 'xlmroberta_ner_flood_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_haesun': 'xlmroberta_ner_haesun_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_iis2009002': 'xlmroberta_ner_iis2009002_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_jgriffi': 'xlmroberta_ner_jgriffi_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_lijingxin': 'xlmroberta_ner_lijingxin_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_moghis': 'xlmroberta_ner_moghis_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_robkayinto': 'xlmroberta_ner_robkayinto_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_skr3178': 'xlmroberta_ner_skr3178_base_finetuned_panx',
            'en.ner.xlmr_roberta.xtreme.base_finetuned.by_transformersbook': 'xlmroberta_ner_transformersbook_base_finetuned_panx',
            'en.ngram': 'ngram',
            'en.norm': 'norm',
            'en.pos': 'pos_atis',
            'en.pos.anc': 'pos_anc',
            'en.pos.atis': 'pos_atis',
            'en.pos.ewt': 'pos_ewt',
            'en.pos.gum': 'pos_gum',
            'en.pos.lines': 'pos_lines',
            'en.pos.partut': 'pos_partut',
            'en.pos.roberta_base_english_upos': 'roberta_pos_roberta_base_english_upos',
            'en.pos.roberta_large_english_upos': 'roberta_pos_roberta_large_english_upos',
            'en.pos.ud_ewt': 'pos_ud_ewt',
            'en.sentiment.imdb.glove': 'sentimentdl_glove_imdb',
            'en.sentiment.imdb.use.dl': 'sentimentdl_use_imdb',
            'en.sentiment.twitter.dl': 'sentimentdl_use_twitter',
            'en.sentiment.twitter.use.dl': 'sentimentdl_use_twitter',
            'en.sentiment.vivekn': 'sentiment_vivekn',
            'en.span_question.albert': 'albert_base_qa_squad2',
            'en.speech2text.accents.wav2vec2.v2.by_willcai': 'asr_wav2vec2_common_voice_accents_3',
            'en.speech2text.accents_indian.wav2vec2.v2.by_willcai': 'asr_wav2vec2_common_voice_accents_indian',
            'en.speech2text.bilal.wav2vec2.v2.by_roshana': 'asr_wav2vec2_bilal_2022',
            'en.speech2text.cetuc_sid_voxforge.wav2vec2.v2_mls0.by_joaoalvarenga': 'asr_wav2vec2_cetuc_sid_voxforge_mls_0',
            'en.speech2text.cetuc_sid_voxforge.wav2vec2.v2_mls1.by_joaoalvarenga': 'asr_wav2vec2_cetuc_sid_voxforge_mls_1',
            'en.speech2text.coralwav2vec2.v2.by_joaoalvarenga': 'asr_wav2vec2_coral_300ep',
            'en.speech2text.dansk.wav2vec2.v2.by_siyam': 'asr_dansk_wav2vec21',
            'en.speech2text.dansk.wav2vec2.v2.stt.by_siyam': 'asr_dansk_wav2vec2_stt',
            'en.speech2text.wav2vec2': 'asr_part1',
            'en.speech2text.wav2vec2.aa_v2_large_gpu': 'asr_wav2vec2_large_a_gpu',
            'en.speech2text.wav2vec2.accents.v2_gpu.by_willcai': 'asr_wav2vec2_common_voice_accents_3_gpu',
            'en.speech2text.wav2vec2.aug.v2_gpu.by_roshana': 'asr_wav2vec2_25_1aug_2022_gpu',
            'en.speech2text.wav2vec2.bilal.v2_gpu.by_roshana': 'asr_wav2vec2_bilal_2022_gpu',
            'en.speech2text.wav2vec2.by_abhishek': 'asr_autonlp_hindi_asr',
            'en.speech2text.wav2vec2.by_behroz': 'asr_sp_proj',
            'en.speech2text.wav2vec2.by_bilalahmed15': 'asr_urdu_repo',
            'en.speech2text.wav2vec2.by_birgermoell': 'asr_liepa_lithuanian',
            'en.speech2text.wav2vec2.by_bkh6722': 'asr_bach_arb',
            'en.speech2text.wav2vec2.by_buidung2004': 'asr_maialong_model',
            'en.speech2text.wav2vec2.by_denden': 'asr_iloko',
            'en.speech2text.wav2vec2.by_fractalego': 'asr_personal_speech_text_model',
            'en.speech2text.wav2vec2.by_hf_internal_testing': 'asr_processor_with_lm',
            'en.speech2text.wav2vec2.by_khady': 'asr_wolof_asr',
            'en.speech2text.wav2vec2.by_lilitket': 'asr_20220507_122935',
            'en.speech2text.wav2vec2.by_mimi': 'asr_wynehills_mimi_asr',
            'en.speech2text.wav2vec2.by_nuwaisir': 'asr_quran_speech_recognizer',
            'en.speech2text.wav2vec2.by_sania67': 'asr_fine_tunning_on_cv_dataset',
            'en.speech2text.wav2vec2.by_talha': 'asr_urdu_asr',
            'en.speech2text.wav2vec2.by_tarakki100': 'asr_sanskrit',
            'en.speech2text.wav2vec2.by_ying_tina': 'asr_temp',
            'en.speech2text.wav2vec2.crypto.v2_finetuned': 'asr_wav2vec_finetuned_on_cryptocurrency',
            'en.speech2text.wav2vec2.crypto.v2_finetuned_gpu': 'asr_wav2vec_finetuned_on_cryptocurrency_gpu',
            'en.speech2text.wav2vec2.dansk.v2_gpu.by_siyam': 'asr_dansk_wav2vec21_gpu',
            'en.speech2text.wav2vec2.dansk.v2_stt_gpu.by_siyam': 'asr_dansk_wav2vec2_stt_gpu',
            'en.speech2text.wav2vec2.distilled_v2': 'asr_distil_wav2vec2',
            'en.speech2text.wav2vec2.distilled_v2_gpu': 'asr_distil_wav2vec2_gpu',
            'en.speech2text.wav2vec2.finetuned': 'asr_finetuned_audio_transcriber',
            'en.speech2text.wav2vec2.gpu': 'asr_quran_speech_recognizer_gpu',
            'en.speech2text.wav2vec2.gpu.by_abhishek': 'asr_autonlp_hindi_asr_gpu',
            'en.speech2text.wav2vec2.gpu.by_behroz': 'asr_sp_proj_gpu',
            'en.speech2text.wav2vec2.gpu.by_bilalahmed15': 'asr_urdu_repo_gpu',
            'en.speech2text.wav2vec2.gpu.by_birgermoell': 'asr_liepa_lithuanian_gpu',
            'en.speech2text.wav2vec2.gpu.by_bkh6722': 'asr_bach_arb_gpu',
            'en.speech2text.wav2vec2.gpu.by_buidung2004': 'asr_maialong_model_gpu',
            'en.speech2text.wav2vec2.gpu.by_denden': 'asr_iloko_gpu',
            'en.speech2text.wav2vec2.gpu.by_fractalego': 'asr_personal_speech_text_model_gpu',
            'en.speech2text.wav2vec2.gpu.by_hf_internal_testing': 'asr_processor_with_lm_gpu',
            'en.speech2text.wav2vec2.gpu.by_joaoalvarenga': 'asr_model_sid_voxforge_cetuc_1_gpu',
            'en.speech2text.wav2vec2.gpu.by_khady': 'asr_wolof_asr_gpu',
            'en.speech2text.wav2vec2.gpu.by_sania67': 'asr_fine_tunning_on_cv_dataset_gpu',
            'en.speech2text.wav2vec2.gpu.by_talha': 'asr_urdu_asr_gpu',
            'en.speech2text.wav2vec2.gpu.by_tarakki100': 'asr_sanskrit_gpu',
            'en.speech2text.wav2vec2.gpu.by_ying_tina': 'asr_temp_gpu',
            'en.speech2text.wav2vec2.gpu.by_zasheza': 'asr_part1_gpu',
            'en.speech2text.wav2vec2.gpu.v1.by_niclas': 'asr_model_2_gpu',
            'en.speech2text.wav2vec2.gpu.v2.by_niclas': 'asr_model_4_gpu',
            'en.speech2text.wav2vec2.gpu.v3.by_niclas': 'asr_models_6_gpu',
            'en.speech2text.wav2vec2.gram.v2_base_100h_gpu.by_saahith': 'asr_wav2vec2_base_100h_ngram_gpu',
            'en.speech2text.wav2vec2.indian.v2_gpu.by_harveenchadha': 'asr_vakyansh_wav2vec2_indian_english_enm_700_gpu',
            'en.speech2text.wav2vec2.indian_accents.v2_gpu.by_willcai': 'asr_wav2vec2_common_voice_accents_indian_gpu',
            'en.speech2text.wav2vec2.ksponspeech.v2': 'asr_wav2vec2_ksponspeech',
            'en.speech2text.wav2vec2.ksponspeech.v2_gpu': 'asr_wav2vec2_ksponspeech_gpu',
            'en.speech2text.wav2vec2.libri.v2_large_960h.by_facebook': 'asr_wav2vec2_large_robust_libri_960h',
            'en.speech2text.wav2vec2.maithili.v2.by_harveenchadha': 'asr_vakyansh_wav2vec2_maithili_maim_50',
            'en.speech2text.wav2vec2.maithili.v2_gpu.by_harveenchadha': 'asr_vakyansh_wav2vec2_maithili_maim_50_gpu',
            'en.speech2text.wav2vec2.murad.v2_data_gpu.by_mbmmurad': 'asr_wav2vec2_murad_with_some_data_gpu',
            'en.speech2text.wav2vec2.murad.v2_gpu.by_mbmmurad': 'asr_wav2vec2_murad_gpu',
            'en.speech2text.wav2vec2.ngram.v2_base_100h.by_saahith': 'asr_wav2vec2_base_100h_ngram',
            'en.speech2text.wav2vec2.sanskrit.v2.by_harveenchadha': 'asr_vakyansh_wav2vec2_sanskrit_sam_60',
            'en.speech2text.wav2vec2.sanskrit.v2_gpu.by_harveenchadha': 'asr_vakyansh_wav2vec2_sanskrit_sam_60_gpu',
            'en.speech2text.wav2vec2.telgu.v2_gpu.by_harveenchadha': 'asr_vakyansh_wav2vec2_telugu_tem_100_gpu',
            'en.speech2text.wav2vec2.test.v2_base_100h.by_saahith': 'asr_wav2vec2_base_100h_test',
            'en.speech2text.wav2vec2.test.v2_base_100h_gpu.by_saahith': 'asr_wav2vec2_base_100h_test_gpu',
            'en.speech2text.wav2vec2.timit.v2_base': 'asr_wav2vec2_base_timit_asr',
            'en.speech2text.wav2vec2.timit.v2_base.by_patrickvonplaten': 'asr_wav2vec2_base_timit_demo_by_patrickvonplaten',
            'en.speech2text.wav2vec2.timit.v2_base.by_prows12': 'asr_wav2vec2_base_timit_demo_test_jong',
            'en.speech2text.wav2vec2.timit.v2_base.by_shields': 'asr_wav2vec2_base_20sec_timit_and_dementiabank',
            'en.speech2text.wav2vec2.timit.v2_base_32d_colab': 'asr_wav2vec2_base_timit_demo_colab_32_epochs30',
            'en.speech2text.wav2vec2.timit.v2_base_32d_colab.by_ying_tina': 'asr_wav2vec2_base_timit_demo_colab_32_epochs50_earlystop',
            'en.speech2text.wav2vec2.timit.v2_base_32d_gpu_colab': 'asr_wav2vec2_base_timit_demo_colab_32_epochs30_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_32d_gpu_colab.by_ying_tina': 'asr_wav2vec2_base_timit_demo_colab_32_epochs50_earlystop_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_adverse_drug_event_colab': 'asr_wav2vec2_base_timit_demo_google_colab_by_adelgalu',
            'en.speech2text.wav2vec2.timit.v2_base_adverse_drug_event_gpu_colab': 'asr_wav2vec2_base_timit_demo_google_colab_by_adelgalu_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_colab': 'asr_wav2vec2_base_timit_ali_hasan_colab_ex2',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_MoHai': 'asr_wav2vec2_base_timit_demo_colab_by_mohai',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_Sarahliu186': 'asr_wav2vec2_base_timit_demo_colab_by_sarahliu186',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_ali221000262': 'asr_wav2vec2_base_timit_demo_colab_by_ali221000262',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_anan0329': 'asr_wav2vec2_base_timit_demo_colab_by_anan0329',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_doddle124578': 'asr_wav2vec2_base_timit_demo_colab_1_by_doddle124578',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_gullenasatish': 'asr_wav2vec2_base_timit_demo_colab_by_gullenasatish',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_hady': 'asr_wav2vec2_base_timit_demo_colab_by_hady',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_izzy_lazerson': 'asr_wav2vec2_base_timit_demo_colab_by_izzy_lazerson',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_jessiejohnson': 'asr_wav2vec2_base_timit_demo_colab_by_jessiejohnson',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_nadaAlnada': 'asr_wav2vec2_base_timit_demo_colab_by_nadaalnada',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_ntp0102': 'asr_wav2vec2_base_timit_demo_colab_by_ntp0102',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_patrickvonplaten': 'asr_wav2vec2_base_timit_demo_google_colab_by_patrickvonplaten',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_radhakri119': 'asr_wav2vec2_base_timit_demo_colab_by_radhakri119',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_samantharhay': 'asr_wav2vec2_base_timit_demo_colab_by_samantharhay',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_terri1102': 'asr_wav2vec2_base_timit_demo_colab_by_terri1102',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_testimonial': 'asr_wav2vec2_base_timit_demo_colab_by_testimonial',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_tingtingyuli': 'asr_wav2vec2_base_timit_demo_colab_by_tingtingyuli',
            'en.speech2text.wav2vec2.timit.v2_base_colab.by_ying_tina': 'asr_wav2vec2_base_timit_demo_colab_test',
            'en.speech2text.wav2vec2.timit.v2_base_colab0': 'asr_wav2vec2_base_timit_demo_colab0_by_cuzeverynameistaken',
            'en.speech2text.wav2vec2.timit.v2_base_colab0.by_hassnain': 'asr_wav2vec2_base_timit_demo_colab0_by_hassnain',
            'en.speech2text.wav2vec2.timit.v2_base_colab0.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab0_by_sherry7144',
            'en.speech2text.wav2vec2.timit.v2_base_colab0.by_tahazakir': 'asr_wav2vec2_base_timit_demo_colab0_by_tahazakir',
            'en.speech2text.wav2vec2.timit.v2_base_colab1': 'asr_wav2vec2_base_timit_demo_colab1_by_cuzeverynameistaken',
            'en.speech2text.wav2vec2.timit.v2_base_colab1.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab1_by_sherry7144',
            'en.speech2text.wav2vec2.timit.v2_base_colab1.by_tahazakir': 'asr_wav2vec2_base_timit_demo_colab1_by_tahazakir',
            'en.speech2text.wav2vec2.timit.v2_base_colab10': 'asr_wav2vec2_base_timit_demo_colab10',
            'en.speech2text.wav2vec2.timit.v2_base_colab11': 'asr_wav2vec2_base_timit_demo_colab11_by_sameearif88',
            'en.speech2text.wav2vec2.timit.v2_base_colab2': 'asr_wav2vec2_base_timit_demo_colab2_by_ahmad573',
            'en.speech2text.wav2vec2.timit.v2_base_colab2.by_hassnain': 'asr_wav2vec2_base_timit_demo_colab2_by_hassnain',
            'en.speech2text.wav2vec2.timit.v2_base_colab2.by_sameearif88': 'asr_wav2vec2_base_timit_demo_colab2_by_sameearif88',
            'en.speech2text.wav2vec2.timit.v2_base_colab2.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab2_by_sherry7144',
            'en.speech2text.wav2vec2.timit.v2_base_colab240': 'asr_wav2vec2_base_timit_demo_colab240',
            'en.speech2text.wav2vec2.timit.v2_base_colab3': 'asr_wav2vec2_base_timit_demo_colab3_by_hassnain',
            'en.speech2text.wav2vec2.timit.v2_base_colab3.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab3_by_sherry7144',
            'en.speech2text.wav2vec2.timit.v2_base_colab30': 'asr_wav2vec2_base_timit_demo_colab30',
            'en.speech2text.wav2vec2.timit.v2_base_colab4': 'asr_wav2vec2_base_timit_demo_colab4',
            'en.speech2text.wav2vec2.timit.v2_base_colab40': 'asr_wav2vec2_base_timit_demo_colab40',
            'en.speech2text.wav2vec2.timit.v2_base_colab50': 'asr_wav2vec2_base_timit_demo_colab50',
            'en.speech2text.wav2vec2.timit.v2_base_colab51': 'asr_wav2vec2_base_timit_demo_colab51',
            'en.speech2text.wav2vec2.timit.v2_base_colab52': 'asr_wav2vec2_base_timit_demo_colab52',
            'en.speech2text.wav2vec2.timit.v2_base_colab53': 'asr_wav2vec2_base_timit_demo_colab53_by_hassnain',
            'en.speech2text.wav2vec2.timit.v2_base_colab57': 'asr_wav2vec2_base_timit_demo_colab57',
            'en.speech2text.wav2vec2.timit.v2_base_colab6': 'asr_wav2vec2_base_timit_demo_colab6_by_hassnain',
            'en.speech2text.wav2vec2.timit.v2_base_colab647': 'asr_wav2vec2_base_timit_demo_colab647',
            'en.speech2text.wav2vec2.timit.v2_base_colab66': 'asr_wav2vec2_base_timit_demo_colab66',
            'en.speech2text.wav2vec2.timit.v2_base_colab7': 'asr_wav2vec2_base_timit_demo_colab7_by_hassnain',
            'en.speech2text.wav2vec2.timit.v2_base_colab7.by_sameearif88': 'asr_wav2vec2_base_timit_demo_colab7_by_sameearif88',
            'en.speech2text.wav2vec2.timit.v2_base_colab70': 'asr_wav2vec2_base_timit_demo_colab70',
            'en.speech2text.wav2vec2.timit.v2_base_colab9': 'asr_wav2vec2_base_timit_demo_colab9',
            'en.speech2text.wav2vec2.timit.v2_base_colab90': 'asr_wav2vec2_base_timit_demo_colab90',
            'en.speech2text.wav2vec2.timit.v2_base_colab92': 'asr_wav2vec2_base_timit_demo_colab92',
            'en.speech2text.wav2vec2.timit.v2_base_colab971': 'asr_wav2vec2_base_timit_demo_colab971',
            'en.speech2text.wav2vec2.timit.v2_base_exp1.by_moaiz237': 'asr_wav2vec2_base_timit_moaiz_exp1',
            'en.speech2text.wav2vec2.timit.v2_base_exp2.by_moaiz237': 'asr_wav2vec2_base_timit_moaiz_exp2',
            'en.speech2text.wav2vec2.timit.v2_base_explast.by_moaiz237': 'asr_wav2vec2_base_timit_moaiz_explast',
            'en.speech2text.wav2vec2.timit.v2_base_gpu': 'asr_wav2vec2_base_timit_asr_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu.by_moaiz237': 'asr_wav2vec2_base_timit_moaiz_explast_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu.by_patrickvonplaten': 'asr_wav2vec2_base_timit_demo_by_patrickvonplaten_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu.by_prows12': 'asr_wav2vec2_base_timit_demo_test_jong_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu.by_shields': 'asr_wav2vec2_base_20sec_timit_and_dementiabank_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab': 'asr_wav2vec2_base_timit_ali_hasan_colab_ex2_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_MoHai': 'asr_wav2vec2_base_timit_demo_colab_by_mohai_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_anan0329': 'asr_wav2vec2_base_timit_demo_colab_by_anan0329_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_doddle124578': 'asr_wav2vec2_base_timit_demo_colab_by_doddle124578_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_gullenasatish': 'asr_wav2vec2_base_timit_demo_colab_by_gullenasatish_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_hady': 'asr_wav2vec2_base_timit_demo_colab_by_hady_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_izzy_lazerson': 'asr_wav2vec2_base_timit_demo_colab_by_izzy_lazerson_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_jessiejohnson': 'asr_wav2vec2_base_timit_demo_colab_by_jessiejohnson_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_nadaAlnada': 'asr_wav2vec2_base_timit_demo_colab_by_nadaalnada_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_ntp0102': 'asr_wav2vec2_base_timit_demo_colab_by_ntp0102_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_patrickvonplaten': 'asr_wav2vec2_base_timit_demo_google_colab_by_patrickvonplaten_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_radhakri119': 'asr_wav2vec2_base_timit_demo_colab_by_radhakri119_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_samantharhay': 'asr_wav2vec2_base_timit_demo_colab_by_samantharhay_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_testimonial': 'asr_wav2vec2_base_timit_demo_colab_by_testimonial_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_tingtingyuli': 'asr_wav2vec2_base_timit_demo_colab_by_tingtingyuli_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab.by_ying_tina': 'asr_wav2vec2_base_timit_demo_colab_test_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab0': 'asr_wav2vec2_base_timit_demo_colab0_by_cuzeverynameistaken_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab0.by_hassnain': 'asr_wav2vec2_base_timit_demo_colab0_by_hassnain_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab0.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab0_by_sherry7144_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab0.by_tahazakir': 'asr_wav2vec2_base_timit_demo_colab0_by_tahazakir_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab1': 'asr_wav2vec2_base_timit_demo_colab1_by_cuzeverynameistaken_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab1.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab1_by_sherry7144_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab1.by_tahazakir': 'asr_wav2vec2_base_timit_demo_colab1_by_tahazakir_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab10': 'asr_wav2vec2_base_timit_demo_colab10_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab2': 'asr_wav2vec2_base_timit_demo_colab2_by_ahmad573_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab2.by_sherry7144': 'asr_wav2vec2_base_timit_demo_colab2_by_sherry7144_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab3': 'asr_wav2vec2_base_timit_demo_colab3_by_hassnain_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab4': 'asr_wav2vec2_base_timit_demo_colab4_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab40': 'asr_wav2vec2_base_timit_demo_colab40_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab50': 'asr_wav2vec2_base_timit_demo_colab50_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab51': 'asr_wav2vec2_base_timit_demo_colab51_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab53': 'asr_wav2vec2_base_timit_demo_colab53_by_hassnain_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab6': 'asr_wav2vec2_base_timit_demo_colab6_by_hassnain_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab7': 'asr_wav2vec2_base_timit_demo_colab7_by_hassnain_gpu',
            'en.speech2text.wav2vec2.timit.v2_base_gpu_colab9': 'asr_wav2vec2_base_timit_demo_colab9_gpu',
            'en.speech2text.wav2vec2.timit.v2_large': 'asr_wav2vec2_large_lv60_timit_asr',
            'en.speech2text.wav2vec2.timit.v2_large_gpu': 'asr_wav2vec2_large_lv60_timit_asr_gpu',
            'en.speech2text.wav2vec2.timit.v3_base_colab.by_doddle124578': 'asr_wav2vec2_base_timit_demo_colab_2',
            'en.speech2text.wav2vec2.timit.v4_base_colab.by_doddle124578': 'asr_wav2vec2_base_timit_demo_colab_3',
            'en.speech2text.wav2vec2.timit.v5_base_colab.by_doddle124578': 'asr_wav2vec2_base_timit_demo_colab_by_doddle124578',
            'en.speech2text.wav2vec2.v1.by_niclas': 'asr_model_2',
            'en.speech2text.wav2vec2.v2': 'asr_asr_with_transformers_wav2vec2',
            'en.speech2text.wav2vec2.v2.by_ai4bharat': 'asr_indicwav2vec_v1_bengali',
            'en.speech2text.wav2vec2.v2.by_anjulrajendrasharma': 'asr_wav2vec2_indian_english',
            'en.speech2text.wav2vec2.v2.by_burakyldrm': 'asr_wav2vec2_burak_v2.1',
            'en.speech2text.wav2vec2.v2.by_gngpostalsrvc': 'asr_w2v2_ami',
            'en.speech2text.wav2vec2.v2.by_hoangbinhmta99': 'asr_wav2vec_demo',
            'en.speech2text.wav2vec2.v2.by_itaihay': 'asr_wav2vec_asr_swbd',
            'en.speech2text.wav2vec2.v2.by_mbmmurad': 'asr_wav2vec2_murad_with_some_data',
            'en.speech2text.wav2vec2.v2.by_neelan_elucidate_ai': 'asr_wav2vec2_tcrs_runtest',
            'en.speech2text.wav2vec2.v2.by_niclas': 'asr_model_4',
            'en.speech2text.wav2vec2.v2.by_raffay': 'asr_final_wav2vec2_urdu_asr_project',
            'en.speech2text.wav2vec2.v2.by_rattana': 'asr_wav2vec2_thai_asr',
            'en.speech2text.wav2vec2.v2.by_roshana': 'asr_wav2vec2_25_1aug_2022',
            'en.speech2text.wav2vec2.v2.by_snehatyagi': 'asr_wav2vec2_test',
            'en.speech2text.wav2vec2.v2.by_thunninoi': 'asr_wav2vec2_japanese_hiragana_vtuber',
            'en.speech2text.wav2vec2.v2.by_urukhan': 'asr_wav2vec2_russian',
            'en.speech2text.wav2vec2.v2_20epoch': 'asr_wav2vec2_bilal_20epoch',
            'en.speech2text.wav2vec2.v2_20epoch_gpu': 'asr_wav2vec2_bilal_20epoch_gpu',
            'en.speech2text.wav2vec2.v2_ami_gpu.by_gngpostalsrvc': 'asr_w2v2_ami_gpu',
            'en.speech2text.wav2vec2.v2_base': 'asr_wav2vec2_base_checkpoint_10',
            'en.speech2text.wav2vec2.v2_base.by_cahya': 'asr_wav2vec2_base_test',
            'en.speech2text.wav2vec2.v2_base.by_huyue012': 'asr_wav2vec2_base_cynthia_tedlium_2500_v2',
            'en.speech2text.wav2vec2.v2_base.by_rjrohit': 'asr_wav2vec2_base_rj_try_5',
            'en.speech2text.wav2vec2.v2_base.by_sanchit_gandhi': 'asr_wav2vec2_ctc_earnings22_baseline_5_gram',
            'en.speech2text.wav2vec2.v2_base_10000.by_jiobiala24': 'asr_wav2vec2_base_10000',
            'en.speech2text.wav2vec2.v2_base_10000_gpu.by_jiobiala24': 'asr_wav2vec2_base_10000_gpu',
            'en.speech2text.wav2vec2.v2_base_100h': 'asr_wav2vec2_base_100h_by_facebook',
            'en.speech2text.wav2vec2.v2_base_100h.by_gorkemgoknar': 'asr_wav2vec2_base_100h_with_lm_turkish',
            'en.speech2text.wav2vec2.v2_base_100h.by_patrickvonplaten': 'asr_wav2vec2_base_100h_with_lm_by_patrickvonplaten',
            'en.speech2text.wav2vec2.v2_base_100h.by_saahith': 'asr_wav2vec2_base_100h_with_lm_by_saahith',
            'en.speech2text.wav2vec2.v2_base_100h.by_vuiseng9': 'asr_wav2vec2_base_100h_by_vuiseng9',
            'en.speech2text.wav2vec2.v2_base_100h_13k_steps.by_patrickvonplaten': 'asr_wav2vec2_base_100h_13k_steps',
            'en.speech2text.wav2vec2.v2_base_100h_13ksteps_gpu.by_patrickvonplaten': 'asr_wav2vec2_base_100h_13k_steps_gpu',
            'en.speech2text.wav2vec2.v2_base_100h_gpu': 'asr_wav2vec2_base_100h_by_facebook_gpu',
            'en.speech2text.wav2vec2.v2_base_100h_gpu.by_gorkemgoknar': 'asr_wav2vec2_base_100h_with_lm_turkish_gpu',
            'en.speech2text.wav2vec2.v2_base_100h_gpu.by_patrickvonplaten': 'asr_wav2vec2_base_100h_with_lm_by_patrickvonplaten_gpu',
            'en.speech2text.wav2vec2.v2_base_100h_gpu.by_saahith': 'asr_wav2vec2_base_100h_with_lm_by_saahith_gpu',
            'en.speech2text.wav2vec2.v2_base_3percent': 'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_3percent',
            'en.speech2text.wav2vec2.v2_base_3percent_gpu': 'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_3percent_gpu',
            'en.speech2text.wav2vec2.v2_base_5percent': 'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_5percent',
            'en.speech2text.wav2vec2.v2_base_5percent_gpu': 'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_5percent_gpu',
            'en.speech2text.wav2vec2.v2_base_960h': 'asr_wav2vec2_base_960h_4_gram',
            'en.speech2text.wav2vec2.v2_base_960h.by_facebook': 'asr_wav2vec2_base_960h_by_facebook',
            'en.speech2text.wav2vec2.v2_base_960h_gpu': 'asr_wav2vec2_base_960h_by_facebook_gpu',
            'en.speech2text.wav2vec2.v2_base_960h_gpu.by_patrickvonplaten': 'asr_wav2vec2_base_960h_4_gram_gpu',
            'en.speech2text.wav2vec2.v2_base_checkpoint14.by_jiobiala24': 'asr_wav2vec2_base_checkpoint_14',
            'en.speech2text.wav2vec2.v2_base_checkpoint_6.by_jiobiala24': 'asr_wav2vec2_base_checkpoint_6',
            'en.speech2text.wav2vec2.v2_base_checkpoint_9.by_jiobiala24': 'asr_wav2vec2_base_checkpoint_9',
            'en.speech2text.wav2vec2.v2_base_colab': 'asr_wav2vec2_base_common_voice_second_colab',
            'en.speech2text.wav2vec2.v2_base_colab.by_thyagosme': 'asr_wav2vec2_base_demo_colab_by_thyagosme',
            'en.speech2text.wav2vec2.v2_base_finetuned': 'asr_wav2vec2_base_finetuned_spgi_speech_dev',
            'en.speech2text.wav2vec2.v2_base_finetuned_gpu': 'asr_wav2vec2_base_finetuned_spgi_speech_dev_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu': 'asr_wav2vec2_ctc_earnings22_baseline_5_gram_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu.by_cahya': 'asr_wav2vec2_base_test_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu.by_huyue012': 'asr_wav2vec2_base_cynthia_tedlium_2500_v2_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu.by_rjrohit': 'asr_wav2vec2_base_rj_try_5_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu_checkpoint_6.by_jiobiala24': 'asr_wav2vec2_base_checkpoint_6_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu_checkpoint_9.by_jiobiala24': 'asr_wav2vec2_base_checkpoint_9_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu_colab': 'asr_wav2vec2_base_nptel_demo_colab_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu_colab.by_thyagosme': 'asr_wav2vec2_base_demo_colab_by_thyagosme_gpu',
            'en.speech2text.wav2vec2.v2_base_gpu_colab.by_zoha': 'asr_wav2vec2_base_common_voice_second_colab_gpu',
            'en.speech2text.wav2vec2.v2_colab': 'asr_wav2vec2_vee_demo_colab',
            'en.speech2text.wav2vec2.v2_enm700.by_harveenchadha': 'asr_vakyansh_wav2vec2_indian_english_enm_700',
            'en.speech2text.wav2vec2.v2_gpu': 'asr_asr_with_transformers_wav2vec2_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_ai4bharat': 'asr_indicwav2vec_v1_bengali_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_anjulrajendrasharma': 'asr_wav2vec2_indian_english_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_burakyldrm': 'asr_wav2vec2_burak_v2.1_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_gngpostalsrvc': 'asr_w2v2_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_hoangbinhmta99': 'asr_wav2vec_demo_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_itaihay': 'asr_wav2vec_asr_swbd_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_joaoalvarenga': 'asr_wav2vec2_coral_300ep_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_neelan_elucidate_ai': 'asr_wav2vec2_tcrs_runtest_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_snehatyagi': 'asr_wav2vec2_test_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_thunninoi': 'asr_wav2vec2_japanese_hiragana_vtuber_gpu',
            'en.speech2text.wav2vec2.v2_gpu.by_urukhan': 'asr_wav2vec2_russian_gpu',
            'en.speech2text.wav2vec2.v2_gpu_colab': 'asr_wav2vec2_vee_demo_colab_gpu',
            'en.speech2text.wav2vec2.v2_large': 'asr_wav2vec2_large_a',
            'en.speech2text.wav2vec2.v2_large.by_crossdelenna': 'asr_wav2vec2_large_in_lm',
            'en.speech2text.wav2vec2.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_english',
            'en.speech2text.wav2vec2.v2_large.by_leonardvorbeck': 'asr_wav2vec2_large_robust_ls960',
            'en.speech2text.wav2vec2.v2_large.by_prajwals': 'asr_wav2vec2_med_custom_train_large',
            'en.speech2text.wav2vec2.v2_large.by_sanchit_gandhi': 'asr_wav2vec2_large_tedlium',
            'en.speech2text.wav2vec2.v2_large_10m': 'asr_wav2vec2_large_10min_lv60_self',
            'en.speech2text.wav2vec2.v2_large_10m_gpu': 'asr_wav2vec2_large_10min_lv60_self_gpu',
            'en.speech2text.wav2vec2.v2_large_300h': 'asr_wav2vec2_large_robust_swbd_300h',
            'en.speech2text.wav2vec2.v2_large_300h_gpu': 'asr_wav2vec2_large_robust_swbd_300h_gpu',
            'en.speech2text.wav2vec2.v2_large_4500h': 'asr_iwslt_asr_wav2vec_large_4500h',
            'en.speech2text.wav2vec2.v2_large_4500h_gpu': 'asr_iwslt_asr_wav2vec_large_4500h_gpu',
            'en.speech2text.wav2vec2.v2_large_960h': 'asr_wav2vec2_large_960h',
            'en.speech2text.wav2vec2.v2_large_960h.by_gxbag': 'asr_wav2vec2_large_960h_lv60_self_with_wikipedia_lm',
            'en.speech2text.wav2vec2.v2_large_960h.by_patrickvonplaten': 'asr_wav2vec2_large_960h_lv60_self_4_gram',
            'en.speech2text.wav2vec2.v2_large_960h_gpu': 'asr_wav2vec2_large_960h_gpu',
            'en.speech2text.wav2vec2.v2_large_960h_gpu.by_facebook': 'asr_wav2vec2_large_960h_lv60_gpu',
            'en.speech2text.wav2vec2.v2_large_960h_gpu.by_gxbag': 'asr_wav2vec2_large_960h_lv60_self_with_wikipedia_lm_gpu',
            'en.speech2text.wav2vec2.v2_large_960h_gpu.by_patrickvonplaten': 'asr_wav2vec2_large_960h_lv60_self_4_gram_gpu',
            'en.speech2text.wav2vec2.v2_large_960h_lv60.by_facebook': 'asr_wav2vec2_large_960h_lv60',
            'en.speech2text.wav2vec2.v2_large_960h_self.by_facebook': 'asr_wav2vec2_large_960h_lv60_self',
            'en.speech2text.wav2vec2.v2_large_960h_self_gpu.by_facebook': 'asr_wav2vec2_large_960h_lv60_self_gpu',
            'en.speech2text.wav2vec2.v2_large_gpu': 'asr_wav2vec2_large_english_gpu',
            'en.speech2text.wav2vec2.v2_large_gpu.by_crossdelenna': 'asr_wav2vec2_large_in_lm_gpu',
            'en.speech2text.wav2vec2.v2_large_gpu.by_leonardvorbeck': 'asr_wav2vec2_large_robust_ls960_gpu',
            'en.speech2text.wav2vec2.v2_large_gpu.by_sanchit_gandhi': 'asr_wav2vec2_large_tedlium_gpu',
            'en.speech2text.wav2vec2.v2_large_roobust_960h_gpu.by_facebook': 'asr_wav2vec2_large_robust_libri_960h_gpu',
            'en.speech2text.wav2vec2.v3.by_niclas': 'asr_models_6',
            'en.speech2text.wav2vec2.voxforge.v2_gpu_mls.by_joaoalvarenga': 'asr_wav2vec2_cetuc_sid_voxforge_mls_0_gpu',
            'en.speech2text.wav2vec2.voxforge_cetuc.v1.by_joaoalvarenga': 'asr_model_sid_voxforge_cetuc_1',
            'en.speech2text.wav2vec2.voxforge_cetuc.v2.by_joaoalvarenga': 'asr_model_sid_voxforge_cetuc_2',
            'en.speech2text.wav2vec2.voxpopuli.v2_base': 'asr_wav2vec2_base_10k_voxpopuli',
            'en.speech2text.wav2vec2.voxpopuli.v2_base_gpu': 'asr_wav2vec2_base_10k_voxpopuli_gpu',
            'en.speech2text.wav2vec_xlsr': 'asr_xlsr_punctuation',
            'en.speech2text.wav2vec_xlsr.300m': 'asr_hausa_4_wa2vec_data_aug_xls_r_300m',
            'en.speech2text.wav2vec_xlsr.300m_gpu': 'asr_hausa_4_wa2vec_data_aug_xls_r_300m_gpu',
            'en.speech2text.wav2vec_xlsr.5h': 'asr_xlsr_53_bemba_5hrs',
            'en.speech2text.wav2vec_xlsr.5h_gpu': 'asr_xlsr_53_bemba_5hrs_gpu',
            'en.speech2text.wav2vec_xlsr.by_akashpb13': 'asr_central_kurdish_xlsr',
            'en.speech2text.wav2vec_xlsr.by_bakhtullah123': 'asr_xls_r_53_english',
            'en.speech2text.wav2vec_xlsr.by_sania67': 'asr_fine_tuned_xlsr_english',
            'en.speech2text.wav2vec_xlsr.egyptian.v2_large.by_othrif': 'asr_wav2vec2_large_xlsr_egyptian',
            'en.speech2text.wav2vec_xlsr.egyptian.v2_large_gpu_egyptian.by_othrif': 'asr_wav2vec2_large_xlsr_egyptian_gpu',
            'en.speech2text.wav2vec_xlsr.gender_male_female.v2_gpu_s287_exp': 'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s287_gpu',
            'en.speech2text.wav2vec_xlsr.gender_male_female.v2_s287_exp': 'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s287',
            'en.speech2text.wav2vec_xlsr.german.v2_300m_gpu.by_aware_ai': 'asr_wav2vec2_xls_r_300m_german_english_gpu',
            'en.speech2text.wav2vec_xlsr.gpu': 'asr_central_kurdish_xlsr_gpu',
            'en.speech2text.wav2vec_xlsr.gpu.by_boris': 'asr_xlsr_punctuation_gpu',
            'en.speech2text.wav2vec_xlsr.gpu.by_sania67': 'asr_fine_tuned_xlsr_english_gpu',
            'en.speech2text.wav2vec_xlsr.hindi.v2_large_300m_colab.by_nimrah': 'asr_wav2vec2_large_xls_r_300m_hindi_home_colab_11',
            'en.speech2text.wav2vec_xlsr.kana.v2_large_300m_gpu_colab.by_pinot': 'asr_wav2vec2_large_xls_r_300m_j_kana_colab_gpu',
            'en.speech2text.wav2vec_xlsr.kana.v3_large_300m_colab.by_pinot': 'asr_wav2vec2_large_xls_r_300m_j_kana_colab',
            'en.speech2text.wav2vec_xlsr.ksponspeech.v2_large': 'asr_wav2vec2_large_xlsr_ksponspeech_1_20',
            'en.speech2text.wav2vec_xlsr.ksponspeech.v2_large_gpu': 'asr_wav2vec2_large_xlsr_ksponspeech_1_20_gpu',
            'en.speech2text.wav2vec_xlsr.l_v2': 'asr_english_filipino_wav2vec2_l_xls_r_test_03',
            'en.speech2text.wav2vec_xlsr.l_v2_300m_gpu_official': 'asr_filipino_wav2vec2_l_xls_r_300m_official_gpu',
            'en.speech2text.wav2vec_xlsr.l_v2_300m_official': 'asr_filipino_wav2vec2_l_xls_r_300m_official',
            'en.speech2text.wav2vec_xlsr.l_v2_gpu': 'asr_english_filipino_wav2vec2_l_xls_r_test_05_gpu',
            'en.speech2text.wav2vec_xlsr.large_v3.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_04',
            'en.speech2text.wav2vec_xlsr.large_v4.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_05',
            'en.speech2text.wav2vec_xlsr.large_v5.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_06',
            'en.speech2text.wav2vec_xlsr.large_v6.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_07',
            'en.speech2text.wav2vec_xlsr.large_v7.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_09',
            'en.speech2text.wav2vec_xlsr.large_v8_gpu.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_07_gpu',
            'en.speech2text.wav2vec_xlsr.large_v9_gpu.by_khalsuu': 'asr_english_filipino_wav2vec2_l_xls_r_test_09_gpu',
            'en.speech2text.wav2vec_xlsr.moroccan.v2_large.by_othrif': 'asr_wav2vec2_large_xlsr_moroccan',
            'en.speech2text.wav2vec_xlsr.moroccan.v2_large_gpu_moroccan.by_othrif': 'asr_wav2vec2_large_xlsr_moroccan_gpu',
            'en.speech2text.wav2vec_xlsr.phon.v2.by_facebook': 'asr_wav2vec2_xlsr_53_phon',
            'en.speech2text.wav2vec_xlsr.phon_babel.v2.by_facebook': 'asr_wav2vec2_xlsr_53_phon_babel',
            'en.speech2text.wav2vec_xlsr.phon_babel_gpu.v2_gpu.by_facebook': 'asr_wav2vec2_xlsr_53_phon_babel_gpu',
            'en.speech2text.wav2vec_xlsr.phon_gpu.v2_gpu.by_facebook': 'asr_wav2vec2_xlsr_53_phon_gpu',
            'en.speech2text.wav2vec_xlsr.phonome.v2_large_300m_gpu_colab.by_pinot': 'asr_wav2vec2_large_xls_r_300m_j_phoneme_colab_gpu',
            'en.speech2text.wav2vec_xlsr.phonome.v3_large_300m_colab.by_pinot': 'asr_wav2vec2_large_xls_r_300m_j_phoneme_colab',
            'en.speech2text.wav2vec_xlsr.slovakian.v2_large.by_jimregan': 'asr_wav2vec2_large_xlsr_slovakian',
            'en.speech2text.wav2vec_xlsr.slovakian.v2_large_gpu.by_jimregan': 'asr_wav2vec2_large_xlsr_slovakian_gpu',
            'en.speech2text.wav2vec_xlsr.timit.v2_base': 'asr_wav2vec2_xls_r_timit_tokenizer_base',
            'en.speech2text.wav2vec_xlsr.timit.v2_base_gpu': 'asr_wav2vec2_xls_r_timit_tokenizer_base_gpu',
            'en.speech2text.wav2vec_xlsr.turkish.v2_large_300m_colab.by_nimrah': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_nimrah',
            'en.speech2text.wav2vec_xlsr.turkish.v2_large_300m_colab_9.by_nimrah': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_9',
            'en.speech2text.wav2vec_xlsr.turkish.v3_large_300m_colab.by_nimrah': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_4',
            'en.speech2text.wav2vec_xlsr.turrkish.v2_300m_gpu.by_emre': 'asr_wav2vec2_xls_r_300m_turkish_tr_med_gpu',
            'en.speech2text.wav2vec_xlsr.upper_sorbian.v2_large_gpu.by_jimregan': 'asr_wav2vec2_large_xlsr_upper_sorbian_mixed_gpu',
            'en.speech2text.wav2vec_xlsr.upper_sorbian_mixed.v2_large.by_jimregan': 'asr_wav2vec2_large_xlsr_upper_sorbian_mixed',
            'en.speech2text.wav2vec_xlsr.urdu.v2_large_300m.by_omar47': 'asr_wav2vec2_large_xls_r_300m_urdu_10',
            'en.speech2text.wav2vec_xlsr.urdu.v3_large_300m.by_omar47': 'asr_wav2vec2_large_xls_r_300m_urdu_v2',
            'en.speech2text.wav2vec_xlsr.v1gpu.by_bakhtullah123': 'asr_xls_r_53_english_gpu',
            'en.speech2text.wav2vec_xlsr.v2': 'asr_wav2vec2_xls_r_1b_english',
            'en.speech2text.wav2vec_xlsr.v2.by_chrisvinsen': 'asr_xlsr_wav2vec2_final',
            'en.speech2text.wav2vec_xlsr.v2.by_harshit345': 'asr_xlsr_wav2vec_english',
            'en.speech2text.wav2vec_xlsr.v2.by_hrdipto': 'asr_wav2vec2_xls_r_tf_left_right_shuru',
            'en.speech2text.wav2vec_xlsr.v2.by_shoubhik': 'asr_wav2vec2_xlsr_bengali_10500',
            'en.speech2text.wav2vec_xlsr.v2.by_slplab': 'asr_wav2vec2_xlsr50k_english_phoneme',
            'en.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_aware_ai': 'asr_wav2vec2_xls_r_300m_german_english',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_comodoro': 'asr_wav2vec2_xls_r_300m_cv8',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_emre': 'asr_wav2vec2_xls_r_300m_turkish_tr_med',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_hrdipto': 'asr_wav2vec2_xls_r_300m_bangla_command_generated_data_finetune',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_kongkeaouch': 'asr_wav2vec2_xls_r_300m_kh',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_malay_huggingface': 'asr_wav2vec2_xls_r_300m_mixed_by_malay_huggingface',
            'en.speech2text.wav2vec_xlsr.v2_300m.by_shoubhik': 'asr_wav2vec2_xls_r_300m_hindi_lm',
            'en.speech2text.wav2vec_xlsr.v2_300m_cv8.by_emre': 'asr_wav2vec2_xls_r_300m_am_cv8_v1',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_cv8_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu.by_aware_ai': 'asr_wav2vec2_xls_r_300m_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu.by_hrdipto': 'asr_wav2vec2_xls_r_300m_bangla_command_generated_data_finetune_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu.by_kongkeaouch': 'asr_wav2vec2_xls_r_300m_kh_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu.by_malay_huggingface': 'asr_wav2vec2_xls_r_300m_mixed_by_malay_huggingface_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu.by_shoubhik': 'asr_wav2vec2_xls_r_300m_hindi_lm_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu.german.by_aware_ai': 'asr_wav2vec2_xls_r_300m_german_gpu',
            'en.speech2text.wav2vec_xlsr.v2_300m_gpu_cv8.by_emre': 'asr_wav2vec2_xls_r_300m_am_cv8_v1_gpu',
            'en.speech2text.wav2vec_xlsr.v2_40m': 'asr_wav2vec2_xlsr50k_korean_phoneme_aihub_40m',
            'en.speech2text.wav2vec_xlsr.v2_40m_gpu': 'asr_wav2vec2_xlsr50k_korean_phoneme_aihub_40m_gpu',
            'en.speech2text.wav2vec_xlsr.v2_base_colab': 'asr_xlsr_wav2vec2_base_commonvoice_demo_colab_4',
            'en.speech2text.wav2vec_xlsr.v2_base_colab.by_chrisvinsen': 'asr_xlsr_wav2vec2_base_commonvoice_demo_colab_6',
            'en.speech2text.wav2vec_xlsr.v2_base_gpu_colab': 'asr_xlsr_wav2vec2_base_commonvoice_demo_colab_4_gpu',
            'en.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xls_r_1b_english_gpu',
            'en.speech2text.wav2vec_xlsr.v2_gpu.by_chrisvinsen': 'asr_xlsr_wav2vec2_final_gpu',
            'en.speech2text.wav2vec_xlsr.v2_gpu.by_harshit345': 'asr_xlsr_wav2vec_english_gpu',
            'en.speech2text.wav2vec_xlsr.v2_gpu.by_hrdipto': 'asr_wav2vec2_xls_r_tf_left_right_shuru_gpu',
            'en.speech2text.wav2vec_xlsr.v2_gpu.by_slplab': 'asr_wav2vec2_xlsr50k_english_phoneme_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xls_r_thai_test',
            'en.speech2text.wav2vec_xlsr.v2_large.by_arbml': 'asr_wav2vec2_large_xlsr_53_arabic_egyptian_by_arbml',
            'en.speech2text.wav2vec_xlsr.v2_large.by_cpierse': 'asr_wav2vec2_large_xlsr_53_irish',
            'en.speech2text.wav2vec_xlsr.v2_large.by_fleek': 'asr_wav2vec_large_xlsr_korean',
            'en.speech2text.wav2vec_xlsr.v2_large.by_gary109': 'asr_ai_light_dance_singing2_wav2vec2_large_xlsr_53_5gram_v4_2',
            'en.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_english_by_jonatasgrosman',
            'en.speech2text.wav2vec_xlsr.v2_large.by_lgris': 'asr_wav2vec2_large_xlsr_coraa_portuguese_cv8',
            'en.speech2text.wav2vec_xlsr.v2_large.by_logicbloke': 'asr_wav2vec2_large_xlsr_53_arabic_by_logicbloke',
            'en.speech2text.wav2vec_xlsr.v2_large.by_patrickvonplaten': 'asr_wav2vec2_large_xlsr_turkish_demo',
            'en.speech2text.wav2vec_xlsr.v2_large.by_sharonibejih': 'asr_wav2vec2_large_xlsr_sermon',
            'en.speech2text.wav2vec_xlsr.v2_large.by_tyoc213': 'asr_wav2vec2_large_xlsr_nahuatl',
            'en.speech2text.wav2vec_xlsr.v2_large.by_voidful': 'asr_wav2vec2_large_xlsr_53_gpt',
            'en.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_cantonese',
            'en.speech2text.wav2vec_xlsr.v2_large_300m.by_abdulqahar47': 'asr_wav2vec2_large_xls_r_300m_hausa_v1.2',
            'en.speech2text.wav2vec_xlsr.v2_large_300m.by_aditya3107': 'asr_wav2vec2_large_xls_r_300m_ie_cv_la_as',
            'en.speech2text.wav2vec_xlsr.v2_large_300m.by_lilitket': 'asr_wav2vec2_large_xls_r_300m_hyam_batch4',
            'en.speech2text.wav2vec_xlsr.v2_large_300m.by_msaudtahir': 'asr_wav2vec2_large_xls_r_300m_urdu_proj',
            'en.speech2text.wav2vec_xlsr.v2_large_300m.by_pavle_tsotskolauri': 'asr_wav2vec2_large_xls_r_300m_georgian_v0.6',
            'en.speech2text.wav2vec_xlsr.v2_large_300m.by_raphaelkalandadze': 'asr_wav2vec2_large_xls_r_300m_georgian_large',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_6h_colab': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_vai6hav',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_6h_gpu_colab': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_vai6hav_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_chaitanya97',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_emeson77': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_emeson77',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_fitods': 'asr_wav2vec2_large_xls_r_300m_guarani_colab',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_izzy_lazerson': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_izzy_lazerson',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_krirk': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_krirk',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_li666': 'asr_wav2vec2_large_xls_r_300m_cn_colab',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_lilitket': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_lilitket',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_masapasa': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_masapasa',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_patrickvonplaten': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_patrickvonplaten',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_robertodtg': 'asr_wav2vec2_large_xls_r_300m_colab_by_robertodtg',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_satyamatury': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_satyamatury',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_shacharm': 'asr_wav2vec2_large_xls_r_300m_english_colab',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_colab.by_tonyalves': 'asr_wav2vec2_large_xls_r_300m_colab_by_tonyalves',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_cantonese_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_abdulqahar47': 'asr_wav2vec2_large_xls_r_300m_hausa_v1.2_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_aditya3107': 'asr_wav2vec2_large_xls_r_300m_ie_cv_la_as_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_lilitket': 'asr_wav2vec2_large_xls_r_300m_hyam_batch4_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_msaudtahir': 'asr_wav2vec2_large_xls_r_300m_urdu_proj_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_omar47': 'asr_wav2vec2_large_xls_r_300m_urdu_10_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_raphaelkalandadze': 'asr_wav2vec2_large_xls_r_300m_georgian_large_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab': 'asr_wav2vec2_large_xls_r_300m_colab_by_robertodtg_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_chaitanya97': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_chaitanya97_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_emeson77': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_emeson77_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_fitods': 'asr_wav2vec2_large_xls_r_300m_guarani_colab_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_izzy_lazerson': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_izzy_lazerson_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_li666': 'asr_wav2vec2_large_xls_r_300m_cn_colab_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_nimrah': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_nimrah_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_patrickvonplaten': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_patrickvonplaten_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_satyamatury': 'asr_wav2vec2_large_xls_r_300m_turkish_colab_by_satyamatury_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_shacharm': 'asr_wav2vec2_large_xls_r_300m_english_colab_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_gpu_colab.by_tonyalves': 'asr_wav2vec2_large_xls_r_300m_colab_by_tonyalves_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_lr4.by_lilitket': 'asr_wav2vec2_large_xls_r_300m_hyam_batch4_lr4',
            'en.speech2text.wav2vec_xlsr.v2_large_300m_lr8.by_lilitket': 'asr_wav2vec2_large_xls_r_300m_hyam_batch4_lr8',
            'en.speech2text.wav2vec_xlsr.v2_large_colab': 'asr_wav2vec2_large_xlsr_53_demo_colab_by_project2you',
            'en.speech2text.wav2vec_xlsr.v2_large_colab.by_rafiulrumy': 'asr_wav2vec2_large_xlsr_hindi_demo_colab_by_rafiulrumy',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_english_by_jonatasgrosman_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_arbml': 'asr_wav2vec2_large_xlsr_53_arabic_egyptian_by_arbml_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_cpierse': 'asr_wav2vec2_large_xlsr_53_irish_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_fleek': 'asr_wav2vec_large_xlsr_korean_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_gary109': 'asr_ai_light_dance_singing2_wav2vec2_large_xlsr_53_5gram_v4_2_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_logicbloke': 'asr_wav2vec2_large_xlsr_53_arabic_by_logicbloke_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_patrickvonplaten': 'asr_wav2vec2_large_xlsr_turkish_demo_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_sharonibejih': 'asr_wav2vec2_large_xlsr_sermon_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_tyoc213': 'asr_wav2vec2_large_xlsr_nahuatl_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu.by_voidful': 'asr_wav2vec2_large_xlsr_53_gpt_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_gpu_colab': 'asr_wav2vec2_large_xlsr_53_demo_colab_by_project2you_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_small_300m': 'asr_wav2vec2_large_xls_r_300m_guarani_small_by_jhonparra18',
            'en.speech2text.wav2vec_xlsr.v2_large_small_300m.by_tomascufaro': 'asr_wav2vec2_large_xls_r_300m_spanish_small_by_tomascufaro',
            'en.speech2text.wav2vec_xlsr.v2_large_small_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_spanish_small_by_tomascufaro_gpu',
            'en.speech2text.wav2vec_xlsr.v2_large_small_300m_gpu.by_jhonparra18': 'asr_wav2vec2_large_xls_r_300m_guarani_small_by_jhonparra18_gpu',
            'en.speech2text.wav2vec_xlsr.v2_multilingual': 'asr_wav2vec2_xlsr_multilingual_53',
            'en.speech2text.wav2vec_xlsr.v2_multilingual_gpu': 'asr_wav2vec2_xlsr_multilingual_53_gpu',
            'en.speech2text.wav2vec_xlsr.v2gpu.by_bakhtullah123': 'asr_xlsr_training_gpu',
            'en.spell.norvig': 'spellcheck_norvig',
            'en.stem': 'stemmer',
            'en.stopwords': 'stopwords_iso',
            'en.stopwords.iso': 'stopwords_iso',
            'en.t5': 'google_t5_small_ssm_nq',
            'en.t5.active_to_passive_styletransfer': 't5_active_to_passive_styletransfer',
            'en.t5.base': 't5_base',
            'en.t5.formal_to_informal_styletransfer': 't5_formal_to_informal_styletransfer',
            'en.t5.grammar_error_corrector': 't5_grammar_error_corrector',
            'en.t5.informal_to_formal_styletransfer': 't5_informal_to_formal_styletransfer',
            'en.t5.passive_to_active_styletransfer': 't5_passive_to_active_styletransfer',
            'en.t5.small': 't5_small',
            'en.t5.small.generation': 't5_question_generation_small',
            'en.t5.wikiSQL': 't5_small_wikiSQL',
            'en.tokenize': 'spark_nlp_tokenizer',
            'en.toxic': 'multiclassifierdl_use_toxic',
            'en.use': 'tfhub_use',
            'en.xlnet': 'xlnet_base_cased',
            'en.yake': 'yake',
            'roberta': 'distilroberta_base'},
        'eo': {'eo.embed.w2v_cc_300d': 'w2v_cc_300d',
               'eo.ner.pos.small': 'roberta_pos_esperberto_small_pos',
               'eo.stopwords': 'stopwords_eo'},
        'es': {
            'es.answer_question.bert.cased_base_finetuned': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_tar',
            'es.answer_question.bert.cased_multilingual_base': 'bert_qa_multilingual_bert_base_cased_spanish',
            'es.answer_question.bert.mlqa.cased_base_finetuned': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_mlqa',
            'es.answer_question.bert.mlqa.uncased_base_finetuned': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_mlqa',
            'es.answer_question.bert.sqac.cased_base_finetuned': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_qa_sqac',
            'es.answer_question.bert.sqac.uncased_base_finetuned': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_sqac',
            'es.answer_question.bert.squad_es.uncased_base_finetuned': 'bert_qa_base_spanish_wwm_uncased_finetuned_squad',
            'es.answer_question.bert.uncased_base_finetuned': 'bert_qa_bert_base_spanish_wwm_uncased_finetuned_qa_tar',
            'es.answer_question.distil_bert.base_uncased': 'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_tar',
            'es.answer_question.mlqa.distil_bert.base_uncased': 'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_mlqa',
            'es.answer_question.roberta.base_finetuned': 'roberta_qa_mrm8488_base_bne_finetuned_s_c',
            'es.answer_question.roberta.base_finetuned.by_nlp_en_es': 'roberta_qa_nlp_en_es_base_bne_finetuned_s_c',
            'es.answer_question.roberta.sqac.base': 'roberta_qa_base_spanish_s_c',
            'es.answer_question.roberta.sqac.base.by_bsc_temu': 'roberta_qa_bsc_temu_base_bne_s_c',
            'es.answer_question.roberta.sqac.base.by_plantl_gob_es': 'roberta_qa_plantl_gob_es_base_bne_s_c',
            'es.answer_question.roberta.sqac.large': 'roberta_qa_bsc_temu_large_bne_s_c',
            'es.answer_question.roberta.sqac.large.by_plantl_gob_es': 'roberta_qa_plantl_gob_es_large_bne_s_c',
            'es.answer_question.roberta.sqac.large_finetuned': 'roberta_qa_bertin_large_finetuned_s_c',
            'es.answer_question.roberta.squad.base_finetuned': 'roberta_qa_ruperta_base_finetuned_squadv1',
            'es.answer_question.roberta.squad_es.base': 'roberta_qa_base_bne_squad2',
            'es.answer_question.roberta.squad_es.base.by_jamarju': 'roberta_qa_base_bne_squad_2.0',
            'es.answer_question.roberta.squad_es.base_adverse_drug_event': 'roberta_qa_base_spanish_squades',
            'es.answer_question.roberta.squad_es.large': 'roberta_qa_large_bne_squad_2.0',
            'es.answer_question.roberta.squadv2.v2_base_finetuned': 'roberta_qa_ruperta_base_finetuned_squadv2',
            'es.answer_question.sqac.bert.base': 'bert_qa_beto_base_spanish_sqac',
            'es.answer_question.sqac.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac',
            'es.answer_question.sqac.distil_bert.base_uncased': 'distilbert_qa_distillbert_base_spanish_uncased_finetuned_qa_sqac',
            'es.answer_question.sqac.roberta.base': 'roberta_qa_PlanTL_GOB_ES_roberta_base_bne_sqac',
            'es.answer_question.sqac.roberta.base.by_BSC-TeMU': 'roberta_qa_BSC_TeMU_roberta_base_bne_sqac',
            'es.answer_question.sqac.roberta.base.by_IIC': 'roberta_qa_roberta_base_spanish_sqac',
            'es.answer_question.sqac.roberta.base.by_PlanTL-GOB-ES': 'roberta_qa_PlanTL_GOB_ES_roberta_base_bne_sqac',
            'es.answer_question.sqac.roberta.base.by_mrm8488': 'roberta_qa_mrm8488_roberta_base_bne_finetuned_sqac',
            'es.answer_question.sqac.roberta.base.by_nlp-en-es': 'roberta_qa_nlp_en_es_roberta_base_bne_finetuned_sqac',
            'es.answer_question.sqac.roberta.large': 'roberta_qa_BSC_TeMU_roberta_large_bne_sqac',
            'es.answer_question.sqac.roberta.large.by_BSC-TeMU': 'roberta_qa_BSC_TeMU_roberta_large_bne_sqac',
            'es.answer_question.sqac.roberta.large.by_PlanTL-GOB-ES': 'roberta_qa_PlanTL_GOB_ES_roberta_large_bne_sqac',
            'es.answer_question.sqac.roberta.large.by_nlp-en-es': 'roberta_qa_bertin_large_finetuned_sqac',
            'es.answer_question.squad.electra.small': 'electra_qa_electricidad_small_finetuned_squadv1',
            'es.answer_question.squad.roberta.base': 'roberta_qa_roberta_base_spanish_squades',
            'es.answer_question.squad.roberta.base.by_IIC': 'roberta_qa_roberta_base_spanish_squades',
            'es.answer_question.squad.roberta.base.by_jamarju': 'roberta_qa_roberta_base_bne_squad_2.0_es_jamarju',
            'es.answer_question.squad.roberta.base_4096.by_mrm8488': 'roberta_qa_longformer_base_4096_spanish_finetuned_squad',
            'es.answer_question.squad.roberta.large': 'roberta_qa_roberta_large_fine_tuned_squad_es_stevemobs',
            'es.answer_question.squad.roberta.large.by_jamarju': 'roberta_qa_roberta_large_bne_squad_2.0_es_jamarju',
            'es.answer_question.squad.roberta.large.by_stevemobs': 'roberta_qa_roberta_large_fine_tuned_squad_es_stevemobs',
            'es.answer_question.squad.ruperta.base.by_mrm8488': 'roberta_qa_RuPERTa_base_finetuned_squadv1',
            'es.answer_question.squad_sqac.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac_finetuned_squad',
            'es.answer_question.squadv2.bert.base_cased': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_MMG',
            'es.answer_question.squadv2.bert.base_cased.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_MMG',
            'es.answer_question.squadv2.bert.base_cased.by_mrm8488': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_mrm8488',
            'es.answer_question.squadv2.bert.distilled_base_cased': 'bert_qa_distill_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_mrm8488',
            'es.answer_question.squadv2.electra.small': 'electra_qa_biomedtra_small_es_squad2',
            'es.answer_question.squadv2.roberta.base': 'roberta_qa_roberta_base_bne_squad2_hackathon_pln',
            'es.answer_question.squadv2.roberta.base_v2': 'roberta_qa_RuPERTa_base_finetuned_squadv2',
            'es.answer_question.squadv2_bio_medical.roberta.base': 'roberta_qa_roberta_base_biomedical_es_squad2_hackathon_pln',
            'es.answer_question.squadv2_clinical_bio_medical.roberta.base': 'roberta_qa_roberta_base_biomedical_clinical_es_squad2_hackathon_pln',
            'es.answer_question.squadv2_sqac.bert.base_cased.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_sqac_finetuned_squad2_es_MMG',
            'es.answer_question.squadv2_sqac.bert.base_cased_spa.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_spa_squad2_es_finetuned_sqac',
            'es.answer_question.squadv2_sqac.bert.base_cased_v2.by_MMG': 'bert_qa_bert_base_spanish_wwm_cased_finetuned_squad2_es_finetuned_sqac',
            'es.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_spanish',
            'es.answer_question.xlm_roberta.multilingual_large': 'xlm_roberta_qa_xlm_roberta_large_qa_multilingual_finedtuned_ru_ru_AlexKay',
            'es.answer_question.xlmr_roberta.squad.base': 'xlm_roberta_qa_xlmr_base_texas_squad_es_es_saattrupdan',
            'es.classify.3class_paragraphs.roberta.by_hackathon_pln_es': 'roberta_classifier_readability_es_3class_paragraphs',
            'es.classify.3class_sentences.roberta.by_hackathon_pln_es': 'roberta_classifier_readability_es_3class_sentences',
            'es.classify.bert': 'bert_classifier_autonlp_spanish_songs_202661',
            'es.classify.bert.hate.': 'bert_classifier_dehatebert_mono_spanish',
            'es.classify.bert.news.': 'bert_classifier_spanish_news_classification_headlines',
            'es.classify.bert.news.by_m47labs': 'bert_classifier_spanish_news_classification_headlines_untrained',
            'es.classify.bert.sentiment_hate.finetuned': 'bert_classifier_dehate_mono_spanish_finetuned_sentiments_reviews_politicos',
            'es.classify.bert.tiny_finetuned': 'bert_sequence_classifier_spanish_tinybert_betito_finetuned_mnli',
            'es.classify.bert.xnli.tiny_finetuned': 'bert_sequence_classifier_spanish_tinybert_betito_finetuned_xnli',
            'es.classify.beto_bert': 'bert_sequence_classifier_beto_emotion_analysis',
            'es.classify.beto_bert.by_finiteautomata': 'bert_classifier_beto_emotion_analysis',
            'es.classify.beto_bert.sentiment': 'beto_sentiment',
            'es.classify.beto_bert.sentiment.by_finiteautomata': 'bert_classifier_beto_sentiment_analysis',
            'es.classify.beto_bert.sentiment_analysis': 'bert_sequence_classifier_beto_sentiment_analysis',
            'es.classify.electra.amazon.small_finetuned': 'electra_classifier_mrm8488_electricidad_small_finetuned_amazon_review_classification',
            'es.classify.electra.go_emotions.base_finetuned': 'electra_classifier_electricidad_base_finetuned_go_emotions',
            'es.classify.hate_contextualized.bert.by_finiteautomata': 'bert_classifier_contextualized_hate_speech',
            'es.classify.hate_non_contextualized.bert.by_finiteautomata': 'bert_classifier_non_contextualized_hate_speech',
            'es.classify.readability_paragraphs.roberta.by_hackathon_pln_es': 'roberta_classifier_readability_es_paragraphs',
            'es.classify.readability_sentences.roberta.by_hackathon_pln_es': 'roberta_classifier_readability_es_sentences',
            'es.classify.roberta': 'roberta_jurisbert_clas_art_convencion_americana_dh',
            'es.classify.roberta.amazon.base_finetuned': 'roberta_classifier_base_bne_finetuned_amazon_reviews_multi_finetuned_amazon_reviews_multi',
            'es.classify.roberta.base': 'roberta_sequence_classifier_bsc_base_spanish_diagnostics',
            'es.classify.roberta.base.by_maxpe': 'roberta_classifier_bertin_base_spanish_sem_eval_2018_task_1',
            'es.classify.roberta.base_finetuned': 'roberta_classifier_base_bne_finetuned_cyberbullying_spanish',
            'es.classify.roberta.by_alexhf90': 'roberta_classifier_clasificacion_sentimientos',
            'es.classify.roberta.by_gagandeepkundi': 'roberta_classifier_latam_question_quality',
            'es.classify.roberta.by_prompsit': 'roberta_classifier_paraphrase',
            'es.classify.roberta.catalonia_independence.base_finetuned': 'roberta_classifier_base_bne_finetuned_catalonia_independence_detector',
            'es.classify.roberta.hate.base_finetuned': 'roberta_classifier_base_bne_finetuned_hate_speech_offensive_spanish',
            'es.classify.roberta.news.': 'roberta_classifier_fake_news_detection_spanish',
            'es.classify.roberta.pawsx_xtreme.base_finetuned': 'roberta_sequence_classifier_ruperta_base_finetuned_pawsx',
            'es.classify.roberta.sentiment.': 'roberta_classifier_bne_sentiment_analysis',
            'es.classify.roberta.sentiment.base': 'roberta_classifier_bertin_base_sentiment_analysis',
            'es.classify.roberta.sentiment.base.by_edumunozsala': 'roberta_classifier_ruperta_base_sentiment_analysis',
            'es.classify.roberta.twitter.': 'roberta_classifier_detect_acoso_twitter',
            'es.classify.roberta.xnli.base': 'roberta_classifier_bertin_base_xnli',
            'es.classify.sentiment.': 'classifierdl_bert_sentiment',
            'es.classify.token_bert.spanish_ner': 'bert_token_classifier_spanish_ner',
            'es.classify.tratados.roberta.by_hackathon_pln_es': 'roberta_jurisbert_class_tratados_internacionales_sistema_universal',
            'es.classify.xlmr_roberta.twitter.': 'xlmroberta_classifier_twitter_emotion',
            'es.embed.RoBERTalex': 'roberta_embeddings_RoBERTalex',
            'es.embed.RuPERTa_base': 'roberta_embeddings_RuPERTa_base',
            'es.embed.alberti_bert_base_multilingual_cased': 'bert_embeddings_alberti_bert_base_multilingual_cased',
            'es.embed.bert.base_cased': 'bert_base_cased',
            'es.embed.bert.base_legal': 'legalectra_base',
            'es.embed.bert.base_uncased': 'bert_base_uncased',
            'es.embed.bert.cased_base': 'bert_embeddings_base_es_cased',
            'es.embed.bert.cased_base.by_dccuchile': 'bert_embeddings_base_spanish_wwm_cased',
            'es.embed.bert.small_legal': 'legalectra_small',
            'es.embed.bert.uncased_base': 'bert_embeddings_base_spanish_wwm_uncased',
            'es.embed.bert_base_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
            'es.embed.bert_base_es_cased': 'bert_embeddings_bert_base_es_cased',
            'es.embed.bertin_base_gaussian': 'roberta_embeddings_bertin_base_gaussian',
            'es.embed.bertin_base_gaussian_exp_512seqlen': 'roberta_embeddings_bertin_base_gaussian_exp_512seqlen',
            'es.embed.bertin_base_random': 'roberta_embeddings_bertin_base_random',
            'es.embed.bertin_base_random_exp_512seqlen': 'roberta_embeddings_bertin_base_random_exp_512seqlen',
            'es.embed.bertin_base_stepwise': 'roberta_embeddings_bertin_base_stepwise',
            'es.embed.bertin_base_stepwise_exp_512seqlen': 'roberta_embeddings_bertin_base_stepwise_exp_512seqlen',
            'es.embed.bertin_roberta_base_spanish': 'roberta_embeddings_bertin_roberta_base_spanish',
            'es.embed.bertin_roberta_large_spanish': 'roberta_embeddings_bertin_roberta_large_spanish',
            'es.embed.beto_gn_base_cased': 'bert_embeddings_beto_gn_base_cased',
            'es.embed.distilbert_base_es_cased': 'distilbert_embeddings_distilbert_base_es_cased',
            'es.embed.distilbert_base_es_multilingual_cased': 'distilbert_embeddings_distilbert_base_es_multilingual_cased',
            'es.embed.dpr_spanish_passage_encoder_allqa_base': 'bert_embeddings_dpr_spanish_passage_encoder_allqa_base',
            'es.embed.dpr_spanish_passage_encoder_squades_base': 'bert_embeddings_dpr_spanish_passage_encoder_squades_base',
            'es.embed.dpr_spanish_question_encoder_allqa_base': 'bert_embeddings_dpr_spanish_question_encoder_allqa_base',
            'es.embed.dpr_spanish_question_encoder_squades_base': 'bert_embeddings_dpr_spanish_question_encoder_squades_base',
            'es.embed.electra.base': 'electra_embeddings_electricidad_base_generator',
            'es.embed.jurisbert': 'roberta_embeddings_jurisbert',
            'es.embed.legal.cbow.cased_d100': 'word2vec_cbow_legal_d100_cased',
            'es.embed.legal.cbow.cased_d300': 'word2vec_cbow_legal_d300_cased',
            'es.embed.legal.cbow.cased_d50': 'word2vec_cbow_legal_d50_cased',
            'es.embed.legal.cbow.uncased_d100': 'word2vec_cbow_legal_d100_uncased',
            'es.embed.legal.cbow.uncased_d300': 'word2vec_cbow_legal_d300_uncased',
            'es.embed.legal.cbow.uncased_d50': 'word2vec_cbow_legal_d50_uncased',
            'es.embed.legal.skipgram.cased_d100': 'word2vec_skipgram_legal_d100_cased',
            'es.embed.legal.skipgram.cased_d300': 'word2vec_skipgram_legal_d300_cased',
            'es.embed.legal.skipgram.cased_d50': 'word2vec_skipgram_legal_d50_cased',
            'es.embed.legal.skipgram.uncased_d100': 'word2vec_skipgram_legal_d100_uncased',
            'es.embed.legal.skipgram.uncased_d300': 'word2vec_skipgram_legal_d300_uncased',
            'es.embed.legal.skipgram.uncased_d50': 'word2vec_skipgram_legal_d50_uncased',
            'es.embed.longformer.base_legal': 'longformer_legal_base_8192',
            'es.embed.longformer.legal': 'longformer_legal_embeddings',
            'es.embed.mlm_spanish_roberta_base': 'roberta_embeddings_mlm_spanish_roberta_base',
            'es.embed.roberta_base_bne': 'roberta_embeddings_roberta_base_bne',
            'es.embed.roberta_large_bne': 'roberta_embeddings_roberta_large_bne',
            'es.embed.w2v_cc_300d': 'w2v_cc_300d',
            'es.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
            'es.embed_sentence.bert.base_uncased': 'sent_bert_base_uncased',
            'es.lemma': 'lemma_spacylookup',
            'es.lemma.ancora': 'lemma_ancora',
            'es.lemma.gsd': 'lemma_gsd',
            'es.lemma.spacylookup': 'lemma_spacylookup',
            'es.ner': 'wikiner_6B_100',
            'es.ner.NER_LAW_MONEY4': 'roberta_ner_NER_LAW_MONEY4',
            'es.ner.RuPERTa_base_finetuned_ner': 'roberta_ner_RuPERTa_base_finetuned_ner',
            'es.ner.bert': 'bert_ner_anglicisms_spanish_mbert',
            'es.ner.bert.by_luch0247': 'bert_token_classifier_autotrain_lucy_alicorp_1356152290',
            'es.ner.bert.by_nymiz': 'bert_ner_eus_es_nymiz',
            'es.ner.bert.cased': 'bert_ner_spanish_cased_finedtuned',
            'es.ner.bert.cased_finetuned': 'bert_ner_bert_spanish_cased_finetuned_ner',
            'es.ner.bert.clinical.uncased_base_finetuned': 'bert_ner_bert_base_spanish_wwm_uncased_finetuned_clinical',
            'es.ner.bert.uncased_base_finetuned': 'bert_ner_bert_base_spanish_wwm_uncased_finetuned_ner_medical',
            'es.ner.bert.uncased_tiny_finetuned': 'bert_ner_tinybert_spanish_uncased_finetuned_ner',
            'es.ner.beto_bert': 'bert_ner_meddocan_beto_ner',
            'es.ner.beto_bert.by_nazagara': 'bert_token_classifier_ner_fine_tuned_beto',
            'es.ner.bsc_bio_ehr_es_cantemist': 'roberta_ner_bsc_bio_ehr_es_cantemist',
            'es.ner.bsc_bio_ehr_es_pharmaconer': 'roberta_ner_bsc_bio_ehr_es_pharmaconer',
            'es.ner.pos': 'roberta_pos_veganuary_pos',
            'es.ner.pos.cased_finetuned': 'bert_pos_bert_spanish_cased_finetuned_pos',
            'es.ner.pos.cased_finetuned.by_mrm8488': 'bert_pos_spanish_cased_finetuned_pos_16_tags',
            'es.ner.pos.cased_finetuned_snytax.by_mrm8488': 'bert_pos_bert_spanish_cased_finetuned_pos_syntax',
            'es.ner.pos.cased_finetuned_v2.by_mrm8488': 'bert_pos_bert_spanish_cased_finetuned_pos_16_tags',
            'es.ner.roberta': 'roberta_token_classifier_bne_capitel_ner',
            'es.ner.roberta.bio_clinical.finetuned': 'roberta_ner_finetuned_bioclinical',
            'es.ner.roberta.clinical.base': 'roberta_ner_nlp_cic_wfu_clinical_cases_ner_sents_tokenized_bertin_roberta_base_spanish_fine_tuned',
            'es.ner.roberta.clinical_bio_medical_craft.base_augmented_finetuned': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_craft_augmentedtransfer_es',
            'es.ner.roberta.clinical_bio_medical_craft.base_augmented_finetuned.by_StivenLancheros': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_craft_augmented_es',
            'es.ner.roberta.clinical_bio_medical_craft.base_finetuned': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_craft_en_es_stivenlancheros',
            'es.ner.roberta.clinical_bio_medical_craft.base_finetuned.by_StivenLancheros': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_concat_craft_es_stivenlancheros',
            'es.ner.roberta.disease': 'roberta_ner_spanish_disease_finder',
            'es.ner.roberta.finetuning_': 'roberta_ner_jurisbert_finetuning_ner',
            'es.ner.roberta_base_bne_capitel_ner': 'roberta_ner_roberta_base_bne_capitel_ner',
            'es.ner.roberta_base_bne_capitel_ner_plus': 'roberta_ner_roberta_base_bne_capitel_ner_plus',
            'es.ner.roberta_large_bne_capitel_ner': 'roberta_ner_roberta_large_bne_capitel_ner',
            'es.ner.wikiner': 'wikiner_6B_100',
            'es.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
            'es.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
            'es.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
            'es.ner.xlmr_roberta.base': 'xlmroberta_ner_base_panx_dataset',
            'es.ner.xlmr_roberta.large': 'xlmroberta_ner_xlm_roberta_large_ner_spanish',
            'es.ner.xlmr_roberta.large.by_tner': 'xlmroberta_ner_large_panx_dataset',
            'es.pos': 'pos_ancora',
            'es.pos.RuPERTa_base_finetuned_pos': 'roberta_pos_RuPERTa_base_finetuned_pos',
            'es.pos.ancora': 'pos_ancora',
            'es.pos.gsd': 'pos_gsd',
            'es.pos.roberta_base_bne_capitel_pos': 'roberta_pos_roberta_base_bne_capitel_pos',
            'es.pos.roberta_large_bne_capitel_pos': 'roberta_pos_roberta_large_bne_capitel_pos',
            'es.pos.ud_gsd': 'pos_ud_gsd',
            'es.stopwords': 'stopwords_iso',
            'es.stopwords_es': 'stopwords_es'},
        'et': {'et.answer_question.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_est_qa',
               'et.embed.camembert': 'camembert_embeddings_est_roberta',
               'et.embed.w2v_cc_300d': 'w2v_cc_300d',
               'et.lemma': 'lemma_ewt',
               'et.lemma.edt': 'lemma_edt',
               'et.lemma.ewt': 'lemma_ewt',
               'et.ner.camembert': 'camembert_classifier_est_roberta_hist_ner',
               'et.pos': 'pos_edt',
               'et.pos.ewt': 'pos_ewt',
               'et.stopwords': 'stopwords_iso'},
        'eu': {
            'eu.answer_question.ixam_bert.squad.finetuned': 'bert_qa_ixambert_finetuned_squad_eu_marcbrun',
            'eu.answer_question.ixam_bert.squad.finetuned.by_MarcBrun': 'bert_qa_ixambert_finetuned_squad_eu_en_marcbrun',
            'eu.embed.roberta': 'roberta_embeddings_robasqu',
            'eu.embed.w2v_cc_300d': 'w2v_cc_300d',
            'eu.lemma': 'lemma_bdt',
            'eu.lemma.bdt': 'lemma_bdt',
            'eu.pos': 'pos_ud_bdt',
            'eu.pos.bdt': 'pos_bdt',
            'eu.stopwords': 'stopwords_iso',
            'eu.stopwords.iso': 'stopwords_iso'},
        'fa': {'fa.answer_question.bert': 'bert_qa_bert_fa_qa_v1',
               'fa.answer_question.bert.base': 'bert_qa_bert_base_fa_qa',
               'fa.answer_question.bert.by_alirezabaneshi': 'bert_qa_testpersianqa',
               'fa.answer_question.bert.by_newsha': 'bert_qa_pquad',
               'fa.answer_question.bert.pars_bert.finetuned': 'bert_qa_parsbert_finetuned_persianqa',
               'fa.answer_question.bert.pars_bert.uncased_base_finetuned': 'bert_qa_base_parsbert_uncased_finetuned_perqa',
               'fa.answer_question.bert.squad_pars_bert.uncased_base_finetuned': 'bert_qa_base_parsbert_uncased_finetuned_squad',
               'fa.answer_question.bert.v2.by_newsha': 'bert_qa_pquad_2',
               'fa.answer_question.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_fa_qa',
               'fa.answer_question.xlmr_roberta.large': 'xlmroberta_qa_xlmr_large',
               'fa.classify.bert.news.uncased_base': 'bert_classifier_bert_fa_base_uncased_clf_persiannews',
               'fa.classify.bert.sentiment.deepsentipers_multi.uncased_base.by_HooshvareLab': 'bert_classifier_bert_fa_base_uncased_sentiment_deepsentipers_multi',
               'fa.classify.bert.sentiment.digikala.uncased_base.by_HooshvareLab': 'bert_classifier_bert_fa_base_uncased_sentiment_digikala',
               'fa.classify.bert.sentiment.snappfood.uncased_base.by_HooshvareLab': 'bert_classifier_bert_fa_base_uncased_sentiment_snappfood',
               'fa.classify.bert.sentiment.uncased_base': 'bert_classifier_bert_fa_base_uncased_sentiment_deepsentipers_binary',
               'fa.classify.bert.sentiment_twitter.': 'bert_classifier_pars_fa_sentiment_twitter',
               'fa.classify.bert.uncased_base': 'bert_classifier_bert_fa_base_uncased_clf_digimag',
               'fa.classify.bert.uncased_base.by_demoversion': 'bert_classifier_bert_fa_base_uncased_haddad_wikinli',
               'fa.classify.bert.uncased_base.farstail.by_m3hrdadfi': 'bert_classifier_bert_fa_base_uncased_farstail',
               'fa.classify.bert.uncased_base.wikinli.by_m3hrdadfi': 'bert_classifier_bert_fa_base_uncased_wikinli',
               'fa.classify.token_bert.parsbert_armanner': 'bert_token_classifier_parsbert_armanner',
               'fa.classify.token_bert.parsbert_ner': 'bert_token_classifier_parsbert_ner',
               'fa.classify.token_bert.parsbert_peymaner': 'bert_token_classifier_parsbert_peymaner',
               'fa.classify.token_roberta_token_classifier_zwnj_base_ner': 'roberta_token_classifier_zwnj_base_ner',
               'fa.embed': 'persian_w2v_cc_300d',
               'fa.embed.albert': 'albert_embeddings_albert_fa_base_v2',
               'fa.embed.albert_fa_zwnj_base_v2': 'albert_embeddings_albert_fa_zwnj_base_v2',
               'fa.embed.bert.base': 'bert_embeddings_fa_zwnj_base',
               'fa.embed.bert.uncased_base': 'bert_embeddings_fa_base_uncased',
               'fa.embed.distilbert_fa_zwnj_base': 'distilbert_embeddings_distilbert_fa_zwnj_base',
               'fa.embed.roberta_fa_zwnj_base': 'roberta_embeddings_roberta_fa_zwnj_base',
               'fa.embed.word2vec': 'persian_w2v_cc_300d',
               'fa.embed.word2vec.300d': 'persian_w2v_cc_300d',
               'fa.lemma': 'lemma',
               'fa.lemma.perdt': 'lemma_perdt',
               'fa.lemma.seraji': 'lemma_seraji',
               'fa.ner': 'personer_cc_300d',
               'fa.ner.bert.arman.uncased_base': 'bert_ner_bert_fa_base_uncased_ner_arman',
               'fa.ner.bert.base': 'bert_ner_bert_fa_zwnj_base_ner',
               'fa.ner.bert.pars_bert.uncased_base': 'bert_ner_bert_base_parsbert_ner_uncased',
               'fa.ner.bert.pars_bert_arman.uncased_base': 'bert_ner_bert_base_parsbert_armanner_uncased',
               'fa.ner.bert.pars_bert_peyma.uncased_base': 'bert_ner_bert_base_parsbert_peymaner_uncased',
               'fa.ner.bert.peyma.uncased_base': 'bert_ner_bert_fa_base_uncased_ner_peyma',
               'fa.ner.distil_bert': 'distilbert_token_classifier_persian_ner',
               'fa.ner.person': 'personer_cc_300d',
               'fa.ner.person.cc_300d': 'personer_cc_300d',
               'fa.ner.roberta_fa_zwnj_base_ner': 'roberta_ner_roberta_fa_zwnj_base_ner',
               'fa.ner.xlmr_roberta.arman_xtreme.base_finetuned': 'xlmroberta_ner_base_finetuned_arman',
               'fa.ner.xlmr_roberta.peyma.base_finetuned': 'xlmroberta_ner_base_finetuned_peyma',
               'fa.pos': 'pos_perdt',
               'fa.pos.perdt': 'pos_perdt',
               'fa.pos.seraji': 'pos_seraji',
               'fa.speech2text.wav2vec2.v2_gpu_s117_exp': 'asr_exp_w2v2t_pretraining_s117_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s165_vp_exp': 'asr_exp_w2v2t_vp_s165_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s168_exp': 'asr_exp_w2v2t_wav2vec2_s168_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s198_vp_exp': 'asr_exp_w2v2t_vp_s198_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s224_vp_exp': 'asr_exp_w2v2t_vp_s224_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s282_vp_exp': 'asr_exp_w2v2t_vp_s282_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s28_exp': 'asr_exp_w2v2t_pretraining_s28_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s321_exp': 'asr_exp_w2v2t_wav2vec2_s321_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s339_vp_exp': 'asr_exp_w2v2t_vp_s339_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s376_vp_exp': 'asr_exp_w2v2t_vp_s376_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s407_vp_exp': 'asr_exp_w2v2t_vp_100k_s407_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s419_vp_exp': 'asr_exp_w2v2t_vp_s419_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s533_vp_exp': 'asr_exp_w2v2t_vp_s533_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s555_vp_exp': 'asr_exp_w2v2t_vp_s555_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s650_exp': 'asr_exp_w2v2t_pretraining_s650_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s689_vp_exp': 'asr_exp_w2v2t_vp_s689_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s738_vp_exp': 'asr_exp_w2v2t_vp_s738_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s749_vp_exp': 'asr_exp_w2v2t_vp_s749_gpu',
               'fa.speech2text.wav2vec2.v2_gpu_s88_vp_exp': 'asr_exp_w2v2t_vp_100k_s88_gpu',
               'fa.speech2text.wav2vec2.v2_s165_vp_exp': 'asr_exp_w2v2t_vp_s165',
               'fa.speech2text.wav2vec2.v2_s168_exp': 'asr_exp_w2v2t_wav2vec2_s168',
               'fa.speech2text.wav2vec2.v2_s198_vp_exp': 'asr_exp_w2v2t_vp_s198',
               'fa.speech2text.wav2vec2.v2_s224_vp_exp': 'asr_exp_w2v2t_vp_s224',
               'fa.speech2text.wav2vec2.v2_s282_vp_exp': 'asr_exp_w2v2t_vp_s282',
               'fa.speech2text.wav2vec2.v2_s321_exp': 'asr_exp_w2v2t_wav2vec2_s321',
               'fa.speech2text.wav2vec2.v2_s339_vp_exp': 'asr_exp_w2v2t_vp_s339',
               'fa.speech2text.wav2vec2.v2_s376_vp_exp': 'asr_exp_w2v2t_vp_s376',
               'fa.speech2text.wav2vec2.v2_s407_vp_exp': 'asr_exp_w2v2t_vp_100k_s407',
               'fa.speech2text.wav2vec2.v2_s419_vp_exp': 'asr_exp_w2v2t_vp_s419',
               'fa.speech2text.wav2vec2.v2_s533_vp_exp': 'asr_exp_w2v2t_vp_s533',
               'fa.speech2text.wav2vec2.v2_s555_vp_exp': 'asr_exp_w2v2t_vp_s555',
               'fa.speech2text.wav2vec2.v2_s689_vp_exp': 'asr_exp_w2v2t_vp_s689',
               'fa.speech2text.wav2vec2.v2_s738_vp_exp': 'asr_exp_w2v2t_vp_s738',
               'fa.speech2text.wav2vec2.v2_s749_vp_exp': 'asr_exp_w2v2t_vp_s749',
               'fa.speech2text.wav2vec2.v2_s88_vp_exp': 'asr_exp_w2v2t_vp_100k_s88',
               'fa.speech2text.wav2vec_xlsr': 'asr_xlsr_lm',
               'fa.speech2text.wav2vec_xlsr.gpu': 'asr_xlsr_lm_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_gpu_s116_exp': 'asr_exp_w2v2t_xlsr_53_s116_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_gpu_s204_exp': 'asr_exp_w2v2t_xlsr_53_s204_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_gpu_s356_exp': 'asr_exp_w2v2t_xlsr_53_s356_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_gpu_s44_exp': 'asr_exp_w2v2t_xls_r_s44_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_persian',
               'fa.speech2text.wav2vec_xlsr.v2_large_3h': 'asr_wav2vec2_large_xlsr_persian_v3_by_m3hrdadfi',
               'fa.speech2text.wav2vec_xlsr.v2_large_3h_gpu': 'asr_wav2vec2_large_xlsr_persian_v3_by_m3hrdadfi_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_persian_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_large_gpu.by_m3hrdadfi': 'asr_wav2vec2_large_xlsr_persian_gpu',
               'fa.speech2text.wav2vec_xlsr.v2_s116_exp': 'asr_exp_w2v2t_xlsr_53_s116',
               'fa.speech2text.wav2vec_xlsr.v2_s204_exp': 'asr_exp_w2v2t_xlsr_53_s204',
               'fa.speech2text.wav2vec_xlsr.v2_s356_exp': 'asr_exp_w2v2t_xlsr_53_s356',
               'fa.speech2text.wav2vec_xlsr.v2_s44_exp': 'asr_exp_w2v2t_xls_r_s44',
               'fa.stopwords': 'stopwords_iso',
               'fa.stopwords.iso': 'stopwords_iso'},
        'fi': {'fi.answer_question.roberta': 'roberta_qa_addi_fi_roberta',
               'fi.answer_question.roberta.squad.finetuned': 'roberta_qa_fin_roberta_v1_finetuned_squad',
               'fi.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_FI_XLM_R',
               'fi.classify.bert.sentiment.': 'bert_classifier_finbert_finnsentiment',
               'fi.embed.bert.cased_base': 'bert_embeddings_base_finnish_cased_v1',
               'fi.embed.bert.uncased_base': 'bert_embeddings_base_finnish_uncased_v1',
               'fi.embed.w2v_cc_300d': 'w2v_cc_300d',
               'fi.embed_sentence.bert': 'bert_base_finnish_uncased',
               'fi.embed_sentence.bert.cased': 'bert_base_finnish_cased',
               'fi.embed_sentence.bert.uncased': 'bert_base_finnish_uncased',
               'fi.lemma': 'lemma_tdt',
               'fi.lemma.ftb': 'lemma_ftb',
               'fi.lemma.tdt': 'lemma_tdt',
               'fi.ner': 'wikiner_6B_100',
               'fi.ner.6B_100d': 'finnish_ner_6B_100',
               'fi.ner.6B_300d': 'finnish_ner_6B_300',
               'fi.ner.840B_300d': 'finnish_ner_840B_300',
               'fi.ner.xlmr_roberta.base': 'xlmroberta_ner_base_fin',
               'fi.ner.xlmr_roberta.large': 'xlmroberta_ner_large_fin',
               'fi.ner.xlmr_roberta.uncased_base': 'xlmroberta_ner_base_uncased_fin',
               'fi.ner.xlmr_roberta.uncased_large': 'xlmroberta_ner_large_uncased_fin',
               'fi.pos': 'pos_tdt',
               'fi.pos.ftb': 'pos_ftb',
               'fi.pos.tdt': 'pos_tdt',
               'fi.pos.ud_tdt': 'pos_ud_tdt',
               'fi.speech2text.wav2vec2.voxpopuli.v2_base': 'asr_wav2vec2_base_10k_voxpopuli',
               'fi.speech2text.wav2vec2.voxpopuli.v2_base_finetuned': 'asr_wav2vec2_base_voxpopuli_v2_finetuned',
               'fi.speech2text.wav2vec2.voxpopuli.v2_base_finetuned_gpu': 'asr_wav2vec2_base_voxpopuli_v2_finetuned_gpu',
               'fi.speech2text.wav2vec2.voxpopuli.v2_base_gpu': 'asr_wav2vec2_base_10k_voxpopuli_gpu',
               'fi.speech2text.wav2vec2.voxpopuli.v2_large': 'asr_wav2vec2_large_uralic_voxpopuli_v2_finnish',
               'fi.speech2text.wav2vec2.voxpopuli.v2_large_gpu': 'asr_wav2vec2_large_uralic_voxpopuli_v2_finnish_gpu',
               'fi.speech2text.wav2vec_xlsr.by_finnish_nlp': 'asr_wav2vec2_xlsr_1b_finnish_lm_by_finnish_nlp',
               'fi.speech2text.wav2vec_xlsr.v2': 'asr_wav2vec2_xlsr_1b_finnish',
               'fi.speech2text.wav2vec_xlsr.v2.by_aapot': 'asr_wav2vec2_xlsr_1b_finnish_lm_v2_by_aapot',
               'fi.speech2text.wav2vec_xlsr.v2.by_finnish_nlp': 'asr_wav2vec2_xlsr_1b_finnish_lm_v2_by_finnish_nlp',
               'fi.speech2text.wav2vec_xlsr.v2.by_rasmus': 'asr_wav2vec2_xlsr_train_aug_biglm_1b',
               'fi.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xlsr_300m_finnish',
               'fi.speech2text.wav2vec_xlsr.v2_300m.by_aapot': 'asr_wav2vec2_xlsr_300m_finnish_lm_by_aapot',
               'fi.speech2text.wav2vec_xlsr.v2_300m.by_finnish_nlp': 'asr_wav2vec2_xlsr_300m_finnish_lm_by_finnish_nlp',
               'fi.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xlsr_1b_finnish_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_gpu.by_aapot': 'asr_wav2vec2_xlsr_1b_finnish_lm_v2_by_aapot_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_gpu.by_finnish_nlp': 'asr_wav2vec2_xlsr_1b_finnish_lm_v2_by_finnish_nlp_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_gpu.by_rasmus': 'asr_wav2vec2_xlsr_train_aug_biglm_1b_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_finnish_by_tommi',
               'fi.speech2text.wav2vec_xlsr.v2_large.by_aapot': 'asr_wav2vec2_large_xlsr_53_finnish_by_aapot',
               'fi.speech2text.wav2vec_xlsr.v2_large.by_birgermoell': 'asr_wav2vec2_large_xlsr_finnish',
               'fi.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_finnish_by_jonatasgrosman',
               'fi.speech2text.wav2vec_xlsr.v2_large.by_vasilis': 'asr_wav2vec2_large_xlsr_53_finnish_by_vasilis',
               'fi.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_finnish_by_tommi_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_large_gpu.by_aapot': 'asr_wav2vec2_large_xlsr_53_finnish_by_aapot_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_large_gpu.by_birgermoell': 'asr_wav2vec2_large_xlsr_finnish_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_large_gpu.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_finnish_by_jonatasgrosman_gpu',
               'fi.speech2text.wav2vec_xlsr.v2_large_gpu.by_vasilis': 'asr_wav2vec2_large_xlsr_53_finnish_by_vasilis_gpu',
               'fi.speech2text.wav2vec_xlsrby_aapot': 'asr_wav2vec2_xlsr_1b_finnish_lm_by_aapot',
               'fi.stopwords': 'stopwords_iso',
               'fi.stopwords.iso': 'stopwords_iso'},
        'fo': {'fo.lemma': 'lemma_farpahc',
               'fo.lemma.farpahc': 'lemma_farpahc',
               'fo.pos': 'pos_farpahc'},
        'fon': {'fon.speech2text.wav2vec_xlsr': 'asr_fonxlsr',
                'fon.speech2text.wav2vec_xlsr.gpu': 'asr_fonxlsr_gpu'},
        'fr': {
            'fr.answer_question.camembert.fquad': 'camembert_base_qa_fquad',
            'fr.answer_question.roberta': 'roberta_qa_addi_fr_roberta',
            'fr.answer_question.roberta.by_gantenbein': 'roberta_qa_addi_fr_xlm_r',
            'fr.answer_question.squad.xlmr_roberta.base': 'xlm_roberta_qa_xlmr_base_texas_squad_fr_fr_saattrupdan',
            'fr.classify.allocine': 'mdeberta_v3_base_sequence_classifier_allocine',
            'fr.classify.bert.hate.': 'bert_classifier_dehatebert_mono_french',
            'fr.classify.bert.multi2convai.': 'bert_classifier_multi2convai_corona',
            'fr.classify.bert.multi2convai.by_inovex': 'bert_classifier_multi2convai_quality',
            'fr.classify.bert.multi2convai.v2.by_inovex': 'bert_classifier_multi2convai_quality_fr_mbert',
            'fr.classify.bert.multilingual': 'bert_multilingual_sequence_classifier_allocine',
            'fr.classify.camembert.base': 'camembert_base_sequence_classifier_allocine',
            'fr.classify.camembert.large': 'camembert_large_sequence_classifier_allocine',
            'fr.classify.distilbert_sequence.allocine': 'distilbert_multilingual_sequence_classifier_allocine',
            'fr.classify.sentiment.bert': 'classifierdl_bert_sentiment',
            'fr.classify.xlm_roberta.allocine': 'xlm_roberta_base_sequence_classifier_allocine',
            'fr.embed.albert': 'albert_embeddings_fralbert_base',
            'fr.embed.bert.cased_base': 'bert_embeddings_base_fr_cased',
            'fr.embed.bert_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
            'fr.embed.bert_base_fr_cased': 'bert_embeddings_bert_base_fr_cased',
            'fr.embed.camembert': 'camembert_embeddings_dummy',
            'fr.embed.camembert.91m_generic': 'camembert_embeddings_generic_model_r91m',
            'fr.embed.camembert.adverse_drug_event_generic': 'camembert_embeddings_adeimousa_generic_model',
            'fr.embed.camembert.base': 'camembert_embeddings_dataikunlp_camembert_base',
            'fr.embed.camembert.by_ebtihal': 'camembert_embeddings_arbertmo',
            'fr.embed.camembert.by_ghani_25': 'camembert_embeddings_summfinfr',
            'fr.embed.camembert.by_hueynemud': 'camembert_embeddings_das22_10_camembert_pretrained',
            'fr.embed.camembert.by_jodsa': 'camembert_embeddings_camembert_mlm',
            'fr.embed.camembert.distilled_base': 'camembert_embeddings_distilcamembert_base',
            'fr.embed.camembert.generic': 'camembert_embeddings_doyyingface_generic_model',
            'fr.embed.camembert.generic.by_adam1224': 'camembert_embeddings_adam1224_generic_model',
            'fr.embed.camembert.generic.by_aliasdasd': 'camembert_embeddings_aliasdasd_generic_model',
            'fr.embed.camembert.generic.by_ankitkupadhyay': 'camembert_embeddings_ankitkupadhyay_generic_model',
            'fr.embed.camembert.generic.by_codingjacob': 'camembert_embeddings_codingjacob_generic_model',
            'fr.embed.camembert.generic.by_cylee': 'camembert_embeddings_cylee_generic_model',
            'fr.embed.camembert.generic.by_devtrent': 'camembert_embeddings_devtrent_generic_model',
            'fr.embed.camembert.generic.by_dianeshan': 'camembert_embeddings_dianeshan_generic_model',
            'fr.embed.camembert.generic.by_edge2992': 'camembert_embeddings_edge2992_generic_model',
            'fr.embed.camembert.generic.by_eduardopds': 'camembert_embeddings_eduardopds_generic_model',
            'fr.embed.camembert.generic.by_elliotsmith': 'camembert_embeddings_elliotsmith_generic_model',
            'fr.embed.camembert.generic.by_elusive_magnolia': 'camembert_embeddings_elusive_magnolia_generic_model',
            'fr.embed.camembert.generic.by_ericchchiu': 'camembert_embeddings_ericchchiu_generic_model',
            'fr.embed.camembert.generic.by_fjluque': 'camembert_embeddings_fjluque_generic_model',
            'fr.embed.camembert.generic.by_gulabpatel': 'camembert_embeddings_new_generic_model',
            'fr.embed.camembert.generic.by_h4d35': 'camembert_embeddings_h4d35_generic_model',
            'fr.embed.camembert.generic.by_hackertec': 'camembert_embeddings_generic2',
            'fr.embed.camembert.generic.by_hasanmurad': 'camembert_embeddings_hasanmurad_generic_model',
            'fr.embed.camembert.generic.by_hasanmuradbuet': 'camembert_embeddings_hasanmuradbuet_generic_model',
            'fr.embed.camembert.generic.by_henrywang': 'camembert_embeddings_henrywang_generic_model',
            'fr.embed.camembert.generic.by_jcai1': 'camembert_embeddings_jcai1_generic_model',
            'fr.embed.camembert.generic.by_joe8zhang': 'camembert_embeddings_joe8zhang_generic_model',
            'fr.embed.camembert.generic.by_jonathansum': 'camembert_embeddings_jonathansum_generic_model',
            'fr.embed.camembert.generic.by_juliencarbonnell': 'camembert_embeddings_juliencarbonnell_generic_model',
            'fr.embed.camembert.generic.by_katrin_kc': 'camembert_embeddings_katrin_kc_generic_model',
            'fr.embed.camembert.generic.by_katster': 'camembert_embeddings_katster_generic_model',
            'fr.embed.camembert.generic.by_kaushikacharya': 'camembert_embeddings_kaushikacharya_generic_model',
            'fr.embed.camembert.generic.by_leisa': 'camembert_embeddings_leisa_generic_model',
            'fr.embed.camembert.generic.by_lewtun': 'camembert_embeddings_lewtun_generic_model',
            'fr.embed.camembert.generic.by_lijingxin': 'camembert_embeddings_lijingxin_generic_model',
            'fr.embed.camembert.generic.by_linyi': 'camembert_embeddings_linyi_generic_model',
            'fr.embed.camembert.generic.by_mbateman': 'camembert_embeddings_mbateman_generic_model',
            'fr.embed.camembert.generic.by_mohammadrea76': 'camembert_embeddings_mohammadrea76_generic_model',
            'fr.embed.camembert.generic.by_myx4567': 'camembert_embeddings_myx4567_generic_model',
            'fr.embed.camembert.generic.by_osanseviero': 'camembert_embeddings_generic_model_test',
            'fr.embed.camembert.generic.by_peterhsu': 'camembert_embeddings_peterhsu_generic_model',
            'fr.embed.camembert.generic.by_pgperrone': 'camembert_embeddings_pgperrone_generic_model',
            'fr.embed.camembert.generic.by_safik': 'camembert_embeddings_safik_generic_model',
            'fr.embed.camembert.generic.by_sebu': 'camembert_embeddings_sebu_generic_model',
            'fr.embed.camembert.generic.by_seyfullah': 'camembert_embeddings_seyfullah_generic_model',
            'fr.embed.camembert.generic.by_sonny': 'camembert_embeddings_sonny_generic_model',
            'fr.embed.camembert.generic.by_tnagata': 'camembert_embeddings_tnagata_generic_model',
            'fr.embed.camembert.generic.by_tpanza': 'camembert_embeddings_tpanza_generic_model',
            'fr.embed.camembert.generic.by_wangst': 'camembert_embeddings_wangst_generic_model',
            'fr.embed.camembert.generic.by_weipeng': 'camembert_embeddings_weipeng_generic_model',
            'fr.embed.camembert.generic.by_xkang': 'camembert_embeddings_xkang_generic_model',
            'fr.embed.camembert.generic.by_yancong': 'camembert_embeddings_yancong_generic_model',
            'fr.embed.camembert.generic.by_ysharma': 'camembert_embeddings_ysharma_generic_model_2',
            'fr.embed.camembert.generic.by_zhenghuabin': 'camembert_embeddings_zhenghuabin_generic_model',
            'fr.embed.camembert.generic_v2.by_fjluque': 'camembert_embeddings_fjluque_generic_model2',
            'fr.embed.camembert.generic_v2.by_hackertec': 'camembert_embeddings_hackertec_generic',
            'fr.embed.camembert.generic_v2.by_lijingxin': 'camembert_embeddings_lijingxin_generic_model_2',
            'fr.embed.camembert.generic_v2.by_osanseviero': 'camembert_embeddings_osanseviero_generic_model',
            'fr.embed.camembert.generic_v2.by_peterhsu': 'camembert_embeddings_tf_generic_model',
            'fr.embed.camembert.tweet.base': 'camembert_embeddings_bertweetfr_base',
            'fr.embed.camembert_base': 'camembert_base',
            'fr.embed.camembert_base_ccnet': 'camembert_base_ccnet',
            'fr.embed.camembert_ccnet4g': 'camembert_base_ccnet_4gb',
            'fr.embed.camembert_large': 'camembert_large',
            'fr.embed.camembert_oscar_4g': 'camembert_base_oscar_4gb',
            'fr.embed.camembert_wiki_4g': 'camembert_base_wikipedia_4gb',
            'fr.embed.distilbert': 'distilbert_embeddings_distilbert_base_fr_cased',
            'fr.embed.electra.cased_base': 'electra_embeddings_electra_base_french_europeana_cased_generator',
            'fr.embed.french_roberta': 'roberta_embeddings_french_roberta',
            'fr.embed.roberta_base_wechsel_french': 'roberta_embeddings_roberta_base_wechsel_french',
            'fr.embed.w2v_cc_300d': 'w2v_cc_300d',
            'fr.embed.word2vec_wac_200': 'word2vec_wac_200',
            'fr.embed.word2vec_wiki_1000': 'word2vec_wiki_1000',
            'fr.lemma': 'lemma_ftb',
            'fr.lemma.ftb': 'lemma_ftb',
            'fr.lemma.gsd': 'lemma_gsd',
            'fr.lemma.parisstories': 'lemma_parisstories',
            'fr.lemma.partut': 'lemma_partut',
            'fr.lemma.rhapsodie': 'lemma_rhapsodie',
            'fr.lemma.sequoia': 'lemma_sequoia',
            'fr.lemma.spacylookup': 'lemma_spacylookup',
            'fr.ner': 'wikiner_840B_300',
            'fr.ner.bert': 'bert_ner_bert_mention_fr_vera_pro',
            'fr.ner.camembert': 'camembert_classifier_magbert_ner',
            'fr.ner.camembert.antilles.': 'camembert_classifier_poet',
            'fr.ner.camembert.by_jean_baptiste': 'camembert_classifier_ner',
            'fr.ner.camembert.fquad.': 'camembert_classifier_squadfr_fquad_piaf_answer_extraction',
            'fr.ner.camembert.with_dates.by_jean_baptiste': 'camembert_classifier_ner_with_dates',
            'fr.ner.pos': 'bert_pos_french_postag_model',
            'fr.ner.pos.antilles.': 'camembert_classifier_pos_french',
            'fr.ner.wikiner': 'wikiner_840B_300',
            'fr.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
            'fr.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned': 'xlmroberta_ner_cj_mills_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_Neha2608': 'xlmroberta_ner_neha2608_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_V3RX2000': 'xlmroberta_ner_v3rx2000_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_dkasti': 'xlmroberta_ner_dkasti_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_edwardjross': 'xlmroberta_ner_edwardjross_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_flood': 'xlmroberta_ner_flood_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_haesun': 'xlmroberta_ner_haesun_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_iis2009002': 'xlmroberta_ner_iis2009002_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_jgriffi': 'xlmroberta_ner_jgriffi_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_lijingxin': 'xlmroberta_ner_lijingxin_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_moghis': 'xlmroberta_ner_moghis_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_olpa': 'xlmroberta_ner_xml_roberta_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_robkayinto': 'xlmroberta_ner_robkayinto_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_skr3178': 'xlmroberta_ner_skr3178_base_finetuned_panx',
            'fr.ner.xlmr_roberta.xtreme.base_finetuned.by_transformersbook': 'xlmroberta_ner_transformersbook_base_finetuned_panx',
            'fr.pos': 'pos_sequoia',
            'fr.pos.gsd': 'pos_gsd',
            'fr.pos.parisstories': 'pos_parisstories',
            'fr.pos.partut': 'pos_partut',
            'fr.pos.rhapsodie': 'pos_rhapsodie',
            'fr.pos.sequoia': 'pos_sequoia',
            'fr.pos.ud_gsd': 'pos_ud_gsd',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s156_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s156_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s21_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s21_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s255_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s255_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s3_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s3_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s400_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s400_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s428_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s428_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s469_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s469_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s474_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s474_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s500_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s500_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s626_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s626_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s714_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s714_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s722_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s722_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s911_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s911_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_gpu_s934_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s934_gpu',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s156_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s156',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s21_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s21',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s255_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s255',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s3_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s3',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s400_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s400',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s428_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s428',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s469_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s469',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s474_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s474',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s500_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s500',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s626_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s626',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s714_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s714',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s722_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s722',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s911_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s911',
            'fr.speech2text.wav2vec2.gender_male_female.v2_s934_vp_exp': 'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s934',
            'fr.speech2text.wav2vec2.v2_gpu_s169_vp_exp': 'asr_exp_w2v2t_vp_s169_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s179_vp_exp': 'asr_exp_w2v2t_vp_s179_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s203_vp_exp': 'asr_exp_w2v2t_vp_s203_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s208_exp': 'asr_exp_w2v2t_pretraining_s208_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s227_exp': 'asr_exp_w2v2t_wav2vec2_s227_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s251_exp': 'asr_exp_w2v2t_r_wav2vec2_s251_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s271_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_france_10_belgium_0_s271_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s281_vp_exp': 'asr_exp_w2v2t_vp_s281_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s320_vp_exp': 'asr_exp_w2v2t_vp_s320_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s438_vp_exp': 'asr_exp_w2v2t_vp_s438_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s456_exp': 'asr_exp_w2v2t_r_wav2vec2_s456_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s459_exp': 'asr_exp_w2v2t_r_wav2vec2_s459_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s509_vp_exp': 'asr_exp_w2v2t_vp_100k_s509_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s596_vp_exp': 'asr_exp_w2v2t_vp_s596_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s607_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_france_5_belgium_5_s607_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s688_vp_exp': 'asr_exp_w2v2t_vp_100k_s688_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s709_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_france_2_belgium_8_s709_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s766_exp': 'asr_exp_w2v2t_pretraining_s766_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s809_exp': 'asr_exp_w2v2t_wav2vec2_s809_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s870_exp': 'asr_exp_w2v2t_wav2vec2_s870_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s875_vp_exp': 'asr_exp_w2v2t_vp_s875_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s877_vp_exp': 'asr_exp_w2v2t_vp_s877_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s878_vp_exp': 'asr_exp_w2v2t_vp_s878_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s929_exp': 'asr_exp_w2v2t_pretraining_s929_gpu',
            'fr.speech2text.wav2vec2.v2_gpu_s973_vp_exp': 'asr_exp_w2v2t_vp_100k_s973_gpu',
            'fr.speech2text.wav2vec2.v2_s169_vp_exp': 'asr_exp_w2v2t_vp_s169',
            'fr.speech2text.wav2vec2.v2_s179_vp_exp': 'asr_exp_w2v2t_vp_s179',
            'fr.speech2text.wav2vec2.v2_s203_vp_exp': 'asr_exp_w2v2t_vp_s203',
            'fr.speech2text.wav2vec2.v2_s227_exp': 'asr_exp_w2v2t_wav2vec2_s227',
            'fr.speech2text.wav2vec2.v2_s251_exp': 'asr_exp_w2v2t_r_wav2vec2_s251',
            'fr.speech2text.wav2vec2.v2_s271_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_france_10_belgium_0_s271',
            'fr.speech2text.wav2vec2.v2_s281_vp_exp': 'asr_exp_w2v2t_vp_s281',
            'fr.speech2text.wav2vec2.v2_s320_vp_exp': 'asr_exp_w2v2t_vp_s320',
            'fr.speech2text.wav2vec2.v2_s438_vp_exp': 'asr_exp_w2v2t_vp_s438',
            'fr.speech2text.wav2vec2.v2_s456_exp': 'asr_exp_w2v2t_r_wav2vec2_s456',
            'fr.speech2text.wav2vec2.v2_s459_exp': 'asr_exp_w2v2t_r_wav2vec2_s459',
            'fr.speech2text.wav2vec2.v2_s509_vp_exp': 'asr_exp_w2v2t_vp_100k_s509',
            'fr.speech2text.wav2vec2.v2_s596_vp_exp': 'asr_exp_w2v2t_vp_s596',
            'fr.speech2text.wav2vec2.v2_s607_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_france_5_belgium_5_s607',
            'fr.speech2text.wav2vec2.v2_s688_vp_exp': 'asr_exp_w2v2t_vp_100k_s688',
            'fr.speech2text.wav2vec2.v2_s709_vp_exp': 'asr_exp_w2v2r_vp_100k_accent_france_2_belgium_8_s709',
            'fr.speech2text.wav2vec2.v2_s809_exp': 'asr_exp_w2v2t_wav2vec2_s809',
            'fr.speech2text.wav2vec2.v2_s870_exp': 'asr_exp_w2v2t_wav2vec2_s870',
            'fr.speech2text.wav2vec2.v2_s875_vp_exp': 'asr_exp_w2v2t_vp_s875',
            'fr.speech2text.wav2vec2.v2_s877_vp_exp': 'asr_exp_w2v2t_vp_s877',
            'fr.speech2text.wav2vec2.v2_s878_vp_exp': 'asr_exp_w2v2t_vp_s878',
            'fr.speech2text.wav2vec2.v2_s973_vp_exp': 'asr_exp_w2v2t_vp_100k_s973',
            'fr.speech2text.wav2vec2.voxpopuli.v2_base_gpu': 'asr_wav2vec2_base_10k_voxpopuli_gpu',
            'fr.speech2text.wav2vec2.voxpopuli.v2_large': 'asr_wav2vec2_large_voxpopuli_french',
            'fr.speech2text.wav2vec2.voxpopuli.v2_large_gpu': 'asr_wav2vec2_large_voxpopuli_french_gpu',
            'fr.speech2text.wav2vec_xlsr.gender_male_female.v2_gpu_s295_exp': 'asr_exp_w2v2r_xls_r_gender_male_2_female_8_s295_gpu',
            'fr.speech2text.wav2vec_xlsr.gender_male_female.v2_gpu_s559_exp': 'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s559_gpu',
            'fr.speech2text.wav2vec_xlsr.gender_male_female.v2_gpu_s755_exp': 'asr_exp_w2v2r_xls_r_gender_male_8_female_2_s755_gpu',
            'fr.speech2text.wav2vec_xlsr.gender_male_female.v2_s295_exp': 'asr_exp_w2v2r_xls_r_gender_male_2_female_8_s295',
            'fr.speech2text.wav2vec_xlsr.gender_male_female.v2_s559_exp': 'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s559',
            'fr.speech2text.wav2vec_xlsr.gender_male_female.v2_s755_exp': 'asr_exp_w2v2r_xls_r_gender_male_8_female_2_s755',
            'fr.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xls_r_1b_french_by_bhuang_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_gpu_s250_exp': 'asr_exp_w2v2t_xls_r_s250_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_gpu_s286_exp': 'asr_exp_w2v2t_xlsr_53_s286_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_gpu_s539_exp': 'asr_exp_w2v2t_xlsr_53_s539_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_gpu_s800_exp': 'asr_exp_w2v2t_xlsr_53_s800_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_french',
            'fr.speech2text.wav2vec_xlsr.v2_large.by_facebook': 'asr_wav2vec2_large_xlsr_53_french_by_facebook',
            'fr.speech2text.wav2vec_xlsr.v2_large.by_ilyes': 'asr_wav2vec2_large_xlsr_53_french_by_ilyes',
            'fr.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_french_by_jonatasgrosman',
            'fr.speech2text.wav2vec_xlsr.v2_large.by_nhut': 'asr_wav2vec2_large_xlsr_french',
            'fr.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_french_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_large_gpu.by_facebook': 'asr_wav2vec2_large_xlsr_53_french_by_facebook_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_large_gpu.by_ilyes': 'asr_wav2vec2_large_xlsr_53_french_by_ilyes_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_large_gpu.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_french_by_jonatasgrosman_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_large_gpu.by_nhut': 'asr_wav2vec2_large_xlsr_french_gpu',
            'fr.speech2text.wav2vec_xlsr.v2_s250_exp': 'asr_exp_w2v2t_xls_r_s250',
            'fr.speech2text.wav2vec_xlsr.v2_s286_exp': 'asr_exp_w2v2t_xlsr_53_s286',
            'fr.speech2text.wav2vec_xlsr.v2_s539_exp': 'asr_exp_w2v2t_xlsr_53_s539',
            'fr.speech2text.wav2vec_xlsr.v2_s800_exp': 'asr_exp_w2v2t_xlsr_53_s800',
            'fr.stopwords': 'stopwords_iso',
            'fr.stopwords.iso': 'stopwords_iso'},
        'fro': {'fro.lemma': 'lemma_srcmf',
                'fro.lemma.srcmf': 'lemma_srcmf',
                'fro.pos.srcmf': 'pos_srcmf'},
        'frr': {'frr.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'fy': {'fy.embed.bert.cased_base': 'bert_embeddings_base_dutch_cased_frisian',
               'fy.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ga': {'ga.lemma': 'lemma',
               'ga.lemma.idt': 'lemma_idt',
               'ga.ner.bert.wikiann.cased_base_finetuned': 'bert_ner_bert_base_irish_cased_v1_finetuned_ner',
               'ga.ner.roberta.wikiann.finetuned': 'roberta_ner_bertreach_finetuned_ner',
               'ga.pos': 'pos_idt',
               'ga.pos.idt': 'pos_idt',
               'ga.stopwords': 'stopwords_iso',
               'ga.stopwords.iso': 'stopwords_iso'},
        'gam': {
            'gam.answer_question.roberta.cuad.base_finetuned': 'roberta_qa_roberta_base_finetuned_cuad_gam'},
        'gd': {'gd.embed.w2v_cc_300d': 'w2v_cc_300d',
               'gd.lemma': 'lemma_arcosg',
               'gd.pos.arcosg': 'pos_arcosg'},
        'gl': {'gl.embed.roberta': 'roberta_embeddings_robertinh',
               'gl.embed.w2v_cc_300d': 'w2v_cc_300d',
               'gl.lemma': 'lemma_treegal',
               'gl.lemma.ctg': 'lemma_ctg',
               'gl.lemma.treegal': 'lemma_treegal',
               'gl.pos': 'pos_ud_treegal',
               'gl.pos.ctg': 'pos_ctg',
               'gl.pos.treegal': 'pos_treegal',
               'gl.stopwords': 'stopwords_gl'},
        'gom': {'gom.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'got': {'got.lemma': 'lemma_proiel',
                'got.lemma.proiel': 'lemma_proiel',
                'got.pos.proiel': 'pos_proiel'},
        'grc': {'grc.lemma': 'lemma_proiel',
                'grc.lemma.perseus': 'lemma_perseus',
                'grc.lemma.proiel': 'lemma_proiel',
                'grc.lemma.spacylookup': 'lemma_spacylookup',
                'grc.pos': 'pos_proiel',
                'grc.pos.perseus': 'pos_perseus',
                'grc.stopwords': 'stopwords_iso'},
        'gu': {'gu.detect_sentence': 'sentence_detector_dl',
               'gu.embed.RoBERTa_hindi_guj_san': 'roberta_embeddings_RoBERTa_hindi_guj_san',
               'gu.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_gpu',
               'gu.stopwords': 'stopwords_iso'},
        'gv': {'gv.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ha': {
            'ha.embed.bert.cased_multilingual_base_finetuned': 'bert_embeddings_base_multilingual_cased_finetuned_hausa',
            'ha.embed.bert.cased_multilingual_base_finetuned.by_davlan': 'bert_embeddings_base_multilingual_cased_finetuned_swahili',
            'ha.embed.xlm_roberta': 'xlm_roberta_base_finetuned_hausa',
            'ha.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_hausa',
            'ha.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_xlm_roberta_base_finetuned_hausa_finetuned_ner_hausa',
            'ha.ner.xlmr_roberta.base_finetuned_hausa.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_ner_hausa',
            'ha.ner.xlmr_roberta.base_finetuned_swahilis.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_swahili_finetuned_ner_hausa',
            'ha.speech2text.wav2vec_xlsr': 'asr_hausa_xlsr',
            'ha.speech2text.wav2vec_xlsr.gpu': 'asr_hausa_xlsr_gpu',
            'ha.stopwords': 'stopwords_ha'},
        'he': {'he.answer_question.squad.bert': 'bert_qa_hebert_finetuned_hebrew_squad',
               'he.classify.bert': 'bert_classifier_descriptive',
               'he.classify.bert.sentiment.': 'bert_classifier_he_sentiment_analysis',
               'he.embed': 'hebrew_cc_300d',
               'he.embed.bert.base': 'bert_embeddings_onlplab_aleph_base',
               'he.embed.bert.legal': 'bert_embeddings_legal_hebert',
               'he.embed.bert.legal.by_avichr': 'bert_embeddings_legal_hebert_ft',
               'he.embed.cbow_300d': 'hebrew_cc_300d',
               'he.embed.glove': 'hebrew_cc_300d',
               'he.lemma': 'lemma',
               'he.lemma.htb': 'lemma_htb',
               'he.ner': 'hebrewner_cc_300d',
               'he.ner.bert': 'bert_ner_hebert_ner',
               'he.ner.bert.finetuned': 'bert_token_classifier_aleph_finetuned_metaphor_detection',
               'he.ner.cc_300d': 'hebrewner_cc_300d',
               'he.pos': 'pos_ud_htb',
               'he.pos.htb': 'pos_htb',
               'he.pos.ud_htb': 'pos_ud_htb',
               'he.stopwords': 'stopwords_iso',
               'he.stopwords.iso': 'stopwords_iso'},
        'hi': {'hi.answer_question.bert.cased_large': 'bert_qa_muril_large_cased_hita_qa',
               'hi.answer_question.bert.cased_multilingual_base': 'bert_qa_multilingual_bert_base_cased_hindi',
               'hi.answer_question.bert.mlqa.finetuned': 'bert_qa_mbert_finetuned_mlqa_dev',
               'hi.answer_question.bert.squad.finetuned': 'bert_qa_muril_finetuned_squadv1',
               'hi.answer_question.bert.squadv2.large': 'bert_qa_muril_large_squad2',
               'hi.answer_question.xlm_roberta': 'xlm_roberta_qa_autonlp_hindi_question_answering_23865268',
               'hi.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_hindi',
               'hi.classify.roberta': 'roberta_classifier_autotrain_citizen_nlu_hindi_1370952776',
               'hi.classify.xlmr_roberta.news.': 'xlmroberta_classifier_autonlp_fake_news_detection_system_29906863',
               'hi.embed': 'hindi_cc_300d',
               'hi.embed.RoBERTa_hindi_guj_san': 'roberta_embeddings_RoBERTa_hindi_guj_san',
               'hi.embed.bert': 'bert_embeddings_indic_transformers',
               'hi.embed.bert.cased_base': 'bert_embeddings_base_hi_cased',
               'hi.embed.bert_hi_cased': 'bert_embeddings_bert_base_hi_cased',
               'hi.embed.distil_bert': 'distilbert_embeddings_indic_transformers',
               'hi.embed.distilbert_base_hi_cased': 'distilbert_embeddings_distilbert_base_hi_cased',
               'hi.embed.indic_transformers_hi_bert': 'bert_embeddings_indic_transformers_hi_bert',
               'hi.embed.indic_transformers_hi_distilbert': 'distilbert_embeddings_indic_transformers_hi_distilbert',
               'hi.embed.indic_transformers_hi_roberta': 'roberta_embeddings_indic_transformers_hi_roberta',
               'hi.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
               'hi.embed.roberta': 'roberta_embeddings_hindi',
               'hi.embed.roberta.by_neuralspace_reverie': 'roberta_embeddings_indic_transformers',
               'hi.embed.xlmr_roberta': 'xlmroberta_embeddings_indic_transformers_hi_xlmroberta',
               'hi.lemma': 'lemma',
               'hi.lemma.hdtb': 'lemma_hdtb',
               'hi.ner': 'bert_hi_en_ner',
               'hi.ner.bert': 'bert_token_classifier_hi_en_ner',
               'hi.ner.bert.by_l3cube_pune': 'bert_ner_hing_bert_lid',
               'hi.ner.bert.by_sagorsarker': 'bert_ner_codeswitch_hineng_ner_lince',
               'hi.ner.bert.ner_codeswitch_hineng_lid_lince': 'bert_ner_codeswitch_hineng_lid_lince',
               'hi.ner.pos': 'bert_pos_codeswitch_hineng_pos_lince',
               'hi.ner.xlmr_roberta.large_original': 'xlmroberta_ner_hiner_original_large',
               'hi.pos': 'pos_ud_hdtb',
               'hi.pos.hdtb': 'pos_hdtb',
               'hi.speech2text.wav2vec2': 'asr_cdac_hindispeechrecognition',
               'hi.speech2text.wav2vec2.by_harveenchadha': 'asr_hindi_model_with_lm_vakyansh',
               'hi.speech2text.wav2vec2.by_swayam01': 'asr_hindi_clsril_100',
               'hi.speech2text.wav2vec2.gpu': 'asr_cdac_hindispeechrecognition_gpu',
               'hi.speech2text.wav2vec2.gpu.by_harveenchadha': 'asr_hindi_model_with_lm_vakyansh_gpu',
               'hi.speech2text.wav2vec2.gpu.by_swayam01': 'asr_hindi_clsril_100_gpu',
               'hi.speech2text.wav2vec2.v2': 'asr_indicwav2vec_hindi',
               'hi.speech2text.wav2vec2.v2.by_harveenchadha': 'asr_vakyansh_wav2vec2_hindi_him_4200',
               'hi.speech2text.wav2vec2.v2_base': 'asr_hindi_base_wav2vec2',
               'hi.speech2text.wav2vec2.v2_base_gpu': 'asr_hindi_base_wav2vec2_gpu',
               'hi.speech2text.wav2vec2.v2_gpu': 'asr_indicwav2vec_hindi_gpu',
               'hi.speech2text.wav2vec2.v2_gpu.by_harveenchadha': 'asr_vakyansh_wav2vec2_hindi_him_4200_gpu',
               'hi.speech2text.wav2vec2.v2_large': 'asr_hindi_large_wav2vec2',
               'hi.speech2text.wav2vec2.v2_large_gpu': 'asr_hindi_large_wav2vec2_gpu',
               'hi.speech2text.wav2vec_xlsr': 'asr_xls_r_ab_test_by_priyajay',
               'hi.speech2text.wav2vec_xlsr.300m': 'asr_xls_r_300m_prod',
               'hi.speech2text.wav2vec_xlsr.300m.by_yaswanth': 'asr_xls_r_300m_yaswanth_hindi2',
               'hi.speech2text.wav2vec_xlsr.300m_gpu': 'asr_xls_r_300m_prod_gpu',
               'hi.speech2text.wav2vec_xlsr.300m_gpu.by_yaswanth': 'asr_xls_r_300m_yaswanth_hindi2_gpu',
               'hi.speech2text.wav2vec_xlsr.by_kapilkd13': 'asr_xls_r_test',
               'hi.speech2text.wav2vec_xlsr.gpu': 'asr_xls_r_ab_test_by_priyajay_gpu',
               'hi.speech2text.wav2vec_xlsr.gpu.by_priyajay': 'asr_xls_r_test_gpu',
               'hi.speech2text.wav2vec_xlsr.large': 'asr_wave2vec2_large_xlsr_hindi',
               'hi.speech2text.wav2vec_xlsr.large_gpu': 'asr_wave2vec2_large_xlsr_hindi_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m_final',
               'hi.speech2text.wav2vec_xlsr.v2_300m.by_legolastheelf': 'asr_wav2vec2_xls_r_lm_300m',
               'hi.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_final_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_300m_gpu.by_legolastheelf': 'asr_wav2vec2_xls_r_lm_300m_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_gpu': 'asr_xlsr_53_wav2vec_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_cv7',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m.by_ravirajoshi': 'asr_wav2vec2_large_xls_r_300m_hindi_by_ravirajoshi',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m.by_reichenbach': 'asr_wav2vec2_large_xls_r_300m_by_reichenbach',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m.by_saitomar': 'asr_wav2vec2_large_xls_r_300m_hindi_kaggle',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_cv8.by_drishtisharma': 'asr_wav2vec2_large_xls_r_300m_cv8',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_d3.by_drishtisharma': 'asr_wav2vec2_large_xls_r_300m_d3',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_d3_gpu': 'asr_wav2vec2_large_xls_r_300m_d3_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_cv7_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_ravirajoshi': 'asr_wav2vec2_large_xls_r_300m_hindi_by_ravirajoshi_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_reichenbach': 'asr_wav2vec2_large_xls_r_300m_by_reichenbach_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_gpu.by_saitomar': 'asr_wav2vec2_large_xls_r_300m_hindi_kaggle_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_gpu_cv8.by_drishtisharma': 'asr_wav2vec2_large_xls_r_300m_cv8_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_gpu_wx1.by_drishtisharma': 'asr_wav2vec2_large_xls_r_300m_wx1_gpu',
               'hi.speech2text.wav2vec_xlsr.v2_large_300m_wx1.by_drishtisharma': 'asr_wav2vec2_large_xls_r_300m_wx1',
               'hi.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_hindi_gpu',
               'hi.stopwords': 'stopwords_iso',
               'hi.stopwords.iso': 'stopwords_iso'},
        'hif': {'hif.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'hr': {'hr.classify.bert.hate.': 'bert_classifier_bcms_ic_frenk_hate',
               'hr.classify.bert.multi2convai.': 'bert_classifier_multi2convai_logistics',
               'hr.embed.w2v_cc_300d': 'w2v_cc_300d',
               'hr.lemma': 'lemma_spacylookup',
               'hr.lemma.set': 'lemma_set',
               'hr.lemma.spacylookup': 'lemma_spacylookup',
               'hr.pos.set': 'pos_set',
               'hr.stopwords': 'stopwords_iso'},
        'hsb': {'hsb.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'hu': {
            'hu.answer_question.squad.bert': 'bert_qa_huBert_fine_tuned_hungarian_squadv1',
            'hu.lemma': 'lemma_spacylookup',
            'hu.lemma.spacylookup': 'lemma_spacylookup',
            'hu.lemma.szeged': 'lemma_szeged',
            'hu.ner.bert': 'bert_ner_named_entity_recognition_nerkor_hubert_hungarian',
            'hu.ner.bert.by_fdominik98': 'bert_ner_ner_hu_model_2021',
            'hu.ner.bert.cased_base': 'bert_ner_bert_base_hu_cased_ner',
            'hu.ner.bert.cased_base.by_akdeniz27': 'bert_ner_bert_base_hungarian_cased_ner',
            'hu.pos': 'pos_ud_szeged',
            'hu.pos.szeged': 'pos_szeged',
            'hu.pos.ud_szeged': 'pos_ud_szeged',
            'hu.speech2text.wav2vec2.voxpopuli.v2_base_gpu': 'asr_wav2vec2_base_10k_voxpopuli_gpu',
            'hu.speech2text.wav2vec_xlsr': 'asr_xlsr_hungarian',
            'hu.speech2text.wav2vec_xlsr.gpu': 'asr_xlsr_hungarian_gpu',
            'hu.speech2text.wav2vec_xlsr.l_v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_hungarian_by_anton_l_gpu',
            'hu.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_hungarian_by_anton_l',
            'hu.speech2text.wav2vec_xlsr.v2_large.by_birgermoell': 'asr_wav2vec2_large_xlsr_hungarian',
            'hu.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_hungarian_by_jonatasgrosman',
            'hu.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_hungarian_by_jonatasgrosman_gpu',
            'hu.speech2text.wav2vec_xlsr.v2_large_gpu.by_birgermoell': 'asr_wav2vec2_large_xlsr_hungarian_gpu',
            'hu.speech2text.wav2vec_xlsr.v2_large_gpu.by_gchhablani': 'asr_wav2vec2_large_xlsr_gpu',
            'hu.stopwords': 'stopwords_iso',
            'hu.stopwords.iso': 'stopwords_iso'},
        'hy': {'hy.embed.w2v_cc_300d': 'w2v_cc_300d',
               'hy.lemma': 'lemma_armtdp',
               'hy.lemma.armtdp': 'lemma_armtdp',
               'hy.pos': 'pos_ud_armtdp',
               'hy.pos.armtdp': 'pos_armtdp',
               'hy.stopwords': 'stopwords_iso',
               'hy.stopwords.iso': 'stopwords_iso'},
        'hyw': {'hyw.lemma': 'lemma_armtdp', 'hyw.pos': 'pos_armtdp'},
        'id': {'id.answer_question.bert.lang': 'bert_qa_firmanindolanguagemodel',
               'id.answer_question.bert.tydiqa.base': 'bert_qa_base_indonesian_tydiqa',
               'id.answer_question.indo_bert': 'bert_qa_Indobert_QA',
               'id.classify.bert.sentiment.base': 'bert_classifier_bert_base_indonesian_1.5g_sentiment_analysis_smsa',
               'id.classify.roberta': 'roberta_classifier_indo_indonli',
               'id.classify.roberta.base': 'roberta_classifier_indonesian_base_emotion',
               'id.classify.roberta.base.by_w11wo': 'roberta_classifier_indonesian_base_indonli',
               'id.classify.roberta.by_akahana': 'roberta_classifier_indonesia_emotion',
               'id.classify.roberta.sentiment.': 'roberta_classifier_indonesia_sentiment',
               'id.classify.roberta.sentiment.base': 'roberta_classifier_indonesian_base_sentiment',
               'id.classify.roberta.sentiment.base.by_ayameRushia': 'roberta_classifier_base_indonesian_sentiment_analysis_smsa',
               'id.classify.roberta.sentiment.by_sahri': 'roberta_classifier_indonesiasentiment',
               'id.detect_sentence': 'sentence_detector_dl',
               'id.embed.bert.base': 'bert_embeddings_base_indonesian_1.5g',
               'id.embed.bert.base_522m': 'bert_embeddings_base_indonesian_522m',
               'id.embed.distilbert': 'distilbert_embeddings_distilbert_base_indonesian',
               'id.embed.indo_roberta_small': 'roberta_embeddings_indo_roberta_small',
               'id.embed.indonesian_roberta_base': 'roberta_embeddings_indonesian_roberta_base',
               'id.embed.indonesian_roberta_large': 'roberta_embeddings_indonesian_roberta_large',
               'id.embed.roberta.base_522m': 'roberta_embeddings_base_indonesian_522m',
               'id.embed.roberta.small': 'roberta_embeddings_indo_small',
               'id.embed.roberta_base_indonesian_522M': 'roberta_embeddings_roberta_base_indonesian_522M',
               'id.lemma': 'lemma_gsd',
               'id.lemma.csui': 'lemma_csui',
               'id.lemma.gsd': 'lemma_gsd',
               'id.lemma.spacylookup': 'lemma_spacylookup',
               'id.ner': 'xlm_roberta_large_token_classification_ner',
               'id.ner.bert.base': 'bert_ner_bert_base_indonesian_ner',
               'id.ner.bert.xtreme.base': 'bert_ner_bert_base_ft_ner_xtreme_id_sultannn',
               'id.ner.pos': 'roberta_token_classifier_pos_tagger',
               'id.ner.pos.base': 'roberta_ner_indonesian_roberta_base_bapos_tagger',
               'id.ner.xlmr_roberta': 'xlmroberta_ner_shopee',
               'id.ner.xlmr_roberta.base': 'xlmroberta_ner_base_indonesian',
               'id.ner.xlmr_roberta.large': 'xlmroberta_ner_large_indonesian',
               'id.pos': 'pos_csui',
               'id.pos.csui': 'pos_csui',
               'id.pos.gsd': 'pos_gsd',
               'id.pos.indonesian_roberta_base_posp_tagger': 'roberta_pos_indonesian_roberta_base_posp_tagger',
               'id.speech2text.wav2vec2.v2': 'asr_wav2vec2_from_scratch_finetune_dummy',
               'id.speech2text.wav2vec2.v2_gpu': 'asr_wav2vec2_from_scratch_finetune_dummy_gpu',
               'id.speech2text.wav2vec2.v2_gpu_s156_exp': 'asr_exp_w2v2t_wav2vec2_s156_gpu',
               'id.speech2text.wav2vec2.v2_gpu_s226_exp': 'asr_exp_w2v2t_wav2vec2_s226_gpu',
               'id.speech2text.wav2vec2.v2_gpu_s417_exp': 'asr_exp_w2v2t_wav2vec2_s417_gpu',
               'id.speech2text.wav2vec2.v2_gpu_s615_vp_exp': 'asr_exp_w2v2t_vp_100k_s615_gpu',
               'id.speech2text.wav2vec2.v2_gpu_s764_vp_exp': 'asr_exp_w2v2t_vp_100k_s764_gpu',
               'id.speech2text.wav2vec2.v2_gpu_s842_vp_exp': 'asr_exp_w2v2t_vp_100k_s842_gpu',
               'id.speech2text.wav2vec2.v2_s156_exp': 'asr_exp_w2v2t_wav2vec2_s156',
               'id.speech2text.wav2vec2.v2_s226_exp': 'asr_exp_w2v2t_wav2vec2_s226',
               'id.speech2text.wav2vec2.v2_s417_exp': 'asr_exp_w2v2t_wav2vec2_s417',
               'id.speech2text.wav2vec2.v2_s615_vp_exp': 'asr_exp_w2v2t_vp_100k_s615',
               'id.speech2text.wav2vec2.v2_s764_vp_exp': 'asr_exp_w2v2t_vp_100k_s764',
               'id.speech2text.wav2vec2.v2_s842_vp_exp': 'asr_exp_w2v2t_vp_100k_s842',
               'id.speech2text.wav2vec_xlsr': 'asr_xlsr_indonesia',
               'id.speech2text.wav2vec_xlsr.gpu': 'asr_xlsr_indonesia_gpu',
               'id.speech2text.wav2vec_xlsr.v2': 'asr_wav2vec2_xlsr_53_common_voice_indonesian',
               'id.speech2text.wav2vec_xlsr.v2_300m': 'asr_fine_tune_wav2vec2_xls_r_300m_indonesia',
               'id.speech2text.wav2vec_xlsr.v2_300m.by_wikidepia': 'asr_wav2vec2_xls_r_300m_indonesian',
               'id.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_fine_tune_wav2vec2_xls_r_300m_indonesia_gpu',
               'id.speech2text.wav2vec_xlsr.v2_300m_gpu.by_wikidepia': 'asr_wav2vec2_xls_r_300m_indonesian_gpu',
               'id.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xlsr_53_common_voice_indonesian_gpu',
               'id.speech2text.wav2vec_xlsr.v2_gpu_s449_exp': 'asr_exp_w2v2t_xlsr_53_s449_gpu',
               'id.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_indonesian_artificial',
               'id.speech2text.wav2vec_xlsr.v2_large.by_cahya': 'asr_wav2vec2_large_xlsr_indonesian_by_cahya',
               'id.speech2text.wav2vec_xlsr.v2_large.by_galuh': 'asr_wav2vec2_large_xlsr_indonesian_by_galuh',
               'id.speech2text.wav2vec_xlsr.v2_large.by_indonesian_nlp': 'asr_wav2vec2_large_xlsr_indonesian_by_indonesian_nlp',
               'id.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_indonesian',
               'id.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_indonesian_gpu',
               'id.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_indonesian_artificial_gpu',
               'id.speech2text.wav2vec_xlsr.v2_large_gpu.by_cahya': 'asr_wav2vec2_large_xlsr_indonesian_by_cahya_gpu',
               'id.speech2text.wav2vec_xlsr.v2_large_gpu.by_galuh': 'asr_wav2vec2_large_xlsr_indonesian_by_galuh_gpu',
               'id.speech2text.wav2vec_xlsr.v2_large_gpu.by_indonesian_nlp': 'asr_wav2vec2_large_xlsr_indonesian_by_indonesian_nlp_gpu',
               'id.speech2text.wav2vec_xlsr.v2_s449_exp': 'asr_exp_w2v2t_xlsr_53_s449',
               'id.stopwords': 'stopwords_iso',
               'id.stopwords.iso': 'stopwords_iso'},
        'ig': {'ig.embed.xlm_roberta': 'xlm_roberta_base_finetuned_igbo',
               'ig.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_igbo',
               'ig.ner.distil_bert.cased_multilingual_base': 'distilbert_ner_distilbert_base_multilingual_cased_masakhaner',
               'ig.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_xlm_roberta_base_finetuned_igbo_finetuned_ner_igbo',
               'ig.ner.xlmr_roberta.base_finetuned_igbo.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_ner_igbo',
               'ig.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_swahili_finetuned_ner_igbo',
               'ig.ner.xlmr_roberta.wikiann.base': 'xlmroberta_ner_xlm_roberta_base_wikiann_ner'},
        'is': {'is.answer_question.roberta': 'roberta_qa_icebert',
               'is.answer_question.squad.roberta': 'roberta_qa_icebert_texas_squad_is_saattrupdan',
               'is.answer_question.squad.xlmr_roberta.base': 'xlm_roberta_qa_xlmr_base_texas_squad_is_is_saattrupdan',
               'is.answer_question.xlmr_roberta': 'xlm_roberta_qa_XLMr_ENIS_QA_Is',
               'is.classify.roberta.finetuned': 'roberta_classifier_icebert_finetuned_grouped',
               'is.lemma': 'lemma_icepahc',
               'is.lemma.modern': 'lemma_modern',
               'is.ner': 'roberta_token_classifier_icelandic_ner',
               'is.ner.bert': 'bert_ner_icelandic_ner_bert',
               'is.ner.distil_bert': 'distilbert_token_classifier_typo_detector',
               'is.ner.roberta': 'roberta_ner_icelandic_ner_roberta',
               'is.pos': 'pos_icepahc',
               'is.pos.modern': 'pos_modern',
               'is.stopwords': 'stopwords_iso'},
        'it': {'it.answer_question.roberta': 'roberta_qa_addi_it_roberta',
               'it.answer_question.squad.bert': 'bert_qa_bert_italian_finedtuned_squadv1_it_alfa',
               'it.answer_question.squad.bert.base_uncased': 'bert_qa_bert_base_italian_uncased_squad_it_antoniocappiello',
               'it.answer_question.squad.bert.xxl_cased': 'bert_qa_squad_xxl_cased_hub1',
               'it.answer_question.xlm_roberta': 'xlm_roberta_qa_ADDI_IT_XLM_R',
               'it.classify.bert': 'bert_classifier_autonlp_bank_transaction_classification_5521155',
               'it.classify.bert.by_m47labs': 'bert_classifier_it_iptc',
               'it.classify.bert.hate.': 'bert_classifier_dehatebert_mono_italian',
               'it.classify.bert.multi2convai.': 'bert_classifier_multi2convai_corona',
               'it.classify.bert.multi2convai.quality.by_inovex': 'bert_classifier_multi2convai_qualy',
               'it.classify.bert.multi2convai.quality_v2.by_inovex': 'bert_classifier_multi2convai_quality_it_mbert',
               'it.classify.bert.sentiment.cased_base': 'bert_classifier_bert_base_italian_cased_sentiment',
               'it.classify.bert.vaccine.': 'bert_classifier_vaccine_topic',
               'it.classify.distil_bert': 'distilbert_sequence_classifier_cross_encoder_distilbert_it_efederici',
               'it.classify.sentiment': 'bert_sequence_classifier_sentiment',
               'it.embed.BERTino': 'distilbert_embeddings_BERTino',
               'it.embed.bert': 'bert_base_italian_cased',
               'it.embed.bert.cased_base': 'bert_embeddings_base_it_cased',
               'it.embed.bert.cased_base.by_dbmdz': 'bert_embeddings_base_italian_cased',
               'it.embed.bert.cased_xxl_base': 'bert_embeddings_base_italian_xxl_cased',
               'it.embed.bert.uncased': 'bert_base_italian_uncased',
               'it.embed.bert.uncased_base': 'bert_embeddings_base_italian_uncased',
               'it.embed.bert.uncased_xxl_base': 'bert_embeddings_base_italian_xxl_uncased',
               'it.embed.bert_base_italian_xxl_cased': 'bert_embeddings_bert_base_italian_xxl_cased',
               'it.embed.bert_base_italian_xxl_uncased': 'bert_embeddings_bert_base_italian_xxl_uncased',
               'it.embed.bert_it_cased': 'bert_embeddings_bert_base_it_cased',
               'it.embed.camembert.cased': 'camembert_embeddings_umberto_commoncrawl_cased_v1',
               'it.embed.camembert.uncased': 'camembert_embeddings_umberto_wikipedia_uncased_v1',
               'it.embed.chefberto_italian_cased': 'bert_embeddings_chefberto_italian_cased',
               'it.embed.distil_bert': 'distilbert_embeddings_bertino',
               'it.embed.distilbert_base_it_cased': 'distilbert_embeddings_distilbert_base_it_cased',
               'it.embed.electra.cased_xxl_base': 'electra_embeddings_electra_base_italian_xxl_cased_generator',
               'it.embed.hseBert_it_cased': 'bert_embeddings_hseBert_it_cased',
               'it.embed.wineberto_italian_cased': 'bert_embeddings_wineberto_italian_cased',
               'it.embed.word2vec': 'w2v_cc_300d',
               'it.lemma': 'lemma_twittiro',
               'it.lemma.dxc': 'lemma_dxc',
               'it.lemma.isdt': 'lemma_isdt',
               'it.lemma.partut': 'lemma_partut',
               'it.lemma.postwita': 'lemma_postwita',
               'it.lemma.spacylookup': 'lemma_spacylookup',
               'it.lemma.twittiro': 'lemma_twittiro',
               'it.lemma.vit': 'lemma_vit',
               'it.ner': 'wikiner_840B_300',
               'it.ner.pos.xtreme.cased_finetuned': 'bert_pos_bert_italian_cased_finetuned_pos',
               'it.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
               'it.ner.xlmr_roberta.xtreme.base_finetuned': 'xlmroberta_ner_xlm_roberta_base_finetuned_panx_ner',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_Neha2608': 'xlmroberta_ner_neha2608_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_V3RX2000': 'xlmroberta_ner_v3rx2000_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_cj_mills': 'xlmroberta_ner_cj_mills_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_dkasti': 'xlmroberta_ner_dkasti_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_edwardjross': 'xlmroberta_ner_edwardjross_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_flood': 'xlmroberta_ner_flood_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_haesun': 'xlmroberta_ner_haesun_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_iis2009002': 'xlmroberta_ner_iis2009002_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_jgriffi': 'xlmroberta_ner_jgriffi_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_lijingxin': 'xlmroberta_ner_lijingxin_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_moghis': 'xlmroberta_ner_moghis_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_robkayinto': 'xlmroberta_ner_robkayinto_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_skr3178': 'xlmroberta_ner_skr3178_base_finetuned_panx',
               'it.ner.xlmr_roberta.xtreme.base_finetuned.by_transformersbook': 'xlmroberta_ner_transformersbook_base_finetuned_panx',
               'it.pos': 'pos_partut',
               'it.pos.isdt': 'pos_isdt',
               'it.pos.partut': 'pos_partut',
               'it.pos.postwita': 'pos_postwita',
               'it.pos.twittiro': 'pos_twittiro',
               'it.pos.ud_isdt': 'pos_ud_isdt',
               'it.pos.vit': 'pos_vit',
               'it.speech2text.wav2vec2.v2_gpu_s149_vp_exp': 'asr_exp_w2v2t_vp_100k_s149_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s149_vp_exp.by_jonatasgrosman': 'asr_exp_w2v2t_vp_s149_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s1_vp_exp': 'asr_exp_w2v2t_vp_s1_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s211_exp': 'asr_exp_w2v2t_wav2vec2_s211_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s222_vp_exp': 'asr_exp_w2v2t_vp_s222_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s27_vp_exp': 'asr_exp_w2v2t_vp_s27_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s317_exp': 'asr_exp_w2v2t_r_wav2vec2_s317_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s324_vp_exp': 'asr_exp_w2v2t_vp_s324_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s335_vp_exp': 'asr_exp_w2v2t_vp_s335_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s33_vp_exp': 'asr_exp_w2v2t_vp_s33_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s358_vp_exp': 'asr_exp_w2v2t_vp_100k_s358_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s411_vp_exp': 'asr_exp_w2v2t_vp_s411_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s449_vp_exp': 'asr_exp_w2v2t_vp_100k_s449_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s496_vp_exp': 'asr_exp_w2v2t_vp_s496_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s557_vp_exp': 'asr_exp_w2v2t_vp_s557_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s578_exp': 'asr_exp_w2v2t_r_wav2vec2_s578_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s579_vp_exp': 'asr_exp_w2v2t_vp_s579_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s609_exp': 'asr_exp_w2v2t_wav2vec2_s609_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s615_exp': 'asr_exp_w2v2t_pretraining_s615_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s646_exp': 'asr_exp_w2v2t_r_wav2vec2_s646_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s692_exp': 'asr_exp_w2v2t_wav2vec2_s692_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s764_exp': 'asr_exp_w2v2t_pretraining_s764_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s791_vp_exp': 'asr_exp_w2v2t_vp_s791_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s821_vp_exp': 'asr_exp_w2v2t_vp_s821_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s842_exp': 'asr_exp_w2v2t_pretraining_s842_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s878_vp_exp': 'asr_exp_w2v2t_vp_s878_gpu',
               'it.speech2text.wav2vec2.v2_gpu_s965_vp_exp': 'asr_exp_w2v2t_vp_s965_gpu',
               'it.speech2text.wav2vec2.v2_s149_vp_exp': 'asr_exp_w2v2t_vp_100k_s149',
               'it.speech2text.wav2vec2.v2_s149_vp_exp.by_jonatasgrosman': 'asr_exp_w2v2t_vp_s149',
               'it.speech2text.wav2vec2.v2_s211_exp': 'asr_exp_w2v2t_wav2vec2_s211',
               'it.speech2text.wav2vec2.v2_s222_vp_exp': 'asr_exp_w2v2t_vp_s222',
               'it.speech2text.wav2vec2.v2_s27_vp_exp': 'asr_exp_w2v2t_vp_s27',
               'it.speech2text.wav2vec2.v2_s317_exp': 'asr_exp_w2v2t_r_wav2vec2_s317',
               'it.speech2text.wav2vec2.v2_s324_vp_exp': 'asr_exp_w2v2t_vp_s324',
               'it.speech2text.wav2vec2.v2_s335_vp_exp': 'asr_exp_w2v2t_vp_s335',
               'it.speech2text.wav2vec2.v2_s358_vp_exp': 'asr_exp_w2v2t_vp_100k_s358',
               'it.speech2text.wav2vec2.v2_s411_vp_exp': 'asr_exp_w2v2t_vp_s411',
               'it.speech2text.wav2vec2.v2_s449_vp_exp': 'asr_exp_w2v2t_vp_100k_s449',
               'it.speech2text.wav2vec2.v2_s496_vp_exp': 'asr_exp_w2v2t_vp_s496',
               'it.speech2text.wav2vec2.v2_s557_vp_exp': 'asr_exp_w2v2t_vp_s557',
               'it.speech2text.wav2vec2.v2_s578_exp': 'asr_exp_w2v2t_r_wav2vec2_s578',
               'it.speech2text.wav2vec2.v2_s579_vp_exp': 'asr_exp_w2v2t_vp_s579',
               'it.speech2text.wav2vec2.v2_s609_exp': 'asr_exp_w2v2t_wav2vec2_s609',
               'it.speech2text.wav2vec2.v2_s646_exp': 'asr_exp_w2v2t_r_wav2vec2_s646',
               'it.speech2text.wav2vec2.v2_s692_exp': 'asr_exp_w2v2t_wav2vec2_s692',
               'it.speech2text.wav2vec2.v2_s791_vp_exp': 'asr_exp_w2v2t_vp_s791',
               'it.speech2text.wav2vec2.v2_s821_vp_exp': 'asr_exp_w2v2t_vp_s821',
               'it.speech2text.wav2vec2.v2_s965_vp_exp': 'asr_exp_w2v2t_vp_s965',
               'it.speech2text.wav2vec2.voxpopuli.base': 'asr_voxpopuli_base_2_5_gram_doc4lm',
               'it.speech2text.wav2vec2.voxpopuli.base_gpu': 'asr_voxpopuli_base_2_5_gram_doc4lm_gpu',
               'it.speech2text.wav2vec2.voxpopuli.v2_base_gpu': 'asr_wav2vec2_base_10k_voxpopuli_gpu',
               'it.speech2text.wav2vec_xlsr.v2_300m': 'asr_wav2vec2_xls_r_300m_italian_robust',
               'it.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_wav2vec2_xls_r_300m_italian_gpu',
               'it.speech2text.wav2vec_xlsr.v2_300m_gpu.by_dbdmg': 'asr_wav2vec2_xls_r_300m_italian_robust_gpu',
               'it.speech2text.wav2vec_xlsr.v2_gpu_s226_exp': 'asr_exp_w2v2t_xls_r_s226_gpu',
               'it.speech2text.wav2vec_xlsr.v2_gpu_s237_exp': 'asr_exp_w2v2t_xlsr_53_s237_gpu',
               'it.speech2text.wav2vec_xlsr.v2_gpu_s387_exp': 'asr_exp_w2v2t_xlsr_53_s387_gpu',
               'it.speech2text.wav2vec_xlsr.v2_gpu_s417_exp': 'asr_exp_w2v2t_xls_r_s417_gpu',
               'it.speech2text.wav2vec_xlsr.v2_gpu_s79_exp': 'asr_exp_w2v2t_xlsr_53_s79_gpu',
               'it.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_italian',
               'it.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_gpu',
               'it.speech2text.wav2vec_xlsr.v2_large_gpu.by_joaoalvarenga': 'asr_wav2vec2_large_xlsr_italian_gpu',
               'it.speech2text.wav2vec_xlsr.v2_s226_exp': 'asr_exp_w2v2t_xls_r_s226',
               'it.speech2text.wav2vec_xlsr.v2_s237_exp': 'asr_exp_w2v2t_xlsr_53_s237',
               'it.speech2text.wav2vec_xlsr.v2_s387_exp': 'asr_exp_w2v2t_xlsr_53_s387',
               'it.speech2text.wav2vec_xlsr.v2_s417_exp': 'asr_exp_w2v2t_xls_r_s417',
               'it.stopwords': 'stopwords_iso',
               'it.stopwords.iso': 'stopwords_iso'},
        'ja': {
            'ja.answer_question.bert.base_whole_word_masking': 'bert_qa_base_japanese_whole_word_masking_tes',
            'ja.answer_question.wikipedia.bert.base': 'bert_qa_base_japanese_wikipedia_ud_head',
            'ja.answer_question.wikipedia.bert.large': 'bert_qa_large_japanese_wikipedia_ud_head',
            'ja.classify.bert': 'bert_classifier_autotrain_iine_classification10_737422470',
            'ja.classify.bert.joy.': 'bert_classifier_autonlp_wrime_joy_only_117396',
            'ja.classify.bert.news.': 'bert_classifier_autotrain_livedoor_news_722922024',
            'ja.classify.bert.news.by_jurader': 'bert_classifier_autotrain_livedoor_news_732022289',
            'ja.classify.bert.sentiment.': 'bert_sequence_classifier_japanese_sentiment',
            'ja.classify.bert.sentiment.59362.by_abhishek': 'bert_classifier_autonlp_japanese_sentiment_59362',
            'ja.classify.bert.sentiment.59363.by_abhishek': 'bert_classifier_autonlp_japanese_sentiment_59363',
            'ja.classify.bert.v2_base': 'bert_classifier_bert_base_japanese_v2_wrime_fine_tune',
            'ja.classify.token_bert.classifier_ner_ud_gsd': 'bert_token_classifier_ner_ud_gsd',
            'ja.embed.albert_base_japanese_v1': 'albert_embeddings_albert_base_japanese_v1',
            'ja.embed.bert.base': 'bert_base_japanese',
            'ja.embed.bert.base_whole_word_masking': 'bert_embeddings_base_japanese_char_whole_word_masking',
            'ja.embed.bert.base_whole_word_masking.by_cl_tohoku': 'bert_embeddings_base_japanese_whole_word_masking',
            'ja.embed.bert.cased_base': 'bert_embeddings_base_ja_cased',
            'ja.embed.bert.large': 'bert_embeddings_large_japanese',
            'ja.embed.bert.large.by_cl_tohoku': 'bert_embeddings_large_japanese_char',
            'ja.embed.bert.v2_base': 'bert_embeddings_base_japanese_char_v2',
            'ja.embed.bert.v2_base.by_cl_tohoku': 'bert_embeddings_base_japanese_v2',
            'ja.embed.bert.wiki.base.by_cl_tohoku': 'bert_embeddings_base_japanese',
            'ja.embed.bert.wiki.base_char.by_cl_tohoku': 'bert_embeddings_base_japanese_char',
            'ja.embed.bert_base_ja_cased': 'bert_embeddings_bert_base_ja_cased',
            'ja.embed.bert_base_japanese_basic_char_v2': 'bert_embeddings_bert_base_japanese_basic_char_v2',
            'ja.embed.bert_base_japanese_char': 'bert_embeddings_bert_base_japanese_char',
            'ja.embed.bert_base_japanese_char_extended': 'bert_embeddings_bert_base_japanese_char_extended',
            'ja.embed.bert_base_japanese_char_v2': 'bert_embeddings_bert_base_japanese_char_v2',
            'ja.embed.bert_base_japanese_char_whole_word_masking': 'bert_embeddings_bert_base_japanese_char_whole_word_masking',
            'ja.embed.bert_base_japanese_v2': 'bert_embeddings_bert_base_japanese_v2',
            'ja.embed.bert_base_japanese_whole_word_masking': 'bert_embeddings_bert_base_japanese_whole_word_masking',
            'ja.embed.bert_large_japanese': 'bert_embeddings_bert_large_japanese',
            'ja.embed.bert_large_japanese_char': 'bert_embeddings_bert_large_japanese_char',
            'ja.embed.bert_large_japanese_char_extended': 'bert_embeddings_bert_large_japanese_char_extended',
            'ja.embed.bert_small_japanese': 'bert_embeddings_bert_small_japanese',
            'ja.embed.bert_small_japanese_fin': 'bert_embeddings_bert_small_japanese_fin',
            'ja.embed.distilbert_base_ja_cased': 'distilbert_embeddings_distilbert_base_ja_cased',
            'ja.embed.electra.base': 'electra_embeddings_electra_base_japanese_generator',
            'ja.embed.electra.small': 'electra_embeddings_electra_small_japanese_fin_generator',
            'ja.embed.electra.small.by_cinnamon': 'electra_embeddings_electra_small_japanese_generator',
            'ja.embed.electra.small_paper_japanese_fin_generator.small.by_izumi_lab': 'electra_embeddings_electra_small_paper_japanese_fin_generator',
            'ja.embed.electra.small_paper_japanese_generator.small.by_izumi_lab': 'electra_embeddings_electra_small_paper_japanese_generator',
            'ja.embed.glove.cc_300d': 'japanese_cc_300d',
            'ja.lemma': 'lemma',
            'ja.lemma.gsd': 'lemma_gsd',
            'ja.lemma.gsdluw': 'lemma_gsdluw',
            'ja.ner': 'ner_ud_gsd_glove_840B_300d',
            'ja.ner.base': 'ner_ud_gsd_bert_base_japanese',
            'ja.ner.bert': 'bert_token_classifier_ner_japanese',
            'ja.ner.pos.universal_dependencies.base': 'bert_pos_bert_base_japanese_luw_upos',
            'ja.ner.pos.universal_dependencies.base.by_KoichiYasuoka': 'bert_pos_bert_base_japanese_unidic_luw_upos',
            'ja.ner.pos.universal_dependencies.large': 'bert_pos_bert_large_japanese_luw_upos',
            'ja.ner.pos.universal_dependencies_luw_upos.large.by_KoichiYasuoka': 'bert_pos_bert_large_japanese_unidic_luw_upos',
            'ja.ner.pos.universal_dependencies_unidic_luw_upos.base.by_KoichiYasuoka': 'bert_pos_bert_base_japanese_upos',
            'ja.ner.pos.universal_dependencies_upos.large.by_KoichiYasuoka': 'bert_pos_bert_large_japanese_upos',
            'ja.ner.ud_gsd': 'ner_ud_gsd_glove_840B_300d',
            'ja.ner.ud_gsd.glove_840B_300D': 'ner_ud_gsd_glove_840B_300d',
            'ja.ner.ud_gsd_cc_300d': 'ner_ud_gsd_cc_300d',
            'ja.ner.ud_gsd_xlm_roberta_base': 'ner_ud_gsd_xlm_roberta_base',
            'ja.ner.xlmr_roberta.base': 'xlmroberta_ner_base_panx_dataset',
            'ja.ner.xlmr_roberta.large': 'xlmroberta_ner_large_panx_dataset',
            'ja.pos': 'pos_gsd',
            'ja.pos.gsd': 'pos_gsd',
            'ja.pos.gsdluw': 'pos_gsdluw',
            'ja.pos.ud_gsd': 'pos_ud_gsd',
            'ja.segment_words': 'wordseg_gsd_ud',
            'ja.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_japanese_hiragana',
            'ja.stopwords': 'stopwords_iso',
            'ja.stopwords.iso': 'stopwords_iso'},
        'jv': {'jv.embed.bert.imdb_javanese.small': 'bert_embeddings_javanese_small_imdb',
               'jv.embed.bert.small': 'bert_embeddings_javanese_small',
               'jv.embed.distil_bert.imdb_javanese.small': 'distilbert_embeddings_javanese_small_imdb',
               'jv.embed.distil_bert.small': 'distilbert_embeddings_javanese_small',
               'jv.embed.distilbert': 'distilbert_embeddings_javanese_distilbert_small',
               'jv.embed.javanese_bert_small': 'bert_embeddings_javanese_bert_small',
               'jv.embed.javanese_bert_small_imdb': 'bert_embeddings_javanese_bert_small_imdb',
               'jv.embed.javanese_distilbert_small_imdb': 'distilbert_embeddings_javanese_distilbert_small_imdb',
               'jv.embed.javanese_roberta_small': 'roberta_embeddings_javanese_roberta_small',
               'jv.embed.javanese_roberta_small_imdb': 'roberta_embeddings_javanese_roberta_small_imdb',
               'jv.embed.roberta.imdb_javanese.small': 'roberta_embeddings_javanese_small_imdb',
               'jv.embed.roberta.small': 'roberta_embeddings_javanese_small'},
        'ka': {'ka.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'kab': {'kab.speech2text.wav2vec_xlsr': 'asr_kabyle_xlsr',
                'kab.speech2text.wav2vec_xlsr.gpu': 'asr_kabyle_xlsr_gpu'},
        'kin': {'kin.ner.bert.uncased_base': 'bert_ner_mbert_base_uncased_kin',
                'kin.ner.bert.uncased_base.by_arnolfokam': 'bert_ner_mbert_base_uncased_ner_kin',
                'kin.ner.roberta.base': 'roberta_ner_roberta_base_kin'},
        'kn': {'kn.classify.xlmr_roberta': 'xlmroberta_classifier_deoffxlmr_mono_kannada',
               'kn.embed.KNUBert': 'roberta_embeddings_KNUBert',
               'kn.embed.KanBERTo': 'roberta_embeddings_KanBERTo',
               'kn.stopwords': 'stopwords_iso',
               'ml.detect_sentence': 'sentence_detector_dl'},
        'ko': {'ko.answer_question.bert': 'bert_qa_komrc_train',
               'ko.answer_question.bert.by_taekyoon': 'bert_qa_neg_komrc_train',
               'ko.answer_question.bert.klue.cased_multilingual_base_finetuned': 'bert_qa_bert_base_multilingual_cased_finetuned_klue',
               'ko.answer_question.bert.klue.v2_finetuned': 'bert_qa_kobert_finetuned_klue_v2',
               'ko.answer_question.bert.korquad.cased_multilingual_base': 'bert_qa_bert_base_multilingual_cased_korquad',
               'ko.answer_question.bert.korquad.cased_multilingual_base.by_eliza_dukim': 'bert_qa_bert_base_multilingual_cased_korquad_v1',
               'ko.answer_question.bert.squad.base_finetuned': 'bert_qa_kcbert_base_finetuned_squad',
               'ko.answer_question.bert.squad.finetuned': 'bert_qa_kobert_finetuned_squad_kor_v1',
               'ko.answer_question.electra': 'electra_qa_long',
               'ko.answer_question.klue.bert.base': 'bert_qa_ainize_klue_bert_base_mrc',
               'ko.answer_question.klue.bert.base.by_ainize': 'bert_qa_ainize_klue_bert_base_mrc',
               'ko.answer_question.klue.bert.base.by_bespin-global': 'bert_qa_bespin_global_klue_bert_base_mrc',
               'ko.answer_question.klue.bert.base_aihub.by_bespin-global': 'bert_qa_klue_bert_base_aihub_mrc',
               'ko.answer_question.klue.electra.base': 'electra_qa_klue_mrc_base',
               'ko.answer_question.klue.electra.base.by_obokkkk': 'electra_qa_base_v3_discriminator_finetuned_klue_v4',
               'ko.answer_question.klue.electra.base.by_seongju': 'electra_qa_klue_mrc_base',
               'ko.answer_question.korquad.electra.base': 'electra_qa_base_v3_finetuned_korquad',
               'ko.answer_question.korquad.electra.base_v2.by_monologg': 'electra_qa_base_v2_finetuned_korquad',
               'ko.answer_question.korquad.electra.base_v2_384.by_monologg': 'electra_qa_base_v2_finetuned_korquad_384',
               'ko.answer_question.korquad.electra.small': 'electra_qa_small_v3_finetuned_korquad',
               'ko.classify.bert': 'bert_classifier_kor_unsmile',
               'ko.classify.bert.by_dobbytk': 'bert_classifier_letr_sol_profanity_filter',
               'ko.classify.bert.cased_multilingual_base': 'bert_classifier_bert_base_multilingual_cased_nsmc',
               'ko.classify.bert.hate.': 'bert_classifier_hatescore_korean_hate_speech',
               'ko.classify.electra': 'electra_classifier_ko_senti_1',
               'ko.classify.electra.base': 'electra_classifier_beep_kc_base_bias',
               'ko.classify.electra.base.by_beomi': 'electra_classifier_beep_ko_base_v3_discriminator_bias',
               'ko.classify.electra.base.by_jminj': 'electra_classifier_ko_base_bad_sentence',
               'ko.classify.electra.base.by_mindlogic': 'electra_classifier_mindlogic_ko_ai_citizen_base',
               'ko.classify.electra.base.by_monologg': 'electra_classifier_ko_base_bias',
               'ko.classify.electra.base.kc.by_jminj': 'electra_classifier_kc_base_bad_sentence',
               'ko.classify.electra.base_finetuned': 'electra_classifier_ko_base_finetuned_nsmc',
               'ko.classify.electra.by_jaecheol': 'electra_classifier_nsmc_ko_test_model',
               'ko.classify.electra.by_searle_j': 'electra_classifier_kote_for_easygoing_people',
               'ko.classify.electra.gender.base': 'electra_classifier_ko_base_gender_bias',
               'ko.classify.electra.gender.base.by_monologg': 'electra_classifier_ko_base_v3_gender_bias',
               'ko.classify.electra.hate.': 'electra_classifier_korean_hatespeech',
               'ko.classify.electra.hate.base': 'electra_classifier_beep_kc_base_hate',
               'ko.classify.electra.hate.base.by_beomi': 'electra_classifier_beep_ko_base_v3_discriminator_hate',
               'ko.classify.electra.hate.base.by_monologg': 'electra_classifier_ko_base_v3_hate_speech',
               'ko.classify.electra.hate.by_beomi': 'electra_classifier_korean_hatespeech_multilabel',
               'ko.classify.electra.sentiment.base': 'electra_classifier_ko_base_v3_generalized_sentiment_analysis',
               'ko.classify.electra.sentiment.base_finetuned': 'electra_classifier_ko_base_finetuned_sentiment',
               'ko.classify.electra.sentiment.small_finetuned': 'electra_classifier_ko_small_finetuned_sentiment',
               'ko.classify.electra.small_finetuned': 'electra_classifier_ko_small_finetuned_intent_cls',
               'ko.classify.electra.small_finetuned.by_monologg': 'electra_classifier_ko_small_finetuned_nsmc',
               'ko.classify.electra.tunib.base.by_jminj': 'electra_classifier_tunib_base_bad_sentence',
               'ko.classify.electra_v3.base.by_monologg': 'electra_classifier_ko_base_v3_bias',
               'ko.classify.roberta.base': 'roberta_classifier_soongsil_bert_base_apeach',
               'ko.classify.roberta.base.by_jason9693': 'roberta_classifier_soongsilbert_base_beep',
               'ko.classify.roberta.small': 'roberta_classifier_soongsil_bert_small_apeach',
               'ko.embed.KR_FinBert': 'bert_embeddings_KR_FinBert',
               'ko.embed.bert': 'bert_embeddings_bert_base',
               'ko.embed.bert.base': 'bert_embeddings_kor_base',
               'ko.embed.bert_base_v1_sports': 'bert_embeddings_bert_base_v1_sports',
               'ko.embed.bert_kor_base': 'bert_embeddings_bert_kor_base',
               'ko.embed.dbert': 'bert_embeddings_dbert',
               'ko.embed.electra': 'electra_embeddings_kr_electra_generator',
               'ko.embed.electra.base': 'electra_embeddings_finance_koelectra_base_generator',
               'ko.embed.electra.by_deeq': 'electra_embeddings_delectra_generator',
               'ko.embed.electra.small': 'electra_embeddings_finance_koelectra_small_generator',
               'ko.embed.electra.small.by_monologg': 'electra_embeddings_koelectra_small_generator',
               'ko.embed.electra.v2_base': 'electra_embeddings_koelectra_base_v2_generator',
               'ko.embed.koelelectra.base.by_monologg': 'electra_embeddings_koelectra_base_generator',
               'ko.embed.koelelectra.base_v3.by_monologg': 'electra_embeddings_koelectra_base_v3_generator',
               'ko.embed.roberta_ko_small': 'roberta_embeddings_roberta_ko_small',
               'ko.lemma': 'lemma_gsd',
               'ko.lemma.gsd': 'lemma_gsd',
               'ko.lemma.kaist': 'lemma_kaist',
               'ko.ner': 'ner_kmou_glove_840B_300d',
               'ko.ner.kmou': 'ner_kmou_glove_840B_300d',
               'ko.ner.kmou.glove_840B_300d': 'ner_kmou_glove_840B_300d',
               'ko.ner.xlmr_roberta.base': 'xlmroberta_ner_base_panx_dataset',
               'ko.ner.xlmr_roberta.large': 'xlmroberta_ner_large_panx_dataset',
               'ko.pos': 'pos_gsd',
               'ko.pos.gsd': 'pos_gsd',
               'ko.pos.kaist': 'pos_kaist',
               'ko.pos.ud_kaist': 'pos_ud_kaist',
               'ko.segment_words': 'wordseg_kaist_ud',
               'ko.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_korean',
               'ko.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_korean_gpu',
               'ko.stopwords': 'stopwords_iso'},
        'kr': {'kr.speech2text.wav2vec_xlsr.v2': 'asr_wav2vec2_xlsr_korean_senior',
               'kr.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xlsr_korean_senior_gpu'},
        'ku': {'ku.speech2text.wav2vec_xlsr': 'asr_xlsr_kurmanji_kurdish',
               'ku.speech2text.wav2vec_xlsr.gpu': 'asr_xlsr_kurmanji_kurdish_gpu'},
        'ky': {'ky.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_kyrgyz',
               'ky.speech2text.wav2vec_xlsr.v2_large.by_adilism': 'asr_wav2vec2_large_xlsr_kyrgyz_by_adilism',
               'ky.speech2text.wav2vec_xlsr.v2_large.by_iarfmoose': 'asr_wav2vec2_large_xlsr_kyrgyz_by_iarfmoose',
               'ky.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_kyrgyz_gpu',
               'ky.speech2text.wav2vec_xlsr.v2_large_gpu.by_adilism': 'asr_wav2vec2_large_xlsr_kyrgyz_by_adilism_gpu',
               'ky.speech2text.wav2vec_xlsr.v2_large_gpu.by_iarfmoose': 'asr_wav2vec2_large_xlsr_kyrgyz_by_iarfmoose_gpu',
               'ky.stopwords': 'stopwords_iso'},
        'la': {'la.embed.bert': 'bert_embeddings_cicero_similis',
               'la.lemma': 'lemma_proiel',
               'la.lemma.ittb': 'lemma_ittb',
               'la.lemma.llct': 'lemma_llct',
               'la.lemma.perseus': 'lemma_perseus',
               'la.lemma.proiel': 'lemma_proiel',
               'la.lemma.udante': 'lemma_udante',
               'la.pos': 'pos_perseus',
               'la.pos.ittb': 'pos_ittb',
               'la.pos.llct': 'pos_llct',
               'la.pos.perseus': 'pos_perseus',
               'la.pos.proiel': 'pos_proiel',
               'la.pos.udante': 'pos_udante',
               'la.speech2text.wav2vec2.v2_base': 'asr_wav2vec2_base_latin',
               'la.speech2text.wav2vec2.v2_base_gpu': 'asr_wav2vec2_base_latin_gpu',
               'la.stopwords': 'stopwords_la'},
        'lb': {'lb.embed.w2v_cc_300d': 'w2v_cc_300d',
               'lb.lemma': 'lemma_spacylookup',
               'lb.stopwords': 'stopwords_iso'},
        'lg': {'lg.embed.xlm_roberta': 'xlm_roberta_base_finetuned_luganda',
               'lg.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_luganda',
               'lg.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_luganda',
               'lg.ner.xlmr_roberta.base_finetuned_luganda.by_mbeukman': 'xlmroberta_ner_base_finetuned_luganda_finetuned_luganda',
               'lg.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_base_finetuned_swahili_finetuned_luganda',
               'lg.speech2text.wav2vec2.v2': 'asr_wav2vec2_luganda_by_birgermoell',
               'lg.speech2text.wav2vec2.v2.by_cahya': 'asr_wav2vec2_luganda_by_cahya',
               'lg.speech2text.wav2vec2.v2.by_indonesian_nlp': 'asr_wav2vec2_luganda_by_indonesian_nlp',
               'lg.speech2text.wav2vec2.v2_gpu': 'asr_wav2vec2_luganda_by_birgermoell_gpu',
               'lg.speech2text.wav2vec2.v2_gpu.by_cahya': 'asr_wav2vec2_luganda_by_cahya_gpu',
               'lg.speech2text.wav2vec2.v2_gpu.by_indonesian_nlp': 'asr_wav2vec2_luganda_by_indonesian_nlp_gpu',
               'lg.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_luganda',
               'lg.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_luganda_gpu',
               'lg.speech2text.wav2vec_xlsr.v2_multilingual': 'asr_wav2vec2_xlsr_multilingual_56',
               'lg.speech2text.wav2vec_xlsr.v2_multilingual_gpu': 'asr_wav2vec2_xlsr_multilingual_56_gpu'},
        'lij': {'lij.stopwords': 'stopwords_iso'},
        'lmo': {'lmo.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'lo': {'lo.ner.pos.base': 'roberta_pos_lao_roberta_base_pos_tagger'},
        'lou': {'lou.embed.xlm_roberta': 'xlm_roberta_base_finetuned_luo'},
        'lt': {'lt.embed.bert.cased_base': 'bert_embeddings_base_lt_cased',
               'lt.embed.w2v_cc_300d': 'w2v_cc_300d',
               'lt.lemma': 'lemma_spacylookup',
               'lt.lemma.alksnis': 'lemma_alksnis',
               'lt.lemma.spacylookup': 'lemma_spacylookup',
               'lt.pos.alksnis': 'pos_alksnis',
               'lt.speech2text.wav2vec2': 'asr_common_voice_lithuanian_fairseq',
               'lt.speech2text.wav2vec2.gpu': 'asr_common_voice_lithuanian_fairseq_gpu',
               'lt.speech2text.wav2vec2.v2': 'asr_wav2vec2_common_voice_lithuanian',
               'lt.speech2text.wav2vec2.v2.by_seccily': 'asr_wav2vec_lite',
               'lt.speech2text.wav2vec2.v2_gpu': 'asr_wav2vec2_common_voice_lithuanian_gpu',
               'lt.speech2text.wav2vec2.v2_gpu.by_seccily': 'asr_wav2vec_lite_gpu',
               'lt.speech2text.wav2vec_xlsr.l_v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_lithuanian_by_anton_l_gpu',
               'lt.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xlsr_lithuanian_gpu',
               'lt.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_lithuanian_by_deividasm',
               'lt.speech2text.wav2vec_xlsr.v2_large.by_anton_l': 'asr_wav2vec2_large_xlsr_53_lithuanian_by_anton_l',
               'lt.speech2text.wav2vec_xlsr.v2_large.by_dundar': 'asr_wav2vec2_large_xlsr_53_lithuanian_by_dundar',
               'lt.speech2text.wav2vec_xlsr.v2_large.by_m3hrdadfi': 'asr_wav2vec2_large_xlsr_lithuanian',
               'lt.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_lithuanian_by_deividasm_gpu',
               'lt.speech2text.wav2vec_xlsr.v2_large_gpu.by_dundar': 'asr_wav2vec2_large_xlsr_53_lithuanian_by_dundar_gpu',
               'lt.speech2text.wav2vec_xlsr.v2_large_gpu.by_m3hrdadfi': 'asr_wav2vec2_large_xlsr_lithuanian_gpu',
               'lt.stopwords': 'stopwords_iso'},
        'lu': {'lu.embed.bert.medium': 'bert_embeddings_medium_luxembourgish'},
        'luo': {
            'luo.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_luo_finetuned_ner',
            'luo.ner.xlmr_roberta.base_finetuned_ner.by_mbeukman': 'xlmroberta_ner_base_finetuned_ner',
            'luo.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_base_finetuned_swahili_finetuned_ner'},
        'lv': {'lv.lemma': 'lemma',
               'lv.lemma.lvtb': 'lemma_lvtb',
               'lv.pos': 'pos_lvtb',
               'lv.pos.lvtb': 'pos_lvtb',
               'lv.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_latvian',
               'lv.speech2text.wav2vec_xlsr.v2_large.by_jimregan': 'asr_wav2vec2_large_xlsr_latvian',
               'lv.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xls_r_1b_common_voice7_gpu',
               'lv.speech2text.wav2vec_xlsr.v2_large_gpu.by_anton_l': 'asr_wav2vec2_large_xlsr_53_latvian_gpu',
               'lv.speech2text.wav2vec_xlsr.v2_large_gpu.by_jimregan': 'asr_wav2vec2_large_xlsr_latvian_gpu',
               'lv.stopwords': 'stopwords_iso',
               'lv.stopwords.iso': 'stopwords_iso'},
        'lwt': {
            'lwt.answer_question.distil_roberta.squadv2.distilled_base_finetuned': 'roberta_qa_distilroberta_base_finetuned_squad2_lwt',
            'lwt.answer_question.roberta.squadv2.base_finetuned': 'roberta_qa_roberta_base_finetuned_squad2_lwt'},
        'lzh': {'lzh.lemma': 'lemma_kyoto',
                'lzh.lemma.kyoto': 'lemma_kyoto',
                'lzh.pos.kyoto': 'pos_kyoto'},
        'mai': {'mai.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'mg': {'mg.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'min': {'min.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'mk': {'mk.embed.w2v_cc_300d': 'w2v_cc_300d',
               'mk.lemma': 'lemma_spacylookup',
               'mk.stopwords': 'stopwords_iso'},
        'ml': {'ml.classify.roberta.news.': 'roberta_classifier_malayalam_news',
               'ml.classify.xlmr_roberta': 'xlmroberta_classifier_deoffxlmr_mono_malyalam',
               'ml.detect_sentence': 'sentence_detector_dl',
               'ml.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ml.stopwords': 'stopwords_iso'},
        'mn': {'mn.embed.w2v_cc_300d': 'w2v_cc_300d',
               'mn.ner.roberta.base': 'roberta_ner_roberta_base_ner',
               'mn.ner.roberta.base.by_bayartsogt': 'roberta_ner_bayartsogt_roberta_base_ner_demo',
               'mn.ner.roberta.base.by_buyandelger': 'roberta_ner_buyandelger_roberta_base_ner_demo',
               'mn.speech2text.wav2vec_xlsr.l_v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_mongolian_by_anton_l_gpu',
               'mn.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_mongolian_by_anton_l',
               'mn.speech2text.wav2vec_xlsr.v2_large.by_manandey': 'asr_wav2vec2_large_xlsr_mongolian_by_manandey',
               'mn.speech2text.wav2vec_xlsr.v2_large.by_tugstugi': 'asr_wav2vec2_large_xlsr_53_mongolian_by_tugstugi',
               'mn.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_mongolian_by_tugstugi_gpu',
               'mn.speech2text.wav2vec_xlsr.v2_large_gpu.by_manandey': 'asr_wav2vec2_large_xlsr_mongolian_by_manandey_gpu'},
        'mr': {'mr.detect_sentence': 'sentence_detector_dl',
               'mr.embed.albert': 'albert_embeddings_marathi_albert',
               'mr.embed.albert_v2': 'albert_embeddings_marathi_albert_v2',
               'mr.embed.distil_bert': 'distilbert_embeddings_marathi',
               'mr.embed.distilbert': 'distilbert_embeddings_marathi_distilbert',
               'mr.embed.marathi_bert': 'bert_embeddings_marathi_bert',
               'mr.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
               'mr.embed.xlmr_roberta': 'xlmroberta_embeddings_marathi_roberta',
               'mr.lemma': 'lemma_ufal',
               'mr.lemma.ufal': 'lemma_ufal',
               'mr.ner.bert': 'bert_ner_marathi_ner',
               'mr.pos': 'pos_ufal',
               'mr.pos.ufal': 'pos_ufal',
               'mr.stopwords': 'stopwords_iso',
               'mr.stopwords.iso': 'stopwords_iso'},
        'ms': {'ms.answer_question.bert.squad.base': 'bert_qa_squad_ms_bert_base',
               'ms.embed.albert': 'albert_embeddings_albert_large_bahasa_cased',
               'ms.embed.albert_base_bahasa_cased': 'albert_embeddings_albert_base_bahasa_cased',
               'ms.embed.albert_tiny_bahasa_cased': 'albert_embeddings_albert_tiny_bahasa_cased',
               'ms.embed.bert': 'bert_embeddings_melayubert',
               'ms.embed.distil_bert.small': 'distilbert_embeddings_malaysian_small',
               'ms.embed.distilbert': 'distilbert_embeddings_malaysian_distilbert_small',
               'ms.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'mt': {'mt.embed.camembert': 'camembert_embeddings_camembert_aux_amandes',
               'mt.embed.w2v_cc_300d': 'w2v_cc_300d',
               'mt.lemma': 'lemma_mudt',
               'mt.lemma.mudt': 'lemma_mudt',
               'mt.pos': 'pos_mudt'},
        'mwl': {'mwl.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'my': {'my.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'myv': {'myv.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'mzn': {'mzn.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'nah': {'nah.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'nap': {'nap.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'nb': {'nb.classify.bert.large': 'bert_classifier_nb_large_user_needs',
               'nb.lemma': 'lemma_spacylookup',
               'nb.lemma.spacylookup': 'lemma_spacylookup',
               'nb.pos': 'pos_ud_bokmaal',
               'nb.stopwords': 'stopwords_iso'},
        'nds': {'nds.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ne': {'ne.detect_sentence': 'sentence_detector_dl',
               'ne.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ne.stopwords': 'stopwords_iso'},
        'new': {'new.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'nl': {
            'nl.answer_question.bert.tydiqa.multilingual': 'bert_qa_part_2_bert_multilingual_dutch_model_e1',
            'nl.answer_question.squadv2.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_dutch_squad2',
            'nl.classify.bert': 'bert_classifier_republic',
            'nl.classify.bert.cased_base': 'bert_classifier_bert_base_dutch_cased_hebban_reviews',
            'nl.classify.bert.cased_multilingual_base': 'bert_classifier_bert_base_multilingual_cased_hebban_reviews',
            'nl.classify.bert.frombertje2_dadialog02.by_jeska': 'bert_classifier_vaccinchatsentenceclassifierdutch_frombertje2_dadialog02',
            'nl.classify.bert.frombertje2_dadialogqonly.by_jeska': 'bert_classifier_vaccinchatsentenceclassifierdutch_frombertje2_dadialogqonly',
            'nl.classify.bert.frombertje2_dadialogqonly09.by_jeska': 'bert_classifier_vaccinchatsentenceclassifierdutch_frombertje2_dadialogqonly09',
            'nl.classify.bert.frombertjedial.by_jeska': 'bert_classifier_vaccinchatsentenceclassifierdutch_frombertjedial',
            'nl.classify.bert.news.finetuned': 'bert_classifier_dutch_news_clf_finetuned',
            'nl.classify.bert.sentiment.cased_base_finetuned': 'bert_classifier_base_dutch_cased_finetuned_sentiment',
            'nl.classify.distil_bert.cased_base': 'distilbert_sequence_classifier_distilbert_base_dutch_cased_toxic_comments',
            'nl.classify.roberta': 'roberta_classifier_autonlp_savesome_631818261',
            'nl.classify.roberta.base': 'roberta_classifier_robbert_dutch_base_toxic_comments',
            'nl.classify.roberta.sentiment.': 'roberta_classifier_robbertje_merged_dutch_sentiment',
            'nl.classify.roberta.sentiment.v2': 'roberta_classifier_robbert_v2_dutch_sentiment',
            'nl.classify.roberta.sentiment_twitter.': 'roberta_classifier_robbert_twitter_sentiment_custom',
            'nl.classify.roberta.v2_base': 'roberta_classifier_robbert_v2_dutch_base_hebban_reviews',
            'nl.embed': 'dutch_cc_300d',
            'nl.embed.bert': 'bert_base_dutch_cased',
            'nl.embed.bert.base_cased': 'bert_base_cased',
            'nl.embed.bert.cased_base': 'bert_embeddings_base_dutch_cased',
            'nl.embed.bert.cased_base.by_geotrend': 'bert_embeddings_base_nl_cased',
            'nl.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_nl_cased',
            'nl.embed.robbert_v2_dutch_base': 'roberta_embeddings_robbert_v2_dutch_base',
            'nl.embed.robbertje_1_gb_bort': 'roberta_embeddings_robbertje_1_gb_bort',
            'nl.embed.robbertje_1_gb_merged': 'roberta_embeddings_robbertje_1_gb_merged',
            'nl.embed.robbertje_1_gb_non_shuffled': 'roberta_embeddings_robbertje_1_gb_non_shuffled',
            'nl.embed.robbertje_1_gb_shuffled': 'roberta_embeddings_robbertje_1_gb_shuffled',
            'nl.embed.roberta': 'roberta_embeddings_medroberta.nl',
            'nl.embed.roberta.conll.v2_base': 'roberta_embeddings_pdelobelle_robbert_v2_dutch_base',
            'nl.embed.w2v_cc_300d': 'w2v_cc_300d',
            'nl.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
            'nl.lemma': 'lemma_spacylookup',
            'nl.lemma.lassysmall': 'lemma_lassysmall',
            'nl.lemma.spacylookup': 'lemma_spacylookup',
            'nl.lemma_alpino': 'lemma_alpino',
            'nl.ner': 'wikiner_6B_100',
            'nl.ner.bert': 'bert_token_classifier_dutch_udlassy_ner',
            'nl.ner.bert.cased_base_finetuned': 'bert_ner_bert_base_dutch_cased_finetuned_sonar_ner',
            'nl.ner.bert.cased_base_finetuned.by_wietsedv': 'bert_ner_bert_base_dutch_cased_finetuned_udlassy_ner',
            'nl.ner.bert.cased_multilingual_base': 'bert_ner_bert_base_multilingual_cased_ner_hrl',
            'nl.ner.bert.conll.cased_base_finetuned': 'bert_ner_bert_base_dutch_cased_finetuned_conll2002_ner',
            'nl.ner.bert.wikineural.multilingual': 'bert_ner_wikineural_multilingual_ner',
            'nl.ner.distil_bert.cased_multilingual_base': 'distilbert_ner_distilbert_base_multilingual_cased_ner_hrl',
            'nl.ner.distil_bert.conll.cased_multilingual_base_finetuned': 'distilbert_ner_distilbert_base_multilingual_cased_finetuned_conll2003_ner',
            'nl.ner.pos': 'roberta_pos_veganuary_pos',
            'nl.ner.pos.cased_base': 'bert_pos_bert_base_dutch_cased_upos_alpino',
            'nl.ner.pos.cased_base.by_gronlp': 'bert_pos_bert_base_dutch_cased_upos_alpino_gronings',
            'nl.ner.pos.cased_base_finetuned': 'bert_pos_bert_base_dutch_cased_finetuned_lassysmall_pos',
            'nl.ner.pos.cased_base_finetuned.by_wietsedv': 'bert_pos_bert_base_dutch_cased_finetuned_udlassy_pos',
            'nl.ner.roberta.conll.v2': 'roberta_ner_robbert_v2_dutch_ner',
            'nl.ner.wikiner': 'wikiner_6B_300',
            'nl.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
            'nl.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
            'nl.ner.xlmr_roberta.base': 'xlmroberta_ner_xlm_roberta_base_ner_hrl',
            'nl.ner.xlmr_roberta.base.by_ml6team': 'xlmroberta_ner_xlm_roberta_base_nl_emoji_ner',
            'nl.ner.xlmr_roberta.large': 'xlmroberta_ner_xlm_roberta_large_ner_hrl',
            'nl.pos': 'pos_ud_alpino',
            'nl.pos.alpino': 'pos_alpino',
            'nl.pos.fullstop_dutch_punctuation_prediction': 'roberta_pos_fullstop_dutch_punctuation_prediction',
            'nl.pos.lassysmall': 'pos_lassysmall',
            'nl.pos.ud_alpino': 'pos_ud_alpino',
            'nl.speech2text.wav2vec2.v2': 'asr_wav2vec2_common_voice_demo',
            'nl.speech2text.wav2vec2.v2_gpu': 'asr_wav2vec2_common_voice_demo_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s379_exp': 'asr_exp_w2v2t_wav2vec2_s379_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s408_vp_exp': 'asr_exp_w2v2t_vp_100k_s408_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s461_exp': 'asr_exp_w2v2t_pretraining_s461_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s510_vp_exp': 'asr_exp_w2v2t_vp_s510_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s607_vp_exp': 'asr_exp_w2v2t_vp_s607_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s703_vp_exp': 'asr_exp_w2v2t_vp_s703_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s721_exp': 'asr_exp_w2v2t_wav2vec2_s721_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s754_exp': 'asr_exp_w2v2t_wav2vec2_s754_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s772_vp_exp': 'asr_exp_w2v2t_vp_100k_s772_gpu',
            'nl.speech2text.wav2vec2.v2_gpu_s899_vp_exp': 'asr_exp_w2v2t_vp_100k_s899_gpu',
            'nl.speech2text.wav2vec2.v2_large': 'asr_wav2vec2_dutch_large_cgn',
            'nl.speech2text.wav2vec2.v2_large_3h': 'asr_wav2vec2_dutch_large_cgn_3hrs',
            'nl.speech2text.wav2vec2.v2_large_3h.by_bartelds': 'asr_wav2vec2_large_cgn_3hrs',
            'nl.speech2text.wav2vec2.v2_large_3h_gpu': 'asr_wav2vec2_dutch_large_cgn_3hrs_gpu',
            'nl.speech2text.wav2vec2.v2_large_3h_gpu.by_bartelds': 'asr_wav2vec2_large_cgn_3hrs_gpu',
            'nl.speech2text.wav2vec2.v2_large_gpu': 'asr_wav2vec2_dutch_large_cgn_gpu',
            'nl.speech2text.wav2vec2.v2_s379_exp': 'asr_exp_w2v2t_wav2vec2_s379',
            'nl.speech2text.wav2vec2.v2_s408_vp_exp': 'asr_exp_w2v2t_vp_100k_s408',
            'nl.speech2text.wav2vec2.v2_s510_vp_exp': 'asr_exp_w2v2t_vp_s510',
            'nl.speech2text.wav2vec2.v2_s607_vp_exp': 'asr_exp_w2v2t_vp_s607',
            'nl.speech2text.wav2vec2.v2_s703_vp_exp': 'asr_exp_w2v2t_vp_s703',
            'nl.speech2text.wav2vec2.v2_s721_exp': 'asr_exp_w2v2t_wav2vec2_s721',
            'nl.speech2text.wav2vec2.v2_s754_exp': 'asr_exp_w2v2t_wav2vec2_s754',
            'nl.speech2text.wav2vec2.v2_s772_vp_exp': 'asr_exp_w2v2t_vp_100k_s772',
            'nl.speech2text.wav2vec2.v2_s899_vp_exp': 'asr_exp_w2v2t_vp_100k_s899',
            'nl.speech2text.wav2vec2.voxpopuli.v2_base_gpu': 'asr_wav2vec2_base_10k_voxpopuli_gpu',
            'nl.speech2text.wav2vec_xlsr.300m': 'asr_xlsr300m_7.0_lm',
            'nl.speech2text.wav2vec_xlsr.300m.by_iskaj': 'asr_xlsr300m_8.0',
            'nl.speech2text.wav2vec_xlsr.300m_gpu': 'asr_xlsr300m_7.0_lm_gpu',
            'nl.speech2text.wav2vec_xlsr.300m_gpu.by_iskaj': 'asr_xlsr300m_8.0_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_gpu_s799_exp': 'asr_exp_w2v2t_xlsr_53_s799_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_gpu_s948_exp': 'asr_exp_w2v2t_xlsr_53_s948_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_gpu_s972_exp': 'asr_exp_w2v2t_xlsr_53_s972_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_dutch',
            'nl.speech2text.wav2vec_xlsr.v2_large.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_dutch_by_jonatasgrosman',
            'nl.speech2text.wav2vec_xlsr.v2_large.by_nithinholla': 'asr_wav2vec2_large_xlsr_53_dutch_by_nithinholla',
            'nl.speech2text.wav2vec_xlsr.v2_large.by_simonsr': 'asr_wav2vec2_large_xlsr_dutch',
            'nl.speech2text.wav2vec_xlsr.v2_large.by_wietsedv': 'asr_wav2vec2_large_xlsr_53_dutch_by_wietsedv',
            'nl.speech2text.wav2vec_xlsr.v2_large.dutch.by_facebook': 'asr_wav2vec2_large_xlsr_53_dutch_by_facebook',
            'nl.speech2text.wav2vec_xlsr.v2_large.polish.by_facebook': 'asr_wav2vec2_large_xlsr_53_polish_by_facebook',
            'nl.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_dutch_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu.by_jonatasgrosman': 'asr_wav2vec2_large_xlsr_53_dutch_by_jonatasgrosman_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu.by_nithinholla': 'asr_wav2vec2_large_xlsr_53_dutch_by_nithinholla_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu.by_simonsr': 'asr_wav2vec2_large_xlsr_dutch_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu.by_wietsedv': 'asr_wav2vec2_large_xlsr_53_dutch_by_wietsedv_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu.dutch.by_facebook': 'asr_wav2vec2_large_xlsr_53_dutch_by_facebook_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_large_gpu.polish.by_facebook': 'asr_wav2vec2_large_xlsr_53_polish_by_facebook_gpu',
            'nl.speech2text.wav2vec_xlsr.v2_s799_exp': 'asr_exp_w2v2t_xlsr_53_s799',
            'nl.speech2text.wav2vec_xlsr.v2_s948_exp': 'asr_exp_w2v2t_xlsr_53_s948',
            'nl.speech2text.wav2vec_xlsr.v2_s972_exp': 'asr_exp_w2v2t_xlsr_53_s972',
            'nl.stopwords': 'stopwords_iso'},
        'nn': {'nn.embed.w2v_cc_300d': 'w2v_cc_300d',
               'nn.pos': 'pos_ud_nynorsk',
               'nn.pos.ud_nynorsk': 'pos_ud_nynorsk'},
        'no': {'no.embed.bert': 'bert_embeddings_norbert',
               'no.embed.bert.by_ltgoslo': 'bert_embeddings_norbert2',
               'no.embed.bert.cased_base': 'bert_embeddings_base_no_cased',
               'no.embed.w2v_cc_300d': 'w2v_cc_300d',
               'no.lemma': 'lemma_nynorsk',
               'no.lemma.bokmaal': 'lemma_bokmaal',
               'no.lemma.nynorsk': 'lemma_nynorsk',
               'no.lemma.nynorsklia': 'lemma_nynorsklia',
               'no.ner.bert.wikiann.cased_multilingual_base_finetuned': 'bert_token_classifier_base_multilingual_cased_finetuned_norsk_ner',
               'no.ner.norne': 'norne_6B_100',
               'no.ner.norne.100d': 'norne_6B_100',
               'no.ner.norne.glove.6B_300': 'norne_6B_300',
               'no.ner.norne.glove.840B_300': 'norne_840B_300',
               'no.pos': 'pos_bokmaal',
               'no.pos.bokmaal': 'pos_bokmaal',
               'no.pos.nynorsk': 'pos_nynorsk',
               'no.pos.nynorsklia': 'pos_nynorsklia'},
        'nso': {'nso.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'oc': {'oc.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'or': {'or.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'orv': {'orv.lemma': 'lemma_torot',
                'orv.lemma.rnc': 'lemma_rnc',
                'orv.lemma.torot': 'lemma_torot',
                'orv.pos.rnc': 'pos_rnc',
                'orv.pos.torot': 'pos_torot'},
        'os': {'os.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'pa': {'pa.detect_sentence': 'sentence_detector_dl',
               'pa.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
               'pa.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'pcm': {'pcm.embed.xlm_roberta': 'xlm_roberta_base_finetuned_naija',
                'pcm.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_naija',
                'pcm.lemma.nsc': 'lemma_nsc',
                'pcm.ner.bert.uncased_base': 'bert_ner_mbert_base_uncased_ner_pcm',
                'pcm.ner.bert.uncased_base.by_arnolfokam': 'bert_ner_mbert_base_uncased_pcm',
                'pcm.ner.roberta.base': 'roberta_ner_roberta_base_pcm',
                'pcm.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_naija',
                'pcm.ner.xlmr_roberta.base_finetuned_naija.by_mbeukman': 'xlmroberta_ner_base_finetuned_naija_finetuned_naija',
                'pcm.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_base_finetuned_swahili_finetuned_naija',
                'pcm.pos.nsc': 'pos_nsc'},
        'pfl': {'pfl.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'pl': {
            'pl.answer_question.squad.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_polish_squad1',
            'pl.answer_question.squadv2.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetuned_polish_squad2',
            'pl.classify.bert.hate.': 'bert_classifier_dehatebert_mono_polish',
            'pl.classify.bert.multi2convai.': 'bert_classifier_multi2convai_logistics',
            'pl.embed.bert.cased_base': 'bert_embeddings_base_pl_cased',
            'pl.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_pl_cased',
            'pl.embed.w2v_cc_300d': 'w2v_cc_300d',
            'pl.lemma': 'lemma_lfg',
            'pl.lemma.lfg': 'lemma_lfg',
            'pl.lemma.pdb': 'lemma_pdb',
            'pl.ner': 'wikiner_6B_100',
            'pl.ner.wikiner': 'wikiner_6B_100',
            'pl.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
            'pl.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
            'pl.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
            'pl.pos': 'pos_ud_lfg',
            'pl.pos.flg': 'pos_lfg',
            'pl.pos.pdb': 'pos_pdb',
            'pl.pos.ud_lfg': 'pos_ud_lfg',
            'pl.stopwords': 'stopwords_iso',
            'pl.stopwords.iso': 'stopwords_iso'},
        'pms': {'pms.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'pnb': {'pnb.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ps': {'ps.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'pt': {
            'pt.answer_question.distil_bert.squad.finetuned': 'distilbert_qa_finetuned_squad',
            'pt.answer_question.squad.bert.base_cased': 'bert_qa_bert_base_portuguese_cased_finetuned_squad_v1_pt_mrm8488',
            'pt.answer_question.squad.bert.base_cased.by_mrm8488': 'bert_qa_bert_base_portuguese_cased_finetuned_squad_v1_pt_mrm8488',
            'pt.answer_question.squad.bert.base_cased.by_pierreguillou': 'bert_qa_bert_base_cased_squad_v1.1_portuguese',
            'pt.answer_question.squad.bert.large_cased': 'bert_qa_bert_large_cased_squad_v1.1_portuguese',
            'pt.answer_question.squad.biobert': 'bert_qa_bioBERTpt_squad_v1.1_portuguese',
            'pt.answer_question.squad.distil_bert': 'distilbert_qa_multi_finedtuned_squad',
            'pt.bert': 'bert_portuguese_base_cased',
            'pt.bert.cased': 'bert_portuguese_base_cased',
            'pt.bert.cased.large': 'bert_portuguese_large_cased',
            'pt.classify.bert': 'bert_classifier_paraphrase',
            'pt.classify.bert.hate.': 'bert_classifier_dehatebert_mono_portugese',
            'pt.embed.BR_BERTo': 'roberta_embeddings_BR_BERTo',
            'pt.embed.bert.cased_base': 'bert_embeddings_base_portuguese_cased',
            'pt.embed.bert.cased_base.by_geotrend': 'bert_embeddings_base_pt_cased',
            'pt.embed.bert_base_cased_pt_lenerbr': 'bert_embeddings_bert_base_cased_pt_lenerbr',
            'pt.embed.bert_base_gl_cased': 'bert_embeddings_bert_base_gl_cased',
            'pt.embed.bert_base_portuguese_cased': 'bert_embeddings_bert_base_portuguese_cased',
            'pt.embed.bert_base_portuguese_cased_finetuned_peticoes': 'bert_embeddings_bert_base_portuguese_cased_finetuned_peticoes',
            'pt.embed.bert_base_portuguese_cased_finetuned_tcu_acordaos': 'bert_embeddings_bert_base_portuguese_cased_finetuned_tcu_acordaos',
            'pt.embed.bert_base_pt_cased': 'bert_embeddings_bert_base_pt_cased',
            'pt.embed.bert_large_cased_pt_lenerbr': 'bert_embeddings_bert_large_cased_pt_lenerbr',
            'pt.embed.bert_large_portuguese_cased': 'bert_embeddings_bert_large_portuguese_cased',
            'pt.embed.bert_small_gl_cased': 'bert_embeddings_bert_small_gl_cased',
            'pt.embed.biobert': 'bert_embeddings_biobertpt_all',
            'pt.embed.biobert.by_pucpr': 'bert_embeddings_biobertpt_bio',
            'pt.embed.biobert.clinical.by_pucpr': 'bert_embeddings_biobertpt_clin',
            'pt.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_pt_cased',
            'pt.embed.gs_all': 'biobert_embeddings_all',
            'pt.embed.gs_biomedical': 'biobert_embeddings_biomedical',
            'pt.embed.gs_clinical': 'biobert_embeddings_clinical',
            'pt.embed.w2v_cc_300d': 'w2v_cc_300d',
            'pt.embed_sentence.bert.base_legal': 'sbert_legal_bertimbau_base_tsdae_sts',
            'pt.embed_sentence.bert.cased_large_legal': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.1',
            'pt.embed_sentence.bert.large_legal': 'sbert_legal_bertimbau_large_gpl_sts',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.10.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.10',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.2.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.2',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.3.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.3',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.4.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.4',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.5.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.5',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.7.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.7',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.8.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.8',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v0.9.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v0.9',
            'pt.embed_sentence.bert.legal.cased_large_mlm_sts_v1.0.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_sts_v1.0',
            'pt.embed_sentence.bert.legal.cased_large_mlm_v0.11_gpl_nli_sts_v0.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_v0.11_gpl_nli_sts_v0',
            'pt.embed_sentence.bert.legal.cased_large_mlm_v0.11_gpl_nli_sts_v1.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_v0.11_gpl_nli_sts_v1',
            'pt.embed_sentence.bert.legal.cased_large_mlm_v0.11_nli_sts_v0.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_v0.11_nli_sts_v0',
            'pt.embed_sentence.bert.legal.cased_large_mlm_v0.11_nli_sts_v1.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_v0.11_nli_sts_v1',
            'pt.embed_sentence.bert.legal.cased_large_mlm_v0.11_sts_v0.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_v0.11_sts_v0',
            'pt.embed_sentence.bert.legal.cased_large_mlm_v0.11_sts_v1.by_stjiris': 'sbert_bert_large_portuguese_cased_legal_mlm_v0.11_sts_v1',
            'pt.embed_sentence.bert.v2_base_legal': 'sbert_legal_bertimbau_sts_base_ma_v2',
            'pt.embed_sentence.bert.v2_large_legal': 'sbert_legal_bertimbau_large_tsdae_sts_v2',
            'pt.embed_sentence.bertimbau.legal.assin.base.by_rufimelo': 'sbert_legal_bertimbau_sts_base_ma',
            'pt.embed_sentence.bertimbau.legal.assin2.base.by_rufimelo': 'sbert_legal_bertimbau_sts_base',
            'pt.embed_sentence.bertimbau.legal.large_sts_by_rufimelo': 'sbert_legal_bertimbau_sts_large',
            'pt.embed_sentence.bertimbau.legal.large_sts_ma.by_rufimelo': 'sbert_legal_bertimbau_sts_large_ma',
            'pt.embed_sentence.bertimbau.legal.large_sts_ma_v3.by_rufimelo': 'sbert_legal_bertimbau_sts_large_ma_v3',
            'pt.embed_sentence.bertimbau.legal.large_tsdae_sts.by_rufimelo': 'sbert_legal_bertimbau_large_tsdae_sts',
            'pt.embed_sentence.bertimbau.legal.large_tsdae_sts_v4.by_rufimelo': 'sbert_legal_bertimbau_large_tsdae_sts_v4',
            'pt.embed_sentence.bertimbau.legal.large_tsdae_v4_gpl_sts.by_rufimelo': 'sbert_legal_bertimbau_large_tsdae_v4_gpl_sts',
            'pt.embed_sentence.bertimbau.legal.v2_large_sts_v2.by_rufimelo': 'sbert_legal_bertimbau_sts_large_v2',
            'pt.embed_sentence.bertimbau.legal.v2_large_v2_sts.by_rufimelo': 'sbert_legal_bertimbau_large_v2_sts',
            'pt.lemma': 'lemma_bosque',
            'pt.lemma.bosque': 'lemma_bosque',
            'pt.lemma.gsd': 'lemma_gsd',
            'pt.lemma.spacylookup': 'lemma_spacylookup',
            'pt.ner': 'wikiner_6B_100',
            'pt.ner.bert': 'bert_ner_satellite_instrument_bert_ner',
            'pt.ner.bert.base': 'bert_ner_bert_base_pt_archive',
            'pt.ner.bert.base.by_luciano': 'bert_ner_bertimbau_base_lener_br_luciano',
            'pt.ner.bert.by_dominguesm': 'bert_token_classifier_restore_punctuation_ptbr',
            'pt.ner.bert.cased_base': 'bert_ner_ner_bert_base_cased_pt_lenerbr',
            'pt.ner.bert.clinical.': 'bert_token_classifier_clinicalnerpt_diagnostic',
            'pt.ner.bert.clinical.disease': 'bert_token_classifier_clinicalnerpt_disease',
            'pt.ner.bert.clinical_chemical.': 'bert_token_classifier_clinicalnerpt_chemical',
            'pt.ner.bert.clinical_disorder.by_pucpr': 'bert_token_classifier_clinicalnerpt_disorder',
            'pt.ner.bert.clinical_finding.by_pucpr': 'bert_token_classifier_clinicalnerpt_finding',
            'pt.ner.bert.large': 'bert_ner_bertimbau_large_lener_br_luciano',
            'pt.ner.bert.news.': 'bert_ner_ner_news_portuguese',
            'pt.ner.biobert': 'bert_token_classifier_biobertpt_clin_tempclinbr',
            'pt.ner.pos': 'bert_pos_autonlp_pos_tag_bosque',
            'pt.ner.satellite_instrument_roberta_NER': 'roberta_ner_satellite_instrument_roberta_NER',
            'pt.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
            'pt.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
            'pt.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
            'pt.pos': 'pos_ud_bosque',
            'pt.pos.bosque': 'pos_bosque',
            'pt.pos.gsd': 'pos_gsd',
            'pt.pos.ud_bosque': 'pos_ud_bosque',
            'pt.speech2text.wav2vec2.v2_gpu_s250_exp': 'asr_exp_w2v2t_wav2vec2_s250_gpu',
            'pt.speech2text.wav2vec2.v2_gpu_s515_exp': 'asr_exp_w2v2t_wav2vec2_s515_gpu',
            'pt.speech2text.wav2vec2.v2_gpu_s645_vp_exp': 'asr_exp_w2v2t_vp_100k_s645_gpu',
            'pt.speech2text.wav2vec2.v2_gpu_s660_vp_exp': 'asr_exp_w2v2t_vp_100k_s660_gpu',
            'pt.speech2text.wav2vec2.v2_gpu_s69_vp_exp': 'asr_exp_w2v2t_vp_100k_s69_gpu',
            'pt.speech2text.wav2vec2.v2_gpu_s859_exp': 'asr_exp_w2v2t_wav2vec2_s859_gpu',
            'pt.speech2text.wav2vec2.v2_s250_exp': 'asr_exp_w2v2t_wav2vec2_s250',
            'pt.speech2text.wav2vec2.v2_s515_exp': 'asr_exp_w2v2t_wav2vec2_s515',
            'pt.speech2text.wav2vec2.v2_s645_vp_exp': 'asr_exp_w2v2t_vp_100k_s645',
            'pt.speech2text.wav2vec2.v2_s660_vp_exp': 'asr_exp_w2v2t_vp_100k_s660',
            'pt.speech2text.wav2vec2.v2_s69_vp_exp': 'asr_exp_w2v2t_vp_100k_s69',
            'pt.speech2text.wav2vec2.v2_s859_exp': 'asr_exp_w2v2t_wav2vec2_s859',
            'pt.speech2text.wav2vec2.voxpopuli.v2_large': 'asr_wav2vec2_large_100k_voxpopuli_tts_dataset_portuguese',
            'pt.speech2text.wav2vec2.voxpopuli.v2_large_gpu': 'asr_wav2vec2_large_100k_voxpopuli_tts_dataset_portuguese_gpu',
            'pt.speech2text.wav2vec_xlsr': 'asr_bp500_xlsr',
            'pt.speech2text.wav2vec_xlsr.commonvoice10.by_lgris': 'asr_bp_commonvoice10_xlsr',
            'pt.speech2text.wav2vec_xlsr.commonvoice10.gpu.by_lgris': 'asr_bp_commonvoice10_xlsr_gpu',
            'pt.speech2text.wav2vec_xlsr.commonvoice100.by_lgris': 'asr_bp_commonvoice100_xlsr',
            'pt.speech2text.wav2vec_xlsr.commonvoice100.gpu.by_lgris': 'asr_bp_commonvoice100_xlsr_gpu',
            'pt.speech2text.wav2vec_xlsr.gpu': 'asr_bp500_xlsr_gpu',
            'pt.speech2text.wav2vec_xlsr.lapsbm1.by_lgris': 'asr_bp_lapsbm1_xlsr',
            'pt.speech2text.wav2vec_xlsr.lapsbm1.gpu.by_lgris': 'asr_bp_lapsbm1_xlsr_gpu',
            'pt.speech2text.wav2vec_xlsr.sidi10.by_lgris': 'asr_bp_sid10_xlsr',
            'pt.speech2text.wav2vec_xlsr.sidi10.gpu.by_lgris': 'asr_bp_sid10_xlsr_gpu',
            'pt.speech2text.wav2vec_xlsr.tedx100.by_lgris': 'asr_bp_tedx100_xlsr',
            'pt.speech2text.wav2vec_xlsr.tedx100.gpu.by_lgris': 'asr_bp_tedx100_xlsr_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_400h': 'asr_wav2vec2_xls_r_cv7_from_bp400h',
            'pt.speech2text.wav2vec_xlsr.v2_400h_gpu': 'asr_wav2vec2_xls_r_cv7_from_bp400h_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xls_r_1b_portuguese_coraa_3_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_gpu_s454_exp': 'asr_exp_w2v2t_xlsr_53_s454_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_gpu_s677_exp': 'asr_exp_w2v2t_xlsr_53_s677_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_coraa_portuguese_cv7',
            'pt.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_coraa_portuguese_cv7_gpu',
            'pt.speech2text.wav2vec_xlsr.v2_s454_exp': 'asr_exp_w2v2t_xlsr_53_s454',
            'pt.speech2text.wav2vec_xlsr.v2_s677_exp': 'asr_exp_w2v2t_xlsr_53_s677',
            'pt.speech2text.wav2vec_xlsr.voxforge1.by_lgris': 'asr_bp_voxforge1_xlsr',
            'pt.speech2text.wav2vec_xlsr.voxforge1.gpu.by_lgris': 'asr_bp_voxforge1_xlsr_gpu',
            'pt.stopwords': 'stopwords_iso',
            'pt.stopwords.iso': 'stopwords_iso'},
        'qhe': {'qhe.lemma': 'lemma_hiencs',
                'qhe.pos': 'pos_hiencs',
                'qhe.pos.hiencs': 'pos_hiencs'},
        'qtd': {'qtd.lemma': 'lemma_sagt',
                'qtd.lemma.sagt': 'lemma_sagt',
                'qtd.pos': 'pos_sagt'},
        'qu': {'qu.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'rm': {'rm.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'ro': {'ro.embed.ALR_BERT': 'albert_embeddings_ALR_BERT',
               'ro.embed.bert.cased_base': 'bert_base_cased',
               'ro.embed.bert.cased_base.by_geotrend': 'bert_embeddings_base_ro_cased',
               'ro.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_ro_cased',
               'ro.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ro.lemma': 'lemma_spacylookup',
               'ro.lemma.nonstandard': 'lemma_nonstandard',
               'ro.lemma.rrt': 'lemma_rrt',
               'ro.lemma.simonero': 'lemma_simonero',
               'ro.lemma.spacylookup': 'lemma_spacylookup',
               'ro.pos': 'pos_nonstandard',
               'ro.pos.nonstandard': 'pos_nonstandard',
               'ro.pos.rrt': 'pos_rrt',
               'ro.pos.simonero': 'pos_simonero',
               'ro.pos.ud_rrt': 'pos_ud_rrt',
               'ro.speech2text.wav2vec2.v2': 'asr_romanian_wav2vec2',
               'ro.speech2text.wav2vec2.v2_gpu': 'asr_romanian_wav2vec2_gpu',
               'ro.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_romanian_by_anton_l',
               'ro.speech2text.wav2vec_xlsr.v2_large.by_gmihaila': 'asr_wav2vec2_large_xlsr_53_romanian_by_gmihaila',
               'ro.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_romanian_by_gmihaila_gpu',
               'ro.stopwords': 'stopwords_iso',
               'ro.stopwords.iso': 'stopwords_iso'},
        'ru': {'ru.answer_question.bert': 'bert_qa_deep_pavlov_full',
               'ru.answer_question.bert.pavalov.by_ruselkomp': 'bert_qa_deep_pavlov_full_2',
               'ru.answer_question.bert.squad.large_finetuned': 'bert_qa_ruselkomp_sbert_large_nlu_ru_finetuned_squad_full',
               'ru.answer_question.bert.squad.large_finetuned.by_Timur1984': 'bert_qa_timur1984_sbert_large_nlu_ru_finetuned_squad_full',
               'ru.answer_question.bert.tes.by_ruselkomp': 'bert_qa_sber_full_tes',
               'ru.answer_question.distil_bert': 'distilbert_qa_model_QA_5_epoch_RU',
               'ru.answer_question.xlm_roberta.multilingual_large': 'xlm_roberta_qa_xlm_roberta_large_qa_multilingual_finedtuned_ru_ru_alexkay',
               'ru.classify.bert': 'bert_classifier_rubertconv_toxic_clf',
               'ru.classify.bert.base': 'bert_classifier_response_quality_base',
               'ru.classify.bert.base.by_rexhaif': 'bert_classifier_ru_base_srl',
               'ru.classify.bert.base.by_skolkovoinstitute': 'bert_classifier_rubert_base_corruption_detector',
               'ru.classify.bert.base.by_tinkoff_ai': 'bert_classifier_response_toxicity_base',
               'ru.classify.bert.by_skolkovoinstitute': 'bert_classifier_russian_toxicity',
               'ru.classify.bert.cased_base': 'bert_classifier_rubert_base_cased_dp_paraphrase_detection',
               'ru.classify.bert.sentiment.': 'bert_sequence_classifier_rubert_sentiment',
               'ru.classify.bert.sentiment.cased_base': 'bert_classifier_rubert_base_cased_sentiment',
               'ru.classify.bert.sentiment.cased_base.by_Tatyana': 'bert_classifier_rubert_base_cased_sentiment_new',
               'ru.classify.bert.sentiment.tiny': 'bert_classifier_rubert_tiny_sentiment_balanced',
               'ru.classify.bert.sentiment_medicine.cased_base.by_blanchefort': 'bert_classifier_rubert_base_cased_sentiment_med',
               'ru.classify.bert.tiny': 'bert_classifier_response_quality_tiny',
               'ru.classify.bert.tiny.by_aniemore': 'bert_classifier_rubert_tiny2_russian_emotion_detection',
               'ru.classify.bert.tiny.by_chgk13': 'bert_classifier_tiny_russian_toxic',
               'ru.classify.emotion.bert.tiny.by_cointegrated': 'bert_classifier_rubert_tiny2_cedr_emotion_detection',
               'ru.classify.sentiment.bert.sentiment.cased_base.by_blanchefort': 'bert_classifier_rubert_base_cased_sentiment_rusentiment',
               'ru.classify.sentiment.reviews.bert.sentiment.cased_base.by_blanchefort': 'bert_classifier_rubert_base_cased_sentiment_rurewiews',
               'ru.classify.toxic': 'bert_sequence_classifier_toxicity',
               'ru.classify.toxic.bert.tiny.by_cointegrated': 'bert_classifier_rubert_tiny_toxicity',
               'ru.detect_sentence': 'sentence_detector_dl',
               'ru.embed.bert.cased_base': 'bert_embeddings_base_ru_cased',
               'ru.embed.bert_base_ru_cased': 'bert_embeddings_bert_base_ru_cased',
               'ru.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_ru_cased',
               'ru.embed.roberta_base_russian_v0': 'roberta_embeddings_roberta_base_russian_v0',
               'ru.embed.ruRoberta_large': 'roberta_embeddings_ruRoberta_large',
               'ru.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ru.lemma': 'lemma_gsd',
               'ru.lemma.gsd': 'lemma_gsd',
               'ru.lemma.spacylookup': 'lemma_spacylookup',
               'ru.lemma.syntagrus': 'lemma_syntagrus',
               'ru.lemma.taiga': 'lemma_taiga',
               'ru.ner': 'wikiner_6B_100',
               'ru.ner.bert': 'bert_ner_labse_ner_nerel',
               'ru.ner.bert.by_ilyagusev': 'bert_ner_rubertconv_toxic_editor',
               'ru.ner.pos.universal_dependencies.base': 'bert_pos_bert_base_russian_upos',
               'ru.ner.wikiner': 'wikiner_6B_100',
               'ru.ner.wikiner.glove.6B_100': 'wikiner_6B_100',
               'ru.ner.wikiner.glove.6B_300': 'wikiner_6B_300',
               'ru.ner.wikiner.glove.840B_300': 'wikiner_840B_300',
               'ru.ner.xlmr_roberta.base': 'xlmroberta_ner_base_panx_dataset',
               'ru.ner.xlmr_roberta.large': 'xlmroberta_ner_large_panx_dataset',
               'ru.pos': 'pos_syntagrus',
               'ru.pos.gsd': 'pos_gsd',
               'ru.pos.syntagrus': 'pos_syntagrus',
               'ru.pos.taiga': 'pos_taiga',
               'ru.pos.ud_gsd': 'pos_ud_gsd',
               'ru.stopwords': 'stopwords_iso',
               'ru.stopwords.iso': 'stopwords_iso'},
        'rw': {'rw.embed.xlm_roberta': 'xlm_roberta_base_finetuned_kinyarwanda',
               'rw.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_kinyarwanda',
               'rw.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_kinyarwanda_finetuned_ner_kinyarwand',
               'rw.ner.xlmr_roberta.base_finetuned_kinyarwand.by_mbeukman': 'xlmroberta_ner_base_finetuned_ner_kinyarwand',
               'rw.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_base_finetuned_swahili_finetuned_ner_kinyarwand'},
        'sa': {'sa.embed.w2v_cc_300d': 'w2v_cc_300d',
               'sa.lemma': 'lemma_vedic',
               'sa.pos': 'pos_vedic',
               'sa.stopwords': 'stopwords_iso'},
        'sae': {
            'sae.answer_question.roberta.squad.base': 'roberta_qa_sae_roberta_base_squad'},
        'sah': {'sah.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'sc': {'sc.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'scn': {'scn.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'sco': {'sco.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'sd': {'sd.detect_sentence': 'sentence_detector_dl',
               'sd.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'sg': {
            'sg.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_swiss_german',
            'sg.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_swiss_german_gpu'},
        'sh': {'sh.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'si': {'si.answer_question.bert.base': 'bert_qa_bert_base_sinhala_qa',
               'si.embed.roberta': 'roberta_embeddings_sinhalaberto',
               'si.embed.w2v_cc_300d': 'w2v_cc_300d',
               'si.stopwords': 'stopwords_iso'},
        'sk': {'sk.embed.bert': 'bert_embeddings_fernet_cc',
               'sk.embed.roberta': 'roberta_embeddings_slovakbert',
               'sk.embed.roberta.news.': 'roberta_embeddings_fernet_news',
               'sk.embed.w2v_cc_300d': 'w2v_cc_300d',
               'sk.lemma': 'lemma_snk',
               'sk.lemma.snk': 'lemma_snk',
               'sk.ner.bert.wikiann.': 'bert_token_classifier_fernet_cc_sk_ner',
               'sk.ner.pos': 'roberta_pos_veganuary_pos',
               'sk.ner.pos.universal_dependencies.': 'roberta_pos_slovakbert_pos',
               'sk.ner.roberta.wikiann.distilled': 'roberta_ner_distil_slovakbert_ner',
               'sk.pos': 'pos_ud_snk',
               'sk.pos.snk': 'pos_snk',
               'sk.pos.ud_snk': 'pos_ud_snk',
               'sk.stopwords': 'stopwords_iso',
               'sk.stopwords.iso': 'stopwords_iso'},
        'sl': {'sl.embed.camembert': 'camembert_embeddings_sloberta',
               'sl.embed.w2v_cc_300d': 'w2v_cc_300d',
               'sl.lemma': 'lemma_sst',
               'sl.lemma.ssj': 'lemma_ssj',
               'sl.lemma.sst': 'lemma_sst',
               'sl.pos': 'pos_sst',
               'sl.pos.ssj': 'pos_ssj',
               'sl.pos.sst': 'pos_sst',
               'sl.stopwords': 'stopwords_iso',
               'sl.stopwords.iso': 'stopwords_iso'},
        'sme': {'sme.lemma': 'lemma_giella', 'sme.pos': 'pos_giella'},
        'so': {'so.detect_sentence': 'sentence_detector_dl',
               'so.embed.w2v_cc_300d': 'w2v_cc_300d',
               'so.stopwords': 'stopwords_so'},
        'sq': {
            'sq.answer_question.bert.uncased_base': 'bert_qa_bert_base_uncased_fiqa_flm_sq_flit',
            'sq.embed.w2v_cc_300d': 'w2v_cc_300d',
            'sq.ner.bert.cased_base': 'bert_ner_mbert_base_albanian_cased_ner',
            'sq.ner.bert.wikiann.cased_multilingual_base_finetuned': 'bert_token_classifier_base_multilingual_cased_finetuned_albanian_ner',
            'sq.stopwords': 'stopwords_iso'},
        'sr': {'sr.embed.w2v_cc_300d': 'w2v_cc_300d',
               'sr.lemma': 'lemma_spacylookup',
               'sr.lemma.set': 'lemma_set',
               'sr.lemma.spacylookup': 'lemma_spacylookup',
               'sr.pos': 'pos_set',
               'sr.pos.set': 'pos_set',
               'sr.stopwords': 'stopwords_iso',
               'sr.stopwords.iso': 'stopwords_iso'},
        'st': {'st.ner.roberta.tweet.large': 'roberta_ner_tner_roberta_large_tweet_st_2020',
               'st.ner.roberta.tweet.large.by_asahi417': 'roberta_ner_tner_roberta_large_tweet_st_asahi417',
               'st.stopwords': 'stopwords_st'},
        'su': {'su.classify.bert.base': 'bert_classifier_sundanese_base_emotion',
               'su.classify.roberta.base': 'roberta_classifier_sundanese_base_emotion',
               'su.embed.sundanese_roberta_base': 'roberta_embeddings_sundanese_roberta_base',
               'su.embed.w2v_cc_300d': 'w2v_cc_300d',
               'su.speech2text.wav2vec2.v2': 'asr_wav2vec2_indonesian_javanese_sundanese',
               'su.speech2text.wav2vec2.v2_gpu': 'asr_wav2vec2_indonesian_javanese_sundanese_gpu',
               'su.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_sundanese',
               'su.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_sundanese_gpu'},
        'sv': {
            'sv.answer_question.bert.squad.cased': 'bert_qa_bert_multi_cased_squad_sv_marbogusz',
            'sv.answer_question.bert.squad.cased_base': 'bert_qa_bert_base_swedish_cased_squad_experimental',
            'sv.answer_question.bert.squad.cased_base.by_KBLab': 'bert_qa_base_swedish_cased_squad_experimental',
            'sv.answer_question.squadv2.bert.base': 'bert_qa_bert_base_swedish_squad2',
            'sv.answer_question.xlmr_roberta.large': 'xlm_roberta_qa_xlmr_large_qa_sv_sv_m3hrdadfi',
            'sv.classify.bert.sentiment.cased_base': 'bert_classifier_base_swedish_cased_sentiment',
            'sv.classify.token_bert.swedish_ner': 'bert_token_classifier_swedish_ner',
            'sv.embed.bert.base_cased': 'bert_base_cased',
            'sv.embed.bert.cased_base': 'bert_embeddings_kb_base_swedish_cased',
            'sv.embed.bert.cased_base.by_kblab': 'bert_embeddings_kblab_base_swedish_cased',
            'sv.embed.bert.distilled_cased': 'bert_embeddings_kb_distilled_cased',
            'sv.embed.w2v_cc_300d': 'w2v_cc_300d',
            'sv.embed_sentence.bert.base_cased': 'sent_bert_base_cased',
            'sv.lemma': 'lemma_lines',
            'sv.lemma.lines': 'lemma_lines',
            'sv.lemma.spacylookup': 'lemma_spacylookup',
            'sv.lemma.talbanken': 'lemma_talbanken',
            'sv.ner': 'swedish_ner_6B_100',
            'sv.ner.6B_100': 'swedish_ner_6B_100',
            'sv.ner.6B_300': 'swedish_ner_6B_300',
            'sv.ner.840B_300': 'swedish_ner_840B_300',
            'sv.ner.bert': 'bert_ner_swedish_ner',
            'sv.ner.bert.base': 'bert_token_classifier_base_swedish_lowermix_reallysimple_ner',
            'sv.ner.bert.cased_base': 'bert_ner_kb_bert_base_swedish_cased_ner',
            'sv.ner.bert.cased_base.by_kblab': 'bert_ner_kblab_bert_base_swedish_cased_ner',
            'sv.ner.bert.cased_base.neriob.by_kblab': 'bert_ner_bert_base_swedish_cased_neriob',
            'sv.ner.bert.finetuned': 'bert_ner_bert_finetuned_ner_swedish_test',
            'sv.ner.bert.finetuned.by_nonzerophilip': 'bert_ner_bert_finetuned_ner_swedish_test_numb_2',
            'sv.ner.bert.large_finetuned': 'bert_ner_bert_finetuned_ner_swedish_test_large_set',
            'sv.ner.bert.sentiment.': 'bert_ner_swedish_sentiment_fear_targets',
            'sv.ner.bert.sentiment.by_recordedfuture': 'bert_ner_swedish_sentiment_violence_targets',
            'sv.ner.bert.small_finetuned': 'bert_ner_bert_finetuned_ner_swedish_small_set_health_and_standart',
            'sv.ner.pos.cased_base': 'bert_pos_bert_base_swedish_cased_pos',
            'sv.pos': 'pos_ud_tal',
            'sv.pos.lines': 'pos_lines',
            'sv.pos.talbanken': 'pos_talbanken',
            'sv.pos.ud_tal': 'pos_ud_tal',
            'sv.speech2text.wav2vec2': 'asr_lm_swedish',
            'sv.speech2text.wav2vec2.by_marma': 'asr_test_by_marma',
            'sv.speech2text.wav2vec2.gpu': 'asr_test_by_marma_gpu',
            'sv.speech2text.wav2vec2.v2': 'asr_wav2vec2_swedish_common_voice',
            'sv.speech2text.wav2vec2.v2_large': 'asr_wav2vec2_large_voxrex_swedish_4gram',
            'sv.speech2text.wav2vec2.v2_large_gpu': 'asr_wav2vec2_large_voxrex_swedish_4gram_gpu',
            'sv.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_welsh',
            'sv.speech2text.wav2vec_xlsr.v2_large.by_marma': 'asr_wav2vec2_large_xlsr_swedish',
            'sv.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_welsh_gpu',
            'sv.speech2text.wav2vec_xlsr.v2_large_gpu.by_marma': 'asr_wav2vec2_large_xlsr_swedish_gpu',
            'sv.stopwords': 'stopwords_iso',
            'sv.stopwords.iso': 'stopwords_iso'},
        'sw': {
            'sw.answer_question.tydiqa.xlm_roberta.base': 'xlm_roberta_qa_afriberta_base_finetuned_tydiqa',
            'sw.classify.bert.news.': 'bert_classifier_bert_swahili_news_classification',
            'sw.classify.sentiment.': 'classifierdl_xlm_roberta_sentiment',
            'sw.embed.bert.cased_base': 'bert_embeddings_base_sw_cased',
            'sw.embed.w2v_cc_300d': 'w2v_cc_300d',
            'sw.embed.xlm_roberta': 'xlm_roberta_base_finetuned_swahili',
            'sw.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_swahili',
            'sw.ner.bert.uncased_base': 'bert_ner_bert_base_uncased_swa',
            'sw.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_amharic_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_hausa.by_mbeukman': 'xlmroberta_ner_base_finetuned_hausa_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_igbo.by_mbeukman': 'xlmroberta_ner_base_finetuned_igbo_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_kinyarwanda.by_mbeukman': 'xlmroberta_ner_base_finetuned_kinyarwanda_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_luganda.by_mbeukman': 'xlmroberta_ner_base_finetuned_luganda_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_luo.by_mbeukman': 'xlmroberta_ner_base_finetuned_luo_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_naija.by_mbeukman': 'xlmroberta_ner_base_finetuned_naija_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_base_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_swahili.v2.by_mbeukman': 'xlmroberta_ner_base_finetuned_swahili_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_wolof.by_mbeukman': 'xlmroberta_ner_base_finetuned_wolof_finetuned_ner_swahili',
            'sw.ner.xlmr_roberta.base_finetuned_yoruba.by_mbeukman': 'xlmroberta_ner_base_finetuned_yoruba_finetuned_ner_swahili',
            'sw.stopwords': 'stopwords_sw'},
        'swa': {'swa.ner.bert.uncased_base': 'bert_ner_mbert_base_uncased_ner_swa',
                'swa.ner.bert.uncased_base.by_arnolfokam': 'bert_ner_mbert_base_uncased_swa',
                'swa.ner.roberta.base': 'roberta_ner_roberta_base_swa'},
        'ta': {
            'ta.answer_question.bert.chaii.cased_multilingual_base_finetuned': 'bert_qa_bert_base_multilingual_cased_finetuned_chaii',
            'ta.answer_question.squad.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_squad_tamil',
            'ta.classify.xlmr_roberta': 'xlmroberta_classifier_deoffxlmr_mono_tamil',
            'ta.detect_sentence': 'sentence_detector_dl',
            'ta.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
            'ta.embed.w2v_cc_300d': 'w2v_cc_300d',
            'ta.lemma': 'lemma',
            'ta.lemma.ttb': 'lemma_ttb',
            'ta.pos': 'pos_ttb',
            'ta.stopwords': 'stopwords_iso'},
        'te': {'te.detect_sentence': 'sentence_detector_dl',
               'te.embed.bert': 'bert_embeddings_indic_transformers',
               'te.embed.distil_bert': 'distilbert_embeddings_indic_transformers',
               'te.embed.distilbert': 'distilbert_uncased',
               'te.embed.indic_transformers_te_bert': 'bert_embeddings_indic_transformers_te_bert',
               'te.embed.indic_transformers_te_roberta': 'roberta_embeddings_indic_transformers_te_roberta',
               'te.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
               'te.embed.roberta': 'roberta_embeddings_indic_transformers',
               'te.embed.telugu_bertu': 'bert_embeddings_telugu_bertu',
               'te.embed.w2v_cc_300d': 'w2v_cc_300d',
               'te.embed.xlmr_roberta': 'xlmroberta_embeddings_indic_transformers_te_xlmroberta',
               'te.lemma': 'lemma_mtg',
               'te.pos': 'pos_mtg',
               'te.stopwords': 'stopwords_iso'},
        'tg': {'tg.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'th': {
            'th.answer_question.bert.multilingual_base_cased': 'bert_qa_bert_base_multilingual_cased_finetune_qa',
            'th.answer_question.squadv2.xlm_roberta.base': 'xlm_roberta_qa_thai_xlm_roberta_base_squad2',
            'th.answer_question.xquad.multi_lingual_bert.base': 'bert_qa_xquad_th_mbert_base',
            'th.answer_question.xquad_squad.bert.cased': 'bert_qa_thai_bert_multi_cased_finetuned_xquadv1_finetuned_squad',
            'th.classify.sentiment': 'sentiment_jager_use',
            'th.embed.bert.cased_base': 'bert_embeddings_base_th_cased',
            'th.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_th_cased',
            'th.embed.w2v_cc_300d': 'w2v_cc_300d',
            'th.ner.lst20.glove_840B_300D': 'ner_lst20_glove_840B_300d',
            'th.ner.pos.universal_dependencies.base': 'bert_pos_bert_base_thai_upos',
            'th.pos': 'pos_lst20',
            'th.segment_words': 'wordseg_best',
            'th.sentiment': 'sentiment_jager_use',
            'th.stopwords': 'stopwords_iso',
            'th.stopwords.iso': 'stopwords_iso'},
        'ti': {'ti.classify.roberta': 'roberta_classifier_ti_geezswitch',
               'ti.classify.roberta.sentiment.': 'roberta_classifier_ti_sentiment',
               'ti.ner.pos': 'roberta_pos_veganuary_pos',
               'ti.stopwords': 'stopwords_iso'},
        'tk': {'tk.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'tl': {
            'tl.embed.electra.cased_base': 'electra_embeddings_electra_tagalog_base_cased_generator',
            'tl.embed.electra.cased_small': 'electra_embeddings_electra_tagalog_small_cased_generator',
            'tl.embed.electra.uncased_base': 'electra_embeddings_electra_tagalog_base_uncased_generator',
            'tl.embed.electra.uncased_small': 'electra_embeddings_electra_tagalog_small_uncased_generator',
            'tl.embed.roberta.base': 'roberta_embeddings_tagalog_base',
            'tl.embed.roberta.large': 'roberta_embeddings_tagalog_large',
            'tl.embed.roberta_tagalog_base': 'roberta_embeddings_roberta_tagalog_base',
            'tl.embed.roberta_tagalog_large': 'roberta_embeddings_roberta_tagalog_large',
            'tl.embed.w2v_cc_300d': 'w2v_cc_300d',
            'tl.lemma': 'lemma_spacylookup',
            'tl.stopwords': 'stopwords_iso'},
        'tn': {'tn.embed.roberta': 'roberta_embeddings_tswanabert',
               'tn.stopwords': 'stopwords_iso'},
        'tr': {
                'tr.distilbert.zero_shot_classifier.multinli': 'distilbert_base_zero_shot_classifier_turkish_cased_multinli',
            'tr.distilbert.zero_shot_classifier.allnli': 'distilbert_base_zero_shot_classifier_turkish_cased_allnli',
            'tr.distilbert.zero_shot_classifier.snli': 'distilbert_base_zero_shot_classifier_turkish_cased_snli',
        'tr.answer_question.bert': 'bert_qa_bert_turkish_question_answering',
               'tr.answer_question.bert.base_uncased': 'bert_qa_loodos_bert_base_uncased_QA_fine_tuned',
               'tr.answer_question.bert.by_lserinol': 'bert_qa_bert_turkish_question_answering',
               'tr.answer_question.bert.by_yunusemreemik': 'bert_qa_logo_qna_model',
               'tr.answer_question.bert.cased_base_128d_finetuned_epochs_3': 'bert_qa_base_turkish_128k_cased_finetuned_lr_2e_05_epochs_3',
               'tr.answer_question.bert.cased_base_finetuned_epochs_3': 'bert_qa_bert_base_turkish_cased_finetuned_lr_2e_05_epochs_3',
               'tr.answer_question.bert.distilled': 'bert_qa_distilbert_tr_q_a',
               'tr.answer_question.bert.onwhol': 'bert_qa_modelonwhol',
               'tr.answer_question.bert.squadv2.cased_v2': 'bert_qa_question_answering_cased_squadv2',
               'tr.answer_question.bert.squadv2.uncased_v2': 'bert_qa_question_answering_uncased_squadv2',
               'tr.answer_question.bert.tquad.': 'bert_qa_modelontquad',
               'tr.answer_question.bert.tquad.cased_base_128d_finetuned_epochs_1': 'bert_qa_base_turkish_128k_cased_tquad2_finetuned_lr_2e_05_epochs_1',
               'tr.answer_question.bert.tquad.cased_base_128d_finetuned_epochs_3': 'bert_qa_base_turkish_128k_cased_tquad2_finetuned_lr_2e_05_epochs_3',
               'tr.answer_question.electra': 'electra_qa_turkish',
               'tr.answer_question.electra.small_uncased': 'electra_qa_small_turkish_uncased_discriminator_finetuned',
               'tr.answer_question.squad.bert.base': 'bert_qa_bert_base_turkish_squad',
               'tr.answer_question.squad.electra': 'electra_qa_enelpi_squad',
               'tr.answer_question.squad.electra.base': 'electra_qa_base_discriminator_finetuned_squadv1',
               'tr.answer_question.squadv2.electra.base_v2': 'electra_qa_base_discriminator_finetuned_squadv2',
               'tr.answer_question.xlm_roberta': 'xlm_roberta_qa_XLM_Turkish',
               'tr.classify.bert': 'bert_classifier_autotrain_sentanaly_1016134101',
               'tr.classify.bert.base': 'bert_classifier_bert_base_turkish_bullying',
               'tr.classify.bert.by_akoksal': 'bert_classifier_bounti',
               'tr.classify.bert.by_gurkan08': 'bert_classifier_gurkan08_turkish_text_classification',
               'tr.classify.bert.by_hemekci': 'bert_classifier_off_detection_turkish',
               'tr.classify.bert.by_savasy': 'bert_classifier_savasy_turkish_text_classification',
               'tr.classify.bert.multi2convai.': 'bert_classifier_multi2convai_logistics',
               'tr.classify.bert.news.': 'bert_classifier_interpress_turkish_news_classification',
               'tr.classify.bert.sentiment.': 'bert_sequence_classifier_turkish_sentiment',
               'tr.classify.bert.sentiment.by_emre': 'bert_classifier_turkish_sentiment_analysis',
               'tr.classify.bert.sentiment.by_gurkan08': 'bert_classifier_turkish_product_comment_sentiment_classification',
               'tr.classify.bert.sentiment.cased_base': 'bert_classifier_bert_base_turkish_sentiment_cased',
               'tr.classify.bert.tweet_sentiment.': 'bert_classifier_sentiment_tweets',
               'tr.classify.bert.uncased': 'bert_classifier_lex_textclassification_turkish_uncased',
               'tr.classify.cyberbullying': 'classifierdl_berturk_cyberbullying',
               'tr.classify.distil_bert.cased_base': 'distilbert_sequence_classifier_distilbert_base_turkish_cased_emotion',
               'tr.classify.electra.base': 'electra_classifier_qd_dialog_base_turkish',
               'tr.classify.electra.base.by_izzet': 'electra_classifier_qd_quora_base_turkish',
               'tr.classify.electra.sentiment.': 'electra_classifier_turkish_sentiment_analysis',
               'tr.classify.electra.tweet.base': 'electra_classifier_qd_tweet_base_turkish',
               'tr.classify.news': 'classifierdl_bert_news',
               'tr.classify.sentiment.': 'classifierdl_use_sentiment',
               'tr.classify.token_bert.turkish_ner': 'bert_token_classifier_turkish_ner',
               'tr.embed.bert': 'bert_base_turkish_cased',
               'tr.embed.bert.cased_base': 'bert_embeddings_base_tr_cased',
               'tr.embed.bert.uncased': 'bert_base_turkish_uncased',
               'tr.embed.bert_cased': 'bert_embeddings_bert_base_tr_cased',
               'tr.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_tr_cased',
               'tr.embed.electra.cased_base': 'electra_embeddings_electra_base_turkish_mc4_cased_generator',
               'tr.embed.electra.uncased_base': 'electra_embeddings_electra_base_turkish_mc4_uncased_generator',
               'tr.embed.w2v_cc_300d': 'w2v_cc_300d',
               'tr.lemma': 'lemma_penn',
               'tr.lemma.atis': 'lemma_atis',
               'tr.lemma.boun': 'lemma_boun',
               'tr.lemma.framenet': 'lemma_framenet',
               'tr.lemma.imst': 'lemma_imst',
               'tr.lemma.kenet': 'lemma_kenet',
               'tr.lemma.penn': 'lemma_penn',
               'tr.lemma.spacylookup': 'lemma_spacylookup',
               'tr.lemma.tourism': 'lemma_tourism',
               'tr.ner': 'turkish_ner_840B_300',
               'tr.ner.bert': 'turkish_ner_bert',
               'tr.ner.bert.128d': 'bert_ner_berturk_128k_keyword_discriminator',
               'tr.ner.bert.by_busecarik': 'bert_token_classifier_berturk_sunlp_ner_turkish',
               'tr.ner.bert.by_gurkan08': 'bert_ner_turkish_ner',
               'tr.ner.bert.cased': 'bert_token_classifier_berturk_cased_keyword_discriminator',
               'tr.ner.bert.cased.by_alierenak': 'bert_token_classifier_berturk_cased_ner',
               'tr.ner.bert.cased_base': 'bert_ner_bert_base_turkish_cased_ner',
               'tr.ner.bert.cased_base.by_beyhan': 'bert_ner_bert_base_turkish_ner_cased_pretrained',
               'tr.ner.bert.cased_base.by_savasy': 'bert_ner_bert_base_turkish_ner_cased',
               'tr.ner.bert.cased_base.by_winvoker': 'bert_ner_bert_base_turkish_cased_ner_tf',
               'tr.ner.bert.keyword_extractor': 'bert_ner_berturk_keyword_extractor',
               'tr.ner.bert.lang': 'bert_ner_offlangdetectionturkish',
               'tr.ner.bert.loodos.by_busecarik': 'bert_token_classifier_loodos_sunlp_ner_turkish',
               'tr.ner.bert.uncased': 'bert_ner_berturk_uncased_keyword_discriminator',
               'tr.ner.bert.uncased.by_yanekyuk': 'bert_ner_berturk_uncased_keyword_extractor',
               'tr.ner.xlm_roberta': 'xlm_roberta_base_token_classifier_ner',
               'tr.ner.xlmr_roberta.base': 'xlmroberta_ner_xlm_roberta_base_turkish_ner',
               'tr.pos': 'pos_boun',
               'tr.pos.atis': 'pos_atis',
               'tr.pos.boun': 'pos_boun',
               'tr.pos.framenet': 'pos_framenet',
               'tr.pos.imst': 'pos_imst',
               'tr.pos.kenet': 'pos_kenet',
               'tr.pos.penn': 'pos_penn',
               'tr.pos.tourism': 'pos_tourism',
               'tr.pos.ud_imst': 'pos_ud_imst',
               'tr.stopwords': 'stopwords_iso',
               'tr.stopwords.iso': 'stopwords_iso'},
        'tt': {'tt.embed.w2v_cc_300d': 'w2v_cc_300d',
               'tt.speech2text.wav2vec_xlsr.l_v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_tatar_by_anton_l_gpu',
               'tt.speech2text.wav2vec_xlsr.v2_gpu': 'asr_wav2vec2_xlsr_tatar_gpu',
               'tt.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_tatar_by_anton_l',
               'tt.speech2text.wav2vec_xlsr.v2_large.by_crang': 'asr_wav2vec2_large_xlsr_53_tatar_by_crang',
               'tt.speech2text.wav2vec_xlsr.v2_large_300m': 'asr_wav2vec2_large_xls_r_300m_tatar',
               'tt.speech2text.wav2vec_xlsr.v2_large_300m_gpu': 'asr_wav2vec2_large_xls_r_300m_tatar_gpu',
               'tt.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_tatar_by_crang_gpu',
               'tt.speech2text.wav2vec_xlsr.v2_large_small': 'asr_wav2vec2_large_xlsr_53_W2V2_TATAR_SMALL',
               'tt.speech2text.wav2vec_xlsr.v2_large_small_gpu': 'asr_wav2vec2_large_xlsr_53_w2v2_tatar_small_gpu',
               'tt.stopwords': 'stopwords_iso'},
        'tw': {'tw.speech2text.wav2vec_xlsr.v2': 'asr_wav2vec2large_xlsr_akan'},
        'ug': {'ug.embed.w2v_cc_300d': 'w2v_cc_300d',
               'ug.lemma': 'lemma_udt',
               'ug.lemma.udt': 'lemma_udt',
               'ug.pos.udt': 'pos_udt'},
        'uk': {'uk.answer_question.xlmr_roberta': 'xlmroberta_qa_ukrainian',
               'uk.detect_sentence': 'sentence_detector_dl',
               'uk.embed.bert.cased_base': 'bert_embeddings_base_uk_cased',
               'uk.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_uk_cased',
               'uk.embed.ukr_roberta_base': 'roberta_embeddings_ukr_roberta_base',
               'uk.embed.w2v_cc_300d': 'w2v_cc_300d',
               'uk.embed.xlmr_roberta.base': 'xlmroberta_embeddings_xlm_roberta_base',
               'uk.lemma': 'lemma',
               'uk.lemma.iu': 'lemma_iu',
               'uk.ner.pos': 'xlmroberta_pos_uk_morph',
               'uk.ner.xlmr_roberta': 'xlmroberta_ner_uk_ner',
               'uk.pos': 'pos_ud_iu',
               'uk.pos.bert_base_slavic_cyrillic_upos': 'bert_pos_bert_base_slavic_cyrillic_upos',
               'uk.pos.bert_large_slavic_cyrillic_upos': 'bert_pos_bert_large_slavic_cyrillic_upos',
               'uk.pos.iu': 'pos_iu',
               'uk.pos.ud_iu': 'pos_ud_iu',
               'uk.stopwords': 'stopwords_iso'},
        'unk': {
            'unk.ner.bert': 'bert_token_classifier_autotrain_medicaltokenclassification_1279048948'},
        'ur': {
            'ur.classify.distilbert_sequence.imdb': 'distilbert_base_sequence_classifier_imdb',
            'ur.classify.fakenews': 'classifierdl_urduvec_fakenews',
            'ur.classify.news': 'classifierdl_bert_news',
            'ur.classify.sentiment.imdb': 'mdeberta_v3_base_sequence_classifier_imdb',
            'ur.embed': 'urduvec_140M_300d',
            'ur.embed.bert.cased_base': 'bert_embeddings_base_ur_cased',
            'ur.embed.bert_cased': 'bert_embeddings_bert_base_ur_cased',
            'ur.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_ur_cased',
            'ur.embed.glove.300d': 'urduvec_140M_300d',
            'ur.embed.muril_adapted_local': 'bert_embeddings_muril_adapted_local',
            'ur.embed.roberta_urdu_small': 'roberta_embeddings_roberta_urdu_small',
            'ur.embed.urdu_vec_140M_300d': 'urduvec_140M_300d',
            'ur.embed.w2v_cc_300d': 'w2v_cc_300d',
            'ur.lemma': 'lemma_udtb',
            'ur.lemma.spacylookup': 'lemma_spacylookup',
            'ur.lemma.udtb': 'lemma_udtb',
            'ur.ner': 'uner_mk_140M_300d',
            'ur.ner.mk_140M_300d': 'uner_mk_140M_300d',
            'ur.pos': 'pos_udtb',
            'ur.pos.ud_udtb': 'pos_ud_udtb',
            'ur.pos.udtb': 'pos_udtb',
            'ur.sentiment': 'sentimentdl_urduvec_imdb',
            'ur.stopwords': 'stopwords_iso'},
        'uz': {'uz.classify.bert.news.': 'bert_classifier_uzbek_news_category',
               'uz.embed.w2v_cc_300d': 'w2v_cc_300d',
               'uz.speech2text.wav2vec2': 'asr_uzbek_stt',
               'uz.speech2text.wav2vec2.gpu': 'asr_uzbek_stt_gpu'},
        'vec': {'vec.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'vi': {'vi.answer_question.bert': 'bert_qa_bert_qa_vi_nvkha',
               'vi.answer_question.bert.cased_multilingual_base': 'bert_qa_multilingual_bert_base_cased_vietnamese',
               'vi.answer_question.bert.uncased_base_finetuned': 'bert_qa_bert_base_uncased_finetuned_vi_infovqa',
               'vi.answer_question.xlm_roberta.large': 'xlm_roberta_qa_xlm_roberta_large_vi_qa',
               'vi.classify.sentiment.distilled': 'classifierdl_distilbert_sentiment',
               'vi.embed.bert.cased_base': 'bert_embeddings_base_vi_cased',
               'vi.embed.bert_cased': 'bert_embeddings_bert_base_vi_cased',
               'vi.embed.distilbert.cased': 'distilbert_base_cased',
               'vi.embed.w2v_cc_300d': 'w2v_cc_300d',
               'vi.lemma': 'lemma',
               'vi.lemma.vtb': 'lemma_vtb',
               'vi.pos': 'pos_vtb',
               'vi.speech2text.wav2vec2.v2_base_160h': 'asr_wav2vec2_base_vietnamese_160h',
               'vi.speech2text.wav2vec2.v2_base_160h_gpu': 'asr_wav2vec2_base_vietnamese_160h_gpu',
               'vi.speech2text.wav2vec2.v2_base_250h': 'asr_wav2vec2_base_vietnamese_250h',
               'vi.speech2text.wav2vec2.v2_base_250h_gpu': 'asr_wav2vec2_base_vietnamese_250h_gpu',
               'vi.speech2text.wav2vec2.v2_base_gpu': 'asr_wav2vec2_base_vietnamese_gpu',
               'vi.speech2text.wav2vec_xlsr.cord19.v2_large': 'asr_wav2vec2_large_xlsr_vietnamese_by_ontocord',
               'vi.speech2text.wav2vec_xlsr.cord19.v2_large_gpu': 'asr_wav2vec2_large_xlsr_vietnamese_by_ontocord_gpu',
               'vi.speech2text.wav2vec_xlsr.v2': 'asr_fine_tune_xlsr_wav2vec2_speech2text_vietnamese',
               'vi.speech2text.wav2vec_xlsr.v2_gpu': 'asr_fine_tune_xlsr_wav2vec2_speech2text_vietnamese_gpu',
               'vi.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_53_vietnamese_by_anuragshas',
               'vi.speech2text.wav2vec_xlsr.v2_large.by_cuongld': 'asr_wav2vec2_large_xlsr_vietnamese_by_cuongld',
               'vi.speech2text.wav2vec_xlsr.v2_large.by_nhut': 'asr_wav2vec2_large_xlsr_vietnamese_by_nhut',
               'vi.speech2text.wav2vec_xlsr.v2_large.by_not_tanh': 'asr_wav2vec2_large_xlsr_53_vietnamese_by_not_tanh',
               'vi.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_53_vietnamese_by_anuragshas_gpu',
               'vi.speech2text.wav2vec_xlsr.v2_large_gpu.by_cuongld': 'asr_wav2vec2_large_xlsr_vietnamese_by_cuongld_gpu',
               'vi.speech2text.wav2vec_xlsr.v2_large_gpu.by_nhut': 'asr_wav2vec2_large_xlsr_vietnamese_by_nhut_gpu',
               'vi.speech2text.wav2vec_xlsr.v2_large_gpu.by_not_tanh': 'asr_wav2vec2_large_xlsr_53_vietnamese_by_not_tanh_gpu',
               'vi.stopwords': 'stopwords_iso'},
        'vls': {'vls.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'vn': {
            'vn.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_vietnamese'},
        'vo': {'vo.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'wa': {'wa.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'war': {'war.embed.w2v_cc_300d': 'w2v_cc_300d'},

        'wo': {'wo.embed.xlm_roberta': 'xlm_roberta_base_finetuned_wolof',
               'wo.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_wolof',
               'wo.lemma.wtb': 'lemma_wtb',
               'wo.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_base_finetuned_ner_wolof',
               'wo.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_base_finetuned_swahili_finetuned_ner_wolof',
               'wo.ner.xlmr_roberta.base_finetuned_wolof.by_mbeukman': 'xlmroberta_ner_base_finetuned_wolof_finetuned_ner_wolof',
               'wo.pos': 'pos_wtb',
               'wo.speech2text.wav2vec_xlsr.v2_300m': 'asr_av2vec2_xls_r_300m_wolof_lm',
               'wo.speech2text.wav2vec_xlsr.v2_300m_gpu': 'asr_av2vec2_xls_r_300m_wolof_lm_gpu'},
        'xmf': {'xmf.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'xx': {'xx.aav.marian.translate_to.en': 'opus_mt_aav_en',
               'xx.aed.marian.translate_to.es': 'opus_mt_es_aed',
               'xx.af.marian.translate_to.de': 'opus_mt_de_af',
               'xx.af.marian.translate_to.en': 'opus_mt_af_en',
               'xx.af.marian.translate_to.eo': 'opus_mt_eo_af',
               'xx.af.marian.translate_to.es': 'opus_mt_es_af',
               'xx.af.marian.translate_to.fi': 'opus_mt_fi_af',
               'xx.af.marian.translate_to.fr': 'opus_mt_fr_af',
               'xx.af.marian.translate_to.nl': 'opus_mt_nl_af',
               'xx.af.marian.translate_to.ru': 'opus_mt_ru_af',
               'xx.af.marian.translate_to.sv': 'opus_mt_sv_af',
               'xx.af.translate_to.ru': 'opus_tatoeba_af_ru',
               'xx.afa.marian.translate_to.afa': 'opus_mt_afa_afa',
               'xx.afa.marian.translate_to.en': 'opus_mt_afa_en',
               'xx.alv.marian.translate_to.en': 'opus_mt_alv_en',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_ar_hi': 'bert_qa_mbert_finetuned_mlqa_ar_hi_dev',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_de_hi': 'bert_qa_mbert_finetuned_mlqa_de_hi_dev',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_es_hi': 'bert_qa_mbert_finetuned_mlqa_es_hi_dev',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_hi_en': 'bert_qa_mbert_finetuned_mlqa_en_hi_dev',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_vi_hi': 'bert_qa_mbert_finetuned_mlqa_vi_hi_dev',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_zh_hi': 'bert_qa_mbert_finetuned_mlqa_zh_hi_dev',
               'xx.answer_question.bert.mlqa.finetuned.extra_support_zh_hi_en': 'bert_qa_mbert_finetuned_mlqa_en_zh_hi_dev',
               'xx.answer_question.bert.squad.cased_multilingual_base_finetuned': 'bert_qa_paul_vinh_bert_base_multilingual_cased_finetuned_squad',
               'xx.answer_question.bert.squad.cased_multilingual_base_finetuned.by_salti': 'bert_qa_salti_bert_base_multilingual_cased_finetuned_squad',
               'xx.answer_question.bert.squad.cased_multilingual_base_finetuned.by_vanichandna': 'bert_qa_bert_base_multilingual_cased_finetuned_squadv1',
               'xx.answer_question.bert.squad.extra_support_es_de_en': 'bert_qa_squad_mbert_en_de_es_model',
               'xx.answer_question.bert.squad.extra_support_zh_de_en_es_vi': 'bert_qa_squad_mbert_en_de_es_vi_zh_model',
               'xx.answer_question.bert.squad.uncased_multilingual_base_finetuned': 'bert_qa_bert_base_multilingual_uncased_finetuned_squad',
               'xx.answer_question.bert.tydiqa.3lang': 'bert_qa_3lang',
               'xx.answer_question.bert.uncased_base': 'bert_qa_base_multi_uncased',
               'xx.answer_question.bert.xquad.multilingual_base': 'bert_qa_bert_base_multilingual_xquad',
               'xx.answer_question.chaii.xlm_roberta': 'xlm_roberta_qa_xlm_roberta_qa_chaii',
               'xx.answer_question.distil_bert.en_de_es_tuned.by_ZYW': 'distilbert_qa_en_de_es_model',
               'xx.answer_question.distil_bert.en_de_tuned.by_ZYW': 'distilbert_qa_en_de_model',
               'xx.answer_question.distil_bert.vi_zh_es_tuned.by_ZYW': 'distilbert_qa_en_de_vi_zh_es_model',
               'xx.answer_question.roberta': 'roberta_qa_ft_lr_cu_leolin12345',
               'xx.answer_question.squad.distil_bert._en_de_es_vi_zh_tuned.by_ZYW': 'distilbert_qa_squad_en_de_es_vi_zh_model',
               'xx.answer_question.squad.distil_bert.en_de_es_tuned.by_ZYW': 'distilbert_qa_squad_en_de_es_model',
               'xx.answer_question.tydiqa.bert': 'bert_qa_telugu_bertu_tydiqa',
               'xx.answer_question.tydiqa.multi_lingual_bert': 'bert_qa_Part_1_mBERT_Model_E1',
               'xx.answer_question.xlm_roberta.distilled': 'xlm_roberta_qa_distill_xlm_mrc',
               'xx.answer_question.xquad.bert.cased': 'bert_qa_bert_multi_cased_finetuned_xquadv1',
               'xx.answer_question.xquad.bert.uncased': 'bert_qa_bert_multi_uncased_finetuned_xquadv1',
               'xx.answer_question.xquad_tydiqa.bert.cased': 'bert_qa_bert_multi_cased_finedtuned_xquad_tydiqa_goldp',
               'xx.ar.marian.translate_to.de': 'opus_mt_de_ar',
               'xx.ar.marian.translate_to.el': 'opus_mt_el_ar',
               'xx.ar.marian.translate_to.en': 'opus_mt_ar_en',
               'xx.ar.marian.translate_to.es': 'opus_mt_es_ar',
               'xx.ar.marian.translate_to.fr': 'opus_mt_fr_ar',
               'xx.ar.marian.translate_to.he': 'opus_mt_he_ar',
               'xx.ar.marian.translate_to.it': 'opus_mt_it_ar',
               'xx.ar.marian.translate_to.ja': 'opus_mt_ja_ar',
               'xx.ar.marian.translate_to.pl': 'opus_mt_pl_ar',
               'xx.ar.marian.translate_to.ru': 'opus_mt_ru_ar',
               'xx.ar.marian.translate_to.tr': 'opus_mt_tr_ar',
               'xx.art.marian.translate_to.en': 'opus_mt_art_en',
               'xx.ase.marian.translate_to.de': 'opus_mt_de_ase',
               'xx.ase.marian.translate_to.en': 'opus_mt_ase_en',
               'xx.ase.marian.translate_to.es': 'opus_mt_es_ase',
               'xx.ase.marian.translate_to.fr': 'opus_mt_fr_ase',
               'xx.ase.marian.translate_to.sv': 'opus_mt_sv_ase',
               'xx.az.marian.translate_to.en': 'opus_mt_az_en',
               'xx.az.marian.translate_to.tr': 'opus_mt_tr_az',
               'xx.bat.marian.translate_to.en': 'opus_mt_bat_en',
               'xx.bcl.marian.translate_to.de': 'opus_mt_de_bcl',
               'xx.bcl.marian.translate_to.en': 'opus_mt_bcl_en',
               'xx.bcl.marian.translate_to.es': 'opus_mt_es_bcl',
               'xx.bcl.marian.translate_to.fi': 'opus_mt_fi_bcl',
               'xx.bcl.marian.translate_to.fr': 'opus_mt_fr_bcl',
               'xx.bcl.marian.translate_to.sv': 'opus_mt_sv_bcl',
               'xx.bem.marian.translate_to.en': 'opus_mt_bem_en',
               'xx.bem.marian.translate_to.fi': 'opus_mt_fi_bem',
               'xx.bem.marian.translate_to.fr': 'opus_mt_fr_bem',
               'xx.bem.marian.translate_to.sv': 'opus_mt_sv_bem',
               'xx.ber.marian.translate_to.en': 'opus_mt_ber_en',
               'xx.ber.marian.translate_to.es': 'opus_mt_es_ber',
               'xx.ber.marian.translate_to.fr': 'opus_mt_fr_ber',
               'xx.bg.marian.translate_to.de': 'opus_mt_de_bg',
               'xx.bg.marian.translate_to.en': 'opus_mt_bg_en',
               'xx.bg.marian.translate_to.eo': 'opus_mt_eo_bg',
               'xx.bg.marian.translate_to.es': 'opus_mt_es_bg',
               'xx.bg.marian.translate_to.fi': 'opus_mt_fi_bg',
               'xx.bg.marian.translate_to.fr': 'opus_mt_fr_bg',
               'xx.bg.marian.translate_to.it': 'opus_mt_it_bg',
               'xx.bg.marian.translate_to.ja': 'opus_mt_ja_bg',
               'xx.bg.marian.translate_to.ru': 'opus_mt_ru_bg',
               'xx.bg.marian.translate_to.sv': 'opus_mt_sv_bg',
               'xx.bg.marian.translate_to.uk': 'opus_mt_uk_bg',
               'xx.bg.marian.translate_to.zh': 'opus_mt_zh_bg',
               'xx.bi.marian.translate_to.de': 'opus_mt_de_bi',
               'xx.bi.marian.translate_to.en': 'opus_mt_bi_en',
               'xx.bi.marian.translate_to.es': 'opus_mt_es_bi',
               'xx.bi.marian.translate_to.fr': 'opus_mt_fr_bi',
               'xx.bi.marian.translate_to.sv': 'opus_mt_sv_bi',
               'xx.bn.marian.translate_to.en': 'opus_mt_bn_en',
               'xx.bnt.marian.translate_to.en': 'opus_mt_bnt_en',
               'xx.bzs.marian.translate_to.de': 'opus_mt_de_bzs',
               'xx.bzs.marian.translate_to.en': 'opus_mt_bzs_en',
               'xx.bzs.marian.translate_to.es': 'opus_mt_es_bzs',
               'xx.bzs.marian.translate_to.fi': 'opus_mt_fi_bzs',
               'xx.bzs.marian.translate_to.fr': 'opus_mt_fr_bzs',
               'xx.bzs.marian.translate_to.sv': 'opus_mt_sv_bzs',
               'xx.ca.marian.translate_to.de': 'opus_mt_de_ca',
               'xx.ca.marian.translate_to.en': 'opus_mt_ca_en',
               'xx.ca.marian.translate_to.es': 'opus_mt_es_ca',
               'xx.ca.marian.translate_to.fr': 'opus_mt_fr_ca',
               'xx.ca.marian.translate_to.it': 'opus_mt_it_ca',
               'xx.ca.marian.translate_to.nl': 'opus_mt_nl_ca',
               'xx.ca.marian.translate_to.pt': 'opus_mt_pt_ca',
               'xx.ca.marian.translate_to.uk': 'opus_mt_uk_ca',
               'xx.cau.marian.translate_to.en': 'opus_mt_cau_en',
               'xx.ccs.marian.translate_to.en': 'opus_mt_ccs_en',
               'xx.ceb.marian.translate_to.en': 'opus_mt_ceb_en',
               'xx.ceb.marian.translate_to.es': 'opus_mt_es_ceb',
               'xx.ceb.marian.translate_to.fi': 'opus_mt_fi_ceb',
               'xx.ceb.marian.translate_to.fr': 'opus_mt_fr_ceb',
               'xx.ceb.marian.translate_to.sv': 'opus_mt_sv_ceb',
               'xx.cel.marian.translate_to.en': 'opus_mt_cel_en',
               'xx.chk.marian.translate_to.en': 'opus_mt_chk_en',
               'xx.chk.marian.translate_to.sv': 'opus_mt_sv_chk',
               'xx.classify.bert': 'bert_classifier_arabic_ner_ace',
               'xx.classify.bert.by_meghanabhange': 'bert_classifier_hinglish_class',
               'xx.classify.bert.by_mlkorra': 'bert_classifier_obgv_gder',
               'xx.classify.bert.by_ychennlp': 'bert_classifier_arabic_relation_extraction',
               'xx.classify.bert.cased_base.extra_support_es_en': 'bert_classifier_bert_base_en_es_codemix_cased',
               'xx.classify.bert.cased_base.extra_support_hi_en': 'bert_classifier_bert_base_en_hi_codemix_cased',
               'xx.classify.bert.lang': 'bert_classifier_tanglish_offensive_language_identification',
               'xx.classify.bert.news.': 'bert_classifier_english_news_classification_headlines',
               'xx.classify.bert.news.by_m47labs': 'bert_classifier_italian_news_classification_headlines',
               'xx.classify.bert.sentiment.': 'bert_classifier_hinglish11k_sentiment_analysis',
               'xx.classify.bert.sentiment.cased_tiny': 'bert_classifier_bert_tiny_bahasa_cased_sentiment',
               'xx.classify.bert.sentiment.multilingual': 'bert_sequence_classifier_multilingual_sentiment',
               'xx.classify.bert.sentiment.uncased_multilingual_base': 'bert_classifier_bert_base_multilingual_uncased_sentiment',
               'xx.classify.bert.tweet.': 'bert_classifier_mbert_corona_tweets_belgium_curfew_support',
               'xx.classify.electra.tweet_sentiment.': 'electra_classifier_bertic_tweetsentiment',
               'xx.classify.roberta.base': 'roberta_classifier_zabanshenas_base_mix',
               'xx.classify.token_xlm_roberta.token_classifier_ner_40_lang': 'xlm_roberta_token_classifier_ner_40_lang',
               'xx.classify.wiki_21': 'ld_wiki_tatoeba_cnn_21',
               'xx.classify.wiki_21.bigru': 'ld_tatoeba_bigru_21',
               'xx.classify.wiki_220': 'ld_wiki_tatoeba_cnn_220',
               'xx.classify.wiki_231': 'ld_wiki_cnn_231',
               'xx.classify.wiki_375': 'ld_wiki_tatoeba_cnn_375',
               'xx.classify.wiki_43': 'ld_wiki_tatoeba_cnn_43',
               'xx.classify.wiki_95': 'ld_wiki_tatoeba_cnn_95',
               'xx.classify.wiki_99': 'ld_tatoeba_cnn_99',
               'xx.classify.xlmr_roberta': 'xlmroberta_classifier_verdict',
               'xx.classify.xlmr_roberta.glue.large.extra_support_ru_en': 'xlmroberta_classifier_large_en_ru_mnli',
               'xx.classify.xlmr_roberta.xnli.base': 'xlmroberta_classifier_base_snli_mnli_anli_xnli',
               'xx.cpf.marian.translate_to.en': 'opus_mt_cpf_en',
               'xx.cpp.marian.translate_to.cpp': 'opus_mt_cpp_cpp',
               'xx.cpp.marian.translate_to.en': 'opus_mt_cpp_en',
               'xx.crs.marian.translate_to.de': 'opus_mt_de_crs',
               'xx.crs.marian.translate_to.en': 'opus_mt_crs_en',
               'xx.crs.marian.translate_to.es': 'opus_mt_es_crs',
               'xx.crs.marian.translate_to.fi': 'opus_mt_fi_crs',
               'xx.crs.marian.translate_to.fr': 'opus_mt_fr_crs',
               'xx.crs.marian.translate_to.sv': 'opus_mt_sv_crs',
               'xx.cs.marian.translate_to.de': 'opus_mt_de_cs',
               'xx.cs.marian.translate_to.en': 'opus_mt_cs_en',
               'xx.cs.marian.translate_to.eo': 'opus_mt_eo_cs',
               'xx.cs.marian.translate_to.es': 'opus_mt_es_cs',
               'xx.cs.marian.translate_to.fi': 'opus_mt_fi_cs',
               'xx.cs.marian.translate_to.sv': 'opus_mt_sv_cs',
               'xx.cs.marian.translate_to.uk': 'opus_mt_uk_cs',
               'xx.cs.translate_to.sv': 'opus_mt_cs_sv',
               'xx.csg.marian.translate_to.es': 'opus_mt_es_csg',
               'xx.csn.marian.translate_to.es': 'opus_mt_es_csn',
               'xx.cus.marian.translate_to.en': 'opus_mt_cus_en',
               'xx.cy.marian.translate_to.en': 'opus_mt_cy_en',
               'xx.da.marian.translate_to.de': 'opus_mt_de_da',
               'xx.da.marian.translate_to.en': 'opus_mt_da_en',
               'xx.da.marian.translate_to.eo': 'opus_mt_eo_da',
               'xx.da.marian.translate_to.es': 'opus_mt_es_da',
               'xx.da.marian.translate_to.ja': 'opus_mt_ja_da',
               'xx.da.marian.translate_to.no': 'opus_mt_no_da',
               'xx.da.marian.translate_to.ru': 'opus_mt_ru_da',
               'xx.de.marian.translate_to.af': 'opus_mt_af_de',
               'xx.de.marian.translate_to.ar': 'opus_mt_ar_de',
               'xx.de.marian.translate_to.ase': 'opus_mt_ase_de',
               'xx.de.marian.translate_to.bcl': 'opus_mt_bcl_de',
               'xx.de.marian.translate_to.bg': 'opus_mt_bg_de',
               'xx.de.marian.translate_to.ca': 'opus_mt_ca_de',
               'xx.de.marian.translate_to.crs': 'opus_mt_crs_de',
               'xx.de.marian.translate_to.cs': 'opus_mt_cs_de',
               'xx.de.marian.translate_to.da': 'opus_mt_da_de',
               'xx.de.marian.translate_to.de': 'opus_mt_de_de',
               'xx.de.marian.translate_to.ee': 'opus_mt_ee_de',
               'xx.de.marian.translate_to.efi': 'opus_mt_efi_de',
               'xx.de.marian.translate_to.en': 'opus_mt_de_en',
               'xx.de.marian.translate_to.eo': 'opus_mt_eo_de',
               'xx.de.marian.translate_to.es': 'opus_mt_es_de',
               'xx.de.marian.translate_to.et': 'opus_mt_et_de',
               'xx.de.marian.translate_to.eu': 'opus_mt_eu_de',
               'xx.de.marian.translate_to.fi': 'opus_mt_fi_de',
               'xx.de.marian.translate_to.fr': 'opus_mt_fr_de',
               'xx.de.marian.translate_to.gaa': 'opus_mt_gaa_de',
               'xx.de.marian.translate_to.guw': 'opus_mt_guw_de',
               'xx.de.marian.translate_to.he': 'opus_mt_he_de',
               'xx.de.marian.translate_to.hil': 'opus_mt_hil_de',
               'xx.de.marian.translate_to.hu': 'opus_mt_hu_de',
               'xx.de.marian.translate_to.ig': 'opus_mt_ig_de',
               'xx.de.marian.translate_to.ilo': 'opus_mt_ilo_de',
               'xx.de.marian.translate_to.is': 'opus_mt_is_de',
               'xx.de.marian.translate_to.it': 'opus_mt_it_de',
               'xx.de.marian.translate_to.ja': 'opus_mt_ja_de',
               'xx.de.marian.translate_to.ko': 'opus_mt_ko_de',
               'xx.de.marian.translate_to.ln': 'opus_mt_ln_de',
               'xx.de.marian.translate_to.loz': 'opus_mt_loz_de',
               'xx.de.marian.translate_to.lt': 'opus_mt_lt_de',
               'xx.de.marian.translate_to.ms': 'opus_mt_ms_de',
               'xx.de.marian.translate_to.niu': 'opus_mt_niu_de',
               'xx.de.marian.translate_to.no': 'opus_mt_no_de',
               'xx.de.marian.translate_to.nso': 'opus_mt_nso_de',
               'xx.de.marian.translate_to.ny': 'opus_mt_ny_de',
               'xx.de.marian.translate_to.pag': 'opus_mt_pag_de',
               'xx.de.marian.translate_to.pap': 'opus_mt_pap_de',
               'xx.de.marian.translate_to.pl': 'opus_mt_pl_de',
               'xx.de.marian.translate_to.rn': 'opus_mt_rn_de',
               'xx.de.marian.translate_to.tl': 'opus_mt_tl_de',
               'xx.de.marian.translate_to.uk': 'opus_mt_uk_de',
               'xx.de.marian.translate_to.vi': 'opus_mt_vi_de',
               'xx.de.marian.translate_to.zh': 'opus_mt_zh_de',
               'xx.dra.marian.translate_to.en': 'opus_mt_dra_en',
               'xx.ee.marian.translate_to.de': 'opus_mt_de_ee',
               'xx.ee.marian.translate_to.en': 'opus_mt_ee_en',
               'xx.ee.marian.translate_to.es': 'opus_mt_es_ee',
               'xx.ee.marian.translate_to.fi': 'opus_mt_fi_ee',
               'xx.ee.marian.translate_to.fr': 'opus_mt_fr_ee',
               'xx.ee.marian.translate_to.sv': 'opus_mt_sv_ee',
               'xx.efi.marian.translate_to.de': 'opus_mt_de_efi',
               'xx.efi.marian.translate_to.en': 'opus_mt_efi_en',
               'xx.efi.marian.translate_to.es': 'opus_mt_es_efi',
               'xx.efi.marian.translate_to.fi': 'opus_mt_fi_efi',
               'xx.efi.marian.translate_to.fr': 'opus_mt_fr_efi',
               'xx.efi.marian.translate_to.sv': 'opus_mt_sv_efi',
               'xx.el.marian.translate_to.ar': 'opus_mt_ar_el',
               'xx.el.marian.translate_to.de': 'opus_mt_de_el',
               'xx.el.marian.translate_to.eo': 'opus_mt_eo_el',
               'xx.el.marian.translate_to.es': 'opus_mt_es_el',
               'xx.el.marian.translate_to.fi': 'opus_mt_fi_el',
               'xx.el.marian.translate_to.fr': 'opus_mt_fr_el',
               'xx.el.marian.translate_to.sv': 'opus_mt_sv_el',
               'xx.embed': 'glove_840B_300',
               'xx.embed.albert.indic': 'albert_indic',
               'xx.embed.bert': 'bert_multi_cased',
               'xx.embed.bert.muril': 'bert_muril',
               'xx.embed.bert_base_multilingual_cased': 'bert_base_multilingual_cased',
               'xx.embed.bert_base_multilingual_uncased': 'bert_base_multilingual_uncased',
               'xx.embed.bert_multi_cased': 'bert_multi_cased',
               'xx.embed.distilbert': 'distilbert_base_multilingual_cased',
               'xx.embed.glove.6B_300': 'glove_6B_300',
               'xx.embed.glove.840B_300': 'glove_840B_300',
               'xx.embed.glove.glove_6B_100': 'glove_6B_100',
               'xx.embed.mdeberta_v3_base': 'mdeberta_v3_base',
               'xx.embed.xlm': 'xlm_roberta_base',
               'xx.embed.xlm.base': 'xlm_roberta_base',
               'xx.embed.xlm.twitter': 'twitter_xlm_roberta_base',
               'xx.embed.xlm_roberta_large': 'xlm_roberta_large',
               'xx.embed.xlm_roberta_xtreme_base': 'xlm_roberta_xtreme_base',
               'xx.embed.xlmr_roberta.base': 'xlmroberta_embeddings_afriberta_base',
               'xx.embed.xlmr_roberta.large': 'xlmroberta_embeddings_afriberta_large',
               'xx.embed.xlmr_roberta.large.by_hfl': 'xlmroberta_embeddings_cino_large',
               'xx.embed.xlmr_roberta.large_128d': 'xlmroberta_embeddings_roberta_large_eng_ara_128k',
               'xx.embed.xlmr_roberta.mini_lm_mini': 'xlmroberta_embeddings_fairlex_fscs_minilm',
               'xx.embed.xlmr_roberta.small': 'xlmroberta_embeddings_afriberta_small',
               'xx.embed.xlmr_roberta.v2_base': 'xlmroberta_embeddings_cino_base_v2',
               'xx.embed.xlmr_roberta.v2_large': 'xlmroberta_embeddings_cino_large_v2',
               'xx.embed.xlmr_roberta.v2_small': 'xlmroberta_embeddings_cino_small_v2',
               'xx.embed_sentence': 'sent_bert_multi_cased',
               'xx.embed_sentence.bert': 'sent_bert_multi_cased',
               'xx.embed_sentence.bert.cased': 'sent_bert_multi_cased',
               'xx.embed_sentence.bert.muril': 'sent_bert_muril',
               'xx.embed_sentence.bert_use_cmlm_multi_base': 'sent_bert_use_cmlm_multi_base',
               'xx.embed_sentence.bert_use_cmlm_multi_base_br': 'sent_bert_use_cmlm_multi_base_br',
               'xx.embed_sentence.labse': 'labse',
               'xx.embed_sentence.xlm_roberta.base': 'sent_xlm_roberta_base',
               'xx.en.marian.translate_to.aav': 'opus_mt_en_aav',
               'xx.en.marian.translate_to.af': 'opus_mt_en_af',
               'xx.en.marian.translate_to.afa': 'opus_mt_en_afa',
               'xx.en.marian.translate_to.alv': 'opus_mt_en_alv',
               'xx.en.marian.translate_to.ar': 'opus_mt_en_ar',
               'xx.en.marian.translate_to.az': 'opus_mt_en_az',
               'xx.en.marian.translate_to.bat': 'opus_mt_en_bat',
               'xx.en.marian.translate_to.bcl': 'opus_mt_en_bcl',
               'xx.en.marian.translate_to.bem': 'opus_mt_en_bem',
               'xx.en.marian.translate_to.ber': 'opus_mt_en_ber',
               'xx.en.marian.translate_to.bg': 'opus_mt_en_bg',
               'xx.en.marian.translate_to.bi': 'opus_mt_en_bi',
               'xx.en.marian.translate_to.bnt': 'opus_mt_en_bnt',
               'xx.en.marian.translate_to.bzs': 'opus_mt_en_bzs',
               'xx.en.marian.translate_to.ca': 'opus_mt_en_ca',
               'xx.en.marian.translate_to.ceb': 'opus_mt_en_ceb',
               'xx.en.marian.translate_to.cel': 'opus_mt_en_cel',
               'xx.en.marian.translate_to.chk': 'opus_mt_en_chk',
               'xx.en.marian.translate_to.cpf': 'opus_mt_en_cpf',
               'xx.en.marian.translate_to.cpp': 'opus_mt_en_cpp',
               'xx.en.marian.translate_to.crs': 'opus_mt_en_crs',
               'xx.en.marian.translate_to.cs': 'opus_mt_en_cs',
               'xx.en.marian.translate_to.cus': 'opus_mt_en_cus',
               'xx.en.marian.translate_to.cy': 'opus_mt_en_cy',
               'xx.en.marian.translate_to.da': 'opus_mt_en_da',
               'xx.en.marian.translate_to.de': 'opus_mt_en_de',
               'xx.en.marian.translate_to.dra': 'opus_mt_en_dra',
               'xx.en.marian.translate_to.ee': 'opus_mt_en_ee',
               'xx.en.marian.translate_to.efi': 'opus_mt_en_efi',
               'xx.en.marian.translate_to.el': 'opus_mt_en_el',
               'xx.en.marian.translate_to.eo': 'opus_mt_en_eo',
               'xx.en.marian.translate_to.es': 'opus_mt_en_es',
               'xx.en.marian.translate_to.et': 'opus_mt_en_et',
               'xx.en.marian.translate_to.eu': 'opus_mt_en_eu',
               'xx.en.marian.translate_to.euq': 'opus_mt_en_euq',
               'xx.en.marian.translate_to.fi': 'opus_mt_en_fi',
               'xx.en.marian.translate_to.fiu': 'opus_mt_en_fiu',
               'xx.en.marian.translate_to.fj': 'opus_mt_en_fj',
               'xx.en.marian.translate_to.fr': 'opus_mt_en_fr',
               'xx.en.marian.translate_to.ga': 'opus_mt_en_ga',
               'xx.en.marian.translate_to.gaa': 'opus_mt_en_gaa',
               'xx.en.marian.translate_to.gem': 'opus_mt_en_gem',
               'xx.en.marian.translate_to.gil': 'opus_mt_en_gil',
               'xx.en.marian.translate_to.gl': 'opus_mt_en_gl',
               'xx.en.marian.translate_to.gmq': 'opus_mt_en_gmq',
               'xx.en.marian.translate_to.gmw': 'opus_mt_en_gmw',
               'xx.en.marian.translate_to.grk': 'opus_mt_en_grk',
               'xx.en.marian.translate_to.guw': 'opus_mt_en_guw',
               'xx.en.marian.translate_to.gv': 'opus_mt_en_gv',
               'xx.en.marian.translate_to.ha': 'opus_mt_en_ha',
               'xx.en.marian.translate_to.he': 'opus_mt_en_he',
               'xx.en.marian.translate_to.hi': 'opus_mt_en_hi',
               'xx.en.marian.translate_to.hil': 'opus_mt_en_hil',
               'xx.en.marian.translate_to.ho': 'opus_mt_en_ho',
               'xx.en.marian.translate_to.ht': 'opus_mt_en_ht',
               'xx.en.marian.translate_to.hu': 'opus_mt_en_hu',
               'xx.en.marian.translate_to.hy': 'opus_mt_en_hy',
               'xx.en.marian.translate_to.id': 'opus_mt_en_id',
               'xx.en.marian.translate_to.ig': 'opus_mt_en_ig',
               'xx.en.marian.translate_to.iir': 'opus_mt_en_iir',
               'xx.en.marian.translate_to.ilo': 'opus_mt_en_ilo',
               'xx.en.marian.translate_to.inc': 'opus_mt_en_inc',
               'xx.en.marian.translate_to.ine': 'opus_mt_en_ine',
               'xx.en.marian.translate_to.is': 'opus_mt_en_is',
               'xx.en.marian.translate_to.iso': 'opus_mt_en_iso',
               'xx.en.marian.translate_to.it': 'opus_mt_en_it',
               'xx.en.marian.translate_to.itc': 'opus_mt_en_itc',
               'xx.en.marian.translate_to.jap': 'opus_mt_en_jap',
               'xx.en.marian.translate_to.kg': 'opus_mt_en_kg',
               'xx.en.marian.translate_to.kj': 'opus_mt_en_kj',
               'xx.en.marian.translate_to.kqn': 'opus_mt_en_kqn',
               'xx.en.marian.translate_to.kwn': 'opus_mt_en_kwn',
               'xx.en.marian.translate_to.kwy': 'opus_mt_en_kwy',
               'xx.en.marian.translate_to.lg': 'opus_mt_en_lg',
               'xx.en.marian.translate_to.ln': 'opus_mt_en_ln',
               'xx.en.marian.translate_to.loz': 'opus_mt_en_loz',
               'xx.en.marian.translate_to.lu': 'opus_mt_en_lu',
               'xx.en.marian.translate_to.lua': 'opus_mt_en_lua',
               'xx.en.marian.translate_to.lue': 'opus_mt_en_lue',
               'xx.en.marian.translate_to.lun': 'opus_mt_en_lun',
               'xx.en.marian.translate_to.luo': 'opus_mt_en_luo',
               'xx.en.marian.translate_to.lus': 'opus_mt_en_lus',
               'xx.en.marian.translate_to.map': 'opus_mt_en_map',
               'xx.en.marian.translate_to.mfe': 'opus_mt_en_mfe',
               'xx.en.marian.translate_to.mg': 'opus_mt_en_mg',
               'xx.en.marian.translate_to.mh': 'opus_mt_en_mh',
               'xx.en.marian.translate_to.mk': 'opus_mt_en_mk',
               'xx.en.marian.translate_to.mkh': 'opus_mt_en_mkh',
               'xx.en.marian.translate_to.ml': 'opus_mt_en_ml',
               'xx.en.marian.translate_to.mos': 'opus_mt_en_mos',
               'xx.en.marian.translate_to.mr': 'opus_mt_en_mr',
               'xx.en.marian.translate_to.mt': 'opus_mt_en_mt',
               'xx.en.marian.translate_to.mul': 'opus_mt_en_mul',
               'xx.en.marian.translate_to.ng': 'opus_mt_en_ng',
               'xx.en.marian.translate_to.nic': 'opus_mt_en_nic',
               'xx.en.marian.translate_to.niu': 'opus_mt_en_niu',
               'xx.en.marian.translate_to.nl': 'opus_mt_en_nl',
               'xx.en.marian.translate_to.nso': 'opus_mt_en_nso',
               'xx.en.marian.translate_to.ny': 'opus_mt_en_ny',
               'xx.en.marian.translate_to.nyk': 'opus_mt_en_nyk',
               'xx.en.marian.translate_to.om': 'opus_mt_en_om',
               'xx.en.marian.translate_to.pag': 'opus_mt_en_pag',
               'xx.en.marian.translate_to.pap': 'opus_mt_en_pap',
               'xx.en.marian.translate_to.phi': 'opus_mt_en_phi',
               'xx.en.marian.translate_to.pis': 'opus_mt_en_pis',
               'xx.en.marian.translate_to.pon': 'opus_mt_en_pon',
               'xx.en.marian.translate_to.poz': 'opus_mt_en_poz',
               'xx.en.marian.translate_to.pqe': 'opus_mt_en_pqe',
               'xx.en.marian.translate_to.pqw': 'opus_mt_en_pqw',
               'xx.en.marian.translate_to.rn': 'opus_mt_en_rn',
               'xx.en.marian.translate_to.rnd': 'opus_mt_en_rnd',
               'xx.en.marian.translate_to.ro': 'opus_mt_en_ro',
               'xx.en.marian.translate_to.roa': 'opus_mt_en_roa',
               'xx.en.marian.translate_to.ru': 'opus_mt_en_ru',
               'xx.en.marian.translate_to.run': 'opus_mt_en_run',
               'xx.en.marian.translate_to.rw': 'opus_mt_en_rw',
               'xx.en.marian.translate_to.sal': 'opus_mt_en_sal',
               'xx.en.marian.translate_to.sem': 'opus_mt_en_sem',
               'xx.en.marian.translate_to.sg': 'opus_mt_en_sg',
               'xx.en.marian.translate_to.sit': 'opus_mt_en_sit',
               'xx.en.marian.translate_to.sk': 'opus_mt_en_sk',
               'xx.en.marian.translate_to.sla': 'opus_mt_en_sla',
               'xx.en.marian.translate_to.sm': 'opus_mt_en_sm',
               'xx.en.marian.translate_to.sn': 'opus_mt_en_sn',
               'xx.en.marian.translate_to.sq': 'opus_mt_en_sq',
               'xx.en.marian.translate_to.ss': 'opus_mt_en_ss',
               'xx.en.marian.translate_to.st': 'opus_mt_en_st',
               'xx.en.marian.translate_to.sv': 'opus_mt_en_sv',
               'xx.en.marian.translate_to.sw': 'opus_mt_en_sw',
               'xx.en.marian.translate_to.swc': 'opus_mt_en_swc',
               'xx.en.marian.translate_to.tdt': 'opus_mt_en_tdt',
               'xx.en.marian.translate_to.ti': 'opus_mt_en_ti',
               'xx.en.marian.translate_to.tiv': 'opus_mt_en_tiv',
               'xx.en.marian.translate_to.tl': 'opus_mt_en_tl',
               'xx.en.marian.translate_to.tll': 'opus_mt_en_tll',
               'xx.en.marian.translate_to.tn': 'opus_mt_en_tn',
               'xx.en.marian.translate_to.to': 'opus_mt_en_to',
               'xx.en.marian.translate_to.toi': 'opus_mt_en_toi',
               'xx.en.marian.translate_to.tpi': 'opus_mt_en_tpi',
               'xx.en.marian.translate_to.trk': 'opus_mt_en_trk',
               'xx.en.marian.translate_to.ts': 'opus_mt_en_ts',
               'xx.en.marian.translate_to.tut': 'opus_mt_en_tut',
               'xx.en.marian.translate_to.tvl': 'opus_mt_en_tvl',
               'xx.en.marian.translate_to.tw': 'opus_mt_en_tw',
               'xx.en.marian.translate_to.ty': 'opus_mt_en_ty',
               'xx.en.marian.translate_to.uk': 'opus_mt_en_uk',
               'xx.en.marian.translate_to.umb': 'opus_mt_en_umb',
               'xx.en.marian.translate_to.ur': 'opus_mt_en_ur',
               'xx.en.marian.translate_to.urj': 'opus_mt_en_urj',
               'xx.en.marian.translate_to.vi': 'opus_mt_en_vi',
               'xx.en.marian.translate_to.xh': 'opus_mt_en_xh',
               'xx.en.marian.translate_to.zh': 'opus_mt_en_zh',
               'xx.en.marian.translate_to.zle': 'opus_mt_en_zle',
               'xx.en.marian.translate_to.zls': 'opus_mt_en_zls',
               'xx.en.marian.translate_to.zlw': 'opus_mt_en_zlw',
               'xx.eo.marian.translate_to.af': 'opus_mt_af_eo',
               'xx.eo.marian.translate_to.ar': 'opus_mt_ar_eo',
               'xx.eo.marian.translate_to.bg': 'opus_mt_bg_eo',
               'xx.eo.marian.translate_to.cs': 'opus_mt_cs_eo',
               'xx.eo.marian.translate_to.da': 'opus_mt_da_eo',
               'xx.eo.marian.translate_to.de': 'opus_mt_de_eo',
               'xx.eo.marian.translate_to.el': 'opus_mt_el_eo',
               'xx.eo.marian.translate_to.en': 'opus_mt_eo_en',
               'xx.eo.marian.translate_to.es': 'opus_mt_es_eo',
               'xx.eo.marian.translate_to.fi': 'opus_mt_fi_eo',
               'xx.eo.marian.translate_to.fr': 'opus_mt_fr_eo',
               'xx.eo.marian.translate_to.he': 'opus_mt_he_eo',
               'xx.eo.marian.translate_to.hu': 'opus_mt_hu_eo',
               'xx.eo.marian.translate_to.is': 'opus_mt_is_eo',
               'xx.eo.marian.translate_to.it': 'opus_mt_it_eo',
               'xx.eo.marian.translate_to.lt': 'opus_mt_lt_eo',
               'xx.eo.marian.translate_to.nl': 'opus_mt_nl_eo',
               'xx.eo.marian.translate_to.pl': 'opus_mt_pl_eo',
               'xx.eo.marian.translate_to.pt': 'opus_mt_pt_eo',
               'xx.eo.marian.translate_to.ro': 'opus_mt_ro_eo',
               'xx.eo.marian.translate_to.ru': 'opus_mt_ru_eo',
               'xx.eo.marian.translate_to.sh': 'opus_mt_sh_eo',
               'xx.eo.marian.translate_to.sv': 'opus_mt_sv_eo',
               'xx.eo.marian.translate_to.tr': 'opus_mt_tr_eo',
               'xx.eo.marian.translate_to.vi': 'opus_mt_vi_eo',
               'xx.es.marian.translate_to.aed': 'opus_mt_aed_es',
               'xx.es.marian.translate_to.af': 'opus_mt_af_es',
               'xx.es.marian.translate_to.ar': 'opus_mt_ar_es',
               'xx.es.marian.translate_to.ase': 'opus_mt_ase_es',
               'xx.es.marian.translate_to.az': 'opus_mt_az_es',
               'xx.es.marian.translate_to.bcl': 'opus_mt_bcl_es',
               'xx.es.marian.translate_to.be': 'opus_mt_be_es',
               'xx.es.marian.translate_to.bem': 'opus_mt_bem_es',
               'xx.es.marian.translate_to.ber': 'opus_mt_ber_es',
               'xx.es.marian.translate_to.bg': 'opus_mt_bg_es',
               'xx.es.marian.translate_to.bi': 'opus_mt_bi_es',
               'xx.es.marian.translate_to.bzs': 'opus_mt_bzs_es',
               'xx.es.marian.translate_to.ca': 'opus_mt_ca_es',
               'xx.es.marian.translate_to.ceb': 'opus_mt_ceb_es',
               'xx.es.marian.translate_to.chk': 'opus_mt_chk_es',
               'xx.es.marian.translate_to.crs': 'opus_mt_crs_es',
               'xx.es.marian.translate_to.csg': 'opus_mt_csg_es',
               'xx.es.marian.translate_to.csn': 'opus_mt_csn_es',
               'xx.es.marian.translate_to.da': 'opus_mt_da_es',
               'xx.es.marian.translate_to.de': 'opus_mt_de_es',
               'xx.es.marian.translate_to.ee': 'opus_mt_ee_es',
               'xx.es.marian.translate_to.en': 'opus_mt_es_en',
               'xx.es.marian.translate_to.eo': 'opus_mt_eo_es',
               'xx.es.marian.translate_to.es': 'opus_mt_es_es',
               'xx.es.marian.translate_to.et': 'opus_mt_et_es',
               'xx.es.marian.translate_to.eu': 'opus_mt_eu_es',
               'xx.es.marian.translate_to.fi': 'opus_mt_fi_es',
               'xx.es.marian.translate_to.fr': 'opus_mt_fr_es',
               'xx.es.marian.translate_to.gaa': 'opus_mt_gaa_es',
               'xx.es.marian.translate_to.gil': 'opus_mt_gil_es',
               'xx.es.marian.translate_to.gl': 'opus_mt_gl_es',
               'xx.es.marian.translate_to.guw': 'opus_mt_guw_es',
               'xx.es.marian.translate_to.ha': 'opus_mt_ha_es',
               'xx.es.marian.translate_to.he': 'opus_mt_he_es',
               'xx.es.marian.translate_to.hr': 'opus_mt_hr_es',
               'xx.es.marian.translate_to.ht': 'opus_mt_ht_es',
               'xx.es.marian.translate_to.id': 'opus_mt_id_es',
               'xx.es.marian.translate_to.ig': 'opus_mt_ig_es',
               'xx.es.marian.translate_to.ilo': 'opus_mt_ilo_es',
               'xx.es.marian.translate_to.is': 'opus_mt_is_es',
               'xx.es.marian.translate_to.iso': 'opus_mt_iso_es',
               'xx.es.marian.translate_to.it': 'opus_mt_it_es',
               'xx.es.marian.translate_to.ja': 'opus_mt_ja_es',
               'xx.es.marian.translate_to.kg': 'opus_mt_kg_es',
               'xx.es.marian.translate_to.ko': 'opus_mt_ko_es',
               'xx.es.marian.translate_to.kqn': 'opus_mt_kqn_es',
               'xx.es.marian.translate_to.lg': 'opus_mt_lg_es',
               'xx.es.marian.translate_to.ln': 'opus_mt_ln_es',
               'xx.es.marian.translate_to.loz': 'opus_mt_loz_es',
               'xx.es.marian.translate_to.lt': 'opus_mt_lt_es',
               'xx.es.marian.translate_to.lu': 'opus_mt_lu_es',
               'xx.es.marian.translate_to.lua': 'opus_mt_lua_es',
               'xx.es.marian.translate_to.lue': 'opus_mt_lue_es',
               'xx.es.marian.translate_to.lus': 'opus_mt_lus_es',
               'xx.es.marian.translate_to.lv': 'opus_mt_lv_es',
               'xx.es.marian.translate_to.mfe': 'opus_mt_mfe_es',
               'xx.es.marian.translate_to.mfs': 'opus_mt_mfs_es',
               'xx.es.marian.translate_to.mg': 'opus_mt_mg_es',
               'xx.es.marian.translate_to.mh': 'opus_mt_mh_es',
               'xx.es.marian.translate_to.mk': 'opus_mt_mk_es',
               'xx.es.marian.translate_to.mt': 'opus_mt_mt_es',
               'xx.es.marian.translate_to.niu': 'opus_mt_niu_es',
               'xx.es.marian.translate_to.nl': 'opus_mt_nl_es',
               'xx.es.marian.translate_to.no': 'opus_mt_no_es',
               'xx.es.marian.translate_to.nso': 'opus_mt_nso_es',
               'xx.es.marian.translate_to.ny': 'opus_mt_ny_es',
               'xx.es.marian.translate_to.pag': 'opus_mt_pag_es',
               'xx.es.marian.translate_to.pap': 'opus_mt_pap_es',
               'xx.es.marian.translate_to.pis': 'opus_mt_pis_es',
               'xx.es.marian.translate_to.pl': 'opus_mt_pl_es',
               'xx.es.marian.translate_to.pon': 'opus_mt_pon_es',
               'xx.es.marian.translate_to.prl': 'opus_mt_prl_es',
               'xx.es.marian.translate_to.rn': 'opus_mt_rn_es',
               'xx.es.marian.translate_to.ru': 'opus_mt_ru_es',
               'xx.es.marian.translate_to.run': 'opus_mt_run_es',
               'xx.es.marian.translate_to.rw': 'opus_mt_rw_es',
               'xx.es.marian.translate_to.sg': 'opus_mt_sg_es',
               'xx.es.marian.translate_to.sk': 'opus_mt_sk_es',
               'xx.es.marian.translate_to.sl': 'opus_mt_sl_es',
               'xx.es.marian.translate_to.sm': 'opus_mt_sm_es',
               'xx.es.marian.translate_to.sn': 'opus_mt_sn_es',
               'xx.es.marian.translate_to.sq': 'opus_mt_sq_es',
               'xx.es.marian.translate_to.srn': 'opus_mt_srn_es',
               'xx.es.marian.translate_to.ssp': 'opus_mt_ssp_es',
               'xx.es.marian.translate_to.st': 'opus_mt_st_es',
               'xx.es.marian.translate_to.sv': 'opus_mt_sv_es',
               'xx.es.marian.translate_to.swc': 'opus_mt_swc_es',
               'xx.es.marian.translate_to.tl': 'opus_mt_tl_es',
               'xx.es.marian.translate_to.tll': 'opus_mt_tll_es',
               'xx.es.marian.translate_to.tn': 'opus_mt_tn_es',
               'xx.es.marian.translate_to.to': 'opus_mt_to_es',
               'xx.es.marian.translate_to.toi': 'opus_mt_toi_es',
               'xx.es.marian.translate_to.tr': 'opus_mt_tr_es',
               'xx.es.marian.translate_to.ts': 'opus_mt_ts_es',
               'xx.es.marian.translate_to.tum': 'opus_mt_tum_es',
               'xx.es.marian.translate_to.tvl': 'opus_mt_tvl_es',
               'xx.es.marian.translate_to.tw': 'opus_mt_tw_es',
               'xx.es.marian.translate_to.ty': 'opus_mt_ty_es',
               'xx.es.marian.translate_to.tzo': 'opus_mt_tzo_es',
               'xx.es.marian.translate_to.uk': 'opus_mt_uk_es',
               'xx.es.marian.translate_to.ve': 'opus_mt_ve_es',
               'xx.es.marian.translate_to.vi': 'opus_mt_vi_es',
               'xx.es.marian.translate_to.vsl': 'opus_mt_vsl_es',
               'xx.es.marian.translate_to.war': 'opus_mt_war_es',
               'xx.es.marian.translate_to.xh': 'opus_mt_xh_es',
               'xx.es.marian.translate_to.yo': 'opus_mt_yo_es',
               'xx.es.marian.translate_to.zai': 'opus_mt_zai_es',
               'xx.es.marian.translate_to.zh': 'opus_tatoeba_es_zh',
               'xx.es.marian.translate_to.zne': 'opus_mt_zne_es',
               'xx.et.marian.translate_to.de': 'opus_mt_de_et',
               'xx.et.marian.translate_to.en': 'opus_mt_et_en',
               'xx.et.marian.translate_to.es': 'opus_mt_es_et',
               'xx.et.marian.translate_to.fi': 'opus_mt_fi_et',
               'xx.et.marian.translate_to.ru': 'opus_mt_ru_et',
               'xx.et.marian.translate_to.sv': 'opus_mt_sv_et',
               'xx.eu.marian.translate_to.de': 'opus_mt_de_eu',
               'xx.eu.marian.translate_to.en': 'opus_mt_eu_en',
               'xx.eu.marian.translate_to.es': 'opus_mt_es_eu',
               'xx.eu.marian.translate_to.ru': 'opus_mt_ru_eu',
               'xx.euq.marian.translate_to.en': 'opus_mt_euq_en',
               'xx.fi.marian.translate_to.af': 'opus_mt_af_fi',
               'xx.fi.marian.translate_to.bcl': 'opus_mt_bcl_fi',
               'xx.fi.marian.translate_to.bem': 'opus_mt_bem_fi',
               'xx.fi.marian.translate_to.bg': 'opus_mt_bg_fi',
               'xx.fi.marian.translate_to.bzs': 'opus_mt_bzs_fi',
               'xx.fi.marian.translate_to.ceb': 'opus_mt_ceb_fi',
               'xx.fi.marian.translate_to.crs': 'opus_mt_crs_fi',
               'xx.fi.marian.translate_to.cs': 'opus_mt_cs_fi',
               'xx.fi.marian.translate_to.da': 'opus_mt_da_fi',
               'xx.fi.marian.translate_to.de': 'opus_mt_de_fi',
               'xx.fi.marian.translate_to.ee': 'opus_mt_ee_fi',
               'xx.fi.marian.translate_to.efi': 'opus_mt_efi_fi',
               'xx.fi.marian.translate_to.el': 'opus_mt_el_fi',
               'xx.fi.marian.translate_to.en': 'opus_mt_fi_en',
               'xx.fi.marian.translate_to.eo': 'opus_mt_eo_fi',
               'xx.fi.marian.translate_to.es': 'opus_mt_es_fi',
               'xx.fi.marian.translate_to.et': 'opus_mt_et_fi',
               'xx.fi.marian.translate_to.fi': 'opus_mt_fi_fi',
               'xx.fi.marian.translate_to.fse': 'opus_mt_fse_fi',
               'xx.fi.marian.translate_to.gaa': 'opus_mt_gaa_fi',
               'xx.fi.marian.translate_to.gil': 'opus_mt_gil_fi',
               'xx.fi.marian.translate_to.guw': 'opus_mt_guw_fi',
               'xx.fi.marian.translate_to.ha': 'opus_mt_ha_fi',
               'xx.fi.marian.translate_to.he': 'opus_mt_he_fi',
               'xx.fi.marian.translate_to.hil': 'opus_mt_hil_fi',
               'xx.fi.marian.translate_to.hr': 'opus_mt_hr_fi',
               'xx.fi.marian.translate_to.ht': 'opus_mt_ht_fi',
               'xx.fi.marian.translate_to.hu': 'opus_mt_hu_fi',
               'xx.fi.marian.translate_to.id': 'opus_mt_id_fi',
               'xx.fi.marian.translate_to.ig': 'opus_mt_ig_fi',
               'xx.fi.marian.translate_to.ilo': 'opus_mt_ilo_fi',
               'xx.fi.marian.translate_to.is': 'opus_mt_is_fi',
               'xx.fi.marian.translate_to.iso': 'opus_mt_iso_fi',
               'xx.fi.marian.translate_to.ja': 'opus_mt_ja_fi',
               'xx.fi.marian.translate_to.ko': 'opus_mt_ko_fi',
               'xx.fi.marian.translate_to.lg': 'opus_mt_lg_fi',
               'xx.fi.marian.translate_to.loz': 'opus_mt_loz_fi',
               'xx.fi.marian.translate_to.lu': 'opus_mt_lu_fi',
               'xx.fi.marian.translate_to.lua': 'opus_mt_lua_fi',
               'xx.fi.marian.translate_to.lue': 'opus_mt_lue_fi',
               'xx.fi.marian.translate_to.lus': 'opus_mt_lus_fi',
               'xx.fi.marian.translate_to.lv': 'opus_mt_lv_fi',
               'xx.fi.marian.translate_to.mh': 'opus_mt_mh_fi',
               'xx.fi.marian.translate_to.mk': 'opus_mt_mk_fi',
               'xx.fi.marian.translate_to.mt': 'opus_mt_mt_fi',
               'xx.fi.marian.translate_to.niu': 'opus_mt_niu_fi',
               'xx.fi.marian.translate_to.nl': 'opus_mt_nl_fi',
               'xx.fi.marian.translate_to.no': 'opus_mt_no_fi',
               'xx.fi.marian.translate_to.nso': 'opus_mt_nso_fi',
               'xx.fi.marian.translate_to.pag': 'opus_mt_pag_fi',
               'xx.fi.marian.translate_to.pap': 'opus_mt_pap_fi',
               'xx.fi.marian.translate_to.pis': 'opus_mt_pis_fi',
               'xx.fi.marian.translate_to.pon': 'opus_mt_pon_fi',
               'xx.fi.marian.translate_to.ro': 'opus_mt_ro_fi',
               'xx.fi.marian.translate_to.ru': 'opus_mt_ru_fi',
               'xx.fi.marian.translate_to.sg': 'opus_mt_sg_fi',
               'xx.fi.marian.translate_to.sk': 'opus_mt_sk_fi',
               'xx.fi.marian.translate_to.sl': 'opus_mt_sl_fi',
               'xx.fi.marian.translate_to.st': 'opus_mt_st_fi',
               'xx.fi.marian.translate_to.sv': 'opus_mt_sv_fi',
               'xx.fi.marian.translate_to.swc': 'opus_mt_swc_fi',
               'xx.fi.marian.translate_to.tll': 'opus_mt_tll_fi',
               'xx.fi.marian.translate_to.toi': 'opus_mt_toi_fi',
               'xx.fi.marian.translate_to.ts': 'opus_mt_ts_fi',
               'xx.fi.marian.translate_to.tvl': 'opus_mt_tvl_fi',
               'xx.fi.marian.translate_to.tw': 'opus_mt_tw_fi',
               'xx.fi.marian.translate_to.ty': 'opus_mt_ty_fi',
               'xx.fi.marian.translate_to.uk': 'opus_mt_uk_fi',
               'xx.fi.marian.translate_to.war': 'opus_mt_war_fi',
               'xx.fi.marian.translate_to.yo': 'opus_mt_yo_fi',
               'xx.fi.marian.translate_to.zh': 'opus_mt_zh_fi',
               'xx.fi.marian.translate_to.zne': 'opus_mt_zne_fi',
               'xx.fiu.marian.translate_to.en': 'opus_mt_fiu_en',
               'xx.fiu.marian.translate_to.fiu': 'opus_mt_fiu_fiu',
               'xx.fj.marian.translate_to.de': 'opus_mt_de_fj',
               'xx.fj.marian.translate_to.en': 'opus_mt_fj_en',
               'xx.fj.marian.translate_to.es': 'opus_mt_es_fj',
               'xx.fj.marian.translate_to.fi': 'opus_mt_fi_fj',
               'xx.fj.marian.translate_to.fr': 'opus_mt_fr_fj',
               'xx.fj.marian.translate_to.sv': 'opus_mt_sv_fj',
               'xx.fr.marian.translate_to.af': 'opus_mt_af_fr',
               'xx.fr.marian.translate_to.ar': 'opus_mt_ar_fr',
               'xx.fr.marian.translate_to.ase': 'opus_mt_ase_fr',
               'xx.fr.marian.translate_to.bcl': 'opus_mt_bcl_fr',
               'xx.fr.marian.translate_to.bem': 'opus_mt_bem_fr',
               'xx.fr.marian.translate_to.ber': 'opus_mt_ber_fr',
               'xx.fr.marian.translate_to.bg': 'opus_mt_bg_fr',
               'xx.fr.marian.translate_to.bi': 'opus_mt_bi_fr',
               'xx.fr.marian.translate_to.bzs': 'opus_mt_bzs_fr',
               'xx.fr.marian.translate_to.ca': 'opus_mt_ca_fr',
               'xx.fr.marian.translate_to.ceb': 'opus_mt_ceb_fr',
               'xx.fr.marian.translate_to.chk': 'opus_mt_chk_fr',
               'xx.fr.marian.translate_to.crs': 'opus_mt_crs_fr',
               'xx.fr.marian.translate_to.cs': 'opus_mt_cs_fr',
               'xx.fr.marian.translate_to.da': 'opus_mt_da_fr',
               'xx.fr.marian.translate_to.de': 'opus_mt_de_fr',
               'xx.fr.marian.translate_to.ee': 'opus_mt_ee_fr',
               'xx.fr.marian.translate_to.efi': 'opus_mt_efi_fr',
               'xx.fr.marian.translate_to.el': 'opus_mt_el_fr',
               'xx.fr.marian.translate_to.en': 'opus_mt_fr_en',
               'xx.fr.marian.translate_to.eo': 'opus_mt_eo_fr',
               'xx.fr.marian.translate_to.es': 'opus_mt_es_fr',
               'xx.fr.marian.translate_to.et': 'opus_mt_et_fr',
               'xx.fr.marian.translate_to.fi': 'opus_mt_fi_fr',
               'xx.fr.marian.translate_to.fj': 'opus_mt_fj_fr',
               'xx.fr.marian.translate_to.gaa': 'opus_mt_gaa_fr',
               'xx.fr.marian.translate_to.gil': 'opus_mt_gil_fr',
               'xx.fr.marian.translate_to.guw': 'opus_mt_guw_fr',
               'xx.fr.marian.translate_to.ha': 'opus_mt_ha_fr',
               'xx.fr.marian.translate_to.hr': 'opus_mt_hr_fr',
               'xx.fr.marian.translate_to.ht': 'opus_mt_ht_fr',
               'xx.fr.marian.translate_to.hu': 'opus_mt_hu_fr',
               'xx.fr.marian.translate_to.id': 'opus_mt_id_fr',
               'xx.fr.marian.translate_to.ig': 'opus_mt_ig_fr',
               'xx.fr.marian.translate_to.is': 'opus_mt_is_fr',
               'xx.fr.marian.translate_to.iso': 'opus_mt_iso_fr',
               'xx.fr.marian.translate_to.it': 'opus_mt_it_fr',
               'xx.fr.marian.translate_to.ja': 'opus_mt_ja_fr',
               'xx.fr.marian.translate_to.kg': 'opus_mt_kg_fr',
               'xx.fr.marian.translate_to.ko': 'opus_mt_ko_fr',
               'xx.fr.marian.translate_to.kqn': 'opus_mt_kqn_fr',
               'xx.fr.marian.translate_to.kwy': 'opus_mt_kwy_fr',
               'xx.fr.marian.translate_to.lg': 'opus_mt_lg_fr',
               'xx.fr.marian.translate_to.ln': 'opus_mt_ln_fr',
               'xx.fr.marian.translate_to.loz': 'opus_mt_loz_fr',
               'xx.fr.marian.translate_to.lt': 'opus_mt_lt_fr',
               'xx.fr.marian.translate_to.lu': 'opus_mt_lu_fr',
               'xx.fr.marian.translate_to.lua': 'opus_mt_lua_fr',
               'xx.fr.marian.translate_to.lue': 'opus_mt_lue_fr',
               'xx.fr.marian.translate_to.lus': 'opus_mt_lus_fr',
               'xx.fr.marian.translate_to.lv': 'opus_mt_lv_fr',
               'xx.fr.marian.translate_to.mk': 'opus_mt_mk_fr',
               'xx.fr.marian.translate_to.ms': 'opus_mt_ms_fr',
               'xx.fr.marian.translate_to.mt': 'opus_mt_mt_fr',
               'xx.fr.marian.translate_to.niu': 'opus_mt_niu_fr',
               'xx.fr.marian.translate_to.nl': 'opus_mt_nl_fr',
               'xx.fr.marian.translate_to.no': 'opus_mt_no_fr',
               'xx.fr.marian.translate_to.nso': 'opus_mt_nso_fr',
               'xx.fr.marian.translate_to.pap': 'opus_mt_pap_fr',
               'xx.fr.marian.translate_to.pis': 'opus_mt_pis_fr',
               'xx.fr.marian.translate_to.pl': 'opus_mt_pl_fr',
               'xx.fr.marian.translate_to.pon': 'opus_mt_pon_fr',
               'xx.fr.marian.translate_to.rn': 'opus_mt_rn_fr',
               'xx.fr.marian.translate_to.rnd': 'opus_mt_rnd_fr',
               'xx.fr.marian.translate_to.ro': 'opus_mt_ro_fr',
               'xx.fr.marian.translate_to.ru': 'opus_mt_ru_fr',
               'xx.fr.marian.translate_to.rw': 'opus_mt_rw_fr',
               'xx.fr.marian.translate_to.sg': 'opus_mt_sg_fr',
               'xx.fr.marian.translate_to.sk': 'opus_mt_sk_fr',
               'xx.fr.marian.translate_to.sl': 'opus_mt_sl_fr',
               'xx.fr.marian.translate_to.sm': 'opus_mt_sm_fr',
               'xx.fr.marian.translate_to.sn': 'opus_mt_sn_fr',
               'xx.fr.marian.translate_to.srn': 'opus_mt_srn_fr',
               'xx.fr.marian.translate_to.st': 'opus_mt_st_fr',
               'xx.fr.marian.translate_to.sv': 'opus_mt_sv_fr',
               'xx.fr.marian.translate_to.swc': 'opus_mt_swc_fr',
               'xx.fr.marian.translate_to.th': 'opus_mt_th_fr',
               'xx.fr.marian.translate_to.tiv': 'opus_mt_tiv_fr',
               'xx.fr.marian.translate_to.tll': 'opus_mt_tll_fr',
               'xx.fr.marian.translate_to.tn': 'opus_mt_tn_fr',
               'xx.fr.marian.translate_to.to': 'opus_mt_to_fr',
               'xx.fr.marian.translate_to.toi': 'opus_mt_toi_fr',
               'xx.fr.marian.translate_to.tr': 'opus_mt_tr_fr',
               'xx.fr.marian.translate_to.ts': 'opus_mt_ts_fr',
               'xx.fr.marian.translate_to.tum': 'opus_mt_tum_fr',
               'xx.fr.marian.translate_to.tvl': 'opus_mt_tvl_fr',
               'xx.fr.marian.translate_to.tw': 'opus_mt_tw_fr',
               'xx.fr.marian.translate_to.ty': 'opus_mt_ty_fr',
               'xx.fr.marian.translate_to.uk': 'opus_mt_uk_fr',
               'xx.fr.marian.translate_to.vi': 'opus_mt_vi_fr',
               'xx.fr.marian.translate_to.war': 'opus_mt_war_fr',
               'xx.fr.marian.translate_to.wls': 'opus_mt_wls_fr',
               'xx.fr.marian.translate_to.xh': 'opus_mt_xh_fr',
               'xx.fr.marian.translate_to.yap': 'opus_mt_yap_fr',
               'xx.fr.marian.translate_to.yo': 'opus_mt_yo_fr',
               'xx.fr.marian.translate_to.zne': 'opus_mt_zne_fr',
               'xx.fse.marian.translate_to.fi': 'opus_mt_fi_fse',
               'xx.ga.marian.translate_to.en': 'opus_mt_ga_en',
               'xx.gaa.marian.translate_to.de': 'opus_mt_de_gaa',
               'xx.gaa.marian.translate_to.en': 'opus_mt_gaa_en',
               'xx.gaa.marian.translate_to.es': 'opus_mt_es_gaa',
               'xx.gaa.marian.translate_to.fi': 'opus_mt_fi_gaa',
               'xx.gaa.marian.translate_to.fr': 'opus_mt_fr_gaa',
               'xx.gaa.marian.translate_to.sv': 'opus_mt_sv_gaa',
               'xx.gem.marian.translate_to.en': 'opus_mt_gem_en',
               'xx.gem.marian.translate_to.gem': 'opus_mt_gem_gem',
               'xx.gil.marian.translate_to.de': 'opus_mt_de_gil',
               'xx.gil.marian.translate_to.en': 'opus_mt_gil_en',
               'xx.gil.marian.translate_to.es': 'opus_mt_es_gil',
               'xx.gil.marian.translate_to.fi': 'opus_mt_fi_gil',
               'xx.gil.marian.translate_to.fr': 'opus_mt_fr_gil',
               'xx.gil.marian.translate_to.sv': 'opus_mt_sv_gil',
               'xx.gl.marian.translate_to.en': 'opus_mt_gl_en',
               'xx.gl.marian.translate_to.es': 'opus_mt_es_gl',
               'xx.gl.marian.translate_to.pt': 'opus_mt_pt_gl',
               'xx.gmq.marian.translate_to.en': 'opus_mt_gmq_en',
               'xx.gmq.marian.translate_to.gmq': 'opus_mt_gmq_gmq',
               'xx.gmw.marian.translate_to.en': 'opus_mt_gmw_en',
               'xx.gmw.marian.translate_to.gmw': 'opus_mt_gmw_gmw',
               'xx.grk.marian.translate_to.en': 'opus_mt_grk_en',
               'xx.guw.marian.translate_to.de': 'opus_mt_de_guw',
               'xx.guw.marian.translate_to.en': 'opus_mt_guw_en',
               'xx.guw.marian.translate_to.es': 'opus_mt_es_guw',
               'xx.guw.marian.translate_to.fi': 'opus_mt_fi_guw',
               'xx.guw.marian.translate_to.fr': 'opus_mt_fr_guw',
               'xx.guw.marian.translate_to.sv': 'opus_mt_sv_guw',
               'xx.gv.marian.translate_to.en': 'opus_mt_gv_en',
               'xx.ha.marian.translate_to.de': 'opus_mt_de_ha',
               'xx.ha.marian.translate_to.en': 'opus_mt_ha_en',
               'xx.ha.marian.translate_to.es': 'opus_mt_es_ha',
               'xx.ha.marian.translate_to.fi': 'opus_mt_fi_ha',
               'xx.ha.marian.translate_to.fr': 'opus_mt_fr_ha',
               'xx.ha.marian.translate_to.sv': 'opus_mt_sv_ha',
               'xx.he.marian.translate_to.ar': 'opus_mt_ar_he',
               'xx.he.marian.translate_to.de': 'opus_mt_de_he',
               'xx.he.marian.translate_to.eo': 'opus_mt_eo_he',
               'xx.he.marian.translate_to.es': 'opus_mt_es_he',
               'xx.he.marian.translate_to.fi': 'opus_mt_fi_he',
               'xx.he.marian.translate_to.fr': 'opus_mt_fr_he',
               'xx.he.marian.translate_to.it': 'opus_tatoeba_he_it',
               'xx.he.marian.translate_to.ja': 'opus_mt_ja_he',
               'xx.he.marian.translate_to.ru': 'opus_mt_ru_he',
               'xx.he.marian.translate_to.sv': 'opus_mt_sv_he',
               'xx.he.marian.translate_to.uk': 'opus_mt_uk_he',
               'xx.he.marian.translate_to.zh': 'opus_mt_zh_he',
               'xx.he.translate_to.fr': 'opus_tatoeba_he_fr',
               'xx.hi.marian.translate_to.en': 'opus_mt_hi_en',
               'xx.hil.marian.translate_to.de': 'opus_mt_de_hil',
               'xx.hil.marian.translate_to.en': 'opus_mt_hil_en',
               'xx.hil.marian.translate_to.es': 'opus_mt_es_hil',
               'xx.hil.marian.translate_to.fi': 'opus_mt_fi_hil',
               'xx.hil.marian.translate_to.fr': 'opus_mt_fr_hil',
               'xx.hil.marian.translate_to.sv': 'opus_mt_sv_hil',
               'xx.ho.marian.translate_to.de': 'opus_mt_de_ho',
               'xx.ho.marian.translate_to.en': 'opus_mt_ho_en',
               'xx.ho.marian.translate_to.es': 'opus_mt_es_ho',
               'xx.ho.marian.translate_to.fi': 'opus_mt_fi_ho',
               'xx.ho.marian.translate_to.fr': 'opus_mt_fr_ho',
               'xx.ho.marian.translate_to.sv': 'opus_mt_sv_ho',
               'xx.hr.marian.translate_to.de': 'opus_mt_de_hr',
               'xx.hr.marian.translate_to.es': 'opus_mt_es_hr',
               'xx.hr.marian.translate_to.fi': 'opus_mt_fi_hr',
               'xx.hr.marian.translate_to.fr': 'opus_mt_fr_hr',
               'xx.hr.marian.translate_to.sv': 'opus_mt_sv_hr',
               'xx.ht.marian.translate_to.de': 'opus_mt_de_ht',
               'xx.ht.marian.translate_to.en': 'opus_mt_ht_en',
               'xx.ht.marian.translate_to.es': 'opus_mt_es_ht',
               'xx.ht.marian.translate_to.fi': 'opus_mt_fi_ht',
               'xx.ht.marian.translate_to.fr': 'opus_mt_fr_ht',
               'xx.ht.marian.translate_to.sv': 'opus_mt_sv_ht',
               'xx.hu.marian.translate_to.de': 'opus_mt_de_hu',
               'xx.hu.marian.translate_to.en': 'opus_mt_hu_en',
               'xx.hu.marian.translate_to.eo': 'opus_mt_eo_hu',
               'xx.hu.marian.translate_to.fi': 'opus_mt_fi_hu',
               'xx.hu.marian.translate_to.fr': 'opus_mt_fr_hu',
               'xx.hu.marian.translate_to.ja': 'opus_mt_ja_hu',
               'xx.hu.marian.translate_to.ko': 'opus_mt_ko_hu',
               'xx.hu.marian.translate_to.sv': 'opus_mt_sv_hu',
               'xx.hu.marian.translate_to.uk': 'opus_mt_uk_hu',
               'xx.hy.marian.translate_to.en': 'opus_mt_hy_en',
               'xx.hy.marian.translate_to.ru': 'opus_mt_ru_hy',
               'xx.id.marian.translate_to.en': 'opus_mt_id_en',
               'xx.id.marian.translate_to.es': 'opus_mt_es_id',
               'xx.id.marian.translate_to.fi': 'opus_mt_fi_id',
               'xx.id.marian.translate_to.fr': 'opus_mt_fr_id',
               'xx.id.marian.translate_to.sv': 'opus_mt_sv_id',
               'xx.ig.marian.translate_to.de': 'opus_mt_de_ig',
               'xx.ig.marian.translate_to.en': 'opus_mt_ig_en',
               'xx.ig.marian.translate_to.es': 'opus_mt_es_ig',
               'xx.ig.marian.translate_to.fi': 'opus_mt_fi_ig',
               'xx.ig.marian.translate_to.fr': 'opus_mt_fr_ig',
               'xx.ig.marian.translate_to.sv': 'opus_mt_sv_ig',
               'xx.iir.marian.translate_to.en': 'opus_mt_iir_en',
               'xx.iir.marian.translate_to.iir': 'opus_mt_iir_iir',
               'xx.ilo.marian.translate_to.de': 'opus_mt_de_ilo',
               'xx.ilo.marian.translate_to.en': 'opus_mt_ilo_en',
               'xx.ilo.marian.translate_to.es': 'opus_mt_es_ilo',
               'xx.ilo.marian.translate_to.fi': 'opus_mt_fi_ilo',
               'xx.ilo.marian.translate_to.fr': 'opus_mt_fr_ilo',
               'xx.ilo.marian.translate_to.sv': 'opus_mt_sv_ilo',
               'xx.inc.marian.translate_to.en': 'opus_mt_inc_en',
               'xx.inc.marian.translate_to.inc': 'opus_mt_inc_inc',
               'xx.ine.marian.translate_to.en': 'opus_mt_ine_en',
               'xx.ine.marian.translate_to.ine': 'opus_mt_ine_ine',
               'xx.is.marian.translate_to.de': 'opus_mt_de_is',
               'xx.is.marian.translate_to.en': 'opus_mt_is_en',
               'xx.is.marian.translate_to.es': 'opus_mt_es_is',
               'xx.is.marian.translate_to.fi': 'opus_mt_fi_is',
               'xx.is.marian.translate_to.it': 'opus_mt_it_is',
               'xx.is.marian.translate_to.sv': 'opus_mt_sv_is',
               'xx.iso.marian.translate_to.de': 'opus_mt_de_iso',
               'xx.iso.marian.translate_to.en': 'opus_mt_iso_en',
               'xx.iso.marian.translate_to.es': 'opus_mt_es_iso',
               'xx.iso.marian.translate_to.fi': 'opus_mt_fi_iso',
               'xx.iso.marian.translate_to.fr': 'opus_mt_fr_iso',
               'xx.iso.marian.translate_to.sv': 'opus_mt_sv_iso',
               'xx.it.marian.translate_to.ar': 'opus_mt_ar_it',
               'xx.it.marian.translate_to.bg': 'opus_mt_bg_it',
               'xx.it.marian.translate_to.ca': 'opus_mt_ca_it',
               'xx.it.marian.translate_to.de': 'opus_mt_de_it',
               'xx.it.marian.translate_to.en': 'opus_mt_it_en',
               'xx.it.marian.translate_to.eo': 'opus_mt_eo_it',
               'xx.it.marian.translate_to.es': 'opus_mt_es_it',
               'xx.it.marian.translate_to.fi': 'opus_mt_fi_it',
               'xx.it.marian.translate_to.he': 'opus_mt_he_it',
               'xx.it.marian.translate_to.is': 'opus_mt_is_it',
               'xx.it.marian.translate_to.ja': 'opus_mt_ja_it',
               'xx.it.marian.translate_to.lt': 'opus_mt_lt_it',
               'xx.it.marian.translate_to.ms': 'opus_mt_ms_it',
               'xx.it.marian.translate_to.uk': 'opus_mt_uk_it',
               'xx.it.marian.translate_to.vi': 'opus_mt_vi_it',
               'xx.it.marian.translate_to.zh': 'opus_mt_zh_it',
               'xx.it.translate_to.he': 'opus_tatoeba_it_he',
               'xx.itc.marian.translate_to.en': 'opus_mt_itc_en',
               'xx.itc.marian.translate_to.itc': 'opus_mt_itc_itc',
               'xx.ja.marian.translate_to.en': 'opus_mt_ja_en',
               'xx.jap.marian.translate_to.en': 'opus_mt_jap_en',
               'xx.ka.marian.translate_to.en': 'opus_mt_ka_en',
               'xx.kab.marian.translate_to.en': 'opus_mt_kab_en',
               'xx.kg.marian.translate_to.de': 'opus_mt_de_kg',
               'xx.kg.marian.translate_to.en': 'opus_mt_kg_en',
               'xx.kg.marian.translate_to.es': 'opus_mt_es_kg',
               'xx.kg.marian.translate_to.fi': 'opus_mt_fi_kg',
               'xx.kg.marian.translate_to.fr': 'opus_mt_fr_kg',
               'xx.kg.marian.translate_to.sv': 'opus_mt_sv_kg',
               'xx.kj.marian.translate_to.en': 'opus_mt_kj_en',
               'xx.kl.marian.translate_to.en': 'opus_mt_kl_en',
               'xx.ko.marian.translate_to.en': 'opus_mt_ko_en',
               'xx.kqn.marian.translate_to.en': 'opus_mt_kqn_en',
               'xx.kqn.marian.translate_to.fi': 'opus_mt_fi_kqn',
               'xx.kqn.marian.translate_to.fr': 'opus_mt_fr_kqn',
               'xx.kqn.marian.translate_to.sv': 'opus_mt_sv_kqn',
               'xx.kwn.marian.translate_to.en': 'opus_mt_kwn_en',
               'xx.kwy.marian.translate_to.en': 'opus_mt_kwy_en',
               'xx.kwy.marian.translate_to.fr': 'opus_mt_fr_kwy',
               'xx.kwy.marian.translate_to.sv': 'opus_mt_sv_kwy',
               'xx.lg.marian.translate_to.en': 'opus_mt_lg_en',
               'xx.lg.marian.translate_to.fi': 'opus_mt_fi_lg',
               'xx.lg.marian.translate_to.fr': 'opus_mt_fr_lg',
               'xx.lg.marian.translate_to.sv': 'opus_mt_sv_lg',
               'xx.ln.marian.translate_to.de': 'opus_mt_de_ln',
               'xx.ln.marian.translate_to.en': 'opus_mt_ln_en',
               'xx.ln.marian.translate_to.es': 'opus_mt_es_ln',
               'xx.ln.marian.translate_to.fi': 'opus_mt_fi_ln',
               'xx.ln.marian.translate_to.fr': 'opus_mt_fr_ln',
               'xx.ln.marian.translate_to.sv': 'opus_mt_sv_ln',
               'xx.loz.marian.translate_to.de': 'opus_mt_de_loz',
               'xx.loz.marian.translate_to.en': 'opus_mt_loz_en',
               'xx.loz.marian.translate_to.es': 'opus_mt_es_loz',
               'xx.loz.marian.translate_to.fr': 'opus_mt_fr_loz',
               'xx.lt.marian.translate_to.de': 'opus_mt_de_lt',
               'xx.lt.marian.translate_to.es': 'opus_mt_es_lt',
               'xx.lt.marian.translate_to.it': 'opus_mt_it_lt',
               'xx.lt.marian.translate_to.pl': 'opus_mt_pl_lt',
               'xx.lt.marian.translate_to.ru': 'opus_mt_ru_lt',
               'xx.lt.marian.translate_to.tr': 'opus_mt_tr_lt',
               'xx.lu.marian.translate_to.en': 'opus_mt_lu_en',
               'xx.lu.marian.translate_to.fi': 'opus_mt_fi_lu',
               'xx.lu.marian.translate_to.fr': 'opus_mt_fr_lu',
               'xx.lu.marian.translate_to.sv': 'opus_mt_sv_lu',
               'xx.lua.marian.translate_to.de': 'opus_mt_de_lua',
               'xx.lua.marian.translate_to.en': 'opus_mt_lua_en',
               'xx.lua.marian.translate_to.es': 'opus_mt_es_lua',
               'xx.lua.marian.translate_to.fi': 'opus_mt_fi_lua',
               'xx.lua.marian.translate_to.fr': 'opus_mt_fr_lua',
               'xx.lua.marian.translate_to.sv': 'opus_mt_sv_lua',
               'xx.lue.marian.translate_to.en': 'opus_mt_lue_en',
               'xx.lue.marian.translate_to.fi': 'opus_mt_fi_lue',
               'xx.lue.marian.translate_to.fr': 'opus_mt_fr_lue',
               'xx.lue.marian.translate_to.sv': 'opus_mt_sv_lue',
               'xx.lun.marian.translate_to.en': 'opus_mt_lun_en',
               'xx.luo.marian.translate_to.en': 'opus_mt_luo_en',
               'xx.lus.marian.translate_to.en': 'opus_mt_lus_en',
               'xx.lus.marian.translate_to.es': 'opus_mt_es_lus',
               'xx.lus.marian.translate_to.fi': 'opus_mt_fi_lus',
               'xx.lus.marian.translate_to.fr': 'opus_mt_fr_lus',
               'xx.lus.marian.translate_to.sv': 'opus_mt_sv_lus',
               'xx.lv.marian.translate_to.en': 'opus_mt_lv_en',
               'xx.lv.marian.translate_to.fi': 'opus_mt_fi_lv',
               'xx.lv.marian.translate_to.ru': 'opus_mt_ru_lv',
               'xx.lv.marian.translate_to.sv': 'opus_mt_sv_lv',
               'xx.marian': 'opus_mt_en_fr',
               'xx.mfe.marian.translate_to.en': 'opus_mt_mfe_en',
               'xx.mfe.marian.translate_to.fi': 'opus_mt_fi_mfe',
               'xx.mfe.marian.translate_to.fr': 'opus_mt_fr_mfe',
               'xx.mfe.marian.translate_to.sv': 'opus_mt_sv_mfe',
               'xx.mfs.marian.translate_to.es': 'opus_mt_es_mfs',
               'xx.mg.marian.translate_to.en': 'opus_mt_mg_en',
               'xx.mg.marian.translate_to.fi': 'opus_mt_fi_mg',
               'xx.mh.marian.translate_to.en': 'opus_mt_mh_en',
               'xx.mh.marian.translate_to.fi': 'opus_mt_fi_mh',
               'xx.mh.marian.translate_to.fr': 'opus_mt_fr_mh',
               'xx.mh.marian.translate_to.sv': 'opus_mt_sv_mh',
               'xx.mk.marian.translate_to.en': 'opus_mt_mk_en',
               'xx.mk.marian.translate_to.es': 'opus_mt_es_mk',
               'xx.mk.marian.translate_to.fi': 'opus_mt_fi_mk',
               'xx.mkh.marian.translate_to.en': 'opus_mt_mkh_en',
               'xx.ml.marian.translate_to.en': 'opus_mt_ml_en',
               'xx.mos.marian.translate_to.en': 'opus_mt_mos_en',
               'xx.mos.marian.translate_to.fi': 'opus_mt_fi_mos',
               'xx.mos.marian.translate_to.fr': 'opus_mt_fr_mos',
               'xx.mos.marian.translate_to.sv': 'opus_mt_sv_mos',
               'xx.mr.marian.translate_to.en': 'opus_mt_mr_en',
               'xx.ms.marian.translate_to.de': 'opus_mt_de_ms',
               'xx.ms.marian.translate_to.fr': 'opus_mt_fr_ms',
               'xx.ms.marian.translate_to.it': 'opus_mt_it_ms',
               'xx.ms.marian.translate_to.ja': 'opus_mt_ja_ms',
               'xx.ms.marian.translate_to.ms': 'opus_mt_ms_ms',
               'xx.ms.marian.translate_to.zh': 'opus_mt_zh_ms',
               'xx.mt.marian.translate_to.de': 'opus_mt_de_mt',
               'xx.mt.marian.translate_to.en': 'opus_mt_mt_en',
               'xx.mt.marian.translate_to.es': 'opus_mt_es_mt',
               'xx.mt.marian.translate_to.fi': 'opus_mt_fi_mt',
               'xx.mt.marian.translate_to.fr': 'opus_mt_fr_mt',
               'xx.mt.marian.translate_to.sv': 'opus_mt_sv_mt',
               'xx.mul.marian.translate_to.en': 'opus_mt_mul_en',
               'xx.ner.bert': 'bert_ner_indicner',
               'xx.ner.bert.extra_support_it_es_vi_en': 'bert_ner_ner_en_vi_it_es_tinparadox',
               'xx.ner.bert.wikiann.base': 'bert_ner_nbailab_base_ner_scandi',
               'xx.ner.biobert.craft.cased_base_augmented_finetuned.extra_support_en': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft_augmentedtransfer_en',
               'xx.ner.biobert.craft.cased_base_augmented_finetuned.extra_support_en.by_StivenLancheros': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft_augmented_en',
               'xx.ner.biobert.craft.cased_base_augmented_finetuned.extra_support_es': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft_augmentedtransfer_es',
               'xx.ner.biobert.craft.cased_base_augmented_finetuned.extra_support_es.by_StivenLancheros': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft_augmented_es',
               'xx.ner.biobert.craft.cased_base_finetuned': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft_english',
               'xx.ner.biobert.craft.cased_base_finetuned.extra_support_es': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_concat_craft_es_stivenlancheros',
               'xx.ner.biobert.craft.cased_base_finetuned.extra_support_es_en': 'bert_ner_biobert_base_cased_v1.2_finetuned_ner_craft_es_en_stivenlancheros',
               'xx.ner.distil_bert.cased_base_finetuned': 'distilbert_ner_base_multi_cased_finetuned_typo_detection',
               'xx.ner.high_resourced_lang': 'xlm_roberta_large_token_classifier_hrl',
               'xx.ner.masakhaner': 'xlm_roberta_large_token_classifier_masakhaner',
               'xx.ner.masakhaner.distilbert': 'distilbert_base_token_classifier_masakhaner',
               'xx.ner.masakhaner.xlm_roberta': 'xlm_roberta_large_token_classifier_masakhaner',
               'xx.ner.pos.cased_base': 'bert_pos_bert_base_dutch_cased_upos_alpino_frisian',
               'xx.ner.pos.xtreme.base': 'bert_pos_bert_base_ft_pos_xtreme',
               'xx.ner.roberta': 'roberta_ner_sroberta_ner',
               'xx.ner.roberta.base': 'roberta_ner_sroberta_base_ner',
               'xx.ner.roberta.clinical_bio_medical_craft.base_augmented_finetuned.extra_support_es_en': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_craft_augmentedtransfer_en',
               'xx.ner.roberta.clinical_bio_medical_craft.base_augmented_finetuned.extra_support_es_en.by_StivenLancheros': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_craft_augmented_en',
               'xx.ner.roberta.clinical_bio_medical_craft.base_finetuned.extra_support_es': 'roberta_ner_roberta_base_biomedical_clinical_es_finetuned_ner_craft',
               'xx.ner.roberta.l': 'roberta_ner_sroberta_l_ner',
               'xx.ner.roberta.xl': 'roberta_ner_sroberta_xl_ner',
               'xx.ner.scandinavian': 'bert_token_classifier_scandi_ner',
               'xx.ner.wikiner_glove_840B_300': 'ner_wikiner_glove_840B_300',
               'xx.ner.wikiner_xlm_roberta_base': 'ner_wikiner_xlm_roberta_base',
               'xx.ner.xlmr_roberta': 'xlmroberta_ner_extract_names',
               'xx.ner.xlmr_roberta.base': 'xlmroberta_ner_base_masakhan',
               'xx.ner.xlmr_roberta.base.by_davlan': 'xlmroberta_ner_base_sadilar',
               'xx.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_cj_mills_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned.by_cj_mills': 'xlmroberta_ner_cj_mills_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_danhsf': 'xlmroberta_ner_danhsf_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_jdang': 'xlmroberta_ner_jdang_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_k3nneth': 'xlmroberta_ner_k3nneth_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_leizhang': 'xlmroberta_ner_leizhang_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_moghis': 'xlmroberta_ner_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_olpa': 'xlmroberta_ner_olpa_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_osanseviero': 'xlmroberta_ner_osanseviero_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_transformersbook': 'xlmroberta_ner_transformersbook_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned.by_zdepablo': 'xlmroberta_ner_zpablo_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_dkasti': 'xlmroberta_ner_dkasti_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_edwardjross': 'xlmroberta_ner_edwardjross_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_flood': 'xlmroberta_ner_flood_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_haesun': 'xlmroberta_ner_haesun_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_iis2009002': 'xlmroberta_ner_iis2009002_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_jgriffi': 'xlmroberta_ner_jgriffi_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_lijingxin': 'xlmroberta_ner_lijingxin_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_neha2608': 'xlmroberta_ner_neha2608_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_robkayinto': 'xlmroberta_ner_robkayinto_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_skr3178': 'xlmroberta_ner_skr3178_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx.by_v3rx2000': 'xlmroberta_ner_v3rx2000_base_finetuned_panx',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_dkasti': 'xlmroberta_ner_dkasti_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_edwardjross': 'xlmroberta_ner_edwardjross_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_flood': 'xlmroberta_ner_flood_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_haesun': 'xlmroberta_ner_haesun_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_iis2009002': 'xlmroberta_ner_iis2009002_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_jgriffi': 'xlmroberta_ner_jgriffi_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_lijingxin': 'xlmroberta_ner_lijingxin_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_neha2608': 'xlmroberta_ner_neha2608_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_robkayinto': 'xlmroberta_ner_robkayinto_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_skr3178': 'xlmroberta_ner_skr3178_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.base_finetuned_panx_all.by_v3rx2000': 'xlmroberta_ner_v3rx2000_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.conll.large_finetuned': 'xlmroberta_ner_large_finetuned_conll03_english',
               'xx.ner.xlmr_roberta.lang': 'xlmroberta_ner_fullstop_punctuation_multilang_larg',
               'xx.ner.xlmr_roberta.lang.by_jplu': 'xlmroberta_ner_tf_r_40_lang',
               'xx.ner.xlmr_roberta.lang.by_nbroad': 'xlmroberta_ner_jplu_r_40_lang',
               'xx.ner.xlmr_roberta.multilingual': 'xlmroberta_ner_roberta_multilingual_medieval',
               'xx.ner.xlmr_roberta.wikiann.base_finetuned': 'xlmroberta_ner_transformersbook_base_finetuned_panx_all',
               'xx.ner.xlmr_roberta.wikineural.multilingual': 'xlmroberta_ner_skyr_wikineural_multilingual',
               'xx.ner.xtreme_glove_840B_300': 'ner_xtreme_glove_840B_300',
               'xx.ner.xtreme_xlm_roberta_xtreme_base': 'ner_xtreme_xlm_roberta_xtreme_base',
               'xx.ng.marian.translate_to.en': 'opus_mt_ng_en',
               'xx.nic.marian.translate_to.en': 'opus_mt_nic_en',
               'xx.niu.marian.translate_to.de': 'opus_mt_de_niu',
               'xx.niu.marian.translate_to.en': 'opus_mt_niu_en',
               'xx.niu.marian.translate_to.es': 'opus_mt_es_niu',
               'xx.niu.marian.translate_to.fi': 'opus_mt_fi_niu',
               'xx.niu.marian.translate_to.fr': 'opus_mt_fr_niu',
               'xx.niu.marian.translate_to.sv': 'opus_mt_sv_niu',
               'xx.nl.marian.translate_to.af': 'opus_mt_af_nl',
               'xx.nl.marian.translate_to.ca': 'opus_mt_ca_nl',
               'xx.nl.marian.translate_to.de': 'opus_mt_de_nl',
               'xx.nl.marian.translate_to.en': 'opus_mt_nl_en',
               'xx.nl.marian.translate_to.eo': 'opus_mt_eo_nl',
               'xx.nl.marian.translate_to.es': 'opus_mt_es_nl',
               'xx.nl.marian.translate_to.fi': 'opus_mt_fi_nl',
               'xx.nl.marian.translate_to.ja': 'opus_mt_ja_nl',
               'xx.nl.marian.translate_to.no': 'opus_mt_no_nl',
               'xx.nl.marian.translate_to.sv': 'opus_mt_sv_nl',
               'xx.nl.marian.translate_to.uk': 'opus_mt_uk_nl',
               'xx.nl.marian.translate_to.zh': 'opus_mt_zh_nl',
               'xx.no.marian.translate_to.da': 'opus_mt_da_no',
               'xx.no.marian.translate_to.de': 'opus_mt_de_no',
               'xx.no.marian.translate_to.es': 'opus_mt_es_no',
               'xx.no.marian.translate_to.fi': 'opus_mt_fi_no',
               'xx.no.marian.translate_to.fr': 'opus_mt_fr_no',
               'xx.no.marian.translate_to.nl': 'opus_mt_nl_no',
               'xx.no.marian.translate_to.no': 'opus_mt_no_no',
               'xx.no.marian.translate_to.pl': 'opus_mt_pl_no',
               'xx.no.marian.translate_to.ru': 'opus_mt_ru_no',
               'xx.no.marian.translate_to.sv': 'opus_mt_sv_no',
               'xx.no.marian.translate_to.uk': 'opus_mt_uk_no',
               'xx.nso.marian.translate_to.de': 'opus_mt_de_nso',
               'xx.nso.marian.translate_to.en': 'opus_mt_nso_en',
               'xx.nso.marian.translate_to.es': 'opus_mt_es_nso',
               'xx.nso.marian.translate_to.fi': 'opus_mt_fi_nso',
               'xx.nso.marian.translate_to.fr': 'opus_mt_fr_nso',
               'xx.nso.marian.translate_to.sv': 'opus_mt_sv_nso',
               'xx.ny.marian.translate_to.de': 'opus_mt_de_ny',
               'xx.ny.marian.translate_to.en': 'opus_mt_ny_en',
               'xx.ny.marian.translate_to.es': 'opus_mt_es_ny',
               'xx.ny.marian.translate_to.fi': 'opus_mt_fi_ny',
               'xx.ny.marian.translate_to.fr': 'opus_mt_fr_ny',
               'xx.ny.marian.translate_to.sv': 'opus_mt_sv_ny',
               'xx.nyk.marian.translate_to.en': 'opus_mt_nyk_en',
               'xx.om.marian.translate_to.en': 'opus_mt_om_en',
               'xx.pa.marian.translate_to.en': 'opus_mt_pa_en',
               'xx.pag.marian.translate_to.de': 'opus_mt_de_pag',
               'xx.pag.marian.translate_to.en': 'opus_mt_pag_en',
               'xx.pag.marian.translate_to.es': 'opus_mt_es_pag',
               'xx.pag.marian.translate_to.fi': 'opus_mt_fi_pag',
               'xx.pag.marian.translate_to.fr': 'opus_mt_fr_pag',
               'xx.pag.marian.translate_to.sv': 'opus_mt_sv_pag',
               'xx.pap.marian.translate_to.de': 'opus_mt_de_pap',
               'xx.pap.marian.translate_to.en': 'opus_mt_pap_en',
               'xx.pap.marian.translate_to.es': 'opus_mt_es_pap',
               'xx.pap.marian.translate_to.fi': 'opus_mt_fi_pap',
               'xx.pap.marian.translate_to.fr': 'opus_mt_fr_pap',
               'xx.pap.marian.translate_to.sv': 'opus_mt_sv_pap',
               'xx.phi.marian.translate_to.en': 'opus_mt_phi_en',
               'xx.pis.marian.translate_to.de': 'opus_mt_de_pis',
               'xx.pis.marian.translate_to.en': 'opus_mt_pis_en',
               'xx.pis.marian.translate_to.es': 'opus_mt_es_pis',
               'xx.pis.marian.translate_to.fi': 'opus_mt_fi_pis',
               'xx.pis.marian.translate_to.fr': 'opus_mt_fr_pis',
               'xx.pis.marian.translate_to.sv': 'opus_mt_sv_pis',
               'xx.pl.marian.translate_to.ar': 'opus_mt_ar_pl',
               'xx.pl.marian.translate_to.de': 'opus_mt_de_pl',
               'xx.pl.marian.translate_to.en': 'opus_mt_pl_en',
               'xx.pl.marian.translate_to.eo': 'opus_mt_eo_pl',
               'xx.pl.marian.translate_to.es': 'opus_mt_es_pl',
               'xx.pl.marian.translate_to.fr': 'opus_mt_fr_pl',
               'xx.pl.marian.translate_to.ja': 'opus_mt_ja_pl',
               'xx.pl.marian.translate_to.lt': 'opus_mt_lt_pl',
               'xx.pl.marian.translate_to.no': 'opus_mt_no_pl',
               'xx.pl.marian.translate_to.uk': 'opus_mt_uk_pl',
               'xx.pon.marian.translate_to.de': 'opus_mt_de_pon',
               'xx.pon.marian.translate_to.en': 'opus_mt_pon_en',
               'xx.pon.marian.translate_to.es': 'opus_mt_es_pon',
               'xx.pon.marian.translate_to.fi': 'opus_mt_fi_pon',
               'xx.pon.marian.translate_to.fr': 'opus_mt_fr_pon',
               'xx.pon.marian.translate_to.sv': 'opus_mt_sv_pon',
               'xx.pqe.marian.translate_to.en': 'opus_mt_pqe_en',
               'xx.prl.marian.translate_to.es': 'opus_mt_es_prl',
               'xx.pt.marian.translate_to.ca': 'opus_mt_ca_pt',
               'xx.pt.marian.translate_to.eo': 'opus_mt_eo_pt',
               'xx.pt.marian.translate_to.gl': 'opus_mt_gl_pt',
               'xx.pt.marian.translate_to.ja': 'opus_mt_ja_pt',
               'xx.pt.marian.translate_to.tl': 'opus_mt_tl_pt',
               'xx.pt.marian.translate_to.uk': 'opus_mt_uk_pt',
               'xx.rn.marian.translate_to.en': 'opus_mt_rn_en',
               'xx.rn.marian.translate_to.es': 'opus_mt_es_rn',
               'xx.rnd.marian.translate_to.en': 'opus_mt_rnd_en',
               'xx.rnd.marian.translate_to.fr': 'opus_mt_fr_rnd',
               'xx.rnd.marian.translate_to.sv': 'opus_mt_sv_rnd',
               'xx.ro.marian.translate_to.eo': 'opus_mt_eo_ro',
               'xx.ro.marian.translate_to.es': 'opus_mt_es_ro',
               'xx.ro.marian.translate_to.fi': 'opus_mt_fi_ro',
               'xx.ro.marian.translate_to.fr': 'opus_mt_fr_ro',
               'xx.ro.marian.translate_to.sv': 'opus_mt_sv_ro',
               'xx.roa.marian.translate_to.en': 'opus_mt_roa_en',
               'xx.ru.marian.translate_to.af': 'opus_mt_af_ru',
               'xx.ru.marian.translate_to.ar': 'opus_mt_ar_ru',
               'xx.ru.marian.translate_to.bg': 'opus_mt_bg_ru',
               'xx.ru.marian.translate_to.da': 'opus_mt_da_ru',
               'xx.ru.marian.translate_to.en': 'opus_mt_ru_en',
               'xx.ru.marian.translate_to.eo': 'opus_mt_eo_ru',
               'xx.ru.marian.translate_to.es': 'opus_mt_es_ru',
               'xx.ru.marian.translate_to.et': 'opus_mt_et_ru',
               'xx.ru.marian.translate_to.eu': 'opus_mt_eu_ru',
               'xx.ru.marian.translate_to.fi': 'opus_mt_fi_ru',
               'xx.ru.marian.translate_to.fr': 'opus_mt_fr_ru',
               'xx.ru.marian.translate_to.he': 'opus_mt_he_ru',
               'xx.ru.marian.translate_to.hy': 'opus_mt_hy_ru',
               'xx.ru.marian.translate_to.ja': 'opus_mt_ja_ru',
               'xx.ru.marian.translate_to.ka': 'opus_mt_ka_ru',
               'xx.ru.marian.translate_to.ko': 'opus_mt_ko_ru',
               'xx.ru.marian.translate_to.lt': 'opus_mt_lt_ru',
               'xx.ru.marian.translate_to.lv': 'opus_mt_lv_ru',
               'xx.ru.marian.translate_to.no': 'opus_mt_no_ru',
               'xx.ru.marian.translate_to.rn': 'opus_mt_rn_ru',
               'xx.ru.marian.translate_to.sl': 'opus_mt_sl_ru',
               'xx.ru.marian.translate_to.sv': 'opus_mt_sv_ru',
               'xx.ru.marian.translate_to.uk': 'opus_mt_uk_ru',
               'xx.ru.marian.translate_to.vi': 'opus_mt_vi_ru',
               'xx.run.marian.translate_to.en': 'opus_mt_run_en',
               'xx.run.marian.translate_to.fi': 'opus_mt_fi_run',
               'xx.run.marian.translate_to.fr': 'opus_mt_fr_run',
               'xx.run.marian.translate_to.sv': 'opus_mt_sv_run',
               'xx.rw.marian.translate_to.en': 'opus_mt_rw_en',
               'xx.rw.marian.translate_to.es': 'opus_mt_es_rw',
               'xx.rw.marian.translate_to.fi': 'opus_mt_fi_rw',
               'xx.rw.marian.translate_to.fr': 'opus_mt_fr_rw',
               'xx.rw.marian.translate_to.sv': 'opus_mt_sv_rw',
               'xx.sal.marian.translate_to.en': 'opus_mt_sal_en',
               'xx.sem.marian.translate_to.en': 'opus_mt_sem_en',
               'xx.sem.marian.translate_to.sem': 'opus_mt_sem_sem',
               'xx.sentence_detector': 'sentence_detector_dl',
               'xx.sg.marian.translate_to.en': 'opus_mt_sg_en',
               'xx.sg.marian.translate_to.es': 'opus_mt_es_sg',
               'xx.sg.marian.translate_to.fi': 'opus_mt_fi_sg',
               'xx.sg.marian.translate_to.fr': 'opus_mt_fr_sg',
               'xx.sg.marian.translate_to.sv': 'opus_mt_sv_sg',
               'xx.sh.marian.translate_to.eo': 'opus_mt_eo_sh',
               'xx.sh.marian.translate_to.ja': 'opus_mt_ja_sh',
               'xx.sh.marian.translate_to.uk': 'opus_mt_uk_sh',
               'xx.sk.marian.translate_to.en': 'opus_mt_sk_en',
               'xx.sk.marian.translate_to.fi': 'opus_mt_fi_sk',
               'xx.sk.marian.translate_to.fr': 'opus_mt_fr_sk',
               'xx.sk.marian.translate_to.sv': 'opus_mt_sv_sk',
               'xx.sl.marian.translate_to.es': 'opus_mt_es_sl',
               'xx.sl.marian.translate_to.fi': 'opus_mt_fi_sl',
               'xx.sl.marian.translate_to.fr': 'opus_mt_fr_sl',
               'xx.sl.marian.translate_to.ru': 'opus_mt_ru_sl',
               'xx.sl.marian.translate_to.sv': 'opus_mt_sv_sl',
               'xx.sl.marian.translate_to.uk': 'opus_mt_uk_sl',
               'xx.sla.marian.translate_to.en': 'opus_mt_sla_en',
               'xx.sla.marian.translate_to.sla': 'opus_mt_sla_sla',
               'xx.sm.marian.translate_to.en': 'opus_mt_sm_en',
               'xx.sm.marian.translate_to.es': 'opus_mt_es_sm',
               'xx.sm.marian.translate_to.fi': 'opus_mt_fi_sm',
               'xx.sm.marian.translate_to.fr': 'opus_mt_fr_sm',
               'xx.sm.marian.translate_to.sv': 'opus_mt_sv_sm',
               'xx.sn.marian.translate_to.en': 'opus_mt_sn_en',
               'xx.sn.marian.translate_to.es': 'opus_mt_es_sn',
               'xx.sn.marian.translate_to.fi': 'opus_mt_fi_sn',
               'xx.sn.marian.translate_to.fr': 'opus_mt_fr_sn',
               'xx.sn.marian.translate_to.sv': 'opus_mt_sv_sn',
               'xx.sq.marian.translate_to.en': 'opus_mt_sq_en',
               'xx.sq.marian.translate_to.fi': 'opus_mt_fi_sq',
               'xx.sq.marian.translate_to.sv': 'opus_mt_sv_sq',
               'xx.srn.marian.translate_to.en': 'opus_mt_srn_en',
               'xx.srn.marian.translate_to.es': 'opus_mt_es_srn',
               'xx.srn.marian.translate_to.fi': 'opus_mt_fi_srn',
               'xx.srn.marian.translate_to.fr': 'opus_mt_fr_srn',
               'xx.srn.marian.translate_to.sv': 'opus_mt_sv_srn',
               'xx.ss.marian.translate_to.en': 'opus_mt_ss_en',
               'xx.st.marian.translate_to.en': 'opus_mt_st_en',
               'xx.st.marian.translate_to.es': 'opus_mt_es_st',
               'xx.st.marian.translate_to.fi': 'opus_mt_fi_st',
               'xx.st.marian.translate_to.fr': 'opus_mt_fr_st',
               'xx.st.marian.translate_to.sv': 'opus_mt_sv_st',
               'xx.sv.marian.translate_to.af': 'opus_mt_af_sv',
               'xx.sv.marian.translate_to.am': 'opus_mt_am_sv',
               'xx.sv.marian.translate_to.ase': 'opus_mt_ase_sv',
               'xx.sv.marian.translate_to.bcl': 'opus_mt_bcl_sv',
               'xx.sv.marian.translate_to.bem': 'opus_mt_bem_sv',
               'xx.sv.marian.translate_to.bg': 'opus_mt_bg_sv',
               'xx.sv.marian.translate_to.bi': 'opus_mt_bi_sv',
               'xx.sv.marian.translate_to.bzs': 'opus_mt_bzs_sv',
               'xx.sv.marian.translate_to.ceb': 'opus_mt_ceb_sv',
               'xx.sv.marian.translate_to.chk': 'opus_mt_chk_sv',
               'xx.sv.marian.translate_to.crs': 'opus_mt_crs_sv',
               'xx.sv.marian.translate_to.ee': 'opus_mt_ee_sv',
               'xx.sv.marian.translate_to.efi': 'opus_mt_efi_sv',
               'xx.sv.marian.translate_to.el': 'opus_mt_el_sv',
               'xx.sv.marian.translate_to.en': 'opus_mt_sv_en',
               'xx.sv.marian.translate_to.eo': 'opus_mt_eo_sv',
               'xx.sv.marian.translate_to.et': 'opus_mt_et_sv',
               'xx.sv.marian.translate_to.fi': 'opus_mt_fi_sv',
               'xx.sv.marian.translate_to.fr': 'opus_mt_fr_sv',
               'xx.sv.marian.translate_to.gaa': 'opus_mt_gaa_sv',
               'xx.sv.marian.translate_to.gil': 'opus_mt_gil_sv',
               'xx.sv.marian.translate_to.guw': 'opus_mt_guw_sv',
               'xx.sv.marian.translate_to.ha': 'opus_mt_ha_sv',
               'xx.sv.marian.translate_to.he': 'opus_mt_he_sv',
               'xx.sv.marian.translate_to.hr': 'opus_mt_hr_sv',
               'xx.sv.marian.translate_to.ht': 'opus_mt_ht_sv',
               'xx.sv.marian.translate_to.hu': 'opus_mt_hu_sv',
               'xx.sv.marian.translate_to.id': 'opus_mt_id_sv',
               'xx.sv.marian.translate_to.ig': 'opus_mt_ig_sv',
               'xx.sv.marian.translate_to.ilo': 'opus_mt_ilo_sv',
               'xx.sv.marian.translate_to.is': 'opus_mt_is_sv',
               'xx.sv.marian.translate_to.iso': 'opus_mt_iso_sv',
               'xx.sv.marian.translate_to.it': 'opus_mt_it_sv',
               'xx.sv.marian.translate_to.ja': 'opus_mt_ja_sv',
               'xx.sv.marian.translate_to.kg': 'opus_mt_kg_sv',
               'xx.sv.marian.translate_to.ko': 'opus_mt_ko_sv',
               'xx.sv.marian.translate_to.kqn': 'opus_mt_kqn_sv',
               'xx.sv.marian.translate_to.kwy': 'opus_mt_kwy_sv',
               'xx.sv.marian.translate_to.lg': 'opus_mt_lg_sv',
               'xx.sv.marian.translate_to.loz': 'opus_mt_loz_sv',
               'xx.sv.marian.translate_to.lt': 'opus_mt_lt_sv',
               'xx.sv.marian.translate_to.lu': 'opus_mt_lu_sv',
               'xx.sv.marian.translate_to.lua': 'opus_mt_lua_sv',
               'xx.sv.marian.translate_to.lue': 'opus_mt_lue_sv',
               'xx.sv.marian.translate_to.lus': 'opus_mt_lus_sv',
               'xx.sv.marian.translate_to.lv': 'opus_mt_lv_sv',
               'xx.sv.marian.translate_to.mt': 'opus_mt_mt_sv',
               'xx.sv.marian.translate_to.niu': 'opus_mt_niu_sv',
               'xx.sv.marian.translate_to.nl': 'opus_mt_nl_sv',
               'xx.sv.marian.translate_to.no': 'opus_mt_no_sv',
               'xx.sv.marian.translate_to.nso': 'opus_mt_nso_sv',
               'xx.sv.marian.translate_to.pag': 'opus_mt_pag_sv',
               'xx.sv.marian.translate_to.pis': 'opus_mt_pis_sv',
               'xx.sv.marian.translate_to.pl': 'opus_mt_pl_sv',
               'xx.sv.marian.translate_to.pon': 'opus_mt_pon_sv',
               'xx.sv.marian.translate_to.rnd': 'opus_mt_rnd_sv',
               'xx.sv.marian.translate_to.ro': 'opus_mt_ro_sv',
               'xx.sv.marian.translate_to.ru': 'opus_mt_ru_sv',
               'xx.sv.marian.translate_to.run': 'opus_mt_run_sv',
               'xx.sv.marian.translate_to.rw': 'opus_mt_rw_sv',
               'xx.sv.marian.translate_to.sg': 'opus_mt_sg_sv',
               'xx.sv.marian.translate_to.sk': 'opus_mt_sk_sv',
               'xx.sv.marian.translate_to.sl': 'opus_mt_sl_sv',
               'xx.sv.marian.translate_to.sn': 'opus_mt_sn_sv',
               'xx.sv.marian.translate_to.sq': 'opus_mt_sq_sv',
               'xx.sv.marian.translate_to.srn': 'opus_mt_srn_sv',
               'xx.sv.marian.translate_to.st': 'opus_mt_st_sv',
               'xx.sv.marian.translate_to.sv': 'opus_mt_sv_sv',
               'xx.sv.marian.translate_to.swc': 'opus_mt_swc_sv',
               'xx.sv.marian.translate_to.tiv': 'opus_mt_tiv_sv',
               'xx.sv.marian.translate_to.tll': 'opus_mt_tll_sv',
               'xx.sv.marian.translate_to.tn': 'opus_mt_tn_sv',
               'xx.sv.marian.translate_to.to': 'opus_mt_to_sv',
               'xx.sv.marian.translate_to.toi': 'opus_mt_toi_sv',
               'xx.sv.marian.translate_to.tpi': 'opus_mt_tpi_sv',
               'xx.sv.marian.translate_to.tr': 'opus_mt_tr_sv',
               'xx.sv.marian.translate_to.ts': 'opus_mt_ts_sv',
               'xx.sv.marian.translate_to.tum': 'opus_mt_tum_sv',
               'xx.sv.marian.translate_to.tvl': 'opus_mt_tvl_sv',
               'xx.sv.marian.translate_to.tw': 'opus_mt_tw_sv',
               'xx.sv.marian.translate_to.ty': 'opus_mt_ty_sv',
               'xx.sv.marian.translate_to.uk': 'opus_mt_uk_sv',
               'xx.sv.marian.translate_to.war': 'opus_mt_war_sv',
               'xx.sv.marian.translate_to.wls': 'opus_mt_wls_sv',
               'xx.sv.marian.translate_to.xh': 'opus_mt_xh_sv',
               'xx.sv.marian.translate_to.yap': 'opus_mt_yap_sv',
               'xx.sv.marian.translate_to.yo': 'opus_mt_yo_sv',
               'xx.sv.marian.translate_to.zh': 'opus_mt_zh_sv',
               'xx.sv.marian.translate_to.zne': 'opus_mt_zne_sv',
               'xx.sw.marian.translate_to.fi': 'opus_mt_fi_sw',
               'xx.swc.marian.translate_to.en': 'opus_mt_swc_en',
               'xx.swc.marian.translate_to.es': 'opus_mt_es_swc',
               'xx.swc.marian.translate_to.fi': 'opus_mt_fi_swc',
               'xx.swc.marian.translate_to.fr': 'opus_mt_fr_swc',
               'xx.swc.marian.translate_to.sv': 'opus_mt_sv_swc',
               'xx.taw.marian.translate_to.en': 'opus_mt_taw_en',
               'xx.th.marian.translate_to.en': 'opus_mt_th_en',
               'xx.th.marian.translate_to.sv': 'opus_mt_sv_th',
               'xx.ti.marian.translate_to.en': 'opus_mt_ti_en',
               'xx.tiv.marian.translate_to.en': 'opus_mt_tiv_en',
               'xx.tiv.marian.translate_to.fi': 'opus_mt_fi_tiv',
               'xx.tiv.marian.translate_to.fr': 'opus_mt_fr_tiv',
               'xx.tiv.marian.translate_to.sv': 'opus_mt_sv_tiv',
               'xx.tl.marian.translate_to.de': 'opus_mt_de_tl',
               'xx.tl.marian.translate_to.en': 'opus_mt_tl_en',
               'xx.tl.marian.translate_to.es': 'opus_mt_es_tl',
               'xx.tl.marian.translate_to.fr': 'opus_mt_fr_tl',
               'xx.tl.marian.translate_to.pt': 'opus_mt_pt_tl',
               'xx.tll.marian.translate_to.en': 'opus_mt_tll_en',
               'xx.tll.marian.translate_to.es': 'opus_mt_es_tll',
               'xx.tll.marian.translate_to.fi': 'opus_mt_fi_tll',
               'xx.tll.marian.translate_to.fr': 'opus_mt_fr_tll',
               'xx.tll.marian.translate_to.sv': 'opus_mt_sv_tll',
               'xx.tn.marian.translate_to.en': 'opus_mt_tn_en',
               'xx.tn.marian.translate_to.es': 'opus_mt_es_tn',
               'xx.tn.marian.translate_to.fi': 'opus_mt_fi_tn',
               'xx.tn.marian.translate_to.fr': 'opus_mt_fr_tn',
               'xx.tn.marian.translate_to.sv': 'opus_mt_sv_tn',
               'xx.to.marian.translate_to.en': 'opus_mt_to_en',
               'xx.to.marian.translate_to.es': 'opus_mt_es_to',
               'xx.to.marian.translate_to.fi': 'opus_mt_fi_to',
               'xx.to.marian.translate_to.fr': 'opus_mt_fr_to',
               'xx.to.marian.translate_to.sv': 'opus_mt_sv_to',
               'xx.toi.marian.translate_to.en': 'opus_mt_toi_en',
               'xx.toi.marian.translate_to.fi': 'opus_mt_fi_toi',
               'xx.toi.marian.translate_to.sv': 'opus_mt_sv_toi',
               'xx.tpi.marian.translate_to.en': 'opus_mt_tpi_en',
               'xx.tpi.marian.translate_to.es': 'opus_mt_es_tpi',
               'xx.tpi.marian.translate_to.fi': 'opus_mt_fi_tpi',
               'xx.tpi.marian.translate_to.fr': 'opus_mt_fr_tpi',
               'xx.tpi.marian.translate_to.sv': 'opus_mt_sv_tpi',
               'xx.tr.marian.translate_to.ar': 'opus_mt_ar_tr',
               'xx.tr.marian.translate_to.az': 'opus_mt_az_tr',
               'xx.tr.marian.translate_to.bg': 'opus_mt_bg_tr',
               'xx.tr.marian.translate_to.en': 'opus_mt_tr_en',
               'xx.tr.marian.translate_to.fi': 'opus_mt_fi_tr',
               'xx.tr.marian.translate_to.ja': 'opus_mt_ja_tr',
               'xx.tr.marian.translate_to.lt': 'opus_mt_lt_tr',
               'xx.tr.marian.translate_to.uk': 'opus_mt_uk_tr',
               'xx.trk.marian.translate_to.en': 'opus_mt_trk_en',
               'xx.ts.marian.translate_to.en': 'opus_mt_ts_en',
               'xx.ts.marian.translate_to.fi': 'opus_mt_fi_ts',
               'xx.ts.marian.translate_to.fr': 'opus_mt_fr_ts',
               'xx.ts.marian.translate_to.sv': 'opus_mt_sv_ts',
               'xx.tum.marian.translate_to.en': 'opus_mt_tum_en',
               'xx.tum.marian.translate_to.fr': 'opus_mt_fr_tum',
               'xx.tum.marian.translate_to.sv': 'opus_mt_sv_tum',
               'xx.tvl.marian.translate_to.en': 'opus_mt_tvl_en',
               'xx.tvl.marian.translate_to.es': 'opus_mt_es_tvl',
               'xx.tvl.marian.translate_to.fi': 'opus_mt_fi_tvl',
               'xx.tvl.marian.translate_to.fr': 'opus_mt_fr_tvl',
               'xx.tvl.marian.translate_to.sv': 'opus_mt_sv_tvl',
               'xx.tw.marian.translate_to.es': 'opus_mt_es_tw',
               'xx.tw.marian.translate_to.fi': 'opus_mt_fi_tw',
               'xx.tw.marian.translate_to.fr': 'opus_mt_fr_tw',
               'xx.tw.marian.translate_to.sv': 'opus_mt_sv_tw',
               'xx.ty.marian.translate_to.es': 'opus_mt_es_ty',
               'xx.ty.marian.translate_to.fi': 'opus_mt_fi_ty',
               'xx.ty.marian.translate_to.fr': 'opus_mt_fr_ty',
               'xx.ty.marian.translate_to.sv': 'opus_mt_sv_ty',
               'xx.tzo.marian.translate_to.es': 'opus_mt_es_tzo',
               'xx.uk.marian.translate_to.bg': 'opus_mt_bg_uk',
               'xx.uk.marian.translate_to.ca': 'opus_mt_ca_uk',
               'xx.uk.marian.translate_to.cs': 'opus_mt_cs_uk',
               'xx.uk.marian.translate_to.de': 'opus_mt_de_uk',
               'xx.uk.marian.translate_to.en': 'opus_mt_uk_en',
               'xx.uk.marian.translate_to.es': 'opus_mt_es_uk',
               'xx.uk.marian.translate_to.fi': 'opus_mt_fi_uk',
               'xx.uk.marian.translate_to.fr': 'opus_mt_fr_uk',
               'xx.uk.marian.translate_to.he': 'opus_mt_he_uk',
               'xx.uk.marian.translate_to.hu': 'opus_mt_hu_uk',
               'xx.uk.marian.translate_to.it': 'opus_mt_it_uk',
               'xx.uk.marian.translate_to.nl': 'opus_mt_nl_uk',
               'xx.uk.marian.translate_to.no': 'opus_mt_no_uk',
               'xx.uk.marian.translate_to.pl': 'opus_mt_pl_uk',
               'xx.uk.marian.translate_to.pt': 'opus_mt_pt_uk',
               'xx.uk.marian.translate_to.ru': 'opus_mt_ru_uk',
               'xx.uk.marian.translate_to.sh': 'opus_mt_sh_uk',
               'xx.uk.marian.translate_to.sl': 'opus_mt_sl_uk',
               'xx.uk.marian.translate_to.sv': 'opus_mt_sv_uk',
               'xx.uk.marian.translate_to.tr': 'opus_mt_tr_uk',
               'xx.uk.marian.translate_to.zh': 'opus_mt_zh_uk',
               'xx.umb.marian.translate_to.en': 'opus_mt_umb_en',
               'xx.umb.marian.translate_to.sv': 'opus_mt_sv_umb',
               'xx.ur.marian.translate_to.en': 'opus_mt_ur_en',
               'xx.ur.marian.translate_to.hi': 'opus_mt_hi_ur',
               'xx.urj.marian.translate_to.en': 'opus_mt_urj_en',
               'xx.urj.marian.translate_to.urj': 'opus_mt_urj_urj',
               'xx.use.multi': 'tfhub_use_multi',
               'xx.use.multi_lg': 'tfhub_use_multi_lg',
               'xx.ve.marian.translate_to.en': 'opus_mt_ve_en',
               'xx.ve.marian.translate_to.es': 'opus_mt_es_ve',
               'xx.ve.marian.translate_to.fi': 'opus_mt_fi_ve',
               'xx.ve.marian.translate_to.fr': 'opus_mt_fr_ve',
               'xx.ve.marian.translate_to.sv': 'opus_mt_sv_ve',
               'xx.vi.marian.translate_to.de': 'opus_mt_de_vi',
               'xx.vi.marian.translate_to.en': 'opus_mt_vi_en',
               'xx.vi.marian.translate_to.es': 'opus_mt_es_vi',
               'xx.vi.marian.translate_to.fr': 'opus_mt_fr_vi',
               'xx.vi.marian.translate_to.it': 'opus_mt_it_vi',
               'xx.vi.marian.translate_to.ja': 'opus_mt_ja_vi',
               'xx.vi.marian.translate_to.ru': 'opus_mt_ru_vi',
               'xx.vi.marian.translate_to.zh': 'opus_mt_zh_vi',
               'xx.wa.marian.translate_to.en': 'opus_mt_wa_en',
               'xx.wal.marian.translate_to.en': 'opus_mt_wal_en',
               'xx.war.marian.translate_to.en': 'opus_mt_war_en',
               'xx.war.marian.translate_to.es': 'opus_mt_es_war',
               'xx.war.marian.translate_to.fi': 'opus_mt_fi_war',
               'xx.war.marian.translate_to.fr': 'opus_mt_fr_war',
               'xx.war.marian.translate_to.sv': 'opus_mt_sv_war',
               'xx.wls.marian.translate_to.en': 'opus_mt_wls_en',
               'xx.wls.marian.translate_to.es': 'opus_mt_es_wls',
               'xx.wls.marian.translate_to.fi': 'opus_mt_fi_wls',
               'xx.wls.marian.translate_to.fr': 'opus_mt_fr_wls',
               'xx.wls.marian.translate_to.sv': 'opus_mt_sv_wls',
               'xx.xh.marian.translate_to.en': 'opus_mt_xh_en',
               'xx.xh.marian.translate_to.es': 'opus_mt_es_xh',
               'xx.xh.marian.translate_to.fi': 'opus_mt_fi_xh',
               'xx.xh.marian.translate_to.fr': 'opus_mt_fr_xh',
               'xx.xh.marian.translate_to.sv': 'opus_mt_sv_xh',
               'xx.yap.marian.translate_to.en': 'opus_mt_yap_en',
               'xx.yap.marian.translate_to.fi': 'opus_mt_fi_yap',
               'xx.yap.marian.translate_to.fr': 'opus_mt_fr_yap',
               'xx.yap.marian.translate_to.sv': 'opus_mt_sv_yap',
               'xx.yo.marian.translate_to.en': 'opus_mt_yo_en',
               'xx.yo.marian.translate_to.es': 'opus_mt_es_yo',
               'xx.yo.marian.translate_to.fi': 'opus_mt_fi_yo',
               'xx.yo.marian.translate_to.fr': 'opus_mt_fr_yo',
               'xx.yo.marian.translate_to.sv': 'opus_mt_sv_yo',
               'xx.yua.marian.translate_to.es': 'opus_mt_es_yua',
               'xx.zai.marian.translate_to.es': 'opus_mt_es_zai',
               'xx.zh.marian.translate_to.en': 'opus_mt_zh_en',
               'xx.zle.marian.translate_to.en': 'opus_mt_zle_en',
               'xx.zle.marian.translate_to.zle': 'opus_mt_zle_zle',
               'xx.zls.marian.translate_to.en': 'opus_mt_zls_en',
               'xx.zls.marian.translate_to.zls': 'opus_mt_zls_zls',
               'xx.zlw.marian.translate_to.en': 'opus_mt_zlw_en',
               'xx.zlw.marian.translate_to.zlw': 'opus_mt_zlw_zlw',
               'xx.zne.marian.translate_to.fi': 'opus_mt_fi_zne',
               'xx.zne.marian.translate_to.fr': 'opus_mt_fr_zne',
               'xx.zne.marian.translate_to.sv': 'opus_mt_sv_zne'},
        'yi': {'yi.detect_sentence': 'sentence_detector_dl',
               'yi.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'yo': {
            'yo.embed.bert.cased_multilingual_base_finetuned': 'bert_embeddings_base_multilingual_cased_finetuned_yoruba',
            'yo.embed.w2v_cc_300d': 'w2v_cc_300d',
            'yo.embed.xlm_roberta': 'xlm_roberta_base_finetuned_yoruba',
            'yo.embed_sentence.xlm_roberta': 'sent_xlm_roberta_base_finetuned_yoruba',
            'yo.lemma': 'lemma',
            'yo.ner.xlmr_roberta.base_finetuned': 'xlmroberta_ner_xlm_roberta_base_finetuned_ner_yoruba',
            'yo.ner.xlmr_roberta.base_finetuned_swahili.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_swahili_finetuned_ner_yoruba',
            'yo.ner.xlmr_roberta.base_finetuned_yoruba.by_mbeukman': 'xlmroberta_ner_xlm_roberta_base_finetuned_yoruba_finetuned_ner_yoruba',
            'yo.pos': 'pos_ud_ytb',
            'yo.stopwords': 'stopwords_yo'},
        'yue': {
            'yue.speech2text.wav2vec_xlsr.v2_large': 'asr_wav2vec2_large_xlsr_cantonese_by_ctl',
            'yue.speech2text.wav2vec_xlsr.v2_large_gpu': 'asr_wav2vec2_large_xlsr_cantonese_by_ctl_gpu'},
        'zea': {'zea.embed.w2v_cc_300d': 'w2v_cc_300d'},
        'zh': {'zh.answer_question.bert': 'bert_qa_question_answering_chinese',
               'zh.answer_question.bert.base': 'bert_qa_chinese_pert_base_mrc',
               'zh.answer_question.bert.base.by_hfl': 'bert_qa_chinese_pert_base_mrc',
               'zh.answer_question.bert.base.by_jackh1995': 'bert_qa_roberta_base_chinese_extractive_qa_scratch',
               'zh.answer_question.bert.base.by_liam168': 'bert_qa_qa_roberta_base_chinese_extractive',
               'zh.answer_question.bert.base.by_uer': 'bert_qa_roberta_base_chinese_extractive_qa',
               'zh.answer_question.bert.base_extractive': 'bert_qa_roberta_base_chinese_extractive',
               'zh.answer_question.bert.by_jackh1995': 'bert_qa_bert_chinese_finetuned',
               'zh.answer_question.bert.by_yechen': 'bert_qa_question_answering_chinese',
               'zh.answer_question.bert.cased_multilingual_base': 'bert_qa_multilingual_base_cased_chines',
               'zh.answer_question.bert.large': 'bert_qa_chinese_pert_large_open_domain_mrc',
               'zh.answer_question.bert.large.by_hfl': 'bert_qa_chinese_pert_large_mrc',
               'zh.answer_question.bert.large.by_luhua': 'bert_qa_chinese_pretrain_mrc_roberta_wwm_ext_large',
               'zh.answer_question.bert.large.by_qalover': 'bert_qa_chinese_pert_large_open_domain_mrc',
               'zh.answer_question.bert.multilingual_base_cased': 'bert_qa_multilingual_bert_base_cased_chinese',
               'zh.answer_question.bert_voidful': 'bert_qa_question_answering_zh_voidful',
               'zh.answer_question.mac_bert.large': 'bert_qa_chinese_pretrain_mrc_macbert_large',
               'zh.answer_question.squad.bert.base': 'bert_qa_bert_base_chinese_finetuned_squad_colab',
               'zh.answer_question.xlm_roberta.base': 'xlm_roberta_qa_xlm_roberta_base_chinese',
               'zh.classify.bert': 'bert_classifier_autonlp_abbb_622117836',
               'zh.classify.bert.base_finetuned': 'bert_classifier_c2_roberta_base_finetuned_dianping_chinese',
               'zh.classify.bert.base_finetuned_dianping_chinese.by_uer': 'bert_classifier_roberta_base_finetuned_dianping_chinese',
               'zh.classify.bert.base_finetuned_ifeng_chinese.by_uer': 'bert_classifier_roberta_base_finetuned_ifeng_chinese',
               'zh.classify.bert.base_finetuned_jd_binary_chinese.by_uer': 'bert_classifier_roberta_base_finetuned_jd_binary_chinese',
               'zh.classify.bert.base_finetuned_jd_full_chinese.by_uer': 'bert_classifier_roberta_base_finetuned_jd_full_chinese',
               'zh.classify.bert.by_lgodwangl': 'bert_classifier_sent_chineses',
               'zh.classify.bert.cat333_624217911.by_kyleinincubated': 'bert_classifier_autonlp_cat333_624217911',
               'zh.classify.bert.cat33_624317932.by_kyleinincubated': 'bert_classifier_autonlp_cat33_624317932',
               'zh.classify.bert.cls.by_celtics1863': 'bert_classifier_env_cls_chinese',
               'zh.classify.bert.finetuned': 'bert_classifier_finetuned_semantic_chinese',
               'zh.classify.bert.lang_110m': 'bert_classifier_erlangshen_roberta_110m_nli',
               'zh.classify.bert.lang_110m.by_idea_ccnl': 'bert_classifier_idea_ccnl_erlangshen_roberta_110m_similarity',
               'zh.classify.bert.lang_110m.by_swtx': 'bert_classifier_swtx_erlangshen_roberta_110m_similarity',
               'zh.classify.bert.lang_330m': 'bert_classifier_erlangshen_roberta_330m_nli',
               'zh.classify.bert.lang_330m.by_idea_ccnl': 'bert_classifier_erlangshen_roberta_330m_similarity',
               'zh.classify.bert.maysix.by_east': 'bert_classifier_autotrain_maysix_828926405',
               'zh.classify.bert.news.base_finetuned': 'bert_classifier_roberta_base_finetuned_chinanews_chinese',
               'zh.classify.bert.rule.by_east': 'bert_classifier_autotrain_rule_793324440',
               'zh.classify.bert.sentiment.': 'bert_classifier_chinese_sentiment',
               'zh.classify.bert.sentiment.lang': 'bert_classifier_erlangshen_sentiment_finetune',
               'zh.classify.bert.sentiment.lang_110m': 'bert_classifier_erlangshen_roberta_110m_sentiment',
               'zh.classify.bert.sentiment.lang_330m': 'bert_classifier_erlangshen_roberta_330m_sentiment',
               'zh.classify.bert.topic.by_celtics1863': 'bert_classifier_env_topic',
               'zh.classify.distil_bert.uncased_base': 'distilbert_sequence_classifier_c4_zh_distilbert_base_uncased',
               'zh.classify.genre.bert.by_herais': 'bert_classifier_pred_genre',
               'zh.classify.timeperiod.bert.by_herais': 'bert_classifier_pred_timeperiod',
               'zh.embed': 'bert_base_chinese',
               'zh.embed.bert': 'bert_base_chinese',
               'zh.embed.bert.10l_128d_128d': 'bert_embeddings_chinese_roberta_l_10_h_128',
               'zh.embed.bert.10l_256d_256d': 'bert_embeddings_chinese_roberta_l_10_h_256',
               'zh.embed.bert.10l_512d_512d': 'bert_embeddings_chinese_roberta_l_10_h_512',
               'zh.embed.bert.10l_768d_768d': 'bert_embeddings_chinese_roberta_l_10_h_768',
               'zh.embed.bert.12l_128d_128d': 'bert_embeddings_chinese_roberta_l_12_h_128',
               'zh.embed.bert.12l_256d_256d': 'bert_embeddings_chinese_roberta_l_12_h_256',
               'zh.embed.bert.12l_512d_512d': 'bert_embeddings_chinese_roberta_l_12_h_512',
               'zh.embed.bert.12l_768d_768d': 'bert_embeddings_chinese_roberta_l_12_h_768',
               'zh.embed.bert.2l_128d_128d': 'bert_embeddings_chinese_roberta_l_2_h_128',
               'zh.embed.bert.2l_256d_256d': 'bert_embeddings_chinese_roberta_l_2_h_256',
               'zh.embed.bert.2l_512d_512d': 'bert_embeddings_chinese_roberta_l_2_h_512',
               'zh.embed.bert.2l_768d_768d': 'bert_embeddings_chinese_roberta_l_2_h_768',
               'zh.embed.bert.4l_128d_128d': 'bert_embeddings_chinese_roberta_l_4_h_128',
               'zh.embed.bert.4l_256d_256d': 'bert_embeddings_chinese_roberta_l_4_h_256',
               'zh.embed.bert.4l_512d_512d': 'bert_embeddings_chinese_roberta_l_4_h_512',
               'zh.embed.bert.4l_768d_768d': 'bert_embeddings_chinese_roberta_l_4_h_768',
               'zh.embed.bert.6l_128d_128d': 'bert_embeddings_chinese_roberta_l_6_h_128',
               'zh.embed.bert.6l_256d_256d': 'bert_embeddings_chinese_roberta_l_6_h_256',
               'zh.embed.bert.6l_512d_512d': 'bert_embeddings_chinese_roberta_l_6_h_512',
               'zh.embed.bert.6l_768d_768d': 'bert_embeddings_chinese_roberta_l_6_h_768',
               'zh.embed.bert.8l_128d_128d': 'bert_embeddings_chinese_roberta_l_8_h_128',
               'zh.embed.bert.8l_256d_256d': 'bert_embeddings_chinese_roberta_l_8_h_256',
               'zh.embed.bert.8l_512d_512d': 'bert_embeddings_chinese_roberta_l_8_h_512',
               'zh.embed.bert.8l_768d_768d': 'bert_embeddings_chinese_roberta_l_8_h_768',
               'zh.embed.bert.base': 'bert_embeddings_base_chinese',
               'zh.embed.bert.base.by_model_attribution_challenge': 'bert_embeddings_model_attribution_challenge_base_chinese',
               'zh.embed.bert.base.by_ptrsxu': 'bert_embeddings_ptrsxu_base_chinese',
               'zh.embed.bert.by_ptrsxu': 'bert_embeddings_ptrsxu_chinese_wwm_ext',
               'zh.embed.bert.by_qinluo': 'bert_embeddings_wo_chinese_plus',
               'zh.embed.bert.cased_base': 'bert_embeddings_base_zh_cased',
               'zh.embed.bert.chinese_wwm': 'bert_embeddings_chinese_wwm',
               'zh.embed.bert.large': 'bert_embeddings_chinese_lert_large',
               'zh.embed.bert.large.by_hfl': 'bert_embeddings_chinese_mac_large',
               'zh.embed.bert.lert.base.by_hfl': 'bert_embeddings_chinese_lert_base',
               'zh.embed.bert.mac.base.by_hfl': 'bert_embeddings_chinese_mac_base',
               'zh.embed.bert.mini': 'bert_embeddings_minirbt_h256',
               'zh.embed.bert.mini.by_hfl': 'bert_embeddings_minirbt_h288',
               'zh.embed.bert.rbt4_h312.by_hfl': 'bert_embeddings_rbt4_h312',
               'zh.embed.bert.small': 'bert_embeddings_chinese_lert_small',
               'zh.embed.bert.wwm': 'chinese_bert_wwm',
               'zh.embed.bert.wwm_ext.by_hfl': 'bert_embeddings_hfl_chinese_wwm_ext',
               'zh.embed.bert_5lang_cased': 'bert_embeddings_bert_base_5lang_cased',
               'zh.embed.bert_base_chinese_jinyong': 'bert_embeddings_bert_base_chinese_jinyong',
               'zh.embed.bert_base_zh_cased': 'bert_embeddings_bert_base_zh_cased',
               'zh.embed.bert_large_chinese': 'bert_embeddings_bert_large_chinese',
               'zh.embed.chinese_bert_wwm_ext': 'bert_embeddings_chinese_bert_wwm_ext',
               'zh.embed.chinese_macbert_base': 'bert_embeddings_chinese_macbert_base',
               'zh.embed.chinese_macbert_large': 'bert_embeddings_chinese_macbert_large',
               'zh.embed.chinese_roberta_wwm_ext': 'bert_embeddings_chinese_roberta_wwm_ext',
               'zh.embed.chinese_roberta_wwm_ext_large': 'bert_embeddings_chinese_roberta_wwm_ext_large',
               'zh.embed.chinese_roberta_wwm_large_ext_fix_mlm': 'bert_embeddings_chinese_roberta_wwm_large_ext_fix_mlm',
               'zh.embed.distilbert_base_cased': 'distilbert_embeddings_distilbert_base_zh_cased',
               'zh.embed.env_bert_chinese': 'bert_embeddings_env_bert_chinese',
               'zh.embed.jdt_fin_roberta_wwm': 'bert_embeddings_jdt_fin_roberta_wwm',
               'zh.embed.jdt_fin_roberta_wwm_large': 'bert_embeddings_jdt_fin_roberta_wwm_large',
               'zh.embed.macbert4csc_base_chinese': 'bert_embeddings_macbert4csc_base_chinese',
               'zh.embed.mengzi_bert_base': 'bert_embeddings_mengzi_bert_base',
               'zh.embed.mengzi_bert_base_fin': 'bert_embeddings_mengzi_bert_base_fin',
               'zh.embed.mengzi_oscar_base': 'bert_embeddings_mengzi_oscar_base',
               'zh.embed.mengzi_oscar_base_caption': 'bert_embeddings_mengzi_oscar_base_caption',
               'zh.embed.mengzi_oscar_base_retrieval': 'bert_embeddings_mengzi_oscar_base_retrieval',
               'zh.embed.rbt3': 'bert_embeddings_rbt3',
               'zh.embed.rbt4': 'bert_embeddings_rbt4',
               'zh.embed.rbt6': 'bert_embeddings_rbt6',
               'zh.embed.rbtl3': 'bert_embeddings_rbtl3',
               'zh.embed.roberta.wwm_ext.by_hfl': 'bert_embeddings_hfl_chinese_roberta_wwm_ext',
               'zh.embed.roberta_base_wechsel_chinese': 'roberta_embeddings_roberta_base_wechsel_chinese',
               'zh.embed.sikubert': 'bert_embeddings_sikubert',
               'zh.embed.sikuroberta': 'bert_embeddings_sikuroberta',
               'zh.embed.uer_large': 'bert_embeddings_uer_large',
               'zh.embed.w2v_cc_300d': 'w2v_cc_300d',
               'zh.embed.wobert_chinese_base': 'bert_embeddings_wobert_chinese_base',
               'zh.embed.wobert_chinese_plus': 'bert_embeddings_wobert_chinese_plus',
               'zh.embed.wobert_chinese_plus_base': 'bert_embeddings_wobert_chinese_plus_base',
               'zh.embed.xlmr_roberta.mini_lm_mini': 'xlmroberta_embeddings_fairlex_cail_minilm',
               'zh.embed.xlnet': 'chinese_xlnet_base',
               'zh.embed_sentence.bert': 'sbert_chinese_qmc_finance_v1',
               'zh.embed_sentence.bert.distilled': 'sbert_chinese_qmc_finance_v1_distill',
               'zh.lemma': 'lemma',
               'zh.lemma.gsd': 'lemma_gsd',
               'zh.lemma.gsdsimp': 'lemma_gsdsimp',
               'zh.ner': 'ner_msra_bert_768d',
               'zh.ner.bert': 'ner_msra_bert_768d',
               'zh.ner.bert.base': 'bert_ner_bert_base_chinese_ner',
               'zh.ner.bert.base.by_ckiplab': 'bert_token_classifier_base_chinese_ws',
               'zh.ner.bert.base_finetuned': 'bert_ner_roberta_base_finetuned_cluener2020_chinese',
               'zh.ner.bert.finetuned': 'bert_ner_bert_finetuned_ner_chinese',
               'zh.ner.bert.han.base.by_ckiplab': 'bert_token_classifier_base_han_chinese_ws',
               'zh.ner.bert.tiny': 'bert_ner_bert_tiny_chinese_ner',
               'zh.ner.bert.tiny.by_ckiplab': 'bert_token_classifier_tiny_chinese_ws',
               'zh.ner.bert_token': 'bert_token_classifier_chinese_ner',
               'zh.ner.msra.bert_768D': 'ner_msra_bert_768d',
               'zh.ner.pos': 'bert_pos_classical_chinese_punctuation_guwen_biaodian',
               'zh.ner.pos.base': 'bert_pos_bert_base_han_chinese_pos',
               'zh.ner.pos.tiny': 'bert_pos_bert_tiny_chinese_pos',
               'zh.ner.pos.universal_dependencies.base': 'bert_pos_bert_ancient_chinese_base_upos',
               'zh.ner.weibo.bert_768d': 'ner_weibo_bert_768d',
               'zh.pos': 'pos_gsdsimp',
               'zh.pos.bert_base_chinese_pos': 'bert_pos_bert_base_chinese_pos',
               'zh.pos.chinese_bert_wwm_ext_upos': 'bert_pos_chinese_bert_wwm_ext_upos',
               'zh.pos.chinese_roberta_base_upos': 'bert_pos_chinese_roberta_base_upos',
               'zh.pos.chinese_roberta_large_upos': 'bert_pos_chinese_roberta_large_upos',
               'zh.pos.gsd': 'pos_gsd',
               'zh.pos.gsdsimp': 'pos_gsdsimp',
               'zh.pos.ud_gsd': 'pos_ud_gsd',
               'zh.pos.ud_gsd_trad': 'pos_ud_gsd_trad',
               'zh.segment_words': 'wordseg_weibo',
               'zh.segment_words.ctb9': 'wordseg_ctb9',
               'zh.segment_words.gsd': 'wordseg_gsd_ud_trad',
               'zh.segment_words.large': 'wordseg_large',
               'zh.segment_words.msra': 'wordseg_msra',
               'zh.segment_words.pku': 'wordseg_pku',
               'zh.segment_words.weibo': 'wordseg_weibo',
               'zh.stopwords': 'stopwords_iso',
               'zh.tokenize': 'wordseg_weibo'},
        'zu': {'zu.embed.roberta': 'roberta_embeddings_zuberta',
               'zu.stopwords': 'stopwords_zu'}}

    healthcare_component_alias_references = {}
    pretrained_healthcare_pipe_references = {
        'de': {'de.deid.clinical': 'clinical_deidentification',
               'de.deid.ner_subentity.pipeline': 'ner_deid_subentity_pipeline',
               'de.deid.pipeline': 'german_deid_pipeline_spark24',
               'de.med_ner.deid_generic.pipeline': 'ner_deid_generic_pipeline'},
        'en': {

            'en.classify.bert_sequence.binary_rct_biobert.pipeline': 'bert_sequence_classifier_binary_rct_biobert_pipeline',
            'en.classify.bert_token_ner_jsl.pipeline': 'bert_token_classifier_ner_jsl_pipeline',
            'en.classify.rct_binary_biobert.pipeline': 'rct_binary_classifier_biobert_pipeline',
            'en.classify.rct_binary_use.pipeline': 'rct_binary_classifier_use_pipeline',
            'en.classify.token_bert.ade_pipeline': 'bert_token_classifier_ner_ade_pipeline',
            'en.classify.token_bert.anatomy_pipeline': 'bert_token_classifier_ner_anatomy_pipeline',
            'en.classify.token_bert.bacteria_ner.pipeline': 'bert_token_classifier_ner_bacteria_pipeline',
            'en.classify.token_bert.biolp.pipeline': 'bert_token_classifier_ner_bionlp_pipeline',
            'en.classify.token_bert.cellular_pipeline': 'bert_token_classifier_ner_cellular_pipeline',
            'en.classify.token_bert.chemicals_pipeline': 'bert_token_classifier_ner_chemicals_pipeline',
            'en.classify.token_bert.chemprot_pipeline': 'bert_token_classifier_ner_chemprot_pipeline',
            'en.classify.token_bert.clinical_pipeline': 'bert_token_classifier_ner_clinical_pipeline',
            'en.classify.token_bert.druge_developement.pipeline': 'bert_token_classifier_drug_development_trials_pipeline',
            'en.classify.token_bert.jsl_slim.pipeline': 'bert_token_classifier_ner_jsl_slim_pipeline',
            'en.classify.token_bert.ner_ade.pipeline': 'bert_token_classifier_ner_drugs_pipeline',
            'en.classify.token_bert.ner_deid.pipeline': 'bert_token_classifier_ner_deid_pipeline',
            'en.de_identify.clinical_pipeline': 'clinical_deidentification',
            'en.de_identify.clinical_slim': 'clinical_deidentification_slim',
            'en.deid.clinical_wip': 'clinical_deidentification_wip',
            'en.deid.glove_augmented.pipeline': 'clinical_deidentification_glove_augmented',
            'en.deid.glove_pipeline': 'clinical_deidentification_glove',
            'en.deid.med_ner_large.pipeline': 'ner_deid_sd_large_pipeline',
            'en.deid.ner_augmented.pipeline': 'ner_deid_augmented_pipeline',
            'en.deid.ner_biobert.pipeline': 'ner_deid_biobert_pipeline',
            'en.deid.ner_enriched_biobert.pipeline': 'ner_deid_enriched_biobert_pipeline',
            'en.deid.sd.pipeline': 'ner_deid_sd_pipeline',
            'en.deid.subentity_ner_augmented.pipeline': 'ner_deid_subentity_augmented_pipeline',
            'en.deid.subentity_ner_augmented_i2b2.pipeline': 'ner_deid_subentity_augmented_i2b2_pipeline',
            'en.explain_dco.clinical_medication.pipeline': 'explain_clinical_doc_medication',
            'en.explain_doc.carp': 'explain_clinical_doc_carp',
            'en.explain_doc.clinical_ade': 'explain_clinical_doc_ade',
            'en.explain_doc.clinical_radiology.pipeline': 'explain_clinical_doc_radiology',
            'en.explain_doc.era': 'explain_clinical_doc_era',
            'en.icd10_icd9.mapping': 'icd10_icd9_mapping',
            'en.icd10cm.umls.mapping': 'icd10cm_umls_mapping',
            'en.icd10cm_resolver.pipeline': 'icd10cm_resolver_pipeline',
            'en.map_entity.icd10cm_to_snomed.pipe': 'icd10cm_snomed_mapping',
            'en.map_entity.icdo_to_snomed.pipe': 'icdo_snomed_mapping',
            'en.map_entity.rxnorm_to_ndc.pipe': 'rxnorm_ndc_mapping',
            'en.map_entity.snomed_to_icd10cm.pipe': 'snomed_icd10cm_mapping',
            'en.map_entity.snomed_to_icdo.pipe': 'snomed_icdo_mapping',
            'en.map_entity.umls_clinical_findings_resolver': 'umls_clinical_findings_resolver_pipeline',
            'en.map_entity.umls_disease_syndrome_resolver': 'umls_disease_syndrome_resolver_pipeline',
            'en.map_entity.umls_drug_resolver': 'umls_drug_resolver_pipeline',
            'en.map_entity.umls_drug_substance_resolver': 'umls_drug_substance_resolver_pipeline',
            'en.map_entity.umls_major_concepts_resolver': 'umls_major_concepts_resolver_pipeline',
            'en.med_ner.ade_clinical.pipeline': 'ner_ade_clinical_pipeline',
            'en.med_ner.anatom.pipeline': 'ner_anatomy_pipeline',
            'en.med_ner.anatomy_biobert.pipeline': 'ner_anatomy_biobert_pipeline',
            'en.med_ner.anatomy_coarse.pipeline': 'ner_anatomy_coarse_pipeline',
            'en.med_ner.anatomy_coarse_biobert.pipeline': 'ner_anatomy_coarse_biobert_pipeline',
            'en.med_ner.bacterial_species.pipeline': 'ner_bacterial_species_pipeline',
            'en.med_ner.biobert_ade.pipeline': 'ner_ade_biobert_pipeline',
            'en.med_ner.biobert_events.pipeline': 'ner_events_biobert_pipeline',
            'en.med_ner.biobert_jsl_greedy.pipeline': 'ner_jsl_greedy_biobert_pipeline',
            'en.med_ner.biomarker.pipeline': 'ner_biomarker_pipeline',
            'en.med_ner.biomedical_bc2gm.pipeline': 'ner_biomedical_bc2gm_pipeline',
            'en.med_ner.bionlp.pipeline': 'ner_bionlp_pipeline',
            'en.med_ner.bionlp_biobert.pipeline': 'ner_bionlp_biobert_pipeline',
            'en.med_ner.cancer_genetics.pipeline': 'ner_cancer_genetics_pipeline',
            'en.med_ner.cellular.pipeline': 'ner_cellular_pipeline',
            'en.med_ner.cellular_biobert.pipeline': 'ner_cellular_biobert_pipeline',
            'en.med_ner.chemicals.pipeline': 'ner_chemicals_pipeline',
            'en.med_ner.chemprot_biobert.pipeline': 'ner_chemprot_biobert_pipeline',
            'en.med_ner.chemprot_clinical.pipeline': 'ner_chemprot_clinical_pipeline',
            'en.med_ner.chexpert.pipeline': 'ner_chexpert_pipeline',
            'en.med_ner.clinical-abbreviation.pipeline': 'ner_abbreviation_clinical_pipeline',
            'en.med_ner.clinical.pipeline': 'ner_clinical_pipeline',
            'en.med_ner.clinical_bert_ade.pipeline': 'ner_ade_clinicalbert_pipeline',
            'en.med_ner.clinical_biobert.pipeline': 'ner_clinical_biobert_pipeline',
            'en.med_ner.clinical_drugprot.pipeline': 'ner_drugprot_clinical_pipeline',
            'en.med_ner.clinical_large.pipeline': 'ner_clinical_large_pipeline',
            'en.med_ner.clinical_measurements.pipeline': 'ner_measurements_clinical_pipeline',
            'en.med_ner.clinical_trials_abstracts.pipe': 'ner_clinical_trials_abstracts_pipeline',
            'en.med_ner.deid_enriched.pipeline': 'ner_deid_enriched_pipeline',
            'en.med_ner.deid_generic_augmented.pipeline': 'ner_deid_generic_augmented_pipeline',
            'en.med_ner.deid_large.pipeline': 'ner_deid_large_pipeline',
            'en.med_ner.deidentify.pipeline': 'ner_deidentify_dl_pipeline',
            'en.med_ner.diseases.pipeline': 'ner_diseases_pipeline',
            'en.med_ner.diseases_biobert.pipeline': 'ner_diseases_biobert_pipeline',
            'en.med_ner.diseases_large.pipeline': 'ner_diseases_large_pipeline',
            'en.med_ner.drugs.pipeline': 'ner_drugs_pipeline',
            'en.med_ner.drugs_greedy.pipeline': 'ner_drugs_greedy_pipeline',
            'en.med_ner.drugs_large.pipeline': 'ner_drugs_large_pipeline',
            'en.med_ner.events_admission_clinical.pipeline': 'ner_events_admission_clinical_pipeline',
            'en.med_ner.events_clinical.pipeline': 'ner_events_clinical_pipeline',
            'en.med_ner.genetic_variants.pipeline': 'ner_genetic_variants_pipeline',
            'en.med_ner.greedy_wip_biobert.pipeline': 'jsl_ner_wip_greedy_biobert_pipeline',
            'en.med_ner.healthcare_ade.pipeline': 'ner_ade_healthcare_pipeline',
            'en.med_ner.healthcare_events.pipeline': 'ner_events_healthcare_pipeline',
            'en.med_ner.healthcare_pipeline': 'ner_healthcare_pipeline',
            'en.med_ner.human_phenotype_clinical.pipeline': 'ner_human_phenotype_go_clinical_pipeline',
            'en.med_ner.human_phenotype_gene_biobert.pipeline': 'ner_human_phenotype_gene_biobert_pipeline',
            'en.med_ner.human_phnotype_gene_clinical.pipeline': 'ner_human_phenotype_gene_clinical_pipeline',
            'en.med_ner.jsl.pipeline': 'ner_jsl_pipeline',
            'en.med_ner.jsl_biobert.pipeline': 'ner_jsl_biobert_pipeline',
            'en.med_ner.jsl_enriched.pipeline': 'ner_jsl_enriched_pipeline',
            'en.med_ner.jsl_enriched_biobert.pipeline': 'ner_jsl_enriched_biobert_pipeline',
            'en.med_ner.jsl_greedy.pipeline': 'ner_jsl_greedy_pipeline',
            'en.med_ner.jsl_rd_wip_greedy.pipeline': 'jsl_rd_ner_wip_greedy_clinical_pipeline',
            'en.med_ner.jsl_slim.pipeline': 'ner_jsl_slim_pipeline',
            'en.med_ner.jsl_wip_clinical.pipeline': 'jsl_ner_wip_clinical_pipeline',
            'en.med_ner.medmentions_coarse.pipeline': 'ner_medmentions_coarse_pipeline',
            'en.med_ner.nihss_pipeline': 'ner_nihss_pipeline',
            'en.med_ner.pathogen.pipeline': 'ner_pathogen_pipeline',
            'en.med_ner.phenotype_go_biobert.pipeline': 'ner_human_phenotype_go_biobert_pipeline',
            'en.med_ner.posology.healthcare_pipeline': 'ner_posology_healthcare_pipeline',
            'en.med_ner.posology_biobert.pipeline': 'ner_posology_biobert_pipeline',
            'en.med_ner.posology_biobert_large.pipeline': 'ner_posology_large_biobert_pipeline',
            'en.med_ner.posology_experimental.pipeline': 'ner_posology_experimental_pipeline',
            'en.med_ner.posology_greedy.pipeline': 'ner_posology_greedy_pipeline',
            'en.med_ner.posology_pipeline': 'ner_posology_pipeline',
            'en.med_ner.posology_small.pipeline': 'ner_posology_small_pipeline',
            'en.med_ner.posoloy_large.pipeline': 'ner_posology_large_pipeline',
            'en.med_ner.profiling_biobert': 'ner_profiling_biobert',
            'en.med_ner.profiling_clinical': 'ner_profiling_clinical',
            'en.med_ner.radiology.clinical_wip.pipeline': 'ner_radiology_wip_clinical_pipeline',
            'en.med_ner.radiology.pipeline': 'ner_radiology_pipeline',
            'en.med_ner.risk_factors.pipeline': 'ner_risk_factors_pipeline',
            'en.med_ner.risk_factors_biobert.pipeline': 'ner_risk_factors_biobert_pipeline',
            'en.med_ner.wip_greedy_biobert.pipeline': 'jsl_rd_ner_wip_greedy_biobert_pipeline',
            'en.med_ner.wip_greedy_clinical.pipeline': 'jsl_ner_wip_greedy_clinical_pipeline',
            'en.med_ner.wip_modifier_clinical.pipeline': 'jsl_ner_wip_modifier_clinical_pipeline',
            'en.mesh.umls.mapping': 'mesh_umls_mapping',
            'en.ner.medication': 'ner_medication_pipeline',
            'en.ner.model_finder.pipeline': 'ner_model_finder',
            'en.oncology_biomarker.pipeline': 'oncology_biomarker_pipeline',
            'en.oncology_diagnosis.pipeline': 'oncology_diagnosis_pipeline',
            'en.oncology_general.pipeline': 'oncology_general_pipeline',
            'en.oncology_therpay.pipeline': 'oncology_therapy_pipeline',
            'en.recognize_entities.posology': 'recognize_entities_posology',
            'en.relation.bodypart_directions.pipeline': 're_bodypart_directions_pipeline',
            'en.relation.bodypart_proceduretest.pipeline': 're_bodypart_proceduretest_pipeline',
            'en.relation.date_clinical.pipeline': 're_date_clinical_pipeline',
            'en.relation.date_test_result.pipeline': 're_test_result_date_pipeline',
            'en.relation.human_gene_clinical.pipeline': 're_human_phenotype_gene_clinical_pipeline',
            'en.relation.temporal_event_clinical.pipeline': 're_temporal_events_clinical_pipeline',
            'en.relation.temproal_enriched.pipeline': 're_temporal_events_enriched_clinical_pipeline',
            'en.relation.test_problem_finding.pipeline': 're_test_problem_finding_pipeline',
            'en.resolve.cvx_pipeline': 'cvx_resolver_pipeline',
            'en.resolve.icd9.pipeline': 'icd9_resolver_pipeline',
            'en.resolve.medication': 'medication_resolver_pipeline',
            'en.resolve.medication_transform.pipeline': 'medication_resolver_transform_pipeline',
            'en.rxnorm.umls.mapping': 'rxnorm_umls_mapping',
            'en.snomed.umls.mapping': 'snomed_umls_mapping',
            'en.spell.clinical.pipeline': 'spellcheck_clinical_pipeline'},
        'es': {'es.deid.clinical': 'clinical_deidentification',
               'es.deid.clinical_augmented': 'clinical_deidentification_augmented',
               'es.deid.pipeline': 'deid_pipeline'},
        'fr': {'fr.deid_obfuscated': 'clinical_deidentification'},
        'it': {'it.deid.clinical': 'clinical_deidentification'},
        'pt': {'pt.deid.clinical': 'clinical_deidentification'},
        'ro': {'ro.deid.clinical': 'clinical_deidentification'}}

    pretrained_healthcare_model_references = {'ca': {'ca.med_ner.living_species': 'ner_living_species'},
                                              'de': {
                                                  'de.classify.bert_sequence.health_mentions_bert': 'bert_sequence_classifier_health_mentions_bert',
                                                  'de.classify.bert_sequence.health_mentions_gbert': 'bert_sequence_classifier_health_mentions_gbert',
                                                  'de.classify.bert_sequence.health_mentions_gbert_large': 'bert_sequence_classifier_health_mentions_gbert_large',
                                                  'de.classify.bert_sequence.health_mentions_medbert': 'bert_sequence_classifier_health_mentions_medbert',
                                                  'de.embed': 'w2v_cc_300d',
                                                  'de.embed.w2v': 'w2v_cc_300d',
                                                  'de.med_ner': 'ner_healthcare_slim',
                                                  'de.med_ner.deid_generic': 'ner_deid_generic',
                                                  'de.med_ner.deid_subentity': 'ner_deid_subentity',
                                                  'de.med_ner.healthcare': 'ner_healthcare',
                                                  'de.med_ner.legal': 'ner_legal',
                                                  'de.med_ner.traffic': 'ner_traffic',
                                                  'de.resolve.icd10gm': 'sbertresolve_icd10gm',
                                                  'de.resolve.snomed': 'sbertresolve_snomed'},
                                              'en': {
                                                  'en.generate.biomedical_biogpt_base': 'text_generator_biomedical_biogpt_base',
                                                  'en.generate.generic_flan_base': 'text_generator_generic_flan_base',
                                                  'en.generate.generic_jsl_base': 'text_generator_generic_jsl_base',
                                                  'en.generate.generic_flan_t5_large': 'text_generator_generic_flan_t5_large',
                                                  'en.generate.biogpt_chat_jsl': 'biogpt_chat_jsl',
                                                  'en.generate.biogpt_chat_jsl_conversational': 'biogpt_chat_jsl_conversational',
                                                  'en.generate.biogpt_chat_jsl_conditions': 'biogpt_chat_jsl_conditions',
                                                  'en.summarizer_generic_jsl': 'summarizer_generic_jsl',
                                                  'en.summarize.clinical_jsl': 'summarizer_clinical_jsl',
                                                  'en.summarize.clinical_jsl_augmented': 'summarizer_clinical_jsl_augmented',
                                                  'en.summarize.biomedical_pubmed': 'summarizer_biomedical_pubmed',
                                                  'en.summarize.generic_jsl': 'summarizer_generic_jsl',
                                                  'en.summarize.clinical_questions': 'summarizer_clinical_questions',
                                                  'en.summarize.radiology': 'summarizer_radiology',
                                                  'en.summarize.clinical_guidelines_large': 'summarizer_clinical_guidelines_large',
                                                  'en.summarize.clinical_laymen': 'summarizer_clinical_laymen',

                                                  'en.assert': 'assertion_dl',
                                                  'en.assert.biobert': 'assertion_dl_biobert',
                                                  'en.assert.biobert_l10210': 'assertion_dl_biobert_scope_L10R10',
                                                  'en.assert.healthcare': 'assertion_dl_healthcare',
                                                  'en.assert.jsl': 'assertion_jsl',
                                                  'en.assert.jsl_augmented': 'assertion_jsl_augmented',
                                                  'en.assert.jsl_large': 'assertion_jsl_large',
                                                  'en.assert.l10r10': 'assertion_dl_scope_L10R10',
                                                  'en.assert.large': 'assertion_dl_large',
                                                  'en.assert.oncology_demographic_binary_wip': 'assertion_oncology_demographic_binary_wip',
                                                  'en.assert.oncology_family_history': 'assertion_oncology_family_history_wip',
                                                  'en.assert.oncology_problem_wip': 'assertion_oncology_problem_wip',
                                                  'en.assert.oncology_response_to_treatment_wip': 'assertion_oncology_response_to_treatment_wip',
                                                  'en.assert.oncology_smoking_status': 'assertion_oncology_smoking_status_wip',
                                                  'en.assert.oncology_test_binary': 'assertion_oncology_test_binary_wip',
                                                  'en.assert.oncology_treatment_binary': 'assertion_oncology_treatment_binary_wip',
                                                  'en.assert.oncology_wip': 'assertion_oncology_wip',
                                                  'en.assert.radiology': 'assertion_dl_radiology',
                                                  'en.clasify.health_premise': 'bert_sequence_classifier_health_mandates_premise_tweet',
                                                  'en.classify .bert_sequence.depression': 'bert_sequence_classifier_depression',
                                                  'en.classify.ade.biobert': 'classifierdl_ade_biobert',
                                                  'en.classify.ade.clinical': 'classifierdl_ade_clinicalbert',
                                                  'en.classify.ade.clinicalbert': 'classifierdl_ade_clinicalbert',
                                                  'en.classify.ade.conversational': 'classifierdl_ade_conversational_biobert',
                                                  'en.classify.ade.seq_biobert': 'bert_sequence_classifier_ade',
                                                  'en.classify.ade.seq_distilbert': 'distilbert_sequence_classifier_ade',
                                                  'en.classify.adverse_drug_events': 'bert_sequence_classifier_ade_augmented',
                                                  'en.classify.bert_sequence.binary_biobert': 'bert_sequence_classifier_binary_rct_biobert',
                                                  'en.classify.bert_sequence.covid_sentiment': 'bert_sequence_classifier_covid_sentiment',
                                                  'en.classify.bert_sequence.depression_binary': 'bert_sequence_classifier_depression_binary',
                                                  'en.classify.bert_sequence.depression_twitter': 'bert_sequence_classifier_depression_twitter',
                                                  'en.classify.bert_sequence.question_statement_clinical': 'bert_sequence_classifier_question_statement_clinical',
                                                  'en.classify.bert_sequence.sdoh.environment_status': 'bert_sequence_classifier_sdoh_environment_status',
                                                  'en.classify.bert_sequence.sdoh_community_absent_status': 'bert_sequence_classifier_sdoh_community_absent_status',
                                                  'en.classify.bert_sequence.sdoh_community_present_status': 'bert_sequence_classifier_sdoh_community_present_status',
                                                  'en.classify.bert_sequence.treatment_sentiment_tweets': 'bert_sequence_classifier_treatment_changes_sentiment_tweet',
                                                  'en.classify.bert_sequence_vaccine_sentiment': 'bert_sequence_classifier_vaccine_sentiment',
                                                  'en.classify.bert_token.binary_ade_tweet': 'bert_token_classifier_ade_tweet_binary',
                                                  'en.classify.bert_token.ner_ade_bert': 'bert_token_classifier_ner_ade_binary',
                                                  'en.classify.drug_reviews': 'bert_sequence_classifier_drug_reviews_webmd',
                                                  'en.classify.exact_age': 'bert_sequence_classifier_exact_age_reddit',
                                                  'en.classify.gender.biobert': 'classifierdl_gender_biobert',
                                                  'en.classify.gender.sbert': 'classifierdl_gender_sbert',
                                                  'en.classify.gender.seq_biobert': 'bert_sequence_classifier_gender_biobert',
                                                  'en.classify.generic.sdoh_alchol_binary_sbiobert_cased': 'genericclassifier_sdoh_alcohol_usage_binary_sbiobert_cased_mli',
                                                  'en.classify.generic.sdoh_alchol_usage_sbiobert_cased': 'genericclassifier_sdoh_alcohol_usage_sbiobert_cased_mli',
                                                  'en.classify.generic.sdoh_ecnomics_sbiobert_cased': 'genericclassifier_sdoh_economics_binary_sbiobert_cased_mli',
                                                  'en.classify.generic.sdoh_substance_binary_sbiobert_cased': 'genericclassifier_sdoh_substance_usage_binary_sbiobert_cased_mli',
                                                  'en.classify.generic.sdoh_tobacco_sbiobert_cased': 'genericclassifier_sdoh_tobacco_usage_sbiobert_cased_mli',
                                                  'en.classify.health': 'classifierdl_health_mentions',
                                                  'en.classify.health_mentions': 'bert_sequence_classifier_health_mentions',
                                                  'en.classify.health_stance': 'bert_sequence_classifier_health_mandates_stance_tweet',
                                                  'en.classify.pico': 'classifierdl_pico_biobert',
                                                  'en.classify.pico.seq_biobert': 'bert_sequence_classifier_pico_biobert',
                                                  'en.classify.rct_binary_biobert': 'rct_binary_classifier_biobert',
                                                  'en.classify.rct_binary_use': 'rct_binary_classifier_use',
                                                  'en.classify.self_reported_age': 'bert_sequence_classifier_self_reported_age_tweet',
                                                  'en.classify.self_reported_partner_violence': 'bert_sequence_classifier_self_reported_partner_violence_tweet',
                                                  'en.classify.self_reported_stress': 'bert_sequence_classifier_self_reported_stress_tweet',
                                                  'en.classify.self_reported_vaccine_status': 'bert_sequence_classifier_self_reported_vaccine_status_tweet',
                                                  'en.classify.stress': 'bert_sequence_classifier_stress',
                                                  'en.classify.stressor': 'bert_sequence_classifier_stressor',
                                                  'en.classify.token_bert.anatem': 'bert_token_classifier_ner_anatem',
                                                  'en.classify.token_bert.bc2gm_gene': 'bert_token_classifier_ner_bc2gm_gene',
                                                  'en.classify.token_bert.bc4chemd_chemicals': 'bert_token_classifier_ner_bc4chemd_chemicals',
                                                  'en.classify.token_bert.bc5cdr_chemicals': 'bert_token_classifier_ner_bc5cdr_chemicals',
                                                  'en.classify.token_bert.bc5cdr_disease': 'bert_token_classifier_ner_bc5cdr_disease',
                                                  'en.classify.token_bert.bionlp': 'bert_token_classifier_ner_bionlp',
                                                  'en.classify.token_bert.cellular': 'bert_token_classifier_ner_cellular',
                                                  'en.classify.token_bert.chemicals': 'bert_token_classifier_ner_chemicals',
                                                  'en.classify.token_bert.jnlpba_cellular': 'bert_token_classifier_ner_jnlpba_cellular',
                                                  'en.classify.token_bert.linnaeus_species': 'bert_token_classifier_ner_linnaeus_species',
                                                  'en.classify.token_bert.ncbi_disease': 'bert_token_classifier_ner_ncbi_disease',
                                                  'en.classify.token_bert.ner_ade': 'bert_token_classifier_ner_ade',
                                                  'en.classify.token_bert.ner_anatomy': 'bert_token_classifier_ner_anatomy',
                                                  'en.classify.token_bert.ner_bacteria': 'bert_token_classifier_ner_bacteria',
                                                  'en.classify.token_bert.ner_chemical': 'bert_token_classifier_ner_chemicals',
                                                  'en.classify.token_bert.ner_clinical': 'bert_token_classifier_ner_clinical',
                                                  'en.classify.token_bert.ner_deid': 'bert_token_classifier_ner_deid',
                                                  'en.classify.token_bert.ner_drugs': 'bert_token_classifier_ner_drugs',
                                                  'en.classify.token_bert.ner_jsl': 'bert_token_classifier_ner_jsl',
                                                  'en.classify.token_bert.ner_jsl_slim': 'bert_token_classifier_ner_jsl_slim',
                                                  'en.classify.token_bert.pathogen': 'bert_token_classifier_ner_pathogen',
                                                  'en.classify.token_bert.species': 'bert_token_classifier_ner_species',
                                                  'en.classify.token_bert.supplement': 'bert_token_classifier_ner_supplement',
                                                  'en.classify.treatment_sentiment': 'bert_sequence_classifier_treatement_changes_sentiment_tweet',
                                                  'en.classify.vaccine_sentiment': 'classifierdl_vaccine_sentiment',
                                                  'en.de_identify': 'deidentify_rb',
                                                  'en.de_identify.clinical': 'deidentify_enriched_clinical',
                                                  'en.de_identify.large': 'deidentify_large',
                                                  'en.de_identify.rb': 'deidentify_rb',
                                                  'en.de_identify.rb_no_regex': 'deidentify_rb_no_regex',
                                                  'en.de_identify.rules': 'deid_rules',
                                                  'en.detect_sentence.clinical': 'sentence_detector_dl_healthcare',
                                                  'en.embed.glove.biovec': 'embeddings_biovec',
                                                  'en.embed.glove.clinical': 'embeddings_clinical',
                                                  'en.embed.glove.healthcare': 'embeddings_healthcare',
                                                  'en.embed.glove.healthcare_100d': 'embeddings_healthcare_100d',
                                                  'en.embed.glove.icdoem': 'embeddings_icdoem',
                                                  'en.embed.glove.icdoem_2ng': 'embeddings_icdoem_2ng',
                                                  'en.embed_sentence.bert.jsl_medium_umls_uncased': 'sbert_jsl_medium_umls_uncased',
                                                  'en.embed_sentence.bert.jsl_medium_uncased': 'sbert_jsl_medium_uncased',
                                                  'en.embed_sentence.bert.jsl_mini_umlsuncased': 'sbert_jsl_mini_umls_uncased',
                                                  'en.embed_sentence.bert.jsl_mini_uncased': 'sbert_jsl_mini_uncased',
                                                  'en.embed_sentence.bert.jsl_tiny_umls_uncased': 'sbert_jsl_tiny_umls_uncased',
                                                  'en.embed_sentence.bert.jsl_tiny_uncased': 'sbert_jsl_tiny_uncased',
                                                  'en.embed_sentence.bert_medium.rxnorm': 'jsl_sbert_medium_rxnorm',
                                                  'en.embed_sentence.bert_uncased.rxnorm': 'sbert_jsl_medium_rxnorm_uncased',
                                                  'en.embed_sentence.biobert.jsl_cased': 'sbiobert_jsl_cased',
                                                  'en.embed_sentence.biobert.jsl_umls_cased': 'sbiobert_jsl_umls_cased',
                                                  'en.embed_sentence.biobert.mli': 'sbiobert_base_cased_mli',
                                                  'en.embed_sentence.biobert.rxnorm': 'sbiobert_jsl_rxnorm_cased',
                                                  'en.embed_sentence.bluebert.mli': 'sbluebert_base_uncased_mli',
                                                  'en.extract_relation.nihss': 'redl_nihss_biobert',
                                                  'en.icd10cm_to_snomed': 'icd10cm_snomed_mapper',
                                                  'en.icd10cm_to_umls': 'icd10cm_umls_mapper',
                                                  'en.icdo_to_snomed': 'icdo_snomed_mapper',
                                                  'en.map_entity.abbreviation_augmented': 'abbreviation_mapper_augmented',
                                                  'en.map_entity.abbreviation_category': 'abbreviation_category_mapper',
                                                  'en.map_entity.abbreviation_to_definition': 'abbreviation_mapper',
                                                  'en.map_entity.cvx_code': 'cvx_code_mapper',
                                                  'en.map_entity.cvx_name': 'cvx_name_mapper',
                                                  'en.map_entity.drug_ade': 'drug_ade_mapper',
                                                  'en.map_entity.drug_brand_to_ndc': 'drug_brandname_ndc_mapper',
                                                  'en.map_entity.drug_category': 'drug_category_mapper',
                                                  'en.map_entity.drug_to_action_treatment': 'drug_action_treatment_mapper',
                                                  'en.map_entity.icd10_ic9': 'icd10_icd9_mapper',
                                                  'en.map_entity.icd10cm': 'icd10cm_mapper',
                                                  'en.map_entity.icd10cm_to_snomed': 'icd10cm_snomed_mapper',
                                                  'en.map_entity.icd10cm_to_umls': 'icd10cm_umls_mapper',
                                                  'en.map_entity.icd9': 'icd9_mapper',
                                                  'en.map_entity.icd9_icd10': 'icd9_icd10_mapper',
                                                  'en.map_entity.icdo_to_snomed': 'icdo_snomed_mapper',
                                                  'en.map_entity.kegg_disease': 'kegg_disease_mapper',
                                                  'en.map_entity.kegg_drug': 'kegg_drug_mapper',
                                                  'en.map_entity.mesh_to_umls': 'mesh_umls_mapper',
                                                  'en.map_entity.rxnorm_normalized': 'rxnorm_normalized_mapper',
                                                  'en.map_entity.rxnorm_resolver': 'rxnorm_mapper',
                                                  'en.map_entity.rxnorm_to_action_treatment': 'rxnorm_action_treatment_mapper',
                                                  'en.map_entity.rxnorm_to_ndc': 'rxnorm_ndc_mapper',
                                                  'en.map_entity.rxnorm_to_umls': 'rxnorm_umls_mapper',
                                                  'en.map_entity.section_headers_normalized': 'normalized_section_header_mapper',
                                                  'en.map_entity.snomed_to_icd10cm': 'snomed_icd10cm_mapper',
                                                  'en.map_entity.snomed_to_icdo': 'snomed_icdo_mapper',
                                                  'en.map_entity.snomed_to_umls': 'snomed_umls_mapper',
                                                  'en.map_entity.umls_clinical_drugs_mapper': 'umls_clinical_drugs_mapper',
                                                  'en.map_entity.umls_clinical_findings_mapper': 'umls_clinical_findings_mapper',
                                                  'en.map_entity.umls_disease_syndrome_mapper': 'umls_disease_syndrome_mapper',
                                                  'en.map_entity.umls_drug_substance_mapper': 'umls_drug_substance_mapper',
                                                  'en.map_entity.umls_major_concepts_mapper': 'umls_major_concepts_mapper',
                                                  'en.med_ner': 'jsl_ner_wip_clinical',
                                                  'en.med_ner.abbreviation_clinical': 'ner_abbreviation_clinical',
                                                  'en.med_ner.ade.ade_healthcare': 'ner_ade_healthcare',
                                                  'en.med_ner.ade.clinical': 'ner_ade_clinical',
                                                  'en.med_ner.ade.clinical_bert': 'ner_ade_clinicalbert',
                                                  'en.med_ner.ade_biobert': 'ner_ade_biobert',
                                                  'en.med_ner.admission_events': 'ner_events_admission_clinical',
                                                  'en.med_ner.anatomy': 'ner_anatomy',
                                                  'en.med_ner.anatomy.biobert': 'ner_anatomy_biobert',
                                                  'en.med_ner.anatomy.coarse': 'ner_anatomy_coarse',
                                                  'en.med_ner.anatomy.coarse_biobert': 'ner_anatomy_coarse_biobert',
                                                  'en.med_ner.anatomy_general': 'ner_oncology_anatomy_general',
                                                  'en.med_ner.aspect_sentiment': 'ner_aspect_based_sentiment',
                                                  'en.med_ner.bacterial_species': 'ner_bacterial_species',
                                                  'en.med_ner.binary_ade': 'ner_ade_binary',
                                                  'en.med_ner.biomarker': 'ner_biomarker',
                                                  'en.med_ner.biomedical_bc2gm': 'ner_biomedical_bc2gm',
                                                  'en.med_ner.bionlp': 'ner_bionlp',
                                                  'en.med_ner.bionlp.biobert': 'ner_bionlp_biobert',
                                                  'en.med_ner.cancer': 'ner_cancer_genetics',
                                                  'en.med_ner.cellular': 'ner_cellular',
                                                  'en.med_ner.cellular.biobert': 'ner_cellular_biobert',
                                                  'en.med_ner.chemd': 'ner_chemd_clinical',
                                                  'en.med_ner.chemicals': 'ner_chemicals',
                                                  'en.med_ner.chemprot': 'ner_chemprot_biobert',
                                                  'en.med_ner.chemprot.bert': 'bert_token_classifier_ner_chemprot',
                                                  'en.med_ner.chemprot.clinical': 'ner_chemprot_clinical',
                                                  'en.med_ner.chexpert': 'ner_chexpert',
                                                  'en.med_ner.clinical': 'ner_clinical',
                                                  'en.med_ner.clinical.biobert': 'ner_clinical_biobert',
                                                  'en.med_ner.clinical_case_eu': 'ner_eu_clinical_case',
                                                  'en.med_ner.clinical_trials': 'bert_sequence_classifier_rct_biobert',
                                                  'en.med_ner.clinical_trials_abstracts': 'bert_token_classifier_ner_clinical_trials_abstracts',
                                                  'en.med_ner.covid_trials': 'ner_covid_trials',
                                                  'en.med_ner.deid': 'ner_deidentify_dl',
                                                  'en.med_ner.deid.augmented': 'ner_deid_augmented',
                                                  'en.med_ner.deid.biobert': 'ner_deid_biobert',
                                                  'en.med_ner.deid.enriched': 'ner_deid_enriched',
                                                  'en.med_ner.deid.enriched_biobert': 'ner_deid_enriched_biobert',
                                                  'en.med_ner.deid.generic_augmented': 'ner_deid_generic_augmented',
                                                  'en.med_ner.deid.large': 'ner_deid_large',
                                                  'en.med_ner.deid.sd': 'ner_deid_sd',
                                                  'en.med_ner.deid.sd_large': 'ner_deid_sd_large',
                                                  'en.med_ner.deid.subentity_augmented': 'ner_deid_subentity_augmented',
                                                  'en.med_ner.deid.synthetic': 'ner_deid_synthetic',
                                                  'en.med_ner.deid_subentity_augmented_i2b2': 'ner_deid_subentity_augmented_i2b2',
                                                  'en.med_ner.diseases': 'ner_diseases',
                                                  'en.med_ner.diseases.biobert': 'ner_diseases_biobert',
                                                  'en.med_ner.diseases.large': 'ner_diseases_large',
                                                  'en.med_ner.drugprot_clinical': 'ner_drugprot_clinical',
                                                  'en.med_ner.drugs': 'ner_drugs',
                                                  'en.med_ner.drugs.large': 'ner_drugs_large',
                                                  'en.med_ner.drugsgreedy': 'ner_drugs_greedy',
                                                  'en.med_ner.events_biobert': 'ner_events_biobert',
                                                  'en.med_ner.events_clinical': 'ner_events_clinical',
                                                  'en.med_ner.events_healthcre': 'ner_events_healthcare',
                                                  'en.med_ner.financial_contract': 'ner_financial_contract',
                                                  'en.med_ner.genetic_variants': 'ner_genetic_variants',
                                                  'en.med_ner.healthcare': 'ner_healthcare',
                                                  'en.med_ner.human_phenotype.gene_biobert': 'ner_human_phenotype_gene_biobert',
                                                  'en.med_ner.human_phenotype.gene_clinical': 'ner_human_phenotype_gene_clinical',
                                                  'en.med_ner.human_phenotype.go_biobert': 'ner_human_phenotype_go_biobert',
                                                  'en.med_ner.human_phenotype.go_clinical': 'ner_human_phenotype_go_clinical',
                                                  'en.med_ner.jsl': 'ner_jsl',
                                                  'en.med_ner.jsl.biobert': 'ner_jsl_biobert',
                                                  'en.med_ner.jsl.enriched': 'ner_jsl_enriched',
                                                  'en.med_ner.jsl.enriched_biobert': 'ner_jsl_enriched_biobert',
                                                  'en.med_ner.jsl.wip.clinical': 'jsl_ner_wip_clinical',
                                                  'en.med_ner.jsl.wip.clinical.greedy': 'jsl_ner_wip_greedy_clinical',
                                                  'en.med_ner.jsl.wip.clinical.modifier': 'jsl_ner_wip_modifier_clinical',
                                                  'en.med_ner.jsl.wip.clinical.rd': 'jsl_rd_ner_wip_greedy_clinical',
                                                  'en.med_ner.jsl_greedy_biobert': 'ner_jsl_greedy_biobert',
                                                  'en.med_ner.jsl_slim': 'ner_jsl_slim',
                                                  'en.med_ner.living_species': 'ner_living_species',
                                                  'en.med_ner.living_species.biobert': 'ner_living_species_biobert',
                                                  'en.med_ner.living_species.token_bert': 'bert_token_classifier_ner_living_species',
                                                  'en.med_ner.measurements': 'ner_measurements_clinical',
                                                  'en.med_ner.medmentions': 'ner_medmentions_coarse',
                                                  'en.med_ner.nero_clinical.nature': 'ner_nature_nero_clinical',
                                                  'en.med_ner.nihss': 'ner_nihss',
                                                  'en.med_ner.oncology': 'ner_oncology',
                                                  'en.med_ner.oncology_anatom_general_healthcare': 'ner_oncology_anatomy_general_healthcare',
                                                  'en.med_ner.oncology_anatomy_general': 'ner_oncology_anatomy_general_wip',
                                                  'en.med_ner.oncology_anatomy_granular': 'ner_oncology_anatomy_granular',
                                                  'en.med_ner.oncology_anatomy_granular_wip': 'ner_oncology_anatomy_granular_wip',
                                                  'en.med_ner.oncology_biomarker': 'ner_oncology_biomarker',
                                                  'en.med_ner.oncology_biomarker_healthcare': 'ner_oncology_biomarker_healthcare',
                                                  'en.med_ner.oncology_biomarker_wip': 'ner_oncology_biomarker_wip',
                                                  'en.med_ner.oncology_demographics': 'ner_oncology_demographics',
                                                  'en.med_ner.oncology_demographics_wip': 'ner_oncology_demographics_wip',
                                                  'en.med_ner.oncology_diagnosis': 'ner_oncology_diagnosis',
                                                  'en.med_ner.oncology_diseases_wip': 'ner_oncology_diagnosis_wip',
                                                  'en.med_ner.oncology_posology': 'ner_oncology_posology',
                                                  'en.med_ner.oncology_posology_wip': 'ner_oncology_posology_wip',
                                                  'en.med_ner.oncology_response_to_treatment': 'ner_oncology_response_to_treatment',
                                                  'en.med_ner.oncology_response_to_treatment_wip': 'ner_oncology_response_to_treatment_wip',
                                                  'en.med_ner.oncology_test': 'ner_oncology_test',
                                                  'en.med_ner.oncology_test_wip': 'ner_oncology_test_wip',
                                                  'en.med_ner.oncology_therapy': 'ner_oncology_therapy',
                                                  'en.med_ner.oncology_therapy_wip': 'ner_oncology_therapy_wip',
                                                  'en.med_ner.oncology_tnm': 'ner_oncology_tnm',
                                                  'en.med_ner.oncology_tnm_wip': 'ner_oncology_tnm_wip',
                                                  'en.med_ner.oncology_unspecific_posology': 'ner_oncology_unspecific_posology',
                                                  'en.med_ner.oncology_unspecific_posology_healthcare': 'ner_oncology_unspecific_posology_healthcare',
                                                  'en.med_ner.oncology_unspecific_posology_wip': 'ner_oncology_unspecific_posology_wip',
                                                  'en.med_ner.oncology_wip': 'ner_oncology_wip',
                                                  'en.med_ner.pathogen': 'ner_pathogen',
                                                  'en.med_ner.posology': 'ner_posology',
                                                  'en.med_ner.posology.biobert': 'ner_posology_biobert',
                                                  'en.med_ner.posology.experimental': 'ner_posology_experimental',
                                                  'en.med_ner.posology.greedy': 'ner_posology_greedy',
                                                  'en.med_ner.posology.healthcare': 'ner_posology_healthcare',
                                                  'en.med_ner.posology.large': 'ner_posology_large',
                                                  'en.med_ner.posology.large_biobert': 'ner_posology_large_biobert',
                                                  'en.med_ner.posology.small': 'ner_posology_small',
                                                  'en.med_ner.radiology': 'ner_radiology',
                                                  'en.med_ner.radiology.wip_clinical': 'ner_radiology_wip_clinical',
                                                  'en.med_ner.radiology.wip_greedy_biobert': 'jsl_rd_ner_wip_greedy_biobert',
                                                  'en.med_ner.risk_factors': 'ner_risk_factors',
                                                  'en.med_ner.risk_factors.biobert': 'ner_risk_factors_biobert',
                                                  'en.med_ner.sdoh_mentions': 'ner_sdoh_mentions',
                                                  'en.med_ner.sdoh_mentions_test': 'ner_sdoh_mentions_test',
                                                  'en.med_ner.sdoh_slim_wip': 'ner_sdoh_slim_wip',
                                                  'en.med_ner.supplement_clinical': 'ner_supplement_clinical',
                                                  'en.med_ner.tumour': 'nerdl_tumour_demo',
                                                  'en.mesh_to_umls': 'mesh_umls_mapper',
                                                  'en.ner.clinical_trials_abstracts': 'ner_clinical_trials_abstracts',
                                                  'en.ner.drug_development_trials': 'bert_token_classifier_drug_development_trials',
                                                  'en.norm_drugs': 'drug_normalizer',
                                                  'en.pos.clinical': 'pos_clinical',
                                                  'en.relation': 'redl_bodypart_direction_biobert',
                                                  'en.relation.ade': 'redl_ade_biobert',
                                                  'en.relation.ade_biobert': 're_ade_biobert',
                                                  'en.relation.ade_clinical': 're_ade_clinical',
                                                  'en.relation.adverse_drug_events.clinical': 're_ade_clinical',
                                                  'en.relation.adverse_drug_events.clinical.biobert': 'redl_ade_biobert',
                                                  'en.relation.adverse_drug_events.conversational': 're_ade_conversational',
                                                  'en.relation.bodypart.direction': 'redl_bodypart_direction_biobert',
                                                  'en.relation.bodypart.problem': 'redl_bodypart_problem_biobert',
                                                  'en.relation.bodypart.procedure': 'redl_bodypart_procedure_test_biobert',
                                                  'en.relation.chemprot': 'redl_chemprot_biobert',
                                                  'en.relation.clinical': 'redl_clinical_biobert',
                                                  'en.relation.date': 'redl_date_clinical_biobert',
                                                  'en.relation.drug_drug_interaction': 'redl_drug_drug_interaction_biobert',
                                                  'en.relation.drugprot': 'redl_drugprot_biobert',
                                                  'en.relation.drugprot.clinical': 're_drugprot_clinical',
                                                  'en.relation.humen_phenotype_gene': 'redl_human_phenotype_gene_biobert',
                                                  'en.relation.oncology.size_wip': 're_oncology_size_wip',
                                                  'en.relation.oncology.test_result': 're_oncology_test_result_wip',
                                                  'en.relation.oncology.test_result_biobert': 'redl_oncology_test_result_biobert_wip',
                                                  'en.relation.oncology_biobert_wip': 'redl_oncology_biobert_wip',
                                                  'en.relation.oncology_biomarker_result': 're_oncology_biomarker_result_wip',
                                                  'en.relation.oncology_biomarker_result_biobert_wip': 'redl_oncology_biomarker_result_biobert_wip',
                                                  'en.relation.oncology_granular_biobert_wip': 'redl_oncology_granular_biobert_wip',
                                                  'en.relation.oncology_granular_wip': 're_oncology_granular_wip',
                                                  'en.relation.oncology_location_biobert_wip': 'redl_oncology_location_biobert_wip',
                                                  'en.relation.oncology_location_wip': 're_oncology_location_wip',
                                                  'en.relation.oncology_size_biobert': 'redl_oncology_size_biobert_wip',
                                                  'en.relation.oncology_temporal_biobert_wip': 'redl_oncology_temporal_biobert_wip',
                                                  'en.relation.oncology_temporal_wip': 're_oncology_temporal_wip',
                                                  'en.relation.oncology_wip': 're_oncology_wip',
                                                  'en.relation.temporal_events': 'redl_temporal_events_biobert',
                                                  'en.relation.temporal_events_clinical': 're_temporal_events_clinical',
                                                  'en.relation.test_result_date': 're_test_result_date',
                                                  'en.relation.zeroshot': 'zero_shot_re',
                                                  'en.relation.zeroshot_biobert': 're_zeroshot_biobert',
                                                  'en.resolve': 'sbiobertresolve_cpt',
                                                  'en.resolve.HPO': 'sbiobertresolve_HPO',
                                                  'en.resolve.atc': 'sbiobertresolve_atc',
                                                  'en.resolve.clinical_abbreviation_acronym': 'sbiobertresolve_clinical_abbreviation_acronym',
                                                  'en.resolve.clinical_snomed_procedures_measurements': 'sbiobertresolve_clinical_snomed_procedures_measurements',
                                                  'en.resolve.cpt': 'sbiobertresolve_cpt',
                                                  'en.resolve.cpt.augmented': 'sbiobertresolve_cpt_augmented',
                                                  'en.resolve.cpt.procedures_augmented': 'sbiobertresolve_cpt_procedures_augmented',
                                                  'en.resolve.cpt.procedures_measurements': 'sbiobertresolve_cpt_procedures_measurements_augmented',
                                                  'en.resolve.cvx': 'sbiobertresolve_cvx',
                                                  'en.resolve.hcc': 'sbiobertresolve_hcc_augmented',
                                                  'en.resolve.hcc.augmented': 'sbiobertresolve_hcc_augmented',
                                                  'en.resolve.hcpcs': 'sbiobertresolve_hcpcs',
                                                  'en.resolve.ic9': 'sbiobertresolve_icd9',
                                                  'en.resolve.icd10cm': 'sbiobertresolve_icd10cm',
                                                  'en.resolve.icd10cm.augmented': 'sbiobertresolve_icd10cm_augmented',
                                                  'en.resolve.icd10cm.augmented_billable': 'sbiobertresolve_icd10cm_augmented_billable_hcc',
                                                  'en.resolve.icd10cm.slim_billable_hcc': 'sbiobertresolve_icd10cm_slim_billable_hcc',
                                                  'en.resolve.icd10cm.slim_billable_hcc_med': 'sbertresolve_icd10cm_slim_billable_hcc_med',
                                                  'en.resolve.icd10cm.slim_normalized': 'sbiobertresolve_icd10cm_slim_normalized',
                                                  'en.resolve.icd10cm_generalised': 'sbiobertresolve_icd10cm_generalised',
                                                  'en.resolve.icd10pcs': 'sbiobertresolve_icd10pcs',
                                                  'en.resolve.icd10pcs_augmented': 'sbiobertresolve_icd10pcs_augmented',
                                                  'en.resolve.icdo': 'sbiobertresolve_icdo',
                                                  'en.resolve.icdo.base': 'sbiobertresolve_icdo_base',
                                                  'en.resolve.icdo_augmented': 'sbiobertresolve_icdo_augmented',
                                                  'en.resolve.loinc': 'sbiobertresolve_loinc',
                                                  'en.resolve.loinc.augmented': 'sbiobertresolve_loinc_augmented',
                                                  'en.resolve.loinc.biobert': 'sbiobertresolve_loinc',
                                                  'en.resolve.loinc_cased': 'sbiobertresolve_loinc_cased',
                                                  'en.resolve.loinc_uncased': 'sbluebertresolve_loinc_uncased',
                                                  'en.resolve.mesh': 'sbiobertresolve_mesh',
                                                  'en.resolve.ndc': 'sbiobertresolve_ndc',
                                                  'en.resolve.ner.model_finder': 'sbertresolve_ner_model_finder',
                                                  'en.resolve.rxcui': 'sbiobertresolve_rxcui',
                                                  'en.resolve.rxnen.med_ner.deid_subentityorm_augmented': 'sbiobertresolve_rxnorm_augmented',
                                                  'en.resolve.rxnorm': 'sbiobertresolve_rxnorm',
                                                  'en.resolve.rxnorm.augmented': 'sbiobertresolve_jsl_rxnorm_augmented',
                                                  'en.resolve.rxnorm.augmented_cased': 'sbiobertresolve_rxnorm_augmented_cased',
                                                  'en.resolve.rxnorm.augmented_med': 'sbertresolve_jsl_rxnorm_augmented_med',
                                                  'en.resolve.rxnorm.augmented_re': 'sbiobertresolve_rxnorm_augmented_re',
                                                  'en.resolve.rxnorm.augmented_uncased': 'sbluebertresolve_rxnorm_augmented_uncased',
                                                  'en.resolve.rxnorm.disposition': 'sbertresolve_rxnorm_disposition',
                                                  'en.resolve.rxnorm.disposition.sbert': 'sbertresolve_rxnorm_disposition',
                                                  'en.resolve.rxnorm_action_treatment': 'sbiobertresolve_rxnorm_action_treatment',
                                                  'en.resolve.rxnorm_disposition': 'sbiobertresolve_rxnorm_disposition',
                                                  'en.resolve.rxnorm_disposition.sbert': 'sbertresolve_rxnorm_disposition',
                                                  'en.resolve.rxnorm_ndc': 'sbiobertresolve_rxnorm_ndc',
                                                  'en.resolve.snomed': 'sbiobertresolve_snomed_auxConcepts',
                                                  'en.resolve.snomed.aux_concepts': 'sbiobertresolve_snomed_auxConcepts',
                                                  'en.resolve.snomed.aux_concepts_int': 'sbiobertresolve_snomed_auxConcepts_int',
                                                  'en.resolve.snomed.findings': 'sbiobertresolve_snomed_findings',
                                                  'en.resolve.snomed.findings_aux_concepts': 'sbiobertresolve_snomed_findings_aux_concepts',
                                                  'en.resolve.snomed.findings_int': 'sbiobertresolve_snomed_findings_int',
                                                  'en.resolve.snomed.procedures_measurements': 'sbiobertresolve_snomed_procedures_measurements',
                                                  'en.resolve.snomed_body_structure': 'sbiobertresolve_snomed_bodyStructure',
                                                  'en.resolve.snomed_body_structure_med': 'sbertresolve_snomed_bodyStructure_med',
                                                  'en.resolve.snomed_conditions': 'sbertresolve_snomed_conditions',
                                                  'en.resolve.snomed_drug': 'sbiobertresolve_snomed_drug',
                                                  'en.resolve.umls': 'sbiobertresolve_umls_major_concepts',
                                                  'en.resolve.umls.findings': 'sbiobertresolve_umls_findings',
                                                  'en.resolve.umls_clinical_drugs': 'sbiobertresolve_umls_clinical_drugs',
                                                  'en.resolve.umls_disease_syndrome': 'sbiobertresolve_umls_disease_syndrome',
                                                  'en.resolve.umls_drug_substance': 'sbiobertresolve_umls_drug_substance',
                                                  'en.rxnorm_to_ndc': 'rxnorm_ndc_mapper',
                                                  'en.rxnorm_to_umls': 'rxnorm_umls_mapper',
                                                  'en.snomed_to_icd10cm': 'snomed_icd10cm_mapper',
                                                  'en.snomed_to_icdo': 'snomed_icdo_mapper',
                                                  'en.snomed_to_umls': 'snomed_umls_mapper',
                                                  'en.spell.clinical': 'spellcheck_clinical',
                                                  'en.spell.drug_norvig': 'spellcheck_drug_norvig',
                                                  'en.t5.base_pubmedqa': 't5_base_pubmedqa',
                                                  'en.t5.mediqa': 't5_base_mediqa_mnli',
                                                  'en.zero_shot.ner_roberta': 'zero_shot_ner_roberta',
                                                  'es.embed.roberta_base_biomedical': 'roberta_base_biomedical',
                                                  'es.med_ner.roberta_ner_diag_proc': 'roberta_ner_diag_proc',
                                                  'es.resolve.snomed': 'robertaresolve_snomed'},
                                              'es': {
                                                  'es.classify.bert_token.clinical_trials_abstract': 'bert_token_classifier_ner_clinical_trials_abstracts',
                                                  'es.classify.bert_token.negation_uncertainty': 'bert_token_classifier_negation_uncertainty',
                                                  'es.classify.bert_token.ner_living_species': 'bert_token_classifier_ner_living_species',
                                                  'es.classify.bert_token.pharmacology': 'bert_token_classifier_pharmacology',
                                                  'es.classify.disease_mentions': 'bert_token_classifier_disease_mentions_tweet',
                                                  'es.classify.self_reported_symptoms': 'bert_sequence_classifier_self_reported_symptoms_tweet',
                                                  'es.embed.roberta_base_biomedical': 'roberta_base_biomedical',
                                                  'es.embed.scielo.150d': 'embeddings_scielo_150d',
                                                  'es.embed.scielo.300d': 'embeddings_scielo_300d',
                                                  'es.embed.scielo.50d': 'embeddings_scielo_50d',
                                                  'es.embed.scielo300d': 'embeddings_scielo_300d',
                                                  'es.embed.scielowiki.150d': 'embeddings_scielowiki_150d',
                                                  'es.embed.scielowiki.300d': 'embeddings_scielowiki_300d',
                                                  'es.embed.scielowiki.50d': 'embeddings_scielowiki_50d',
                                                  'es.embed.sciwiki.150d': 'embeddings_sciwiki_150d',
                                                  'es.embed.sciwiki.300d': 'embeddings_sciwiki_300d',
                                                  'es.embed.sciwiki.50d': 'embeddings_sciwiki_50d',
                                                  'es.embed.sciwiki_300d': 'embeddings_sciwiki_300d',
                                                  'es.med_ner': 'ner_diag_proc',
                                                  'es.med_ner.clinical_trial_abstracts': 'ner_clinical_trials_abstracts',
                                                  'es.med_ner.deid.generic': 'ner_deid_generic',
                                                  'es.med_ner.deid.generic.roberta': 'ner_deid_generic_roberta_augmented',
                                                  'es.med_ner.deid.generic_augmented': 'ner_deid_generic_augmented',
                                                  'es.med_ner.deid.generic_roberta': 'ner_deid_generic_roberta',
                                                  'es.med_ner.deid.subentity': 'ner_deid_subentity',
                                                  'es.med_ner.deid.subentity.roberta': 'ner_deid_subentity_roberta_augmented',
                                                  'es.med_ner.deid.subentity_augmented': 'ner_deid_subentity_augmented',
                                                  'es.med_ner.deid.subentity_roberta': 'ner_deid_subentity_roberta',
                                                  'es.med_ner.diag_proc': 'ner_diag_proc',
                                                  'es.med_ner.living_species': 'ner_living_species',
                                                  'es.med_ner.living_species.300': 'ner_living_species_300',
                                                  'es.med_ner.living_species.bert': 'ner_living_species_bert',
                                                  'es.med_ner.living_species.roberta': 'ner_living_species_roberta',
                                                  'es.med_ner.negtaion_uncertainty': 'ner_negation_uncertainty',
                                                  'es.med_ner.neoplasm': 'ner_neoplasms',
                                                  'es.med_ner.pharmacology': 'ner_pharmacology',
                                                  'es.med_ner.roberta_ner_diag_proc': 'roberta_ner_diag_proc',
                                                  'es.med_ner.scielowiki': 'meddroprof_scielowiki',
                                                  'es.med_ner.tweet_disease_mention': 'disease_mentions_tweet',
                                                  'es.resolve.snomed': 'robertaresolve_snomed'},
                                              'fr': {'fr.med_ner.deid_generic': 'ner_deid_generic',
                                                     'fr.med_ner.deid_subentity': 'ner_deid_subentity',
                                                     'fr.med_ner.living_species': 'ner_living_species',
                                                     'fr.med_ner.living_species.bert': 'ner_living_species_bert'},
                                              'gl': {'gl.med_ner.living_species': 'ner_living_species'},
                                              'it': {
                                                  'it.classify.bert_token.ner_living_species': 'bert_token_classifier_ner_living_species',
                                                  'it.med_ner.deid_generic': 'ner_deid_generic',
                                                  'it.med_ner.deid_subentity': 'ner_deid_subentity',
                                                  'it.med_ner.living_species': 'ner_living_species',
                                                  'it.med_ner.living_species.bert': 'ner_living_species_bert'},
                                              'pt': {'pt.med_ner.deid': 'ner_deid_generic',
                                                     'pt.med_ner.deid.generic': 'ner_deid_generic',
                                                     'pt.med_ner.deid.subentity': 'ner_deid_subentity',
                                                     'pt.med_ner.living_species': 'ner_living_species',
                                                     'pt.med_ner.living_species.bert': 'ner_living_species_bert',
                                                     'pt.med_ner.living_species.roberta': 'ner_living_species_roberta',
                                                     'pt.med_ner.living_species.token_bert': 'bert_token_classifier_ner_living_species'},
                                              'ro': {'ro.embed.clinical.bert.base_cased': 'ner_clinical_bert',
                                                     'ro.med_ner.clinical': 'ner_clinical',
                                                     'ro.med_ner.deid.subentity': 'ner_deid_subentity',
                                                     'ro.med_ner.deid.subentity.bert': 'ner_deid_subentity_bert',
                                                     'ro.med_ner.deid_generic': 'ner_deid_generic',
                                                     'ro.med_ner.deid_generic_bert': 'ner_deid_generic_bert',
                                                     'ro.med_ner.living_species.bert': 'ner_living_species_bert'}}
    ocr_model_references = {
        'img2text': OCR_NODE_IDS.IMAGE2TEXT,
        'png2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'jpg2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'pdf2text': OCR_NODE_IDS.PDF2TEXT,
        'doc2text': OCR_NODE_IDS.DOC2TEXT,

        'pdf2table': OCR_NODE_IDS.PDF2TEXT_TABLE,
        'doc2table': OCR_NODE_IDS.DOC2TEXT_TABLE,
        'ppt2table': OCR_NODE_IDS.PPT2TEXT_TABLE,
        'classify.image': OCR_NODE_IDS.VISUAL_DOCUMENT_CLASSIFIER,
        'en.classify_image.tabacco': 'visual_document_classifier_tobacco3482'
    }

    ocr_model_references = {
        'img2text': OCR_NODE_IDS.IMAGE2TEXT,
        'png2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'jpg2text': OCR_NODE_IDS.IMAGE2TEXT,  # Alias for img2text
        'pdf2text': OCR_NODE_IDS.PDF2TEXT,
        'doc2text': OCR_NODE_IDS.DOC2TEXT,

        'pdf2table': OCR_NODE_IDS.PDF2TEXT_TABLE,
        'doc2table': OCR_NODE_IDS.DOC2TEXT_TABLE,
        'ppt2table': OCR_NODE_IDS.PPT2TEXT_TABLE,
        'classify.image': OCR_NODE_IDS.VISUAL_DOCUMENT_CLASSIFIER,
        'en.classify_image.tabacco': 'visual_document_classifier_tobacco3482'
    }
    # map storage ref to nlu refner_jsl
    storage_ref_2_nlu_ref = {'ar': {'glove_300d': 'ar.embed'},
                             'bn': {'bengali_cc_300d': 'bn.embed.glove',
                                    'glove_840B_300': 'xx.embed.glove.840B_300'},
                             'da': {'glove_100d': 'xx.embed.glove.glove_6B_100'},
                             'de': {'clinical': 'de.embed_sentence.bert.base_cased',
                                    'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300',
                                    'labse': 'xx.embed_sentence.labse',
                                    'sent_bert_base_cased': 'de.embed_sentence.bert.base_cased',
                                    'sent_bert_multi_cased': 'xx.embed_sentence',
                                    'w2v_cc_300d': 'de.embed.w2v'},
                             'en': {'albert_base_uncased': 'en.embed_sentence.albert',
                                    'albert_large_uncased': 'en.embed.albert.large_uncased',
                                    'bert_large_cased': 'en.embed.bert.large_cased',
                                    'biobert_pubmed_base_cased': 'en.embed.biobert',
                                    'distilbert_base_cased': 'en.embed.distilbert.base',
                                    'electra_base_uncased': 'en.embed.electra.base_uncased',
                                    'electra_large_uncased': 'en.embed.electra.large_uncased',
                                    'electra_small_uncased': 'en.embed.electra.small_uncased',
                                    'elmo': 'en.embed.elmo',
                                    'glove_100d': 'en.embed.glove.100d',
                                    'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300',
                                    'longformer_large_4096': 'en.embed.longformer.large',
                                    'roberta_base': 'en.embed.roberta.base',
                                    'roberta_large': 'en.embed.roberta.large',
                                    'sent_biobert_pubmed_base_cased': 'en.embed_sentence.biobert.pubmed_base_cased',
                                    'small_bert_L2_128': 'en.embed.bert.small_L2_128',
                                    'small_bert_L4_256': 'en.embed.bert.small_L4_256',
                                    'small_bert_L4_512': 'en.embed.bert.small_L4_512',
                                    'small_bert_L8_512': 'en.embed.bert.small_L8_512',
                                    'tfhub_use': 'en.embed_sentence.use',
                                    'xlm_roberta_base': 'xx.embed.xlm',
                                    'xlm_roberta_xtreme_base': 'xx.embed.xlm_roberta_xtreme_base',
                                    'xlnet_base_cased': 'en.embed.xlnet_base_cased'},
                             'es': {'embeddings_scielo300': 'es.embed.scielo300',
                                    'es.ner': 'roberta_token_classifier_bne_capitel_ner',
                                    'glove_100d': 'xx.embed.glove.glove_6B_100',
                                    'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300',
                                    'w2v_cc_300d_es': 'es.embed.w2v_cc_300d'},
                             'fa': {'glove_300d': 'fa.embed'},
                             'fi': {'glove_100d': 'xx.embed.glove.glove_6B_100',
                                    'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300'},
                             'fr': {'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300',
                                    'labse': 'xx.embed_sentence.labse'},
                             'he': {'glove_300d': 'he.embed'},
                             'it': {'glove_6B_300': 'xx.embed.glove.6B_300'},
                             'ja': {'fasttext_300_ja': 'ja.embed.glove.cc_300d',
                                    'glove_840B_300': 'xx.embed.glove.840B_300',
                                    'xlm_roberta_base': 'xx.embed.xlm'},
                             'nl': {'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300'},
                             'no': {'glove_100d': 'xx.embed.glove.glove_6B_100',
                                    'glove_6B_300': 'xx.embed.glove.6B_300',
                                    'glove_840B_300': 'xx.embed.glove.840B_300'},
                             'pl': {'glove_100d': 'xx.embed.glove.glove_6B_100'},
                             'pt': {'glove_100d': 'xx.embed.glove.glove_6B_100',
                                    'glove_840B_300': 'xx.embed.glove.840B_300'},
                             'ro': {'bert_base_cased_v1': 'ro.embed.bert.cased_base',
                                    'w2v_cc_300d_ro': 'ro.embed.w2v_cc_300d'},
                             'ru': {'glove_100d': 'xx.embed.glove.glove_6B_100',
                                    'glove_840B_300': 'xx.embed.glove.840B_300'},
                             'sv': {'glove_100d': 'xx.embed.glove.glove_6B_100',
                                    'glove_6B_300': 'xx.embed.glove.6B_300'},
                             'th': {'labse': 'xx.embed_sentence.labse',
                                    'tfhub_use_multi_lg': 'xx.use.multi'},
                             'tr': {'bert_base_turkish_uncased': 'tr.embed.bert.uncased',
                                    'bert_multi_cased': 'xx.embed.bert',
                                    'glove_840B_300': 'xx.embed.glove.840B_300',
                                    'labse': 'xx.embed_sentence.labse'},
                             'ur': {'glove_300d': 'ur.embed', 'labse': 'xx.embed_sentence.labse'},
                             'zh': {'bert_base_chinese': 'zh.embed',
                                    'glove_6B_300': 'xx.embed.glove.6B_300'}}

    bad_storage_refs = [

        'BERT_SENTENCE_EMBEDDINGS_c7e5b6a772f5',
        'RelationExtractionModel_ce79d77d1bf1',
        'RelationExtractionModel_1fb1dfa024c7',
        'RelationExtractionModel_6a65c9992836',
        'BERT_SENTENCE_EMBEDDINGS_0bee53f1b2cc',
        'BERT_SENTENCE_EMBEDDINGS_59c3cd1e17c4',
        'RelationExtractionModel_3ab4750ad5b6',
        'RelationExtractionModel_6b61602c8303',
        'RelationExtractionModel_9c255241fec3',
        'ROBERTA_EMBEDDINGS_39f3e48e5c3f',
        'RelationExtractionModel_14b00157fc1a',
        'RelationExtractionModel_53a12cc975cb',
        'ROBERTA_EMBEDDINGS_39f3e48e5c3f',

    ]
    licensed_storage_ref_2_nlu_ref = {'ca': {'w2v_cc_300d_ca': 'ca.embed.w2v_cc_300d'},
                                      'de': {'clinical': 'de.embed_sentence.bert.base_cased',
                                             'w2v_cc_300d': 'de.embed'},
                                      'en': {'BERT_SENTENCE_EMBEDDINGS_0bee53f1b2cc': 'en.embed_sentence.biobert.mli',
                                             'BERT_SENTENCE_EMBEDDINGS_33904e9f754a': 'en.embed_sentence.bert_uncased.rxnorm',
                                             'BERT_SENTENCE_EMBEDDINGS_59c3cd1e17c4': 'en.embed_sentence.bluebert.mli',
                                             'BERT_SENTENCE_EMBEDDINGS_76a84231a63f': 'en.embed_sentence.biobert.rxnorm',
                                             'BERT_SENTENCE_EMBEDDINGS_c7e5b6a772f5': 'en.embed_sentence.bert.jsl_medium_uncased',
                                             'BERT_SENTENCE_EMBEDDINGS_f67c6fa21fe5': 'en.embed_sentence.biobert.jsl_cased',
                                             'ROBERTA_EMBEDDINGS_39f3e48e5c3f': 'en.embed_sentence.biobert.clinical_base_cased',
                                             'RelationExtractionModel_14b00157fc1a': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_189543bacd6e': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_1fb1dfa024c7': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_3ab4750ad5b6': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_513eb6317779': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_53a12cc975cb': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_68ebe11369b6': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_6a65c9992836': 'en.embed.biobert',
                                             'RelationExtractionModel_6b61602c8303': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_723addf4b6aa': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_7bb24c4f22d1': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_9c255241fec3': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_ab6e5ebef610': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_bc96a0f8b566': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_ce79d77d1bf1': 'en.embed.glove.clinical',
                                             'RelationExtractionModel_d0af74510daa': 'en.embed.glove.clinical',
                                             'bert_base_cased': 'en.embed.bert.base_cased',
                                             'bert_embeddings_PHS_BERT': 'en.embed.bert_phs',
                                             'biobert_clinical_base_cased': 'en.embed.biobert.clinical_base_cased',
                                             'biobert_pubmed_base_cased': 'en.embed.biobert',
                                             'clinical': 'en.embed.glove.clinical',
                                             'embeddings_healthcare100': 'en.embed.glove.healthcare_100d',
                                             'sent_biobert_clinical_base_cased': 'en.embed_sentence.biobert.clinical_base_cased',
                                             'sent_bluebert_base_uncased_mednli': 'en.embed_sentence.bluebert.mli'},
                                      'es': {'ROBERTA_EMBEDDINGS_39f3e48e5c3f': 'es.embed.roberta_base_biomedical',
                                             'bert_base_cased_es': 'es.embed.bert.base_cased',
                                             'clinical': 'es.embed.roberta_base_biomedical',
                                             'embeddings_scielo300': 'es.embed.scielo300',
                                             'embeddings_scielowiki300': 'es.embed.scielowiki.300d',
                                             'embeddings_wiki300': 'es.embed.sciwiki_300d'},
                                      'fr': {'WordEmbeddings_b266d1e5126a': 'fr.embed.w2v_cc_300d',
                                             'bert_embeddings_bert_base_fr_cased_fr': 'fr.embed.bert_base_fr_cased'},
                                      'gl': {'w2v_cc_300d_gl': 'gl.embed.w2v_cc_300d'},
                                      'it': {
                                          'bert_embeddings_bert_base_italian_xxl_cased_it': 'it.embed.bert_base_italian_xxl_cased',
                                          'w2v_cc_300d_it': 'it.embed.word2vec'},
                                      'pt': {'biobert_embeddings_biomedical_pt': 'pt.embed.gs_biomedical',
                                             'roberta_embeddings_BR_BERTo_pt': 'pt.embed.BR_BERTo',
                                             'w2v_cc_300d_pt': 'pt.embed.w2v_cc_300d'},
                                      'ro': {'bert_base_cased_v1': 'ro.embed.bert.base_cased',
                                             'w2v_cc_300d_ro': 'ro.embed.w2v_cc_300d'}}

    # Map NLU train references to JSL Anno IDs
    traianble_nlu_ref_to_jsl_anno_id = {
        'train.deep_sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.sentence_detector': NLP_NODE_IDS.TRAINABLE_SENTENCE_DETECTOR_DL,
        'train.classifier_dl': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.classifier': NLP_NODE_IDS.TRAINABLE_CLASSIFIER_DL,
        'train.ner': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.named_entity_recognizer_dl': NLP_NODE_IDS.TRAINABLE_NER_DL,
        'train.sentiment_dl': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.sentiment': NLP_NODE_IDS.TRAINABLE_SENTIMENT_DL,
        'train.pos': NLP_NODE_IDS.TRAINABLE_POS,
        'train.multi_classifier': NLP_NODE_IDS.TRAINABLE_MULTI_CLASSIFIER_DL,
        'train.word_seg': NLP_NODE_IDS.TRAINABLE_WORD_SEGMENTER,
        'train.word_segmenter': NLP_NODE_IDS.TRAINABLE_WORD_SEGMENTER,
        'train.generic_classifier': NLP_HC_NODE_IDS.TRAINABLE_GENERIC_CLASSIFIER,
        'train.resolve_sentence': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.resolve': NLP_HC_NODE_IDS.TRAINABLE_SENTENCE_ENTITY_RESOLVER,
        'train.assertion': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assert': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,
        'train.assertion_dl': NLP_HC_NODE_IDS.TRAINABLE_ASSERTION_DL,

    }

    # Map every nlp_ref to an Annotator class. Language Agnostic and includes HC+OS
    # For models with no pretrained weight, i.e. most OCR annotators, it maps AnnoId to Class

    nlp_ref_to_anno_class = {'abbreviation_category_mapper': 'ChunkMapperModel',
                             'abbreviation_mapper': 'ChunkMapperModel',
                             'abbreviation_mapper_augmented': 'ChunkMapperModel',
                             'albert_base_qa_squad2': 'AlbertForQuestionAnswering',
                             'albert_base_sequence_classifier_ag_news': 'AlbertForSequenceClassification',
                             'albert_base_sequence_classifier_imdb': 'AlbertForSequenceClassification',
                             'albert_base_token_classifier_conll03': 'AlbertForTokenClassification',
                             'albert_base_uncased': 'AlbertEmbeddings',
                             'albert_embeddings_ALR_BERT': 'AlbertEmbeddings',
                             'albert_embeddings_albert_base_arabic': 'AlbertEmbeddings',
                             'albert_embeddings_albert_base_bahasa_cased': 'AlbertEmbeddings',
                             'albert_embeddings_albert_base_japanese_v1': 'AlbertEmbeddings',
                             'albert_embeddings_albert_base_v1': 'AlbertEmbeddings',
                             'albert_embeddings_albert_fa_base_v2': 'AlbertEmbeddings',
                             'albert_embeddings_albert_fa_zwnj_base_v2': 'AlbertEmbeddings',
                             'albert_embeddings_albert_german_ner': 'AlbertEmbeddings',
                             'albert_embeddings_albert_large_arabic': 'AlbertEmbeddings',
                             'albert_embeddings_albert_large_bahasa_cased': 'AlbertEmbeddings',
                             'albert_embeddings_albert_tiny_bahasa_cased': 'AlbertEmbeddings',
                             'albert_embeddings_albert_xlarge_arabic': 'AlbertEmbeddings',
                             'albert_embeddings_albert_xlarge_v1': 'AlbertEmbeddings',
                             'albert_embeddings_albert_xxlarge_v1': 'AlbertEmbeddings',
                             'albert_embeddings_fralbert_base': 'AlbertEmbeddings',
                             'albert_embeddings_marathi_albert': 'AlbertEmbeddings',
                             'albert_embeddings_marathi_albert_v2': 'AlbertEmbeddings',
                             'albert_indic': 'AlbertEmbeddings',
                             'albert_large_token_classifier_conll03': 'AlbertForTokenClassification',
                             'albert_large_uncased': 'AlbertEmbeddings',
                             'albert_qa_BioM_xxlarge_SQuAD2': 'AlbertForQuestionAnswering',
                             'albert_qa_QA_1e': 'AlbertForQuestionAnswering',
                             'albert_qa_ai_club_inductions_21_nlp': 'AlbertForQuestionAnswering',
                             'albert_qa_base_v2_squad': 'AlbertForQuestionAnswering',
                             'albert_qa_cs224n_squad2.0_base_v2': 'AlbertForQuestionAnswering',
                             'albert_qa_cs224n_squad2.0_large_v2': 'AlbertForQuestionAnswering',
                             'albert_qa_cs224n_squad2.0_xxlarge_v1': 'AlbertForQuestionAnswering',
                             'albert_qa_generic': 'AlbertForQuestionAnswering',
                             'albert_qa_nlpunibo': 'AlbertForQuestionAnswering',
                             'albert_qa_slp': 'AlbertForQuestionAnswering',
                             'albert_qa_squad_2.0': 'AlbertForQuestionAnswering',
                             'albert_qa_squad_slp': 'AlbertForQuestionAnswering',
                             'albert_qa_vumichien_base_v2_squad2': 'AlbertForQuestionAnswering',
                             'albert_qa_xlarge_finetuned': 'AlbertForQuestionAnswering',
                             'albert_qa_xlarge_finetuned_squad': 'AlbertForQuestionAnswering',
                             'albert_qa_xlarge_v2_squad_v2': 'AlbertForQuestionAnswering',
                             'albert_qa_xxlarge_finetuned_squad': 'AlbertForQuestionAnswering',
                             'albert_qa_xxlarge_tweetqa': 'AlbertForQuestionAnswering',
                             'albert_qa_xxlarge_v1_finetuned_squad2': 'AlbertForQuestionAnswering',
                             'albert_qa_xxlarge_v2_squad2': 'AlbertForQuestionAnswering',
                             'albert_qa_xxlarge_v2_squad2_covid_deepset': 'AlbertForQuestionAnswering',
                             'albert_qa_xxlargev1_squad2_512': 'AlbertForQuestionAnswering',
                             'albert_xlarge_token_classifier_conll03': 'AlbertForTokenClassification',
                             'albert_xlarge_uncased': 'AlbertEmbeddings',
                             'albert_xxlarge_uncased': 'AlbertEmbeddings',
                             'aner_cc_300d': 'NerDLModel',
                             'arabic_w2v_cc_300d': 'WordEmbeddingsModel',
                             'asr_20220507_122935': 'Wav2Vec2ForCTC',
                             'asr_ai_light_dance_singing2_wav2vec2_large_xlsr_53_5gram_v4_2': 'Wav2Vec2ForCTC',
                             'asr_ai_light_dance_singing2_wav2vec2_large_xlsr_53_5gram_v4_2_gpu': 'Wav2Vec2ForCTC',
                             'asr_alvenir_wav2vec2_base_nst_cv9': 'Wav2Vec2ForCTC',
                             'asr_asr_with_transformers_wav2vec2': 'Wav2Vec2ForCTC',
                             'asr_asr_with_transformers_wav2vec2_gpu': 'Wav2Vec2ForCTC',
                             'asr_autonlp_hindi_asr': 'Wav2Vec2ForCTC',
                             'asr_autonlp_hindi_asr_gpu': 'Wav2Vec2ForCTC',
                             'asr_av2vec2_xls_r_300m_wolof_lm': 'Wav2Vec2ForCTC',
                             'asr_av2vec2_xls_r_300m_wolof_lm_gpu': 'Wav2Vec2ForCTC',
                             'asr_bach_arb': 'Wav2Vec2ForCTC',
                             'asr_bach_arb_gpu': 'Wav2Vec2ForCTC',
                             'asr_baseline': 'Wav2Vec2ForCTC',
                             'asr_baseline_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp500_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp500_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp_commonvoice100_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp_commonvoice100_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp_commonvoice10_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp_commonvoice10_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp_lapsbm1_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp_lapsbm1_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp_sid10_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp_sid10_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp_tedx100_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp_tedx100_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_bp_voxforge1_xlsr': 'Wav2Vec2ForCTC',
                             'asr_bp_voxforge1_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_cdac_hindispeechrecognition': 'Wav2Vec2ForCTC',
                             'asr_cdac_hindispeechrecognition_gpu': 'Wav2Vec2ForCTC',
                             'asr_central_kurdish_xlsr': 'Wav2Vec2ForCTC',
                             'asr_central_kurdish_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_common_voice_lithuanian_fairseq': 'Wav2Vec2ForCTC',
                             'asr_common_voice_lithuanian_fairseq_gpu': 'Wav2Vec2ForCTC',
                             'asr_dansk_wav2vec21': 'Wav2Vec2ForCTC',
                             'asr_dansk_wav2vec21_gpu': 'Wav2Vec2ForCTC',
                             'asr_dansk_wav2vec2_stt': 'Wav2Vec2ForCTC',
                             'asr_dansk_wav2vec2_stt_gpu': 'Wav2Vec2ForCTC',
                             'asr_distil_wav2vec2': 'Wav2Vec2ForCTC',
                             'asr_distil_wav2vec2_gpu': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_03': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_04': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_05': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_05_gpu': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_06': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_07': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_07_gpu': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_09': 'Wav2Vec2ForCTC',
                             'asr_english_filipino_wav2vec2_l_xls_r_test_09_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_france_10_belgium_0_s271': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_france_10_belgium_0_s271_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_france_2_belgium_8_s709': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_france_2_belgium_8_s709_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_france_5_belgium_5_s607': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_france_5_belgium_5_s607_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s103': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s103_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s377': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s377_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s756': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_0_austria_10_s756_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s527': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s527_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s545': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s545_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s779': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_10_austria_0_s779_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s468': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s468_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s732': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s732_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s957': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_2_austria_8_s957_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s3': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s3_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s803': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s803_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s95': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_5_austria_5_s95_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_8_austria_2_s445': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_accent_germany_8_austria_2_s445_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s400': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s400_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s469': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s469_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s934': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_0_female_10_s934_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s156': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s156_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s626': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s626_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s714': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_10_female_0_s714_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s255': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s255_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s3': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_2_female_8_s3_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s21': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s21_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s474': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s474_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s722': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_5_female_5_s722_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s428': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s428_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s500': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s500_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s911': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_vp_100k_gender_male_8_female_2_s911_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s350': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s350_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s381': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s381_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s673': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_0_austria_10_s673_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s295': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s728': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s728_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s886': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_10_austria_0_s886_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s368': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s458': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s458_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s543': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_2_austria_8_s543_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s412': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s412_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s534': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_5_austria_5_s534_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_8_austria_2_s42': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_accent_germany_8_austria_2_s42_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_0_female_10_s922': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s204': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s204_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s287': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s287_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s559': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_10_female_0_s559_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_2_female_8_s295': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_2_female_8_s295_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_5_female_5_s896': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_5_female_5_s896_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_8_female_2_s755': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2r_xls_r_gender_male_8_female_2_s755_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s117_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s208_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s28_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s461_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s615_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s650_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s764_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s766_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s842_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_pretraining_s929_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s251': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s251_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s317': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s317_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s37': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s37_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s456': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s456_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s459': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s459_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s460': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s460_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s466': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s466_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s578': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s578_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s646': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_r_wav2vec2_s646_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s149': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s149_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s358': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s358_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s407': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s407_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s408': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s408_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s449': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s449_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s509': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s509_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s615': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s615_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s627': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s627_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s645': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s645_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s660': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s660_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s688': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s688_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s69': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s69_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s764': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s764_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s772': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s772_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s842': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s842_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s88': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s88_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s899': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s899_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s973': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_100k_s973_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s149': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s149_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s165': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s165_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s169': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s169_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s179': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s179_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s184': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s198': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s198_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s1_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s203': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s203_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s222': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s222_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s224': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s224_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s27': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s27_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s281': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s281_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s282': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s282_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s320': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s320_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s324': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s324_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s335': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s335_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s339': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s339_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s33_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s376': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s376_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s411': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s411_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s419': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s419_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s438': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s438_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s496': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s496_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s510': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s510_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s533': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s533_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s555': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s555_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s557': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s557_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s579': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s579_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s596': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s596_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s607': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s607_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s689': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s689_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s703': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s703_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s738': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s738_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s749': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s749_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s791': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s791_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s821': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s821_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s875': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s875_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s877': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s877_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s878': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s878_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s946': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s962': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s962_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s965': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_vp_s965_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s156': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s156_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s168': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s168_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s211': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s211_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s226': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s226_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s227': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s227_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s250': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s250_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s321': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s321_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s379': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s379_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s417': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s417_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s515': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s515_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s609': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s609_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s692': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s692_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s721': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s721_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s754': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s754_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s809': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s809_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s859': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s859_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s870': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s870_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s982': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_wav2vec2_s982_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s143': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s143_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s226': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s226_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s250': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s250_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s417': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s417_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s438': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s438_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s44': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xls_r_s44_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s116': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s116_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s204': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s204_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s237': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s237_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s286': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s286_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s356': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s356_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s387': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s387_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s449': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s449_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s454': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s454_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s539': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s539_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s677': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s677_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s799': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s799_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s79_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s800': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s800_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s948': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s948_gpu': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s972': 'Wav2Vec2ForCTC',
                             'asr_exp_w2v2t_xlsr_53_s972_gpu': 'Wav2Vec2ForCTC',
                             'asr_filipino_wav2vec2_l_xls_r_300m_official': 'Wav2Vec2ForCTC',
                             'asr_filipino_wav2vec2_l_xls_r_300m_official_gpu': 'Wav2Vec2ForCTC',
                             'asr_final_wav2vec2_urdu_asr_project': 'Wav2Vec2ForCTC',
                             'asr_fine_tune_wav2vec2_xls_r_300m_indonesia': 'Wav2Vec2ForCTC',
                             'asr_fine_tune_wav2vec2_xls_r_300m_indonesia_gpu': 'Wav2Vec2ForCTC',
                             'asr_fine_tune_xlsr_wav2vec2_speech2text_vietnamese': 'Wav2Vec2ForCTC',
                             'asr_fine_tune_xlsr_wav2vec2_speech2text_vietnamese_gpu': 'Wav2Vec2ForCTC',
                             'asr_fine_tuned_xlsr_english': 'Wav2Vec2ForCTC',
                             'asr_fine_tuned_xlsr_english_gpu': 'Wav2Vec2ForCTC',
                             'asr_fine_tunning_on_cv_dataset': 'Wav2Vec2ForCTC',
                             'asr_fine_tunning_on_cv_dataset_gpu': 'Wav2Vec2ForCTC',
                             'asr_finetuned_audio_transcriber': 'Wav2Vec2ForCTC',
                             'asr_fonxlsr': 'Wav2Vec2ForCTC',
                             'asr_fonxlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_greek_lsr_1': 'Wav2Vec2ForCTC',
                             'asr_hausa_4_wa2vec_data_aug_xls_r_300m': 'Wav2Vec2ForCTC',
                             'asr_hausa_4_wa2vec_data_aug_xls_r_300m_gpu': 'Wav2Vec2ForCTC',
                             'asr_hausa_xlsr': 'Wav2Vec2ForCTC',
                             'asr_hausa_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_hf_challenge_test': 'Wav2Vec2ForCTC',
                             'asr_hf_challenge_test_gpu': 'Wav2Vec2ForCTC',
                             'asr_hindi_base_wav2vec2': 'Wav2Vec2ForCTC',
                             'asr_hindi_base_wav2vec2_gpu': 'Wav2Vec2ForCTC',
                             'asr_hindi_clsril_100': 'Wav2Vec2ForCTC',
                             'asr_hindi_clsril_100_gpu': 'Wav2Vec2ForCTC',
                             'asr_hindi_large_wav2vec2': 'Wav2Vec2ForCTC',
                             'asr_hindi_large_wav2vec2_gpu': 'Wav2Vec2ForCTC',
                             'asr_hindi_model_with_lm_vakyansh': 'Wav2Vec2ForCTC',
                             'asr_hindi_model_with_lm_vakyansh_gpu': 'Wav2Vec2ForCTC',
                             'asr_iloko': 'Wav2Vec2ForCTC',
                             'asr_iloko_gpu': 'Wav2Vec2ForCTC',
                             'asr_indicwav2vec_hindi': 'Wav2Vec2ForCTC',
                             'asr_indicwav2vec_hindi_gpu': 'Wav2Vec2ForCTC',
                             'asr_indicwav2vec_v1_bengali': 'Wav2Vec2ForCTC',
                             'asr_indicwav2vec_v1_bengali_gpu': 'Wav2Vec2ForCTC',
                             'asr_iwslt_asr_wav2vec_large_4500h': 'Wav2Vec2ForCTC',
                             'asr_iwslt_asr_wav2vec_large_4500h_gpu': 'Wav2Vec2ForCTC',
                             'asr_kabyle_xlsr': 'Wav2Vec2ForCTC',
                             'asr_kabyle_xlsr_gpu': 'Wav2Vec2ForCTC',
                             'asr_liepa_lithuanian': 'Wav2Vec2ForCTC',
                             'asr_liepa_lithuanian_gpu': 'Wav2Vec2ForCTC',
                             'asr_lm_swedish': 'Wav2Vec2ForCTC',
                             'asr_maialong_model': 'Wav2Vec2ForCTC',
                             'asr_maialong_model_gpu': 'Wav2Vec2ForCTC',
                             'asr_model_2': 'Wav2Vec2ForCTC',
                             'asr_model_2_gpu': 'Wav2Vec2ForCTC',
                             'asr_model_4': 'Wav2Vec2ForCTC',
                             'asr_model_4_gpu': 'Wav2Vec2ForCTC',
                             'asr_model_sid_voxforge_cetuc_1': 'Wav2Vec2ForCTC',
                             'asr_model_sid_voxforge_cetuc_1_gpu': 'Wav2Vec2ForCTC',
                             'asr_model_sid_voxforge_cetuc_2': 'Wav2Vec2ForCTC',
                             'asr_models_6': 'Wav2Vec2ForCTC',
                             'asr_models_6_gpu': 'Wav2Vec2ForCTC',
                             'asr_part1': 'Wav2Vec2ForCTC',
                             'asr_part1_gpu': 'Wav2Vec2ForCTC',
                             'asr_personal_speech_text_model': 'Wav2Vec2ForCTC',
                             'asr_personal_speech_text_model_gpu': 'Wav2Vec2ForCTC',
                             'asr_processor_with_lm': 'Wav2Vec2ForCTC',
                             'asr_processor_with_lm_gpu': 'Wav2Vec2ForCTC',
                             'asr_quran_speech_recognizer': 'Wav2Vec2ForCTC',
                             'asr_quran_speech_recognizer_gpu': 'Wav2Vec2ForCTC',
                             'asr_romanian_wav2vec2': 'Wav2Vec2ForCTC',
                             'asr_romanian_wav2vec2_gpu': 'Wav2Vec2ForCTC',
                             'asr_sanskrit': 'Wav2Vec2ForCTC',
                             'asr_sanskrit_gpu': 'Wav2Vec2ForCTC',
                             'asr_sp_proj': 'Wav2Vec2ForCTC',
                             'asr_sp_proj_gpu': 'Wav2Vec2ForCTC',
                             'asr_speech_sprint_test': 'Wav2Vec2ForCTC',
                             'asr_temp': 'Wav2Vec2ForCTC',
                             'asr_temp_gpu': 'Wav2Vec2ForCTC',
                             'asr_test_by_marma': 'Wav2Vec2ForCTC',
                             'asr_test_by_marma_gpu': 'Wav2Vec2ForCTC',
                             'asr_urdu_asr': 'Wav2Vec2ForCTC',
                             'asr_urdu_asr_gpu': 'Wav2Vec2ForCTC',
                             'asr_urdu_repo': 'Wav2Vec2ForCTC',
                             'asr_urdu_repo_gpu': 'Wav2Vec2ForCTC',
                             'asr_uzbek_stt': 'Wav2Vec2ForCTC',
                             'asr_uzbek_stt_gpu': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_hindi_him_4200': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_hindi_him_4200_gpu': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_indian_english_enm_700': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_indian_english_enm_700_gpu': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_maithili_maim_50': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_maithili_maim_50_gpu': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_sanskrit_sam_60': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_sanskrit_sam_60_gpu': 'Wav2Vec2ForCTC',
                             'asr_vakyansh_wav2vec2_telugu_tem_100_gpu': 'Wav2Vec2ForCTC',
                             'asr_voxpopuli_base_2_5_gram_doc4lm': 'Wav2Vec2ForCTC',
                             'asr_voxpopuli_base_2_5_gram_doc4lm_gpu': 'Wav2Vec2ForCTC',
                             'asr_w2v2_ami': 'Wav2Vec2ForCTC',
                             'asr_w2v2_ami_gpu': 'Wav2Vec2ForCTC',
                             'asr_w2v2_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_25_1aug_2022': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_25_1aug_2022_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_10000': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_10000_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_13k_steps': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_13k_steps_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_by_facebook': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_by_facebook_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_by_vuiseng9': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_ngram': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_ngram_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_test': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_test_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_with_lm_by_patrickvonplaten': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_with_lm_by_patrickvonplaten_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_with_lm_by_saahith': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_with_lm_by_saahith_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_with_lm_turkish': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_100h_with_lm_turkish_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_10k_voxpopuli': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_10k_voxpopuli_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_20sec_timit_and_dementiabank': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_20sec_timit_and_dementiabank_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_960h_4_gram': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_960h_4_gram_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_960h_by_facebook': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_960h_by_facebook_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_checkpoint_10': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_checkpoint_14': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_checkpoint_6': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_checkpoint_6_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_checkpoint_9': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_checkpoint_9_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_common_voice_second_colab': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_common_voice_second_colab_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_cynthia_tedlium_2500_v2': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_cynthia_tedlium_2500_v2_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_demo_colab_by_thyagosme': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_demo_colab_by_thyagosme_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_finetuned_spgi_speech_dev': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_finetuned_spgi_speech_dev_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_german': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_german_cv9': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_german_cv9_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_german_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_latin': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_latin_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_nptel_demo_colab_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_nst': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_nst_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_rj_try_5': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_rj_try_5_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_3percent': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_3percent_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_5percent': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_swbd_turn_eos_long_short_utt_removed_5percent_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_test': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_test_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_ali_hasan_colab_ex2': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_ali_hasan_colab_ex2_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_asr': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_asr_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_by_patrickvonplaten': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_by_patrickvonplaten_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_cuzeverynameistaken': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_cuzeverynameistaken_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_hassnain': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_hassnain_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_sherry7144': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_sherry7144_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_tahazakir': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab0_by_tahazakir_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab10': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab10_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab11_by_sameearif88': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab1_by_cuzeverynameistaken': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab1_by_cuzeverynameistaken_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab1_by_sherry7144': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab1_by_sherry7144_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab1_by_tahazakir': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab1_by_tahazakir_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab240': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab2_by_ahmad573': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab2_by_ahmad573_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab2_by_hassnain': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab2_by_sameearif88': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab2_by_sherry7144': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab2_by_sherry7144_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab30': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab3_by_hassnain': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab3_by_hassnain_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab3_by_sherry7144': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab4': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab40': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab40_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab4_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab50': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab50_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab51': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab51_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab52': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab53_by_hassnain': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab53_by_hassnain_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab57': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab647': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab66': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab6_by_hassnain': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab6_by_hassnain_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab70': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab7_by_hassnain': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab7_by_hassnain_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab7_by_sameearif88': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab9': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab90': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab92': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab971': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab9_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_1_by_doddle124578': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_2': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_3': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_32_epochs30': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_32_epochs30_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_32_epochs50_earlystop': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_32_epochs50_earlystop_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_ali221000262': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_anan0329': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_anan0329_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_doddle124578': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_doddle124578_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_gullenasatish': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_gullenasatish_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_hady': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_hady_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_izzy_lazerson': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_izzy_lazerson_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_jessiejohnson': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_jessiejohnson_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_mohai': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_mohai_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_nadaalnada': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_nadaalnada_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_ntp0102': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_ntp0102_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_radhakri119': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_radhakri119_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_samantharhay': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_samantharhay_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_sarahliu186': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_terri1102': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_testimonial': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_testimonial_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_tingtingyuli': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_by_tingtingyuli_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_test': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_colab_test_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_google_colab_by_adelgalu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_google_colab_by_adelgalu_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_google_colab_by_patrickvonplaten': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_google_colab_by_patrickvonplaten_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_test_jong': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_demo_test_jong_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_moaiz_exp1': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_moaiz_exp2': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_moaiz_explast': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_timit_moaiz_explast_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_vietnamese_160h': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_vietnamese_160h_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_vietnamese_250h': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_vietnamese_250h_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_vietnamese_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_voxpopuli_v2_finetuned': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_base_voxpopuli_v2_finetuned_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_bilal_2022': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_bilal_2022_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_bilal_20epoch': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_bilal_20epoch_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_burak_v2.1': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_burak_v2.1_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_cetuc_sid_voxforge_mls_0': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_cetuc_sid_voxforge_mls_0_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_cetuc_sid_voxforge_mls_1': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_ab_demo': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_ab_demo_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_accents_3': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_accents_3_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_accents_indian': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_accents_indian_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_demo': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_demo_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_lithuanian': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_common_voice_lithuanian_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_coral_300ep': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_coral_300ep_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_ctc_earnings22_baseline_5_gram': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_ctc_earnings22_baseline_5_gram_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_dutch_large_cgn': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_dutch_large_cgn_3hrs': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_dutch_large_cgn_3hrs_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_dutch_large_cgn_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_from_scratch_finetune_dummy': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_from_scratch_finetune_dummy_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_indian_english': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_indian_english_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_indonesian_javanese_sundanese': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_indonesian_javanese_sundanese_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_japanese_hiragana_vtuber': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_japanese_hiragana_vtuber_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_ksponspeech': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_ksponspeech_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_100k_voxpopuli_catala_by_ccoreilly': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_100k_voxpopuli_catala_by_ccoreilly_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_100k_voxpopuli_catala_by_softcatala': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_100k_voxpopuli_catala_by_softcatala_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_100k_voxpopuli_tts_dataset_portuguese': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_100k_voxpopuli_tts_dataset_portuguese_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_10min_lv60_self': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_10min_lv60_self_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_self': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_self_4_gram': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_self_4_gram_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_self_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_self_with_wikipedia_lm': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_960h_lv60_self_with_wikipedia_lm_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_a': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_a_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_cgn_3hrs': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_cgn_3hrs_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_english': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_english_gpu': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_in_lm': 'Wav2Vec2ForCTC',
                             'asr_wav2vec2_large_in_lm_gpu': '