import argparse
import os
import sys

from setuptools import find_packages, setup


def long_description():
    here = os.path.abspath(os.path.dirname(__file__))
    with open(os.path.join(here, 'README.md'), 'r') as fh:
        return fh.read()


def get_version(name):
    version = {}
    with open('dagster_pandas/version.py') as fp:
        exec(fp.read(), version)  # pylint: disable=W0122

    if name == 'dagster-pandas':
        return version['__version__']
    elif name == 'dagster-pandas-nightly':
        return version['__nightly__']
    else:
        raise Exception('Shouldn\'t be here: bad package name {name}'.format(name=name))


parser = argparse.ArgumentParser()
parser.add_argument('--nightly', action='store_true')


def _do_setup(name='dagster-pandas'):
    setup(
        name=name,
        version=get_version(name),
        author='Elementl',
        author_email='hello@elementl.com',
        license='Apache-2.0',
        description=(
            'Utilities and examples for working with pandas and dagster, an opinionated '
            'framework for expressing data pipelines'
        ),
        long_description=long_description(),
        long_description_content_type='text/markdown',
        url='https://github.com/dagster-io/dagster',
        classifiers=[
            'Programming Language :: Python :: 2.7',
            'Programming Language :: Python :: 3.6',
            'Programming Language :: Python :: 3.7',
            'Programming Language :: Python :: 3.8',
            'License :: OSI Approved :: Apache Software License',
            'Operating System :: OS Independent',
        ],
        packages=find_packages(exclude=['dagster_pandas_tests']),
        include_package_data=True,
        install_requires=['dagster', 'pandas', 'matplotlib'],
    )


if __name__ == '__main__':
    parsed, unparsed = parser.parse_known_args()
    sys.argv = [sys.argv[0]] + unparsed
    if parsed.nightly:
        _do_setup('dagster-pandas-nightly')
    else:
        _do_setup('dagster-pandas')
