"""
    Contabo API


    The version of the OpenAPI document: 1.0.0
    Contact: support@contabo.com
    Generated by: https://openapi-generator.tech
"""


import re  # noqa: F401
import sys  # noqa: F401

from pfruck_contabo.model_utils import (  # noqa: F401
    ApiTypeError,
    ModelComposed,
    ModelNormal,
    ModelSimple,
    cached_property,
    change_keys_js_to_python,
    convert_js_args_to_python_args,
    date,
    datetime,
    file_type,
    none_type,
    validate_get_composed_info,
    OpenApiModel
)
from pfruck_contabo.exceptions import ApiAttributeError



class CreateInstanceRequest(ModelNormal):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.

    Attributes:
      allowed_values (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          with a capitalized key describing the allowed value and an allowed
          value. These dicts store the allowed enum values.
      attribute_map (dict): The key is attribute name
          and the value is json key in definition.
      discriminator_value_class_map (dict): A dict to go from the discriminator
          variable value to the discriminator class name.
      validations (dict): The key is the tuple path to the attribute
          and the for var_name this is (var_name,). The value is a dict
          that stores validations for max_length, min_length, max_items,
          min_items, exclusive_maximum, inclusive_maximum, exclusive_minimum,
          inclusive_minimum, and regex.
      additional_properties_type (tuple): A tuple of classes accepted
          as additional properties values.
    """

    allowed_values = {
        ('region',): {
            'EU': "EU",
            'US-CENTRAL': "US-central",
            'US-EAST': "US-east",
            'US-WEST': "US-west",
            'SIN': "SIN",
        },
        ('license',): {
            'PLESKHOST': "PleskHost",
            'PLESKPRO': "PleskPro",
            'PLESKADMIN': "PleskAdmin",
            'CPANEL5': "cPanel5",
            'CPANEL30': "cPanel30",
            'CPANEL50': "cPanel50",
            'CPANEL100': "cPanel100",
            'CPANEL150': "cPanel150",
            'CPANEL200': "cPanel200",
            'CPANEL250': "cPanel250",
            'CPANEL300': "cPanel300",
            'CPANEL350': "cPanel350",
            'CPANEL400': "cPanel400",
            'CPANEL450': "cPanel450",
            'CPANEL500': "cPanel500",
            'CPANEL550': "cPanel550",
            'CPANEL600': "cPanel600",
            'CPANEL650': "cPanel650",
            'CPANEL700': "cPanel700",
            'CPANEL750': "cPanel750",
            'CPANEL800': "cPanel800",
            'CPANEL850': "cPanel850",
            'CPANEL900': "cPanel900",
            'CPANEL950': "cPanel950",
            'CPANEL1000': "cPanel1000",
        },
    }

    validations = {
        ('product_id',): {
            'min_length': 1,
        },
        ('region',): {
            'min_length': 1,
        },
    }

    @cached_property
    def additional_properties_type():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded
        """
        return (bool, date, datetime, dict, float, int, list, str, none_type,)  # noqa: E501

    _nullable = False

    @cached_property
    def openapi_types():
        """
        This must be a method because a model may have properties that are
        of type self, this must run after the class is loaded

        Returns
            openapi_types (dict): The key is attribute name
                and the value is attribute type.
        """
        return {
            'image_id': (str,),  # noqa: E501
            'product_id': (str,),  # noqa: E501
            'region': (str,),  # noqa: E501
            'period': (int,),  # noqa: E501
            'ssh_keys': ([int],),  # noqa: E501
            'root_password': (int,),  # noqa: E501
            'user_data': (str,),  # noqa: E501
            'license': (str,),  # noqa: E501
        }

    @cached_property
    def discriminator():
        return None


    attribute_map = {
        'image_id': 'imageId',  # noqa: E501
        'product_id': 'productId',  # noqa: E501
        'region': 'region',  # noqa: E501
        'period': 'period',  # noqa: E501
        'ssh_keys': 'sshKeys',  # noqa: E501
        'root_password': 'rootPassword',  # noqa: E501
        'user_data': 'userData',  # noqa: E501
        'license': 'license',  # noqa: E501
    }

    read_only_vars = {
    }

    _composed_schemas = {}

    @classmethod
    @convert_js_args_to_python_args
    def _from_openapi_data(cls, *args, **kwargs):  # noqa: E501
        """CreateInstanceRequest - a model defined in OpenAPI

        Args:

        Keyword Args:
            image_id (str): ImageId to be used to setup the compute instance. Default is Ubuntu 20.04. defaults to "db1409d2-ed92-4f2f-978e-7b2fa4a1ec90"  # noqa: E501
            product_id (str): You can find `productId`s [here](https://contabo.com/en/product-list/?show_ids=true). Default is V1. defaults to "V1"  # noqa: E501
            region (str): Instance Region where the compute instance should be located. Default is EU. defaults to "EU", must be one of ["EU", "US-central", "US-east", "US-west", "SIN", ]  # noqa: E501
            period (int): Initial contract period in months. Available periods are: 1, 3, 6 and 12 months. Default to 1 month. defaults to 1  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            ssh_keys ([int]): Array of ids of public SSH Keys in order to access as admin user with root privileges (via sudo). Applies to Linux/BSD systems. Please refer to Secrets Management API.. [optional]  # noqa: E501
            root_password (int): Password id for admin user with administrator/root privileges. For Linux/BSD please use SSH, for Windows RDP. Please refer to Secrets Management API.. [optional]  # noqa: E501
            user_data (str): [Cloud-Init](https://cloud-init.io/) Config in order to customize during start of compute instance.. [optional]  # noqa: E501
            license (str): Additional licence in order to enhance your chosen product, mainly needed for software licenses on your product (not needed for windows).. [optional]  # noqa: E501
        """

        image_id = kwargs.get('image_id', "db1409d2-ed92-4f2f-978e-7b2fa4a1ec90")
        product_id = kwargs.get('product_id', "V1")
        region = kwargs.get('region', "EU")
        period = kwargs.get('period', 1)
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        self = super(OpenApiModel, cls).__new__(cls)

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.image_id = image_id
        self.product_id = product_id
        self.region = region
        self.period = period
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
        return self

    required_properties = set([
        '_data_store',
        '_check_type',
        '_spec_property_naming',
        '_path_to_item',
        '_configuration',
        '_visited_composed_classes',
    ])

    @convert_js_args_to_python_args
    def __init__(self, *args, **kwargs):  # noqa: E501
        """CreateInstanceRequest - a model defined in OpenAPI

        Args:

        Keyword Args:
            image_id (str): ImageId to be used to setup the compute instance. Default is Ubuntu 20.04. defaults to "db1409d2-ed92-4f2f-978e-7b2fa4a1ec90"  # noqa: E501
            product_id (str): You can find `productId`s [here](https://contabo.com/en/product-list/?show_ids=true). Default is V1. defaults to "V1"  # noqa: E501
            region (str): Instance Region where the compute instance should be located. Default is EU. defaults to "EU", must be one of ["EU", "US-central", "US-east", "US-west", "SIN", ]  # noqa: E501
            period (int): Initial contract period in months. Available periods are: 1, 3, 6 and 12 months. Default to 1 month. defaults to 1  # noqa: E501
            _check_type (bool): if True, values for parameters in openapi_types
                                will be type checked and a TypeError will be
                                raised if the wrong type is input.
                                Defaults to True
            _path_to_item (tuple/list): This is a list of keys or values to
                                drill down to the model in received_data
                                when deserializing a response
            _spec_property_naming (bool): True if the variable names in the input data
                                are serialized names, as specified in the OpenAPI document.
                                False if the variable names in the input data
                                are pythonic names, e.g. snake case (default)
            _configuration (Configuration): the instance to use when
                                deserializing a file_type parameter.
                                If passed, type conversion is attempted
                                If omitted no type conversion is done.
            _visited_composed_classes (tuple): This stores a tuple of
                                classes that we have traveled through so that
                                if we see that class again we will not use its
                                discriminator again.
                                When traveling through a discriminator, the
                                composed schema that is
                                is traveled through is added to this set.
                                For example if Animal has a discriminator
                                petType and we pass in "Dog", and the class Dog
                                allOf includes Animal, we move through Animal
                                once using the discriminator, and pick Dog.
                                Then in Dog, we will make an instance of the
                                Animal class but this time we won't travel
                                through its discriminator because we passed in
                                _visited_composed_classes = (Animal,)
            ssh_keys ([int]): Array of ids of public SSH Keys in order to access as admin user with root privileges (via sudo). Applies to Linux/BSD systems. Please refer to Secrets Management API.. [optional]  # noqa: E501
            root_password (int): Password id for admin user with administrator/root privileges. For Linux/BSD please use SSH, for Windows RDP. Please refer to Secrets Management API.. [optional]  # noqa: E501
            user_data (str): [Cloud-Init](https://cloud-init.io/) Config in order to customize during start of compute instance.. [optional]  # noqa: E501
            license (str): Additional licence in order to enhance your chosen product, mainly needed for software licenses on your product (not needed for windows).. [optional]  # noqa: E501
        """

        image_id = kwargs.get('image_id', "db1409d2-ed92-4f2f-978e-7b2fa4a1ec90")
        product_id = kwargs.get('product_id', "V1")
        region = kwargs.get('region', "EU")
        period = kwargs.get('period', 1)
        _check_type = kwargs.pop('_check_type', True)
        _spec_property_naming = kwargs.pop('_spec_property_naming', False)
        _path_to_item = kwargs.pop('_path_to_item', ())
        _configuration = kwargs.pop('_configuration', None)
        _visited_composed_classes = kwargs.pop('_visited_composed_classes', ())

        if args:
            for arg in args:
                if isinstance(arg, dict):
                    kwargs.update(arg)
                else:
                    raise ApiTypeError(
                        "Invalid positional arguments=%s passed to %s. Remove those invalid positional arguments." % (
                            args,
                            self.__class__.__name__,
                        ),
                        path_to_item=_path_to_item,
                        valid_classes=(self.__class__,),
                    )

        self._data_store = {}
        self._check_type = _check_type
        self._spec_property_naming = _spec_property_naming
        self._path_to_item = _path_to_item
        self._configuration = _configuration
        self._visited_composed_classes = _visited_composed_classes + (self.__class__,)

        self.image_id = image_id
        self.product_id = product_id
        self.region = region
        self.period = period
        for var_name, var_value in kwargs.items():
            if var_name not in self.attribute_map and \
                        self._configuration is not None and \
                        self._configuration.discard_unknown_keys and \
                        self.additional_properties_type is None:
                # discard variable.
                continue
            setattr(self, var_name, var_value)
            if var_name in self.read_only_vars:
                raise ApiAttributeError(f"`{var_name}` is a read-only attribute. Use `from_openapi_data` to instantiate "
                                     f"class with read only attributes.")
