__version__ = "1.1.0"
__author__ = "Adam Hopkins"
__credits__ = "Richard Kuesters"

import logging

from .authentication import Authentication
from .configuration import Configuration
from .decorators import protected, scoped
from .endpoints import BaseEndpoint
from .initialization import Initialize, initialize
from .responses import Responses

logging.getLogger(__name__).addHandler(logging.NullHandler())


__all__ = [
    "Authentication",
    "Initialize",
    "Configuration",
    "Responses",
    "BaseEndpoint",
    "initialize",
    "protected",
    "scoped",
]
